/// <reference path="./internals/internal_*.d.ts" />
declare class BlockPos extends Vec3i {
    constructor(arg0: Vec3i_)
    constructor(arg0: number, arg1: number, arg2: number)
    south(): this;
    mutable(): Internal.BlockPos$MutableBlockPos;
    above(): this;
    offset(arg0: Vec3i_): this;
    getY(): number;
    static offsetCodec(arg0: number): Internal.Codec<Vec3i>;
    static getY(arg0: number): number;
    static betweenClosed(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.Iterable<BlockPos>;
    toShortString(): string;
    static betweenClosedStream(arg0: BlockPos_, arg1: BlockPos_): Internal.Stream<BlockPos>;
    notify(): void;
    static "betweenClosedStream(net.minecraft.world.level.levelgen.structure.BoundingBox)"(arg0: Internal.BoundingBox_): Internal.Stream<BlockPos>;
    compareTo(arg0: any): number;
    east(arg0: number): Vec3i;
    multiply(arg0: number): this;
    relative(arg0: Internal.Direction_): Vec3i;
    static offset(arg0: number, arg1: number, arg2: number, arg3: number): number;
    asLong(): number;
    west(): this;
    static spiralAround(arg0: BlockPos_, arg1: number, arg2: Internal.Direction_, arg3: Internal.Direction_): Internal.Iterable<Internal.BlockPos$MutableBlockPos>;
    closerThan(arg0: Vec3i_, arg1: number): boolean;
    below(arg0: number): this;
    "compareTo(net.minecraft.core.Vec3i)"(arg0: Vec3i_): number;
    static betweenClosedStream(arg0: Internal.BoundingBox_): Internal.Stream<BlockPos>;
    relative(arg0: Internal.Direction$Axis_, arg1: number): Vec3i;
    static randomInCube(arg0: Internal.RandomSource_, arg1: number, arg2: BlockPos_, arg3: number): Internal.Iterable<BlockPos>;
    static breadthFirstTraversal(arg0: BlockPos_, arg1: number, arg2: number, arg3: Internal.BiConsumer_<BlockPos, Internal.Consumer<BlockPos>>, arg4: Internal.Predicate_<BlockPos>): number;
    static betweenClosed(arg0: BlockPos_, arg1: BlockPos_): Internal.Iterable<BlockPos>;
    distSqr(arg0: Vec3i_): number;
    "relative(net.minecraft.core.Direction,int)"(arg0: Internal.Direction_, arg1: number): this;
    static offset(arg0: number, arg1: Internal.Direction_): number;
    getCenter(): Vec3d;
    wait(): void;
    static containing(arg0: Internal.Position_): BlockPos;
    cross(arg0: Vec3i_): this;
    "compareTo(java.lang.Object)"(arg0: any): number;
    above(arg0: number): this;
    distToCenterSqr(arg0: number, arg1: number, arg2: number): number;
    getClass(): typeof any;
    distToCenterSqr(arg0: Internal.Position_): number;
    getX(): number;
    east(): this;
    below(): this;
    south(arg0: number): Vec3i;
    static getX(arg0: number): number;
    static getZ(arg0: number): number;
    static findClosestMatch(arg0: BlockPos_, arg1: number, arg2: number, arg3: Internal.Predicate_<BlockPos>): Optional<BlockPos>;
    atY(arg0: number): this;
    west(arg0: number): Vec3i;
    wait(arg0: number, arg1: number): void;
    distToLowCornerSqr(arg0: number, arg1: number, arg2: number): number;
    "relative(net.minecraft.core.Direction$Axis,int)"(arg0: Internal.Direction$Axis_, arg1: number): Vec3i;
    rotate(arg0: Internal.Rotation_): this;
    static "betweenClosedStream(net.minecraft.world.phys.AABB)"(arg0: Internal.AABB_): Internal.Stream<BlockPos>;
    relative(arg0: Internal.Direction_, arg1: number): this;
    static betweenClosedStream(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.Stream<BlockPos>;
    getZ(): number;
    north(): this;
    static randomBetweenClosed(arg0: Internal.RandomSource_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): Internal.Iterable<BlockPos>;
    offset(arg0: number, arg1: number, arg2: number): Vec3i;
    static withinManhattanStream(arg0: BlockPos_, arg1: number, arg2: number, arg3: number): Internal.Stream<BlockPos>;
    immutable(): this;
    toString(): string;
    north(arg0: number): Vec3i;
    static asLong(arg0: number, arg1: number, arg2: number): number;
    notifyAll(): void;
    distManhattan(arg0: Vec3i_): number;
    static getFlatIndex(arg0: number): number;
    static of(arg0: number): BlockPos;
    get(arg0: Internal.Direction$Axis_): number;
    static withinManhattan(arg0: BlockPos_, arg1: number, arg2: number, arg3: number): Internal.Iterable<BlockPos>;
    /**
     * @deprecated
    */
    static squareOutSouthEast(arg0: BlockPos_): Internal.Stream<BlockPos>;
    static containing(arg0: number, arg1: number, arg2: number): BlockPos;
    static betweenClosedStream(arg0: Internal.AABB_): Internal.Stream<BlockPos>;
    hashCode(): number;
    wait(arg0: number): void;
    compareTo(arg0: Vec3i_): number;
    subtract(arg0: Vec3i_): this;
    equals(arg0: any): boolean;
    closerToCenterThan(arg0: Internal.Position_, arg1: number): boolean;
    get y(): number
    get center(): Vec3d
    get class(): typeof any
    get x(): number
    get z(): number
    static readonly PACKED_Y_LENGTH: (12) & (number);
    static readonly CODEC: Internal.Codec<BlockPos>;
    static readonly ZERO: (BlockPos) & (BlockPos);
}
type BlockPos_ = Vec3d_ | [number, number, number] | BlockPos;
/**
 * Various block related helper functions
*/
declare class Block {
    constructor()
    getClass(): typeof any;
    toString(): string;
    notifyAll(): void;
    static id(id: ResourceLocation_): Internal.BlockIDPredicate;
    static entity(id: ResourceLocation_): Internal.BlockEntityPredicate;
    /**
     * Gets a blocks id from the Block
    */
    static getId(block: Internal.Block_): ResourceLocation;
    /**
     * Get a map of direction name to Direction. Functionally identical to Direction.ALL
    */
    static getFacing(): Internal.Map<string, Internal.Direction>;
    notify(): void;
    static id(id: ResourceLocation_, properties: Internal.Map_<string, any>): Internal.BlockIDPredicate;
    wait(arg0: number, arg1: number): void;
    /**
     * Gets a list of all blocks with tags
    */
    static getTaggedIds(tag: ResourceLocation_): Internal.List<ResourceLocation>;
    hashCode(): number;
    /**
     * Gets a Block from a block id
    */
    static getBlock(id: ResourceLocation_): Internal.Block;
    wait(): void;
    wait(arg0: number): void;
    static custom(predicate: Internal.BlockPredicate_): Internal.BlockPredicate;
    /**
     * Gets a list of the classname of all registered blocks
    */
    static getTypeList(): Internal.List<string>;
    equals(arg0: any): boolean;
    get class(): typeof any
    /**
     * Get a map of direction name to Direction. Functionally identical to Direction.ALL
    */
    get facing(): Internal.Map<string, Internal.Direction>
    /**
     * Gets a list of the classname of all registered blocks
    */
    get typeList(): Internal.List<string>
}
type Block_ = Block;
declare class Vec3d implements Internal.Position {
    constructor(arg0: number, arg1: number, arg2: number)
    constructor(arg0: Vec3f_)
    distanceToSqr(arg0: Vec3d_): number;
    lengthSqr(): number;
    notify(): void;
    yRot(arg0: number): this;
    z(): number;
    xRot(arg0: number): this;
    x(): number;
    align(arg0: Internal.EnumSet_<Internal.Direction$Axis>): this;
    closerThan(arg0: Internal.Position_, arg1: number): boolean;
    static atLowerCornerWithOffset(arg0: Vec3i_, arg1: number, arg2: number, arg3: number): Vec3d;
    subtract(arg0: Vec3d_): this;
    static upFromBottomCenterOf(arg0: Vec3i_, arg1: number): Vec3d;
    scale(arg0: number): this;
    reverse(): this;
    wait(): void;
    length(): number;
    distanceToSqr(arg0: number, arg1: number, arg2: number): number;
    subtract(arg0: number, arg1: number, arg2: number): this;
    zRot(arg0: number): this;
    horizontalDistance(): number;
    normalize(): this;
    get(arg0: Internal.Direction$Axis_): number;
    lerp(arg0: Vec3d_, arg1: number): this;
    getClass(): typeof any;
    relative(arg0: Internal.Direction_, arg1: number): this;
    add(arg0: number, arg1: number, arg2: number): this;
    static atCenterOf(arg0: Vec3i_): Vec3d;
    static directionFromRotation(arg0: Internal.Vec2_): Vec3d;
    cross(arg0: Vec3d_): this;
    add(arg0: Vec3d_): this;
    wait(arg0: number, arg1: number): void;
    "with"(arg0: Internal.Direction$Axis_, arg1: number): this;
    static atBottomCenterOf(arg0: Vec3i_): Vec3d;
    horizontalDistanceSqr(): number;
    dot(arg0: Vec3d_): number;
    multiply(arg0: number, arg1: number, arg2: number): this;
    y(): number;
    vectorTo(arg0: Vec3d_): this;
    offsetRandom(arg0: Internal.RandomSource_, arg1: number): this;
    toString(): string;
    static atLowerCornerOf(arg0: Vec3i_): Vec3d;
    notifyAll(): void;
    static fromRGB24(arg0: number): Vec3d;
    distanceTo(arg0: Vec3d_): number;
    multiply(arg0: Vec3d_): this;
    hashCode(): number;
    toVector3f(): Vec3f;
    wait(arg0: number): void;
    static directionFromRotation(arg0: number, arg1: number): Vec3d;
    equals(arg0: any): boolean;
    get class(): typeof any
    readonly z: number;
    static readonly ZERO: (Vec3d) & (Vec3d);
    static readonly CODEC: Internal.Codec<Vec3d>;
    readonly x: number;
    readonly y: number;
}
type Vec3d_ = [number, number, number] | Vec3d;
declare class RotationAxis extends Internal.Enum<RotationAxis> {
    deg(f: number): Quaternionf;
    static valueOf<T extends Internal.Enum<T>>(arg0: T, arg1: string): T;
    getClass(): typeof any;
    toString(): string;
    notifyAll(): void;
    static valueOf(name: string): RotationAxis;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    compareTo(arg0: any): number;
    name(): string;
    static values(): RotationAxis[];
    hashCode(): number;
    rad(f: number): Quaternionf;
    getDeclaringClass(): typeof RotationAxis;
    ordinal(): number;
    wait(): void;
    "compareTo(dev.latvian.mods.kubejs.util.RotationAxis)"(arg0: RotationAxis_): number;
    wait(arg0: number): void;
    compareTo(arg0: RotationAxis_): number;
    "compareTo(java.lang.Object)"(arg0: any): number;
    equals(arg0: any): boolean;
    describeConstable(): Optional<Internal.Enum$EnumDesc<RotationAxis>>;
    get class(): typeof any
    get declaringClass(): typeof RotationAxis
    static readonly XN: (RotationAxis) & (RotationAxis);
    static readonly ZP: (RotationAxis) & (RotationAxis);
    static readonly YN: (RotationAxis) & (RotationAxis);
    static readonly XP: (RotationAxis) & (RotationAxis);
    static readonly YP: (RotationAxis) & (RotationAxis);
    static readonly ZN: (RotationAxis) & (RotationAxis);
    readonly vec: Vec3f;
}
type RotationAxis_ = "yp" | "xp" | "yn" | "xn" | "zp" | RotationAxis | "zn";
declare class ResourceLocation implements Internal.ResourceLocationAccess, Internal.SpecialEquality, Internal.Comparable<ResourceLocation> {
    constructor(arg0: string, arg1: string)
    constructor(arg0: string)
    static isValidNamespace(arg0: string): boolean;
    getClass(): typeof any;
    compareTo(arg0: ResourceLocation_): number;
    toLanguageKey(arg0: string): string;
    static checkSpecialEquality(o: any, o1: any, shallow: boolean): boolean;
    static validNamespaceChar(arg0: string): boolean;
    static read(arg0: string): Internal.DataResult<ResourceLocation>;
    toShortLanguageKey(): string;
    static isValidPath(arg0: string): boolean;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    compareTo(arg0: any): number;
    setPath(arg0: string): void;
    static tryBuild(arg0: string, arg1: string): ResourceLocation;
    "withPath(java.lang.String)"(arg0: string): this;
    static isAllowedInResourceLocation(arg0: string): boolean;
    withPath(arg0: string): this;
    static tryParse(arg0: string): ResourceLocation;
    static validPathChar(arg0: string): boolean;
    toLanguageKey(arg0: string, arg1: string): string;
    toDebugFileName(): string;
    getPath(): string;
    getNamespace(): string;
    compareNamespaced(arg0: ResourceLocation_): number;
    static of(arg0: string, arg1: string): ResourceLocation;
    "compareTo(net.minecraft.resources.ResourceLocation)"(arg0: ResourceLocation_): number;
    toString(): string;
    withSuffix(arg0: string): this;
    notifyAll(): void;
    specialEquals(o: any, shallow: boolean): boolean;
    static read(arg0: Internal.StringReader_): ResourceLocation;
    toLanguageKey(): string;
    static isValidResourceLocation(arg0: string): boolean;
    "withPath(java.util.function.UnaryOperator)"(arg0: Internal.UnaryOperator_<string>): this;
    static "read(com.mojang.brigadier.StringReader)"(arg0: Internal.StringReader_): ResourceLocation;
    hashCode(): number;
    static "read(java.lang.String)"(arg0: string): Internal.DataResult<ResourceLocation>;
    setNamespace(arg0: string): void;
    wait(): void;
    withPath(arg0: Internal.UnaryOperator_<string>): this;
    wait(arg0: number): void;
    withPrefix(arg0: string): this;
    "compareTo(java.lang.Object)"(arg0: any): number;
    equals(arg0: any): boolean;
    get class(): typeof any
    set path(arg0: string)
    get path(): string
    get namespace(): string
    set namespace(arg0: string)
    static readonly REALMS_NAMESPACE: ("realms") & (string);
    static readonly CODEC: Internal.Codec<ResourceLocation>;
    static readonly NAMESPACE_SEPARATOR: (":") & (string);
    static readonly DEFAULT_NAMESPACE: ("minecraft") & (string);
}
type ResourceLocation_ = ResourceLocation | Special.CustomStat;
declare class MoreJS {
    constructor()
    getClass(): typeof any;
    toString(): string;
    notifyAll(): void;
    static weightedList(): Internal.WeightedList$Builder<any>;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    static ofTradeFilter(arg0: any): Internal.TradeFilter;
    static ofWeightedList(arg0: any): Internal.WeightedList<any>;
    static range(arg0: any): Internal.IntRange;
    static findStructure(arg0: BlockPos_, arg1: Internal.ServerLevel_, arg2: string, arg3: number): BlockPos;
    hashCode(): number;
    static findBiome(arg0: BlockPos_, arg1: Internal.ServerLevel_, arg2: string, arg3: number): BlockPos;
    wait(): void;
    static ofTradeItem(arg0: any): TradeItem;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    get class(): typeof any
}
type MoreJS_ = MoreJS;
declare class Optional <T> {
    getClass(): typeof any;
    ifPresent(arg0: Internal.Consumer_<T>): void;
    isEmpty(): boolean;
    flatMap<U>(arg0: Internal.Function_<T, Optional<U>>): Optional<U>;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    isPresent(): boolean;
    map<U>(arg0: Internal.Function_<T, U>): Optional<U>;
    orElseThrow<X extends Internal.Throwable>(arg0: Internal.Supplier_<X>): T;
    get(): T;
    static of<T>(arg0: T): Optional<T>;
    toString(): string;
    orElseThrow(): T;
    stream(): Internal.Stream<T>;
    notifyAll(): void;
    static empty<T>(): Optional<T>;
    orElseGet(arg0: Internal.Supplier_<T>): T;
    ifPresentOrElse(arg0: Internal.Consumer_<T>, arg1: Internal.Runnable_): void;
    filter(arg0: Internal.Predicate_<T>): this;
    static ofNullable<T>(arg0: T): Optional<T>;
    or(arg0: Internal.Supplier_<Optional<T>>): this;
    hashCode(): number;
    orElse(arg0: T): T;
    wait(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    get class(): typeof any
    get empty(): boolean
    get present(): boolean
}
type Optional_<T> = Optional<T>;
declare class VillagerUtils {
    constructor()
    static getVillagerTrades(arg0: Internal.VillagerProfession_, arg1: number): Internal.List<Internal.VillagerTrades$ItemListing>;
    getClass(): typeof any;
    static getWandererTrades(arg0: number): Internal.List<Internal.VillagerTrades$ItemListing>;
    static createStructureMapTrade(arg0: TradeItem_[], arg1: Internal.WeightedList_<any>): Internal.TreasureMapTrade;
    static createStewTrade(arg0: TradeItem_[], arg1: Internal.MobEffect_[], arg2: number): Internal.StewTrade;
    static getProfessions(): Internal.Collection<Internal.VillagerProfession>;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    static createCustomTrade(arg0: Internal.TransformableTrade$Transformer_): Internal.CustomTrade;
    static isModdedTrade(arg0: Internal.VillagerTrades$ItemListing_): boolean;
    static createBiomeMapTrade(arg0: TradeItem_[], arg1: Internal.WeightedList_<any>): Internal.TreasureMapTrade;
    static setAbstractTrades(arg0: Internal.Map_<number, Internal.VillagerTrades$ItemListing[]>, arg1: number, arg2: Internal.List_<Internal.VillagerTrades$ItemListing>): void;
    static getRandomVillagerTrade(arg0: Internal.VillagerProfession_, arg1: number): Internal.VillagerTrades$ItemListing;
    static getRandomWandererTrade(arg0: number): Internal.VillagerTrades$ItemListing;
    static isVanillaTrade(arg0: Internal.VillagerTrades$ItemListing_): boolean;
    static getVillagerTrades(arg0: Internal.VillagerProfession_): Internal.List<Internal.VillagerTrades$ItemListing>;
    static createEnchantedItemTrade(arg0: TradeItem_[], arg1: Internal.Item_): Internal.EnchantedItemTrade;
    toString(): string;
    notifyAll(): void;
    static createCustomMapTrade(arg0: TradeItem_[], arg1: Internal.MapPosInfo$Provider_): Internal.TreasureMapTrade;
    static createSimpleTrade(arg0: TradeItem_[], arg1: TradeItem_): Internal.SimpleTrade;
    hashCode(): number;
    static getProfession(arg0: ResourceLocation_): Internal.VillagerProfession;
    wait(): void;
    static getRandomVillagerTrade(arg0: Internal.VillagerProfession_): Internal.VillagerTrades$ItemListing;
    wait(arg0: number): void;
    static isMoreJSTrade(arg0: Internal.VillagerTrades$ItemListing_): boolean;
    static getAbstractTrades(arg0: Internal.Map_<number, Internal.VillagerTrades$ItemListing[]>, arg1: number): Internal.List<Internal.VillagerTrades$ItemListing>;
    equals(arg0: any): boolean;
    static createPotionTrade(arg0: TradeItem_[]): Internal.PotionTrade;
    get class(): typeof any
    get professions(): Internal.Collection<Internal.VillagerProfession>
    static readonly VANILLA_TRADE_TYPES: Internal.Set<typeof Internal.VillagerTrades$ItemListing>;
    static readonly CACHED_PROFESSION_TRADES: ({}) & (Internal.Map<Internal.VillagerProfession, Internal.List<Internal.VillagerTrades$ItemListing>>);
}
type VillagerUtils_ = VillagerUtils;
declare class Stats implements Internal.StatsAccessor {
    constructor()
    static botania_callRegisterCustom(arg0: string, arg1: Internal.StatFormatter_): ResourceLocation;
    getClass(): typeof any;
    hashCode(): number;
    toString(): string;
    static botania_callRegisterCustom_$md$837fa8$0(arg0: string, arg1: Internal.StatFormatter_): ResourceLocation;
    wait(): void;
    notifyAll(): void;
    wait(arg0: number): void;
    static makeCustomStat(arg0: string, arg1: Internal.StatFormatter_): ResourceLocation;
    equals(arg0: any): boolean;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    get class(): typeof any
    static readonly SWIM_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly FLY_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly CLEAN_SHULKER_BOX: (ResourceLocation) & (ResourceLocation);
    static readonly TOTAL_WORLD_TIME: (ResourceLocation) & (ResourceLocation);
    static readonly TUNE_NOTEBLOCK: (ResourceLocation) & (ResourceLocation);
    static readonly DAMAGE_RESISTED: (ResourceLocation) & (ResourceLocation);
    static readonly ITEM_DROPPED: Internal.StatType<Internal.Item>;
    static readonly PLAYER_KILLS: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_BREWINGSTAND: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_CAMPFIRE: (ResourceLocation) & (ResourceLocation);
    static readonly INSPECT_DISPENSER: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_FURNACE: (ResourceLocation) & (ResourceLocation);
    static readonly OPEN_ENDERCHEST: (ResourceLocation) & (ResourceLocation);
    static readonly ANIMALS_BRED: (ResourceLocation) & (ResourceLocation);
    static readonly POT_FLOWER: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_STONECUTTER: (ResourceLocation) & (ResourceLocation);
    static readonly ITEM_PICKED_UP: Internal.StatType<Internal.Item>;
    static readonly FALL_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly DAMAGE_ABSORBED: (ResourceLocation) & (ResourceLocation);
    static readonly FISH_CAUGHT: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_ANVIL: (ResourceLocation) & (ResourceLocation);
    static readonly BOAT_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly PLAY_RECORD: (ResourceLocation) & (ResourceLocation);
    static readonly DAMAGE_DEALT_RESISTED: (ResourceLocation) & (ResourceLocation);
    static readonly RAID_WIN: (ResourceLocation) & (ResourceLocation);
    static readonly DAMAGE_DEALT: (ResourceLocation) & (ResourceLocation);
    static readonly DEATHS: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_SMOKER: (ResourceLocation) & (ResourceLocation);
    static readonly ITEM_USED: Internal.StatType<Internal.Item>;
    static readonly BELL_RING: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_SMITHING_TABLE: (ResourceLocation) & (ResourceLocation);
    static readonly INSPECT_DROPPER: (ResourceLocation) & (ResourceLocation);
    static readonly DROP: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_LECTERN: (ResourceLocation) & (ResourceLocation);
    static readonly PLAY_TIME: (ResourceLocation) & (ResourceLocation);
    static readonly WALK_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly CLIMB_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly TRADED_WITH_VILLAGER: (ResourceLocation) & (ResourceLocation);
    static readonly RAID_TRIGGER: (ResourceLocation) & (ResourceLocation);
    static readonly STRIDER_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly ITEM_BROKEN: Internal.StatType<Internal.Item>;
    static readonly BLOCK_MINED: Internal.StatType<Internal.Block>;
    static readonly TIME_SINCE_REST: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_BEACON: (ResourceLocation) & (ResourceLocation);
    static readonly INSPECT_HOPPER: (ResourceLocation) & (ResourceLocation);
    static readonly PLAY_NOTEBLOCK: (ResourceLocation) & (ResourceLocation);
    static readonly CUSTOM: Internal.StatType<ResourceLocation>;
    static readonly CROUCH_TIME: (ResourceLocation) & (ResourceLocation);
    static readonly JUMP: (ResourceLocation) & (ResourceLocation);
    static readonly ENTITY_KILLED: Internal.StatType<Internal.EntityType<any>>;
    static readonly ENTITY_KILLED_BY: Internal.StatType<Internal.EntityType<any>>;
    static readonly INTERACT_WITH_CARTOGRAPHY_TABLE: (ResourceLocation) & (ResourceLocation);
    static readonly MOB_KILLS: (ResourceLocation) & (ResourceLocation);
    static readonly OPEN_CHEST: (ResourceLocation) & (ResourceLocation);
    static readonly SLEEP_IN_BED: (ResourceLocation) & (ResourceLocation);
    static readonly CLEAN_ARMOR: (ResourceLocation) & (ResourceLocation);
    static readonly CROUCH_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly TALKED_TO_VILLAGER: (ResourceLocation) & (ResourceLocation);
    static readonly DAMAGE_DEALT_ABSORBED: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_LOOM: (ResourceLocation) & (ResourceLocation);
    static readonly LEAVE_GAME: (ResourceLocation) & (ResourceLocation);
    static readonly HORSE_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly WALK_ON_WATER_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly MINECART_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly ENCHANT_ITEM: (ResourceLocation) & (ResourceLocation);
    static readonly TIME_SINCE_DEATH: (ResourceLocation) & (ResourceLocation);
    static readonly DAMAGE_TAKEN: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_BLAST_FURNACE: (ResourceLocation) & (ResourceLocation);
    static readonly TRIGGER_TRAPPED_CHEST: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_GRINDSTONE: (ResourceLocation) & (ResourceLocation);
    static readonly OPEN_BARREL: (ResourceLocation) & (ResourceLocation);
    static readonly SPRINT_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly DAMAGE_BLOCKED_BY_SHIELD: (ResourceLocation) & (ResourceLocation);
    static readonly EAT_CAKE_SLICE: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_CRAFTING_TABLE: (ResourceLocation) & (ResourceLocation);
    static readonly CLEAN_BANNER: (ResourceLocation) & (ResourceLocation);
    static readonly TARGET_HIT: (ResourceLocation) & (ResourceLocation);
    static readonly ITEM_CRAFTED: Internal.StatType<Internal.Item>;
    static readonly WALK_UNDER_WATER_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly PIG_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly OPEN_SHULKER_BOX: (ResourceLocation) & (ResourceLocation);
    static readonly USE_CAULDRON: (ResourceLocation) & (ResourceLocation);
    static readonly AVIATE_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly FILL_CAULDRON: (ResourceLocation) & (ResourceLocation);
}
type Stats_ = Stats;
declare class TradeItem {
    constructor(arg0: Internal.ItemStack_, arg1: Internal.IntRange_)
    getClass(): typeof any;
    toString(): string;
    notifyAll(): void;
    createItemStack(arg0: Internal.RandomSource_): Internal.ItemStack;
    static of(arg0: Internal.ItemStack_, arg1: number, arg2: number, arg3: Internal.CompoundTag_): TradeItem;
    isEmpty(): boolean;
    static of(arg0: Internal.ItemStack_, arg1: number, arg2: number): TradeItem;
    static "of(net.minecraft.world.item.ItemStack,int,net.minecraft.nbt.CompoundTag)"(arg0: Internal.ItemStack_, arg1: number, arg2: Internal.CompoundTag_): TradeItem;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    static of(arg0: Internal.ItemStack_, arg1: number): TradeItem;
    hashCode(): number;
    static of(arg0: Internal.ItemStack_): TradeItem;
    static of(arg0: Internal.ItemStack_, arg1: number, arg2: Internal.CompoundTag_): TradeItem;
    wait(): void;
    static "of(net.minecraft.world.item.ItemStack,int,int)"(arg0: Internal.ItemStack_, arg1: number, arg2: number): TradeItem;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    get class(): typeof any
    get empty(): boolean
    static readonly EMPTY: (TradeItem) & (TradeItem);
}
type TradeItem_ = TradeItem;
declare class Fluid {
    constructor()
    static of(o: Internal.FluidStackJS_): Internal.FluidStackJS;
    getClass(): typeof any;
    static getEmpty(): Internal.FluidStackJS;
    static getType(id: ResourceLocation_): Internal.Fluid;
    static of(o: Internal.FluidStackJS_, nbt: Internal.CompoundTag_): Internal.FluidStackJS;
    toString(): string;
    static of(o: Internal.FluidStackJS_, amount: number, nbt: Internal.CompoundTag_): Internal.FluidStackJS;
    static "of(dev.latvian.mods.kubejs.fluid.FluidStackJS,net.minecraft.nbt.CompoundTag)"(o: Internal.FluidStackJS_, nbt: Internal.CompoundTag_): Internal.FluidStackJS;
    notifyAll(): void;
    static of(o: Internal.FluidStackJS_, amount: number): Internal.FluidStackJS;
    static lava(amount: number): Internal.FluidStackJS;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    hashCode(): number;
    static lava(): Internal.FluidStackJS;
    static getTypes(): Internal.List<string>;
    static "of(dev.latvian.mods.kubejs.fluid.FluidStackJS,int)"(o: Internal.FluidStackJS_, amount: number): Internal.FluidStackJS;
    wait(): void;
    static getId(fluid: Internal.Fluid_): ResourceLocation;
    wait(arg0: number): void;
    static water(amount: number): Internal.FluidStackJS;
    static exists(id: ResourceLocation_): boolean;
    equals(arg0: any): boolean;
    static water(): Internal.FluidStackJS;
    get class(): typeof any
    get empty(): Internal.FluidStackJS
    get types(): Internal.List<string>
    static readonly LAVA_ID: (ResourceLocation) & (ResourceLocation);
    static readonly WATER_ID: (ResourceLocation) & (ResourceLocation);
}
type Fluid_ = Fluid;
declare class InputItem implements Internal.InputReplacement, Internal.IngredientSupplierKJS, Internal.JsonSerializable {
    replaceInput(recipe: Internal.RecipeJS_, match: Internal.ReplacementMatch_, original: Internal.InputReplacement_): any;
    getClass(): typeof any;
    toString(): string;
    notifyAll(): void;
    isEmpty(): boolean;
    notify(): void;
    toJson(): Internal.JsonElement;
    withCount(count: number): this;
    wait(arg0: number, arg1: number): void;
    static of(o: any): InputItem;
    static of(ingredient: Internal.Ingredient_, count: number): InputItem;
    toJson(alwaysNest: boolean): Internal.JsonElement;
    validForMatching(): boolean;
    hashCode(): number;
    unwrap(): Internal.List<InputItem>;
    wait(): void;
    wait(arg0: number): void;
    transform(transformer: Internal.InputReplacementTransformer_): Internal.InputReplacementTransformer$Replacement;
    equals(arg0: any): boolean;
    kjs$asIngredient(): Internal.Ingredient;
    get class(): typeof any
    get empty(): boolean
    readonly ingredient: Internal.Ingredient;
    readonly count: number;
    static readonly EMPTY: (InputItem) & (InputItem);
    static readonly PARSE_CACHE: ({"moa_decor_toys:guardian": InputItem, "moa_decor_bath:llavesdebanera": InputItem, "biomesoplenty:hellbark_leaves": InputItem, "aquaculture:pink_salmon": InputItem, "handcrafted:fox_trophy": InputItem, "biomesoplenty:redwood_log": InputItem, "createaddition:zinc_sheet": InputItem, "moa_decor_art:guitarraelectricamagenta": InputItem, "quark:shale": InputItem, "handcrafted:bear_trophy": InputItem, "botania:blue_mystical_flower": InputItem, "moa_decor_toys:cubodemagma": InputItem, "moa_decor_art:tecladomusical": InputItem, "#forge:corundum_clusters": InputItem, "aquaculture:muskellunge": InputItem, "bloomingnature:freesia_pink": InputItem, "luphieclutteredmod:luphie_card_index": InputItem, "moa_decor_holidays:catrinamorada": InputItem, "minecraft:pink_wool": InputItem, "#forge:furniture_warped_log": InputItem, "moa_decor_toys:esqueleto": InputItem, "playdate:teddy_bear": InputItem, "luphieclutteredmod:luphie_lunar_observatory_table": InputItem, "biomesoplenty:fir_leaves": InputItem, "#candlelight:wheat": InputItem, "biomesoplenty:lavender": InputItem, "biomesoplenty:wildflower": InputItem, "gemsnjewels:zircon": InputItem, "moa_decor_toys:saqueador": InputItem, "moa_decor_toys:vaca": InputItem, "bloomingnature:stripped_ebony_log": InputItem, "moa_decor_toys:gatoblanco": InputItem, "moa_decor_toys:conejocastano": InputItem, "biomesoplenty:orange_autumn_leaves": InputItem, "gemsnjewels:black_opal": InputItem, "create:scorchia": InputItem, "#forge:milk": InputItem, "biomesoplenty:snowblossom_leaves": InputItem, "moa_decor_bath:tendederoconropamasculina": InputItem, "luphieclutteredmod:luphie_lunar_observatory_books": InputItem, "bloomingnature:wild_sunflower": InputItem, "bloomingnature:stripped_baobab_log": InputItem, "moa_decor_bath:destapador": InputItem, "moa_decor_toys:osopolar": InputItem, "biomesoplenty:umbran_leaves": InputItem, "biomesoplenty:cattail": InputItem, "moa_decor_holidays:murcielagoabierto": InputItem, "#minecraft:planks": InputItem, "biomesoplenty:brimstone": InputItem, "moa_decor_bath:lavaboconpedestal": InputItem, "moa_decor_toys:lavagante": InputItem, "moa_decor_toys:allay": InputItem, "minecraft:gray_terracotta": InputItem, "meadow:inky_wool": InputItem, "biomesoplenty:rainbow_birch_leaves": InputItem, "biomesoplenty:redwood_leaves": InputItem, "#forge:furniture_jungle_planks": InputItem, "minecraft:red_sandstone": InputItem, "moa_decor_art:arpa": InputItem, "minecraft:dark_oak_leaves": InputItem, "#forge:furniture_birch_log": InputItem, "moa_decor_toys:lobo": InputItem, "biomesoplenty:palm_log": InputItem, "aquaculture:pacific_halibut": InputItem, "meadow:eriophorum_tall": InputItem, "moa_decor_toys:zorro": InputItem, "minecraft:mangrove_leaves": InputItem, "bloomingnature:chestnut_log": InputItem, "#forge:furniture_dead_log": InputItem, "minecraft:magma_block": InputItem, "moa_decor_science:barrilinflamablederramado": InputItem, "moa_decor_holidays:p_galleta_jengibre": InputItem, "bloomingnature:swamp_cypress_leaves": InputItem, "gemsnjewels:aquamarine": InputItem, "minecraft:terracotta": InputItem, "moa_decor_holidays:tumbaesqueletosentado": InputItem, "handcrafted:pufferfish_trophy": InputItem, "moa_decor_art:maniqui": InputItem, "moa_decor_toys:aldeanoinvierno": InputItem, "moa_decor_holidays:mariachiguitarra": InputItem, "#forge:furniture_fir_log": InputItem, "minecraft:dirt": InputItem, "luphieclutteredmod:rubiks_cube": InputItem, "moa_decor_science:lupa": InputItem, "#forge:furniture_bamboo_log": InputItem, "moa_decor_toys:ovejagrisclara": InputItem, "moa_decor_bath:tabladeplanchar": InputItem, "minecraft:pink_concrete_powder": InputItem, "meadow:limestone": InputItem, "moa_decor_toys:gallina": InputItem, "biomesoplenty:white_petals": InputItem, "bloomingnature:lupine_blue": InputItem, "minecraft:black_terracotta": InputItem, "minecraft:spruce_leaves": InputItem, "moa_decor_holidays:catrinacian": InputItem, "minecraft:end_stone": InputItem, "moa_decor_toys:ovejamorada": InputItem, "gemsnjewels:topaz": InputItem, "minecraft:jungle_log": InputItem, "minecraft:yellow_terracotta": InputItem, "gemsnjewels:alexandrite": InputItem, "create:asurine": InputItem, "moa_decor_art:tamborrojo": InputItem, "luphieclutteredmod:luphie_pastel_block_bookshelf": InputItem, "bloomingnature:tall_mountain_laurel": InputItem, "bloomingnature:tall_lupine_purple": InputItem, "#forge:furniture_jacaranda_log": InputItem, "biomesoplenty:orange_cosmos": InputItem, "luphieclutteredmod:blue_sand_seal_plush": InputItem, "moa_decor_toys:caballocastano_h": InputItem, "playdate:toy_clock": InputItem, "moa_decor_toys:caballocafe_r": InputItem, "minecraft:oak_log": InputItem, "aquaculture:tambaqui": InputItem, "moa_decor_toys:caballocastano_c": InputItem, "moa_decor_science:frascodepildoras": InputItem, "moa_decor_toys:caballocastano": InputItem, "moa_decor_toys:caballocafe_m": InputItem, "moa_decor_holidays:conejo_chocolate": InputItem, "moa_decor_toys:caballocastano_r": InputItem, "minecraft:calcite": InputItem, "moa_decor_toys:caballocastano_m": InputItem, "luphieclutteredmod:luphie_sewing_clutter": InputItem, "#forge:furniture_mangrove_planks": InputItem, "moa_decor_holidays:bruja_escoba": InputItem, "biomesoplenty:orange_sand": InputItem, "moa_decor_toys:caballocafe_h": InputItem, "create:veridium": InputItem, "aquaculture:brown_shrooma": InputItem, "moa_decor_toys:caballocafe_c": InputItem, "meadow:rocky_wool": InputItem, "luphieclutteredmod:luphie_analog_kitchen_scale": InputItem, "kubejs:64k_storage_disk_ticket": InputItem, "bloomingnature:stripped_fir_log": InputItem, "bloomingnature:palm_log": InputItem, "moa_decor_toys:vendedorambulante": InputItem, "minecraft:acacia_log": InputItem, "bloomingnature:mountain_snowbell": InputItem, "minecraft:sugar": InputItem, "meadow:alpine_poppy": InputItem, "minecraft:prismarine": InputItem, "moa_decor_toys:ranatemplada": InputItem, "luphieclutteredmod:luphie_rovers_mug": InputItem, "moa_decor_art:tamborazul": InputItem, "bloomingnature:orange_leaves": InputItem, "moa_decor_art:acuarelas": InputItem, "bloomingnature:cattail": InputItem, "#forge:furniture_spruce_log": InputItem, "minecraft:gravel": InputItem, "minecraft:light_gray_concrete_powder": InputItem, "bloomingnature:stripped_swamp_cypress_log": InputItem, "bloomingnature:hyssop": InputItem, "#forge:furniture_acacia_log": InputItem, "handcrafted:skeleton_horse_trophy": InputItem, "moa_decor_bath:mingitorio": InputItem, "moa_decor_holidays:leprechaunolladeoro": InputItem, "minecraft:orange_terracotta": InputItem, "luphieclutteredmod:luphie_gothic_rose_endtable": InputItem, "minecraft:black_concrete": InputItem, "moa_decor_toys:zoglin": InputItem, "luphieclutteredmod:luphie_drying_herb_garland": InputItem, "luphieclutteredmod:luphie_polaroid_garland_b": InputItem, "luphieclutteredmod:luphie_polaroid_garland_a": InputItem, "minecraft:black_wool": InputItem, "biomesoplenty:tall_lavender": InputItem, "minecraft:flowering_azalea_leaves": InputItem, "moa_decor_art:guitarra": InputItem, "meadow:eriophorum": InputItem, "minecraft:dark_oak_log": InputItem, "moa_decor_art:tocadiscos": InputItem, "luphieclutteredmod:luphie_mushroom_chest": InputItem, "moa_decor_toys:gatopersa": InputItem, "meadow:pine_log": InputItem, "luphieclutteredmod:purple_bicycle": InputItem, "bloomingnature:reed": InputItem, "luphieclutteredmod:luphie_bee_lamp": InputItem, "vinery:cherry_leaves": InputItem, "luphieclutteredmod:luphie_green_gumball_machine": InputItem, "luphieclutteredmod:luphie_heart_armchair": InputItem, "moa_decor_art:tamborrosa": InputItem, "minecraft:green_terracotta": InputItem, "minecraft:magenta_concrete_powder": InputItem, "biomesoplenty:umbran_log": InputItem, "moa_decor_holidays:p_galleta_jengibre_n": InputItem, "minecraft:acacia_leaves": InputItem, "#forge:furniture_willow_log": InputItem, "#forge:water": InputItem, "luphieclutteredmod:luphie_cauldron_poster": InputItem, "meadow:saxifrage": InputItem, "botania:brown_mystical_flower": InputItem, "minecraft:shroomlight": InputItem, "moa_decor_toys:enderman": InputItem, "quark:orange_blossom_leaves": InputItem, "bloomingnature:larch_leaves": InputItem, "luphieclutteredmod:cute_blue_bicycle": InputItem, "luphieclutteredmod:green_sand_seal_plush": InputItem, "minecraft:sandstone": InputItem, "moa_decor_bath:llavesderegadera": InputItem, "biomesoplenty:willow_leaves": InputItem, "luphieclutteredmod:luphie_heart_garland": InputItem, "luphieclutteredmod:luphie_polaroid_camera": InputItem, "moa_decor_art:silladedirector": InputItem, "luphieclutteredmod:luphie_sunflower_garland": InputItem, "luphieclutteredmod:luphie_wedding_arch": InputItem, "playdate:rocking_horse": InputItem, "minecraft:lime_concrete_powder": InputItem, "moa_decor_toys:cerdo": InputItem, "moa_decor_toys:steve": InputItem, "quark:permafrost": InputItem, "moa_decor_toys:gatoatigrado": InputItem, "moa_decor_bath:esco": InputItem, "bloomingnature:stripped_aspen_log": InputItem, "moa_decor_holidays:catrinaroja": InputItem, "luphieclutteredmod:luphie_blue_record_player": InputItem, "bloomingnature:white_orchid": InputItem, "minecraft:lily_of_the_valley": InputItem, "moa_decor_toys:burro": InputItem, "handcrafted:goat_trophy": InputItem, "minecraft:tropical_fish": InputItem, "bloomingnature:bottlebrushes": InputItem, "biomesoplenty:rose": InputItem, "minecraft:brown_terracotta": InputItem, "luphieclutteredmod:luphie_potion_shelf": InputItem, "luphieclutteredmod:plant_ladder": InputItem, "#forge:furniture_oak_planks": InputItem, "luphieclutteredmod:yellow_flower_shelf": InputItem, "biomesoplenty:yellow_autumn_leaves": InputItem, "luphieclutteredmod:cute_pink_bicycle": InputItem, "bloomingnature:fir_leaves": InputItem, "aquaculture:atlantic_herring": InputItem, "bloomingnature:goatsbeard": InputItem, "bloomingnature:bluebell": InputItem, "moa_decor_toys:lorogris": InputItem, "luphieclutteredmod:green_flower_shelf": InputItem, "handcrafted:spider_trophy": InputItem, "moa_decor_toys:piglinzombie": InputItem, "minecraft:warped_wart_block": InputItem, "luphieclutteredmod:luphie_pastel_wardrobe": InputItem, "moa_decor_holidays:zombieenterrado": InputItem, "minecraft:moss_block": InputItem, "moa_decor_toys:aldeanopantano": InputItem, "minecraft:light_gray_wool": InputItem, "biomesoplenty:jacaranda_log": InputItem, "moa_decor_art:reflector": InputItem, "aquaculture:bluegill": InputItem, "luphieclutteredmod:red_sand_seal_plush": InputItem, "luphieclutteredmod:rito_village_books": InputItem, "moa_decor_toys:ajoloteazul": InputItem, "minecraft:sand": InputItem, "playdate:toy_boat": InputItem, "moa_decor_toys:llamablanca": InputItem, "moa_decor_art:maquinadecoser": InputItem, "quark:jasper": InputItem, "minecraft:cyan_wool": InputItem, "moa_decor_toys:caballocafeosc_h": InputItem, "moa_decor_science:libros": InputItem, "moa_decor_toys:ovejacian": InputItem, "moa_decor_toys:caballocafeosc_r": InputItem, "minecraft:cyan_terracotta": InputItem, "quark:red_blossom_leaves": InputItem, "minecraft:pink_terracotta": InputItem, "moa_decor_art:tamborcafe": InputItem, "moa_decor_art:tambormorado": InputItem, "moa_decor_toys:alex": InputItem, "#forge:furniture_mahogany_log": InputItem, "moa_decor_toys:caballoblanco_h": InputItem, "minecraft:magenta_concrete": InputItem, "gemsnjewels:citrine": InputItem, "luphieclutteredmod:blue_bicycle": InputItem, "moa_decor_holidays:zombieacostado": InputItem, "luphieclutteredmod:pastel_yellow_flowershelf": InputItem, "meadow:pine_leaves": InputItem, "moa_decor_toys:conejoblancoynegro": InputItem, "bloomingnature:beach_bush": InputItem, "aquaculture:jellyfish": InputItem, "#forge:furniture_spruce_planks": InputItem, "moa_decor_toys:aldeanosabana": InputItem, "biomesoplenty:bramble_leaves": InputItem, "luphieclutteredmod:luphie_yellow_record_player": InputItem, "moa_decor_toys:caballocafeosc_c": InputItem, "alexsmobs:blobfish": InputItem, "minecraft:red_concrete_powder": InputItem, "minecraft:warped_stem": InputItem, "moa_decor_toys:llamacafe": InputItem, "minecraft:green_concrete": InputItem, "minecraft:red_tulip": InputItem, "minecraft:white_concrete_powder": InputItem, "moa_decor_art:paletadepintura": InputItem, "luphieclutteredmod:luphie_retro_green_fridge": InputItem, "luphieclutteredmod:luphiebunny_plushie": InputItem, "minecraft:birch_log": InputItem, "aquaculture:blackfish": InputItem, "minecraft:cherry_log": InputItem, "minecraft:azure_bluet": InputItem, "moa_decor_art:tijeras": InputItem, "moa_decor_art:tambornaranja": InputItem, "moa_decor_toys:fantasma": InputItem, "luphieclutteredmod:luphie_sewing_table_clutter": InputItem, "minecraft:purple_wool": InputItem, "moa_decor_holidays:tumbaesqueleto": InputItem, "luphieclutteredmod:luphie_lunar_observatory_basket_of_papers": InputItem, "luphieclutteredmod:luphie_lunar_observatory_jars": InputItem, "aquaculture:carp": InputItem, "moa_decor_art:banyo": InputItem, "minecraft:melon": InputItem, "minecraft:diorite": InputItem, "moa_decor_art:camaradecine": InputItem, "quark:limestone": InputItem, "moa_decor_toys:gatobritanico": InputItem, "candlelight:rose": InputItem, "moa_decor_toys:lavaganteypiglinzombie": InputItem, "luphieclutteredmod:luphie_honeycomb_lamp": InputItem, "#forge:furniture_crimson_planks": InputItem, "luphieclutteredmod:luphie_nightstand": InputItem, "aquaculture:boulti": InputItem, "biomesoplenty:fir_log": InputItem, "#forge:furniture_jungle_log": InputItem, "#forge:furniture_hellbark_log": InputItem, "moa_decor_toys:golemdenieve": InputItem, "gemsnjewels:pale_diamond": InputItem, "bloomingnature:foxglove_white": InputItem, "botania:orange_mystical_flower": InputItem, "moa_decor_holidays:jaula": InputItem, "moa_decor_toys:gatocalico": InputItem, "alexsmobs:flying_fish": InputItem, "moa_decor_art:guitarraelectricaazulclara": InputItem, "luphieclutteredmod:cluttered_tarrey_town_wood_stove": InputItem, "bloomingnature:stripped_larch_log": InputItem, "luphieclutteredmod:purple_cabinet": InputItem, "aquaculture:synodontis": InputItem, "moa_decor_holidays:c_pdorado": InputItem, "minecraft:lilac": InputItem, "moa_decor_toys:conejonegro": InputItem, "moa_decor_toys:esqueletoglacial": InputItem, "luphieclutteredmod:luphie_apple_chair": InputItem, "luphieclutteredmod:luphie_art_academy_box_of_paint": InputItem, "luphieclutteredmod:luphie_office_box": InputItem, "botania:lime_mystical_flower": InputItem, "luphieclutteredmod:red_birdhouse": InputItem, "biomesoplenty:white_sandstone": InputItem, "moa_decor_toys:arana": InputItem, "luphieclutteredmod:luphie_imperial_table": InputItem, "luphieclutteredmod:luphie_purple_gumball_machine": InputItem, "moa_decor_toys:ajolotecafe": InputItem, "#forge:furniture_mangrove_log": InputItem, "moa_decor_holidays:duende_navideno": InputItem, "moa_decor_toys:shulker": InputItem, "moa_decor_art:tambornegro": InputItem, "aquaculture:catfish": InputItem, "minecraft:purple_terracotta": InputItem, "moa_decor_toys:zombiemomificado": InputItem, "moa_decor_science:telescopio": InputItem, "minecraft:light_blue_concrete": InputItem, "biomesoplenty:magic_leaves": InputItem, "biomesoplenty:goldenrod": InputItem, "moa_decor_toys:panda": InputItem, "moa_decor_art:guitarraelectricacian": InputItem, "moa_decor_toys:caballonegro_c": InputItem, "moa_decor_toys:caballonegro_h": InputItem, "aquaculture:atlantic_halibut": InputItem, "minecraft:soul_soil": InputItem, "moa_decor_toys:caballonegro_r": InputItem, "biomesoplenty:black_sandstone": InputItem, "biomesoplenty:black_sand": InputItem, "moa_decor_bath:cubetadeagua": InputItem, "moa_decor_toys:llamagris": InputItem, "moa_decor_toys:tortugamarina": InputItem, "moa_decor_holidays:duende_navidena": InputItem, "moa_decor_toys:caballocafeosc_m_1": InputItem, "moa_decor_toys:caballonegro_m": InputItem, "minecraft:cod": InputItem, "aquaculture:red_grouper": InputItem, "botania:magenta_mystical_flower": InputItem, "vinery:apple_leaves": InputItem, "moa_decor_toys:guardiananciano": InputItem, "luphieclutteredmod:luphie_pastel_table": InputItem, "moa_decor_bath:regadera": InputItem, "#forge:egg": InputItem, "moa_decor_art:violin": InputItem, "#forge:furniture_warped_planks": InputItem, "luphieclutteredmod:luphie_polaroids_c": InputItem, "luphieclutteredmod:luphie_polaroids_b": InputItem, "luphieclutteredmod:luphie_polaroids_a": InputItem, "moa_decor_toys:ranahelada": InputItem, "aquaculture:rainbow_trout": InputItem, "minecraft:white_tulip": InputItem, "moa_decor_toys:ovejaroja": InputItem, "#bakery:wheat": InputItem, "minecraft:purple_concrete": InputItem, "herbalbrews:hibiscus": InputItem, "minecraft:black_concrete_powder": InputItem, "minecraft:salmon": InputItem, "biomesoplenty:dead_leaves": InputItem, "moa_decor_toys:ajoloterosa": InputItem, "minecraft:book": InputItem, "bloomingnature:genisteae": InputItem, "quark:myalite_crystal": InputItem, "moa_decor_holidays:p_oso_polar_n": InputItem, "bloomingnature:beach_grass": InputItem, "moa_decor_bath:jaboneradepared": InputItem, "minecraft:light_blue_wool": InputItem, "create:limestone": InputItem, "moa_decor_science:barriltoxico": InputItem, "meadow:alpine_birch_leaves_hanging": InputItem, "botania:light_gray_mystical_flower": InputItem, "minecraft:pink_concrete": InputItem, "gemsnjewels:dusk_emerald": InputItem, "moa_decor_art:tamborgris": InputItem, "aquaculture:piranha": InputItem, "gemsnjewels:peridot": InputItem, "luphieclutteredmod:blue_birdhouse": InputItem, "quark:blossom_log": InputItem, "gemsnjewels:jade": InputItem, "moa_decor_toys:caballoblanco": InputItem, "moa_decor_toys:creeper": InputItem, "kubejs:1k_storage_disk_ticket": InputItem, "moa_decor_toys:aldeanodesierto": InputItem, "moa_decor_toys:aldeanotaiga": InputItem, "luphieclutteredmod:pink_flower_shelf": InputItem, "botania:pink_mystical_flower": InputItem, "meadow:delphinium": InputItem, "moa_decor_toys:blaze": InputItem, "botania:yellow_mystical_flower": InputItem, "minecraft:cobblestone": InputItem, "minecraft:jungle_leaves": InputItem, "moa_decor_art:guitarraelectricanegra": InputItem, "moa_decor_bath:trap": InputItem, "luphieclutteredmod:luphie_salt_and_pepper_shakers": InputItem, "minecraft:light_blue_terracotta": InputItem, "minecraft:gray_concrete": InputItem, "aquaculture:arrau_turtle": InputItem, "luphieclutteredmod:luphie_vial_stand": InputItem, "meadow:flecked_wool": InputItem, "vinery:cherry_log": InputItem, "moa_decor_toys:calamarbrillante": InputItem, "luphieclutteredmod:luphie_retro_cafe_shelf": InputItem, "moa_decor_science:libroytintero": InputItem, "bloomingnature:joe_pye": InputItem, "moa_decor_toys:caballonegro": InputItem, "luphieclutteredmod:pastel_rubiks_cube": InputItem, "moa_decor_bath:banera": InputItem, "handcrafted:salmon_trophy": InputItem, "moa_decor_holidays:lapida_cruz": InputItem, "moa_decor_science:lectordesignosvitales": InputItem, "moa_decor_toys:ovejanegra": InputItem, "gemsnjewels:sapphire": InputItem, "minecraft:obsidian": InputItem, "#forge:furniture_dark_oak_log": InputItem, "minecraft:purple_concrete_powder": InputItem, "luphieclutteredmod:luphie_retro_cafe_shelf_stained_glass": InputItem, "biomesoplenty:glowflower": InputItem, "moa_decor_art:guitarraelectricablanca": InputItem, "moa_decor_toys:caballoesqueletoyesqueleto": InputItem, "handcrafted:silverfish_trophy": InputItem, "moa_decor_science:globoterraqueo": InputItem, "botania:black_mystical_flower": InputItem, "luphieclutteredmod:cute_purple_bicycle": InputItem, "moa_decor_toys:calamar": InputItem, "moa_decor_art:tambormagenta": InputItem, "candlelight:mushroom_soup": InputItem, "bloomingnature:foxglove_pink": InputItem, "gemsnjewels:tanzanite": InputItem, "minecraft:clay": InputItem, "meadow:umbra_wool": InputItem, "gemsnjewels:morganite": InputItem, "moa_decor_art:tamborgrisclaro": InputItem, "minecraft:gray_concrete_powder": InputItem, "minecraft:yellow_wool": InputItem, "moa_decor_toys:bruja": InputItem, "biomesoplenty:wilted_lily": InputItem, "moa_decor_toys:ovejarosa": InputItem, "moa_decor_toys:ovejaazulclara": InputItem, "playdate:piggy_bank": InputItem, "minecraft:brown_concrete_powder": InputItem, "minecraft:red_sand": InputItem, "minecraft:pearlescent_froglight": InputItem, "bloomingnature:beach_bush_tall": InputItem, "biomesoplenty:white_sand": InputItem, "moa_decor_art:rollodepelicula": InputItem, "moa_decor_toys:ovejablanca": InputItem, "luphieclutteredmod:luphie_brown_record_player": InputItem, "botania:purple_mystical_flower": InputItem, "vinery:cherry_planks": InputItem, "minecraft:ochre_froglight": InputItem, "minecraft:sunflower": InputItem, "moa_decor_science:brujula": InputItem, "bloomingnature:swamp_oak_log": InputItem, "biomesoplenty:violet": InputItem, "playdate:dino": InputItem, "moa_decor_art:tamborverde": InputItem, "aquaculture:bayad": InputItem, "moa_decor_toys:gatosiames": InputItem, "moa_decor_bath:vasocepillosdedientes": InputItem, "minecraft:stone": InputItem, "minecraft:poppy": InputItem, "bloomingnature:lupine_purple": InputItem, "moa_decor_art:guitarraelectricaverdelima": InputItem, "moa_decor_art:mezcladordj": InputItem, "moa_decor_science:calculadora": InputItem, "moa_decor_holidays:c_pnegro": InputItem, "luphieclutteredmod:luphie_safe": InputItem, "moa_decor_holidays:esqueletosentado": InputItem, "moa_decor_toys:vindicador": InputItem, "luphieclutteredmod:luphie_rovers_stool": InputItem, "biomesoplenty:mahogany_leaves": InputItem, "farmersdelight:cabbage_rolls": InputItem, "luphieclutteredmod:blue_flower_shelf": InputItem, "minecraft:dark_prismarine": InputItem, "vinery:apple_log": InputItem, "quark:azalea_log": InputItem, "minecraft:white_terracotta": InputItem, "kubejs:16k_storage_disk_ticket": InputItem, "aquaculture:perch": InputItem, "moa_decor_science:microscopio": InputItem, "luphieclutteredmod:luphie_small_cauldron_set": InputItem, "minecraft:peony": InputItem, "minecraft:sea_lantern": InputItem, "meadow:enzian": InputItem, "minecraft:white_wool": InputItem, "luphieclutteredmod:luphie_empty_bulletin_board": InputItem, "moa_decor_art:guitarraelectricaamarilla": InputItem, "create:scoria": InputItem, "minecraft:smooth_basalt": InputItem, "minecraft:allium": InputItem, "minecraft:magenta_wool": InputItem, "minecraft:prismarine_bricks": InputItem, "moa_decor_toys:zombie": InputItem, "moa_decor_bath:soporteparajabon": InputItem, "luphieclutteredmod:luphie_antique_sewing_machine": InputItem, "bloomingnature:stripped_chestnut_log": InputItem, "aquaculture:arapaima": InputItem, "moa_decor_toys:piglinbruto": InputItem, "moa_decor_art:microfono": InputItem, "moa_decor_art:rollosdepelicula": InputItem, "moa_decor_art:tamboramarillo": InputItem, "luphieclutteredmod:luphie_heart_cake": InputItem, "moa_decor_toys:ocelote": InputItem, "moa_decor_toys:ghast": InputItem, "beachparty:palm_leaves": InputItem, "meadow:patched_wool": InputItem, "moa_decor_bath:inodoro": InputItem, "bloomingnature:aspen_log": InputItem, "moa_decor_holidays:esqueleto_enjaulado": InputItem, "meadow:highland_wool": InputItem, "moa_decor_toys:gallinayjinetealdeanozombie": InputItem, "luphieclutteredmod:luphie_table_with_cloth": InputItem, "moa_decor_holidays:tumba": InputItem, "biomesoplenty:pink_hibiscus": InputItem, "moa_decor_art:guitarraelectricacafe": InputItem, "kubejs:miles_ticket": InputItem, "moa_decor_toys:slime": InputItem, "moa_decor_toys:warden": InputItem, "quark:lavender_blossom_leaves": InputItem, "moa_decor_toys:esqueletowither": InputItem, "moa_decor_toys:caballocafeosc": InputItem, "luphieclutteredmod:luphie_mermaid_pearl": InputItem, "moa_decor_bath:letreropisomojado": InputItem, "minecraft:green_concrete_powder": InputItem, "luphieclutteredmod:luphie_caged_bulb": InputItem, "bloomingnature:ebony_log": InputItem, "moa_decor_toys:ovejaazul": InputItem, "create:ochrum": InputItem, "luphieclutteredmod:luphie_baking_set_a": InputItem, "kubejs:4k_storage_disk_ticket": InputItem, "bakery:bread": InputItem, "biomesoplenty:magic_log": InputItem, "biomesoplenty:willow_log": InputItem, "moa_decor_holidays:clabaza_creeper_nav": InputItem, "aquaculture:atlantic_cod": InputItem, "minecraft:orange_wool": InputItem, "create:crimsite": InputItem, "moa_decor_holidays:arana_en_telarana": InputItem, "aquaculture:starshell_turtle": InputItem, "minecraft:pufferfish": InputItem, "luphieclutteredmod:luphie_tea_kettle": InputItem, "minecraft:stick": InputItem, "bloomingnature:swamp_cypress_log": InputItem, "moa_decor_art:guitarraelectricarosa": InputItem, "moa_decor_toys:delfin": InputItem, "gemsnjewels:spinel": InputItem, "bloomingnature:ebony_leaves": InputItem, "botania:white_mystical_flower": InputItem, "minecraft:netherrack": InputItem, "herbalbrews:lavender": InputItem, "luphieclutteredmod:luphie_antique_book_stand": InputItem, "moa_decor_toys:piglin": InputItem, "#forge:furniture_umbran_log": InputItem, "minecraft:blue_concrete_powder": InputItem, "moa_decor_toys:caballogris_m": InputItem, "moa_decor_holidays:base_pino_navideno": InputItem, "minecraft:bone_meal": InputItem, "moa_decor_toys:caballogris_r": InputItem, "botania:cyan_mystical_flower": InputItem, "minecraft:lime_wool": InputItem, "moa_decor_toys:caballogris_c": InputItem, "moa_decor_toys:conejoblanco": InputItem, "moa_decor_toys:caballogris_h": InputItem, "moa_decor_holidays:esqueletoacostado": InputItem, "aquaculture:brown_trout": InputItem, "luphieclutteredmod:luphie_cluttered_cat_mugs": InputItem, "moa_decor_toys:llamacrema": InputItem, "moa_decor_toys:ovejaamarilla": InputItem, "moa_decor_toys:caballocafe": InputItem, "luphieclutteredmod:luphie_coffee_grinder": InputItem, "biomesoplenty:flowering_oak_leaves": InputItem, "bloomingnature:golden_rod": InputItem, "moa_decor_holidays:pino_navideno": InputItem, "luphieclutteredmod:luphie_steampunk_lamp": InputItem, "moa_decor_art:claqueta": InputItem, "playdate:wooden_soldier": InputItem, "luphieclutteredmod:luphie_cluttered_desk": InputItem, "aquaculture:leech": InputItem, "luphieclutteredmod:luphie_general_store_cabinet": InputItem, "moa_decor_bath:jabonera": InputItem, "minecraft:pink_tulip": InputItem, "luphieclutteredmod:luphie_antique_lamp": InputItem, "biomesoplenty:jacaranda_leaves": InputItem, "moa_decor_toys:gatojellie": InputItem, "moa_decor_toys:conejodorado": InputItem, "moa_decor_toys:invocador": InputItem, "luphieclutteredmod:luphie_unliving_chair": InputItem, "moa_decor_toys:caballoesqueleto": InputItem, "luphieclutteredmod:luphie_handheld_sea_gem_lantern": InputItem, "moa_decor_toys:devastador": InputItem, "luphieclutteredmod:luphie_pastel_chair": InputItem, "#forge:furniture_crimson_log": InputItem, "moa_decor_toys:mula": InputItem, "bloomingnature:larch_log": InputItem, "moa_decor_toys:abeja": InputItem, "moa_decor_toys:camello": InputItem, "#forge:eggs": InputItem, "moa_decor_bath:lavabo": InputItem, "minecraft:spruce_log": InputItem, "playdate:music_box": InputItem, "moa_decor_holidays:mariachitrompeta": InputItem, "luphieclutteredmod:luphie_hanging_dish_towel": InputItem, "luphieclutteredmod:luphie_havana_cabinet": InputItem, "minecraft:light_gray_concrete": InputItem, "botania:light_blue_mystical_flower": InputItem, "moa_decor_toys:ajolotecian": InputItem, "biomesoplenty:orange_sandstone": InputItem, "moa_decor_holidays:c_pcafe": InputItem, "gemsnjewels:sable_amethyst": InputItem, "moa_decor_toys:gallinayzombiemomificado": InputItem, "moa_decor_science:tintero": InputItem, "luphieclutteredmod:luphie_cluttered_seltzer_cans": InputItem, "luphieclutteredmod:scrambled_pastel_rubiks_cube": InputItem, "gemsnjewels:ruby": InputItem, "moa_decor_science:libro": InputItem, "minecraft:azalea_leaves": InputItem, "moa_decor_art:guitarraelectricaazul": InputItem, "gemsnjewels:iolite": InputItem, "moa_decor_toys:gatoragdoll": InputItem, "moa_decor_art:tamborverdelima": InputItem, "quark:blue_blossom_leaves": InputItem, "luphieclutteredmod:luphie_retro_yellow_fridge": InputItem, "moa_decor_science:barriltoxicoderramado": InputItem, "moa_decor_art:guitarraelectricanaranja": InputItem, "quark:dusky_myalite": InputItem, "luphieclutteredmod:luphie_envelope_stack": InputItem, "gemsnjewels:opal": InputItem, "biomesoplenty:icy_iris": InputItem, "luphieclutteredmod:luphie_briefcase": InputItem, "moa_decor_science:pizarra": InputItem, "luphieclutteredmod:luphie_blossom_garland": InputItem, "moa_decor_holidays:tumbaabierta": InputItem, "meadow:warped_wool": InputItem, "minecraft:rose_bush": InputItem, "vinery:red_grapejuice_wine_bottle": InputItem, "moa_decor_toys:conejocafe": InputItem, "moa_decor_art:guitarraelectricaroja": InputItem, "moa_decor_science:libroabierto": InputItem, "luphieclutteredmod:luphie_mermaid_dresser": InputItem, "moa_decor_toys:ajolotedorado": InputItem, "alexsmobs:acacia_blossom": InputItem, "moa_decor_toys:dragondelender": InputItem, "minecraft:torchflower_seeds": InputItem, "moa_decor_science:mapadeltesoro": InputItem, "luphieclutteredmod:cluttered_purple_cabinet": InputItem, "minecraft:andesite": InputItem, "moa_decor_art:guitarraelectricamorada": InputItem, "biomesoplenty:pink_daffodil": InputItem, "moa_decor_toys:sniffer": InputItem, "#forge:furniture_bamboo_planks": InputItem, "minecraft:magenta_terracotta": InputItem, "moa_decor_science:librosapilados": InputItem, "moa_decor_toys:ovejacafe": InputItem, "moa_decor_toys:cabra": InputItem, "bloomingnature:palm_leaves": InputItem, "moa_decor_bath:jabon": InputItem, "moa_decor_toys:gallinaypiglinzombie": InputItem, "minecraft:dandelion": InputItem, "minecraft:oxeye_daisy": InputItem, "minecraft:brown_concrete": InputItem, "luphieclutteredmod:luphie_retro_pink_fridge": InputItem, "minecraft:cyan_concrete": InputItem, "gemsnjewels:ametrine": InputItem, "moa_decor_toys:champivaca": InputItem, "moa_decor_toys:aleanozombie": InputItem, "moa_decor_toys:ovejagris": InputItem, "playdate:toy_train": InputItem, "bloomingnature:freesia_yellow": InputItem, "moa_decor_toys:ovejaverde": InputItem, "minecraft:wither_rose": InputItem, "minecraft:dripstone_block": InputItem, "luphieclutteredmod:luphie_greener_nightstand": InputItem, "moa_decor_toys:ovejamagenta": InputItem, "minecraft:cyan_concrete_powder": InputItem, "minecraft:lime_concrete": InputItem, "luphieclutteredmod:unpainted_birdhouse": InputItem, "moa_decor_holidays:lapida": InputItem, "luphieclutteredmod:luphie_hoppin_park_lantern": InputItem, "botania:gray_mystical_flower": InputItem, "minecraft:light_gray_terracotta": InputItem, "moa_decor_toys:caballocrema_r": InputItem, "moa_decor_toys:caballocrema_m": InputItem, "bloomingnature:begonie": InputItem, "moa_decor_science:frascodepildorasabierto": InputItem, "minecraft:granite": InputItem, "bloomingnature:bird_of_paradise": InputItem, "minecraft:orange_concrete_powder": InputItem, "moa_decor_toys:caballocrema_c": InputItem, "minecraft:white_concrete": InputItem, "moa_decor_toys:caballocrema_h": InputItem, "luphieclutteredmod:luphie_lunar_observatory_small_table": InputItem, "#forge:furniture_palm_log": InputItem, "moa_decor_toys:gallinayzombie": InputItem, "minecraft:verdant_froglight": InputItem, "#forge:furniture_acacia_planks": InputItem, "minecraft:orange_tulip": InputItem, "botania:green_mystical_flower": InputItem, "minecraft:ice": InputItem, "minecraft:snow_block": InputItem, "beachparty:icecream_coconut": InputItem, "luphieclutteredmod:luphie_mushroom_lamp": InputItem, "moa_decor_art:tamborblanco": InputItem, "bloomingnature:daphne": InputItem, "luphieclutteredmod:luphie_pink_record_player": InputItem, "minecraft:red_wool": InputItem, "luphieclutteredmod:luphie_green_desk": InputItem, "luphieclutteredmod:luphie_retro_black_fridge": InputItem, "moa_decor_toys:aranayesqueleto": InputItem, "moa_decor_toys:hoglin": InputItem, "minecraft:blue_concrete": InputItem, "moa_decor_toys:endermite": InputItem, "aquaculture:tuna": InputItem, "luphieclutteredmod:luphie_lemon_table": InputItem, "minecraft:lime_terracotta": InputItem, "luphieclutteredmod:luphie_brown_desk": InputItem, "luphieclutteredmod:purple_flower_shelf": InputItem, "minecraft:brown_wool": InputItem, "#forge:furniture_redwood_log": InputItem, "moa_decor_holidays:estrella_navidena": InputItem, "minecraft:yellow_concrete_powder": InputItem, "createdeco:zinc_sheet": InputItem, "moa_decor_holidays:leprechaun": InputItem, "gemsnjewels:garnet": InputItem, "moa_decor_bath:tendederoconsabanas": InputItem, "moa_decor_toys:caballocrema": InputItem, "biomesoplenty:mahogany_log": InputItem, "moa_decor_toys:caballogris": InputItem, "moa_decor_toys:golemdehierro": InputItem, "luphieclutteredmod:luphie_china_cabinet": InputItem, "moa_decor_holidays:arana_en_telarana_2": InputItem, "meadow:fire_lily": InputItem, "playdate:toy_robot": InputItem, "bakery:yeast": InputItem, "moa_decor_toys:ovejaverdelima": InputItem, "luphieclutteredmod:scrambled_rubiks_cube": InputItem, "luphieclutteredmod:luphie_flower_desk_lamp": InputItem, "bloomingnature:swamp_oak_leaves": InputItem, "moa_decor_toys:lorocian": InputItem, "moa_decor_science:barrilinflamable": InputItem, "moa_decor_toys:aldeano": InputItem, "minecraft:gray_wool": InputItem, "moa_decor_holidays:creeper_nieve": InputItem, "moa_decor_toys:gatotuxedo": InputItem, "luphieclutteredmod:pink_bicycle": InputItem, "moa_decor_art:microfonoenpedestal": InputItem, "luphieclutteredmod:luphie_cluttered_green_desk": InputItem, "#minecraft:logs": InputItem, "minecraft:blue_terracotta": InputItem, "luphieclutteredmod:cute_yellow_bicycle": InputItem, "luphieclutteredmod:luphie_mushroom_table": InputItem, "quark:ancient_log": InputItem, "moa_decor_toys:zombieahogado": InputItem, "biomesoplenty:dead_log": InputItem, "biomesoplenty:origin_leaves": InputItem, "minecraft:mangrove_log": InputItem, "moa_decor_toys:vex": InputItem, "bloomingnature:stripped_palm_log": InputItem, "botania:red_mystical_flower": InputItem, "bloomingnature:stripped_swamp_oak_log": InputItem, "quark:ancient_leaves": InputItem, "biomesoplenty:waterlily": InputItem, "aquaculture:smallmouth_bass": InputItem, "luphieclutteredmod:luphie_bunny_garland": InputItem, "moa_decor_bath:planch": InputItem, "moa_decor_toys:gallinayahogado": InputItem, "minecraft:birch_leaves": InputItem, "moa_decor_toys:gatonegro": InputItem, "moa_decor_art:guitarraelectricagrisclara": InputItem, "#forge:furniture_oak_log": InputItem, "moa_decor_art:guitarraelectricagris": InputItem, "aquaculture:minnow": InputItem, "biomesoplenty:burning_blossom": InputItem, "#forge:furniture_magic_log": InputItem, "minecraft:cobbled_deepslate": InputItem, "moa_decor_toys:ranacalida": InputItem, "bloomingnature:baobab_leaves": InputItem, "minecraft:blackstone": InputItem, "moa_decor_science:veneno": InputItem, "minecraft:orange_concrete": InputItem, "bloomingnature:tall_lupine_blue": InputItem, "quark:yellow_blossom_leaves": InputItem, "moa_decor_holidays:murcielagocerrado": InputItem, "moa_decor_toys:loroverde": InputItem, "gemsnjewels:tourmaline": InputItem, "playdate:wooden_duck": InputItem, "biomesoplenty:palm_leaves": InputItem, "minecraft:blue_orchid": InputItem, "luphieclutteredmod:luphie_key": InputItem, "moa_decor_toys:aranadelascuevas": InputItem, "luphieclutteredmod:luphie_office_supplies_clutter": InputItem, "minecraft:oak_leaves": InputItem, "aquaculture:red_shrooma": InputItem, "moa_decor_holidays:corona_navidena": InputItem, "luphieclutteredmod:luphie_classic_radio": InputItem, "minecraft:red_concrete": InputItem, "moa_decor_art:amplificador": InputItem, "moa_decor_toys:loroazul": InputItem, "playdate:toy_bench": InputItem, "vinery:grapevine_leaves": InputItem, "aquaculture:gar": InputItem, "bloomingnature:mountain_laurel": InputItem, "minecraft:cherry_leaves": InputItem, "luphieclutteredmod:luphie_pastel_traditional_table": InputItem, "luphieclutteredmod:luphie_bunny_book_ends": InputItem, "luphieclutteredmod:yellow_bicycle": InputItem, "minecraft:soul_sand": InputItem, "minecraft:light_blue_concrete_powder": InputItem, "minecraft:cornflower": InputItem, "#forge:furniture_birch_planks": InputItem, "bloomingnature:aspen_leaves": InputItem, "moa_decor_holidays:zombiesaliendotierra": InputItem, "minecraft:nether_wart_block": InputItem, "luphieclutteredmod:luphie_button_stool": InputItem, "minecraft:green_wool": InputItem, "moa_decor_holidays:fantasma": InputItem, "luphieclutteredmod:stainedglasslamp": InputItem, "beachparty:palm_log": InputItem, "moa_decor_bath:esponjadebano": InputItem, "luphieclutteredmod:luphie_ancient_codex": InputItem, "luphieclutteredmod:luphie_steampunk_globe": InputItem, "moa_decor_bath:tendederoconropafemenina": InputItem, "moa_decor_science:bascula": InputItem, "moa_decor_art:martilloycincel": InputItem, "moa_decor_toys:lororojo": InputItem, "luphieclutteredmod:luphie_rose_endtable": InputItem, "moa_decor_toys:wither": InputItem, "moa_decor_art:pincelesenagua": InputItem, "moa_decor_holidays:santa_claus": InputItem, "aquaculture:box_turtle": InputItem, "bloomingnature:fir_log": InputItem, "luphieclutteredmod:luphie_lunar_observatory_globe": InputItem, "quark:myalite": InputItem, "playdate:ring_tower": InputItem, "minecraft:crimson_stem": InputItem, "minecraft:blue_wool": InputItem, "moa_decor_art:gafas_3d": InputItem, "luphieclutteredmod:luphie_black_cat_garland": InputItem, "biomesoplenty:maple_leaves": InputItem, "playdate:sock_monkey": InputItem, "bloomingnature:chestnut_leaves": InputItem, "biomesoplenty:blue_hydrangea": InputItem, "moa_decor_toys:gatotabby": InputItem, "moa_decor_toys:ovejanaranja": InputItem, "aquaculture:pollock": InputItem, "luphieclutteredmod:luphie_angry_bee_lamp": InputItem, "minecraft:yellow_concrete": InputItem, "moa_decor_toys:lepisma": InputItem, "luphieclutteredmod:tarrey_town_stove": InputItem, "handcrafted:blaze_trophy": InputItem, "moa_decor_toys:zorroblanco": InputItem, "minecraft:red_terracotta": InputItem, "luphieclutteredmod:luphie_paint_water_jar": InputItem, "aquaculture:capitaine": InputItem, "#forge:furniture_dark_oak_planks": InputItem, "bloomingnature:baobab_log": InputItem, "moa_decor_art:guitarraelectricaverde": InputItem, "moa_decor_science:botiquindepared": InputItem, "luphieclutteredmod:luphie_mushroom_wardrobe": InputItem, "minecraft:melon_slice": InputItem, "moa_decor_art:tamborcian": InputItem, "luphieclutteredmod:luphie_cluttered_havana_cabinet": InputItem, "moa_decor_holidays:mariachiviolin": InputItem, "gemsnjewels:kunzite": InputItem, "moa_decor_bath:secadormanos": InputItem, "moa_decor_toys:murcielago": InputItem, "moa_decor_holidays:c_pblanco": InputItem, "moa_decor_art:tamborazulclaro": InputItem, "minecraft:charcoal": InputItem, "moa_decor_toys:devastadorysaqueador": InputItem, "biomesoplenty:hellbark_log": InputItem}) & (Internal.Map<string, InputItem>);
}
type InputItem_ = Internal.Ingredient_ | InputItem;
declare interface Color {
    of(o: any): dev.latvian.mods.rhino.mod.util.color.Color;
    rgba(r: number, g: number, b: number, a: number): dev.latvian.mods.rhino.mod.util.color.Color;
    createMapped(o: any, ...names: string[]): dev.latvian.mods.rhino.mod.util.color.Color;
    readonly DARK_PURPLE: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly YELLOW: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly CYAN_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly GRAY: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly BROWN_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly LIGHT_PURPLE: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly PURPLE_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly DARK_AQUA: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly GREEN: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly LIGHT_GRAY_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly WHITE: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly MAGENTA_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly RED: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly BLACK_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly TEXT: ({"dark_red": Internal.ChatFormatting, "green": Internal.ChatFormatting, "underline": Internal.ChatFormatting, "dark_green": Internal.ChatFormatting, "black": Internal.ChatFormatting, "yellow": Internal.ChatFormatting, "bold": Internal.ChatFormatting, "italic": Internal.ChatFormatting, "dark_blue": Internal.ChatFormatting, "dark_purple": Internal.ChatFormatting, "gold": Internal.ChatFormatting, "red": Internal.ChatFormatting, "aqua": Internal.ChatFormatting, "gray": Internal.ChatFormatting, "light_purple": Internal.ChatFormatting, "blue": Internal.ChatFormatting, "white": Internal.ChatFormatting, "dark_aqua": Internal.ChatFormatting, "dark_gray": Internal.ChatFormatting, "reset": Internal.ChatFormatting, "strikethrough": Internal.ChatFormatting, "obfuscated": Internal.ChatFormatting}) & (Internal.Map<string, Internal.ChatFormatting>);
    readonly RED_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly GRAY_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly DARK_GRAY: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly NONE: (Internal.NoColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly ORANGE_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly WHITE_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly DYE: ({"magenta": Internal.DyeColor, "pink": Internal.DyeColor, "green": Internal.DyeColor, "lime": Internal.DyeColor, "light_gray": Internal.DyeColor, "yellow": Internal.DyeColor, "black": Internal.DyeColor, "light_blue": Internal.DyeColor, "brown": Internal.DyeColor, "cyan": Internal.DyeColor, "orange": Internal.DyeColor, "red": Internal.DyeColor, "gray": Internal.DyeColor, "white": Internal.DyeColor, "blue": Internal.DyeColor, "purple": Internal.DyeColor}) & (Internal.Map<string, Internal.DyeColor>);
    readonly BLACK: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly BLUE: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly DARK_GREEN: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly DARK_RED: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly GOLD: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly MAP: ({"": Internal.NoColor, "light_blue_dye": Internal.DyeColor, "BLUE_DYE": Internal.DyeColor, "purple_dye": Internal.DyeColor, "dark_red": Internal.ChatFormatting, "lightGrayDye": Internal.DyeColor, "DARK_AQUA": Internal.ChatFormatting, "none": Internal.NoColor, "green_dye": Internal.DyeColor, "blackDye": Internal.DyeColor, "dark_blue": Internal.ChatFormatting, "red": Internal.ChatFormatting, "pink_dye": Internal.DyeColor, "aqua": Internal.ChatFormatting, "white": Internal.ChatFormatting, "WHITE_DYE": Internal.DyeColor, "dark_gray": Internal.ChatFormatting, "LIGHT_PURPLE": Internal.ChatFormatting, "BROWN_DYE": Internal.DyeColor, "BLACK": Internal.ChatFormatting, "darkPurple": Internal.ChatFormatting, "NONE": Internal.NoColor, "LIGHT_BLUE_DYE": Internal.DyeColor, "AQUA": Internal.ChatFormatting, "lightBlueDye": Internal.DyeColor, "limeDye": Internal.DyeColor, "PURPLE_DYE": Internal.DyeColor, "GREEN_DYE": Internal.DyeColor, "magenta_dye": Internal.DyeColor, "-": Internal.NoColor, "lime_dye": Internal.DyeColor, "yellowDye": Internal.DyeColor, "grayDye": Internal.DyeColor, "purpleDye": Internal.DyeColor, "DARK_PURPLE": Internal.ChatFormatting, "ORANGE_DYE": Internal.DyeColor, "darkGray": Internal.ChatFormatting, "brownDye": Internal.DyeColor, "YELLOW": Internal.ChatFormatting, "LIME_DYE": Internal.DyeColor, "blueDye": Internal.DyeColor, "white_dye": Internal.DyeColor, "pinkDye": Internal.DyeColor, "blue_dye": Internal.DyeColor, "cyanDye": Internal.DyeColor, "GOLD": Internal.ChatFormatting, "GRAY": Internal.ChatFormatting, "MAGENTA_DYE": Internal.DyeColor, "BLUE": Internal.ChatFormatting, "yellow": Internal.ChatFormatting, "darkBlue": Internal.ChatFormatting, "transparent": Internal.NoColor, "orange_dye": Internal.DyeColor, "red_dye": Internal.DyeColor, "dark_purple": Internal.ChatFormatting, "gold": Internal.ChatFormatting, "gray": Internal.ChatFormatting, "light_purple": Internal.ChatFormatting, "darkRed": Internal.ChatFormatting, "greenDye": Internal.DyeColor, "DARK_RED": Internal.ChatFormatting, "redDye": Internal.DyeColor, "GRAY_DYE": Internal.DyeColor, "orangeDye": Internal.DyeColor, "yellow_dye": Internal.DyeColor, "black_dye": Internal.DyeColor, "magentaDye": Internal.DyeColor, "WHITE": Internal.ChatFormatting, "green": Internal.ChatFormatting, "LIGHT_GRAY_DYE": Internal.DyeColor, "BLACK_DYE": Internal.DyeColor, "darkGreen": Internal.ChatFormatting, "RED_DYE": Internal.DyeColor, "dark_green": Internal.ChatFormatting, "black": Internal.ChatFormatting, "lightPurple": Internal.ChatFormatting, "PINK_DYE": Internal.DyeColor, "DARK_BLUE": Internal.ChatFormatting, "GREEN": Internal.ChatFormatting, "darkAqua": Internal.ChatFormatting, "gray_dye": Internal.DyeColor, "CYAN_DYE": Internal.DyeColor, "RED": Internal.ChatFormatting, "brown_dye": Internal.DyeColor, "cyan_dye": Internal.DyeColor, "blue": Internal.ChatFormatting, "whiteDye": Internal.DyeColor, "dark_aqua": Internal.ChatFormatting, "YELLOW_DYE": Internal.DyeColor, "DARK_GREEN": Internal.ChatFormatting, "DARK_GRAY": Internal.ChatFormatting}) & (Internal.Map<string, dev.latvian.mods.rhino.mod.util.color.Color>);
    readonly GREEN_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly LIGHT_BLUE_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly AQUA: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly DARK_BLUE: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly PINK_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly BLUE_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly YELLOW_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly LIME_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
}
type Color_ = Color;
declare const Color: Color;
declare class JsonIO {
    constructor()
    getClass(): typeof any;
    static readJson(path: Internal.Path_): Internal.JsonElement;
    static toPrettyString(json: Internal.JsonElement_): string;
    static getJsonHashString(json: Internal.JsonElement_): string;
    notify(): void;
    static toObject(json: Internal.JsonElement_): any;
    wait(arg0: number, arg1: number): void;
    static primitiveOf(o: any): Internal.JsonPrimitive;
    static readString(path: Internal.Path_): string;
    static writeJsonHash(stream: Internal.DataOutputStream_, element: Internal.JsonElement_): void;
    static parseRaw(string: string): Internal.JsonElement;
    static write(path: Internal.Path_, json: Internal.JsonObject_): void;
    static read(path: Internal.Path_): Internal.Map<any, any>;
    toString(): string;
    notifyAll(): void;
    static toArray(element: Internal.JsonElement_): Internal.JsonArray;
    static parse(string: string): any;
    static toPrimitive(element: Internal.JsonElement_): any;
    hashCode(): number;
    static copy(element: Internal.JsonElement_): Internal.JsonElement;
    wait(): void;
    wait(arg0: number): void;
    static toString(json: Internal.JsonElement_): string;
    static getJsonHashBytes(json: Internal.JsonElement_): number[];
    equals(arg0: any): boolean;
    static of(o: any): Internal.JsonElement;
    get class(): typeof any
}
type JsonIO_ = JsonIO;
/**
 * Various item related helper methods
*/
declare interface Item {
    /**
     * Returns an ItemStack of the input
    */
    of(in_: Internal.ItemStack_): Internal.ItemStack;
    /**
     * Returns an ItemStack of the input, with the specified count and NBT data
    */
    of(in_: Internal.ItemStack_, count: number, nbt: Internal.CompoundTag_): Internal.ItemStack;
    /**
     * Returns an ItemStack of the input, with the specified count
    */
    of(in_: Internal.ItemStack_, count: number): Internal.ItemStack;
    /**
     * Returns an ItemStack of the input, with the specified NBT data
    */
    withNBT(in_: Internal.ItemStack_, nbt: Internal.CompoundTag_): Internal.ItemStack;
    getTypeToStackMap(): Internal.Map<ResourceLocation, Internal.Collection<Internal.ItemStack>>;
    playerHeadFromSkinHash(hash: string): Internal.ItemStack;
    /**
     * Get the item that represents air/an empty slot
    */
    getEmpty(): Internal.ItemStack;
    /**
     * Returns an ItemStack of the input, with the specified count
    */
    "of(net.minecraft.world.item.ItemStack,int)"(in_: Internal.ItemStack_, count: number): Internal.ItemStack;
    /**
     * Gets an Item from an item id
    */
    getItem(id: ResourceLocation_): Internal.Item;
    getVariants(item: Internal.ItemStack_): Internal.Collection<Internal.ItemStack>;
    /**
     * Get a list of most items in the game. Items not in a creative tab are ignored
    */
    getList(): Internal.List<Internal.ItemStack>;
    /**
     * Returns a Firework with the input properties
    */
    fireworks(properties: Internal.Map_<string, any>): Internal.FireworksJS;
    /**
     * Returns an ItemStack of the input, with the specified NBT data
    */
    "of(net.minecraft.world.item.ItemStack,net.minecraft.nbt.CompoundTag)"(in_: Internal.ItemStack_, tag: Internal.CompoundTag_): Internal.ItemStack;
    playerHead(name: string): Internal.ItemStack;
    playerHeadFromUrl(url: string): Internal.ItemStack;
    /**
     * Returns an ItemStack of the input, with the specified NBT data
    */
    of(in_: Internal.ItemStack_, tag: Internal.CompoundTag_): Internal.ItemStack;
    /**
     * Get a list of all the item ids in the game
    */
    getTypeList(): Internal.List<string>;
    /**
     * Checks if the provided item id exists in the registry
    */
    exists(id: ResourceLocation_): boolean;
    playerHead(uuid: Internal.UUID_, textureBase64: string): Internal.ItemStack;
    /**
     * Checks if the passed in object is an ItemStack.
     * Note that this does not mean it will not function as an ItemStack if passed to something that requests one.
    */
    isItem(o: any): boolean;
    /**
     * Gets an items id from the Item
    */
    getId(item: Internal.Item_): ResourceLocation;
    get typeToStackMap(): Internal.Map<ResourceLocation, Internal.Collection<Internal.ItemStack>>
    /**
     * Get the item that represents air/an empty slot
    */
    get empty(): Internal.ItemStack
    /**
     * Get a list of most items in the game. Items not in a creative tab are ignored
    */
    get list(): Internal.List<Internal.ItemStack>
    /**
     * Get a list of all the item ids in the game
    */
    get typeList(): Internal.List<string>
    readonly KJS_ARMOR_MODIFIER_UUID_PER_SLOT: Internal.UUID[];
    readonly KJS_BASE_ATTACK_SPEED_UUID: (Internal.UUID) & (Internal.UUID);
    readonly KJS_BASE_ATTACK_DAMAGE_UUID: (Internal.UUID) & (Internal.UUID);
}
type Item_ = Item;
declare const Item: Item;
declare abstract class number implements Internal.Serializable {
    constructor()
    abstract longValue(): number;
    getClass(): typeof any;
    abstract doubleValue(): number;
    toString(): string;
    abstract floatValue(): number;
    notifyAll(): void;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    shortValue(): number;
    hashCode(): number;
    abstract intValue(): number;
    wait(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    byteValue(): number;
    get class(): typeof any
}
type number_ = number;
declare class Collectors {
    static mapping<T, U, A, R>(arg0: Internal.Function_<T, U>, arg1: Internal.Collector_<U, A, R>): Internal.Collector<T, any, R>;
    static toUnmodifiableSet<T>(): Internal.Collector<T, any, Internal.Set<T>>;
    static toConcurrentMap<T, K, U>(arg0: Internal.Function_<T, K>, arg1: Internal.Function_<T, U>): Internal.Collector<T, any, Internal.ConcurrentMap<K, U>>;
    static toCollection<T, C extends Internal.Collection<T>>(arg0: Internal.Supplier_<C>): Internal.Collector<T, any, C>;
    static filtering<T, A, R>(arg0: Internal.Predicate_<T>, arg1: Internal.Collector_<T, A, R>): Internal.Collector<T, any, R>;
    notify(): void;
    static toList<T>(): Internal.Collector<T, any, Internal.List<T>>;
    static groupingBy<T, K>(arg0: Internal.Function_<T, K>): Internal.Collector<T, any, Internal.Map<K, Internal.List<T>>>;
    static summarizingDouble<T>(arg0: Internal.ToDoubleFunction_<T>): Internal.Collector<T, any, Internal.DoubleSummaryStatistics>;
    static summingDouble<T>(arg0: Internal.ToDoubleFunction_<T>): Internal.Collector<T, any, number>;
    static reducing<T, U>(arg0: U, arg1: Internal.Function_<T, U>, arg2: Internal.BinaryOperator_<U>): Internal.Collector<T, any, U>;
    static partitioningBy<T>(arg0: Internal.Predicate_<T>): Internal.Collector<T, any, Internal.Map<boolean, Internal.List<T>>>;
    static teeing<T, R1, R2, R>(arg0: Internal.Collector_<T, any, R1>, arg1: Internal.Collector_<T, any, R2>, arg2: Internal.BiFunction_<R1, R2, R>): Internal.Collector<T, any, R>;
    static partitioningBy<T, D, A>(arg0: Internal.Predicate_<T>, arg1: Internal.Collector_<T, A, D>): Internal.Collector<T, any, Internal.Map<boolean, D>>;
    static toUnmodifiableList<T>(): Internal.Collector<T, any, Internal.List<T>>;
    static reducing<T>(arg0: T, arg1: Internal.BinaryOperator_<T>): Internal.Collector<T, any, T>;
    static minBy<T>(arg0: Comparator_<T>): Internal.Collector<T, any, Optional<T>>;
    static flatMapping<T, U, A, R>(arg0: Internal.Function_<T, Internal.Stream<U>>, arg1: Internal.Collector_<U, A, R>): Internal.Collector<T, any, R>;
    static toUnmodifiableMap<T, K, U>(arg0: Internal.Function_<T, K>, arg1: Internal.Function_<T, U>, arg2: Internal.BinaryOperator_<U>): Internal.Collector<T, any, Internal.Map<K, U>>;
    static joining(): Internal.Collector<Internal.CharSequence, any, string>;
    static groupingByConcurrent<T, K>(arg0: Internal.Function_<T, K>): Internal.Collector<T, any, Internal.ConcurrentMap<K, Internal.List<T>>>;
    static reducing<T>(arg0: Internal.BinaryOperator_<T>): Internal.Collector<T, any, Optional<T>>;
    static toMap<T, K, U, M extends Internal.Map<K, U>>(arg0: Internal.Function_<T, K>, arg1: Internal.Function_<T, U>, arg2: Internal.BinaryOperator_<U>, arg3: Internal.Supplier_<M>): Internal.Collector<T, any, M>;
    static maxBy<T>(arg0: Comparator_<T>): Internal.Collector<T, any, Optional<T>>;
    wait(): void;
    static averagingInt<T>(arg0: Internal.ToIntFunction_<T>): Internal.Collector<T, any, number>;
    static summingInt<T>(arg0: Internal.ToIntFunction_<T>): Internal.Collector<T, any, number>;
    static averagingDouble<T>(arg0: Internal.ToDoubleFunction_<T>): Internal.Collector<T, any, number>;
    static joining(arg0: Internal.CharSequence_, arg1: Internal.CharSequence_, arg2: Internal.CharSequence_): Internal.Collector<Internal.CharSequence, any, string>;
    static summarizingLong<T>(arg0: Internal.ToLongFunction_<T>): Internal.Collector<T, any, Internal.LongSummaryStatistics>;
    getClass(): typeof any;
    static groupingByConcurrent<T, K, A, D, M extends Internal.ConcurrentMap<K, D>>(arg0: Internal.Function_<T, K>, arg1: Internal.Supplier_<M>, arg2: Internal.Collector_<T, A, D>): Internal.Collector<T, any, M>;
    static toMap<T, K, U>(arg0: Internal.Function_<T, K>, arg1: Internal.Function_<T, U>, arg2: Internal.BinaryOperator_<U>): Internal.Collector<T, any, Internal.Map<K, U>>;
    wait(arg0: number, arg1: number): void;
    static groupingBy<T, K, D, A, M extends Internal.Map<K, D>>(arg0: Internal.Function_<T, K>, arg1: Internal.Supplier_<M>, arg2: Internal.Collector_<T, A, D>): Internal.Collector<T, any, M>;
    static summingLong<T>(arg0: Internal.ToLongFunction_<T>): Internal.Collector<T, any, number>;
    static groupingByConcurrent<T, K, A, D>(arg0: Internal.Function_<T, K>, arg1: Internal.Collector_<T, A, D>): Internal.Collector<T, any, Internal.ConcurrentMap<K, D>>;
    static joining(arg0: Internal.CharSequence_): Internal.Collector<Internal.CharSequence, any, string>;
    static toMap<T, K, U>(arg0: Internal.Function_<T, K>, arg1: Internal.Function_<T, U>): Internal.Collector<T, any, Internal.Map<K, U>>;
    toString(): string;
    static averagingLong<T>(arg0: Internal.ToLongFunction_<T>): Internal.Collector<T, any, number>;
    notifyAll(): void;
    static toConcurrentMap<T, K, U, M extends Internal.ConcurrentMap<K, U>>(arg0: Internal.Function_<T, K>, arg1: Internal.Function_<T, U>, arg2: Internal.BinaryOperator_<U>, arg3: Internal.Supplier_<M>): Internal.Collector<T, any, M>;
    static counting<T>(): Internal.Collector<T, any, number>;
    static collectingAndThen<T, A, R, RR>(arg0: Internal.Collector_<T, A, R>, arg1: Internal.Function_<R, RR>): Internal.Collector<T, A, RR>;
    hashCode(): number;
    static summarizingInt<T>(arg0: Internal.ToIntFunction_<T>): Internal.Collector<T, any, Internal.IntSummaryStatistics>;
    wait(arg0: number): void;
    static toUnmodifiableMap<T, K, U>(arg0: Internal.Function_<T, K>, arg1: Internal.Function_<T, U>): Internal.Collector<T, any, Internal.Map<K, U>>;
    static toConcurrentMap<T, K, U>(arg0: Internal.Function_<T, K>, arg1: Internal.Function_<T, U>, arg2: Internal.BinaryOperator_<U>): Internal.Collector<T, any, Internal.ConcurrentMap<K, U>>;
    equals(arg0: any): boolean;
    static toSet<T>(): Internal.Collector<T, any, Internal.Set<T>>;
    static groupingBy<T, K, A, D>(arg0: Internal.Function_<T, K>, arg1: Internal.Collector_<T, A, D>): Internal.Collector<T, any, Internal.Map<K, D>>;
    get class(): typeof any
}
type Collectors_ = Collectors;
declare class Notification {
    constructor()
    constructor(buf: Internal.FriendlyByteBuf_)
    getClass(): typeof any;
    write(buf: Internal.FriendlyByteBuf_): void;
    toString(): string;
    static make(consumer: Internal.Consumer_<Notification>): Notification;
    notifyAll(): void;
    static of(cx: Internal.Context_, object: any): Notification;
    setIcon(icon: string): void;
    show(): void;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    hashCode(): number;
    setAtlasIcon(icon: string): void;
    wait(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    setItemIcon(stack: Internal.ItemStack_): void;
    get class(): typeof any
    set icon(icon: string)
    set atlasIcon(icon: string)
    set itemIcon(stack: Internal.ItemStack_)
    duration: Duration;
    static readonly DEFAULT_DURATION: (Duration) & (Duration);
    backgroundColor: dev.latvian.mods.rhino.mod.util.color.Color;
    iconSize: number;
    static readonly DEFAULT_BACKGROUND_COLOR: (Internal.SimpleColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    static readonly DEFAULT_BORDER_COLOR: (Internal.SimpleColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    borderColor: dev.latvian.mods.rhino.mod.util.color.Color;
    text: net.minecraft.network.chat.Component;
    outlineColor: dev.latvian.mods.rhino.mod.util.color.Color;
    textShadow: boolean;
    static readonly NO_TEXT: net.minecraft.network.chat.Component[];
}
type Notification_ = Notification;
declare interface Facing {
    readonly south: (Internal.Direction) & (Internal.Direction);
    readonly up: (Internal.Direction) & (Internal.Direction);
    readonly UP: (Internal.Direction) & (Internal.Direction);
    readonly NORTH: (Internal.Direction) & (Internal.Direction);
    readonly east: (Internal.Direction) & (Internal.Direction);
    readonly DOWN: (Internal.Direction) & (Internal.Direction);
    readonly EAST: (Internal.Direction) & (Internal.Direction);
    readonly west: (Internal.Direction) & (Internal.Direction);
    readonly north: (Internal.Direction) & (Internal.Direction);
    readonly down: (Internal.Direction) & (Internal.Direction);
    readonly ALL: ({"east": Internal.Direction, "south": Internal.Direction, "north": Internal.Direction, "west": Internal.Direction, "up": Internal.Direction, "down": Internal.Direction}) & (Internal.Map<string, Internal.Direction>);
    readonly WEST: (Internal.Direction) & (Internal.Direction);
    readonly SOUTH: (Internal.Direction) & (Internal.Direction);
}
type Facing_ = Facing;
declare const Facing: Facing;
declare class Quaternionf implements Internal.Cloneable, Internal.Externalizable, Internal.Quaternionfc {
    constructor()
    constructor(arg0: Internal.AxisAngle4d_)
    constructor(arg0: Internal.Quaternionfc_)
    constructor(arg0: number, arg1: number, arg2: number, arg3: number)
    constructor(arg0: Internal.AxisAngle4f_)
    constructor(arg0: Internal.Quaterniondc_)
    constructor(arg0: number, arg1: number, arg2: number, arg3: number)
    "transform(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    slerp(arg0: Internal.Quaternionfc_, arg1: number, arg2: Quaternionf_): this;
    transformInverse(arg0: Internal.Vector4d_): Internal.Vector4d;
    invert(): this;
    transformPositiveY(arg0: Vec3f_): Vec3f;
    transformPositiveX(arg0: Internal.Vector3d_): Internal.Vector3d;
    mul(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    transformUnit(arg0: Internal.Vector4d_): Internal.Vector4d;
    getEulerAnglesXYZ(arg0: Vec3f_): Vec3f;
    "getAsMatrix3f(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    "transformInverse(float,float,float,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    "transformUnit(double,double,double,org.joml.Vector4d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    setFromUnnormalized(arg0: Internal.Matrix3fc_): this;
    get(arg0: Internal.Matrix4d_): Internal.Matrix4d;
    conjugate(arg0: Quaternionf_): this;
    transform(arg0: Internal.Vector4d_): Internal.Vector4d;
    rotateXYZ(arg0: number, arg1: number, arg2: number): this;
    fromAxisAngleDeg(arg0: Internal.Vector3fc_, arg1: number): this;
    "transformUnitPositiveZ(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    rotateLocalZ(arg0: number): this;
    scale(arg0: number): this;
    premul(arg0: number, arg1: number, arg2: number, arg3: number): this;
    rotationZ(arg0: number): this;
    transformInverse(arg0: Internal.Vector3d_): Internal.Vector3d;
    transformPositiveY(arg0: Vec4f_): Vec4f;
    transformPositiveX(arg0: Internal.Vector4d_): Internal.Vector4d;
    "set(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_): this;
    premul(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    transformUnit(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    "transformUnitPositiveY(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    invert(arg0: Quaternionf_): this;
    rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number): this;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    "get(org.joml.Quaternionf)"(arg0: Quaternionf_): this;
    transform(arg0: Internal.Vector3d_): Internal.Vector3d;
    "transformInverse(org.joml.Vector4dc,org.joml.Vector4d)"(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    "transform(double,double,double,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    positiveZ(arg0: Vec3f_): Vec3f;
    difference(arg0: Quaternionf_): this;
    div(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    setFromNormalized(arg0: Internal.Matrix3dc_): this;
    normalize(): this;
    getClass(): typeof any;
    transformPositiveY(arg0: Internal.Vector3d_): Internal.Vector3d;
    rotateZ(arg0: number): this;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    transformPositiveZ(arg0: Vec3f_): Vec3f;
    transformUnit(arg0: Vec4f_): Vec4f;
    "setAngleAxis(double,double,double,double)"(arg0: number, arg1: number, arg2: number, arg3: number): this;
    scale(arg0: number, arg1: Quaternionf_): this;
    nlerp(arg0: Internal.Quaternionfc_, arg1: number, arg2: Quaternionf_): this;
    "transformInverse(org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    mul(arg0: number): this;
    "transformUnitPositiveX(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Quaternionf_): this;
    static slerp(arg0: Quaternionf_[], arg1: number[], arg2: Quaternionf_): Internal.Quaternionfc;
    "transformPositiveY(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    get(arg0: Matrix4f_): Matrix4f;
    setAngleAxis(arg0: number, arg1: number, arg2: number, arg3: number): this;
    transform(arg0: Vec4f_): Vec4f;
    transformUnit(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    setFromNormalized(arg0: Internal.Matrix4fc_): this;
    "setFromNormalized(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_): this;
    getAsMatrix3f(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "transformInverseUnit(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    "get(org.joml.Matrix4x3f)"(arg0: Internal.Matrix4x3f_): Internal.Matrix4x3f;
    normalize(arg0: Quaternionf_): this;
    transformInverseUnit(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    rotationAxis(arg0: Internal.AxisAngle4f_): this;
    mul(arg0: number, arg1: Quaternionf_): this;
    "transformUnit(float,float,float,org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    "transformPositiveZ(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    w(): number;
    transform(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    transformPositiveY(arg0: Internal.Vector4d_): Internal.Vector4d;
    rotateTo(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Quaternionf_): this;
    add(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "transformInverse(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    transformPositiveZ(arg0: Vec4f_): Vec4f;
    conjugateBy(arg0: Internal.Quaternionfc_): this;
    "transformInverse(org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    transformInverse(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    get(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
    transform(arg0: Vec3f_): Vec3f;
    "get(org.joml.Matrix3d)"(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
    wait(arg0: number): void;
    "nlerp(org.joml.Quaternionfc,float,org.joml.Quaternionf)"(arg0: Internal.Quaternionfc_, arg1: number, arg2: Quaternionf_): this;
    mul(arg0: number, arg1: number, arg2: number, arg3: number): this;
    get(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
    slerp(arg0: Internal.Quaternionfc_, arg1: number): this;
    add(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): this;
    fromAxisAngleRad(arg0: number, arg1: number, arg2: number, arg3: number): this;
    transformPositiveZ(arg0: Internal.Vector3d_): Internal.Vector3d;
    "transformUnit(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    "get(org.joml.Matrix3f)"(arg0: Matrix3f_): Matrix3f;
    rotationTo(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    rotateLocalY(arg0: number, arg1: Quaternionf_): this;
    div(arg0: Internal.Quaternionfc_): this;
    transformInverseUnit(arg0: Internal.Vector4d_): Internal.Vector4d;
    "transformPositiveY(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    isFinite(): boolean;
    setFromUnnormalized(arg0: Internal.Matrix3dc_): this;
    "nlerpIterative(org.joml.Quaternionfc,float,float,org.joml.Quaternionf)"(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: Quaternionf_): this;
    transformUnitPositiveX(arg0: Vec3f_): Vec3f;
    rotateLocalX(arg0: number): this;
    get(arg0: Internal.AxisAngle4d_): Internal.AxisAngle4d;
    x(): number;
    transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    "transform(double,double,double,org.joml.Vector4d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    transformPositiveZ(arg0: Internal.Vector4d_): Internal.Vector4d;
    transformUnit(arg0: Vec3f_): Vec3f;
    "transformPositiveX(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    "transform(float,float,float,org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    "setFromUnnormalized(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    "transform(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    transformInverseUnit(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    "mul(float,org.joml.Quaternionf)"(arg0: number, arg1: Quaternionf_): this;
    "transformUnitPositiveZ(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    "transformInverseUnit(float,float,float,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    setFromUnnormalized(arg0: Internal.Matrix4fc_): this;
    fromAxisAngleRad(arg0: Internal.Vector3fc_, arg1: number): this;
    wait(): void;
    setFromNormalized(arg0: Internal.Matrix3fc_): this;
    premul(arg0: Internal.Quaternionfc_): this;
    nlerp(arg0: Internal.Quaternionfc_, arg1: number): this;
    integrate(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): this;
    "transformPositiveX(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    "transform(float,float,float,org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    get(arg0: Internal.Matrix4x3f_): Internal.Matrix4x3f;
    "getAsMatrix4f(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    "transformUnit(org.joml.Vector4dc,org.joml.Vector4d)"(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    "transformInverse(float,float,float,org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    static "nlerpIterative(org.joml.Quaternionf[],float[],float,org.joml.Quaternionf)"(arg0: Quaternionf_[], arg1: number[], arg2: number, arg3: Quaternionf_): Internal.Quaternionfc;
    transformInverse(arg0: Vec4f_): Vec4f;
    getEulerAnglesZXY(arg0: Vec3f_): Vec3f;
    nlerpIterative(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: Quaternionf_): this;
    transform(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    "get(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_): Internal.AxisAngle4d;
    transform(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    add(arg0: Internal.Quaternionfc_): this;
    rotateLocalZ(arg0: number, arg1: Quaternionf_): this;
    getAsMatrix4f(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    "transformUnit(float,float,float,org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    rotationYXZ(arg0: number, arg1: number, arg2: number): this;
    add(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    dot(arg0: Quaternionf_): number;
    "transformUnitPositiveY(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    "getAsMatrix4f(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    equals(arg0: number, arg1: number, arg2: number, arg3: number): boolean;
    rotateXYZ(arg0: number, arg1: number, arg2: number, arg3: Quaternionf_): this;
    rotateAxis(arg0: number, arg1: Internal.Vector3fc_): this;
    static "nlerp(org.joml.Quaternionfc[],float[],org.joml.Quaternionf)"(arg0: Internal.Quaternionfc_[], arg1: number[], arg2: Quaternionf_): Internal.Quaternionfc;
    rotateAxis(arg0: number, arg1: Internal.Vector3fc_, arg2: Quaternionf_): this;
    rotateLocalY(arg0: number): this;
    "transformInverse(double,double,double,org.joml.Vector4d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    y(): number;
    transformInverse(arg0: Vec3f_): Vec3f;
    "setFromNormalized(org.joml.Matrix4x3dc)"(arg0: Internal.Matrix4x3dc_): this;
    "transformUnitPositiveX(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    set(arg0: number, arg1: number, arg2: number, arg3: number): this;
    setFromNormalized(arg0: Internal.Matrix4x3fc_): this;
    "get(org.joml.Matrix4d)"(arg0: Internal.Matrix4d_): Internal.Matrix4d;
    static nlerp(arg0: Internal.Quaternionfc_[], arg1: number[], arg2: Quaternionf_): Internal.Quaternionfc;
    getAsMatrix4x3f(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    transform(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    setFromUnnormalized(arg0: Internal.Matrix4x3dc_): this;
    "transformInverse(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    "transformPositiveZ(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    "mul(float)"(arg0: number): this;
    conjugate(): this;
    transformInverse(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    equals(arg0: any): boolean;
    rotateYXZ(arg0: number, arg1: number, arg2: number): this;
    "transformInverseUnit(org.joml.Vector4dc,org.joml.Vector4d)"(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    "transformInverseUnit(float,float,float,org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    "setFromNormalized(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    rotationZYX(arg0: number, arg1: number, arg2: number): this;
    "transformInverse(float,float,float,org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    "transform(org.joml.Vector4dc,org.joml.Vector4d)"(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    fromAxisAngleDeg(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "setFromUnnormalized(org.joml.Matrix3dc)"(arg0: Internal.Matrix3dc_): this;
    transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    "getAsMatrix4x3f(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    transformUnitPositiveZ(arg0: Vec3f_): Vec3f;
    "setFromNormalized(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    transformUnitPositiveY(arg0: Internal.Vector3d_): Internal.Vector3d;
    "transform(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    "transformUnitPositiveZ(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    transformUnit(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    z(): number;
    "transformUnitPositiveY(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    normalizedPositiveX(arg0: Vec3f_): Vec3f;
    rotationAxis(arg0: number, arg1: Internal.Vector3fc_): this;
    "setAngleAxis(float,float,float,float)"(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "set(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): this;
    "get(org.joml.Quaterniond)"(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    getAsMatrix3f(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    toString(arg0: Internal.NumberFormat_): string;
    transformInverseUnit(arg0: Vec3f_): Vec3f;
    transformUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    lengthSquared(): number;
    setFromUnnormalized(arg0: Internal.Matrix4dc_): this;
    getEulerAnglesYXZ(arg0: Vec3f_): Vec3f;
    get(arg0: Quaternionf_): this;
    transformUnitPositiveX(arg0: Internal.Vector4d_): Internal.Vector4d;
    rotateX(arg0: number, arg1: Quaternionf_): this;
    transformUnitPositiveY(arg0: Vec4f_): Vec4f;
    identity(): this;
    "transformInverseUnit(org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    clone(): any;
    writeExternal(arg0: Internal.ObjectOutput_): void;
    "mul(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    "setFromUnnormalized(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    "transformUnitPositiveX(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    rotateZYX(arg0: number, arg1: number, arg2: number, arg3: Quaternionf_): this;
    rotateLocalX(arg0: number, arg1: Quaternionf_): this;
    "transformPositiveY(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    transformUnit(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    static "slerp(org.joml.Quaternionf[],float[],org.joml.Quaternionf)"(arg0: Quaternionf_[], arg1: number[], arg2: Quaternionf_): Internal.Quaternionfc;
    transform(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    set(arg0: Internal.Quaternionfc_): this;
    transformInverseUnit(arg0: Vec4f_): Vec4f;
    transformInverse(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    "set(org.joml.Quaterniondc)"(arg0: Internal.Quaterniondc_): this;
    setFromNormalized(arg0: Internal.Matrix4x3dc_): this;
    "get(org.joml.Matrix4x3d)"(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
    transformInverseUnit(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    transformUnitPositiveX(arg0: Internal.Vector3d_): Internal.Vector3d;
    "transformInverseUnit(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    transformUnitPositiveY(arg0: Vec3f_): Vec3f;
    rotationAxis(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "transformUnit(org.joml.Vector3dc,org.joml.Vector3d)"(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    rotateTo(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    "transformInverseUnit(org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    "transformUnit(double,double,double,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    get(arg0: Internal.AxisAngle4f_): Internal.AxisAngle4f;
    toString(): string;
    "transformPositiveZ(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    normalizedPositiveY(arg0: Vec3f_): Vec3f;
    notifyAll(): void;
    "transformInverse(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    "setFromNormalized(org.joml.Matrix4dc)"(arg0: Internal.Matrix4dc_): this;
    transform(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    equals(arg0: Internal.Quaternionfc_, arg1: number): boolean;
    scaling(arg0: number): this;
    transformInverse(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    "slerp(org.joml.Quaternionfc,float,org.joml.Quaternionf)"(arg0: Internal.Quaternionfc_, arg1: number, arg2: Quaternionf_): this;
    transform(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    setFromUnnormalized(arg0: Internal.Matrix4x3fc_): this;
    transformInverse(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): this;
    rotationTo(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    "transform(org.joml.Vector3dc,org.joml.Vector3d)"(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    transformUnitPositiveX(arg0: Vec4f_): Vec4f;
    premul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): this;
    getAsMatrix4x3f(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    mul(arg0: Internal.Quaternionfc_): this;
    rotateY(arg0: number): this;
    "transformInverse(double,double,double,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    "transformUnit(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    notify(): void;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Quaternionf_): this;
    transform(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    rotationX(arg0: number): this;
    "transformPositiveY(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    "transformInverseUnit(double,double,double,org.joml.Vector4d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    transformUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    integrate(arg0: number, arg1: number, arg2: number, arg3: number): this;
    transformInverse(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    "getAsMatrix4x3f(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    normalizedPositiveZ(arg0: Vec3f_): Vec3f;
    set(arg0: Internal.AxisAngle4f_): this;
    "getAsMatrix3f(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    conjugateBy(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    readExternal(arg0: Internal.ObjectInput_): void;
    "transform(float,float,float,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    angle(): number;
    getEulerAnglesZYX(arg0: Vec3f_): Vec3f;
    "transformPositiveX(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    transformInverseUnit(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    "transform(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    "transformInverseUnit(float,float,float,org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    get(arg0: Matrix3f_): Matrix3f;
    "setFromNormalized(org.joml.Matrix3dc)"(arg0: Internal.Matrix3dc_): this;
    "transformUnitPositiveZ(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    rotateZ(arg0: number, arg1: Quaternionf_): this;
    "transformInverseUnit(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    positiveX(arg0: Vec3f_): Vec3f;
    rotateYXZ(arg0: number, arg1: number, arg2: number, arg3: Quaternionf_): this;
    rotateZYX(arg0: number, arg1: number, arg2: number): this;
    transformUnitPositiveZ(arg0: Internal.Vector4d_): Internal.Vector4d;
    transformUnit(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    "transformPositiveX(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    getAsMatrix4f(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    transformInverse(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    rotateX(arg0: number): this;
    "transformInverseUnit(double,double,double,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    difference(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    transformPositiveX(arg0: Vec3f_): Vec3f;
    "set(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    "transformInverse(org.joml.Vector3dc,org.joml.Vector3d)"(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    "get(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): Internal.AxisAngle4f;
    wait(arg0: number, arg1: number): void;
    "setFromUnnormalized(org.joml.Matrix4dc)"(arg0: Internal.Matrix4dc_): this;
    set(arg0: Internal.Quaterniondc_): this;
    mul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): this;
    transformUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    "transformUnit(float,float,float,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    "mul(org.joml.Quaternionfc,org.joml.Quaternionf)"(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    transform(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    nlerpIterative(arg0: Internal.Quaternionfc_, arg1: number, arg2: number): this;
    "transformUnitPositiveY(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    transformUnitPositiveZ(arg0: Internal.Vector3d_): Internal.Vector3d;
    transformUnit(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    "transformUnit(org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    "transform(org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    "transformUnit(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    setFromNormalized(arg0: Internal.Matrix4dc_): this;
    static nlerpIterative(arg0: Quaternionf_[], arg1: number[], arg2: number, arg3: Quaternionf_): Internal.Quaternionfc;
    rotationY(arg0: number): this;
    rotationXYZ(arg0: number, arg1: number, arg2: number): this;
    transformInverse(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    rotateTo(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Quaternionf_): this;
    "transformInverseUnit(org.joml.Vector3dc,org.joml.Vector3d)"(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    transformPositiveX(arg0: Vec4f_): Vec4f;
    "get(org.joml.Matrix4f)"(arg0: Matrix4f_): Matrix4f;
    set(arg0: Internal.AxisAngle4d_): this;
    hashCode(): number;
    setAngleAxis(arg0: number, arg1: number, arg2: number, arg3: number): this;
    positiveY(arg0: Vec3f_): Vec3f;
    "transformInverse(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    rotateTo(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    "setFromUnnormalized(org.joml.Matrix4x3dc)"(arg0: Internal.Matrix4x3dc_): this;
    transformUnitPositiveZ(arg0: Vec4f_): Vec4f;
    get(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    "transform(org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    "transformPositiveZ(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    "transformUnitPositiveX(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    transformUnitPositiveY(arg0: Internal.Vector4d_): Internal.Vector4d;
    rotateY(arg0: number, arg1: Quaternionf_): this;
    "transformUnit(org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    "setFromUnnormalized(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_): this;
    transformInverse(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    set fromUnnormalized(arg0: Internal.Matrix3fc_)
    set "(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_)
    set fromNormalized(arg0: Internal.Matrix3dc_)
    get class(): typeof any
    set fromNormalized(arg0: Internal.Matrix4fc_)
    set "fromNormalized(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_)
    get finite(): boolean
    set fromUnnormalized(arg0: Internal.Matrix3dc_)
    set "fromUnnormalized(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_)
    set fromUnnormalized(arg0: Internal.Matrix4fc_)
    set fromNormalized(arg0: Internal.Matrix3fc_)
    set "fromNormalized(org.joml.Matrix4x3dc)"(arg0: Internal.Matrix4x3dc_)
    set fromNormalized(arg0: Internal.Matrix4x3fc_)
    set fromUnnormalized(arg0: Internal.Matrix4x3dc_)
    set "fromNormalized(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_)
    set "fromUnnormalized(org.joml.Matrix3dc)"(arg0: Internal.Matrix3dc_)
    set "fromNormalized(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_)
    set "(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_)
    set fromUnnormalized(arg0: Internal.Matrix4dc_)
    set "fromUnnormalized(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_)
    set "(org.joml.Quaterniondc)"(arg0: Internal.Quaterniondc_)
    set fromNormalized(arg0: Internal.Matrix4x3dc_)
    set "fromNormalized(org.joml.Matrix4dc)"(arg0: Internal.Matrix4dc_)
    set fromUnnormalized(arg0: Internal.Matrix4x3fc_)
    set "fromNormalized(org.joml.Matrix3dc)"(arg0: Internal.Matrix3dc_)
    set "(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_)
    set "fromUnnormalized(org.joml.Matrix4dc)"(arg0: Internal.Matrix4dc_)
    set fromNormalized(arg0: Internal.Matrix4dc_)
    set "fromUnnormalized(org.joml.Matrix4x3dc)"(arg0: Internal.Matrix4x3dc_)
    set "fromUnnormalized(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_)
    z: number;
    y: number;
    x: number;
    w: number;
}
type Quaternionf_ = Quaternionf;
declare class BlockProperties {
    constructor()
    getClass(): typeof any;
    hashCode(): number;
    toString(): string;
    wait(): void;
    notifyAll(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    get class(): typeof any
    static readonly LEVEL_FLOWING: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly PERSISTENT: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly HORIZONTAL_FACING: (Internal.DirectionProperty) & (Internal.DirectionProperty);
    static readonly WEST_REDSTONE: Internal.EnumProperty<Internal.RedstoneSide>;
    static readonly CHISELED_BOOKSHELF_SLOT_5_OCCUPIED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly NOTE: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly AGE_5: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly EGGS: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly NORTH: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly HAS_RECORD: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly SCULK_SENSOR_PHASE: Internal.EnumProperty<Internal.SculkSensorPhase>;
    static readonly EAST_WALL: Internal.EnumProperty<Internal.WallSide>;
    static readonly HALF: Internal.EnumProperty<Internal.Half>;
    static readonly RESPAWN_ANCHOR_CHARGES: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly HANGING: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly TILT: Internal.EnumProperty<Internal.Tilt>;
    static readonly STABILITY_DISTANCE: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly CHISELED_BOOKSHELF_SLOT_4_OCCUPIED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly HAS_BOTTLE_2: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly LAYERS: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly SOUTH_REDSTONE: Internal.EnumProperty<Internal.RedstoneSide>;
    static readonly CRACKED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly CONDITIONAL: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly LOCKED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly POWER: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly EYE: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly SOUTH_WALL: Internal.EnumProperty<Internal.WallSide>;
    static readonly MAX_AGE_1: (1) & (number);
    static readonly ATTACHED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly MAX_LEVEL_15: (15) & (number);
    static readonly BELL_ATTACHMENT: Internal.EnumProperty<Internal.BellAttachType>;
    static readonly MAX_DISTANCE: (7) & (number);
    static readonly FLOWER_AMOUNT: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly EXTENDED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly INVERTED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly MODE_COMPARATOR: Internal.EnumProperty<Internal.ComparatorMode>;
    static readonly MOISTURE: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly LIT: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly DISTANCE: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly NORTH_REDSTONE: Internal.EnumProperty<Internal.RedstoneSide>;
    static readonly AGE_3: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly STAIRS_SHAPE: Internal.EnumProperty<Internal.StairsShape>;
    static readonly MAX_LEVEL_8: (8) & (number);
    static readonly MIN_RESPAWN_ANCHOR_CHARGES: (0) & (number);
    static readonly BAMBOO_LEAVES: Internal.EnumProperty<Internal.BambooLeaves>;
    static readonly HORIZONTAL_AXIS: Internal.EnumProperty<Internal.Direction$Axis>;
    static readonly FALLING: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly ENABLED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly ATTACH_FACE: Internal.EnumProperty<Internal.AttachFace>;
    static readonly OPEN: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly UNSTABLE: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly AGE_4: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly EAST: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly ORIENTATION: Internal.EnumProperty<Internal.FrontAndTop>;
    static readonly DOUBLE_BLOCK_HALF: Internal.EnumProperty<Internal.DoubleBlockHalf>;
    static readonly MAX_RESPAWN_ANCHOR_CHARGES: (4) & (number);
    static readonly CHEST_TYPE: Internal.EnumProperty<Internal.ChestType>;
    static readonly MAX_AGE_7: (7) & (number);
    static readonly DOWN: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly CHISELED_BOOKSHELF_SLOT_2_OCCUPIED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly AGE_15: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly STRUCTUREBLOCK_MODE: Internal.EnumProperty<Internal.StructureMode>;
    static readonly SLAB_TYPE: Internal.EnumProperty<Internal.SlabType>;
    static readonly EAST_REDSTONE: Internal.EnumProperty<Internal.RedstoneSide>;
    static readonly WATERLOGGED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly BLOOM: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly SHRIEKING: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly AGE_1: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly FACING_HOPPER: (Internal.DirectionProperty) & (Internal.DirectionProperty);
    static readonly VERTICAL_DIRECTION: (Internal.DirectionProperty) & (Internal.DirectionProperty);
    static readonly PICKLES: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly MAX_AGE_25: (25) & (number);
    static readonly LEVEL_HONEY: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly DUSTED: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly MAX_AGE_4: (4) & (number);
    static readonly PISTON_TYPE: Internal.EnumProperty<Internal.PistonType>;
    static readonly HATCH: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly SNOWY: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly TRIGGERED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly CHISELED_BOOKSHELF_SLOT_1_OCCUPIED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly SIGNAL_FIRE: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly LEVEL_CAULDRON: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly AXIS: Internal.EnumProperty<Internal.Direction$Axis>;
    static readonly AGE_2: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly DRAG: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly CAN_SUMMON: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly LEVEL: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly STAGE: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly MAX_AGE_5: (5) & (number);
    static readonly NORTH_WALL: Internal.EnumProperty<Internal.WallSide>;
    static readonly UP: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly CHISELED_BOOKSHELF_SLOT_0_OCCUPIED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly BITES: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly IN_WALL: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly AGE_25: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly STABILITY_MAX_DISTANCE: (7) & (number);
    static readonly HAS_BOTTLE_1: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly AGE_7: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly CHISELED_BOOKSHELF_SLOT_3_OCCUPIED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly SOUTH: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly MAX_AGE_15: (15) & (number);
    static readonly DISARMED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly RAIL_SHAPE: Internal.EnumProperty<Internal.RailShape>;
    static readonly DOOR_HINGE: Internal.EnumProperty<Internal.DoorHingeSide>;
    static readonly LEVEL_COMPOSTER: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly DELAY: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly MIN_LEVEL: (0) & (number);
    static readonly RAIL_SHAPE_STRAIGHT: Internal.EnumProperty<Internal.RailShape>;
    static readonly MIN_LEVEL_CAULDRON: (1) & (number);
    static readonly BOTTOM: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly HAS_BOOK: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly CANDLES: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly NOTEBLOCK_INSTRUMENT: Internal.EnumProperty<Internal.NoteBlockInstrument>;
    static readonly WEST: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly SHORT: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly BERRIES: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly MAX_AGE_2: (2) & (number);
    static readonly HAS_BOTTLE_0: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly WEST_WALL: Internal.EnumProperty<Internal.WallSide>;
    static readonly ROTATION_16: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly MAX_LEVEL_3: (3) & (number);
    static readonly BED_PART: Internal.EnumProperty<Internal.BedPart>;
    static readonly POWERED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly MAX_AGE_3: (3) & (number);
    static readonly OCCUPIED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly DRIPSTONE_THICKNESS: Internal.EnumProperty<Internal.DripstoneThickness>;
    static readonly FACING: (Internal.DirectionProperty) & (Internal.DirectionProperty);
}
type BlockProperties_ = BlockProperties;
declare class Vec3i implements Internal.Comparable<Vec3i> {
    constructor(arg0: number, arg1: number, arg2: number)
    north(): this;
    getClass(): typeof any;
    distToCenterSqr(arg0: Internal.Position_): number;
    getX(): number;
    getY(): number;
    static offsetCodec(arg0: number): Internal.Codec<Vec3i>;
    south(arg0: number): this;
    toShortString(): string;
    above(arg0: number): this;
    notify(): void;
    west(arg0: number): this;
    wait(arg0: number, arg1: number): void;
    compareTo(arg0: any): number;
    east(arg0: number): this;
    distToLowCornerSqr(arg0: number, arg1: number, arg2: number): number;
    "relative(net.minecraft.core.Direction$Axis,int)"(arg0: Internal.Direction$Axis_, arg1: number): this;
    relative(arg0: Internal.Direction_): this;
    multiply(arg0: number): this;
    getZ(): number;
    closerThan(arg0: Vec3i_, arg1: number): boolean;
    below(arg0: number): this;
    offset(arg0: number, arg1: number, arg2: number): this;
    above(): this;
    toString(): string;
    "compareTo(net.minecraft.core.Vec3i)"(arg0: Vec3i_): number;
    east(): this;
    north(arg0: number): this;
    below(): this;
    notifyAll(): void;
    west(): this;
    distManhattan(arg0: Vec3i_): number;
    relative(arg0: Internal.Direction$Axis_, arg1: number): this;
    get(arg0: Internal.Direction$Axis_): number;
    offset(arg0: Vec3i_): this;
    cross(arg0: Vec3i_): this;
    south(): this;
    hashCode(): number;
    distSqr(arg0: Vec3i_): number;
    subtract(arg0: Vec3i_): this;
    relative(arg0: Internal.Direction_, arg1: number): this;
    wait(): void;
    wait(arg0: number): void;
    compareTo(arg0: Vec3i_): number;
    "compareTo(java.lang.Object)"(arg0: any): number;
    equals(arg0: any): boolean;
    closerToCenterThan(arg0: Internal.Position_, arg1: number): boolean;
    "relative(net.minecraft.core.Direction,int)"(arg0: Internal.Direction_, arg1: number): this;
    distToCenterSqr(arg0: number, arg1: number, arg2: number): number;
    get class(): typeof any
    get x(): number
    get y(): number
    get z(): number
    static readonly ZERO: (Vec3i) & (Vec3i);
    static readonly CODEC: Internal.Codec<Vec3i>;
}
type Vec3i_ = Vec3i;
declare class Blocks {
    constructor()
    getClass(): typeof any;
    static register(arg0: string, arg1: Internal.Block_): Internal.Block;
    hashCode(): number;
    toString(): string;
    wait(): void;
    notifyAll(): void;
    wait(arg0: number): void;
    static rebuildCache(): void;
    equals(arg0: any): boolean;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    get class(): typeof any
    static MANGROVE_PROPAGULE: (Internal.MangrovePropaguleBlock) & (Internal.Block);
    static STONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static POTTED_CRIMSON_FUNGUS: (Internal.FlowerPotBlock) & (Internal.Block);
    static DEEPSLATE_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static CHERRY_SAPLING: (Internal.SaplingBlock) & (Internal.Block);
    static POLISHED_ANDESITE: (Internal.Block) & (Internal.Block);
    static RED_NETHER_BRICKS: (Internal.Block) & (Internal.Block);
    static TORCH: (Internal.TorchBlock) & (Internal.Block);
    static COAL_BLOCK: (Internal.Block) & (Internal.Block);
    static STRIPPED_CRIMSON_STEM: (Internal.RotatedPillarBlock) & (Internal.Block);
    static FIRE_CORAL_BLOCK: (Internal.CoralBlock) & (Internal.Block);
    static WEEPING_VINES_PLANT: (Internal.WeepingVinesPlantBlock) & (Internal.Block);
    static PEONY: (Internal.TallFlowerBlock) & (Internal.Block);
    static CARROTS: (Internal.CarrotBlock) & (Internal.Block);
    static YELLOW_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static CYAN_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static BLUE_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static TUBE_CORAL_BLOCK: (Internal.CoralBlock) & (Internal.Block);
    static SMITHING_TABLE: (Internal.SmithingTableBlock) & (Internal.Block);
    static ACACIA_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static MAGENTA_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static POTTED_CHERRY_SAPLING: (Internal.FlowerPotBlock) & (Internal.Block);
    static PLAYER_WALL_HEAD: (Internal.PlayerWallHeadBlock) & (Internal.Block);
    static DEAD_HORN_CORAL_FAN: (Internal.BaseCoralFanBlock) & (Internal.Block);
    static MANGROVE_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static SPRUCE_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static IRON_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static TRIPWIRE: (Internal.TripWireBlock) & (Internal.Block);
    static BLACK_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static LIGHT_BLUE_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static ACACIA_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static CRIMSON_FUNGUS: (Internal.FungusBlock) & (Internal.Block);
    static BUBBLE_CORAL_BLOCK: (Internal.CoralBlock) & (Internal.Block);
    static LIGHT_BLUE_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static PRISMARINE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static DEAD_TUBE_CORAL_WALL_FAN: (Internal.BaseCoralWallFanBlock) & (Internal.Block);
    static PURPLE_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static RED_NETHER_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static SCULK_SENSOR: (Internal.SculkSensorBlock) & (Internal.Block);
    static YELLOW_WOOL: (Internal.Block) & (Internal.Block);
    static MAGENTA_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static SAND: (Internal.SandBlock) & (Internal.Block);
    static MYCELIUM: (Internal.MyceliumBlock) & (Internal.Block);
    static LIGHT_GRAY_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static ORANGE_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static CORNFLOWER: (Internal.FlowerBlock) & (Internal.Block);
    static DARK_OAK_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static GRANITE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static REDSTONE_LAMP: (Internal.RedstoneLampBlock) & (Internal.Block);
    static LIGHT: (Internal.LightBlock) & (Internal.Block);
    static TUBE_CORAL_FAN: (Internal.CoralFanBlock) & (Internal.Block);
    static WARPED_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static DANDELION: (Internal.FlowerBlock) & (Internal.Block);
    static PINK_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static WARPED_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static RED_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static SOUL_SOIL: (Internal.Block) & (Internal.Block);
    static ACACIA_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static CRIMSON_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static HEAVY_WEIGHTED_PRESSURE_PLATE: (Internal.WeightedPressurePlateBlock) & (Internal.Block);
    static PRISMARINE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static TWISTING_VINES_PLANT: (Internal.TwistingVinesPlantBlock) & (Internal.Block);
    static DEEPSLATE_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static WARPED_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static OAK_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static PINK_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static RED_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static WARPED_WART_BLOCK: (Internal.Block) & (Internal.Block);
    static EXPOSED_CUT_COPPER_STAIRS: (Internal.WeatheringCopperStairBlock) & (Internal.Block);
    static COARSE_DIRT: (Internal.Block) & (Internal.Block);
    static DEEPSLATE_REDSTONE_ORE: (Internal.RedStoneOreBlock) & (Internal.Block);
    static TUFF: (Internal.Block) & (Internal.Block);
    static CHISELED_BOOKSHELF: (Internal.ChiseledBookShelfBlock) & (Internal.Block);
    static ACACIA_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static DEEPSLATE_IRON_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static PURPLE_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static LIGHTNING_ROD: (Internal.LightningRodBlock) & (Internal.Block);
    static COBBLED_DEEPSLATE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static RED_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static CHERRY_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static LILY_PAD: (Internal.WaterlilyBlock) & (Internal.Block);
    static GREEN_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static BARRIER: (Internal.BarrierBlock) & (Internal.Block);
    static PINK_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static DRAGON_HEAD: (Internal.SkullBlock) & (Internal.Block);
    static YELLOW_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static DEAD_BUBBLE_CORAL_WALL_FAN: (Internal.BaseCoralWallFanBlock) & (Internal.Block);
    static STRIPPED_BIRCH_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static SEAGRASS: (Internal.SeagrassBlock) & (Internal.Block);
    static CHERRY_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static HORN_CORAL: (Internal.CoralPlantBlock) & (Internal.Block);
    static MOSSY_STONE_BRICKS: (Internal.Block) & (Internal.Block);
    static SPRUCE_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static WAXED_COPPER_BLOCK: (Internal.Block) & (Internal.Block);
    static STONE_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static GRANITE_WALL: (Internal.WallBlock) & (Internal.Block);
    static NETHER_BRICK_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static MOSS_CARPET: (Internal.CarpetBlock) & (Internal.Block);
    static DARK_OAK_PLANKS: (Internal.Block) & (Internal.Block);
    static MAGENTA_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static ANDESITE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static RED_NETHER_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static BIRCH_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static BAMBOO_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static BROWN_CONCRETE: (Internal.Block) & (Internal.Block);
    static DEEPSLATE_DIAMOND_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static BEETROOTS: (Internal.BeetrootBlock) & (Internal.Block);
    static POTTED_BAMBOO: (Internal.FlowerPotBlock) & (Internal.Block);
    static FERN: (Internal.TallGrassBlock) & (Internal.Block);
    static CRIMSON_HYPHAE: (Internal.RotatedPillarBlock) & (Internal.Block);
    static WAXED_CUT_COPPER: (Internal.Block) & (Internal.Block);
    static ACACIA_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static BLACK_WOOL: (Internal.Block) & (Internal.Block);
    static POLISHED_BLACKSTONE_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static BRAIN_CORAL_WALL_FAN: (Internal.CoralWallFanBlock) & (Internal.Block);
    static VINE: (Internal.VineBlock) & (Internal.Block);
    static CHERRY_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static ANDESITE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static INFESTED_DEEPSLATE: (Internal.InfestedRotatedPillarBlock) & (Internal.Block);
    static ACACIA_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static SPONGE: (Internal.SpongeBlock) & (Internal.Block);
    static REDSTONE_ORE: (Internal.RedStoneOreBlock) & (Internal.Block);
    static STRIPPED_ACACIA_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static REDSTONE_WALL_TORCH: (Internal.RedstoneWallTorchBlock) & (Internal.Block);
    static CYAN_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static BLACK_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static CAMPFIRE: (Internal.CampfireBlock) & (Internal.Block);
    static OCHRE_FROGLIGHT: (Internal.RotatedPillarBlock) & (Internal.Block);
    static COBBLESTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static DRAGON_WALL_HEAD: (Internal.WallSkullBlock) & (Internal.Block);
    static POTTED_WITHER_ROSE: (Internal.FlowerPotBlock) & (Internal.Block);
    static BLACKSTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static GRAY_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static CYAN_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static BAMBOO_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static BIRCH_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static POTTED_CORNFLOWER: (Internal.FlowerPotBlock) & (Internal.Block);
    static STICKY_PISTON: (Internal.PistonBaseBlock) & (Internal.Block);
    static LIGHT_BLUE_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static WEATHERED_COPPER: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static CYAN_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static RAW_GOLD_BLOCK: (Internal.Block) & (Internal.Block);
    static STRIPPED_BIRCH_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static LARGE_AMETHYST_BUD: (Internal.AmethystClusterBlock) & (Internal.Block);
    static POLISHED_ANDESITE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static NETHER_PORTAL: (Internal.NetherPortalBlock) & (Internal.Block);
    static JUNGLE_PLANKS: (Internal.Block) & (Internal.Block);
    static PINK_TULIP: (Internal.FlowerBlock) & (Internal.Block);
    static OAK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static STRIPPED_WARPED_HYPHAE: (Internal.RotatedPillarBlock) & (Internal.Block);
    static POTTED_OAK_SAPLING: (Internal.FlowerPotBlock) & (Internal.Block);
    static MANGROVE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static DARK_OAK_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static EXPOSED_CUT_COPPER_SLAB: (Internal.WeatheringCopperSlabBlock) & (Internal.Block);
    static ORANGE_CONCRETE: (Internal.Block) & (Internal.Block);
    static BLUE_ORCHID: (Internal.FlowerBlock) & (Internal.Block);
    static STRIPPED_BAMBOO_BLOCK: (Internal.RotatedPillarBlock) & (Internal.Block);
    static BIRCH_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static GRAY_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static DEEPSLATE_TILES: (Internal.Block) & (Internal.Block);
    static CRIMSON_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static WHITE_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static KELP: (Internal.KelpBlock) & (Internal.Block);
    static BROWN_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static INFESTED_CRACKED_STONE_BRICKS: (Internal.InfestedBlock) & (Internal.Block);
    static JUNGLE_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static LIGHT_GRAY_CONCRETE: (Internal.Block) & (Internal.Block);
    static RED_MUSHROOM_BLOCK: (Internal.HugeMushroomBlock) & (Internal.Block);
    static GRAY_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static MOSS_BLOCK: (Internal.MossBlock) & (Internal.Block);
    static LIME_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static CRIMSON_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static CARVED_PUMPKIN: (Internal.EquipableCarvedPumpkinBlock) & (Internal.Block);
    static POTATOES: (Internal.PotatoBlock) & (Internal.Block);
    static PURPUR_PILLAR: (Internal.RotatedPillarBlock) & (Internal.Block);
    static MUD_BRICKS: (Internal.Block) & (Internal.Block);
    static DEAD_FIRE_CORAL_BLOCK: (Internal.Block) & (Internal.Block);
    static MANGROVE_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static CHERRY_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static NOTE_BLOCK: (Internal.NoteBlock) & (Internal.Block);
    static ENDER_CHEST: (Internal.EnderChestBlock) & (Internal.Block);
    static CYAN_BED: (Internal.BedBlock) & (Internal.Block);
    static DEAD_TUBE_CORAL_FAN: (Internal.BaseCoralFanBlock) & (Internal.Block);
    static BIRCH_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static YELLOW_CONCRETE: (Internal.Block) & (Internal.Block);
    static DEAD_TUBE_CORAL_BLOCK: (Internal.Block) & (Internal.Block);
    static STRIPPED_WARPED_STEM: (Internal.RotatedPillarBlock) & (Internal.Block);
    static LEVER: (Internal.LeverBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE: (Internal.Block) & (Internal.Block);
    static LIGHT_BLUE_CONCRETE: (Internal.Block) & (Internal.Block);
    static POTTED_MANGROVE_PROPAGULE: (Internal.FlowerPotBlock) & (Internal.Block);
    static DROPPER: (Internal.DropperBlock) & (Internal.Block);
    static SPRUCE_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static RED_SANDSTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static CRAFTING_TABLE: (Internal.CraftingTableBlock) & (Internal.Block);
    static SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static GRASS: (Internal.TallGrassBlock) & (Internal.Block);
    static CHERRY_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static MEDIUM_AMETHYST_BUD: (Internal.AmethystClusterBlock) & (Internal.Block);
    static CRIMSON_ROOTS: (Internal.RootsBlock) & (Internal.Block);
    static WITHER_ROSE: (Internal.WitherRoseBlock) & (Internal.Block);
    static OXEYE_DAISY: (Internal.FlowerBlock) & (Internal.Block);
    static OAK_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static EMERALD_BLOCK: (Internal.Block) & (Internal.Block);
    static BUDDING_AMETHYST: (Internal.BuddingAmethystBlock) & (Internal.Block);
    static RAIL: (Internal.RailBlock) & (Internal.Block);
    static JUNGLE_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static BROWN_MUSHROOM_BLOCK: (Internal.HugeMushroomBlock) & (Internal.Block);
    static DARK_OAK_SAPLING: (Internal.SaplingBlock) & (Internal.Block);
    static DIAMOND_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static LADDER: (Internal.LadderBlock) & (Internal.Block);
    static OAK_SAPLING: (Internal.SaplingBlock) & (Internal.Block);
    static MELON: (Internal.MelonBlock) & (Internal.Block);
    static CRIMSON_PLANKS: (Internal.Block) & (Internal.Block);
    static GLOW_LICHEN: (Internal.GlowLichenBlock) & (Internal.Block);
    static REDSTONE_WIRE: (Internal.RedStoneWireBlock) & (Internal.Block);
    static HORN_CORAL_FAN: (Internal.CoralFanBlock) & (Internal.Block);
    static DARK_PRISMARINE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static CAVE_VINES_PLANT: (Internal.CaveVinesPlantBlock) & (Internal.Block);
    static ACACIA_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static YELLOW_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static SMOOTH_SANDSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static COBBLED_DEEPSLATE_WALL: (Internal.WallBlock) & (Internal.Block);
    static CRIMSON_NYLIUM: (Internal.NyliumBlock) & (Internal.Block);
    static POTTED_BLUE_ORCHID: (Internal.FlowerPotBlock) & (Internal.Block);
    static CYAN_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static SCULK_CATALYST: (Internal.SculkCatalystBlock) & (Internal.Block);
    static STRIPPED_MANGROVE_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static DISPENSER: (Internal.DispenserBlock) & (Internal.Block);
    static PRISMARINE_WALL: (Internal.WallBlock) & (Internal.Block);
    static ORANGE_TULIP: (Internal.FlowerBlock) & (Internal.Block);
    static COMMAND_BLOCK: (Internal.CommandBlock) & (Internal.Block);
    static BLACK_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static SPORE_BLOSSOM: (Internal.SporeBlossomBlock) & (Internal.Block);
    static OXIDIZED_CUT_COPPER_STAIRS: (Internal.WeatheringCopperStairBlock) & (Internal.Block);
    static DEEPSLATE_TILE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static JUNGLE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static DIRT_PATH: (Internal.DirtPathBlock) & (Internal.Block);
    static BLUE_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static GREEN_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static HONEYCOMB_BLOCK: (Internal.Block) & (Internal.Block);
    static ICE: (Internal.IceBlock) & (Internal.Block);
    static BAMBOO_MOSAIC_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static POTTED_BIRCH_SAPLING: (Internal.FlowerPotBlock) & (Internal.Block);
    static WHITE_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static WATER: (Internal.LiquidBlock) & (Internal.Block);
    static CRACKED_NETHER_BRICKS: (Internal.Block) & (Internal.Block);
    static WATER_CAULDRON: (Internal.BoilingWaterCauldronBlock) & (Internal.Block);
    static MUD_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static WAXED_CUT_COPPER_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static POLISHED_DEEPSLATE_WALL: (Internal.WallBlock) & (Internal.Block);
    static OAK_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static OAK_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static POTTED_BROWN_MUSHROOM: (Internal.FlowerPotBlock) & (Internal.Block);
    static WARPED_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static JUKEBOX: (Internal.JukeboxBlock) & (Internal.Block);
    static MANGROVE_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static NETHER_BRICKS: (Internal.Block) & (Internal.Block);
    static PLAYER_HEAD: (Internal.PlayerHeadBlock) & (Internal.Block);
    static PURPLE_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static DEAD_TUBE_CORAL: (Internal.BaseCoralPlantBlock) & (Internal.Block);
    static BIRCH_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static POWDER_SNOW_CAULDRON: (Internal.PowderSnowCauldronBlock) & (Internal.Block);
    static BROWN_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static BREWING_STAND: (Internal.BrewingStandBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static REDSTONE_TORCH: (Internal.RedstoneTorchBlock) & (Internal.Block);
    static BAMBOO_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static BLACK_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static POLISHED_GRANITE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static MAGENTA_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static DEAD_BRAIN_CORAL: (Internal.BaseCoralPlantBlock) & (Internal.Block);
    static BLACK_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static NETHER_SPROUTS: (Internal.NetherSproutsBlock) & (Internal.Block);
    static GREEN_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static SPRUCE_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static PURPLE_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static CONDUIT: (Internal.ConduitBlock) & (Internal.Block);
    static ORANGE_WOOL: (Internal.Block) & (Internal.Block);
    static POTTED_WHITE_TULIP: (Internal.FlowerPotBlock) & (Internal.Block);
    static PRISMARINE_BRICKS: (Internal.Block) & (Internal.Block);
    static POLISHED_BLACKSTONE_WALL: (Internal.WallBlock) & (Internal.Block);
    static SEA_LANTERN: (Internal.Block) & (Internal.Block);
    static MAGENTA_BED: (Internal.BedBlock) & (Internal.Block);
    static POLISHED_DEEPSLATE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static STONE_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static SCAFFOLDING: (Internal.ScaffoldingBlock) & (Internal.Block);
    static NETHER_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static DIORITE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static PISTON_HEAD: (Internal.PistonHeadBlock) & (Internal.Block);
    static BLACK_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static PURPLE_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static LIME_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static OAK_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static CUT_RED_SANDSTONE: (Internal.Block) & (Internal.Block);
    static DEAD_FIRE_CORAL_WALL_FAN: (Internal.BaseCoralWallFanBlock) & (Internal.Block);
    static LIME_BED: (Internal.BedBlock) & (Internal.Block);
    static SPAWNER: (Internal.SpawnerBlock) & (Internal.Block);
    static FROSTED_ICE: (Internal.FrostedIceBlock) & (Internal.Block);
    static IRON_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static WARPED_ROOTS: (Internal.RootsBlock) & (Internal.Block);
    static STONE: (Internal.Block) & (Internal.Block);
    static MUD_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static SOUL_LANTERN: (Internal.LanternBlock) & (Internal.Block);
    static COPPER_BLOCK: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static WAXED_OXIDIZED_COPPER: (Internal.Block) & (Internal.Block);
    static WARPED_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static POLISHED_BASALT: (Internal.RotatedPillarBlock) & (Internal.Block);
    static DAYLIGHT_DETECTOR: (Internal.DaylightDetectorBlock) & (Internal.Block);
    static CRIMSON_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static CHERRY_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static GOLD_BLOCK: (Internal.Block) & (Internal.Block);
    static POTTED_LILY_OF_THE_VALLEY: (Internal.FlowerPotBlock) & (Internal.Block);
    static LIGHT_BLUE_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static LIGHT_GRAY_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static DRIPSTONE_BLOCK: (Internal.Block) & (Internal.Block);
    static COBBLED_DEEPSLATE: (Internal.Block) & (Internal.Block);
    static BIG_DRIPLEAF: (Internal.BigDripleafBlock) & (Internal.Block);
    static MANGROVE_LEAVES: (Internal.MangroveLeavesBlock) & (Internal.Block);
    static GRAY_WOOL: (Internal.Block) & (Internal.Block);
    static INFESTED_CHISELED_STONE_BRICKS: (Internal.InfestedBlock) & (Internal.Block);
    static GRAY_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static CHERRY_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static REPEATING_COMMAND_BLOCK: (Internal.CommandBlock) & (Internal.Block);
    static WARPED_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static RED_BED: (Internal.BedBlock) & (Internal.Block);
    static CHERRY_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static POTTED_DANDELION: (Internal.FlowerPotBlock) & (Internal.Block);
    static POTTED_CACTUS: (Internal.FlowerPotBlock) & (Internal.Block);
    static DIORITE_WALL: (Internal.WallBlock) & (Internal.Block);
    static HOPPER: (Internal.HopperBlock) & (Internal.Block);
    static SPRUCE_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static BARREL: (Internal.BarrelBlock) & (Internal.Block);
    static MELON_STEM: (Internal.StemBlock) & (Internal.Block);
    static ROOTED_DIRT: (Internal.RootedDirtBlock) & (Internal.Block);
    static LIGHT_BLUE_WOOL: (Internal.Block) & (Internal.Block);
    static SOUL_WALL_TORCH: (Internal.WallTorchBlock) & (Internal.Block);
    static LAPIS_BLOCK: (Internal.Block) & (Internal.Block);
    static ANDESITE: (Internal.Block) & (Internal.Block);
    static YELLOW_BED: (Internal.BedBlock) & (Internal.Block);
    static END_STONE_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static BLAST_FURNACE: (Internal.BlastFurnaceBlock) & (Internal.Block);
    static SMALL_DRIPLEAF: (Internal.SmallDripleafBlock) & (Internal.Block);
    static KELP_PLANT: (Internal.KelpPlantBlock) & (Internal.Block);
    static RED_SAND: (Internal.SandBlock) & (Internal.Block);
    static JUNGLE_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static QUARTZ_BRICKS: (Internal.Block) & (Internal.Block);
    static CRIMSON_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static ZOMBIE_WALL_HEAD: (Internal.WallSkullBlock) & (Internal.Block);
    static LIME_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static RAW_COPPER_BLOCK: (Internal.Block) & (Internal.Block);
    static CHERRY_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static ORANGE_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static LOOM: (Internal.LoomBlock) & (Internal.Block);
    static GREEN_WOOL: (Internal.Block) & (Internal.Block);
    static BROWN_WOOL: (Internal.Block) & (Internal.Block);
    static LIGHT_GRAY_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static PIGLIN_WALL_HEAD: (Internal.PiglinWallSkullBlock) & (Internal.Block);
    static BLUE_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static PINK_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static SMOKER: (Internal.SmokerBlock) & (Internal.Block);
    static ANVIL: (Internal.AnvilBlock) & (Internal.Block);
    static BROWN_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static FLOWER_POT: (Internal.FlowerPotBlock) & (Internal.Block);
    static LIGHT_BLUE_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static STONECUTTER: (Internal.StonecutterBlock) & (Internal.Block);
    static CUT_RED_SANDSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static RED_CONCRETE: (Internal.Block) & (Internal.Block);
    static DARK_OAK_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static GREEN_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static BAMBOO: (Internal.BambooStalkBlock) & (Internal.Block);
    static DEAD_HORN_CORAL_BLOCK: (Internal.Block) & (Internal.Block);
    static DARK_OAK_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static MAGENTA_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static DARK_OAK_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static CHISELED_RED_SANDSTONE: (Internal.Block) & (Internal.Block);
    static CRIMSON_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static PITCHER_CROP: (Internal.PitcherCropBlock) & (Internal.Block);
    static CHERRY_LEAVES: (Internal.CherryLeavesBlock) & (Internal.Block);
    static RED_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static QUARTZ_PILLAR: (Internal.RotatedPillarBlock) & (Internal.Block);
    static CHISELED_POLISHED_BLACKSTONE: (Internal.Block) & (Internal.Block);
    static DEAD_FIRE_CORAL: (Internal.BaseCoralPlantBlock) & (Internal.Block);
    static PURPLE_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static RED_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static AMETHYST_CLUSTER: (Internal.AmethystClusterBlock) & (Internal.Block);
    static DARK_PRISMARINE: (Internal.Block) & (Internal.Block);
    static MANGROVE_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static SCULK_VEIN: (Internal.SculkVeinBlock) & (Internal.Block);
    static JUNGLE_SAPLING: (Internal.SaplingBlock) & (Internal.Block);
    static YELLOW_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static OBSERVER: (Internal.ObserverBlock) & (Internal.Block);
    static END_STONE_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static SPRUCE_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static MANGROVE_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static WAXED_EXPOSED_CUT_COPPER: (Internal.Block) & (Internal.Block);
    static STONE_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static BAMBOO_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static STONE_BRICKS: (Internal.Block) & (Internal.Block);
    static SPRUCE_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static NETHER_WART: (Internal.NetherWartBlock) & (Internal.Block);
    static WAXED_OXIDIZED_CUT_COPPER_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static RED_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static OBSIDIAN: (Internal.Block) & (Internal.Block);
    static PURPLE_CONCRETE: (Internal.Block) & (Internal.Block);
    static BLACK_CONCRETE: (Internal.Block) & (Internal.Block);
    static WARPED_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static REINFORCED_DEEPSLATE: (Internal.Block) & (Internal.Block);
    static DRAGON_EGG: (Internal.DragonEggBlock) & (Internal.Block);
    static PACKED_MUD: (Internal.Block) & (Internal.Block);
    static ACACIA_PLANKS: (Internal.Block) & (Internal.Block);
    static RED_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static DARK_OAK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static MOSSY_STONE_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static LIGHT_WEIGHTED_PRESSURE_PLATE: (Internal.WeightedPressurePlateBlock) & (Internal.Block);
    static FIRE_CORAL_FAN: (Internal.CoralFanBlock) & (Internal.Block);
    static QUARTZ_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static PURPUR_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static STONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static STRIPPED_JUNGLE_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static RED_WOOL: (Internal.Block) & (Internal.Block);
    static FARMLAND: (Internal.FarmBlock) & (Internal.Block);
    static DARK_OAK_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static ORANGE_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static DEEPSLATE_GOLD_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static LIGHT_BLUE_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static BRICKS: (Internal.Block) & (Internal.Block);
    static WAXED_EXPOSED_CUT_COPPER_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static MOSSY_COBBLESTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static CAKE: (Internal.CakeBlock) & (Internal.Block);
    static GREEN_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static JUNGLE_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static BLUE_BED: (Internal.BedBlock) & (Internal.Block);
    static OAK_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static MANGROVE_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static DEEPSLATE_BRICKS: (Internal.Block) & (Internal.Block);
    static BASALT: (Internal.RotatedPillarBlock) & (Internal.Block);
    static REPEATER: (Internal.RepeaterBlock) & (Internal.Block);
    static PURPLE_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static AZURE_BLUET: (Internal.FlowerBlock) & (Internal.Block);
    static LILY_OF_THE_VALLEY: (Internal.FlowerBlock) & (Internal.Block);
    static STONE_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static BIRCH_SAPLING: (Internal.SaplingBlock) & (Internal.Block);
    static BIRCH_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static LIGHT_BLUE_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static BROWN_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static FIRE_CORAL: (Internal.CoralPlantBlock) & (Internal.Block);
    static SANDSTONE_WALL: (Internal.WallBlock) & (Internal.Block);
    static RESPAWN_ANCHOR: (Internal.RespawnAnchorBlock) & (Internal.Block);
    static PRISMARINE_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static NETHER_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static NETHERRACK: (Internal.NetherrackBlock) & (Internal.Block);
    static CAVE_VINES: (Internal.CaveVinesBlock) & (Internal.Block);
    static WARPED_NYLIUM: (Internal.NyliumBlock) & (Internal.Block);
    static POTTED_POPPY: (Internal.FlowerPotBlock) & (Internal.Block);
    static POINTED_DRIPSTONE: (Internal.PointedDripstoneBlock) & (Internal.Block);
    static ORANGE_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static LIGHT_GRAY_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static WAXED_WEATHERED_CUT_COPPER_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE_BRICKS: (Internal.Block) & (Internal.Block);
    static GLASS: (Internal.GlassBlock) & (Internal.Block);
    static WARPED_PLANKS: (Internal.Block) & (Internal.Block);
    static WET_SPONGE: (Internal.WetSpongeBlock) & (Internal.Block);
    static GRASS_BLOCK: (Internal.GrassBlock) & (Internal.Block);
    static COAL_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static PURPUR_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static WARPED_STEM: (Internal.RotatedPillarBlock) & (Internal.Block);
    static DEEPSLATE_COPPER_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static POLISHED_DIORITE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static ANCIENT_DEBRIS: (Internal.Block) & (Internal.Block);
    static GRAY_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static DEAD_BRAIN_CORAL_WALL_FAN: (Internal.BaseCoralWallFanBlock) & (Internal.Block);
    static WHITE_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static END_STONE_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static PODZOL: (Internal.SnowyDirtBlock) & (Internal.Block);
    static CHERRY_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static COMPARATOR: (Internal.ComparatorBlock) & (Internal.Block);
    static ACACIA_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static CHISELED_STONE_BRICKS: (Internal.Block) & (Internal.Block);
    static WAXED_WEATHERED_COPPER: (Internal.Block) & (Internal.Block);
    static SUGAR_CANE: (Internal.SugarCaneBlock) & (Internal.Block);
    static DEAD_BRAIN_CORAL_BLOCK: (Internal.Block) & (Internal.Block);
    static NETHERITE_BLOCK: (Internal.Block) & (Internal.Block);
    static OAK_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static WHITE_CONCRETE: (Internal.Block) & (Internal.Block);
    static POTTED_AZURE_BLUET: (Internal.FlowerPotBlock) & (Internal.Block);
    static SANDSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static ORANGE_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static ORANGE_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static BRAIN_CORAL_FAN: (Internal.CoralFanBlock) & (Internal.Block);
    static PINK_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static OXIDIZED_CUT_COPPER: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static GRAY_BED: (Internal.BedBlock) & (Internal.Block);
    static GLASS_PANE: (Internal.IronBarsBlock) & (Internal.Block);
    static GRAVEL: (Internal.GravelBlock) & (Internal.Block);
    static BAMBOO_MOSAIC: (Internal.Block) & (Internal.Block);
    static SUSPICIOUS_GRAVEL: (Internal.BrushableBlock) & (Internal.Block);
    static ENCHANTING_TABLE: (Internal.EnchantmentTableBlock) & (Internal.Block);
    static LILAC: (Internal.TallFlowerBlock) & (Internal.Block);
    static STRIPPED_SPRUCE_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static MANGROVE_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static RED_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static STRIPPED_JUNGLE_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static ALLIUM: (Internal.FlowerBlock) & (Internal.Block);
    static MUD_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static DEAD_BRAIN_CORAL_FAN: (Internal.BaseCoralFanBlock) & (Internal.Block);
    static LIGHT_GRAY_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static ZOMBIE_HEAD: (Internal.SkullBlock) & (Internal.Block);
    static WHITE_TULIP: (Internal.FlowerBlock) & (Internal.Block);
    static PINK_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static MOSSY_COBBLESTONE_WALL: (Internal.WallBlock) & (Internal.Block);
    static CRACKED_DEEPSLATE_BRICKS: (Internal.Block) & (Internal.Block);
    static WHITE_WOOL: (Internal.Block) & (Internal.Block);
    static GREEN_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static GRAY_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static BLACK_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static TUBE_CORAL: (Internal.CoralPlantBlock) & (Internal.Block);
    static JUNGLE_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static CUT_SANDSTONE: (Internal.Block) & (Internal.Block);
    static POLISHED_GRANITE: (Internal.Block) & (Internal.Block);
    static DARK_OAK_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static SKELETON_WALL_SKULL: (Internal.WallSkullBlock) & (Internal.Block);
    static TALL_GRASS: (Internal.DoublePlantBlock) & (Internal.Block);
    static POTTED_JUNGLE_SAPLING: (Internal.FlowerPotBlock) & (Internal.Block);
    static YELLOW_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static PEARLESCENT_FROGLIGHT: (Internal.RotatedPillarBlock) & (Internal.Block);
    static DARK_OAK_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static MAGENTA_WOOL: (Internal.Block) & (Internal.Block);
    static PUMPKIN_STEM: (Internal.StemBlock) & (Internal.Block);
    static MUD: (Internal.MudBlock) & (Internal.Block);
    static GRINDSTONE: (Internal.GrindstoneBlock) & (Internal.Block);
    static LIGHT_BLUE_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static BAMBOO_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static BLUE_ICE: (Internal.HalfTransparentBlock) & (Internal.Block);
    static BROWN_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static FLOWERING_AZALEA: (Internal.AzaleaBlock) & (Internal.Block);
    static CHERRY_PLANKS: (Internal.Block) & (Internal.Block);
    static PACKED_ICE: (Internal.Block) & (Internal.Block);
    static ACACIA_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static GRAY_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static DARK_OAK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static BLUE_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static ORANGE_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static BEEHIVE: (Internal.BeehiveBlock) & (Internal.Block);
    static PURPLE_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static BLUE_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static BLACK_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static WHITE_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static NETHER_GOLD_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static LODESTONE: (Internal.Block) & (Internal.Block);
    static WEEPING_VINES: (Internal.WeepingVinesBlock) & (Internal.Block);
    static MAGENTA_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static OAK_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static END_PORTAL: (Internal.EndPortalBlock) & (Internal.Block);
    static TINTED_GLASS: (Internal.TintedGlassBlock) & (Internal.Block);
    static LIME_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static SKELETON_SKULL: (Internal.SkullBlock) & (Internal.Block);
    static LIME_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static END_STONE: (Internal.Block) & (Internal.Block);
    static JUNGLE_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static TWISTING_VINES: (Internal.TwistingVinesBlock) & (Internal.Block);
    static END_PORTAL_FRAME: (Internal.EndPortalFrameBlock) & (Internal.Block);
    static CRIMSON_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static SPRUCE_PLANKS: (Internal.Block) & (Internal.Block);
    static POLISHED_GRANITE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static YELLOW_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static SNIFFER_EGG: (Internal.SnifferEggBlock) & (Internal.Block);
    static MOSSY_COBBLESTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static CHERRY_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static ORANGE_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static LIGHT_BLUE_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static ACACIA_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static GRAY_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static GRAY_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static BIRCH_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static CRACKED_DEEPSLATE_TILES: (Internal.Block) & (Internal.Block);
    static HANGING_ROOTS: (Internal.HangingRootsBlock) & (Internal.Block);
    static TURTLE_EGG: (Internal.TurtleEggBlock) & (Internal.Block);
    static BLACKSTONE_WALL: (Internal.WallBlock) & (Internal.Block);
    static SMOOTH_RED_SANDSTONE: (Internal.Block) & (Internal.Block);
    static BAMBOO_SAPLING: (Internal.BambooSaplingBlock) & (Internal.Block);
    static WAXED_OXIDIZED_CUT_COPPER_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static WHITE_BED: (Internal.BedBlock) & (Internal.Block);
    static CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static DETECTOR_RAIL: (Internal.DetectorRailBlock) & (Internal.Block);
    static COPPER_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static CAULDRON: (Internal.CauldronBlock) & (Internal.Block);
    static LANTERN: (Internal.LanternBlock) & (Internal.Block);
    static GLOWSTONE: (Internal.Block) & (Internal.Block);
    static YELLOW_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static VOID_AIR: (Internal.AirBlock) & (Internal.Block);
    static PURPUR_BLOCK: (Internal.Block) & (Internal.Block);
    static INFESTED_STONE: (Internal.InfestedBlock) & (Internal.Block);
    static CHAIN: (Internal.ChainBlock) & (Internal.Block);
    static STRIPPED_SPRUCE_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static OAK_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static OAK_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static MAGMA_BLOCK: (Internal.MagmaBlock) & (Internal.Block);
    static DIORITE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static RED_SANDSTONE_WALL: (Internal.WallBlock) & (Internal.Block);
    static LAPIS_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static SPRUCE_SAPLING: (Internal.SaplingBlock) & (Internal.Block);
    static SMOOTH_STONE: (Internal.Block) & (Internal.Block);
    static BUBBLE_COLUMN: (Internal.BubbleColumnBlock) & (Internal.Block);
    static CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static POLISHED_DIORITE: (Internal.Block) & (Internal.Block);
    static BIRCH_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static AIR: (Internal.AirBlock) & (Internal.Block);
    static AZALEA_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static WHITE_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static CAVE_AIR: (Internal.AirBlock) & (Internal.Block);
    static MOSSY_COBBLESTONE: (Internal.Block) & (Internal.Block);
    static OAK_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static BAMBOO_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static EMERALD_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static CYAN_WOOL: (Internal.Block) & (Internal.Block);
    static BIRCH_PLANKS: (Internal.Block) & (Internal.Block);
    static POTTED_ORANGE_TULIP: (Internal.FlowerPotBlock) & (Internal.Block);
    static POTTED_WARPED_ROOTS: (Internal.FlowerPotBlock) & (Internal.Block);
    static SPRUCE_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static DARK_PRISMARINE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static SMALL_AMETHYST_BUD: (Internal.AmethystClusterBlock) & (Internal.Block);
    static SPRUCE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static WITHER_SKELETON_SKULL: (Internal.WitherSkullBlock) & (Internal.Block);
    static BUBBLE_CORAL_FAN: (Internal.CoralFanBlock) & (Internal.Block);
    static CREEPER_WALL_HEAD: (Internal.WallSkullBlock) & (Internal.Block);
    static STRIPPED_OAK_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static ACACIA_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static CHAIN_COMMAND_BLOCK: (Internal.CommandBlock) & (Internal.Block);
    static PIGLIN_HEAD: (Internal.SkullBlock) & (Internal.Block);
    static MANGROVE_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static INFESTED_MOSSY_STONE_BRICKS: (Internal.InfestedBlock) & (Internal.Block);
    static BROWN_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static BLUE_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static ACACIA_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static CYAN_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static FLETCHING_TABLE: (Internal.FletchingTableBlock) & (Internal.Block);
    static TORCHFLOWER_CROP: (Internal.TorchflowerCropBlock) & (Internal.Block);
    static GRAY_CONCRETE: (Internal.Block) & (Internal.Block);
    static WARPED_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static HORN_CORAL_WALL_FAN: (Internal.CoralWallFanBlock) & (Internal.Block);
    static BROWN_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static END_GATEWAY: (Internal.EndGatewayBlock) & (Internal.Block);
    static DEEPSLATE_TILE_WALL: (Internal.WallBlock) & (Internal.Block);
    static POTTED_ALLIUM: (Internal.FlowerPotBlock) & (Internal.Block);
    static COBBLESTONE: (Internal.Block) & (Internal.Block);
    static OAK_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static CALCITE: (Internal.Block) & (Internal.Block);
    static MANGROVE_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static POTTED_OXEYE_DAISY: (Internal.FlowerPotBlock) & (Internal.Block);
    static FIRE_CORAL_WALL_FAN: (Internal.CoralWallFanBlock) & (Internal.Block);
    static OAK_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static STRIPPED_CRIMSON_HYPHAE: (Internal.RotatedPillarBlock) & (Internal.Block);
    static BIRCH_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static TERRACOTTA: (Internal.Block) & (Internal.Block);
    static JUNGLE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static NETHER_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static CYAN_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static BAMBOO_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static END_ROD: (Internal.EndRodBlock) & (Internal.Block);
    static LIGHT_BLUE_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static SMOOTH_QUARTZ: (Internal.Block) & (Internal.Block);
    static PRISMARINE: (Internal.Block) & (Internal.Block);
    static SMOOTH_QUARTZ_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static NETHER_QUARTZ_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static MUDDY_MANGROVE_ROOTS: (Internal.RotatedPillarBlock) & (Internal.Block);
    static LIGHT_GRAY_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static MANGROVE_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static DEEPSLATE_TILE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static ATTACHED_PUMPKIN_STEM: (Internal.AttachedStemBlock) & (Internal.Block);
    static CYAN_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static OXIDIZED_COPPER: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static POLISHED_DEEPSLATE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static POLISHED_DEEPSLATE: (Internal.Block) & (Internal.Block);
    static COCOA: (Internal.CocoaBlock) & (Internal.Block);
    static JUNGLE_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static BIRCH_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static SPRUCE_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static POTTED_RED_MUSHROOM: (Internal.FlowerPotBlock) & (Internal.Block);
    static MAGENTA_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static JUNGLE_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static WARPED_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static CRIMSON_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static CHEST: (Internal.ChestBlock) & (Internal.Block);
    static SPRUCE_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static PINK_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static BLACKSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static LIME_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static GILDED_BLACKSTONE: (Internal.Block) & (Internal.Block);
    static SUNFLOWER: (Internal.TallFlowerBlock) & (Internal.Block);
    static ORANGE_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static VERDANT_FROGLIGHT: (Internal.RotatedPillarBlock) & (Internal.Block);
    static PETRIFIED_OAK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static RED_NETHER_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static DRIED_KELP_BLOCK: (Internal.Block) & (Internal.Block);
    static BONE_BLOCK: (Internal.RotatedPillarBlock) & (Internal.Block);
    static WHITE_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static POTTED_SPRUCE_SAPLING: (Internal.FlowerPotBlock) & (Internal.Block);
    static DEAD_HORN_CORAL: (Internal.BaseCoralPlantBlock) & (Internal.Block);
    static BUBBLE_CORAL: (Internal.CoralPlantBlock) & (Internal.Block);
    static GREEN_CONCRETE: (Internal.Block) & (Internal.Block);
    static CHORUS_FLOWER: (Internal.ChorusFlowerBlock) & (Internal.Block);
    static GRAY_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static SMOOTH_SANDSTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static RED_SANDSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static YELLOW_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static LIGHT_GRAY_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static PINK_WOOL: (Internal.Block) & (Internal.Block);
    static PINK_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static CYAN_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static DARK_OAK_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static POWERED_RAIL: (Internal.PoweredRailBlock) & (Internal.Block);
    static LIGHT_BLUE_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static POWDER_SNOW: (Internal.PowderSnowBlock) & (Internal.Block);
    static ORANGE_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static PINK_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static BLACK_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static SPRUCE_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static GRAY_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static WARPED_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static JIGSAW: (Internal.JigsawBlock) & (Internal.Block);
    static WHITE_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static SPRUCE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static LIGHT_GRAY_WOOL: (Internal.Block) & (Internal.Block);
    static PISTON: (Internal.PistonBaseBlock) & (Internal.Block);
    static SMOOTH_RED_SANDSTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static CUT_COPPER_STAIRS: (Internal.WeatheringCopperStairBlock) & (Internal.Block);
    static DIRT: (Internal.Block) & (Internal.Block);
    static BLUE_CONCRETE: (Internal.Block) & (Internal.Block);
    static RED_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static DEAD_BUBBLE_CORAL_FAN: (Internal.BaseCoralFanBlock) & (Internal.Block);
    static OXIDIZED_CUT_COPPER_SLAB: (Internal.WeatheringCopperSlabBlock) & (Internal.Block);
    static TALL_SEAGRASS: (Internal.TallSeagrassBlock) & (Internal.Block);
    static CHORUS_PLANT: (Internal.ChorusPlantBlock) & (Internal.Block);
    static PINK_CONCRETE: (Internal.Block) & (Internal.Block);
    static WHITE_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static MOVING_PISTON: (Internal.MovingPistonBlock) & (Internal.Block);
    static CHERRY_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static MANGROVE_ROOTS: (Internal.MangroveRootsBlock) & (Internal.Block);
    static POTTED_ACACIA_SAPLING: (Internal.FlowerPotBlock) & (Internal.Block);
    static MANGROVE_PLANKS: (Internal.Block) & (Internal.Block);
    static ACACIA_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static WAXED_OXIDIZED_CUT_COPPER: (Internal.Block) & (Internal.Block);
    static BAMBOO_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static RED_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static BLUE_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static BELL: (Internal.BellBlock) & (Internal.Block);
    static MUSHROOM_STEM: (Internal.HugeMushroomBlock) & (Internal.Block);
    static EXPOSED_COPPER: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static CYAN_CONCRETE: (Internal.Block) & (Internal.Block);
    static POTTED_CRIMSON_ROOTS: (Internal.FlowerPotBlock) & (Internal.Block);
    static GREEN_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static CHISELED_QUARTZ_BLOCK: (Internal.Block) & (Internal.Block);
    static JUNGLE_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static FROGSPAWN: (Internal.FrogspawnBlock) & (Internal.Block);
    static SOUL_TORCH: (Internal.TorchBlock) & (Internal.Block);
    static BOOKSHELF: (Internal.Block) & (Internal.Block);
    static WAXED_EXPOSED_COPPER: (Internal.Block) & (Internal.Block);
    static CRIMSON_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static DIAMOND_BLOCK: (Internal.Block) & (Internal.Block);
    static RED_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static CRIMSON_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static SANDSTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static MAGENTA_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static STRIPPED_DARK_OAK_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static DEAD_BUBBLE_CORAL_BLOCK: (Internal.Block) & (Internal.Block);
    static SPRUCE_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static BLUE_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static STRIPPED_CHERRY_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static CALIBRATED_SCULK_SENSOR: (Internal.CalibratedSculkSensorBlock) & (Internal.Block);
    static AMETHYST_BLOCK: (Internal.AmethystBlock) & (Internal.Block);
    static STRUCTURE_BLOCK: (Internal.StructureBlock) & (Internal.Block);
    static BAMBOO_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static BRAIN_CORAL_BLOCK: (Internal.CoralBlock) & (Internal.Block);
    static BAMBOO_MOSAIC_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static STRIPPED_DARK_OAK_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static SMOOTH_SANDSTONE: (Internal.Block) & (Internal.Block);
    static WAXED_EXPOSED_CUT_COPPER_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static BLUE_WOOL: (Internal.Block) & (Internal.Block);
    static IRON_BARS: (Internal.IronBarsBlock) & (Internal.Block);
    static IRON_BLOCK: (Internal.Block) & (Internal.Block);
    static SUSPICIOUS_SAND: (Internal.BrushableBlock) & (Internal.Block);
    static HORN_CORAL_BLOCK: (Internal.CoralBlock) & (Internal.Block);
    static MAGENTA_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static HONEY_BLOCK: (Internal.HoneyBlock) & (Internal.Block);
    static END_STONE_BRICKS: (Internal.Block) & (Internal.Block);
    static JACK_O_LANTERN: (Internal.CarvedPumpkinBlock) & (Internal.Block);
    static TARGET: (Internal.TargetBlock) & (Internal.Block);
    static BRAIN_CORAL: (Internal.CoralPlantBlock) & (Internal.Block);
    static DEAD_FIRE_CORAL_FAN: (Internal.BaseCoralFanBlock) & (Internal.Block);
    static MOSSY_STONE_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static BLUE_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static WITHER_SKELETON_WALL_SKULL: (Internal.WitherWallSkullBlock) & (Internal.Block);
    static CUT_COPPER: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static BIRCH_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static ROSE_BUSH: (Internal.TallFlowerBlock) & (Internal.Block);
    static YELLOW_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static LECTERN: (Internal.LecternBlock) & (Internal.Block);
    static CRIMSON_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static DAMAGED_ANVIL: (Internal.AnvilBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static POLISHED_DIORITE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static HAY_BLOCK: (Internal.HayBlock) & (Internal.Block);
    static WARPED_HYPHAE: (Internal.RotatedPillarBlock) & (Internal.Block);
    static CHERRY_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static MANGROVE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static WEATHERED_CUT_COPPER_SLAB: (Internal.WeatheringCopperSlabBlock) & (Internal.Block);
    static LIME_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static TRIPWIRE_HOOK: (Internal.TripWireHookBlock) & (Internal.Block);
    static CLAY: (Internal.Block) & (Internal.Block);
    static SNOW: (Internal.SnowLayerBlock) & (Internal.Block);
    static WHEAT: (Internal.CropBlock) & (Internal.Block);
    static CYAN_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static WEATHERED_CUT_COPPER: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static BROWN_MUSHROOM: (Internal.MushroomBlock) & (Internal.Block);
    static SHROOMLIGHT: (Internal.Block) & (Internal.Block);
    static CRIMSON_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static PRISMARINE_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static POPPY: (Internal.FlowerBlock) & (Internal.Block);
    static STRUCTURE_VOID: (Internal.StructureVoidBlock) & (Internal.Block);
    static ORANGE_BED: (Internal.BedBlock) & (Internal.Block);
    static DEEPSLATE_COAL_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static PURPLE_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static CUT_COPPER_SLAB: (Internal.WeatheringCopperSlabBlock) & (Internal.Block);
    static REDSTONE_BLOCK: (Internal.PoweredBlock) & (Internal.Block);
    static BLACK_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static WAXED_CUT_COPPER_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static GREEN_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static POTTED_AZALEA: (Internal.FlowerPotBlock) & (Internal.Block);
    static LIME_CONCRETE: (Internal.Block) & (Internal.Block);
    static BAMBOO_BLOCK: (Internal.RotatedPillarBlock) & (Internal.Block);
    static PURPLE_WOOL: (Internal.Block) & (Internal.Block);
    static SOUL_FIRE: (Internal.SoulFireBlock) & (Internal.Block);
    static CHISELED_NETHER_BRICKS: (Internal.Block) & (Internal.Block);
    static CRACKED_POLISHED_BLACKSTONE_BRICKS: (Internal.Block) & (Internal.Block);
    static PINK_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static CARTOGRAPHY_TABLE: (Internal.CartographyTableBlock) & (Internal.Block);
    static BLACK_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static GREEN_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static CYAN_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static QUARTZ_BLOCK: (Internal.Block) & (Internal.Block);
    static BAMBOO_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static WHITE_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static WAXED_WEATHERED_CUT_COPPER: (Internal.Block) & (Internal.Block);
    static WARPED_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static COMPOSTER: (Internal.ComposterBlock) & (Internal.Block);
    static DARK_OAK_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static ACACIA_SAPLING: (Internal.SaplingBlock) & (Internal.Block);
    static PITCHER_PLANT: (Internal.DoublePlantBlock) & (Internal.Block);
    static CHISELED_SANDSTONE: (Internal.Block) & (Internal.Block);
    static POTTED_PINK_TULIP: (Internal.FlowerPotBlock) & (Internal.Block);
    static LARGE_FERN: (Internal.DoublePlantBlock) & (Internal.Block);
    static TNT: (Internal.TntBlock) & (Internal.Block);
    static COBBLED_DEEPSLATE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static WARPED_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static SMOOTH_QUARTZ_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static LAVA_CAULDRON: (Internal.LavaCauldronBlock) & (Internal.Block);
    static SCULK_SHRIEKER: (Internal.SculkShriekerBlock) & (Internal.Block);
    static BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static CHISELED_DEEPSLATE: (Internal.Block) & (Internal.Block);
    static AZALEA: (Internal.AzaleaBlock) & (Internal.Block);
    static SMOOTH_STONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static JUNGLE_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static LIME_WOOL: (Internal.Block) & (Internal.Block);
    static LIME_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static GREEN_BED: (Internal.BedBlock) & (Internal.Block);
    static ACTIVATOR_RAIL: (Internal.PoweredRailBlock) & (Internal.Block);
    static SEA_PICKLE: (Internal.SeaPickleBlock) & (Internal.Block);
    static PINK_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static BLUE_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static WEATHERED_CUT_COPPER_STAIRS: (Internal.WeatheringCopperStairBlock) & (Internal.Block);
    static CRACKED_STONE_BRICKS: (Internal.Block) & (Internal.Block);
    static FURNACE: (Internal.FurnaceBlock) & (Internal.Block);
    static COBBLESTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static MANGROVE_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static CHERRY_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static BAMBOO_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static LIGHT_GRAY_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static MANGROVE_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static COBBLESTONE_WALL: (Internal.WallBlock) & (Internal.Block);
    static BEDROCK: (Internal.Block) & (Internal.Block);
    static BIRCH_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static PURPLE_BED: (Internal.BedBlock) & (Internal.Block);
    static LIME_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static RED_SANDSTONE: (Internal.Block) & (Internal.Block);
    static GOLD_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static SCULK: (Internal.SculkBlock) & (Internal.Block);
    static ACACIA_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static COBWEB: (Internal.WebBlock) & (Internal.Block);
    static CRIMSON_STEM: (Internal.RotatedPillarBlock) & (Internal.Block);
    static PINK_BED: (Internal.BedBlock) & (Internal.Block);
    static STRIPPED_ACACIA_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static BEE_NEST: (Internal.BeehiveBlock) & (Internal.Block);
    static LAVA: (Internal.LiquidBlock) & (Internal.Block);
    static POTTED_WARPED_FUNGUS: (Internal.FlowerPotBlock) & (Internal.Block);
    static NETHER_WART_BLOCK: (Internal.Block) & (Internal.Block);
    static TORCHFLOWER: (Internal.FlowerBlock) & (Internal.Block);
    static ATTACHED_MELON_STEM: (Internal.AttachedStemBlock) & (Internal.Block);
    static DEEPSLATE_EMERALD_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static BROWN_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static POTTED_DARK_OAK_SAPLING: (Internal.FlowerPotBlock) & (Internal.Block);
    static POTTED_FERN: (Internal.FlowerPotBlock) & (Internal.Block);
    static PUMPKIN: (Internal.PumpkinBlock) & (Internal.Block);
    static EXPOSED_CUT_COPPER: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static RED_MUSHROOM: (Internal.MushroomBlock) & (Internal.Block);
    static BROWN_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static PURPLE_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static ORANGE_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static RAW_IRON_BLOCK: (Internal.Block) & (Internal.Block);
    static WALL_TORCH: (Internal.WallTorchBlock) & (Internal.Block);
    static CACTUS: (Internal.CactusBlock) & (Internal.Block);
    static FIRE: (Internal.FireBlock) & (Internal.Block);
    static SLIME_BLOCK: (Internal.SlimeBlock) & (Internal.Block);
    static CHIPPED_ANVIL: (Internal.AnvilBlock) & (Internal.Block);
    static QUARTZ_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static LIGHT_BLUE_BED: (Internal.BedBlock) & (Internal.Block);
    static GREEN_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static JUNGLE_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static SOUL_SAND: (Internal.SoulSandBlock) & (Internal.Block);
    static CUT_SANDSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static MAGENTA_CONCRETE: (Internal.Block) & (Internal.Block);
    static GRANITE: (Internal.Block) & (Internal.Block);
    static LIGHT_GRAY_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static SMOOTH_BASALT: (Internal.Block) & (Internal.Block);
    static DEAD_BUSH: (Internal.DeadBushBlock) & (Internal.Block);
    static DARK_OAK_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static SOUL_CAMPFIRE: (Internal.CampfireBlock) & (Internal.Block);
    static MAGENTA_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static SPRUCE_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static CREEPER_HEAD: (Internal.SkullBlock) & (Internal.Block);
    static BROWN_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static YELLOW_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static DEAD_BUBBLE_CORAL: (Internal.BaseCoralPlantBlock) & (Internal.Block);
    static BLUE_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static JUNGLE_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static LIME_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static ACACIA_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static MOSSY_STONE_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static TUBE_CORAL_WALL_FAN: (Internal.CoralWallFanBlock) & (Internal.Block);
    static BROWN_BED: (Internal.BedBlock) & (Internal.Block);
    static PURPLE_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static LIGHT_GRAY_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static BIG_DRIPLEAF_STEM: (Internal.BigDripleafStemBlock) & (Internal.Block);
    static LIME_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static WARPED_FUNGUS: (Internal.FungusBlock) & (Internal.Block);
    static WHITE_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static DARK_OAK_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static STRIPPED_MANGROVE_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static CRYING_OBSIDIAN: (Internal.CryingObsidianBlock) & (Internal.Block);
    static WAXED_WEATHERED_CUT_COPPER_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static MAGENTA_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static POTTED_TORCHFLOWER: (Internal.FlowerPotBlock) & (Internal.Block);
    static STONE_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static IRON_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static TRAPPED_CHEST: (Internal.TrappedChestBlock) & (Internal.Block);
    static LIGHT_GRAY_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static OAK_PLANKS: (Internal.Block) & (Internal.Block);
    static FLOWERING_AZALEA_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static POTTED_FLOWERING_AZALEA: (Internal.FlowerPotBlock) & (Internal.Block);
    static POLISHED_ANDESITE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static BUBBLE_CORAL_WALL_FAN: (Internal.CoralWallFanBlock) & (Internal.Block);
    static ANDESITE_WALL: (Internal.WallBlock) & (Internal.Block);
    static YELLOW_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static BIRCH_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static DEEPSLATE_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static SMOOTH_RED_SANDSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static BLACKSTONE: (Internal.Block) & (Internal.Block);
    static LIGHT_GRAY_BED: (Internal.BedBlock) & (Internal.Block);
    static STRIPPED_OAK_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static PINK_PETALS: (Internal.PinkPetalsBlock) & (Internal.Block);
    static DIORITE: (Internal.Block) & (Internal.Block);
    static SWEET_BERRY_BUSH: (Internal.SweetBerryBushBlock) & (Internal.Block);
    static DECORATED_POT: (Internal.DecoratedPotBlock) & (Internal.Block);
    static INFESTED_STONE_BRICKS: (Internal.InfestedBlock) & (Internal.Block);
    static POTTED_RED_TULIP: (Internal.FlowerPotBlock) & (Internal.Block);
    static RED_TULIP: (Internal.FlowerBlock) & (Internal.Block);
    static BAMBOO_PLANKS: (Internal.Block) & (Internal.Block);
    static BIRCH_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static JUNGLE_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static GREEN_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static BEACON: (Internal.BeaconBlock) & (Internal.Block);
    static DEEPSLATE_LAPIS_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static OAK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static BIRCH_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static SANDSTONE: (Internal.Block) & (Internal.Block);
    static SNOW_BLOCK: (Internal.Block) & (Internal.Block);
    static BLACK_BED: (Internal.BedBlock) & (Internal.Block);
    static BROWN_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static POTTED_DEAD_BUSH: (Internal.FlowerPotBlock) & (Internal.Block);
    static STRIPPED_CHERRY_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static GRANITE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static DEEPSLATE: (Internal.RotatedPillarBlock) & (Internal.Block);
    static DARK_OAK_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static WHITE_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static DEAD_HORN_CORAL_WALL_FAN: (Internal.BaseCoralWallFanBlock) & (Internal.Block);
    static BAMBOO_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static INFESTED_COBBLESTONE: (Internal.InfestedBlock) & (Internal.Block);
}
type Blocks_ = Blocks;
declare interface BlockStatePredicate extends Internal.ReplacementMatch, Internal.Predicate<Internal.BlockState> {
    fromString(s: string): this;
    ruleTestOf(o: any): Internal.RuleTest;
    asRuleTest(): Internal.RuleTest;
    getBlockIds(): Internal.Set<ResourceLocation>;
    not<T>(arg0: Internal.Predicate_<T>): Internal.Predicate<T>;
    check(targetStates: Internal.List_<Internal.OreConfiguration$TargetBlockState>): boolean;
    abstract test(arg0: Internal.BlockState_): boolean;
    getBlockStates(): Internal.Collection<Internal.BlockState>;
    getBlocks(): Internal.Collection<Internal.Block>;
    isEqual<T>(arg0: any): Internal.Predicate<T>;
    testBlock(block: Internal.Block_): boolean;
    of(o: any): this;
    test(arg0: any): boolean;
    and(arg0: Internal.Predicate_<Internal.BlockState>): Internal.Predicate<Internal.BlockState>;
    abstract "test(net.minecraft.world.level.block.state.BlockState)"(arg0: Internal.BlockState_): boolean;
    or(arg0: Internal.Predicate_<Internal.BlockState>): Internal.Predicate<Internal.BlockState>;
    negate(): Internal.Predicate<Internal.BlockState>;
    "test(java.lang.Object)"(arg0: any): boolean;
    get blockIds(): Internal.Set<ResourceLocation>
    get blockStates(): Internal.Collection<Internal.BlockState>
    get blocks(): Internal.Collection<Internal.Block>
    readonly AIR_ID: (ResourceLocation) & (ResourceLocation);
}
type BlockStatePredicate_ = RegExp | "-" | `#${Special.BlockTag}` | BlockStatePredicate_[] | Internal.Block_ | Internal.BlockState_ | "*" | BlockStatePredicate | {not?: BlockStatePredicate_, or?: BlockStatePredicate_};
declare const BlockStatePredicate: BlockStatePredicate;
declare class KMath {
    constructor()
    static lerp(value: number, min0: number, max0: number, min1: number, max1: number): number;
    getClass(): typeof any;
    static block(x: number, y: number, z: number): BlockPos;
    static deg(value: number): number;
    static v3d(x: number, y: number, z: number): Internal.Vector3d;
    static ceil(value: number): number;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    static clamp(value: number, min: number, max: number): number;
    static v4f(x: number, y: number, z: number, w: number): Vec4f;
    static rad(value: number): number;
    static degreesDifference(current: number, target: number): number;
    static floor(value: number): number;
    static poseStack(): Internal.PoseStack;
    static lerp(value: number, min: number, max: number): number;
    static v3f(x: number, y: number, z: number): Vec3f;
    toString(): string;
    notifyAll(): void;
    static m4f(): Matrix4f;
    static rotateIfNecessary(current: number, target: number, max: number): number;
    static v3(x: number, y: number, z: number): Vec3d;
    static quaternion(x: number, y: number, z: number, w: number): Quaternionf;
    hashCode(): number;
    static wrapDegrees(d: number): number;
    static m3f(): Matrix3f;
    wait(): void;
    static clampedLerp(value: number, min: number, max: number): number;
    static approachDegrees(current: number, target: number, speed: number): number;
    wait(arg0: number): void;
    static approach(current: number, target: number, speed: number): number;
    equals(arg0: any): boolean;
    static isPowerOfTwo(value: number): boolean;
    get class(): typeof any
    static readonly PI: (3.141592653589793) & (number);
    static readonly RADIANS_TO_DEGREES: (57.29577951308232) & (number);
    static readonly DEGREES_TO_RADIANS: (0.017453292519943295) & (number);
    static readonly E: (2.718281828459045) & (number);
}
type KMath_ = KMath;
declare class Items {
    constructor()
    getClass(): typeof any;
    toString(): string;
    static registerBlock(arg0: Internal.Block_, ...arg1: Internal.Block_[]): Internal.Item;
    notifyAll(): void;
    static "registerItem(net.minecraft.resources.ResourceKey,net.minecraft.world.item.Item)"(arg0: Internal.ResourceKey_<Internal.Item>, arg1: Internal.Item_): Internal.Item;
    static "registerItem(net.minecraft.resources.ResourceLocation,net.minecraft.world.item.Item)"(arg0: ResourceLocation_, arg1: Internal.Item_): Internal.Item;
    static registerBlock(arg0: Internal.Block_): Internal.Item;
    static "registerBlock(net.minecraft.world.level.block.Block,net.minecraft.world.item.Item)"(arg0: Internal.Block_, arg1: Internal.Item_): Internal.Item;
    static "registerBlock(net.minecraft.world.item.BlockItem)"(arg0: Internal.BlockItem_): Internal.Item;
    static registerItem(arg0: Internal.ResourceKey_<Internal.Item>, arg1: Internal.Item_): Internal.Item;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    hashCode(): number;
    static "registerBlock(net.minecraft.world.level.block.Block)"(arg0: Internal.Block_): Internal.Item;
    static registerItem(arg0: ResourceLocation_, arg1: Internal.Item_): Internal.Item;
    static "registerItem(java.lang.String,net.minecraft.world.item.Item)"(arg0: string, arg1: Internal.Item_): Internal.Item;
    wait(): void;
    static registerBlock(arg0: Internal.Block_, arg1: Internal.Item_): Internal.Item;
    wait(arg0: number): void;
    static registerItem(arg0: string, arg1: Internal.Item_): Internal.Item;
    equals(arg0: any): boolean;
    static registerBlock(arg0: Internal.BlockItem_): Internal.Item;
    static "registerBlock(net.minecraft.world.level.block.Block,net.minecraft.world.level.block.Block[])"(arg0: Internal.Block_, ...arg1: Internal.Block_[]): Internal.Item;
    get class(): typeof any
    static POWERED_RAIL: (Internal.BlockItem) & (Internal.Item);
    static GUARDIAN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static QUARTZ: (Internal.Item) & (Internal.Item);
    static TUBE_CORAL: (Internal.BlockItem) & (Internal.Item);
    static TURTLE_EGG: (Internal.BlockItem) & (Internal.Item);
    static HANGING_ROOTS: (Internal.BlockItem) & (Internal.Item);
    static CYAN_DYE: (Internal.DyeItem) & (Internal.Item);
    static WAXED_WEATHERED_CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static CRACKED_DEEPSLATE_TILES: (Internal.BlockItem) & (Internal.Item);
    static OAK_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static BLAZE_ROD: (Internal.Item) & (Internal.Item);
    static GRASS_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static DRIED_KELP: (Internal.Item) & (Internal.Item);
    static TURTLE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static GRAY_BANNER: (Internal.BannerItem) & (Internal.Item);
    static MAGENTA_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static WARPED_FUNGUS: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static BEETROOT: (Internal.Item) & (Internal.Item);
    static LIGHT_GRAY_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static GRAY_BED: (Internal.BedItem) & (Internal.Item);
    static MUDDY_MANGROVE_ROOTS: (Internal.BlockItem) & (Internal.Item);
    static OAK_SIGN: (Internal.SignItem) & (Internal.Item);
    static ACACIA_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_SLAB: (Internal.BlockItem) & (Internal.Item);
    static CHAIN: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_DYE: (Internal.DyeItem) & (Internal.Item);
    static STRIPPED_SPRUCE_LOG: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static PURPUR_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_LEGGINGS: (Internal.ArmorItem) & (Internal.Item);
    static DEBUG_STICK: (Internal.DebugStickItem) & (Internal.Item);
    static DUNE_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static MUSIC_DISC_CAT: (Internal.RecordItem) & (Internal.Item);
    static GOLDEN_SWORD: (Internal.SwordItem) & (Internal.Item);
    static VERDANT_FROGLIGHT: (Internal.BlockItem) & (Internal.Item);
    static WARPED_NYLIUM: (Internal.BlockItem) & (Internal.Item);
    static TIPPED_ARROW: (Internal.TippedArrowItem) & (Internal.Item);
    static MILK_BUCKET: (Internal.MilkBucketItem) & (Internal.Item);
    static LAPIS_ORE: (Internal.BlockItem) & (Internal.Item);
    static WEEPING_VINES: (Internal.BlockItem) & (Internal.Item);
    static BLAZE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static TORCHFLOWER: (Internal.BlockItem) & (Internal.Item);
    static LODESTONE: (Internal.BlockItem) & (Internal.Item);
    static IRON_HELMET: (Internal.ArmorItem) & (Internal.Item);
    static MANGROVE_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static INFESTED_STONE: (Internal.BlockItem) & (Internal.Item);
    static OAK_LOG: (Internal.BlockItem) & (Internal.Item);
    static SMOOTH_QUARTZ: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static BRUSH: (Internal.BrushItem) & (Internal.Item);
    static END_PORTAL_FRAME: (Internal.BlockItem) & (Internal.Item);
    static AZURE_BLUET: (Internal.BlockItem) & (Internal.Item);
    static NETHER_QUARTZ_ORE: (Internal.BlockItem) & (Internal.Item);
    static COBBLESTONE: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static SPRUCE_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static PUMPKIN: (Internal.BlockItem) & (Internal.Item);
    static COBWEB: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_WOOD: (Internal.BlockItem) & (Internal.Item);
    static BLUE_CARPET: (Internal.BlockItem) & (Internal.Item);
    static CARROT: (Internal.ItemNameBlockItem) & (Internal.Item);
    static GOLDEN_BOOTS: (Internal.ArmorItem) & (Internal.Item);
    static BLACKSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static SUNFLOWER: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static COPPER_ORE: (Internal.BlockItem) & (Internal.Item);
    static CHEST: (Internal.BlockItem) & (Internal.Item);
    static DEAD_HORN_CORAL: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_GRANITE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static PURPLE_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static SKELETON_SKULL: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static RESPAWN_ANCHOR: (Internal.BlockItem) & (Internal.Item);
    static BUCKET: (Internal.BucketItem) & (Internal.Item);
    static ZOMBIFIED_PIGLIN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static GLASS: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static FIRE_CORAL: (Internal.BlockItem) & (Internal.Item);
    static LAVA_BUCKET: (Internal.BucketItem) & (Internal.Item);
    static ENDER_PEARL: (Internal.EnderpearlItem) & (Internal.Item);
    static DRIED_KELP_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static WILD_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static JUNGLE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BOOKSHELF: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_LEGGINGS: (Internal.ArmorItem) & (Internal.Item);
    static COBBLESTONE_WALL: (Internal.BlockItem) & (Internal.Item);
    static TWISTING_VINES: (Internal.BlockItem) & (Internal.Item);
    static GRINDSTONE: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static PHANTOM_MEMBRANE: (Internal.Item) & (Internal.Item);
    static BRICK: (Internal.Item) & (Internal.Item);
    static ARCHER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static JUNGLE_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static TINTED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static OAK_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static GOLD_ORE: (Internal.BlockItem) & (Internal.Item);
    static FLOWERING_AZALEA: (Internal.BlockItem) & (Internal.Item);
    static POPPED_CHORUS_FRUIT: (Internal.Item) & (Internal.Item);
    static PRISMARINE_CRYSTALS: (Internal.Item) & (Internal.Item);
    static LAPIS_LAZULI: (Internal.Item) & (Internal.Item);
    static SQUID_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_INGOT: (Internal.Item) & (Internal.Item);
    static DEEPSLATE_EMERALD_ORE: (Internal.BlockItem) & (Internal.Item);
    static CHAINMAIL_BOOTS: (Internal.ArmorItem) & (Internal.Item);
    static NETHERITE_CHESTPLATE: (Internal.ArmorItem) & (Internal.Item);
    static CHICKEN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static BEEHIVE: (Internal.BlockItem) & (Internal.Item);
    static SPYGLASS: (Internal.SpyglassItem) & (Internal.Item);
    static NETHERITE_AXE: (Internal.AxeItem) & (Internal.Item);
    static ELDER_GUARDIAN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static DARK_OAK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BLUE_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static MULE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static ORANGE_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static FIREWORK_STAR: (Internal.FireworkStarItem) & (Internal.Item);
    static SPIDER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static DARK_OAK_LOG: (Internal.BlockItem) & (Internal.Item);
    static SKULL_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static FROG_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static DEAD_BRAIN_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static DIRT: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static WOODEN_SHOVEL: (Internal.ShovelItem) & (Internal.Item);
    static GLOWSTONE_DUST: (Internal.Item) & (Internal.Item);
    static ITEM_FRAME: (Internal.ItemFrameItem) & (Internal.Item);
    static MUSIC_DISC_RELIC: (Internal.RecordItem) & (Internal.Item);
    static SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_FENCE: (Internal.BlockItem) & (Internal.Item);
    static MOSSY_COBBLESTONE_WALL: (Internal.BlockItem) & (Internal.Item);
    static REDSTONE: (Internal.ItemNameBlockItem) & (Internal.Item);
    static CARROT_ON_A_STICK: Internal.Item;
    static SOUL_TORCH: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static LIME_CARPET: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static SUGAR_CANE: (Internal.BlockItem) & (Internal.Item);
    static COMMAND_BLOCK_MINECART: (Internal.MinecartItem) & (Internal.Item);
    static SMOOTH_SANDSTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CHEST_MINECART: (Internal.MinecartItem) & (Internal.Item);
    static DEAD_BUBBLE_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static SCUTE: (Internal.Item) & (Internal.Item);
    static FEATHER: (Internal.Item) & (Internal.Item);
    static JUNGLE_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static CUT_SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static CHISELED_QUARTZ_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static WHITE_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static COPPER_INGOT: (Internal.Item) & (Internal.Item);
    static SWEET_BERRIES: (Internal.ItemNameBlockItem) & (Internal.Item);
    static GREEN_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static BUBBLE_CORAL: (Internal.BlockItem) & (Internal.Item);
    static BELL: (Internal.BlockItem) & (Internal.Item);
    static WAXED_EXPOSED_COPPER: (Internal.BlockItem) & (Internal.Item);
    static WHITE_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static PITCHER_POD: (Internal.ItemNameBlockItem) & (Internal.Item);
    static BLACK_DYE: (Internal.DyeItem) & (Internal.Item);
    static WHITE_WOOL: (Internal.BlockItem) & (Internal.Item);
    static DETECTOR_RAIL: (Internal.BlockItem) & (Internal.Item);
    static TIDE_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static LIME_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static PIGLIN_HEAD: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static CHORUS_FLOWER: (Internal.BlockItem) & (Internal.Item);
    static WARPED_HYPHAE: (Internal.BlockItem) & (Internal.Item);
    static WARDEN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static CHISELED_NETHER_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static SNOWBALL: (Internal.SnowballItem) & (Internal.Item);
    static LANTERN: (Internal.BlockItem) & (Internal.Item);
    static CYAN_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static MAP: (Internal.EmptyMapItem) & (Internal.Item);
    static WHITE_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE_COPPER_ORE: (Internal.BlockItem) & (Internal.Item);
    static CUT_STANDSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BLACK_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static BLAST_FURNACE: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static QUARTZ_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static CYAN_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static IRON_INGOT: (Internal.Item) & (Internal.Item);
    static PINK_BANNER: (Internal.BannerItem) & (Internal.Item);
    static MAGMA_CUBE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static WHITE_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static SMOOTH_RED_SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static TRADER_LLAMA_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static TNT: (Internal.BlockItem) & (Internal.Item);
    static OAK_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static CHERRY_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static GREEN_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_FENCE: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_BANNER: (Internal.BannerItem) & (Internal.Item);
    static ROTTEN_FLESH: (Internal.Item) & (Internal.Item);
    static RIB_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static WRITTEN_BOOK: (Internal.WrittenBookItem) & (Internal.Item);
    static DISC_FRAGMENT_5: (Internal.DiscFragmentItem) & (Internal.Item);
    static SNIFFER_EGG: (Internal.BlockItem) & (Internal.Item);
    static MAGENTA_DYE: (Internal.DyeItem) & (Internal.Item);
    static CLAY: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static MAGENTA_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static BRAIN_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static SPAWNER: (Internal.BlockItem) & (Internal.Item);
    static LIME_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static CRIMSON_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_SCRAP: (Internal.Item) & (Internal.Item);
    static NETHER_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static STONE: (Internal.BlockItem) & (Internal.Item);
    static WITHER_SKELETON_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static AMETHYST_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_SAPLING: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static HOGLIN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static ZOGLIN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static LIME_DYE: (Internal.DyeItem) & (Internal.Item);
    static IRON_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static MAGENTA_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static PETRIFIED_OAK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static PRISMARINE_SHARD: (Internal.Item) & (Internal.Item);
    static NETHER_GOLD_ORE: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_BASALT: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_BANNER: (Internal.BannerItem) & (Internal.Item);
    static CHERRY_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static SANDSTONE_WALL: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static ENDER_DRAGON_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static STRIPPED_OAK_LOG: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_GRANITE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE_GOLD_ORE: (Internal.BlockItem) & (Internal.Item);
    static OBSERVER: (Internal.BlockItem) & (Internal.Item);
    static GRAY_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_SWORD: (Internal.SwordItem) & (Internal.Item);
    static FOX_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static CHERRY_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static MAGENTA_WOOL: (Internal.BlockItem) & (Internal.Item);
    static CALCITE: (Internal.BlockItem) & (Internal.Item);
    static PUMPKIN_SEEDS: (Internal.ItemNameBlockItem) & (Internal.Item);
    static FERMENTED_SPIDER_EYE: (Internal.Item) & (Internal.Item);
    static HEART_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static PURPLE_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static MUTTON: (Internal.Item) & (Internal.Item);
    static PURPLE_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static GOLDEN_PICKAXE: (Internal.PickaxeItem) & (Internal.Item);
    static ZOMBIE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static MUSIC_DISC_PIGSTEP: (Internal.RecordItem) & (Internal.Item);
    static REDSTONE_TORCH: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static LEATHER_LEGGINGS: (Internal.DyeableArmorItem) & (Internal.Item);
    static PIGLIN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static RED_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static COD: (Internal.Item) & (Internal.Item);
    static MUSIC_DISC_11: (Internal.RecordItem) & (Internal.Item);
    static AZALEA_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static NETHER_WART: (Internal.ItemNameBlockItem) & (Internal.Item);
    static NAME_TAG: (Internal.NameTagItem) & (Internal.Item);
    static CYAN_CARPET: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static MOSSY_COBBLESTONE: (Internal.BlockItem) & (Internal.Item);
    static NETHER_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static JACK_O_LANTERN: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_SAPLING: (Internal.BlockItem) & (Internal.Item);
    static WARPED_SLAB: (Internal.BlockItem) & (Internal.Item);
    static FURNACE: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_SLAB: (Internal.BlockItem) & (Internal.Item);
    static RED_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_CARPET: (Internal.BlockItem) & (Internal.Item);
    static POWDER_SNOW_BUCKET: (Internal.SolidBucketItem) & (Internal.Item);
    static BUBBLE_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static WHITE_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static BOOK: (Internal.BookItem) & (Internal.Item);
    static RED_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static DARK_PRISMARINE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_BANNER: (Internal.BannerItem) & (Internal.Item);
    static CRIMSON_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static PURPLE_WOOL: (Internal.BlockItem) & (Internal.Item);
    static PURPLE_BED: (Internal.BedItem) & (Internal.Item);
    static EMERALD_ORE: (Internal.BlockItem) & (Internal.Item);
    static BLUE_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static CRACKED_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static COD_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static DIAMOND: (Internal.Item) & (Internal.Item);
    static AZALEA: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_BOAT: (Internal.BoatItem) & (Internal.Item);
    static SPRUCE_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static MELON_SEEDS: (Internal.ItemNameBlockItem) & (Internal.Item);
    static WEATHERED_CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CANDLE: (Internal.BlockItem) & (Internal.Item);
    static PURPLE_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static PILLAGER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static MUSIC_DISC_13: (Internal.RecordItem) & (Internal.Item);
    static LIGHT_GRAY_CARPET: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_WOOD: (Internal.BlockItem) & (Internal.Item);
    static FLOWER_POT: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_WOOD: (Internal.BlockItem) & (Internal.Item);
    static WARPED_FENCE: (Internal.BlockItem) & (Internal.Item);
    static CHISELED_POLISHED_BLACKSTONE: (Internal.BlockItem) & (Internal.Item);
    static SEA_PICKLE: (Internal.BlockItem) & (Internal.Item);
    static LARGE_FERN: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static AMETHYST_SHARD: (Internal.Item) & (Internal.Item);
    static CHICKEN: (Internal.Item) & (Internal.Item);
    static GRAY_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static TOTEM_OF_UNDYING: (Internal.Item) & (Internal.Item);
    static STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static GREEN_BED: (Internal.BedItem) & (Internal.Item);
    static DROPPER: (Internal.BlockItem) & (Internal.Item);
    static LIME_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static KNOWLEDGE_BOOK: (Internal.KnowledgeBookItem) & (Internal.Item);
    static LOOM: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_WOOL: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_CARPET: (Internal.BlockItem) & (Internal.Item);
    static FISHING_ROD: (Internal.FishingRodItem) & (Internal.Item);
    static BROWN_DYE: (Internal.DyeItem) & (Internal.Item);
    static MEDIUM_AMETHYST_BUD: (Internal.BlockItem) & (Internal.Item);
    static ROOTED_DIRT: (Internal.BlockItem) & (Internal.Item);
    static SHAPER_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static WARPED_STEM: (Internal.BlockItem) & (Internal.Item);
    static SHEAF_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static RED_SAND: (Internal.BlockItem) & (Internal.Item);
    static END_STONE_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static SHEARS: (Internal.ShearsItem) & (Internal.Item);
    static PANDA_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static POTATO: (Internal.ItemNameBlockItem) & (Internal.Item);
    static LAPIS_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static COMPOSTER: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_HELMET: (Internal.ArmorItem) & (Internal.Item);
    static TROPICAL_FISH: (Internal.Item) & (Internal.Item);
    static POTION: (Internal.PotionItem) & (Internal.Item);
    static MANGROVE_ROOTS: (Internal.BlockItem) & (Internal.Item);
    static JIGSAW: (Internal.GameMasterBlockItem) & (Internal.Item);
    static PRISMARINE_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static TROPICAL_FISH_BUCKET: (Internal.MobBucketItem) & (Internal.Item);
    static WARPED_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static RED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static BROWN_CARPET: (Internal.BlockItem) & (Internal.Item);
    static CRIMSON_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static LIGHT_BLUE_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static LEATHER_CHESTPLATE: (Internal.DyeableArmorItem) & (Internal.Item);
    static RED_BED: (Internal.BedItem) & (Internal.Item);
    static STONE_HOE: (Internal.HoeItem) & (Internal.Item);
    static JUNGLE_LOG: (Internal.BlockItem) & (Internal.Item);
    static GLOW_SQUID_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static EYE_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static BROWN_WOOL: (Internal.BlockItem) & (Internal.Item);
    static PUFFERFISH_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static CHAINMAIL_LEGGINGS: (Internal.ArmorItem) & (Internal.Item);
    static GREEN_WOOL: (Internal.BlockItem) & (Internal.Item);
    static BREAD: (Internal.Item) & (Internal.Item);
    static COOKED_CHICKEN: (Internal.Item) & (Internal.Item);
    static BIRCH_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static CRIMSON_SLAB: (Internal.BlockItem) & (Internal.Item);
    static GOLD_NUGGET: (Internal.Item) & (Internal.Item);
    static PHANTOM_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static QUARTZ_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static WHITE_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static WAXED_WEATHERED_COPPER: (Internal.BlockItem) & (Internal.Item);
    static BLUE_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static WHEAT_SEEDS: (Internal.ItemNameBlockItem) & (Internal.Item);
    static DEEPSLATE_TILES: (Internal.BlockItem) & (Internal.Item);
    static PORKCHOP: (Internal.Item) & (Internal.Item);
    static SCAFFOLDING: (Internal.ScaffoldingBlockItem) & (Internal.Item);
    static END_ROD: (Internal.BlockItem) & (Internal.Item);
    static ANDESITE: (Internal.BlockItem) & (Internal.Item);
    static PACKED_MUD: (Internal.BlockItem) & (Internal.Item);
    static STONE_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_WOOL: (Internal.BlockItem) & (Internal.Item);
    static REINFORCED_DEEPSLATE: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static LILY_OF_THE_VALLEY: (Internal.BlockItem) & (Internal.Item);
    static VILLAGER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static STONE_SHOVEL: (Internal.ShovelItem) & (Internal.Item);
    static PARROT_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static WHEAT: (Internal.Item) & (Internal.Item);
    static JUNGLE_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static BROWN_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_DEEPSLATE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_AXE: (Internal.AxeItem) & (Internal.Item);
    static WAXED_WEATHERED_CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static WARPED_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static NETHERRACK: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_CHESTPLATE: (Internal.ArmorItem) & (Internal.Item);
    static GRAY_WOOL: (Internal.BlockItem) & (Internal.Item);
    static COPPER_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static WEATHERED_CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static PURPUR_PILLAR: (Internal.BlockItem) & (Internal.Item);
    static STONE_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static RED_NETHER_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CAKE: (Internal.BlockItem) & (Internal.Item);
    static COBBLED_DEEPSLATE: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_FENCE: (Internal.BlockItem) & (Internal.Item);
    static FARMLAND: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_SHOVEL: (Internal.ShovelItem) & (Internal.Item);
    static PUMPKIN_PIE: (Internal.ItemNameBlockItem) & (Internal.Item);
    static SHULKER_SHELL: (Internal.ShulkerShellItem) & (Internal.Item);
    static OAK_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static RABBIT_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static LIGHT_WEIGHTED_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static APPLE: (Internal.Item) & (Internal.Item);
    static DIAMOND_HORSE_ARMOR: (Internal.HorseArmorItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static WARPED_ROOTS: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_LOG: (Internal.BlockItem) & (Internal.Item);
    static ELYTRA: (Internal.ElytraItem) & (Internal.Item);
    static WARPED_SIGN: (Internal.SignItem) & (Internal.Item);
    static GREEN_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static BEE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static PINK_DYE: (Internal.DyeItem) & (Internal.Item);
    static PLAYER_HEAD: (Internal.PlayerHeadItem) & (Internal.Item);
    static GLOW_LICHEN: (Internal.BlockItem) & (Internal.Item);
    static STONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static ROSE_BUSH: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static GLOW_ITEM_FRAME: (Internal.ItemFrameItem) & (Internal.Item);
    static WHITE_TULIP: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static OBSIDIAN: (Internal.BlockItem) & (Internal.Item);
    static BLADE_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static BROWN_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static EGG: (Internal.EggItem) & (Internal.Item);
    static WITCH_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static OXIDIZED_CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static WAXED_EXPOSED_CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static OCELOT_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static HORN_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static NETHER_SPROUTS: (Internal.BlockItem) & (Internal.Item);
    static MUD_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static DEAD_BRAIN_CORAL: (Internal.BlockItem) & (Internal.Item);
    static TALL_GRASS: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static BLACK_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static SPIDER_EYE: (Internal.Item) & (Internal.Item);
    static FILLED_MAP: (Internal.MapItem) & (Internal.Item);
    static MUD_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static AXOLOTL_BUCKET: (Internal.MobBucketItem) & (Internal.Item);
    static ZOMBIE_HORSE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static DARK_PRISMARINE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_SIGN: (Internal.SignItem) & (Internal.Item);
    static STRIPPED_JUNGLE_WOOD: (Internal.BlockItem) & (Internal.Item);
    static MUSHROOM_STEM: (Internal.BlockItem) & (Internal.Item);
    static LILAC: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static BAMBOO_RAFT: (Internal.BoatItem) & (Internal.Item);
    static SUSPICIOUS_STEW: (Internal.SuspiciousStewItem) & (Internal.Item);
    static SUSPICIOUS_GRAVEL: (Internal.BlockItem) & (Internal.Item);
    static GOLDEN_LEGGINGS: (Internal.ArmorItem) & (Internal.Item);
    static IRON_PICKAXE: (Internal.PickaxeItem) & (Internal.Item);
    static WAXED_OXIDIZED_CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static CRACKED_DEEPSLATE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static SHULKER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static SENTRY_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static LIGHT_GRAY_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static MELON_SLICE: (Internal.Item) & (Internal.Item);
    static HONEYCOMB_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_DIORITE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static PEARLESCENT_FROGLIGHT: (Internal.BlockItem) & (Internal.Item);
    static GOLDEN_CHESTPLATE: (Internal.ArmorItem) & (Internal.Item);
    static ANCIENT_DEBRIS: (Internal.BlockItem) & (Internal.Item);
    static HOPPER_MINECART: (Internal.MinecartItem) & (Internal.Item);
    static MAGMA_CREAM: (Internal.Item) & (Internal.Item);
    static ZOMBIE_HEAD: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static POLISHED_GRANITE: (Internal.BlockItem) & (Internal.Item);
    static PINK_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static HONEYCOMB: (Internal.HoneycombItem) & (Internal.Item);
    static NOTE_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static RED_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static FURNACE_MINECART: (Internal.MinecartItem) & (Internal.Item);
    static DRAGON_BREATH: (Internal.Item) & (Internal.Item);
    static CYAN_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static CRIMSON_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static CHORUS_PLANT: (Internal.BlockItem) & (Internal.Item);
    static WAXED_CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static TURTLE_HELMET: (Internal.ArmorItem) & (Internal.Item);
    static DARK_OAK_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static COAL_ORE: (Internal.BlockItem) & (Internal.Item);
    static COAL: (Internal.Item) & (Internal.Item);
    static COAST_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static GRAY_CARPET: (Internal.BlockItem) & (Internal.Item);
    static OXIDIZED_CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static DANGER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static SANDSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static GREEN_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static BARREL: (Internal.BlockItem) & (Internal.Item);
    static RED_SANDSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static WHITE_DYE: (Internal.DyeItem) & (Internal.Item);
    static ORANGE_DYE: (Internal.DyeItem) & (Internal.Item);
    static ENCHANTED_BOOK: (Internal.EnchantedBookItem) & (Internal.Item);
    static SOUL_SOIL: (Internal.BlockItem) & (Internal.Item);
    static IRON_NUGGET: (Internal.Item) & (Internal.Item);
    static ENDERMITE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static NETHERITE_BOOTS: (Internal.ArmorItem) & (Internal.Item);
    static LEVER: (Internal.BlockItem) & (Internal.Item);
    static COOKED_SALMON: (Internal.Item) & (Internal.Item);
    static CAULDRON: (Internal.Items$1) & (Internal.Item);
    static ALLIUM: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static EXPLORER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static POISONOUS_POTATO: (Internal.Item) & (Internal.Item);
    static FLOWER_BANNER_PATTERN: (Internal.BannerPatternItem) & (Internal.Item);
    static SMOOTH_STONE: (Internal.BlockItem) & (Internal.Item);
    static WHITE_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static SNORT_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static BROWN_MUSHROOM_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static GHAST_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static NETHER_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static IRON_SHOVEL: (Internal.ShovelItem) & (Internal.Item);
    static AXOLOTL_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static ORANGE_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static SEA_LANTERN: (Internal.BlockItem) & (Internal.Item);
    static SMOOTH_RED_SANDSTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_WALL: (Internal.BlockItem) & (Internal.Item);
    static STONE_PICKAXE: (Internal.PickaxeItem) & (Internal.Item);
    static LIME_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static SHIELD: (Internal.ShieldItem) & (Internal.Item);
    static DIORITE_WALL: (Internal.BlockItem) & (Internal.Item);
    static STONE_SWORD: (Internal.SwordItem) & (Internal.Item);
    static GOLDEN_HOE: (Internal.HoeItem) & (Internal.Item);
    static BLACK_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_ORE: (Internal.BlockItem) & (Internal.Item);
    static BLACK_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_DYE: (Internal.DyeItem) & (Internal.Item);
    static REPEATER: (Internal.BlockItem) & (Internal.Item);
    static SPECTRAL_ARROW: (Internal.SpectralArrowItem) & (Internal.Item);
    static CHERRY_SLAB: (Internal.BlockItem) & (Internal.Item);
    static LEAD: (Internal.LeadItem) & (Internal.Item);
    static WHITE_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static CHISELED_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static DEAD_TUBE_CORAL: (Internal.BlockItem) & (Internal.Item);
    static BROWN_BANNER: (Internal.BannerItem) & (Internal.Item);
    static WAXED_OXIDIZED_COPPER: (Internal.BlockItem) & (Internal.Item);
    static PINK_WOOL: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_BOAT: (Internal.BoatItem) & (Internal.Item);
    static BLACK_CARPET: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static BREWING_STAND: (Internal.BlockItem) & (Internal.Item);
    static BIG_DRIPLEAF: (Internal.Items$1) & (Internal.Item);
    static CARVED_PUMPKIN: (Internal.BlockItem) & (Internal.Item);
    static OAK_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static PINK_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static DIORITE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_BOAT: (Internal.BoatItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_WOOD: (Internal.BlockItem) & (Internal.Item);
    static SMOOTH_QUARTZ_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static END_STONE: (Internal.BlockItem) & (Internal.Item);
    static BLUE_BED: (Internal.BedItem) & (Internal.Item);
    static LIGHT: (Internal.BlockItem) & (Internal.Item);
    static BONE_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static DRIPSTONE_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static WET_SPONGE: (Internal.BlockItem) & (Internal.Item);
    static FLINT: (Internal.Item) & (Internal.Item);
    static INFESTED_CHISELED_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static GRAY_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static MOSSY_COBBLESTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static HUSK_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static PINK_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static MAGENTA_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static BLUE_ICE: (Internal.BlockItem) & (Internal.Item);
    static JUKEBOX: (Internal.BlockItem) & (Internal.Item);
    static FIRE_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static FIRE_CHARGE: (Internal.FireChargeItem) & (Internal.Item);
    static COOKED_MUTTON: (Internal.Item) & (Internal.Item);
    static BASALT: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static PIG_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static MUSHROOM_STEW: (Internal.BowlFoodItem) & (Internal.Item);
    static PURPLE_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static HOWL_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static SMALL_AMETHYST_BUD: (Internal.BlockItem) & (Internal.Item);
    static DEAD_HORN_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static WEATHERED_COPPER: (Internal.BlockItem) & (Internal.Item);
    static RED_WOOL: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_PROPAGULE: (Internal.BlockItem) & (Internal.Item);
    static PURPUR_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static PAPER: (Internal.Item) & (Internal.Item);
    static IRON_HOE: (Internal.HoeItem) & (Internal.Item);
    static MAGENTA_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static STICKY_PISTON: (Internal.BlockItem) & (Internal.Item);
    static COMPASS: (Internal.CompassItem) & (Internal.Item);
    static RED_SANDSTONE_WALL: (Internal.BlockItem) & (Internal.Item);
    static DARK_PRISMARINE: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_FENCE: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static CLAY_BALL: (Internal.Item) & (Internal.Item);
    static CYAN_WOOL: (Internal.BlockItem) & (Internal.Item);
    static STONECUTTER: (Internal.BlockItem) & (Internal.Item);
    static MINECART: (Internal.MinecartItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static RED_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static GREEN_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static SHELTER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static AIR: (Internal.AirItem) & (Internal.Item);
    static SEAGRASS: (Internal.BlockItem) & (Internal.Item);
    static GLOWSTONE: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_BED: (Internal.BedItem) & (Internal.Item);
    static ANVIL: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static RAW_COPPER_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_DIORITE: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_SIGN: (Internal.SignItem) & (Internal.Item);
    static MAGENTA_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static NETHER_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static WITHER_SKELETON_SKULL: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static DONKEY_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static STONE_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static WARPED_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static WAXED_COPPER_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static ENCHANTED_GOLDEN_APPLE: (Internal.EnchantedGoldenAppleItem) & (Internal.Item);
    static MANGROVE_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static MUD: (Internal.BlockItem) & (Internal.Item);
    static OAK_FENCE: (Internal.BlockItem) & (Internal.Item);
    static GOAT_HORN: (Internal.InstrumentItem) & (Internal.Item);
    static HOST_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static CAVE_SPIDER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static QUARTZ_PILLAR: (Internal.BlockItem) & (Internal.Item);
    static DEAD_FIRE_CORAL: (Internal.BlockItem) & (Internal.Item);
    static SUGAR: (Internal.Item) & (Internal.Item);
    static WAXED_EXPOSED_CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static BROWN_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static SCULK_VEIN: (Internal.BlockItem) & (Internal.Item);
    static FLETCHING_TABLE: (Internal.BlockItem) & (Internal.Item);
    static INFESTED_MOSSY_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static WARPED_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static BROWN_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static PINK_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static STONE_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static PLENTY_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static RED_CARPET: (Internal.BlockItem) & (Internal.Item);
    static CLOCK: (Internal.Item) & (Internal.Item);
    static GRAY_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static EMERALD: (Internal.Item) & (Internal.Item);
    static DEEPSLATE_DIAMOND_ORE: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static BROWN_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static KELP: (Internal.BlockItem) & (Internal.Item);
    static WITHER_ROSE: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static TADPOLE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static OAK_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static SNOUT_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static SPRUCE_FENCE: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static CRAFTING_TABLE: (Internal.BlockItem) & (Internal.Item);
    static BAKED_POTATO: (Internal.Item) & (Internal.Item);
    static MANGROVE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static CYAN_BED: (Internal.BedItem) & (Internal.Item);
    static CHISELED_BOOKSHELF: (Internal.BlockItem) & (Internal.Item);
    static NAUTILUS_SHELL: (Internal.Item) & (Internal.Item);
    static SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static STICK: (Internal.Item) & (Internal.Item);
    static HEAVY_WEIGHTED_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static COARSE_DIRT: (Internal.BlockItem) & (Internal.Item);
    static QUARTZ_SLAB: (Internal.BlockItem) & (Internal.Item);
    static SPIRE_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static COBBLED_DEEPSLATE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static LIGHTNING_ROD: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_FENCE: (Internal.BlockItem) & (Internal.Item);
    static POLAR_BEAR_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static ACACIA_LOG: (Internal.BlockItem) & (Internal.Item);
    static MOJANG_BANNER_PATTERN: (Internal.BannerPatternItem) & (Internal.Item);
    static DEEPSLATE_REDSTONE_ORE: (Internal.BlockItem) & (Internal.Item);
    static INFESTED_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static ENCHANTING_TABLE: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_ANDESITE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static PURPLE_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static PINK_CARPET: (Internal.BlockItem) & (Internal.Item);
    static BREWER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static DIORITE: (Internal.BlockItem) & (Internal.Item);
    static RED_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_SAPLING: (Internal.BlockItem) & (Internal.Item);
    static GRAY_DYE: (Internal.DyeItem) & (Internal.Item);
    static LIGHT_GRAY_BED: (Internal.BedItem) & (Internal.Item);
    static BAMBOO_SIGN: (Internal.SignItem) & (Internal.Item);
    static IRON_ORE: (Internal.BlockItem) & (Internal.Item);
    static SCULK_SENSOR: (Internal.BlockItem) & (Internal.Item);
    static BUNDLE: (Internal.BundleItem) & (Internal.Item);
    static STRING: (Internal.ItemNameBlockItem) & (Internal.Item);
    static STRIPPED_JUNGLE_LOG: (Internal.BlockItem) & (Internal.Item);
    static END_CRYSTAL: (Internal.EndCrystalItem) & (Internal.Item);
    static LEATHER_BOOTS: (Internal.DyeableArmorItem) & (Internal.Item);
    static SLIME_BALL: (Internal.Item) & (Internal.Item);
    static ORANGE_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE_IRON_ORE: (Internal.BlockItem) & (Internal.Item);
    static BOW: (Internal.BowItem) & (Internal.Item);
    static ORANGE_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static BLUE_ORCHID: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static LLAMA_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static CAMPFIRE: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static MAGENTA_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static EXPOSED_CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BUBBLE_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static RED_MUSHROOM: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static BLACK_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static SAND: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_HOE: (Internal.HoeItem) & (Internal.Item);
    static RED_MUSHROOM_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static MYCELIUM: (Internal.BlockItem) & (Internal.Item);
    static PINK_TULIP: (Internal.BlockItem) & (Internal.Item);
    static PINK_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static GOAT_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static INFESTED_CRACKED_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static RABBIT: (Internal.Item) & (Internal.Item);
    static PRISMARINE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static REDSTONE_LAMP: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_CARPET: (Internal.BlockItem) & (Internal.Item);
    static TUBE_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static MANGROVE_WOOD: (Internal.BlockItem) & (Internal.Item);
    static LIME_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static STRIPPED_ACACIA_WOOD: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static ARMOR_STAND: (Internal.ArmorStandItem) & (Internal.Item);
    static CHERRY_SAPLING: (Internal.BlockItem) & (Internal.Item);
    static BROWN_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static STONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static MANGROVE_BOAT: (Internal.BoatItem) & (Internal.Item);
    static PRISMARINE_WALL: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_BANNER: (Internal.BannerItem) & (Internal.Item);
    static RED_NETHER_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static WAXED_OXIDIZED_CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static IRON_GOLEM_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static CRIMSON_NYLIUM: (Internal.BlockItem) & (Internal.Item);
    static FIRE_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static EXPERIENCE_BOTTLE: (Internal.ExperienceBottleItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static RED_NETHER_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static BLACK_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static SMITHING_TABLE: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_SIGN: (Internal.SignItem) & (Internal.Item);
    static YELLOW_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static VEX_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static PIGLIN_BRUTE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static GRAY_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static COBBLESTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static BLAZE_POWDER: (Internal.Item) & (Internal.Item);
    static MUSIC_DISC_MALL: (Internal.RecordItem) & (Internal.Item);
    static LARGE_AMETHYST_BUD: (Internal.BlockItem) & (Internal.Item);
    static BRICKS: (Internal.BlockItem) & (Internal.Item);
    static BUDDING_AMETHYST: (Internal.BlockItem) & (Internal.Item);
    static RABBIT_FOOT: (Internal.Item) & (Internal.Item);
    static BAMBOO_MOSAIC: (Internal.BlockItem) & (Internal.Item);
    static MOSSY_COBBLESTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static SKULL_BANNER_PATTERN: (Internal.BannerPatternItem) & (Internal.Item);
    static ACACIA_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static BURN_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static COMMAND_BLOCK: (Internal.GameMasterBlockItem) & (Internal.Item);
    static BEACON: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_SPRUCE_WOOD: (Internal.BlockItem) & (Internal.Item);
    static OAK_SAPLING: (Internal.BlockItem) & (Internal.Item);
    static SMOOTH_SANDSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_CRIMSON_STEM: (Internal.BlockItem) & (Internal.Item);
    static GLOW_INK_SAC: (Internal.GlowInkSacItem) & (Internal.Item);
    static CYAN_BANNER: (Internal.BannerItem) & (Internal.Item);
    static CAMEL_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static POLISHED_BLACKSTONE: (Internal.BlockItem) & (Internal.Item);
    static GRASS: (Internal.BlockItem) & (Internal.Item);
    static SMOOTH_RED_SANDSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BROWN_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static MUSIC_DISC_CHIRP: (Internal.RecordItem) & (Internal.Item);
    static MUSIC_DISC_FAR: (Internal.RecordItem) & (Internal.Item);
    static RED_SANDSTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static COBBLED_DEEPSLATE_WALL: (Internal.BlockItem) & (Internal.Item);
    static BLUE_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static WOODEN_AXE: (Internal.AxeItem) & (Internal.Item);
    static SPORE_BLOSSOM: (Internal.BlockItem) & (Internal.Item);
    static DEAD_BRAIN_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static DEEPSLATE_TILE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CROSSBOW: (Internal.CrossbowItem) & (Internal.Item);
    static BAMBOO_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static HORN_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static ORANGE_TULIP: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_PICKAXE: (Internal.PickaxeItem) & (Internal.Item);
    static GREEN_CARPET: (Internal.BlockItem) & (Internal.Item);
    static SILENCE_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static OXIDIZED_CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static RABBIT_HIDE: (Internal.Item) & (Internal.Item);
    static COOKED_COD: (Internal.Item) & (Internal.Item);
    static BLACK_BED: (Internal.BedItem) & (Internal.Item);
    static PUFFERFISH: (Internal.Item) & (Internal.Item);
    static ENDER_EYE: (Internal.EnderEyeItem) & (Internal.Item);
    static INFESTED_COBBLESTONE: (Internal.BlockItem) & (Internal.Item);
    static GOLD_INGOT: (Internal.Item) & (Internal.Item);
    static VEX_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static STRIPPED_MANGROVE_LOG: (Internal.BlockItem) & (Internal.Item);
    static ICE: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_MOSAIC_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static BLACK_BANNER: (Internal.BannerItem) & (Internal.Item);
    static OAK_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static LIME_BANNER: (Internal.BannerItem) & (Internal.Item);
    static PINK_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static SMALL_DRIPLEAF: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static LILY_PAD: (Internal.PlaceOnWaterBlockItem) & (Internal.Item);
    static CREEPER_BANNER_PATTERN: (Internal.BannerPatternItem) & (Internal.Item);
    static GLOW_BERRIES: (Internal.ItemNameBlockItem) & (Internal.Item);
    static HOPPER: (Internal.BlockItem) & (Internal.Item);
    static PUFFERFISH_BUCKET: (Internal.MobBucketItem) & (Internal.Item);
    static PURPLE_BANNER: (Internal.BannerItem) & (Internal.Item);
    static HAY_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static HEART_OF_THE_SEA: (Internal.Item) & (Internal.Item);
    static WARD_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static MOSSY_STONE_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static EXPOSED_CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static WARPED_WART_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_SWORD: (Internal.SwordItem) & (Internal.Item);
    static SHEEP_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static ANGLER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static PODZOL: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_HOE: (Internal.HoeItem) & (Internal.Item);
    static GRAY_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_WARPED_STEM: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_SIGN: (Internal.SignItem) & (Internal.Item);
    static RABBIT_STEW: (Internal.BowlFoodItem) & (Internal.Item);
    static DEAD_TUBE_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static DECORATED_POT: (Internal.BlockItem) & (Internal.Item);
    static OAK_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static CHAINMAIL_HELMET: (Internal.ArmorItem) & (Internal.Item);
    static CRACKED_POLISHED_BLACKSTONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static LIME_BED: (Internal.BedItem) & (Internal.Item);
    static TUFF: (Internal.BlockItem) & (Internal.Item);
    static GRAVEL: (Internal.BlockItem) & (Internal.Item);
    static BARRIER: (Internal.BlockItem) & (Internal.Item);
    static DRAGON_HEAD: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static MUSIC_DISC_MELLOHI: (Internal.RecordItem) & (Internal.Item);
    static IRON_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static BAT_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static VINDICATOR_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static SMOOTH_BASALT: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static DEAD_HORN_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static DROWNED_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static NETHER_STAR: (Internal.SimpleFoiledItem) & (Internal.Item);
    static CRIMSON_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static FLINT_AND_STEEL: (Internal.FlintAndSteelItem) & (Internal.Item);
    static MAGENTA_BED: (Internal.BedItem) & (Internal.Item);
    static BONE: (Internal.Item) & (Internal.Item);
    static BROWN_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static END_STONE_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static CALIBRATED_SCULK_SENSOR: (Internal.BlockItem) & (Internal.Item);
    static COMPARATOR: (Internal.BlockItem) & (Internal.Item);
    static LEATHER_HORSE_ARMOR: (Internal.DyeableHorseArmorItem) & (Internal.Item);
    static STRIPPED_BAMBOO_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_DIORITE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static MUD_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static MOSS_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static CRIMSON_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CREEPER_HEAD: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static JUNGLE_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static BLACK_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static COOKIE: (Internal.Item) & (Internal.Item);
    static GRANITE: (Internal.BlockItem) & (Internal.Item);
    static LEATHER: (Internal.Item) & (Internal.Item);
    static SALMON_BUCKET: (Internal.MobBucketItem) & (Internal.Item);
    static DANDELION: (Internal.BlockItem) & (Internal.Item);
    static WARPED_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static PRISMARINE_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static RED_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static IRON_HORSE_ARMOR: (Internal.HorseArmorItem) & (Internal.Item);
    static IRON_SWORD: (Internal.SwordItem) & (Internal.Item);
    static BONE_MEAL: (Internal.BoneMealItem) & (Internal.Item);
    static GRAY_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static DEAD_FIRE_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static POINTED_DRIPSTONE: (Internal.BlockItem) & (Internal.Item);
    static PURPUR_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static ALLAY_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static COW_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static ARMS_UP_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static BLUE_WOOL: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static MUSIC_DISC_WARD: (Internal.RecordItem) & (Internal.Item);
    static PINK_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static BLUE_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static ANDESITE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CHORUS_FRUIT: (Internal.ChorusFruitItem) & (Internal.Item);
    static VINE: (Internal.BlockItem) & (Internal.Item);
    static COAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_DEEPSLATE_WALL: (Internal.BlockItem) & (Internal.Item);
    static MUSIC_DISC_OTHERSIDE: (Internal.RecordItem) & (Internal.Item);
    static MOSSY_STONE_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static SNOW_GOLEM_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static SCULK: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_ANDESITE: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_SIGN: (Internal.SignItem) & (Internal.Item);
    static COCOA_BEANS: (Internal.ItemNameBlockItem) & (Internal.Item);
    static CYAN_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static PURPLE_DYE: (Internal.DyeItem) & (Internal.Item);
    static CYAN_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static BLACKSTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static GLOBE_BANNER_PATTERN: (Internal.BannerPatternItem) & (Internal.Item);
    static SPRUCE_LOG: (Internal.BlockItem) & (Internal.Item);
    static TUBE_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static EXPOSED_CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static GREEN_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static CONDUIT: (Internal.BlockItem) & (Internal.Item);
    static GLISTERING_MELON_SLICE: (Internal.Item) & (Internal.Item);
    static RAVAGER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static SKELETON_HORSE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static BRAIN_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO: (Internal.BlockItem) & (Internal.Item);
    static COOKED_PORKCHOP: (Internal.Item) & (Internal.Item);
    static GOLDEN_SHOVEL: (Internal.ShovelItem) & (Internal.Item);
    static CUT_RED_SANDSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static MOSSY_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_HELMET: (Internal.ArmorItem) & (Internal.Item);
    static BAMBOO_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static SMOOTH_STONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static IRON_LEGGINGS: (Internal.ArmorItem) & (Internal.Item);
    static SMOKER: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_BIRCH_WOOD: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_BOAT: (Internal.BoatItem) & (Internal.Item);
    static MOSS_CARPET: (Internal.BlockItem) & (Internal.Item);
    static FIREWORK_ROCKET: (Internal.FireworkRocketItem) & (Internal.Item);
    static OCHRE_FROGLIGHT: (Internal.BlockItem) & (Internal.Item);
    static CHISELED_DEEPSLATE: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static NETHER_BRICK_FENCE: (Internal.BlockItem) & (Internal.Item);
    static CHISELED_RED_SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static TADPOLE_BUCKET: (Internal.MobBucketItem) & (Internal.Item);
    static DRAGON_EGG: (Internal.BlockItem) & (Internal.Item);
    static PRIZE_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static DARK_OAK_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static COOKED_RABBIT: (Internal.Item) & (Internal.Item);
    static CHERRY_BOAT: (Internal.BoatItem) & (Internal.Item);
    static END_STONE_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static GREEN_DYE: (Internal.DyeItem) & (Internal.Item);
    static MUSIC_DISC_WAIT: (Internal.RecordItem) & (Internal.Item);
    static RED_NETHER_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static PITCHER_PLANT: (Internal.BlockItem) & (Internal.Item);
    static LIME_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static PRISMARINE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static AMETHYST_CLUSTER: (Internal.BlockItem) & (Internal.Item);
    static CHISELED_SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE_COAL_ORE: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_MANGROVE_WOOD: (Internal.BlockItem) & (Internal.Item);
    static STONE_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static RED_DYE: (Internal.DyeItem) & (Internal.Item);
    static SPLASH_POTION: (Internal.SplashPotionItem) & (Internal.Item);
    static PURPLE_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static STRIDER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static OXEYE_DAISY: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static PINK_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_CHERRY_WOOD: (Internal.BlockItem) & (Internal.Item);
    static REPEATING_COMMAND_BLOCK: (Internal.GameMasterBlockItem) & (Internal.Item);
    static CHERRY_SIGN: (Internal.SignItem) & (Internal.Item);
    static CRYING_OBSIDIAN: (Internal.BlockItem) & (Internal.Item);
    static RAISER_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static CREEPER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static BAMBOO_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static SCULK_SHRIEKER: (Internal.BlockItem) & (Internal.Item);
    static GOLDEN_HORSE_ARMOR: (Internal.HorseArmorItem) & (Internal.Item);
    static POLISHED_DEEPSLATE: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_WOOL: (Internal.BlockItem) & (Internal.Item);
    static PINK_PETALS: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_DYE: (Internal.DyeItem) & (Internal.Item);
    static CRIMSON_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static PURPLE_CARPET: (Internal.BlockItem) & (Internal.Item);
    static WITHER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static BEETROOT_SOUP: (Internal.BowlFoodItem) & (Internal.Item);
    static CRIMSON_ROOTS: (Internal.BlockItem) & (Internal.Item);
    static BLACKSTONE: (Internal.BlockItem) & (Internal.Item);
    static FLOWERING_AZALEA_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static OAK_BOAT: (Internal.BoatItem) & (Internal.Item);
    static POLISHED_ANDESITE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static BROWN_BED: (Internal.BedItem) & (Internal.Item);
    static BLUE_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_CRIMSON_HYPHAE: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_DEEPSLATE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_WOOD: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static TARGET: (Internal.BlockItem) & (Internal.Item);
    static SOUL_SAND: (Internal.BlockItem) & (Internal.Item);
    static DAYLIGHT_DETECTOR: (Internal.BlockItem) & (Internal.Item);
    static MOOSHROOM_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static LIGHT_BLUE_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static PRISMARINE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static DAMAGED_ANVIL: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static RAW_IRON_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static TROPICAL_FISH_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static BAMBOO_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static INK_SAC: (Internal.InkSacItem) & (Internal.Item);
    static LINGERING_POTION: (Internal.LingeringPotionItem) & (Internal.Item);
    static BRAIN_CORAL: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static GILDED_BLACKSTONE: (Internal.BlockItem) & (Internal.Item);
    static PRISMARINE: (Internal.BlockItem) & (Internal.Item);
    static SOUL_CAMPFIRE: (Internal.BlockItem) & (Internal.Item);
    static LECTERN: (Internal.BlockItem) & (Internal.Item);
    static SHROOMLIGHT: (Internal.BlockItem) & (Internal.Item);
    static GOLD_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static MUD_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_FENCE: (Internal.BlockItem) & (Internal.Item);
    static SNIFFER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static CHERRY_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static PAINTING: (Internal.HangingEntityItem) & (Internal.Item);
    static MANGROVE_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static IRON_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static ARROW: (Internal.ArrowItem) & (Internal.Item);
    static DEAD_BUBBLE_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_DARK_OAK_LOG: (Internal.BlockItem) & (Internal.Item);
    static WHITE_CARPET: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static CRIMSON_STEM: (Internal.BlockItem) & (Internal.Item);
    static SOUL_LANTERN: (Internal.BlockItem) & (Internal.Item);
    static BLUE_BANNER: (Internal.BannerItem) & (Internal.Item);
    static WRITABLE_BOOK: (Internal.WritableBookItem) & (Internal.Item);
    static PURPLE_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static CUT_RED_SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static LIME_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static STRAY_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static STRIPPED_BIRCH_LOG: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE_TILE_WALL: (Internal.BlockItem) & (Internal.Item);
    static SLIME_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static NETHER_WART_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE_TILE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_MOSAIC_SLAB: (Internal.BlockItem) & (Internal.Item);
    static END_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static SKELETON_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static CRIMSON_FENCE: (Internal.BlockItem) & (Internal.Item);
    static SUSPICIOUS_SAND: (Internal.BlockItem) & (Internal.Item);
    static CRACKED_NETHER_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static STRUCTURE_BLOCK: (Internal.GameMasterBlockItem) & (Internal.Item);
    static CAT_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static IRON_BOOTS: (Internal.ArmorItem) & (Internal.Item);
    static STRIPPED_OAK_WOOD: (Internal.BlockItem) & (Internal.Item);
    static PISTON: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_UPGRADE_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static DEEPSLATE_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static COD_BUCKET: (Internal.MobBucketItem) & (Internal.Item);
    static HONEY_BOTTLE: (Internal.HoneyBottleItem) & (Internal.Item);
    static EXPOSED_COPPER: (Internal.BlockItem) & (Internal.Item);
    static MUSIC_DISC_STRAD: (Internal.RecordItem) & (Internal.Item);
    static GREEN_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static PINK_BED: (Internal.BedItem) & (Internal.Item);
    static LADDER: (Internal.BlockItem) & (Internal.Item);
    static SCULK_CATALYST: (Internal.BlockItem) & (Internal.Item);
    static BLUE_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static BLUE_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static SNOW_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_CHEST_RAFT: (Internal.BoatItem) & (Internal.Item);
    static SALMON: (Internal.Item) & (Internal.Item);
    static DISPENSER: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_BOOTS: (Internal.ArmorItem) & (Internal.Item);
    static OAK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static RED_BANNER: (Internal.BannerItem) & (Internal.Item);
    static IRON_AXE: (Internal.AxeItem) & (Internal.Item);
    static DEEPSLATE_LAPIS_ORE: (Internal.BlockItem) & (Internal.Item);
    static SILVERFISH_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static ENDERMAN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static GOLDEN_AXE: (Internal.AxeItem) & (Internal.Item);
    static OAK_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static GRANITE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CHARCOAL: (Internal.Item) & (Internal.Item);
    static WOODEN_PICKAXE: (Internal.PickaxeItem) & (Internal.Item);
    static MELON: (Internal.BlockItem) & (Internal.Item);
    static ECHO_SHARD: (Internal.Item) & (Internal.Item);
    static BAMBOO_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static DIRT_PATH: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE: (Internal.BlockItem) & (Internal.Item);
    static WAYFINDER_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static WHITE_BED: (Internal.BedItem) & (Internal.Item);
    static DIORITE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static RECOVERY_COMPASS: (Internal.Item) & (Internal.Item);
    static SNOW: (Internal.BlockItem) & (Internal.Item);
    static GRAY_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static GHAST_TEAR: (Internal.Item) & (Internal.Item);
    static GOLDEN_CARROT: (Internal.Item) & (Internal.Item);
    static FERN: (Internal.BlockItem) & (Internal.Item);
    static CORNFLOWER: (Internal.BlockItem) & (Internal.Item);
    static CHAIN_COMMAND_BLOCK: (Internal.GameMasterBlockItem) & (Internal.Item);
    static ZOMBIE_VILLAGER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static LIME_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static GREEN_BANNER: (Internal.BannerItem) & (Internal.Item);
    static TRIPWIRE_HOOK: (Internal.BlockItem) & (Internal.Item);
    static EVOKER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static SALMON_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static DEEPSLATE_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static RAW_GOLD: (Internal.Item) & (Internal.Item);
    static BIRCH_SIGN: (Internal.SignItem) & (Internal.Item);
    static FROGSPAWN: (Internal.PlaceOnWaterBlockItem) & (Internal.Item);
    static SADDLE: (Internal.SaddleItem) & (Internal.Item);
    static YELLOW_WOOL: (Internal.BlockItem) & (Internal.Item);
    static TRIDENT: (Internal.TridentItem) & (Internal.Item);
    static LIGHT_BLUE_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static WARPED_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static SLIME_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static OAK_WOOD: (Internal.BlockItem) & (Internal.Item);
    static ENDER_CHEST: (Internal.BlockItem) & (Internal.Item);
    static REDSTONE_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_BED: (Internal.BedItem) & (Internal.Item);
    static CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static WANDERING_TRADER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static WAXED_CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CRIMSON_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static WAXED_WEATHERED_CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static WAXED_OXIDIZED_CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static QUARTZ_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_SLAB: (Internal.BlockItem) & (Internal.Item);
    static RAIL: (Internal.BlockItem) & (Internal.Item);
    static EMERALD_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static POPPY: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static ANDESITE_WALL: (Internal.BlockItem) & (Internal.Item);
    static LEATHER_HELMET: (Internal.DyeableArmorItem) & (Internal.Item);
    static ACACIA_SAPLING: (Internal.BlockItem) & (Internal.Item);
    static CARTOGRAPHY_TABLE: (Internal.BlockItem) & (Internal.Item);
    static RED_TULIP: (Internal.BlockItem) & (Internal.Item);
    static TRAPPED_CHEST: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_LOG: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_LOG: (Internal.BlockItem) & (Internal.Item);
    static CHIPPED_ANVIL: (Internal.BlockItem) & (Internal.Item);
    static MAGMA_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static GUNPOWDER: (Internal.Item) & (Internal.Item);
    static OXIDIZED_COPPER: (Internal.BlockItem) & (Internal.Item);
    static BLACK_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static BLUE_DYE: (Internal.DyeItem) & (Internal.Item);
    static PACKED_ICE: (Internal.BlockItem) & (Internal.Item);
    static PEONY: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static CRIMSON_FUNGUS: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_WOOD: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static BEETROOT_SEEDS: (Internal.ItemNameBlockItem) & (Internal.Item);
    static IRON_CHESTPLATE: (Internal.ArmorItem) & (Internal.Item);
    static GOLDEN_APPLE: (Internal.Item) & (Internal.Item);
    static LIGHT_BLUE_BED: (Internal.BedItem) & (Internal.Item);
    static WARPED_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static CACTUS: (Internal.BlockItem) & (Internal.Item);
    static TORCH: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static GLASS_BOTTLE: (Internal.BottleItem) & (Internal.Item);
    static MAGENTA_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static STRUCTURE_VOID: (Internal.BlockItem) & (Internal.Item);
    static DEAD_TUBE_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static GREEN_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static MUSIC_DISC_BLOCKS: (Internal.RecordItem) & (Internal.Item);
    static COOKED_BEEF: (Internal.Item) & (Internal.Item);
    static DIAMOND_SHOVEL: (Internal.ShovelItem) & (Internal.Item);
    static WOODEN_SWORD: (Internal.SwordItem) & (Internal.Item);
    static CRIMSON_SIGN: (Internal.SignItem) & (Internal.Item);
    static NETHER_BRICK: (Internal.Item) & (Internal.Item);
    static STONE_AXE: (Internal.AxeItem) & (Internal.Item);
    static DEAD_BUSH: (Internal.BlockItem) & (Internal.Item);
    static CYAN_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static DEEPSLATE_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static WHITE_BANNER: (Internal.BannerItem) & (Internal.Item);
    static GRANITE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static MOSSY_STONE_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static OAK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static DEAD_BUBBLE_CORAL: (Internal.BlockItem) & (Internal.Item);
    static WARPED_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static MINER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static BROWN_MUSHROOM: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static WOLF_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static MAGENTA_BANNER: (Internal.BannerItem) & (Internal.Item);
    static CYAN_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static WAXED_EXPOSED_CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static RAW_IRON: (Internal.Item) & (Internal.Item);
    static WEATHERED_CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static RED_SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_DARK_OAK_WOOD: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_FENCE: (Internal.BlockItem) & (Internal.Item);
    static INFESTED_DEEPSLATE: (Internal.BlockItem) & (Internal.Item);
    static IRON_BARS: (Internal.BlockItem) & (Internal.Item);
    static SANDSTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static BEDROCK: (Internal.BlockItem) & (Internal.Item);
    static MOURNER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static STRIPPED_CHERRY_LOG: (Internal.BlockItem) & (Internal.Item);
    static TNT_MINECART: (Internal.MinecartItem) & (Internal.Item);
    static BEE_NEST: (Internal.BlockItem) & (Internal.Item);
    static ACTIVATOR_RAIL: (Internal.BlockItem) & (Internal.Item);
    static MUSIC_DISC_5: (Internal.RecordItem) & (Internal.Item);
    static DEAD_FIRE_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static GOLDEN_HELMET: (Internal.ArmorItem) & (Internal.Item);
    static STRIPPED_WARPED_HYPHAE: (Internal.BlockItem) & (Internal.Item);
    static MAGENTA_CARPET: (Internal.BlockItem) & (Internal.Item);
    static TORCHFLOWER_SEEDS: (Internal.ItemNameBlockItem) & (Internal.Item);
    static HONEY_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_ACACIA_LOG: (Internal.BlockItem) & (Internal.Item);
    static FRIEND_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static RAW_GOLD_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static WARPED_FUNGUS_ON_A_STICK: Internal.Item;
    static SMOOTH_SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_SAPLING: (Internal.BlockItem) & (Internal.Item);
    static DOLPHIN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static NETHERITE_PICKAXE: (Internal.PickaxeItem) & (Internal.Item);
    static GRANITE_WALL: (Internal.BlockItem) & (Internal.Item);
    static BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static LIME_WOOL: (Internal.BlockItem) & (Internal.Item);
    static CHAINMAIL_CHESTPLATE: (Internal.ArmorItem) & (Internal.Item);
    static WOODEN_HOE: (Internal.HoeItem) & (Internal.Item);
    static HORSE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static WATER_BUCKET: (Internal.BucketItem) & (Internal.Item);
    static SMOOTH_QUARTZ_SLAB: (Internal.BlockItem) & (Internal.Item);
    static WAXED_CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static HORN_CORAL: (Internal.BlockItem) & (Internal.Item);
    static BLACKSTONE_WALL: (Internal.BlockItem) & (Internal.Item);
    static MUSIC_DISC_STAL: (Internal.RecordItem) & (Internal.Item);
    static SPONGE: (Internal.BlockItem) & (Internal.Item);
    static PIGLIN_BANNER_PATTERN: (Internal.BannerPatternItem) & (Internal.Item);
    static RAW_COPPER: (Internal.Item) & (Internal.Item);
    static DARK_OAK_BOAT: (Internal.BoatItem) & (Internal.Item);
    static REDSTONE_ORE: (Internal.BlockItem) & (Internal.Item);
    static ANDESITE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BOWL: (Internal.Item) & (Internal.Item);
    static BLACK_WOOL: (Internal.BlockItem) & (Internal.Item);
    static COBBLED_DEEPSLATE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static BEEF: (Internal.Item) & (Internal.Item);
    static COBBLESTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static CYAN_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static SPRUCE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static HEARTBREAK_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static CRIMSON_HYPHAE: (Internal.BlockItem) & (Internal.Item);
}
type Items_ = Items;
declare interface NBTIO {
    write(path: Internal.Path_, nbt: Internal.CompoundTag_): void;
    read(path: Internal.Path_): Internal.CompoundTag;
}
type NBTIO_ = NBTIO;
declare const NBTIO: NBTIO;
declare class SoundType {
    constructor(arg0: number, arg1: number, arg2: Internal.SoundEvent_, arg3: Internal.SoundEvent_, arg4: Internal.SoundEvent_, arg5: Internal.SoundEvent_, arg6: Internal.SoundEvent_)
    getClass(): typeof any;
    toString(): string;
    notifyAll(): void;
    getHitSound(): Internal.SoundEvent;
    getStepSound(): Internal.SoundEvent;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    getFallSound(): Internal.SoundEvent;
    getPlaceSound(): Internal.SoundEvent;
    getVolume(): number;
    hashCode(): number;
    getPitch(): number;
    wait(): void;
    wait(arg0: number): void;
    getBreakSound(): Internal.SoundEvent;
    equals(arg0: any): boolean;
    get class(): typeof any
    get hitSound(): Internal.SoundEvent
    get stepSound(): Internal.SoundEvent
    get fallSound(): Internal.SoundEvent
    get placeSound(): Internal.SoundEvent
    get volume(): number
    get pitch(): number
    get breakSound(): Internal.SoundEvent
    static readonly EMPTY: (SoundType) & (SoundType);
    static readonly SAND: (SoundType) & (SoundType);
    static readonly DECORATED_POT: (SoundType) & (SoundType);
    static readonly TUFF: (SoundType) & (SoundType);
    static readonly GRAVEL: (SoundType) & (SoundType);
    static readonly SHROOMLIGHT: (SoundType) & (SoundType);
    static readonly MOSS: (SoundType) & (SoundType);
    readonly pitch: number;
    static readonly GRASS: (SoundType) & (SoundType);
    static readonly SOUL_SOIL: (SoundType) & (SoundType);
    static readonly WEEPING_VINES: (SoundType) & (SoundType);
    static readonly ANCIENT_DEBRIS: (SoundType) & (SoundType);
    static readonly SCULK_SENSOR: (SoundType) & (SoundType);
    static readonly POINTED_DRIPSTONE: (SoundType) & (SoundType);
    static readonly ROOTED_DIRT: (SoundType) & (SoundType);
    static readonly FROGSPAWN: (SoundType) & (SoundType);
    static readonly NETHER_ORE: (SoundType) & (SoundType);
    static readonly COPPER: (SoundType) & (SoundType);
    static readonly LANTERN: (SoundType) & (SoundType);
    static readonly BONE_BLOCK: (SoundType) & (SoundType);
    static readonly FROGLIGHT: (SoundType) & (SoundType);
    static readonly SNOW: (SoundType) & (SoundType);
    static readonly SCULK_VEIN: (SoundType) & (SoundType);
    static readonly CHERRY_WOOD: (SoundType) & (SoundType);
    static readonly POLISHED_DEEPSLATE: (SoundType) & (SoundType);
    static readonly NYLIUM: (SoundType) & (SoundType);
    static readonly DEEPSLATE: (SoundType) & (SoundType);
    static readonly SPORE_BLOSSOM: (SoundType) & (SoundType);
    static readonly BASALT: (SoundType) & (SoundType);
    static readonly CHERRY_WOOD_HANGING_SIGN: (SoundType) & (SoundType);
    static readonly SMALL_AMETHYST_BUD: (SoundType) & (SoundType);
    static readonly CANDLE: (SoundType) & (SoundType);
    static readonly FLOWERING_AZALEA: (SoundType) & (SoundType);
    static readonly ANVIL: (SoundType) & (SoundType);
    static readonly SCAFFOLDING: (SoundType) & (SoundType);
    static readonly DEEPSLATE_BRICKS: (SoundType) & (SoundType);
    static readonly CORAL_BLOCK: (SoundType) & (SoundType);
    static readonly BAMBOO_SAPLING: (SoundType) & (SoundType);
    static readonly LILY_PAD: (SoundType) & (SoundType);
    static readonly MOSS_CARPET: (SoundType) & (SoundType);
    static readonly LADDER: (SoundType) & (SoundType);
    static readonly LARGE_AMETHYST_BUD: (SoundType) & (SoundType);
    static readonly GLOW_LICHEN: (SoundType) & (SoundType);
    static readonly CROP: (SoundType) & (SoundType);
    static readonly PINK_PETALS: (SoundType) & (SoundType);
    static readonly AZALEA_LEAVES: (SoundType) & (SoundType);
    static readonly POWDER_SNOW: (SoundType) & (SoundType);
    static readonly METAL: (SoundType) & (SoundType);
    static readonly HONEY_BLOCK: (SoundType) & (SoundType);
    static readonly NETHER_BRICKS: (SoundType) & (SoundType);
    static readonly SUSPICIOUS_SAND: (SoundType) & (SoundType);
    static readonly GILDED_BLACKSTONE: (SoundType) & (SoundType);
    static readonly HARD_CROP: (SoundType) & (SoundType);
    static readonly SCULK_CATALYST: (SoundType) & (SoundType);
    static readonly DEEPSLATE_TILES: (SoundType) & (SoundType);
    static readonly PACKED_MUD: (SoundType) & (SoundType);
    static readonly SCULK: (SoundType) & (SoundType);
    static readonly VINE: (SoundType) & (SoundType);
    static readonly BAMBOO: (SoundType) & (SoundType);
    static readonly GLASS: (SoundType) & (SoundType);
    static readonly DRIPSTONE_BLOCK: (SoundType) & (SoundType);
    static readonly CHERRY_SAPLING: (SoundType) & (SoundType);
    static readonly CALCITE: (SoundType) & (SoundType);
    static readonly MUD_BRICKS: (SoundType) & (SoundType);
    static readonly STEM: (SoundType) & (SoundType);
    static readonly BAMBOO_WOOD: (SoundType) & (SoundType);
    static readonly SOUL_SAND: (SoundType) & (SoundType);
    static readonly MUD: (SoundType) & (SoundType);
    static readonly BIG_DRIPLEAF: (SoundType) & (SoundType);
    static readonly BAMBOO_WOOD_HANGING_SIGN: (SoundType) & (SoundType);
    static readonly TWISTING_VINES: (SoundType) & (SoundType);
    static readonly NETHERRACK: (SoundType) & (SoundType);
    static readonly AMETHYST_CLUSTER: (SoundType) & (SoundType);
    static readonly SLIME_BLOCK: (SoundType) & (SoundType);
    static readonly SCULK_SHRIEKER: (SoundType) & (SoundType);
    static readonly CHAIN: (SoundType) & (SoundType);
    static readonly WOOD: (SoundType) & (SoundType);
    static readonly AZALEA: (SoundType) & (SoundType);
    static readonly MANGROVE_ROOTS: (SoundType) & (SoundType);
    static readonly CHISELED_BOOKSHELF: (SoundType) & (SoundType);
    static readonly NETHER_GOLD_ORE: (SoundType) & (SoundType);
    static readonly CHERRY_LEAVES: (SoundType) & (SoundType);
    static readonly AMETHYST: (SoundType) & (SoundType);
    static readonly DECORATED_POT_CRACKED: (SoundType) & (SoundType);
    static readonly CAVE_VINES: (SoundType) & (SoundType);
    static readonly SUSPICIOUS_GRAVEL: (SoundType) & (SoundType);
    static readonly LODESTONE: (SoundType) & (SoundType);
    readonly volume: number;
    static readonly FUNGUS: (SoundType) & (SoundType);
    static readonly SMALL_DRIPLEAF: (SoundType) & (SoundType);
    static readonly HANGING_ROOTS: (SoundType) & (SoundType);
    static readonly SWEET_BERRY_BUSH: (SoundType) & (SoundType);
    static readonly NETHER_WOOD: (SoundType) & (SoundType);
    static readonly NETHER_WART: (SoundType) & (SoundType);
    static readonly STONE: (SoundType) & (SoundType);
    static readonly NETHER_WOOD_HANGING_SIGN: (SoundType) & (SoundType);
    static readonly HANGING_SIGN: (SoundType) & (SoundType);
    static readonly WET_GRASS: (SoundType) & (SoundType);
    static readonly NETHERITE_BLOCK: (SoundType) & (SoundType);
    static readonly MEDIUM_AMETHYST_BUD: (SoundType) & (SoundType);
    static readonly MUDDY_MANGROVE_ROOTS: (SoundType) & (SoundType);
    static readonly WOOL: (SoundType) & (SoundType);
    static readonly ROOTS: (SoundType) & (SoundType);
    static readonly WART_BLOCK: (SoundType) & (SoundType);
    static readonly NETHER_SPROUTS: (SoundType) & (SoundType);
}
type SoundType_ = SoundType;
declare class EnchantmentInstance extends Internal.WeightedEntry$IntrusiveBase {
    constructor(arg0: Internal.Enchantment_, arg1: number)
    getClass(): typeof any;
    hashCode(): number;
    toString(): string;
    wait(): void;
    getWeight(): Internal.Weight;
    notifyAll(): void;
    static wrap<T>(arg0: T, arg1: number): Internal.WeightedEntry$Wrapper<T>;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    get class(): typeof any
    get weight(): Internal.Weight
    readonly level: number;
    readonly enchantment: Internal.Enchantment;
}
type EnchantmentInstance_ = EnchantmentInstance;
declare class Duration implements Internal.TemporalAmount, Internal.Comparable<Duration>, Internal.Serializable {
    "dividedBy(java.time.Duration)"(arg0: Duration_): number;
    static parse(arg0: Internal.CharSequence_): Duration;
    notify(): void;
    compareTo(arg0: any): number;
    minusHours(arg0: number): this;
    plusMillis(arg0: number): this;
    toNanosPart(): number;
    getUnits(): Internal.List<Internal.TemporalUnit>;
    multipliedBy(arg0: number): this;
    dividedBy(arg0: number): this;
    get(arg0: Internal.TemporalUnit_): number;
    minusNanos(arg0: number): this;
    static ofSeconds(arg0: number): Duration;
    isNegative(): boolean;
    minus(arg0: Duration_): this;
    static ofMinutes(arg0: number): Duration;
    static ofNanos(arg0: number): Duration;
    toDays(): number;
    toHoursPart(): number;
    minusDays(arg0: number): this;
    toSecondsPart(): number;
    static ofMillis(arg0: number): Duration;
    wait(): void;
    plusNanos(arg0: number): this;
    "compareTo(java.lang.Object)"(arg0: any): number;
    minusSeconds(arg0: number): this;
    toMinutes(): number;
    plus(arg0: number, arg1: Internal.TemporalUnit_): this;
    getClass(): typeof any;
    toMillis(): number;
    toHours(): number;
    getSeconds(): number;
    static ofSeconds(arg0: number, arg1: number): Duration;
    toMinutesPart(): number;
    isZero(): boolean;
    wait(arg0: number, arg1: number): void;
    static of(arg0: number, arg1: Internal.TemporalUnit_): Duration;
    withSeconds(arg0: number): this;
    static between(arg0: Internal.Temporal_, arg1: Internal.Temporal_): Duration;
    plusSeconds(arg0: number): this;
    plusMinutes(arg0: number): this;
    toNanos(): number;
    negated(): this;
    static ofDays(arg0: number): Duration;
    addTo(arg0: Internal.Temporal_): Internal.Temporal;
    compareTo(arg0: Duration_): number;
    toString(): string;
    minus(arg0: number, arg1: Internal.TemporalUnit_): this;
    plus(arg0: Duration_): this;
    notifyAll(): void;
    toDaysPart(): number;
    "compareTo(java.time.Duration)"(arg0: Duration_): number;
    plusDays(arg0: number): this;
    static from(arg0: Internal.TemporalAmount_): Duration;
    getNano(): number;
    plusHours(arg0: number): this;
    truncatedTo(arg0: Internal.TemporalUnit_): this;
    subtractFrom(arg0: Internal.Temporal_): Internal.Temporal;
    hashCode(): number;
    minusMillis(arg0: number): this;
    wait(arg0: number): void;
    dividedBy(arg0: Duration_): number;
    equals(arg0: any): boolean;
    abs(): this;
    static ofHours(arg0: number): Duration;
    minusMinutes(arg0: number): this;
    withNanos(arg0: number): this;
    "dividedBy(long)"(arg0: number): this;
    toSeconds(): number;
    toMillisPart(): number;
    get units(): Internal.List<Internal.TemporalUnit>
    get negative(): boolean
    get class(): typeof any
    get seconds(): number
    get zero(): boolean
    get nano(): number
    static readonly ZERO: (Duration) & (Duration);
}
type Duration_ = Duration;
declare class OutputItem implements Internal.OutputReplacement {
    getClass(): typeof any;
    getCount(): number;
    withRolls(rolls: Internal.IntProvider_): this;
    static of(from: any): OutputItem;
    isEmpty(): boolean;
    notify(): void;
    withCount(count: number): this;
    wait(arg0: number, arg1: number): void;
    weakNBT(): InputItem;
    strongNBT(): InputItem;
    replaceOutput(recipe: Internal.RecipeJS_, match: Internal.ReplacementMatch_, original: Internal.OutputReplacement_): any;
    withChance(chance: number): this;
    withRolls(min: number, max: number): this;
    getNbt(): Internal.CompoundTag;
    toString(): string;
    transform(transformer: Internal.OutputReplacementTransformer_): Internal.OutputReplacementTransformer$Replacement;
    notifyAll(): void;
    getChance(): number;
    static of(item: Internal.ItemStack_, chance: number): OutputItem;
    hashCode(): number;
    wait(): void;
    wait(arg0: number): void;
    hasChance(): boolean;
    equals(arg0: any): boolean;
    /**
     * @deprecated
    */
    ignoreNBT(): InputItem;
    get class(): typeof any
    get count(): number
    get empty(): boolean
    get nbt(): Internal.CompoundTag
    get chance(): number
    static readonly EMPTY: (OutputItem) & (OutputItem);
    readonly item: Internal.ItemStack;
    readonly rolls: Internal.IntProvider;
    readonly chance: number;
}
type OutputItem_ = Internal.ItemStack_ | OutputItem;
declare interface Comparator <T> {
    abstract compare(arg0: T, arg1: T): number;
    comparing<T, U extends Internal.Comparable<any>>(arg0: Internal.Function_<T, U>): this;
    reverseOrder<T extends Internal.Comparable<any>>(): this;
    thenComparing<U extends Internal.Comparable<any>>(arg0: Internal.Function_<T, U>): this;
    "thenComparing(java.util.function.Function)"<U extends Internal.Comparable<any>>(arg0: Internal.Function_<T, U>): this;
    reversed(): this;
    naturalOrder<T extends Internal.Comparable<any>>(): this;
    "thenComparing(java.util.Comparator)"(arg0: Comparator_<T>): this;
    thenComparingLong(arg0: Internal.ToLongFunction_<T>): this;
    comparingInt<T>(arg0: Internal.ToIntFunction_<T>): this;
    thenComparingDouble(arg0: Internal.ToDoubleFunction_<T>): this;
    nullsFirst<T>(arg0: Comparator_<T>): this;
    comparingLong<T>(arg0: Internal.ToLongFunction_<T>): this;
    comparingDouble<T>(arg0: Internal.ToDoubleFunction_<T>): this;
    nullsLast<T>(arg0: Comparator_<T>): this;
    thenComparing<U>(arg0: Internal.Function_<T, U>, arg1: Comparator_<U>): this;
    thenComparing(arg0: Comparator_<T>): this;
    abstract equals(arg0: any): boolean;
    comparing<T, U>(arg0: Internal.Function_<T, U>, arg1: Comparator_<U>): this;
    thenComparingInt(arg0: Internal.ToIntFunction_<T>): this;
}
type Comparator_<T> = Comparator<T>;
declare const Comparator: Comparator;
declare class DamageSource {
    constructor(arg0: Internal.Holder_<Internal.DamageType>)
    constructor(arg0: Internal.Holder_<Internal.DamageType>, arg1: Internal.Entity_, arg2: Internal.Entity_)
    constructor(arg0: Internal.Holder_<Internal.DamageType>, arg1: Internal.Entity_)
    constructor(arg0: Internal.Holder_<Internal.DamageType>, arg1: Vec3d_)
    constructor(arg0: Internal.Holder_<Internal.DamageType>, arg1: Internal.Entity_, arg2: Internal.Entity_, arg3: Vec3d_)
    getClass(): typeof any;
    getSourcePosition(): Vec3d;
    scalesWithDifficulty(): boolean;
    typeHolder(): Internal.Holder<Internal.DamageType>;
    "is(net.minecraft.tags.TagKey)"(arg0: Internal.TagKey_<Internal.DamageType>): boolean;
    notify(): void;
    getLocalizedDeathMessage(arg0: Internal.LivingEntity_): net.minecraft.network.chat.Component;
    wait(arg0: number, arg1: number): void;
    is(arg0: Internal.TagKey_<Internal.DamageType>): boolean;
    type(): Internal.DamageType;
    "is(net.minecraft.resources.ResourceKey)"(arg0: Internal.ResourceKey_<Internal.DamageType>): boolean;
    getType(): string;
    getActual(): Internal.Entity;
    getPlayer(): Internal.Player;
    toString(): string;
    isIndirect(): boolean;
    getImmediate(): Internal.Entity;
    notifyAll(): void;
    getFoodExhaustion(): number;
    sourcePositionRaw(): Vec3d;
    is(arg0: Internal.ResourceKey_<Internal.DamageType>): boolean;
    hashCode(): number;
    isCreativePlayer(): boolean;
    wait(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    get class(): typeof any
    get sourcePosition(): Vec3d
    get type(): string
    get actual(): Internal.Entity
    get player(): Internal.Player
    get indirect(): boolean
    get immediate(): Internal.Entity
    get foodExhaustion(): number
    get creativePlayer(): boolean
}
type DamageSource_ = DamageSource;
declare class Platform {
    constructor()
    getClass(): typeof any;
    static getMcVersion(): string;
    static isForge(): boolean;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    static isFabric(): boolean;
    static isGeneratingData(): boolean;
    static getInfo(modID: string): Internal.PlatformWrapper$ModInfo;
    static isLoaded(modId: string): boolean;
    static getName(): string;
    static setModName(modId: string, name: string): void;
    static getMinecraftVersion(): number;
    static isDevelopmentEnvironment(): boolean;
    static getList(): Internal.Set<string>;
    toString(): string;
    notifyAll(): void;
    static isClientEnvironment(): boolean;
    static getModVersion(): string;
    static breakpoint(...args: any[]): void;
    hashCode(): number;
    static getMinecraftVersionString(): string;
    static getMods(): Internal.Map<string, Internal.PlatformWrapper$ModInfo>;
    wait(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    get class(): typeof any
    get mcVersion(): string
    get forge(): boolean
    get fabric(): boolean
    get generatingData(): boolean
    get name(): string
    get minecraftVersion(): number
    get developmentEnvironment(): boolean
    get list(): Internal.Set<string>
    get clientEnvironment(): boolean
    get modVersion(): string
    get minecraftVersionString(): string
    get mods(): Internal.Map<string, Internal.PlatformWrapper$ModInfo>
}
type Platform_ = Platform;
declare class Vec3f implements Internal.Cloneable, Internal.Vector3fc, Internal.Externalizable {
    constructor()
    constructor(arg0: Internal.Vector3fc_)
    constructor(arg0: Internal.FloatBuffer_)
    constructor(arg0: number, arg1: Internal.FloatBuffer_)
    constructor(arg0: number[])
    constructor(arg0: number)
    constructor(arg0: Internal.Vector2fc_, arg1: number)
    constructor(arg0: Internal.ByteBuffer_)
    constructor(arg0: Internal.Vector2ic_, arg1: number)
    constructor(arg0: number, arg1: Internal.ByteBuffer_)
    constructor(arg0: number, arg1: number, arg2: number)
    constructor(arg0: Internal.Vector3ic_)
    "set(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): this;
    "get(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    set(arg0: number, arg1: number, arg2: number): this;
    get(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    div(arg0: number, arg1: number, arg2: number): this;
    rotateY(arg0: number): this;
    "mul(org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    angleCos(arg0: Internal.Vector3fc_): number;
    "fma(float,org.joml.Vector3fc)"(arg0: number, arg1: Internal.Vector3fc_): this;
    set(arg0: number): this;
    "set(float)"(arg0: number): this;
    static length(arg0: number, arg1: number, arg2: number): number;
    mulAdd(arg0: number, arg1: Internal.Vector3fc_): this;
    normalize(arg0: number, arg1: Vec3f_): this;
    sub(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    half(arg0: number, arg1: number, arg2: number): this;
    round(): this;
    "fma(org.joml.Vector3fc,org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    "mulAdd(org.joml.Vector3fc,org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    orthogonalizeUnit(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    "div(float)"(arg0: number): this;
    "get(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    add(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    get(arg0: number): number;
    "mulAdd(float,org.joml.Vector3fc,org.joml.Vector3f)"(arg0: number, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    mul(arg0: number, arg1: number, arg2: number): this;
    ceil(arg0: Vec3f_): this;
    negate(): this;
    getClass(): typeof any;
    "mulPosition(org.joml.Matrix4x3fc,org.joml.Vector3f)"(arg0: Internal.Matrix4x3fc_, arg1: Vec3f_): this;
    add(arg0: Internal.Vector3fc_): this;
    static lengthSquared(arg0: number, arg1: number, arg2: number): number;
    ceil(): this;
    div(arg0: number, arg1: Vec3f_): this;
    distanceSquared(arg0: number, arg1: number, arg2: number): number;
    "div(float,org.joml.Vector3f)"(arg0: number, arg1: Vec3f_): this;
    "mulDirection(org.joml.Matrix4dc)"(arg0: Internal.Matrix4dc_): this;
    add(arg0: number, arg1: number, arg2: number): this;
    mulTransposeDirection(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    rotateZ(arg0: number): this;
    distanceSquared(arg0: Internal.Vector3fc_): number;
    set(arg0: number[]): this;
    equals(arg0: Internal.Vector3fc_, arg1: number): boolean;
    "set(double)"(arg0: number): this;
    "normalize(float)"(arg0: number): this;
    mulAdd(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    div(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    max(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    lerp(arg0: Internal.Vector3fc_, arg1: number, arg2: Vec3f_): this;
    "mulAdd(org.joml.Vector3fc,org.joml.Vector3fc)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    mulPositionW(arg0: Internal.Matrix4fc_): number;
    mulPosition(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    rotationTo(arg0: number, arg1: number, arg2: number, arg3: Quaternionf_): Quaternionf;
    "mul(org.joml.Matrix3x2fc,org.joml.Vector3f)"(arg0: Internal.Matrix3x2fc_, arg1: Vec3f_): this;
    mul(arg0: Internal.Matrix3x2fc_): this;
    "set(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): this;
    mulDirection(arg0: Internal.Matrix4x3fc_, arg1: Vec3f_): this;
    reflect(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    "mulDirection(org.joml.Matrix4fc,org.joml.Vector3f)"(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    wait(arg0: number): void;
    rotateZ(arg0: number, arg1: Vec3f_): this;
    mul(arg0: Internal.Matrix3fc_): this;
    "mulDirection(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    absolute(arg0: Vec3f_): this;
    angleSigned(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): number;
    normalize(arg0: number): this;
    normalize(arg0: Vec3f_): this;
    normalize(): this;
    mulProject(arg0: Internal.Matrix4fc_, arg1: number, arg2: Vec3f_): this;
    reflect(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    mul(arg0: Internal.Vector3fc_): this;
    isFinite(): boolean;
    mulTransposePosition(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    set(arg0: number, arg1: Internal.FloatBuffer_): this;
    getToAddress(arg0: number): Internal.Vector3fc;
    "mulDirection(org.joml.Matrix4dc,org.joml.Vector3f)"(arg0: Internal.Matrix4dc_, arg1: Vec3f_): this;
    "mul(org.joml.Matrix3dc,org.joml.Vector3f)"(arg0: Internal.Matrix3dc_, arg1: Vec3f_): this;
    "mulDirection(org.joml.Matrix4x3fc,org.joml.Vector3f)"(arg0: Internal.Matrix4x3fc_, arg1: Vec3f_): this;
    x(): number;
    absolute(): this;
    mulDirection(arg0: Internal.Matrix4dc_): this;
    "set(float,float,float)"(arg0: number, arg1: number, arg2: number): this;
    "set(org.joml.Vector2dc,float)"(arg0: Internal.Vector2dc_, arg1: number): this;
    mulDirection(arg0: Internal.Matrix4dc_, arg1: Vec3f_): this;
    mulAdd(arg0: number, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    "mul(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_): this;
    fma(arg0: number, arg1: Internal.Vector3fc_): this;
    wait(): void;
    get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    sub(arg0: Internal.Vector3fc_): this;
    minComponent(): number;
    set(arg0: Internal.Vector3fc_): this;
    orthogonalize(arg0: Internal.Vector3fc_): this;
    rotate(arg0: Internal.Quaternionfc_, arg1: Vec3f_): this;
    "set(org.joml.Vector2ic,float)"(arg0: Internal.Vector2ic_, arg1: number): this;
    set(arg0: Internal.ByteBuffer_): this;
    "mul(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    "set(org.joml.Vector3dc)"(arg0: Internal.Vector3dc_): this;
    rotateX(arg0: number): this;
    round(arg0: Vec3f_): this;
    half(arg0: Internal.Vector3fc_): this;
    mul(arg0: Internal.Matrix3dc_, arg1: Vec3f_): this;
    static distance(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): number;
    mul(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    "normalize(org.joml.Vector3f)"(arg0: Vec3f_): this;
    "set(float[])"(arg0: number[]): this;
    y(): number;
    mul(arg0: Internal.Matrix3x2fc_, arg1: Vec3f_): this;
    "get(int,org.joml.Vector3i)"(arg0: number, arg1: Internal.Vector3i_): Internal.Vector3i;
    set(arg0: Internal.Vector2fc_, arg1: number): this;
    distance(arg0: Internal.Vector3fc_): number;
    "mul(org.joml.Matrix3fc,org.joml.Vector3f)"(arg0: Internal.Matrix3fc_, arg1: Vec3f_): this;
    "mulPosition(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    max(arg0: Internal.Vector3fc_): this;
    equals(arg0: any): boolean;
    setFromAddress(arg0: number): this;
    "mul(float)"(arg0: number): this;
    get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    "mul(org.joml.Matrix3dc)"(arg0: Internal.Matrix3dc_): this;
    "get(org.joml.Vector3f)"(arg0: Vec3f_): this;
    equals(arg0: number, arg1: number, arg2: number): boolean;
    add(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    mulPosition(arg0: Internal.Matrix4x3fc_, arg1: Vec3f_): this;
    mulTransposeDirection(arg0: Internal.Matrix4fc_): this;
    set(arg0: Internal.FloatBuffer_): this;
    "set(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): this;
    z(): number;
    "get(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    mulPositionW(arg0: Internal.Matrix4fc_, arg1: Vec3f_): number;
    mulDirection(arg0: Internal.Matrix4fc_): this;
    "fma(org.joml.Vector3fc,org.joml.Vector3fc)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    toString(arg0: Internal.NumberFormat_): string;
    "get(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    "div(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    lengthSquared(): number;
    mulAdd(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    "set(double,double,double)"(arg0: number, arg1: number, arg2: number): this;
    "set(org.joml.Vector2fc,float)"(arg0: Internal.Vector2fc_, arg1: number): this;
    mulTranspose(arg0: Internal.Matrix3fc_, arg1: Vec3f_): this;
    rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec3f_): this;
    clone(): any;
    cross(arg0: Internal.Vector3fc_): this;
    writeExternal(arg0: Internal.ObjectOutput_): void;
    maxComponent(): number;
    "get(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    set(arg0: Internal.Vector3dc_): this;
    mul(arg0: number): this;
    static distanceSquared(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): number;
    dot(arg0: number, arg1: number, arg2: number): number;
    mulTranspose(arg0: Internal.Matrix3fc_): this;
    set(arg0: number, arg1: Internal.ByteBuffer_): this;
    floor(): this;
    zero(): this;
    reflect(arg0: number, arg1: number, arg2: number): this;
    mulProject(arg0: Internal.Matrix4fc_): this;
    sub(arg0: number, arg1: number, arg2: number): this;
    mulPosition(arg0: Internal.Matrix4x3fc_): this;
    length(): number;
    toString(): string;
    notifyAll(): void;
    "mulPosition(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    "mulPosition(org.joml.Matrix4fc,org.joml.Vector3f)"(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    setComponent(arg0: number, arg1: number): this;
    "mul(org.joml.Matrix3x2fc)"(arg0: Internal.Matrix3x2fc_): this;
    div(arg0: number): this;
    orthogonalize(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    cross(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    div(arg0: Internal.Vector3fc_): this;
    fma(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    set(arg0: number): this;
    rotate(arg0: Internal.Quaternionfc_): this;
    set(arg0: Internal.Vector3ic_): this;
    "mul(float,org.joml.Vector3f)"(arg0: number, arg1: Vec3f_): this;
    min(arg0: Internal.Vector3fc_): this;
    half(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    cross(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    notify(): void;
    "mulAdd(float,org.joml.Vector3fc)"(arg0: number, arg1: Internal.Vector3fc_): this;
    floor(arg0: Vec3f_): this;
    mul(arg0: Internal.Matrix3fc_, arg1: Vec3f_): this;
    half(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    smoothStep(arg0: Internal.Vector3fc_, arg1: number, arg2: Vec3f_): this;
    rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mul(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    set(arg0: Internal.Vector2dc_, arg1: number): this;
    readExternal(arg0: Internal.ObjectInput_): void;
    negate(arg0: Vec3f_): this;
    mul(arg0: number, arg1: Vec3f_): this;
    mulPosition(arg0: Internal.Matrix4fc_): this;
    hermite(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_, arg3: number, arg4: Vec3f_): this;
    get(arg0: Internal.Vector3d_): Internal.Vector3d;
    "set(org.joml.Vector3ic)"(arg0: Internal.Vector3ic_): this;
    get(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    rotateY(arg0: number, arg1: Vec3f_): this;
    "get(int)"(arg0: number): number;
    distance(arg0: number, arg1: number, arg2: number): number;
    "set(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): this;
    dot(arg0: Internal.Vector3fc_): number;
    "set(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    div(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    cross(arg0: number, arg1: number, arg2: number): this;
    orthogonalizeUnit(arg0: Internal.Vector3fc_): this;
    min(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    set(arg0: number, arg1: number, arg2: number): this;
    wait(arg0: number, arg1: number): void;
    "mulDirection(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    set(arg0: Internal.Vector2ic_, arg1: number): this;
    lerp(arg0: Internal.Vector3fc_, arg1: number): this;
    "div(org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    sub(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    rotationTo(arg0: Internal.Vector3fc_, arg1: Quaternionf_): Quaternionf;
    mulTransposePosition(arg0: Internal.Matrix4fc_): this;
    angle(arg0: Internal.Vector3fc_): number;
    mulProject(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    "fma(float,org.joml.Vector3fc,org.joml.Vector3f)"(arg0: number, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    get(arg0: number, arg1: Internal.Vector3i_): Internal.Vector3i;
    fma(arg0: number, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    angleSigned(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): number;
    mulDirection(arg0: Internal.Matrix4x3fc_): this;
    mulDirection(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    hashCode(): number;
    fma(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    get(arg0: Vec3f_): this;
    rotateX(arg0: number, arg1: Vec3f_): this;
    reflect(arg0: Internal.Vector3fc_): this;
    mul(arg0: Internal.Matrix3dc_): this;
    set "(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_)
    set "(float)"(arg0: number)
    get class(): typeof any
    set "(double)"(arg0: number)
    set "(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_)
    get finite(): boolean
    set "(org.joml.Vector3dc)"(arg0: Internal.Vector3dc_)
    set "(float[])"(arg0: number[])
    set fromAddress(arg0: number)
    set "(org.joml.Vector3ic)"(arg0: Internal.Vector3ic_)
    set "(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_)
    z: number;
    y: number;
    x: number;
}
type Vec3f_ = Vec3f;
declare class Vec4f implements Internal.Cloneable, Internal.Vector4fc, Internal.Externalizable {
    constructor()
    constructor(arg0: Internal.FloatBuffer_)
    constructor(arg0: number, arg1: Internal.FloatBuffer_)
    constructor(arg0: Internal.Vector2fc_, arg1: number, arg2: number)
    constructor(arg0: Internal.Vector3fc_, arg1: number)
    constructor(arg0: number[])
    constructor(arg0: number)
    constructor(arg0: Internal.ByteBuffer_)
    constructor(arg0: Internal.Vector2ic_, arg1: number, arg2: number)
    constructor(arg0: number, arg1: Internal.ByteBuffer_)
    constructor(arg0: number, arg1: number, arg2: number, arg3: number)
    constructor(arg0: Internal.Vector4fc_)
    constructor(arg0: Internal.Vector3ic_, arg1: number)
    constructor(arg0: Internal.Vector4ic_)
    min(arg0: Internal.Vector4fc_): this;
    set(arg0: Internal.Vector4ic_): this;
    div(arg0: Internal.Vector4fc_): this;
    "fma(float,org.joml.Vector4fc,org.joml.Vector4f)"(arg0: number, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    normalize3(arg0: Vec4f_): this;
    static distanceSquared(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): number;
    get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    rotateAbout(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "set(float,float,float,float)"(arg0: number, arg1: number, arg2: number, arg3: number): this;
    get(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    mul(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    add(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "div(float)"(arg0: number): this;
    mul(arg0: Internal.Vector4fc_): this;
    dot(arg0: number, arg1: number, arg2: number, arg3: number): number;
    setComponent(arg0: number, arg1: number): this;
    "set(double,double,double,double)"(arg0: number, arg1: number, arg2: number, arg3: number): this;
    fma(arg0: number, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    rotateZ(arg0: number, arg1: Vec4f_): this;
    mulAdd(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    "mul(org.joml.Matrix4fc,org.joml.Vector4f)"(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    z(): number;
    "set(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): this;
    min(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    div(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    "mul(float)"(arg0: number): this;
    "get(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    set(arg0: Internal.Vector2ic_, arg1: number, arg2: number): this;
    dot(arg0: Internal.Vector4fc_): number;
    set(arg0: number, arg1: number, arg2: number): this;
    mulAffine(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    "set(org.joml.Vector2fc,float,float)"(arg0: Internal.Vector2fc_, arg1: number, arg2: number): this;
    toString(arg0: Internal.NumberFormat_): string;
    rotateZ(arg0: number): this;
    "get(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "get(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    "mul(float,org.joml.Vector4f)"(arg0: number, arg1: Vec4f_): this;
    fma(arg0: number, arg1: Internal.Vector4fc_): this;
    normalize3(): this;
    round(arg0: Vec4f_): this;
    div(arg0: number, arg1: number, arg2: number, arg3: number): this;
    lengthSquared(): number;
    mul(arg0: Internal.Matrix4x3fc_): this;
    set(arg0: number, arg1: Internal.ByteBuffer_): this;
    get(arg0: number): number;
    distanceSquared(arg0: Internal.Vector4fc_): number;
    set(arg0: number[]): this;
    sub(arg0: Internal.Vector4fc_): this;
    mulAdd(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_): this;
    set(arg0: Internal.Vector3ic_, arg1: number): this;
    sub(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): this;
    clone(): any;
    getClass(): typeof any;
    mul(arg0: number, arg1: number, arg2: number, arg3: number): this;
    writeExternal(arg0: Internal.ObjectOutput_): void;
    maxComponent(): number;
    "set(org.joml.Vector4ic)"(arg0: Internal.Vector4ic_): this;
    "get(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    set(arg0: Internal.Vector4fc_): this;
    "mul(org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    negate(arg0: Vec4f_): this;
    "set(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): this;
    "fma(float,org.joml.Vector4fc)"(arg0: number, arg1: Internal.Vector4fc_): this;
    get(arg0: Internal.Vector4d_): Internal.Vector4d;
    getToAddress(arg0: number): Internal.Vector4fc;
    rotateY(arg0: number, arg1: Vec4f_): this;
    "get(int,org.joml.Vector4i)"(arg0: number, arg1: Internal.Vector4i_): Internal.Vector4i;
    set(arg0: Internal.Vector3fc_, arg1: number): this;
    "mul(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    "fma(org.joml.Vector4fc,org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    add(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): this;
    static lengthSquared(arg0: number, arg1: number, arg2: number, arg3: number): number;
    ceil(arg0: Vec4f_): this;
    "fma(org.joml.Vector4fc,org.joml.Vector4fc)"(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_): this;
    "mul(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    "set(org.joml.Vector4fc)"(arg0: Internal.Vector4fc_): this;
    negate(): this;
    mulAffineTranspose(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    "mulAdd(float,org.joml.Vector4fc)"(arg0: number, arg1: Internal.Vector4fc_): this;
    w(): number;
    rotate(arg0: Internal.Quaternionfc_): this;
    "set(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): this;
    length(): number;
    toString(): string;
    normalize(arg0: number): this;
    distanceSquared(arg0: number, arg1: number, arg2: number, arg3: number): number;
    mul(arg0: number): this;
    notifyAll(): void;
    ceil(): this;
    smoothStep(arg0: Internal.Vector4fc_, arg1: number, arg2: Vec4f_): this;
    lerp(arg0: Internal.Vector4fc_, arg1: number): this;
    "mul(org.joml.Matrix4x3fc,org.joml.Vector4f)"(arg0: Internal.Matrix4x3fc_, arg1: Vec4f_): this;
    mul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): this;
    floor(arg0: Vec4f_): this;
    mul(arg0: Internal.Matrix4x3fc_, arg1: Vec4f_): this;
    "get(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    div(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): this;
    "set(org.joml.Vector3ic,float)"(arg0: Internal.Vector3ic_, arg1: number): this;
    floor(): this;
    angle(arg0: Internal.Vector4fc_): number;
    wait(arg0: number): void;
    static "lengthSquared(int,int,int,int)"(arg0: number, arg1: number, arg2: number, arg3: number): number;
    "set(org.joml.Vector3fc,float)"(arg0: Internal.Vector3fc_, arg1: number): this;
    max(arg0: Internal.Vector4fc_): this;
    sub(arg0: number, arg1: number, arg2: number, arg3: number): this;
    set(arg0: Internal.FloatBuffer_): this;
    "get(org.joml.Vector4f)"(arg0: Vec4f_): this;
    angleCos(arg0: Internal.Vector4fc_): number;
    "set(float)"(arg0: number): this;
    get(arg0: number, arg1: Internal.Vector4i_): Internal.Vector4i;
    hermite(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Internal.Vector4fc_, arg3: number, arg4: Vec4f_): this;
    "set(float,float,float)"(arg0: number, arg1: number, arg2: number): this;
    absolute(): this;
    distance(arg0: Internal.Vector4fc_): number;
    mul(arg0: number, arg1: Vec4f_): this;
    notify(): void;
    fma(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_): this;
    normalize(): this;
    isFinite(): boolean;
    "normalize(org.joml.Vector4f)"(arg0: Vec4f_): this;
    get(arg0: Vec4f_): this;
    static length(arg0: number, arg1: number, arg2: number, arg3: number): number;
    set(arg0: number, arg1: number, arg2: number, arg3: number): this;
    rotateX(arg0: number, arg1: Vec4f_): this;
    "mul(org.joml.Vector4fc)"(arg0: Internal.Vector4fc_): this;
    lerp(arg0: Internal.Vector4fc_, arg1: number, arg2: Vec4f_): this;
    static distance(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): number;
    div(arg0: number): this;
    setFromAddress(arg0: number): this;
    "div(org.joml.Vector4fc)"(arg0: Internal.Vector4fc_): this;
    mulAdd(arg0: number, arg1: Internal.Vector4fc_): this;
    "div(float,org.joml.Vector4f)"(arg0: number, arg1: Vec4f_): this;
    x(): number;
    absolute(arg0: Vec4f_): this;
    div(arg0: number, arg1: Vec4f_): this;
    readExternal(arg0: Internal.ObjectInput_): void;
    mulTranspose(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    static lengthSquared(arg0: number, arg1: number, arg2: number, arg3: number): number;
    set(arg0: Internal.ByteBuffer_): this;
    "mulProject(org.joml.Matrix4fc,org.joml.Vector4f)"(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    "set(double)"(arg0: number): this;
    "div(org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    get(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    wait(): void;
    fma(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    set(arg0: number, arg1: number, arg2: number, arg3: number): this;
    get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    zero(): this;
    mulProject(arg0: Internal.Matrix4fc_): this;
    "get(int)"(arg0: number): number;
    static "lengthSquared(float,float,float,float)"(arg0: number, arg1: number, arg2: number, arg3: number): number;
    mulAdd(arg0: number, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    mulProject(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    "normalize(float)"(arg0: number): this;
    add(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    rotateX(arg0: number): this;
    minComponent(): number;
    round(): this;
    set(arg0: Internal.Vector4dc_): this;
    "mulAdd(org.joml.Vector4fc,org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    "mulProject(org.joml.Matrix4fc,org.joml.Vector3f)"(arg0: Internal.Matrix4fc_, arg1: Vec3f_): Vec3f;
    add(arg0: Internal.Vector4fc_): this;
    "mulAdd(org.joml.Vector4fc,org.joml.Vector4fc)"(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_): this;
    equals(arg0: Internal.Vector4fc_, arg1: number): boolean;
    wait(arg0: number, arg1: number): void;
    "set(org.joml.Vector2ic,float,float)"(arg0: Internal.Vector2ic_, arg1: number, arg2: number): this;
    sub(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    mulTranspose(arg0: Internal.Matrix4fc_): this;
    max(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    equals(arg0: number, arg1: number, arg2: number, arg3: number): boolean;
    "mulAdd(float,org.joml.Vector4fc,org.joml.Vector4f)"(arg0: number, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    mulProject(arg0: Internal.Matrix4fc_, arg1: Vec3f_): Vec3f;
    rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): this;
    y(): number;
    rotate(arg0: Internal.Quaternionfc_, arg1: Vec4f_): this;
    mul(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    normalize(arg0: Vec4f_): this;
    set(arg0: number): this;
    rotateY(arg0: number): this;
    hashCode(): number;
    set(arg0: Internal.Vector2fc_, arg1: number, arg2: number): this;
    distance(arg0: number, arg1: number, arg2: number, arg3: number): number;
    set(arg0: number, arg1: Internal.FloatBuffer_): this;
    "set(org.joml.Vector4dc)"(arg0: Internal.Vector4dc_): this;
    set(arg0: number): this;
    equals(arg0: any): boolean;
    mul(arg0: Internal.Matrix4fc_): this;
    "set(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): this;
    "set(float[])"(arg0: number[]): this;
    normalize(arg0: number, arg1: Vec4f_): this;
    get class(): typeof any
    set "(org.joml.Vector4ic)"(arg0: Internal.Vector4ic_)
    set "(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_)
    set "(org.joml.Vector4fc)"(arg0: Internal.Vector4fc_)
    set "(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_)
    set "(float)"(arg0: number)
    get finite(): boolean
    set fromAddress(arg0: number)
    set "(double)"(arg0: number)
    set "(org.joml.Vector4dc)"(arg0: Internal.Vector4dc_)
    set "(float[])"(arg0: number[])
    z: number;
    y: number;
    x: number;
    w: number;
}
type Vec4f_ = Vec4f;
declare interface UUID {
    toString(id: Internal.UUID_): string;
    digits(sb: Internal.StringBuilder_, val: number, digits: number): void;
    fromString(o: any): Internal.UUID;
}
type UUID_ = UUID;
declare const UUID: UUID;
/**
 * Various Ingredient related helper methods
*/
declare interface Ingredient {
    /**
     * Returns an ingredient of the input
    */
    of(ingredient: Internal.Ingredient_): Internal.Ingredient;
    /**
     * Returns an ingredient of the input, with the specified count
    */
    of(ingredient: Internal.Ingredient_, count: number): InputItem;
    /**
     * Make a custom ingredient where a match must match the provided predicate function
    */
    custom(predicate: Internal.Predicate_<Internal.ItemStack>): Internal.Ingredient;
    /**
     * Register a custom ingredient action for use in recipes with Recipe#customIngredientAction
    */
    registerCustomIngredientAction(id: string, callback: Internal.CustomIngredientActionCallback_): void;
    /**
     * Make a custom ingredient where items must match both the parent ingredient and the custom predicate function
    */
    custom(parent: Internal.Ingredient_, predicate: Internal.Predicate_<Internal.ItemStack>): Internal.Ingredient;
    /**
     * Checks if the passed in object is an Ingredient.
     * Note that this does not mean it will not function as an Ingredient if passed to something that requests one.
    */
    isIngredient(o: any): boolean;
    /**
     * Make a custom ingredient where an item must match both the parent ingredient and the item's nbt must match the custom predicate function
    */
    customNBT(in_: Internal.Ingredient_, predicate: Internal.Predicate_<Internal.CompoundTag>): Internal.Ingredient;
    /**
     * An ingredient that matches everything
    */
    readonly all: (Internal.WildcardIngredient) & (Internal.Ingredient);
    /**
     * A completely empty ingredient that will only match air
    */
    readonly none: (Internal.Ingredient) & (Internal.Ingredient);
}
type Ingredient_ = Ingredient;
declare const Ingredient: Ingredient;
declare class JavaMath {
    static "nextUp(float)"(arg0: number): number;
    static asin(arg0: number): number;
    static expm1(arg0: number): number;
    static ceil(arg0: number): number;
    static nextAfter(arg0: number, arg1: number): number;
    static exp(arg0: number): number;
    static "decrementExact(long)"(arg0: number): number;
    static "floorMod(long,int)"(arg0: number, arg1: number): number;
    static "incrementExact(int)"(arg0: number): number;
    static copySign(arg0: number, arg1: number): number;
    static ulp(arg0: number): number;
    static max(arg0: number, arg1: number): number;
    static "copySign(float,float)"(arg0: number, arg1: number): number;
    static "negateExact(int)"(arg0: number): number;
    static "fma(double,double,double)"(arg0: number, arg1: number, arg2: number): number;
    static "abs(float)"(arg0: number): number;
    static "min(double,double)"(arg0: number, arg1: number): number;
    static fma(arg0: number, arg1: number, arg2: number): number;
    static round(arg0: number): number;
    static hypot(arg0: number, arg1: number): number;
    static round(arg0: number): number;
    static "scalb(float,int)"(arg0: number, arg1: number): number;
    static abs(arg0: number): number;
    static "subtractExact(long,long)"(arg0: number, arg1: number): number;
    static "floorDiv(long,long)"(arg0: number, arg1: number): number;
    static floorMod(arg0: number, arg1: number): number;
    static log(arg0: number): number;
    static signum(arg0: number): number;
    static "max(float,float)"(arg0: number, arg1: number): number;
    static "nextAfter(double,double)"(arg0: number, arg1: number): number;
    static cos(arg0: number): number;
    getClass(): typeof any;
    static min(arg0: number, arg1: number): number;
    static nextUp(arg0: number): number;
    static "min(int,int)"(arg0: number, arg1: number): number;
    static "floorMod(int,int)"(arg0: number, arg1: number): number;
    static "max(long,long)"(arg0: number, arg1: number): number;
    static "fma(float,float,float)"(arg0: number, arg1: number, arg2: number): number;
    static "nextDown(double)"(arg0: number): number;
    static atan2(arg0: number, arg1: number): number;
    static cosh(arg0: number): number;
    static "round(float)"(arg0: number): number;
    static toIntExact(arg0: number): number;
    static decrementExact(arg0: number): number;
    static "floorDiv(int,int)"(arg0: number, arg1: number): number;
    static sinh(arg0: number): number;
    static toDegrees(arg0: number): number;
    static "multiplyExact(long,long)"(arg0: number, arg1: number): number;
    static max(arg0: number, arg1: number): number;
    static nextAfter(arg0: number, arg1: number): number;
    static "scalb(double,int)"(arg0: number, arg1: number): number;
    static "decrementExact(int)"(arg0: number): number;
    static tanh(arg0: number): number;
    toString(): string;
    static "negateExact(long)"(arg0: number): number;
    static "nextUp(double)"(arg0: number): number;
    notifyAll(): void;
    static floorMod(arg0: number, arg1: number): number;
    static "min(long,long)"(arg0: number, arg1: number): number;
    static nextDown(arg0: number): number;
    static "absExact(long)"(arg0: number): number;
    static "addExact(int,int)"(arg0: number, arg1: number): number;
    static pow(arg0: number, arg1: number): number;
    static absExact(arg0: number): number;
    static scalb(arg0: number, arg1: number): number;
    wait(arg0: number): void;
    static "abs(int)"(arg0: number): number;
    static addExact(arg0: number, arg1: number): number;
    static atan(arg0: number): number;
    static "addExact(long,long)"(arg0: number, arg1: number): number;
    static min(arg0: number, arg1: number): number;
    notify(): void;
    static multiplyExact(arg0: number, arg1: number): number;
    static "ulp(float)"(arg0: number): number;
    static floorDiv(arg0: number, arg1: number): number;
    static random(): number;
    static "ulp(double)"(arg0: number): number;
    static nextUp(arg0: number): number;
    static sqrt(arg0: number): number;
    static "copySign(double,double)"(arg0: number, arg1: number): number;
    static "multiplyExact(int,int)"(arg0: number, arg1: number): number;
    static "abs(double)"(arg0: number): number;
    static "subtractExact(int,int)"(arg0: number, arg1: number): number;
    static min(arg0: number, arg1: number): number;
    static fma(arg0: number, arg1: number, arg2: number): number;
    static addExact(arg0: number, arg1: number): number;
    static multiplyExact(arg0: number, arg1: number): number;
    static abs(arg0: number): number;
    static "floorMod(long,long)"(arg0: number, arg1: number): number;
    static floor(arg0: number): number;
    static subtractExact(arg0: number, arg1: number): number;
    static "abs(long)"(arg0: number): number;
    static rint(arg0: number): number;
    static "min(float,float)"(arg0: number, arg1: number): number;
    static "max(int,int)"(arg0: number, arg1: number): number;
    static signum(arg0: number): number;
    static absExact(arg0: number): number;
    wait(): void;
    static log10(arg0: number): number;
    static abs(arg0: number): number;
    static floorDiv(arg0: number, arg1: number): number;
    static floorDiv(arg0: number, arg1: number): number;
    static tan(arg0: number): number;
    static floorMod(arg0: number, arg1: number): number;
    static ulp(arg0: number): number;
    static sin(arg0: number): number;
    static min(arg0: number, arg1: number): number;
    wait(arg0: number, arg1: number): void;
    static max(arg0: number, arg1: number): number;
    static "max(double,double)"(arg0: number, arg1: number): number;
    static toRadians(arg0: number): number;
    static "multiplyExact(long,int)"(arg0: number, arg1: number): number;
    static incrementExact(arg0: number): number;
    static negateExact(arg0: number): number;
    static max(arg0: number, arg1: number): number;
    static incrementExact(arg0: number): number;
    static decrementExact(arg0: number): number;
    static copySign(arg0: number, arg1: number): number;
    static negateExact(arg0: number): number;
    static "getExponent(float)"(arg0: number): number;
    static "incrementExact(long)"(arg0: number): number;
    static "signum(float)"(arg0: number): number;
    static nextDown(arg0: number): number;
    static "nextAfter(float,double)"(arg0: number, arg1: number): number;
    static IEEEremainder(arg0: number, arg1: number): number;
    static "round(double)"(arg0: number): number;
    static abs(arg0: number): number;
    static getExponent(arg0: number): number;
    static "getExponent(double)"(arg0: number): number;
    static scalb(arg0: number, arg1: number): number;
    static multiplyHigh(arg0: number, arg1: number): number;
    static multiplyFull(arg0: number, arg1: number): number;
    hashCode(): number;
    static multiplyExact(arg0: number, arg1: number): number;
    static getExponent(arg0: number): number;
    static "floorDiv(long,int)"(arg0: number, arg1: number): number;
    static cbrt(arg0: number): number;
    static acos(arg0: number): number;
    static log1p(arg0: number): number;
    static "nextDown(float)"(arg0: number): number;
    equals(arg0: any): boolean;
    static "signum(double)"(arg0: number): number;
    static "absExact(int)"(arg0: number): number;
    static subtractExact(arg0: number, arg1: number): number;
    get class(): typeof any
    static readonly PI: (3.141592653589793) & (number);
    static readonly E: (2.718281828459045) & (number);
}
type JavaMath_ = JavaMath;
declare interface NBT {
    accessTagMap(tag: Internal.CompoundTag_): Internal.Map<string, Internal.Tag>;
    read(buf: Internal.FriendlyByteBuf_): Internal.OrderedCompoundTag;
    toJson(t: Internal.Tag_): Internal.JsonElement;
    toTagCollection(c: Internal.Collection_<any>): Internal.CollectionTag<any>;
    l(v: number): Internal.Tag;
    quoteAndEscapeForJS(stringBuilder: Internal.StringBuilder_, string: string): void;
    b(v: number): Internal.Tag;
    byteArrayTag(v: number[]): Internal.Tag;
    listTag(): Internal.Tag;
    floatTag(v: number): Internal.Tag;
    s(v: number): Internal.Tag;
    byteTag(v: number): Internal.Tag;
    listTag(list: Internal.List_<any>): Internal.Tag;
    ia(v: number[]): Internal.Tag;
    d(v: number): Internal.Tag;
    longArrayTag(v: number[]): Internal.Tag;
    isTagCollection(o: any): boolean;
    "toTagCollection(java.util.Collection)"(c: Internal.Collection_<any>): Internal.CollectionTag<any>;
    longTag(v: number): Internal.Tag;
    intTag(v: number): Internal.Tag;
    compoundTag(): Internal.Tag;
    shortTag(v: number): Internal.Tag;
    stringTag(v: string): Internal.Tag;
    la(v: number[]): Internal.Tag;
    convertType(tagType: Internal.TagType_<any>): Internal.TagType<any>;
    toTagCollection(v: any): Internal.CollectionTag<any>;
    f(v: number): Internal.Tag;
    toTag(v: any): Internal.Tag;
    fromTag(t: Internal.Tag_): any;
    toTagList(list: any): Internal.ListTag;
    toTagCompound(v: any): Internal.CompoundTag;
    isTagCompound(o: any): boolean;
    doubleTag(v: number): Internal.Tag;
    intArrayTag(v: number[]): Internal.Tag;
    ba(v: number[]): Internal.Tag;
    compoundTag(map: Internal.Map_<any, any>): Internal.Tag;
    i(v: number): Internal.Tag;
    "toTagCollection(java.lang.Object)"(v: any): Internal.CollectionTag<any>;
    readonly VALUE_UNWRAPPER: Internal.ValueUnwrapper;
    readonly LIST_TYPE: Internal.TagType<Internal.ListTag>;
    readonly COMPOUND_TYPE: Internal.TagType<Internal.OrderedCompoundTag>;
}
type NBT_ = NBT;
declare const NBT: NBT;
declare interface FluidAmounts {
    readonly MILLIBUCKET: (1) & (number);
    readonly MB: (1) & (number);
    readonly INGOT: (90) & (number);
    readonly BOTTLE: (250) & (number);
    readonly B: (1000) & (number);
    readonly NUGGET: (10) & (number);
    readonly METAL_BLOCK: (810) & (number);
    readonly BUCKET: (1000) & (number);
}
type FluidAmounts_ = FluidAmounts;
declare const FluidAmounts: FluidAmounts;
declare class Matrix3f implements Internal.Cloneable, Internal.Matrix3fc, Internal.Externalizable {
    constructor(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_)
    constructor()
    constructor(arg0: Internal.Matrix3fc_)
    constructor(arg0: Internal.FloatBuffer_)
    constructor(arg0: Internal.Matrix2fc_)
    constructor(arg0: Internal.Matrix4fc_)
    constructor(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number)
    rotateLocalY(arg0: number, arg1: Matrix3f_): this;
    setColumn(arg0: number, arg1: Internal.Vector3fc_): this;
    mapnZnXY(): this;
    rotate(arg0: Internal.Quaternionfc_, arg1: Matrix3f_): this;
    getEulerAnglesXYZ(arg0: Vec3f_): Vec3f;
    mapZXnY(): this;
    get(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    mapYXnZ(arg0: Matrix3f_): this;
    "getUnnormalizedRotation(org.joml.Quaterniond)"(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    mapnYnXZ(arg0: Matrix3f_): this;
    "scale(float)"(arg0: number): this;
    "getTransposed(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix3f_): this;
    mapYnXnZ(arg0: Matrix3f_): this;
    "getNormalizedRotation(org.joml.Quaternionf)"(arg0: Quaternionf_): Quaternionf;
    "set(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_): this;
    getUnnormalizedRotation(arg0: Quaternionf_): Quaternionf;
    negateZ(arg0: Matrix3f_): this;
    "get(int,int)"(arg0: number, arg1: number): number;
    mapXnYnZ(): this;
    mapnYnZX(): this;
    m20(arg0: number): this;
    set(arg0: Internal.Matrix4fc_): this;
    rotationZ(arg0: number): this;
    mapnYnXnZ(arg0: Matrix3f_): this;
    transformTranspose(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapnZYnX(): this;
    sub(arg0: Internal.Matrix3fc_): this;
    setLookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    "rotate(float,org.joml.Vector3fc)"(arg0: number, arg1: Internal.Vector3fc_): this;
    getNormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    "get(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    setColumn(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mapnYnZnX(): this;
    getRowColumn(arg0: number, arg1: number): number;
    positiveZ(arg0: Vec3f_): Vec3f;
    mapnYZX(arg0: Matrix3f_): this;
    mapnXnZY(arg0: Matrix3f_): this;
    mapXZY(arg0: Matrix3f_): this;
    rotateZ(arg0: number, arg1: Matrix3f_): this;
    mapYZnX(): this;
    mapnZnYX(arg0: Matrix3f_): this;
    rotateYXZ(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    rotateLocalZ(arg0: number, arg1: Matrix3f_): this;
    getClass(): typeof any;
    rotateLocal(arg0: Internal.Quaternionfc_, arg1: Matrix3f_): this;
    setLookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    mapZYX(): this;
    mapYnZnX(): this;
    mapnXnYnZ(): this;
    obliqueZ(arg0: number, arg1: number, arg2: Matrix3f_): this;
    scale(arg0: number): this;
    set(arg0: Internal.Matrix3fc_): this;
    m20(): number;
    mapnXnYZ(): this;
    reflect(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    "rotate(org.joml.AxisAngle4f,org.joml.Matrix3f)"(arg0: Internal.AxisAngle4f_, arg1: Matrix3f_): this;
    get(arg0: Matrix4f_): Matrix4f;
    rotation(arg0: number, arg1: Internal.Vector3fc_): this;
    set(arg0: Internal.AxisAngle4d_): this;
    mul(arg0: Internal.Matrix3fc_, arg1: Matrix3f_): this;
    rotate(arg0: Internal.AxisAngle4f_): this;
    rotationXYZ(arg0: number, arg1: number, arg2: number): this;
    m21(arg0: number): this;
    rotationY(arg0: number): this;
    "get3x4(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapnXYnZ(): this;
    rotateXYZ(arg0: number, arg1: number, arg2: number): this;
    mapZnYX(): this;
    getTransposed(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    cofactor(arg0: Matrix3f_): this;
    mapnYZnX(arg0: Matrix3f_): this;
    set(arg0: Internal.ByteBuffer_): this;
    mapXnZY(arg0: Matrix3f_): this;
    setTransposed(arg0: Internal.Matrix3fc_): this;
    getScale(arg0: Vec3f_): Vec3f;
    transform(arg0: Vec3f_): Vec3f;
    rotateY(arg0: number, arg1: Matrix3f_): this;
    mapYnZX(): this;
    "scale(org.joml.Vector3fc,org.joml.Matrix3f)"(arg0: Internal.Vector3fc_, arg1: Matrix3f_): this;
    mapnXZY(arg0: Matrix3f_): this;
    "scale(float,org.joml.Matrix3f)"(arg0: number, arg1: Matrix3f_): this;
    wait(arg0: number): void;
    set(arg0: Internal.Quaterniondc_): this;
    scale(arg0: Internal.Vector3fc_): this;
    normal(arg0: Matrix3f_): this;
    mapZYnX(): this;
    rotation(arg0: number, arg1: number, arg2: number, arg3: number): this;
    setRow(arg0: number, arg1: Internal.Vector3fc_): this;
    scaling(arg0: number, arg1: number, arg2: number): this;
    set(arg0: number, arg1: number, arg2: number): this;
    reflect(arg0: Internal.Quaternionfc_): this;
    rotateLocalY(arg0: number): this;
    "get(org.joml.Matrix3f)"(arg0: Matrix3f_): this;
    rotationTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    set(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    m21(): number;
    sub(arg0: Internal.Matrix3fc_, arg1: Matrix3f_): this;
    set(arg0: Internal.AxisAngle4f_): this;
    isFinite(): boolean;
    get3x4(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapZnYX(arg0: Matrix3f_): this;
    mapnYZX(): this;
    transpose(arg0: Matrix3f_): this;
    rotation(arg0: Internal.Quaternionfc_): this;
    mapnXnYZ(arg0: Matrix3f_): this;
    mapnXnZnY(): this;
    "set(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_): this;
    m10(): number;
    mapXnZnY(): this;
    "set(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): this;
    mapZXY(arg0: Matrix3f_): this;
    rotationX(arg0: number): this;
    rotate(arg0: Internal.AxisAngle4f_, arg1: Matrix3f_): this;
    mapYnXZ(): this;
    reflect(arg0: Internal.Vector3fc_, arg1: Matrix3f_): this;
    getToAddress(arg0: number): Internal.Matrix3fc;
    reflect(arg0: number, arg1: number, arg2: number): this;
    get(arg0: number, arg1: number): number;
    setRow(arg0: number, arg1: number, arg2: number, arg3: number): this;
    wait(): void;
    get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    get3x4(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    set(arg0: Internal.FloatBuffer_): this;
    mapnZnXnY(arg0: Matrix3f_): this;
    mapXZnY(arg0: Matrix3f_): this;
    rotateLocalX(arg0: number, arg1: Matrix3f_): this;
    mulLocal(arg0: Internal.Matrix3fc_): this;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    transform(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    mapnYXnZ(arg0: Matrix3f_): this;
    transformTranspose(arg0: Vec3f_): Vec3f;
    "rotation(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): this;
    rotateLocalZ(arg0: number): this;
    m22(): number;
    lerp(arg0: Internal.Matrix3fc_, arg1: number, arg2: Matrix3f_): this;
    mapYXnZ(): this;
    mapZnYnX(arg0: Matrix3f_): this;
    "rotation(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    mapYXZ(arg0: Matrix3f_): this;
    reflection(arg0: number, arg1: number, arg2: number): this;
    rotate(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "getTransposed(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    mapnZXnY(): this;
    invert(): this;
    m11(): number;
    getTransposed(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapZnXnY(arg0: Matrix3f_): this;
    rotateXYZ(arg0: Vec3f_): this;
    rotate(arg0: number, arg1: Internal.Vector3fc_): this;
    rotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapnXnZY(): this;
    getNormalizedRotation(arg0: Quaternionf_): Quaternionf;
    negateZ(): this;
    mapnZnYnX(arg0: Matrix3f_): this;
    equals(arg0: any): boolean;
    rotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix3f_): this;
    mapXZY(): this;
    mapYnZX(arg0: Matrix3f_): this;
    m00(): number;
    "set(org.joml.Quaterniondc)"(arg0: Internal.Quaterniondc_): this;
    "scaling(float)"(arg0: number): this;
    get3x4(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapnZXY(): this;
    "scaling(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    scale(arg0: number, arg1: number, arg2: number): this;
    "reflect(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    identity(): this;
    scaling(arg0: Internal.Vector3fc_): this;
    mulLocal(arg0: Internal.Matrix3fc_, arg1: Matrix3f_): this;
    mapXZnY(): this;
    "get3x4(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    reflect(arg0: Internal.Vector3fc_): this;
    "getNormalizedRotation(org.joml.Quaterniond)"(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    mul(arg0: Internal.Matrix3fc_): this;
    mapnZnYnX(): this;
    setFromAddress(arg0: number): this;
    m01(arg0: number): this;
    "set(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): this;
    rotate(arg0: Internal.Quaternionfc_): this;
    m12(): number;
    mapZnYnX(): this;
    mapnZYnX(arg0: Matrix3f_): this;
    get3x4(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    normal(): this;
    mapZYnX(arg0: Matrix3f_): this;
    mapnXZY(): this;
    scaleLocal(arg0: number, arg1: number, arg2: number): this;
    "get(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    normalizedPositiveX(arg0: Vec3f_): Vec3f;
    "rotate(org.joml.Quaternionfc,org.joml.Matrix3f)"(arg0: Internal.Quaternionfc_, arg1: Matrix3f_): this;
    get(arg0: number[]): number[];
    negateY(): this;
    getColumn(arg0: number, arg1: Vec3f_): Vec3f;
    toString(arg0: Internal.NumberFormat_): string;
    "get(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapnXYnZ(arg0: Matrix3f_): this;
    mapnYXnZ(): this;
    rotateYXZ(arg0: number, arg1: number, arg2: number): this;
    get(arg0: number[], arg1: number): number[];
    rotateLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix3f_): this;
    set(arg0: number, arg1: Internal.FloatBuffer_): this;
    mapnXnYnZ(arg0: Matrix3f_): this;
    mapZYX(arg0: Matrix3f_): this;
    "scale(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    m12(arg0: number): this;
    clone(): any;
    mapnYnZX(arg0: Matrix3f_): this;
    m01(): number;
    quadraticFormProduct(arg0: Internal.Vector3fc_): number;
    setRowColumn(arg0: number, arg1: number, arg2: number): this;
    "set(int,int,float)"(arg0: number, arg1: number, arg2: number): this;
    writeExternal(arg0: Internal.ObjectOutput_): void;
    getRotation(arg0: Internal.AxisAngle4f_): Internal.AxisAngle4f;
    "get(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    reflection(arg0: Internal.Quaternionfc_): this;
    mapnYnZnX(arg0: Matrix3f_): this;
    transformTranspose(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    mapnZnXnY(): this;
    rotateZYX(arg0: Vec3f_): this;
    rotateLocalX(arg0: number): this;
    "reflection(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    transform(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    m02(arg0: number): this;
    getTransposed(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    scale(arg0: Internal.Vector3fc_, arg1: Matrix3f_): this;
    rotationTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapnZnXY(arg0: Matrix3f_): this;
    mapnYnXZ(): this;
    mapnXZnY(): this;
    mapYZX(): this;
    "get3x4(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    mapnYXZ(): this;
    mulComponentWise(arg0: Internal.Matrix3fc_, arg1: Matrix3f_): this;
    mapZXnY(arg0: Matrix3f_): this;
    negateX(): this;
    rotateXYZ(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    rotationYXZ(arg0: number, arg1: number, arg2: number): this;
    "set(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    "set(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): this;
    toString(): string;
    mapnZYX(arg0: Matrix3f_): this;
    rotateLocal(arg0: Internal.Quaternionfc_): this;
    normalizedPositiveY(arg0: Vec3f_): Vec3f;
    notifyAll(): void;
    mapYZnX(arg0: Matrix3f_): this;
    mapnZnYX(): this;
    "set(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    getRow(arg0: number, arg1: Vec3f_): Vec3f;
    rotate(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix3f_): this;
    mapnZXnY(arg0: Matrix3f_): this;
    mapZnXY(arg0: Matrix3f_): this;
    "reflect(org.joml.Vector3fc,org.joml.Matrix3f)"(arg0: Internal.Vector3fc_, arg1: Matrix3f_): this;
    reflection(arg0: Internal.Vector3fc_): this;
    rotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix3f_): this;
    rotateX(arg0: number): this;
    mapnXZnY(arg0: Matrix3f_): this;
    "rotate(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    mapYXZ(): this;
    setSkewSymmetric(arg0: number, arg1: number, arg2: number): this;
    "rotate(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): this;
    rotateZYX(arg0: number, arg1: number, arg2: number): this;
    notify(): void;
    rotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    rotateLocal(arg0: number, arg1: number, arg2: number, arg3: number): this;
    m02(): number;
    mapZnXnY(): this;
    "set(org.joml.Vector3fc,org.joml.Vector3fc,org.joml.Vector3fc)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    "set(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    negateX(arg0: Matrix3f_): this;
    mapnYZnX(): this;
    m22(arg0: number): this;
    mulComponentWise(arg0: Internal.Matrix3fc_): this;
    normalizedPositiveZ(arg0: Vec3f_): Vec3f;
    invert(arg0: Matrix3f_): this;
    reflect(arg0: Internal.Quaternionfc_, arg1: Matrix3f_): this;
    "getTransposed(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    readExternal(arg0: Internal.ObjectInput_): void;
    mapnZYX(): this;
    scaleLocal(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    getEulerAnglesZYX(arg0: Vec3f_): Vec3f;
    get(arg0: Matrix3f_): this;
    "get(float[],int)"(arg0: number[], arg1: number): number[];
    get(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    rotateX(arg0: number, arg1: Matrix3f_): this;
    positiveX(arg0: Vec3f_): Vec3f;
    "getTransposed(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    rotateYXZ(arg0: Vec3f_): this;
    determinant(): number;
    add(arg0: Internal.Matrix3fc_, arg1: Matrix3f_): this;
    transpose(): this;
    "reflect(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    "set(float[])"(arg0: number[]): this;
    m10(arg0: number): this;
    mapYnZnX(arg0: Matrix3f_): this;
    "set(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): this;
    rotateY(arg0: number): this;
    rotation(arg0: Internal.AxisAngle4f_): this;
    "reflect(org.joml.Quaternionfc,org.joml.Matrix3f)"(arg0: Internal.Quaternionfc_, arg1: Matrix3f_): this;
    add(arg0: Internal.Matrix3fc_): this;
    scale(arg0: number, arg1: Matrix3f_): this;
    lerp(arg0: Internal.Matrix3fc_, arg1: number): this;
    mapYnXZ(arg0: Matrix3f_): this;
    rotateZYX(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    mapnZXY(arg0: Matrix3f_): this;
    "get3x4(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    scale(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    mapZnXY(): this;
    wait(arg0: number, arg1: number): void;
    cofactor(): this;
    mapnYnXnZ(): this;
    quadraticFormProduct(arg0: number, arg1: number, arg2: number): number;
    "set(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): this;
    "set(org.joml.Matrix2fc)"(arg0: Internal.Matrix2fc_): this;
    "get(float[])"(arg0: number[]): number[];
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix3f_): this;
    swap(arg0: Matrix3f_): this;
    mapXnZnY(arg0: Matrix3f_): this;
    set(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    "reflection(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    obliqueZ(arg0: number, arg1: number): this;
    negateY(arg0: Matrix3f_): this;
    getUnnormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    rotate(arg0: number, arg1: Internal.Vector3fc_, arg2: Matrix3f_): this;
    getTransposed(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    m00(arg0: number): this;
    mapXnYnZ(arg0: Matrix3f_): this;
    mapXnZY(): this;
    "get(org.joml.Matrix4f)"(arg0: Matrix4f_): Matrix4f;
    equals(arg0: Internal.Matrix3fc_, arg1: number): boolean;
    mapYZX(arg0: Matrix3f_): this;
    set(arg0: Internal.Matrix4x3fc_): this;
    set(arg0: Internal.Matrix2fc_): this;
    mapnXnZnY(arg0: Matrix3f_): this;
    rotateZ(arg0: number): this;
    "getUnnormalizedRotation(org.joml.Quaternionf)"(arg0: Quaternionf_): Quaternionf;
    hashCode(): number;
    rotationZYX(arg0: number, arg1: number, arg2: number): this;
    mapYnXnZ(): this;
    positiveY(arg0: Vec3f_): Vec3f;
    set(arg0: number, arg1: Internal.ByteBuffer_): this;
    mapnYXZ(arg0: Matrix3f_): this;
    mapZXY(): this;
    scaling(arg0: number): this;
    set(arg0: number[]): this;
    zero(): this;
    set(arg0: Internal.Quaternionfc_): this;
    m11(arg0: number): this;
    set "(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_)
    get class(): typeof any
    set transposed(arg0: Internal.Matrix3fc_)
    get finite(): boolean
    set "(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_)
    set "(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_)
    set "(org.joml.Quaterniondc)"(arg0: Internal.Quaterniondc_)
    set fromAddress(arg0: number)
    set "(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_)
    set "(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_)
    set "(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_)
    set "(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_)
    set "(float[])"(arg0: number[])
    set "(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_)
    set "(org.joml.Matrix2fc)"(arg0: Internal.Matrix2fc_)
    m10: number;
    m21: number;
    m20: number;
    m01: number;
    m12: number;
    m00: number;
    m11: number;
    m22: number;
    m02: number;
}
type Matrix3f_ = Matrix3f;
declare class Matrix4f implements Internal.Cloneable, Internal.Matrix4fc, Internal.Externalizable {
    constructor()
    constructor(arg0: Internal.Matrix3fc_)
    constructor(arg0: Internal.FloatBuffer_)
    constructor(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: number, arg14: number, arg15: number)
    constructor(arg0: Internal.Matrix4dc_)
    constructor(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Internal.Vector4fc_, arg3: Internal.Vector4fc_)
    constructor(arg0: Internal.Matrix4fc_)
    constructor(arg0: Internal.Matrix4x3fc_)
    scaleXY(arg0: number, arg1: number, arg2: Matrix4f_): this;
    setLookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    rotateAffineXYZ(arg0: number, arg1: number, arg2: number): this;
    translationRotateScale(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: Internal.Vector3fc_): this;
    transformProject(arg0: Internal.Vector4fc_, arg1: Vec3f_): Vec3f;
    testSphere(arg0: number, arg1: number, arg2: number, arg3: number): boolean;
    zero(): this;
    mul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: number, arg14: number, arg15: number): this;
    m32(arg0: number): this;
    "get4x3(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    reflect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    obliqueZ(arg0: number, arg1: number, arg2: Matrix4f_): this;
    "orthoLH(float,float,float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    setTransposedFromAddress(arg0: number): this;
    mapYXnZ(arg0: Matrix4f_): this;
    "get(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "perspectiveRect(float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    getRowColumn(arg0: number, arg1: number): number;
    "normalize3x3(org.joml.Matrix3f)"(arg0: Matrix3f_): Matrix3f;
    "set(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_): this;
    "unprojectInv(float,float,float,int[],org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec3f_): Vec3f;
    shadow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    billboardSpherical(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    "set(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): this;
    lookAt(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_, arg3: Matrix4f_): this;
    "mulPerspectiveAffine(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    "normal(org.joml.Matrix4f)"(arg0: Matrix4f_): this;
    "project(org.joml.Vector3fc,int[],org.joml.Vector4f)"(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec4f_): Vec4f;
    rotateX(arg0: number, arg1: Matrix4f_): this;
    mul0(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    m10(arg0: number): this;
    rotateYXZ(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    mapZYnX(): this;
    rotateLocalY(arg0: number, arg1: Matrix4f_): this;
    set(arg0: Internal.Matrix3fc_): this;
    invertAffine(arg0: Matrix4f_): this;
    arcball(arg0: number, arg1: Internal.Vector3fc_, arg2: number, arg3: number, arg4: Matrix4f_): this;
    m32(): number;
    scaleAroundLocal(arg0: number, arg1: number, arg2: number, arg3: number): this;
    unproject(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec3f_): Vec3f;
    "frustumLH(float,float,float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    mapZnYX(): this;
    mapYnXnZ(arg0: Matrix4f_): this;
    shadow(arg0: Vec4f_, arg1: number, arg2: number, arg3: number, arg4: number): this;
    normal(arg0: Matrix3f_): Matrix3f;
    m21(arg0: number): this;
    lerp(arg0: Internal.Matrix4fc_, arg1: number, arg2: Matrix4f_): this;
    rotationY(arg0: number): this;
    getRotation(arg0: Internal.AxisAngle4d_): Internal.AxisAngle4d;
    rotate(arg0: Internal.AxisAngle4f_, arg1: Matrix4f_): this;
    tile(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "unproject(org.joml.Vector3fc,int[],org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec3f_): Vec3f;
    "ortho(float,float,float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    m21(): number;
    isFinite(): boolean;
    transformProject(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    m30(arg0: number): this;
    setRotationYXZ(arg0: number, arg1: number, arg2: number): this;
    reflect(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    mul(arg0: Internal.Matrix4fc_): this;
    m10(): number;
    rotateAffineZYX(arg0: number, arg1: number, arg2: number): this;
    set(arg0: number, arg1: number, arg2: number): this;
    mapnZnXnY(): this;
    setPerspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    "get3x3(org.joml.Matrix3d)"(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
    perspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    mapYXZ(arg0: Matrix4f_): this;
    "get4x3Transposed(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    rotation(arg0: Internal.Quaternionfc_): this;
    mulPerspectiveAffine(arg0: Internal.Matrix4x3fc_, arg1: Matrix4f_): this;
    rotateAffine(arg0: Internal.Quaternionfc_): this;
    get4x3Transposed(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    transpose3x3(arg0: Matrix3f_): Matrix3f;
    translate(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    shadow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): this;
    "transformProject(org.joml.Vector4fc,org.joml.Vector3f)"(arg0: Internal.Vector4fc_, arg1: Vec3f_): Vec3f;
    ortho2DLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    "set4x3(org.joml.Matrix4f)"(arg0: Matrix4f_): this;
    mapYZnX(): this;
    rotateTranslation(arg0: Internal.Quaternionfc_, arg1: Matrix4f_): this;
    frustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    scaleLocal(arg0: number): this;
    rotateZ(arg0: number, arg1: Matrix4f_): this;
    setTransposed(arg0: Internal.FloatBuffer_): this;
    set(arg0: Internal.FloatBuffer_): this;
    rotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    unprojectInv(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec4f_): Vec4f;
    "getRow(int,org.joml.Vector4f)"(arg0: number, arg1: Vec4f_): Vec4f;
    perspectiveInvOrigin(arg0: Vec3f_): Vec3f;
    transformTranspose(arg0: Vec4f_): Vec4f;
    rotationTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    mapnYnXZ(arg0: Matrix4f_): this;
    mapZnYX(arg0: Matrix4f_): this;
    ortho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    mapnZXnY(): this;
    "shadow(float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    getToAddress(arg0: number): Internal.Matrix4fc;
    mapnXZY(): this;
    rotateAround(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number): this;
    transformProject(arg0: Vec4f_): Vec4f;
    "set(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    negateZ(): this;
    m23(): number;
    rotate(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    equals(arg0: Internal.Matrix4fc_, arg1: number): boolean;
    lookAtPerspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): this;
    lookAtLH(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_, arg3: Matrix4f_): this;
    setOrthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    "get4x3Transposed(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    m12(): number;
    mapnYnZX(arg0: Matrix4f_): this;
    "getColumn(int,org.joml.Vector4f)"(arg0: number, arg1: Vec4f_): Vec4f;
    translationRotate(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_): this;
    "reflect(org.joml.Vector3fc,org.joml.Vector3fc)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    "orthoSymmetricLH(float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    normalizedPositiveX(arg0: Vec3f_): Vec3f;
    setFrustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    mapXZY(): this;
    transformDirection(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    getColumn(arg0: number, arg1: Vec3f_): Vec3f;
    perspective(arg0: number, arg1: number, arg2: number, arg3: number): this;
    unprojectRay(arg0: Internal.Vector2fc_, arg1: number[], arg2: Vec3f_, arg3: Vec3f_): this;
    orthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): this;
    reflection(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "transformProject(float,float,float,float,org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
    "mul(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    mapYXnZ(): this;
    m01(arg0: number): this;
    m01(): number;
    "get(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    mul(arg0: Internal.Matrix3x2fc_, arg1: Matrix4f_): this;
    mapYZnX(arg0: Matrix4f_): this;
    "translationRotateScaleInvert(org.joml.Vector3fc,org.joml.Quaternionfc,float)"(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: number): this;
    mapnZXnY(arg0: Matrix4f_): this;
    translate(arg0: Internal.Vector3fc_, arg1: Matrix4f_): this;
    mapZnXY(arg0: Matrix4f_): this;
    transformAab(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Vec3f_, arg7: Vec3f_): this;
    invertOrtho(): this;
    "scaling(float)"(arg0: number): this;
    transform(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    "get4x3Transposed(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    rotateLocalY(arg0: number): this;
    billboardCylindrical(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    "scaling(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    getRow(arg0: number, arg1: Vec3f_): Vec3f;
    rotationTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    setPerspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "ortho(float,float,float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    mapnYXZ(): this;
    setFromIntrinsic(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    negateX(): this;
    setColumn(arg0: number, arg1: Internal.Vector4fc_): this;
    fma4x3(arg0: Internal.Matrix4fc_, arg1: number, arg2: Matrix4f_): this;
    notify(): void;
    set(arg0: number, arg1: Internal.ByteBuffer_): this;
    get4x3(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    translationRotate(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number): this;
    rotateYXZ(arg0: Vec3f_): this;
    mapnYXZ(arg0: Matrix4f_): this;
    orthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "reflection(org.joml.Vector3fc,org.joml.Vector3fc)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    normalizedPositiveZ(arg0: Vec3f_): Vec3f;
    cofactor3x3(arg0: Matrix4f_): this;
    setLookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    "rotate(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    perspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    scale(arg0: Internal.Vector3fc_, arg1: Matrix4f_): this;
    reflect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    mulPerspectiveAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    perspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    scaleAroundLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    translationRotateScaleMulAffine(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: Internal.Vector3fc_, arg3: Matrix4f_): this;
    "orthoSymmetric(float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    rotate(arg0: Internal.Quaternionfc_): this;
    invertOrtho(arg0: Matrix4f_): this;
    mapYZX(arg0: Matrix4f_): this;
    orthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    scaleAround(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    m03(): number;
    "get(float[])"(arg0: number[]): number[];
    translationRotateScaleMulAffine(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: Matrix4f_): this;
    unprojectInv(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec3f_): Vec3f;
    rotationZYX(arg0: number, arg1: number, arg2: number): this;
    rotateYXZ(arg0: number, arg1: number, arg2: number): this;
    cofactor3x3(): this;
    scaleXY(arg0: number, arg1: number): this;
    m12(arg0: number): this;
    rotation(arg0: Internal.AxisAngle4f_): this;
    translateLocal(arg0: Internal.Vector3fc_): this;
    rotateAffineYXZ(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    scaling(arg0: number): this;
    mapZnXY(): this;
    "setTransposed(float[])"(arg0: number[]): this;
    "unprojectInv(org.joml.Vector3fc,int[],org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec3f_): Vec3f;
    "transformProject(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    project(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec3f_): Vec3f;
    hashCode(): number;
    positiveY(arg0: Vec3f_): Vec3f;
    negateX(arg0: Matrix4f_): this;
    setOrtho2D(arg0: number, arg1: number, arg2: number, arg3: number): this;
    translation(arg0: Internal.Vector3fc_): this;
    translationRotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    m23(arg0: number): this;
    "set(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): this;
    "orthoSymmetric(float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    mul3x3(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    setRow(arg0: number, arg1: Internal.Vector4fc_): this;
    project(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec4f_): Vec4f;
    getEulerAnglesXYZ(arg0: Vec3f_): Vec3f;
    trapezoidCrop(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): this;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    translationRotate(arg0: number, arg1: number, arg2: number, arg3: Internal.Quaternionfc_): this;
    transformPosition(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    unprojectInvRay(arg0: number, arg1: number, arg2: number[], arg3: Vec3f_, arg4: Vec3f_): this;
    setOrtho2DLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    scaleAround(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    mapnZnYnX(arg0: Matrix4f_): this;
    "getNormalizedRotation(org.joml.Quaternionf)"(arg0: Quaternionf_): Quaternionf;
    "get(int,int)"(arg0: number, arg1: number): number;
    perspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    get4x3(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: number, arg14: number, arg15: number, arg16: Matrix4f_): this;
    mulPerspectiveAffine(arg0: Internal.Matrix4fc_): this;
    "transformProject(org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    mapZYX(): this;
    ortho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    transform(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
    get3x3(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
    mapnXnYnZ(): this;
    setTransposed(arg0: Internal.ByteBuffer_): this;
    getNormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    "frustum(float,float,float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    mapZnYnX(arg0: Matrix4f_): this;
    positiveZ(arg0: Vec3f_): Vec3f;
    arcball(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    invertPerspective(): this;
    mapnYnZX(): this;
    rotateXYZ(arg0: number, arg1: number, arg2: number): this;
    mapXnZY(arg0: Matrix4f_): this;
    translate(arg0: number, arg1: number, arg2: number): this;
    lerp(arg0: Internal.Matrix4fc_, arg1: number): this;
    "rotate(org.joml.Quaternionfc,org.joml.Matrix4f)"(arg0: Internal.Quaternionfc_, arg1: Matrix4f_): this;
    mapnXYnZ(): this;
    lookAtLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): this;
    mulLocal(arg0: Internal.Matrix4fc_): this;
    rotateXYZ(arg0: Internal.Vector3fc_): this;
    rotateLocal(arg0: Internal.Quaternionfc_, arg1: Matrix4f_): this;
    shadow(arg0: Vec4f_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: Matrix4f_): this;
    mulLocalAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    perspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    set(arg0: number[], arg1: number): this;
    get3x3(arg0: Matrix3f_): Matrix3f;
    "mulPerspectiveAffine(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    rotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    "set3x3(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_): this;
    mapXnYnZ(): this;
    negateZ(arg0: Matrix4f_): this;
    transformProject(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    setOrtho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    "set(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    "getColumn(int,org.joml.Vector3f)"(arg0: number, arg1: Vec3f_): Vec3f;
    mul(arg0: Internal.Matrix4x3fc_): this;
    setPerspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    "project(float,float,float,int[],org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec4f_): Vec4f;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    rotateTowardsXY(arg0: number, arg1: number): this;
    shadow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: Matrix4f_): this;
    setLookAtLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    sub(arg0: Internal.Matrix4fc_): this;
    rotateLocalZ(arg0: number): this;
    scale(arg0: number): this;
    "transformProject(float,float,float,float,org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec3f_): Vec3f;
    m03(arg0: number): this;
    get(arg0: number, arg1: number): number;
    mapnYZX(): this;
    orthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    "translationRotateScale(org.joml.Vector3fc,org.joml.Quaternionfc,float)"(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: number): this;
    get3x4(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    setPerspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    invert(): this;
    transformTranspose(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
    "setTransposed(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    rotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    "get4x3Transposed(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    perspectiveNear(): number;
    rotateLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    mapnYZX(arg0: Matrix4f_): this;
    mulLocalAffine(arg0: Internal.Matrix4fc_): this;
    "getTransposed(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    rotateAround(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    perspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number): this;
    shadow(arg0: Vec4f_, arg1: Matrix4f_): this;
    "scale(org.joml.Vector3fc,org.joml.Matrix4f)"(arg0: Internal.Vector3fc_, arg1: Matrix4f_): this;
    perspectiveOrigin(arg0: Vec3f_): Vec3f;
    frustumAabb(arg0: Vec3f_, arg1: Vec3f_): this;
    "set(org.joml.Matrix4dc)"(arg0: Internal.Matrix4dc_): this;
    getNormalizedRotation(arg0: Quaternionf_): Quaternionf;
    "rotation(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    mulLocal(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    "set(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_): this;
    "mul(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    mapXnYnZ(arg0: Matrix4f_): this;
    setTranslation(arg0: Internal.Vector3fc_): this;
    setPerspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    isAffine(): boolean;
    "scale(float,org.joml.Matrix4f)"(arg0: number, arg1: Matrix4f_): this;
    get3x4(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    arcball(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    mapYnXnZ(): this;
    "get3x4(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    set(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Internal.Vector4fc_, arg3: Internal.Vector4fc_): this;
    mul4x3ComponentWise(arg0: Internal.Matrix4fc_): this;
    rotateAffine(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "getNormalizedRotation(org.joml.Quaterniond)"(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    rotateX(arg0: number): this;
    invertFrustum(): this;
    rotateAffineYXZ(arg0: number, arg1: number, arg2: number): this;
    "set(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): this;
    mapnYnZnX(arg0: Matrix4f_): this;
    "get(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    "invertPerspectiveView(org.joml.Matrix4x3fc,org.joml.Matrix4f)"(arg0: Internal.Matrix4x3fc_, arg1: Matrix4f_): this;
    mapnYnXnZ(): this;
    identity(): this;
    set4x3(arg0: Internal.Matrix4x3fc_): this;
    frustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    rotate(arg0: number, arg1: number, arg2: number, arg3: number): this;
    translateLocal(arg0: number, arg1: number, arg2: number): this;
    clone(): any;
    mul4x3ComponentWise(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    perspective(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    invert(arg0: Matrix4f_): this;
    mapZnYnX(): this;
    frustumRayDir(arg0: number, arg1: number, arg2: Vec3f_): Vec3f;
    perspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapnZnYX(): this;
    "mulPerspectiveAffine(org.joml.Matrix4x3fc,org.joml.Matrix4f)"(arg0: Internal.Matrix4x3fc_, arg1: Matrix4f_): this;
    translationRotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    "mul(org.joml.Matrix3x2fc,org.joml.Matrix4f)"(arg0: Internal.Matrix3x2fc_, arg1: Matrix4f_): this;
    getTransposed(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    sub4x3(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    mulPerspectiveAffine(arg0: Internal.Matrix4x3fc_): this;
    transformProject(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
    properties(): number;
    translationRotateScaleInvert(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: number): this;
    "unproject(float,float,float,int[],org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec3f_): Vec3f;
    toString(): string;
    frustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    translationRotateInvert(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_): this;
    mapnYnXZ(): this;
    mapnZnXY(arg0: Matrix4f_): this;
    mulOrthoAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    "perspectiveOffCenterFovLH(float,float,float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    perspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    translateLocal(arg0: Internal.Vector3fc_, arg1: Matrix4f_): this;
    unproject(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec4f_): Vec4f;
    mapnZnYnX(): this;
    perspective(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): this;
    pick(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number[]): this;
    normalize3x3(arg0: Matrix3f_): Matrix3f;
    scaleLocal(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    unproject(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec4f_): Vec4f;
    scaleLocal(arg0: number, arg1: Matrix4f_): this;
    reflect(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_): this;
    "perspectiveOffCenter(float,float,float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    rotateZ(arg0: number): this;
    rotateLocalZ(arg0: number, arg1: Matrix4f_): this;
    scale(arg0: number, arg1: Matrix4f_): this;
    "get3x3(org.joml.Matrix3f)"(arg0: Matrix3f_): Matrix3f;
    "invertPerspectiveView(org.joml.Matrix4fc,org.joml.Matrix4f)"(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    scale(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    "rotate(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): this;
    ortho2D(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    mapYnZnX(): this;
    orthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    "set(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    arcball(arg0: number, arg1: Internal.Vector3fc_, arg2: number, arg3: number): this;
    get(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    reflection(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_): this;
    testPoint(arg0: number, arg1: number, arg2: number): boolean;
    perspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    perspectiveFov(): number;
    "get4x3(org.joml.Matrix4x3f)"(arg0: Internal.Matrix4x3f_): Internal.Matrix4x3f;
    mapZYnX(arg0: Matrix4f_): this;
    mapZXY(): this;
    "get4x3(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    "get4x3(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "transpose3x3(org.joml.Matrix3f)"(arg0: Matrix3f_): Matrix3f;
    mapnXYnZ(arg0: Matrix4f_): this;
    withLookAtUp(arg0: number, arg1: number, arg2: number): this;
    withLookAtUp(arg0: Internal.Vector3fc_, arg1: Matrix4f_): this;
    mapnYnZnX(): this;
    perspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    mapnXnYnZ(arg0: Matrix4f_): this;
    mapYnZnX(arg0: Matrix4f_): this;
    mapnZnYX(arg0: Matrix4f_): this;
    origin(arg0: Vec3f_): Vec3f;
    getTransposed(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    determinantAffine(): number;
    frustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    rotateAroundLocal(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number): this;
    perspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    obliqueZ(arg0: number, arg1: number): this;
    "mul(org.joml.Matrix4x3fc,org.joml.Matrix4f)"(arg0: Internal.Matrix4x3fc_, arg1: Matrix4f_): this;
    "perspective(float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    frustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    ortho2DLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mapnZYnX(): this;
    get(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    lookAtLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    mul3x3(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): this;
    get(arg0: Internal.Matrix4d_): Internal.Matrix4d;
    pick(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number[], arg5: Matrix4f_): this;
    tile(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    rotateY(arg0: number, arg1: Matrix4f_): this;
    ortho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    "orthoLH(float,float,float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    getUnnormalizedRotation(arg0: Quaternionf_): Quaternionf;
    rotateAffine(arg0: Internal.Quaternionfc_, arg1: Matrix4f_): this;
    mapXZnY(arg0: Matrix4f_): this;
    rotateLocalX(arg0: number, arg1: Matrix4f_): this;
    mapnZXY(arg0: Matrix4f_): this;
    reflection(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapnYXnZ(arg0: Matrix4f_): this;
    mapZXnY(): this;
    m31(): number;
    transformAffine(arg0: Vec4f_): Vec4f;
    perspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    get4x3Transposed(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "scale(float)"(arg0: number): this;
    scaleAround(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    m20(arg0: number): this;
    reflection(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    rotationZ(arg0: number): this;
    static perspectiveOffCenterViewFromRectangle(arg0: Vec3f_, arg1: Vec3f_, arg2: Vec3f_, arg3: Vec3f_, arg4: number, arg5: boolean, arg6: Matrix4f_, arg7: Matrix4f_): void;
    mapZXY(arg0: Matrix4f_): this;
    cofactor3x3(arg0: Matrix3f_): Matrix3f;
    mapnYnXnZ(arg0: Matrix4f_): this;
    "getRotation(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): Internal.AxisAngle4f;
    m20(): number;
    get(arg0: Matrix4f_): this;
    transform(arg0: Vec4f_): Vec4f;
    frustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    perspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    normal(arg0: Matrix4f_): this;
    m33(arg0: number): this;
    "get3x4(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    set3x3(arg0: Internal.Matrix3fc_): this;
    translationRotateScale(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: number): this;
    unprojectRay(arg0: number, arg1: number, arg2: number[], arg3: Vec3f_, arg4: Vec3f_): this;
    "translationRotateScale(org.joml.Vector3fc,org.joml.Quaternionfc,org.joml.Vector3fc)"(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: Internal.Vector3fc_): this;
    normalize3x3(arg0: Matrix4f_): this;
    "frustumLH(float,float,float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    "shadow(org.joml.Vector4f,float,float,float,float)"(arg0: Vec4f_, arg1: number, arg2: number, arg3: number, arg4: number): this;
    getScale(arg0: Vec3f_): Vec3f;
    rotation(arg0: number, arg1: Internal.Vector3fc_): this;
    setRotationXYZ(arg0: number, arg1: number, arg2: number): this;
    mapZnXnY(): this;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    invertFrustum(arg0: Matrix4f_): this;
    transformProject(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    wait(arg0: number): void;
    lookAtLH(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    "transformProject(org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    rotationTowardsXY(arg0: number, arg1: number): this;
    "normalize3x3(org.joml.Matrix4f)"(arg0: Matrix4f_): this;
    orthoCrop(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    "shadow(org.joml.Vector4f,float,float,float,float,org.joml.Matrix4f)"(arg0: Vec4f_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: Matrix4f_): this;
    scaling(arg0: number, arg1: number, arg2: number): this;
    rotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    lookAt(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    unprojectInvRay(arg0: Internal.Vector2fc_, arg1: number[], arg2: Vec3f_, arg3: Vec3f_): this;
    transpose3x3(arg0: Matrix4f_): this;
    mul(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    setLookAt(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    "reflect(org.joml.Quaternionfc,org.joml.Vector3fc,org.joml.Matrix4f)"(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    "unprojectInv(float,float,float,int[],org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec4f_): Vec4f;
    m33(): number;
    transpose(arg0: Matrix4f_): this;
    setPerspective(arg0: number, arg1: number, arg2: number, arg3: number): this;
    unprojectInv(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec3f_): Vec3f;
    set(arg0: Internal.Matrix4fc_): this;
    rotationX(arg0: number): this;
    "set(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): this;
    m22(): number;
    m31(arg0: number): this;
    mapZYX(arg0: Matrix4f_): this;
    mulAffineR(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    setOrthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    m11(): number;
    mapYnZX(arg0: Matrix4f_): this;
    mulOrthoAffine(arg0: Internal.Matrix4fc_): this;
    mapnZnXY(): this;
    setTransposed(arg0: Internal.Matrix4fc_): this;
    setRotationZYX(arg0: number, arg1: number, arg2: number): this;
    assume(arg0: number): this;
    "unproject(float,float,float,int[],org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec4f_): Vec4f;
    transformAab(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Vec3f_, arg3: Vec3f_): this;
    mul0(arg0: Internal.Matrix4fc_): this;
    rotateTowardsXY(arg0: number, arg1: number, arg2: Matrix4f_): this;
    perspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    equals(arg0: any): boolean;
    rotateAroundLocal(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    "perspectiveOffCenterFov(float,float,float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    mapnZYnX(arg0: Matrix4f_): this;
    scaleLocal(arg0: number, arg1: number, arg2: number): this;
    m00(): number;
    rotationYXZ(arg0: number, arg1: number, arg2: number): this;
    rotateLocal(arg0: Internal.Quaternionfc_): this;
    "cofactor3x3(org.joml.Matrix3f)"(arg0: Matrix3f_): Matrix3f;
    mul(arg0: Internal.Matrix4x3fc_, arg1: Matrix4f_): this;
    setOrthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    m13(arg0: number): this;
    invertPerspective(arg0: Matrix4f_): this;
    get3x4(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "get(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    mapnZXY(): this;
    orthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    rotateZYX(arg0: Vec3f_): this;
    rotateLocalX(arg0: number): this;
    "normal(org.joml.Matrix3f)"(arg0: Matrix3f_): Matrix3f;
    translationRotateScaleInvert(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number): this;
    get(arg0: number[], arg1: number): number[];
    mapXZnY(): this;
    "setTransposed(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): this;
    set(arg0: Internal.Matrix4dc_): this;
    negateY(): this;
    withLookAtUp(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    mapnZYX(arg0: Matrix4f_): this;
    sub(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    scaleAroundLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    perspective(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    "perspectiveRect(float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    getRow(arg0: number, arg1: Vec4f_): Vec4f;
    "getRotation(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_): Internal.AxisAngle4d;
    "perspectiveLH(float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    getColumn(arg0: number, arg1: Vec4f_): Vec4f;
    set(arg0: number, arg1: Internal.FloatBuffer_): this;
    mapnYXnZ(): this;
    transpose3x3(): this;
    reflect(arg0: number, arg1: number, arg2: number, arg3: number): this;
    rotateAroundAffine(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    setFrustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    setRowColumn(arg0: number, arg1: number, arg2: number): this;
    transformProject(arg0: Vec3f_): Vec3f;
    normalizedPositiveY(arg0: Vec3f_): Vec3f;
    sub4x3(arg0: Matrix4f_): this;
    translationRotateInvert(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number): this;
    setPerspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    perspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    testAab(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): boolean;
    "reflect(org.joml.Quaternionfc,org.joml.Vector3fc)"(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_): this;
    m13(): number;
    reflect(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    mapYZX(): this;
    "get4x3(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    "getRow(int,org.joml.Vector3f)"(arg0: number, arg1: Vec3f_): Vec3f;
    "unprojectInv(org.joml.Vector3fc,int[],org.joml.Vector4f)"(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec4f_): Vec4f;
    setFromAddress(arg0: number): this;
    m02(arg0: number): this;
    "mulPerspectiveAffine(org.joml.Matrix4fc,org.joml.Matrix4f)"(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    mapnYZnX(arg0: Matrix4f_): this;
    transformAffine(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
    m02(): number;
    project(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec4f_): Vec4f;
    transformTranspose(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    scaleAroundLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    transpose(): this;
    "perspectiveOffCenterFov(float,float,float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    "set(float[])"(arg0: number[]): this;
    set(arg0: number[]): this;
    m11(arg0: number): this;
    mulAffine(arg0: Internal.Matrix4fc_): this;
    readExternal(arg0: Internal.ObjectInput_): void;
    getEulerAnglesZYX(arg0: Vec3f_): Vec3f;
    rotateZYX(arg0: number, arg1: number, arg2: number): this;
    "project(float,float,float,int[],org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec3f_): Vec3f;
    positiveX(arg0: Vec3f_): Vec3f;
    setTranslation(arg0: number, arg1: number, arg2: number): this;
    m22(arg0: number): this;
    mapXnZY(): this;
    originAffine(arg0: Vec3f_): Vec3f;
    "set4x3(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    mapnZYX(): this;
    fma4x3(arg0: Internal.Matrix4fc_, arg1: number): this;
    "get3x4(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    setPerspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    set(arg0: Internal.Matrix4x3fc_): this;
    normal(): this;
    reflect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    setLookAt(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    mulTranslationAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    setPerspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    "reflection(org.joml.Quaternionfc,org.joml.Vector3fc)"(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_): this;
    lookAt(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    "set(org.joml.Quaterniondc)"(arg0: Internal.Quaterniondc_): this;
    billboardSpherical(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    "unproject(org.joml.Vector3fc,int[],org.joml.Vector4f)"(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec4f_): Vec4f;
    mul(arg0: Internal.Matrix3x2fc_): this;
    scale(arg0: number, arg1: number, arg2: number): this;
    "perspectiveOffCenterFovLH(float,float,float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    scaling(arg0: Internal.Vector3fc_): this;
    mapnYZnX(): this;
    unprojectInv(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec4f_): Vec4f;
    m00(arg0: number): this;
    setFrustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    get4x3Transposed(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    mulComponentWise(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    "rotate(float,org.joml.Vector3fc)"(arg0: number, arg1: Internal.Vector3fc_): this;
    set(arg0: Internal.ByteBuffer_): this;
    reflect(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    "getUnnormalizedRotation(org.joml.Quaterniond)"(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    set3x3(arg0: Matrix4f_): this;
    perspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): this;
    "getTransposed(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapnXZY(arg0: Matrix4f_): this;
    set(arg0: Internal.Quaterniondc_): this;
    mapnXnZY(arg0: Matrix4f_): this;
    setPerspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mapXZY(arg0: Matrix4f_): this;
    setOrtho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    mulComponentWise(arg0: Internal.Matrix4fc_): this;
    rotate(arg0: Internal.Quaternionfc_, arg1: Matrix4f_): this;
    "perspectiveLH(float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    add(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    swap(arg0: Matrix4f_): this;
    transformDirection(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    negateY(arg0: Matrix4f_): this;
    translationRotateScale(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number): this;
    getClass(): typeof any;
    "transformProject(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    add(arg0: Internal.Matrix4fc_): this;
    determineProperties(): this;
    mapXnZnY(): this;
    orthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): this;
    "set(float[],int)"(arg0: number[], arg1: number): this;
    rotation(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "shadow(float,float,float,float,org.joml.Matrix4fc,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4fc_, arg5: Matrix4f_): this;
    withLookAtUp(arg0: Internal.Vector3fc_): this;
    getTransposed(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapYnZX(): this;
    mapnXnYZ(): this;
    orthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    perspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    rotateAffineZYX(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    set(arg0: Internal.AxisAngle4d_): this;
    mapnXnZnY(): this;
    rotationXYZ(arg0: number, arg1: number, arg2: number): this;
    rotate(arg0: Internal.AxisAngle4f_): this;
    lookAtPerspective(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): this;
    mapZnXnY(arg0: Matrix4f_): this;
    setTransposed(arg0: number[], arg1: number): this;
    rotateAffineXYZ(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    setOrthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    ortho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    "translationRotateScaleInvert(org.joml.Vector3fc,org.joml.Quaternionfc,org.joml.Vector3fc)"(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: Internal.Vector3fc_): this;
    get3x4(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    get4x3Transposed(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    get4x3(arg0: Internal.Matrix4x3f_): Internal.Matrix4x3f;
    scale(arg0: Internal.Vector3fc_): this;
    "mul(org.joml.Matrix4fc,org.joml.Matrix4f)"(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    "cofactor3x3(org.joml.Matrix4f)"(arg0: Matrix4f_): this;
    lookAt(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): this;
    transformPosition(arg0: Vec3f_): Vec3f;
    "rotation(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): this;
    set(arg0: Internal.AxisAngle4f_): this;
    affineSpan(arg0: Vec3f_, arg1: Vec3f_, arg2: Vec3f_, arg3: Vec3f_): this;
    perspectiveFrustumSlice(arg0: number, arg1: number, arg2: Matrix4f_): this;
    transformDirection(arg0: Vec3f_): Vec3f;
    perspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): this;
    determinant3x3(): number;
    wait(): void;
    get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "frustum(float,float,float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    projectedGridRange(arg0: Internal.Matrix4fc_, arg1: number, arg2: number, arg3: Matrix4f_): this;
    mulAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    perspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    setFrustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapnZnXnY(arg0: Matrix4f_): this;
    shadow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4fc_, arg5: Matrix4f_): this;
    rotationAround(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number): this;
    set4x3(arg0: Matrix4f_): this;
    project(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec3f_): Vec3f;
    getTransposed(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "setTransposed(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): this;
    "get(org.joml.Matrix4d)"(arg0: Internal.Matrix4d_): Internal.Matrix4d;
    get4x3(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    translateLocal(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    scaleAround(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mapnXnYZ(arg0: Matrix4f_): this;
    normalize3x3(): this;
    translationRotateScaleInvert(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: Internal.Vector3fc_): this;
    mapnXnZY(): this;
    translationRotateScale(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): this;
    get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    rotate(arg0: number, arg1: Internal.Vector3fc_): this;
    translation(arg0: number, arg1: number, arg2: number): this;
    "transpose3x3(org.joml.Matrix4f)"(arg0: Matrix4f_): this;
    orthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    setOrthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    frustumPlane(arg0: number, arg1: Vec4f_): Vec4f;
    transformPosition(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    invertAffine(): this;
    frustumCorner(arg0: number, arg1: Vec3f_): Vec3f;
    "project(org.joml.Vector3fc,int[],org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec3f_): Vec3f;
    get(arg0: number[]): number[];
    shadow(arg0: Vec4f_, arg1: Internal.Matrix4fc_, arg2: Matrix4f_): this;
    set(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: number, arg14: number, arg15: number): this;
    toString(arg0: Internal.NumberFormat_): string;
    rotateAffine(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    frustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    transformProject(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec3f_): Vec3f;
    mapZXnY(arg0: Matrix4f_): this;
    rotateXYZ(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    writeExternal(arg0: Internal.ObjectOutput_): void;
    setPerspective(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    getRotation(arg0: Internal.AxisAngle4f_): Internal.AxisAngle4f;
    perspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    get4x3(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    "get3x4(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    mapYnXZ(): this;
    setTransposed(arg0: number[]): this;
    unproject(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec3f_): Vec3f;
    "scale(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    rotateY(arg0: number): this;
    rotateTranslation(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    invertPerspectiveView(arg0: Internal.Matrix4x3fc_, arg1: Matrix4f_): this;
    orthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    setPerspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    notifyAll(): void;
    add4x3(arg0: Internal.Matrix4fc_): this;
    mapnXZnY(): this;
    mulAffineR(arg0: Internal.Matrix4fc_): this;
    frustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    ortho2D(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "orthoSymmetricLH(float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    transformAffine(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    perspectiveFar(): number;
    orthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "set(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): this;
    orthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    mapnXnZnY(arg0: Matrix4f_): this;
    set(arg0: Internal.Quaternionfc_): this;
    "rotate(org.joml.AxisAngle4f,org.joml.Matrix4f)"(arg0: Internal.AxisAngle4f_, arg1: Matrix4f_): this;
    mapYnXZ(arg0: Matrix4f_): this;
    "getTransposed(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    "perspective(float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    "get(float[],int)"(arg0: number[], arg1: number): number[];
    "getTransposed(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapXnZnY(arg0: Matrix4f_): this;
    mapYXZ(): this;
    determinant(): number;
    "reflect(org.joml.Vector3fc,org.joml.Vector3fc,org.joml.Matrix4f)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    add4x3(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    setLookAtLH(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    wait(arg0: number, arg1: number): void;
    setOrthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "perspectiveOffCenter(float,float,float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    getUnnormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    mapnXZnY(arg0: Matrix4f_): this;
    rotateZYX(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    translate(arg0: Internal.Vector3fc_): this;
    "get(org.joml.Matrix4f)"(arg0: Matrix4f_): this;
    m30(): number;
    rotateLocal(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "set3x3(org.joml.Matrix4f)"(arg0: Matrix4f_): this;
    "getUnnormalizedRotation(org.joml.Quaternionf)"(arg0: Quaternionf_): Quaternionf;
    "mul(org.joml.Matrix3x2fc)"(arg0: Internal.Matrix3x2fc_): this;
    rotate(arg0: number, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    getTranslation(arg0: Vec3f_): Vec3f;
    invertPerspectiveView(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    set transposedFromAddress(arg0: number)
    set "(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_)
    get finite(): boolean
    set transposed(arg0: Internal.FloatBuffer_)
    set "(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_)
    set "transposed(float[])"(arg0: number[])
    set "(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_)
    set transposed(arg0: Internal.ByteBuffer_)
    set "(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_)
    set "transposed(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_)
    set "(org.joml.Matrix4dc)"(arg0: Internal.Matrix4dc_)
    set "(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_)
    set translation(arg0: Internal.Vector3fc_)
    get affine(): boolean
    set "(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_)
    set "(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_)
    set "(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_)
    set transposed(arg0: Internal.Matrix4fc_)
    set "transposed(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_)
    set fromAddress(arg0: number)
    set "(float[])"(arg0: number[])
    set "(org.joml.Quaterniondc)"(arg0: Internal.Quaterniondc_)
    get class(): typeof any
    set "transposed(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_)
    set transposed(arg0: number[])
}
type Matrix4f_ = Matrix4f;
/**
 * The hub for all things text components. Format text to your hearts content!
*/
declare class Component {
    constructor()
    getClass(): typeof any;
    /**
     * Returns a component of the input, colored light purple
    */
    static lightPurple(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored blue
    */
    static blue(text: any): Internal.MutableComponent;
    /**
     * Returns a translatable component of the input key
    */
    static translatable(key: string): Internal.MutableComponent;
    /**
     * Returns a ClickEvent of the input
    */
    static clickEventOf(o: any): Internal.ClickEvent;
    /**
     * Returns a colorful representation of the input nbt. Useful for displaying NBT to the player
    */
    static prettyPrintNbt(tag: Internal.Tag_): net.minecraft.network.chat.Component;
    /**
     * Returns an empty component
    */
    static empty(): Internal.MutableComponent;
    /**
     * Returns a translatable component of the input key, with args of the objects
    */
    static translatable(key: string, ...objects: any[]): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored white
    */
    static white(text: any): Internal.MutableComponent;
    /**
     * Returns a plain component of the string, or empty if it is an empty string
    */
    static ofString(s: string): Internal.MutableComponent;
    /**
     * Returns a translatable component of the input key, with args of the objects
    */
    static translate(key: string, ...objects: any[]): Internal.MutableComponent;
    /**
     * Returns a translatable component of the input key
    */
    static translate(key: string): Internal.MutableComponent;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    /**
     * Returns a component displaying all entities matching the input selector
    */
    static selector(selector: string): Internal.MutableComponent;
    /**
     * Checks if the passed in component, and all its children are empty
    */
    static isEmpty(component: net.minecraft.network.chat.Component_): boolean;
    /**
     * Returns a component of the input, colored yellow
    */
    static yellow(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark purple
    */
    static darkPurple(text: any): Internal.MutableComponent;
    /**
     * Returns a Component of the input
    */
    static of(o: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored gray
    */
    static gray(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark blue
    */
    static darkBlue(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark red
    */
    static darkRed(text: any): Internal.MutableComponent;
    toString(): string;
    /**
     * Returns a component of the input, colored gold
    */
    static gold(text: any): Internal.MutableComponent;
    notifyAll(): void;
    /**
     * Returns a component of the input, colored red
    */
    static red(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark green
    */
    static darkGreen(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored green
    */
    static green(text: any): Internal.MutableComponent;
    /**
     * Returns a keybinding component of the input keybinding descriptor
    */
    static keybind(keybind: string): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark aqua
    */
    static darkAqua(text: any): Internal.MutableComponent;
    /**
     * Joins all components
    */
    static join(...texts: net.minecraft.network.chat.Component_[]): Internal.MutableComponent;
    hashCode(): number;
    /**
     * Returns a score component of the input objective, for the provided selector
    */
    static score(selector: string, objective: string): Internal.MutableComponent;
    /**
     * Returns a plain component of the passed in string, even if empty
    */
    static string(text: string): Internal.MutableComponent;
    wait(): void;
    /**
     * Joins all components in the list with the separator component
    */
    static join(separator: Internal.MutableComponent_, texts: Internal.Iterable_<net.minecraft.network.chat.Component>): Internal.MutableComponent;
    /**
     * Returns a component displaying all entities matching the input selector, with a custom separator
    */
    static selector(selector: string, separator: net.minecraft.network.chat.Component_): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored aqua
    */
    static aqua(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored black
    */
    static black(text: any): Internal.MutableComponent;
    wait(arg0: number): void;
    /**
     * Returns a component of the input, colored dark gray
    */
    static darkGray(text: any): Internal.MutableComponent;
    /**
     * Returns a plain component of the input
    */
    static literal(text: string): Internal.MutableComponent;
    equals(arg0: any): boolean;
    get class(): typeof any
}
type Component_ = Component;
/**
 * A collection of utilities
*/
declare interface Utils {
    /**
     * Capitalises the first letter of the string unless it is "a", "an", "the", "of", "on", "in", "and", "or", "but" or "for"
    */
    toTitleCase(s: string): string;
    /**
     * Returns a Stat of the passed in ResourceLocation.
     * Note that this requires the same ResourceLocation to get the same stat, so should not be used unless you want to make your own stat, and are storing an actual ResourceLocation somewhere to access it.
    */
    getStat(id: ResourceLocation_): Internal.Stat<ResourceLocation>;
    /**
     * Returns the provided snake_case_string in Title Case
    */
    snakeCaseToTitleCase(string: string): string;
    /**
     * Returns a new counting map
    */
    newCountingMap(): Internal.CountingMap;
    /**
     * Capitalises the first letter of the string. If ignoreSpecial is true, it will also capitalise articles and prepositions
    */
    toTitleCase(s: string, ignoreSpecial: boolean): string;
    /**
     * Tries to parse the first parameter as a double and returns that. The second parameter is returned if parsing fails
    */
    parseDouble(object: any, def: number): number;
    /**
     * Get a Random, for generating random numbers. Note this will always return the same Random instance
    */
    getRandom(): Internal.Random;
    /**
     * Returns a new mutable list
    */
    newList(): Internal.List<any>;
    /**
     * Get a new random with the specified seed
    */
    newRandom(seed: number): Internal.Random;
    /**
     * Gets all ids from the registry with the specified id
    */
    getRegistryIds(id: ResourceLocation_): Internal.List<ResourceLocation>;
    /**
     * Returns the results of rolling the specified loot table (it does not have to be a chest loot table)
    */
    rollChestLoot(id: ResourceLocation_): Internal.List<Internal.ItemStack>;
    /**
     * Get an immutable empty list
    */
    emptyList<T>(): Internal.List<T>;
    /**
     * Gets the current system time, in milliseconds
    */
    getSystemTime(): number;
    /**
     * Runs the provided supplier function in KubeJS' background thread and returns its CompletableFuture
    */
    supplyAsync(task: Internal.Supplier_<any>): Internal.CompletableFuture<any>;
    /**
     * Returns a ResourceLocation with the specified namepsace and path
    */
    id(namespace: string, path: string): ResourceLocation;
    /**
     * Returns a lazy value with the supplier function as its value factory
    */
    lazy<T>(supplier: Internal.Supplier_<T>): Internal.Lazy<T>;
    /**
     * Checks if the passed in object is an instance of WrappedJS
    */
    isWrapped(o: any): boolean;
    /**
     * Returns the provided snake_case_string in camelCase
    */
    snakeCaseToCamelCase(string: string): string;
    /**
     * Returns the creative tab associated with the id
    */
    findCreativeTab(id: ResourceLocation_): Internal.CreativeModeTab;
    /**
     * Get an immutable empty map
    */
    emptyMap<K, V>(): Internal.Map<K, V>;
    /**
     * Returns a lazy value with the supplier function as its value factory, that will expire after the specified number of milliseconds
    */
    expiringLazy<T>(supplier: Internal.Supplier_<T>, time: number): Internal.Lazy<T>;
    /**
     * Gets a SoundEvent from the id
    */
    getSound(id: ResourceLocation_): Internal.SoundEvent;
    /**
     * Gets a random object from the list using the passed in random
    */
    randomOf(random: Internal.Random_, objects: Internal.Collection_<any>): any;
    /**
     * Returns a new mutable map
    */
    newMap(): Internal.Map<any, any>;
    /**
     * Gets the specified registry
    */
    getRegistry(id: ResourceLocation_): Internal.RegistryInfo<any>;
    particleOptions(o: any): Internal.ParticleOptions;
    /**
     * Returns a copy the object if possible, or the object itself if not
    */
    copy(o: any): any;
    /**
     * Returns a regex pattern of the input with the specified flags
    */
    regex(pattern: string, flags: number): Internal.Pattern;
    /**
     * Typewraps the input string to a ResourceLocation. Format should be namespace:path
    */
    id(id: ResourceLocation_): ResourceLocation;
    /**
     * Returns a regex pattern of the input
    */
    regex(s: any): Internal.Pattern;
    /**
     * Runs the provided runnable function in KubeJS' background thread and returns its CompletableFuture
    */
    runAsync(task: Internal.Runnable_): Internal.CompletableFuture<void>;
    /**
     * Parses a block state from the input string. May throw for invalid inputs!
    */
    parseBlockState(o: any): Internal.BlockState;
    /**
     * Immediately run the passed runnable function in a try-catch block, and log the exception if it throws
    */
    queueIO(runnable: Internal.Runnable_): void;
    /**
     * Tries to parse the first parameter as an integer, and returns that. The second parameter is returned if parsing fails
    */
    parseInt(object: any, def: number): number;
    /**
     * Get the server. Null if there is no server (startup or client)
    */
    getServer(): Internal.MinecraftServer;
    /**
     * Returns the results of rolling the specified loot table with the entity as a parameter (it does not have to be a chest loot table)
    */
    rollChestLoot(id: ResourceLocation_, entity: Internal.Entity_): Internal.List<Internal.ItemStack>;
    /**
     * Get a Random, for generating random numbers. Note this will always return the same Random instance
    */
    get random(): Internal.Random
    /**
     * Gets the current system time, in milliseconds
    */
    get systemTime(): number
    /**
     * Get the server. Null if there is no server (startup or client)
    */
    get server(): Internal.MinecraftServer
    readonly ERROR_PARTICLE: (Internal.DustParticleOptions) & (Internal.DustParticleOptions);
}
type Utils_ = Utils;
declare const Utils: Utils;
declare interface AABB {
    ofSize(vec3: Vec3d_, x: number, y: number, z: number): Internal.AABB;
    ofBlock(pos: BlockPos_): Internal.AABB;
    of(x0: number, y0: number, z0: number, x1: number, y1: number, z1: number): Internal.AABB;
    ofSize(x: number, y: number, z: number): Internal.AABB;
    ofBlocks(pos1: BlockPos_, pos2: BlockPos_): Internal.AABB;
    wrap(o: any): Internal.AABB;
    readonly CUBE: (Internal.AABB) & (Internal.AABB);
    readonly EMPTY: (Internal.AABB) & (Internal.AABB);
}
type AABB_ = AABB;
declare const AABB: AABB;
declare namespace Special {
    type Mod = "tagtooltips" | "dynamiclightsreforged" | "ftbessentials" | "supermartijn642configlib" | "openpartiesandclaims" | "createdeco" | "scena" | "underground_villages" | "simplemagnets" | "playeranimator" | "mcwwindows" | "dynamicvillagertrades" | "aquaculturedelight" | "bettertitlescreen" | "modernfix" | "villagersplus" | "yungsapi" | "ssls_npc_maker_mod" | "kambrik" | "forgivingvoid" | "balm" | "snowrealmagic" | "dynview" | "biggerstacks" | "jeresources" | "paraglider" | "cloth_config" | "shetiphiancore" | "moa_decor_bath" | "embeddium" | "rubidium" | "athena" | "handcrafted" | "repurposed_structures" | "mcwtrpdoors" | "supermartijn642corelib" | "yungsbridges" | "moa_decor_toys" | "botania" | "fairylights" | "mr_tidal_towns" | "luphieclutteredmod" | "curios" | "corail_woodcutter" | "oculus" | "iris" | "gamestages" | "searchables" | "yungsextras" | "framedblocks" | "bettervillage" | "neighborly" | "constructionwand" | "mcwroofs" | "mcwfurnitures" | "chimes" | "jadeaddons" | "l2library" | "krypton" | "toms_storage" | "moa_decor_art" | "fastleafdecay" | "exoticbirds" | "sliceanddice" | "mcwlights" | "crafting_on_a_stick" | "betterjungletemples" | "elytraslot" | "quarkoddities" | "kiwi" | "fastload" | "l2tabs" | "moa_decor_garden_" | "libraryferret" | "caelus" | "oculusparticlefix" | "naturescompass" | "sereneseasons" | "libx" | "botanypots" | "l2screentracker" | "moa_decor_holidays" | "farmingforblockheads" | "adorabuild_structures" | "snowundertrees" | "questsadditions" | "packingtape" | "crafttweaker" | "puzzlesaccessapi" | "forge" | "logbegone" | "emotecraft" | "minecraft" | "smoothchunk" | "compressedblocks" | "terrablender" | "biomesoplenty" | "mousetweaks" | "pamhc2crops" | "cleanswing" | "spectrelib" | "ksyxis" | "betterfpsdist" | "kotlinforforge" | "flywheel" | "pamhc2foodcore" | "gravestone" | "cyclepaintings" | "polymorph" | "lootbags" | "justenoughprofessions" | "zeta" | "playdate" | "entityculling" | "canary" | "xaeroplus" | "xaerominimap" | "appleskin" | "lootr" | "puzzleslib" | "aquaculture" | "extremesoundmuffler" | "cosmeticarmorreworked" | "defaultoptions" | "cristellib" | "treechop" | "skyvillages" | "globalpacks" | "beautify" | "morejs" | "utilitix" | "jei" | "incontrol" | "tipsmod" | "immersive_aircraft" | "sophisticatedcore" | "gpumemleakfix" | "villagernames" | "mcwfurnituresbop" | "xaeroworldmap" | "controlling" | "placebo" | "citadel" | "alexsmobs" | "domesticationinnovation" | "mixinextras" | "gemsnjewels" | "bookshelf" | "sophisticatedbackpacks" | "create_dragon_lib" | "mcwdoors" | "panoramica" | "railways" | "macawsroofsbop" | "konkrete" | "rsinfinitybooster" | "chipped" | "mcwbridges" | "farmersdelight" | "entity_model_features" | "entity_texture_features" | "nomobfarm" | "getittogetherdrops" | "mcwfences" | "pamhc2foodextended" | "moa_decor_cookery" | "non_wandering_trader" | "collective" | "camera" | "simplehats" | "drawerstooltip" | "betterthirdperson" | "seamless_loading_screen" | "resourcefullib" | "inventoryprofilesnext" | "architectury" | "doapi" | "terraform" | "vinery" | "herbalbrews" | "ftblibrary" | "nethervinery" | "wands" | "spacecatcustomprofessions" | "candlelight" | "bakery" | "beachparty" | "ftbteams" | "bloomingnature" | "brewery" | "meadow" | "constantmusic" | "aiimprovements" | "cupboard" | "lightoverlay" | "trashcans" | "framework" | "probejs" | "t_and_t" | "letmedespawn" | "cosmeticarmoursmod" | "controllable" | "rhino" | "kubejs" | "realseasons" | "handoveryouritems" | "pamhc2trees" | "amendments" | "sophisticatedstorage" | "copycats" | "itemfilters" | "ftbquests" | "ftbxmodcompat" | "mobcapturingtool" | "structorytowers" | "create" | "delightful" | "create_central_kitchen" | "waystones" | "structory" | "fastsuite" | "clumps" | "comforts" | "artifacts" | "alternate_current" | "framedcompactdrawers" | "moa_decor_science" | "create_confectionery" | "mighty_mail" | "betterdeserttemples" | "explorerscompass" | "farsight_view" | "playershops" | "recipestages" | "libertyvillagers" | "libipn" | "chipped_express" | "sebastrnlib" | "refinedcooking" | "refinedstorage" | "cookingforblockheads" | "patchouli" | "radiantgear" | "moonlight" | "toolbelt" | "mixinsquared" | "jade" | "snowyspirit" | "creativecore" | "nethersdelight" | "citresewn" | "quark" | "supplementaries" | "diet" | "storagedrawers" | "enderchests" | "moa_decor_lights" | "alexsdelight" | "ferritecore" | "yet_another_config_lib_v3" | "solcarrot" | "charmofundying" | "l2itemselector" | "refinedstorageaddons" | "expandability" | "chiselsandbits" | "overflowingbars" | "createaddition"
    type Ingredient = "libx:effect" | "crafttweaker:any" | "crafttweaker:list" | "crafttweaker:transformed" | "crafttweaker:conditioned" | "crafttweaker:partial_tag" | "kubejs:wildcard" | "kubejs:custom" | "kubejs:custom_predicate" | "kubejs:mod" | "kubejs:regex" | "kubejs:creative_tab" | "toolbelt:belt_upgrade_level" | "kiwi:full_block" | "kiwi:alternatives" | "zeta:flag" | "quark:flag" | "drawerstooltip:standard" | "l2library:enchantment" | "l2library:potion" | "l2library:mob_effect" | "forge:compound" | "forge:nbt" | "forge:partial_nbt" | "forge:difference" | "forge:intersection" | "minecraft:item" | "farmersdelight:tool_action" | "create:block_tag_ingredient";
    type Advancement = "compressedblocks:addiction/c4_diamond_edition" | "meadow:main/get_rennet" | "create:red_signal" | "comforts:sleeping_bag_light_blue" | "minecraft:nether/obtain_crying_obsidian" | "alexsmobs:alexsmobs/bison_spyglass" | "botania:main/bubbell_pickup" | "chiselsandbits:chiselsandbits/collect_bits" | "farmersdelight:main/place_cooking_pot" | "minecraft:husbandry/allay_deliver_item_to_player" | "minecraft:husbandry/froglights" | "botania:challenge/gaia_guardian_hardmode" | "candlelight:main/cook_everything_pan" | "mcwroofs:recipes/birch_planks" | "create:train_portal" | "mcwfences:recipes/stone" | "compressedblocks:addiction/c7_stone_edition" | "refinedstorage:wireless_items" | "mcwroofs:recipes/dark_oak" | "beachparty:palm_sign" | "minecraft:nether/distract_piglin" | "compressedblocks:addiction/c7_diamond_edition" | "mcwroofs:recipes/spruce" | "bakery:main/get_all_cakes" | "lootr:1chest" | "compressedblocks:addiction/c1_diamond_edition" | "alexsmobs:alexsmobs/crimson_mosquito_larva" | "compressedblocks:compression/quadruple_crate" | "cosmeticarmoursmod:golden_halo_achievement" | "alexsmobs:alexsmobs/skunk" | "mcwfences:recipes/end" | "comforts:hammock_purple" | "quark:throw_parrot_egg" | "create:ejector_maxed" | "create:mechanical_pump_0" | "create:brass" | "beautify:hanging_pot" | "nethervinery:crimson_apple_press" | "beachparty:sunglasses" | "brewery:main/get_beer_haley" | "repurposed_structures:bastion_underground" | "vanillatweaks:root" | "comforts:sleeping_bag_pink" | "lootr:1shulker" | "alexsmobs:alexsmobs/murmur" | "corail_woodcutter:recipes/from_jungle_planks" | "refinedstorage:viewing_fluids" | "artifacts:chest_slayer" | "comforts:hammock_magenta" | "snowyspirit:adventure/ride_sled_fast" | "supplementaries:story/unenchanter" | "compressedblocks:addiction/c9_gravel_edition" | "adorabuild_structures:hungry_cutie" | "botania:main/mana_cookie_eat" | "beachparty:palm_pressure_plate" | "botania:challenge/root" | "botania:challenge/infinite_fruit" | "brewery:main/eat_everything" | "botania:main/ender_air_make" | "minecraft:story/obtain_armor" | "botania:main/mana_bomb_ignite" | "bakery:main/place_strawberry_crate" | "vinery:main/get_drunk" | "create:diving_suit" | "corail_woodcutter:recipes/biomesoplenty/from_hellbark_planks" | "alexsmobs:alexsmobs/novelty_hat" | "alexsmobs:alexsmobs/tame_tarantula_hawk" | "minecraft:adventure/trim_with_all_exclusive_armor_patterns" | "adorabuild_structures:fungal_detective" | "botania:main/luminizer_ride" | "minecraft:adventure/very_very_frightening" | "nethervinery:warped_wine_rack_mid" | "minecraft:story/lava_bucket" | "create:hose_pulley_lava" | "mcwroofs:recipes/acacia_planks" | "create:train_crash" | "beachparty:bikini" | "compressedblocks:addiction/c8_stone_edition" | "farmersdelight:main/get_rich_soil" | "beachparty:palm_chest_boat" | "corail_woodcutter:recipes/biomesoplenty/from_magic_planks" | "create:long_travel" | "mcwfences:recipes/bamboo" | "comforts:hammock_red" | "minecraft:husbandry/ride_a_boat_with_a_goat" | "lootr:social" | "alexsmobs:alexsmobs/ghostly_pickaxe" | "minecraft:end/kill_dragon" | "cosmeticarmoursmod:bunny_ear_achievement" | "brewery:main/get_whiskey_maggoallan" | "create:clockwork_bearing" | "botania:main/corporea_craft" | "minecraft:adventure/lightning_rod_with_villager_no_fire" | "brewery:main/brewing_pioneer" | "compressedblocks:addiction/c0_netherite_edition" | "nethervinery:crimson_nether_bag" | "adorabuild_structures:treasure_seeker" | "farmersdelight:main/place_skillet" | "botania:challenge/rank_ss_pick" | "create:encased_fan" | "compressedblocks:addiction/c6_stone_edition" | "minecraft:nether/all_potions" | "botania:main/heisei_dream_pickup" | "beachparty:sand_bucket_block" | "vinery:main/fermentation" | "paraglider:root" | "supplementaries:adventure/way_sign" | "alexsmobs:alexsmobs/fish_bones" | "alexsmobs:alexsmobs/crimson_mosquito" | "compressedblocks:addiction/c5_stone_edition" | "mcwroofs:recipes/sandstone" | "minecraft:husbandry/tame_an_animal" | "bakery:main/place_oat_crate" | "repurposed_structures:shipwrecks" | "minecraft:adventure/craft_decorated_pot_using_only_sherds" | "mcwfences:recipes/deepslate" | "compressedblocks:addiction/c9_stone_edition" | "repurposed_structures:villages" | "brewery:main/drying_excellence" | "minecraft:husbandry/make_a_sign_glow" | "create:andesite_alloy" | "bakery:main/use_bread_on_wall_display" | "compressedblocks:addiction/c2_netherite_edition" | "create:water_wheel" | "mcwroofs:recipes/bamboo" | "alexsmobs:alexsmobs/cosmic_cod" | "beachparty:mini_fridge" | "create:mechanical_arm" | "armor_statues:enable" | "botania:main/crafting_halo_craft" | "minecraft:nether/create_beacon" | "beautify:rope" | "adorabuild_structures:the_lethal_towers" | "cosmeticarmoursmod:gone_fishing_achievement" | "botania:main/kekimurus_pickup" | "adorabuild_structures:bubble_miracle" | "create:windmill_maxed" | "minecraft:story/deflect_arrow" | "alexsmobs:alexsmobs/save_cachalot_whale" | "botania:challenge/old_flower_pickup" | "create:sturdy_sheet" | "botania:main/root" | "bakery:main/place_sign" | "beautify:progression/bookstack" | "minecraft:husbandry/leash_all_frog_variants" | "alexsmobs:alexsmobs/banana" | "alexsmobs:alexsmobs/transmutation_table" | "adorabuild_structures:eyes_of_the_void" | "nethervinery:warped_grapevine_pot" | "meadow:main/cheese_collector" | "exoticbirds:default/log_parrots" | "exoticbirds:default/tame_pelican" | "herbalbrews:main/place_tea_kettle" | "exoticbirds:default/craft_book" | "brewery:main/wild_crops" | "minecraft:story/iron_tools" | "alexsmobs:alexsmobs/enderiophage" | "comforts:sleeping_bag_white" | "compressedblocks:addiction/c2_gold_edition" | "supplementaries:husbandry/turn_table" | "comforts:sleeping_bag_gray" | "alexsmobs:alexsmobs/devils_hole_pupfish_bucket" | "alexsmobs:alexsmobs/tame_cosmaw" | "create:track_0" | "botania:main/runic_altar_pickup" | "herbalbrews:main/find_lavender" | "mcwroofs:recipes/birch" | "comforts:rope_and_nail" | "alexsmobs:alexsmobs/crocodile_chestplate" | "farmersdelight:main/get_mushroom_colony" | "compressedblocks:addiction/c2_cobblestone_edition" | "alexsmobs:alexsmobs/spectre" | "brewery:main/get_whiskey_lilitusinglemalt" | "explorerscompass:explorers_compass_cracked_stone_bricks" | "compressedblocks:addiction/c8_netherite_edition" | "create:honey_drain" | "alexsmobs:alexsmobs/orcas_might" | "alexsmobs:alexsmobs/void_worm_summon" | "bakery:main/find_wild_crops" | "toms_storage:unlock_glowstone" | "beachparty:chair" | "refinedstorage:crafting_on_demand" | "corail_woodcutter:recipes/biomesoplenty/from_umbran_planks" | "alexsmobs:alexsmobs/echolocator" | "alexsmobs:alexsmobs/leafcutter_ant_pupa" | "minecraft:nether/brew_potion" | "herbalbrews:main/drink_armor_flask" | "comforts:sleeping_bag_cyan" | "refinedstorage:destruction" | "meadow:main/place_straw_bed" | "supplementaries:nether/goblet" | "botania:main/bauble_wear" | "brewery:main/copper_brewmaster" | "herbalbrews:main/let_it_dry" | "candlelight:main/find_wild_crops" | "minecraft:end/dragon_egg" | "minecraft:adventure/kill_mob_near_sculk_catalyst" | "botania:challenge/thor_ring" | "minecraft:husbandry/fishy_business" | "alexsmobs:alexsmobs/squid_grapple" | "mcwfences:recipes/dark_oak" | "refinedstorage:wireless_fluids" | "farmersdelight:main/obtain_netherite_knife" | "lootr:50loot" | "refinedstorage:no_cables_required" | "create:pulley_maxed" | "compressedblocks:addiction/c0_cobblestone_edition" | "minecraft:nether/explore_nether" | "meadow:main/fur_armor" | "vinery:main/place_pot" | "compressedblocks:addiction/c4_sand_edition" | "corail_woodcutter:recipes/from_warped_planks" | "refinedstorage:wireless" | "alexsmobs:alexsmobs/spiked_turtle_shell" | "alexsmobs:alexsmobs/gustmaker" | "compressedblocks:addiction/c3_gold_edition" | "quark:wear_full_rainbow" | "nethervinery:warped_wine_rack_small" | "alexsmobs:alexsmobs/void_worm_split" | "refinedstorage:interface_to_the_world" | "create:chocolate_bucket" | "minecraft:adventure/fall_from_world_height" | "comforts:sleeping_bag_light_gray" | "create:fist_bump" | "alexsmobs:alexsmobs/emu" | "vinery:main/wild_crops" | "corail_woodcutter:recipes/biomesoplenty/from_jacaranda_planks" | "alexsmobs:alexsmobs/tame_flutter" | "repurposed_structures:pyramids" | "comforts:hammock_black" | "nethervinery:crested_crimson_planks" | "minecraft:nether/ride_strider" | "beachparty:palm_beam" | "beachparty:palm_door" | "candlelight:main/place_cooking_pan" | "minecraft:adventure/sniper_duel" | "create:track_signal" | "mcwroofs:recipes/stone" | "adorabuild_structures:suspiciously_dangerous" | "cosmeticarmoursmod:netherite_crown_achievement" | "compressedblocks:addiction/c7_dirt_edition" | "minecraft:nether/root" | "compressedblocks:addiction/c4_gravel_edition" | "botania:main/dirt_rod_craft" | "compressedblocks:compression/septuple_crate" | "alexsmobs:alexsmobs/tame_capuchin" | "create:extendo_grip" | "quark:throw_pickarang" | "mcwroofs:recipes/oak" | "minecraft:end/levitate" | "quark:retreive_flamerang" | "create:glass_pipe" | "alexsmobs:alexsmobs/stradpole_feed" | "bakery:main/place_cooking_pot" | "create:self_deploying" | "quark:poison_baby" | "candlelight:main/cook_beef_wellington" | "create:musical_arm" | "repurposed_structures:city_overworld" | "refinedstorage:upgrading" | "botania:challenge/flugel_eye" | "farmersdelight:main/plant_rice" | "compressedblocks:addiction/c5_gravel_edition" | "create:display_link" | "nethervinery:obsidian_stem" | "mcwroofs:recipes/oak_planks" | "mcwfences:recipes/spruce" | "farmersdelight:main/get_ham" | "adorabuild_structures:oh_fortune" | "mcwroofs:recipes/jungle_planks" | "alexsmobs:alexsmobs/crimson_mosquito_sick" | "minecraft:nether/all_effects" | "alexsmobs:alexsmobs/capsid" | "candlelight:main/place_table" | "minecraft:adventure/bullseye" | "corail_woodcutter:recipes/biomesoplenty/from_dead_planks" | "botania:main/mana_blaster_shoot" | "nethervinery:warped_grape_seeds" | "meadow:main/milk_collector" | "alexsmobs:alexsmobs/rattlesnake" | "beachparty:beach_hat" | "compressedblocks:addiction/c1_stone_edition" | "compressedblocks:addiction/c4_cobblestone_edition" | "compressedblocks:addiction/c3_sand_edition" | "quark:instamine_deepslate" | "compressedblocks:addiction/c0_iron_edition" | "minecraft:nether/get_wither_skull" | "meadow:main/place_frame" | "compressedblocks:addiction/c9_dirt_edition" | "botania:main/terrasteel_pickup" | "minecraft:husbandry/bred_all_animals" | "refinedstorage:conditional_connecting" | "betterdeserttemples:temple_entry" | "trashcans:trash_can" | "minecraft:story/mine_stone" | "botania:main/flower_pickup_lexicon" | "candlelight:main/cook_everything_vegetable" | "quark:mine_toretoise" | "compressedblocks:addiction/c5_dirt_edition" | "alexsmobs:alexsmobs/grizzly_bear" | "beautify:lamps" | "create:saw_processing" | "create:andesite_casing" | "corail_woodcutter:recipes/from_cherry_planks" | "adorabuild_structures:fireproof" | "alexsmobs:alexsmobs/laviathan_four_passengers" | "armor_statues:root" | "exoticbirds:default/log_water_birds" | "cosmeticarmoursmod:winged_halo_achievement" | "cosmeticarmoursmod:one_small_step_achievement" | "alexsmobs:alexsmobs/soul_vulture" | "lootr:10loot" | "mcwfences:recipes/crimson" | "compressedblocks:addiction/c6_gravel_edition" | "refinedstorage:upgrading_your_grid" | "mcwfences:recipes/prismarine" | "compressedblocks:addiction/c3_stone_edition" | "meadow:main/root" | "create:steam_engine_maxed" | "botania:main/cacophonium_craft" | "compressedblocks:addiction/c7_netherite_edition" | "farmersdelight:main/root" | "botania:main/functional_flower" | "beautify:lamp_jar" | "alexsmobs:alexsmobs/la_cucaracha" | "minecraft:adventure/two_birds_one_arrow" | "mcwfences:recipes/quartz" | "minecraft:story/enter_the_nether" | "minecraft:adventure/whos_the_pillager_now" | "nethervinery:crested_warped_planks" | "alexsmobs:alexsmobs/gongylidia" | "alexsmobs:alexsmobs/straddle_saddle" | "meadow:main/kill_brown_bear" | "mcwroofs:recipes/granite" | "alexsmobs:alexsmobs/rocky_roller" | "compressedblocks:addiction/c6_sand_edition" | "create:root" | "beachparty:hammock" | "naturescompass:natures_compass_log" | "lootr:25loot" | "minecraft:story/upgrade_tools" | "candlelight:main/cook_everything_pot" | "exoticbirds:default/craft_backpack" | "compressedblocks:addiction/c5_gold_edition" | "alexsmobs:alexsmobs/root" | "compressedblocks:addiction/c8_cobblestone_edition" | "create:train_crash_backwards" | "repurposed_structures:monuments" | "comforts:hammock_gray" | "vinery:main/get_wine" | "alexsmobs:alexsmobs/tame_bald_eagle" | "compressedblocks:addiction/c9_cobblestone_edition" | "lootr:1barrel" | "corail_woodcutter:recipes/from_bamboo_mosaic" | "minecraft:adventure/walk_on_powder_snow_with_leather_boots" | "create:deployer" | "farmersdelight:main/master_chef" | "create:diving_suit_lava" | "alexsmobs:alexsmobs/straddler" | "bakery:main/cut_strawberry_cake" | "farmersdelight:main/use_cutting_board" | "create:arm_blaze_burner" | "create:cuckoo_clock" | "quark:ancient_apple_overlevel" | "botania:challenge/king_key" | "minecraft:husbandry/tactical_fishing" | "bakery:main/eat_sandwich" | "create:copper" | "cosmeticarmoursmod:agricultural_apprentice_achievement" | "mcwroofs:recipes/mangrove" | "mcwroofs:recipes/stone_bricks" | "create:anvil_plough" | "minecraft:adventure/salvage_sherd" | "mcwfences:recipes/sandstone" | "alexsmobs:alexsmobs/banana_slug" | "botania:main/elf_lexicon_pickup" | "compressedblocks:addiction/c7_gravel_edition" | "adorabuild_structures:end_structures" | "mcwroofs:recipes/gutters" | "beautify:progression/hanging_pot" | "create:stressometer" | "alexsmobs:alexsmobs/guster" | "beautify:botanist_workbench" | "farmersdelight:main/hit_raider_with_rotten_tomato" | "alexsmobs:alexsmobs/sunbird_blessing" | "nethervinery:warped_apple_press" | "create:potato_cannon" | "alexsmobs:alexsmobs/laviathan_spyglass" | "exoticbirds:default/craft_incubator" | "comforts:hammock_cyan" | "meadow:main/get_cheese" | "comforts:sleeping_bag_purple" | "minecraft:story/cure_zombie_villager" | "quark:get_all_corundum" | "corail_woodcutter:recipes/from_crimson_planks" | "farmersdelight:main/get_fd_seed" | "compressedblocks:compression/c0" | "compressedblocks:addiction/c6_netherite_edition" | "nethervinery:crimson_wine_rack_small" | "exoticbirds:default/hold_all_phoenix_eggs" | "quark:crawl_in_hollow_log" | "candlelight:main/place_tablesign" | "repurposed_structures:temples" | "compressedblocks:compression/c7" | "compressedblocks:compression/c8" | "compressedblocks:compression/c5" | "compressedblocks:compression/c6" | "compressedblocks:compression/c3" | "compressedblocks:compression/c4" | "compressedblocks:addiction/c8_gravel_edition" | "compressedblocks:compression/c1" | "adorabuild_structures:the_old_man_and_the_sea" | "compressedblocks:compression/c2" | "create:chute" | "alexsmobs:alexsmobs/skelewag_skull" | "chiselsandbits:chiselsandbits/make_tank" | "bakery:main/ride_a_boat_with_a_baker" | "compressedblocks:addiction/c5_cobblestone_edition" | "compressedblocks:compression/c9" | "biomesoplenty:biomesoplenty/root" | "comforts:sleeping_bag_green" | "bakery:main/place_bread_crate" | "mcwroofs:recipes/red_nether_bricks" | "compressedblocks:addiction/c4_iron_edition" | "create:train" | "mcwroofs:recipes/bamboo_planks" | "supplementaries:husbandry/soap" | "botania:challenge/loki_ring" | "minecraft:husbandry/feed_snifflet" | "create:chained_drain" | "nethervinery:warped_fermentation_barrel" | "quark:use_viaduct" | "create:drain" | "compressedblocks:addiction/c0_gold_edition" | "compressedblocks:addiction/c2_iron_edition" | "quark:get_bottled_cloud" | "comforts:hammock_light_blue" | "minecraft:end/find_end_city" | "minecraft:story/form_obsidian" | "compressedblocks:addiction/c1_sand_edition" | "nethervinery:warped_wine_rack_bid" | "compressedblocks:addiction/c4_netherite_edition" | "candlelight:main/write_letter" | "exoticbirds:default/craft_identifier" | "compressedblocks:compression/octuple_crate" | "create:haunted_bell" | "alexsmobs:alexsmobs/crocodile" | "cosmeticarmoursmod:cat_ears_achievement" | "minecraft:end/enter_end_gateway" | "botania:challenge/super_corporea_request" | "beachparty:table" | "candlelight:main/cook_tomato_mozzarella_salad" | "bakery:main/place_stove" | "refinedstorage:managing_patterns" | "candlelight:main/place_chocolate" | "minecraft:nether/obtain_blaze_rod" | "alexsmobs:alexsmobs/acacia_blossom" | "alexsmobs:alexsmobs/breed_froststalker" | "create:crushing_wheel" | "alexsmobs:alexsmobs/tame_elephant" | "botania:challenge/loki_ring_many" | "repurposed_structures:outposts" | "immersive_aircraft:misc/aircraftery" | "corail_woodcutter:recipes/root" | "toms_storage:unlock_dia_pearl" | "minecraft:nether/loot_bastion" | "botania:challenge/l20_shard_use" | "beachparty:cabinet" | "compressedblocks:addiction/c1_cobblestone_edition" | "bakery:main/root" | "brewery:main/root" | "minecraft:adventure/shoot_arrow" | "mcwfences:recipes/acacia" | "beachparty:palm_floorboard" | "nethervinery:crimson_grape_crate" | "mcwroofs:recipes/spruce_planks" | "minecraft:husbandry/silk_touch_nest" | "mcwroofs:recipes/andesite" | "quark:pathfinder_map_center" | "compressedblocks:addiction/c9_diamond_edition" | "alexsmobs:alexsmobs/emu_dodge" | "paraglider:pray_to_the_goddess" | "farmersdelight:main/place_organic_compost" | "farmersdelight:main/use_skillet" | "create:train_roadkill" | "refinedstorage:wireless_monitoring" | "refinedstorage:portable_storage" | "compressedblocks:addiction/c5_netherite_edition" | "beachparty:radio" | "farmersdelight:main/eat_nourishing_food" | "farmersdelight:main/place_campfire" | "comforts:sleeping_bag_magenta" | "compressedblocks:addiction/c8_sand_edition" | "compressedblocks:compression/triple_crate" | "alexsmobs:alexsmobs/lost_tentacle" | "minecraft:adventure/arbalistic" | "compressedblocks:addiction/c7_gold_edition" | "compressedblocks:addiction/c3_diamond_edition" | "alexsmobs:alexsmobs/farseer" | "minecraft:end/respawn_dragon" | "beachparty:palm_planks" | "comforts:hammock_green" | "minecraft:story/smelt_iron" | "create:brass_casing" | "repurposed_structures:strongholds" | "alexsmobs:alexsmobs/falconry_glove" | "repurposed_structures:root" | "compressedblocks:compression/giga_crate" | "bakery:main/get_yeast" | "botania:main/terrasteel_pickup_lexicon" | "create:hand_crank_000" | "create:wrench_goggles" | "repurposed_structures:igloos" | "herbalbrews:main/place_stove" | "bakery:main/spyglass_at_baker" | "minecraft:nether/charge_respawn_anchor" | "farmersdelight:main/harvest_straw" | "naturescompass:natures_compass" | "refinedstorage:drives" | "compressedblocks:addiction/c8_iron_edition" | "alexsmobs:alexsmobs/alligator_snapping_turtle" | "create:mechanical_mixer" | "quark:watcher_center" | "alexsmobs:alexsmobs/tame_mantis_shrimp" | "mcwroofs:recipes/bamboo_mosaic" | "compressedblocks:addiction/c6_cobblestone_edition" | "create:super_glue" | "create:mechanical_press" | "beautify:progression/light" | "botania:main/generating_flower" | "alexsmobs:alexsmobs/froststalker_helmet" | "comforts:sleeping_bag_black" | "create:cross_streams" | "minecraft:story/shiny_gear" | "brewery:main/drying_expertise" | "minecraft:end/elytra" | "brewery:main/get_beer_wheat" | "minecraft:husbandry/tadpole_in_a_bucket" | "brewery:main/get_beer_hops" | "supplementaries:husbandry/wrench" | "brewery:main/crop_collector" | "alexsmobs:alexsmobs/rocky_shell" | "compressedblocks:compression/crate" | "minecraft:husbandry/wax_off" | "vanillatweaks:unlock_all_recipes" | "lootr:1cart" | "candlelight:main/cook_lasagna" | "create:funnel" | "cosmeticarmoursmod:fallen_angel_halo_achievement" | "mcwfences:recipes/jungle" | "botania:challenge/odin_ring" | "corail_woodcutter:recipes/biomesoplenty/from_mahogany_planks" | "botania:main/mana_pool_pickup_lexicon" | "mcwfences:recipes/oak" | "mcwroofs:recipes/prismarine" | "alexsmobs:alexsmobs/mysterious_worm" | "refinedstorage:storing_fluids" | "alexsmobs:alexsmobs/skreecher" | "quark:overlevel_enchant" | "comforts:hammock_lime" | "corail_woodcutter:recipes/biomesoplenty/from_palm_planks" | "chiselsandbits:chiselsandbits/root" | "candlelight:main/place_cooking_pot" | "minecraft:adventure/summon_iron_golem" | "naturescompass:natures_compass_sapling" | "compressedblocks:addiction/c6_iron_edition" | "beachparty:palm_stairs" | "alexsmobs:alexsmobs/hummingbird_feeder" | "minecraft:adventure/avoid_vibration" | "beachparty:tiki_chair" | "create:contraption_actors" | "create:windmill" | "create:rose_quartz" | "repurposed_structures:city_nether" | "exoticbirds:default/obtain_phoenix_egg" | "comforts:sleeping_bag_red" | "botania:main/tiara_wings" | "betterdeserttemples:temple_clear" | "exoticbirds:default/root" | "biomesoplenty:biomesoplenty/all_biomes" | "herbalbrews:main/witching_time" | "alexsmobs:alexsmobs/maraca" | "minecraft:nether/return_to_sender" | "minecraft:adventure/sleep_in_bed" | "alexsmobs:alexsmobs/tame_grizzly_bear" | "beachparty:palm_boat" | "comforts:sleeping_bag_orange" | "alexsmobs:alexsmobs/tarantula_hawk" | "farmersdelight:main/place_feast" | "compressedblocks:compression/quintuple_crate" | "compressedblocks:addiction/c1_dirt_edition" | "herbalbrews:main/let_it_dry_3" | "compressedblocks:addiction/c0_dirt_edition" | "exoticbirds:default/shoot_gull" | "minecraft:end/dragon_breath" | "herbalbrews:main/let_it_dry_2" | "minecraft:adventure/root" | "repurposed_structures:mineshafts" | "alexsmobs:alexsmobs/tame_warped_toad" | "nethervinery:improved_nether_fizz" | "compressedblocks:addiction/root" | "alexsmobs:alexsmobs/shattered_dimensional_carver" | "minecraft:adventure/kill_all_mobs" | "beautify:progression/rope" | "refinedstorage:storing_externally" | "minecraft:story/enchant_item" | "compressedblocks:addiction/c9_iron_edition" | "minecraft:husbandry/obtain_sniffer_egg" | "trashcans:ultimate_trash_can" | "minecraft:adventure/voluntary_exile" | "mcwroofs:recipes/warped_planks" | "refinedstorage:pattern_creation" | "create:stressometer_maxed" | "refinedstorage:exporting" | "compressedblocks:addiction/c5_iron_edition" | "nethervinery:crimson_wine_rack_bid" | "comforts:hammock_blue" | "mcwroofs:recipes/red_sandstone" | "minecraft:story/follow_ender_eye" | "nethervinery:crimson_grape_seeds" | "beautify:progression/root" | "create:display_board_0" | "create:steam_whistle" | "alexsmobs:alexsmobs/breed_anteater" | "comforts:hammock_white" | "brewery:main/get_whiskey_cristelwalker" | "alexsmobs:alexsmobs/elephant_swag" | "minecraft:end/root" | "mcwroofs:recipes/terracotta" | "compressedblocks:addiction/c3_netherite_edition" | "alexsmobs:alexsmobs/froststalker_kill" | "quark:mine_fed_toretoise" | "paraglider:all_vessels" | "compressedblocks:addiction/c3_dirt_edition" | "bakery:main/get_everything" | "create:steam_engine" | "herbalbrews:main/place_cauldron" | "compressedblocks:addiction/c9_gold_edition" | "mcwfences:recipes/mud_brick" | "create:extendo_grip_dual" | "toms_storage:unlock_netherite" | "candlelight:main/find_rose" | "create:crafter_lazy_000" | "minecraft:adventure/spyglass_at_parrot" | "nethervinery:warped_grape_crate" | "beachparty:palm_torch" | "botania:main/pollidisiac_pickup" | "botania:main/mana_cart_craft" | "botania:challenge/gaia_guardian_no_armor" | "mcwfences:recipes/mangrove" | "create:copper_casing" | "alexsmobs:alexsmobs/rocky_chestplate" | "mcwfences:recipes/warped" | "create:mechanical_crafter" | "compressedblocks:addiction/c1_netherite_edition" | "botanypots:husbandry/get_basic_pot" | "meadow:main/place_cheese_form" | "herbalbrews:main/craft_everything" | "bakery:main/get_all_jams" | "minecraft:husbandry/obtain_netherite_hoe" | "create:foods" | "nethervinery:reinforced_crimson_planks" | "exoticbirds:default/catch_bird" | "alexsmobs:alexsmobs/strange_fish_finder" | "comforts:hammock_light_gray" | "alexsmobs:alexsmobs/skelewag" | "refinedstorage:viewing_items" | "alexsmobs:alexsmobs/stink_bottle" | "compressedblocks:addiction/c2_diamond_edition" | "quark:get_own_head" | "compressedblocks:addiction/c5_diamond_edition" | "corail_woodcutter:recipes/from_mangrove_planks" | "meadow:main/wool_collector" | "create:speed_controller" | "botania:main/gaia_guardian_kill" | "beautify:candelabras" | "brewery:main/get_saturated" | "compressedblocks:addiction/c8_diamond_edition" | "exoticbirds:default/log_bird" | "comforts:sleeping_bag_brown" | "beachparty:beach_chair" | "nethervinery:crimson_fermentation_barrel" | "alexsmobs:alexsmobs/dimensional_carver" | "minecraft:adventure/totem_of_undying" | "artifacts:amateur_archaeologist" | "repurposed_structures:mansions" | "adorabuild_structures:trial_by_fire" | "alexsmobs:alexsmobs/breed_hummingbird" | "beautify:blinds" | "brewery:main/get_whiskey_jojannik" | "create:spout" | "adorabuild_structures:overworld_structures" | "minecraft:adventure/kill_a_mob" | "lootr:root" | "create:millstone" | "beautify:iron_blinds" | "adorabuild_structures:tireless_legs" | "create:pipe_organ" | "alexsmobs:alexsmobs/seagull_steal" | "vanillatweaks:custom_villager_shops" | "nethervinery:warped_nether_bag" | "minecraft:husbandry/plant_any_sniffer_seed" | "cosmeticarmoursmod:potioneer_achievement" | "mcwroofs:recipes/cherry" | "compressedblocks:addiction/c9_netherite_edition" | "mcwfences:recipes/blackstone" | "refinedstorage:security" | "create:train_whistle" | "minecraft:adventure/adventuring_time" | "alexsmobs:alexsmobs/tame_gorilla" | "brewery:main/get_whiskey_hadarilabel" | "botania:challenge/tiny_potato_birthday" | "quark:apply_color_rune" | "alexsmobs:alexsmobs/falconry_hood" | "mcwroofs:recipes/mangrove_planks" | "exoticbirds:default/craft_birdcage" | "beachparty:palm_slab" | "mcwroofs:recipes/concrete" | "compressedblocks:compression/sextuple_crate" | "minecraft:husbandry/plant_seed" | "minecraft:nether/find_bastion" | "refinedstorage:autocrafting" | "minecraft:husbandry/axolotl_in_a_bucket" | "vinery:main/apple_press" | "chiselsandbits:chiselsandbits/find_chiselables" | "minecraft:husbandry/allay_deliver_cake_to_note_block" | "nethervinery:crimson_grapevine_pot" | "minecraft:adventure/spyglass_at_dragon" | "compressedblocks:addiction/c2_dirt_edition" | "alexsmobs:alexsmobs/sculk_boomer" | "farmersdelight:main/craft_knife" | "adorabuild_structures:well_well" | "compressedblocks:addiction/c7_iron_edition" | "vinery:main/crop_collector" | "botania:main/pure_daisy_pickup" | "minecraft:nether/ride_strider_in_overworld_lava" | "comforts:hammock_pink" | "create:crusher_maxed_0000" | "corail_woodcutter:recipes/biomesoplenty/from_redwood_planks" | "exoticbirds:default/tame_pigeon" | "minecraft:adventure/trade_at_world_height" | "corail_woodcutter:recipes/from_birch_planks" | "lootr:100loot" | "alexsmobs:alexsmobs/void_worm_kill" | "brewery:main/netherite_brewmaster" | "mcwroofs:recipes/thatch" | "comforts:hammock_brown" | "create:fan_processing" | "bakery:main/eat_pudding" | "create:water_supply" | "brewery:main/get_dried_corn" | "corail_woodcutter:recipes/from_oak_planks" | "botania:main/spawner_mover_use" | "adorabuild_structures:into_the_sky" | "minecraft:husbandry/wax_on" | "comforts:sleeping_bag_lime" | "minecraft:adventure/play_jukebox_in_meadows" | "exoticbirds:default/incubate_egg" | "exoticbirds:default/log_caged_bird" | "adorabuild_structures:echo_of_eternity" | "cosmeticarmoursmod:angel_halo_achievement" | "quark:get_all_blossom_saplings" | "mcwroofs:recipes/jungle" | "candlelight:main/cook_everything" | "beachparty:palm_fence_gate" | "minecraft:adventure/hero_of_the_village" | "mcwroofs:recipes/mud_bricks" | "botania:main/brew_pickup" | "corail_woodcutter:recipes/from_acacia_planks" | "repurposed_structures:witch_huts" | "minecraft:nether/obtain_ancient_debris" | "create:portable_storage_interface" | "botania:main/manaweave_armor_craft" | "comforts:hammock_yellow" | "create:conductor" | "vanillatweaks:armor_statues" | "explorerscompass:explorers_compass_cobweb" | "beachparty:palm_trapdoor" | "minecraft:nether/create_full_beacon" | "snowyspirit:husbandry/eat_gingerbread_golem" | "beautify:frames" | "armor_statues:crafting" | "minecraft:nether/summon_wither" | "create:compacting" | "botania:main/elf_portal_open" | "alexsmobs:alexsmobs/kangaroo" | "mcwfences:recipes/hedge" | "minecraft:husbandry/balanced_diet" | "compressedblocks:addiction/c2_stone_edition" | "beachparty:palm_fence" | "refinedstorage:detecting" | "compressedblocks:compression/mega_crate" | "minecraft:nether/fast_travel" | "botania:main/dandelifeon_pickup" | "alexsmobs:alexsmobs/tame_elephant_tusked" | "compressedblocks:addiction/c6_gold_edition" | "compressedblocks:addiction/c5_sand_edition" | "create:cart_pickup" | "create:potato_cannon_collide" | "refinedstorage:connecting" | "herbalbrews:main/root" | "compressedblocks:addiction/c4_gold_edition" | "meadow:main/spyglass_at_brown_bear" | "compressedblocks:addiction/c3_gravel_edition" | "beautify:trellis" | "create:burner" | "create:precision_mechanism" | "bakery:main/place_baker_station" | "beachparty:palm_button" | "mcwroofs:recipes/crimson_planks" | "vinery:main/wine_collector" | "quark:crab_in_a_bucket" | "create:hose_pulley" | "refinedstorage:storing_items" | "alexsmobs:alexsmobs/rainbow_glass" | "meadow:main/find_meadow" | "beachparty:palm_tall_torch" | "adorabuild_structures:the_power_of_knowledge" | "cosmeticarmoursmod:diamond_crown_achievement" | "vinery:main/get_apple_mash" | "brewery:main/get_dried_wheat" | "refinedstorage:root" | "comforts:sleeping_bag_blue" | "mcwroofs:recipes/acacia" | "refinedstorage:better_than_a_barrel" | "minecraft:adventure/read_power_of_chiseled_bookshelf" | "alexsmobs:alexsmobs/mantis_shrimp_bucket" | "adorabuild_structures:nether_structures" | "vinery:main/get_apple" | "repurposed_structures:ancient_cities" | "alexsmobs:alexsmobs/pocket_sand" | "bakery:main/get_misslilitu_biscuit" | "minecraft:husbandry/root" | "corail_woodcutter:recipes/biomesoplenty/from_fir_planks" | "mcwfences:recipes/nether" | "paraglider:paraglider" | "alexsmobs:alexsmobs/maned_wolf_apple" | "create:shifting_gears" | "meadow:main/get_cozy" | "alexsmobs:alexsmobs/hemolymph_blaster" | "create:train_casing_00" | "corail_woodcutter:recipes/from_spruce_planks" | "minecraft:nether/use_lodestone" | "nethervinery:improved_lava_fizz" | "minecraft:husbandry/safely_harvest_honey" | "minecraft:adventure/trade" | "candlelight:main/place_seeds" | "compressedblocks:addiction/c4_dirt_edition" | "compressedblocks:addiction/c8_dirt_edition" | "minecraft:adventure/spyglass_at_ghast" | "minecraft:nether/uneasy_alliance" | "minecraft:adventure/trim_with_any_armor_pattern" | "alexsmobs:alexsmobs/straddleboard" | "toms_storage:unlock_chest" | "refinedstorage:manipulating_disks" | "betterdeserttemples:root" | "compressedblocks:compression/double_crate" | "alexsmobs:alexsmobs/stink_ray" | "minecraft:story/mine_diamond" | "botania:main/tiny_potato_pet" | "cosmeticarmoursmod:cosmetic_armours_achievement" | "farmersdelight:main/eat_comfort_food" | "create:track_crafting_factory" | "create:belt" | "mcwroofs:recipes/diorite" | "compressedblocks:addiction/c2_sand_edition" | "compressedblocks:addiction/c1_gold_edition" | "compressedblocks:addiction/c1_iron_edition" | "repurposed_structures:ruined_portal_end" | "bakery:main/get_all_caked_goods" | "mcwroofs:recipes/nether_bricks" | "compressedblocks:addiction/c2_gravel_edition" | "brewery:main/kill_beer_elemental" | "compressedblocks:addiction/c4_stone_edition" | "alexsmobs:alexsmobs/spiked_scute" | "create:long_train" | "beachparty:palm_wood" | "vinery:main/get_juice" | "botania:main/terrasteel_weapon_craft" | "farmersdelight:main/plant_all_crops" | "botania:challenge/alf_portal_bread" | "alexsmobs:alexsmobs/stomp_leafcutter_anthill" | "compressedblocks:addiction/c7_cobblestone_edition" | "supplementaries:adventure/globe" | "meadow:main/get_salt" | "create:backtank" | "quark:influence" | "alexsmobs:alexsmobs/sopa_de_macaco" | "minecraft:husbandry/kill_axolotl_target" | "alexsmobs:alexsmobs/blood_sprayer" | "minecraft:nether/find_fortress" | "alexsmobs:alexsmobs/warped_mosco_kill" | "mcwroofs:recipes/cherry_planks" | "mcwroofs:recipes/cobblestone" | "botania:main/rune_pickup" | "botania:main/flower_pickup" | "botanypots:husbandry/get_hopper_pot" | "refinedstorage:monitoring" | "corail_woodcutter:recipes/from_dark_oak_planks" | "botania:main/mana_pool_pickup" | "candlelight:main/eat_tomato" | "minecraft:adventure/throw_trident" | "alexsmobs:alexsmobs/transmute_1000_items" | "mcwroofs:recipes/warped" | "alexsmobs:alexsmobs/soul_heart" | "comforts:sleeping_bag_yellow" | "create:lava_wheel_00000" | "candlelight:main/root" | "bakery:main/eat_bread" | "mcwfences:recipes/birch" | "bakery:main/get_all_baked_goods" | "alexsmobs:alexsmobs/bald_eagle_challenge" | "botania:challenge/pinkinator" | "beachparty:beach_towel" | "compressedblocks:addiction/c8_gold_edition" | "botania:main/enchanter_make" | "adorabuild_structures:release_them_all" | "compressedblocks:addiction/c9_sand_edition" | "compressedblocks:addiction/c0_stone_edition" | "mcwroofs:recipes/crimson" | "compressedblocks:addiction/c3_cobblestone_edition" | "adorabuild_structures:turtle_kingdom" | "brewery:main/get_dried_barley" | "alexsmobs:alexsmobs/tigers_blessing" | "alexsmobs:alexsmobs/endolocator" | "compressedblocks:addiction/c7_sand_edition" | "minecraft:story/root" | "compressedblocks:addiction/c1_gravel_edition" | "mcwroofs:recipes/dark_oak_planks" | "quark:redirect_beacon" | "minecraft:recipes/root" | "alexsmobs:alexsmobs/enderiophage_rocket" | "beachparty:lounge_chair" | "alexsmobs:alexsmobs/rainbow_jelly" | "paraglider:statues_bargain" | "alexsmobs:alexsmobs/breed_crocodile" | "botania:main/lexicon_use" | "corail_woodcutter:recipes/biomesoplenty/from_willow_planks" | "brewery:main/get_beer_barley" | "candlelight:main/place_typewriter" | "create:belt_funnel_kiss" | "minecraft:adventure/honey_block_slide" | "nethervinery:reinforced_warped_planks" | "minecraft:adventure/ol_betsy" | "beautify:progression/blinds" | "supplementaries:husbandry/sus_stew" | "candlelight:main/place_stove" | "botania:main/spark_craft" | "beautify:bookstack" | "repurposed_structures:ruins" | "corail_woodcutter:recipes/from_bamboo_planks" | "refinedstorage:importing" | "explorerscompass:explorers_compass" | "adorabuild_structures:like_a_feather" | "quark:shiba_help" | "nethervinery:crimson_wine_rack_mid" | "minecraft:nether/netherite_armor" | "create:linked_controller" | "create:arm_many_targets" | "alexsmobs:alexsmobs/ender_flu" | "vinery:main/root" | "farmersdelight:main/harvest_ropelogged_tomato" | "compressedblocks:compression/root" | "minecraft:story/enter_the_end" | "compressedblocks:addiction/c6_diamond_edition" | "minecraft:husbandry/breed_an_animal" | "alexsmobs:alexsmobs/underminer" | "mcwroofs:recipes/bricks" | "comforts:hammock_orange" | "botania:main/apothecary_pickup" | "snowyspirit:adventure/sled_with_wolf" | "compressedblocks:addiction/c0_gravel_edition" | "minecraft:husbandry/complete_catalogue" | "compressedblocks:addiction/c6_dirt_edition" | "candlelight:main/use_pan_on_tool_rack" | "compressedblocks:addiction/c3_iron_edition" | "mcwroofs:recipes/awning" | "compressedblocks:addiction/c0_diamond_edition" | "refinedstorage:construction" | "repurposed_structures:fortress_jungle" | "cosmeticarmoursmod:royalty_achievement" | "compressedblocks:addiction/c0_sand_edition";
    type RecipeId = "botania:metamorphic_fungal_stone_wall" | "farmersdelight:cutting/brown_mushroom_colony" | "chipped_express:stonecutting_chipped_brown_glazed_terracotta_pillar_sides_from_brown_glazed_terracotta" | "chipped_express:stonecutting_chipped_blank_blackstone_carving_from_blackstone" | "compressedblocks:shapeless_mega_crated_arrow" | "mcwfurnituresbop:willow_bookshelf" | "chipped_express:stonecutting_chipped_cut_blank_netherrack_from_netherrack" | "chipped_express:stonecutting_chipped_tiny_brick_bordered_ancient_debris_from_ancient_debris" | "compressedblocks:shapeless_septuple_crated_flint" | "candlelight:bamboo_drawer" | "chipped_express:stonecutting_chipped_coal_barrel_from_barrel" | "chipped_express:stonecutting_chipped_golden_melon_from_melon" | "chipped_express:stonecutting_chipped_thorned_iron_bars_from_iron_bars" | "mcwroofs:blue_terracotta_attic_roof" | "botanypots:botanypots/crafting/brown_concrete_botany_pot" | "compressedblocks:shapeless_giga_crated_torch" | "chipped_express:stonecutting_chipped_checkered_prismarine_tiles_from_prismarine" | "botania:mana_infusion/peony_to_dandelion" | "mcwlights:magenta_ceiling_light" | "pamhc2foodextended:applecideritem" | "chipped_express:stonecutting_chipped_rough_snow_block_from_snow_block" | "quark:building/crafting/glass/pink_framed_glass" | "moa_decor_garden_:florero_ttulipanblanco_1" | "mcwroofs:red_terracotta_lower_roof" | "pamhc2crops:stick_x4_cattail_x2" | "create:cut_granite_wall" | "supplementaries:compressedblocks/sign_post_c7_oak" | "minecraft:deepslate_brick_stairs_from_cobbled_deepslate_stonecutting" | "mcwtrpdoors:acacia_barrel_trapdoor" | "chipped_express:stonecutting_chipped_iron_bowl_lantern_from_lantern" | "create:oak_window" | "chipped_express:stonecutting_chipped_square_red_stained_glass_from_red_stained_glass" | "chipped_express:stonecutting_chipped_rectangle_light_gray_wool_from_light_gray_wool" | "quark:building/crafting/stonevariants/calcite_pillar" | "botanypots:quark/crop/azalea_hedge" | "compressedblocks:shaped_quadruple_crated_brown_mushroom" | "create:cut_diorite_from_stone_types_diorite_stonecutting" | "compressedblocks:shaped_c0_netherite_block" | "createdeco:short_red_brick_stairs_from_tiled_red_brick_stairs_stonecutting" | "chipped_express:stonecutting_chipped_simple_obsidian_pillar_from_obsidian" | "pamhc2foodextended:deviledeggitem" | "chipped_express:stonecutting_chipped_cross_haired_red_carpet_from_red_carpet" | "undergarden:gloomgourd_pie" | "supplementaries:sconce_nether_brass" | "chipped_express:stonecutting_chipped_cut_amethyst_block_column_from_amethyst_block" | "chipped_express:stonecutting_chipped_cracked_disordered_lapis_block_bricks_from_lapis_block" | "botania:orechid/deepslate_gold_ore" | "mcwwindows:oak_plank_pane_window" | "chipped_express:stonecutting_chipped_screen_jungle_door_from_jungle_door" | "railways:crafting/palettes/dyeing_1x/light_blue_iron_wrapped_locometal" | "quark:building/crafting/acacia_ladder" | "moa_decor_bath:trap_1" | "compressedblocks:shaped_octuple_crated_vine" | "compressedblocks:shaped_c7_end_stone_bricks" | "createdeco:andesite_catwalk_from_stonecutting" | "farmersdelight:cooked_chicken_cuts_from_smoking" | "moa_decor_cookery:paydemanzana_1" | "compressedblocks:shapeless_mega_crated_honeycomb" | "vinery:table" | "snowyspirit:compressedblocks/sled_c7_acacia" | "minecraft:map_extending" | "compressedblocks:shaped_c7_stripped_acacia_log" | "compressedblocks:shapeless_double_crated_beetroot" | "chipped_express:stonecutting_chipped_blackstone_scales_from_blackstone" | "chipped_express:stonecutting_chipped_d_sign_stripped_warped_stem_from_stripped_warped_stem" | "chipped_express:stonecutting_chipped_edged_andesite_bricks_from_andesite" | "minecraft:cut_copper_slab_from_copper_block_stonecutting" | "chipped_express:stonecutting_chipped_square_blue_stained_glass_pane_from_blue_stained_glass_pane" | "botanypots:minecraft/soil/netherrack" | "createdeco:copper_catwalk_stairs" | "candlelight:quartz_counter" | "create:compat/byg/milling/snowdrops" | "chipped_express:stonecutting_chipped_woved_orange_wool_from_orange_wool" | "chipped_express:stonecutting_chipped_square_pink_stained_glass_pane_from_pink_stained_glass_pane" | "compressedblocks:shapeless_double_crated_baked_potato" | "compressedblocks:shapeless_octuple_crated_sugar" | "meadow:umbra_carpet" | "compressedblocks:shapeless_quadruple_crated_jungle_sapling" | "corail_woodcutter:woodcutting/biomesoplenty/redwood_sign_from_redwood_logs" | "framedblocks:framed_stairs_rotate_to_framed_vertical_stairs" | "compressedblocks:shapeless_c5_waxed_weathered_copper" | "quark:world/crafting/woodsets/blossom/pressure_plate" | "chipped_express:stonecutting_chipped_wickered_pink_wool_from_pink_wool" | "compressedblocks:shapeless_giga_crated_dragon_breath" | "compressedblocks:shapeless_c4_diorite" | "chipped_express:stonecutting_chipped_smooth_smooth_stone_column_from_smooth_stone" | "luphieclutteredmod:luphie_darkwood_quilted_chair_recipe" | "compressedblocks:shaped_triple_crated_light_gray_dye" | "biomesoplenty:palm_fence" | "farmingforblockheads:chicken_nest" | "chipped_express:stonecutting_chipped_basket_woven_jungle_planks_from_jungle_planks" | "compressedblocks:shapeless_octuple_crated_black_dye" | "cosmeticarmoursmod:royal_tunic_white_2_pink" | "railways:sequenced_assembly/track_crimson_narrow" | "chipped_express:stonecutting_chipped_tiny_netherrack_bricks_from_netherrack" | "compressedblocks:shaped_octuple_crated_light_gray_dye" | "minecraft:green_stained_glass" | "create:cutting/crimson_hyphae" | "compressedblocks:shaped_c3_red_sandstone" | "compressedblocks:shaped_double_crated_stick" | "botania:marimorphosis/metamorphic_mountain_stone" | "chipped_express:stonecutting_chipped_vertical_stiped_blue_stained_glass_pane_from_blue_stained_glass_pane" | "vinery:wine_fermentation/aegis_wine" | "quark:building/crafting/vertslabs/nether_brick_vertical_slab" | "create:small_veridium_brick_slab_recycling" | "minecraft:sandstone_slab_from_sandstone_stonecutting" | "compressedblocks:shaped_c9_exposed_cut_copper" | "chipped_express:stonecutting_chipped_vertical_stiped_pink_stained_glass_pane_from_pink_stained_glass_pane" | "cosmeticarmoursmod:gilded_netherite_crown_rec" | "pamhc2foodextended:succotashitem" | "quark:building/crafting/lamps/red_crystal_lamp" | "chipped_express:stonecutting_chipped_borderless_bricks_pillar_from_bricks" | "chipped_express:stonecutting_chipped_cubed_yellow_carpet_from_yellow_carpet" | "compressedblocks:shapeless_c8_exposed_copper" | "quark:world/crafting/slabs/myalite_slab" | "createdeco:long_red_brick_stairs_from_tiled_red_bricks_stonecutting" | "createdeco:purple_shipping_container_from_dyeing_vaults" | "createdeco:long_blue_brick_stairs_from_long_blue_bricks_stonecutting" | "lootbags:clothing_collection/brewfest_outfit_completion" | "corail_woodcutter:woodcutting/biomesoplenty/dead_sign_from_dead_planks" | "chipped_express:stonecutting_chipped_brown_mushroom_bushel_from_brown_mushroom" | "botania:blaze_quartz" | "playdate:toy_train" | "minecraft:cut_sandstone_slab" | "luphieclutteredmod:stripped_green_wood_recipe" | "quark:world/crafting/woodsets/ancient/chest" | "railways:crafting/palettes/dyeing_1x/gray_locometal_pillar" | "supplementaries:candle_holders/candle_holder_white_dye" | "refinedstorage:coloring_recipes/fluid_grid" | "compressedblocks:shapeless_quintuple_crated_allium" | "handcrafted:jungle_cupboard" | "mcwlights:chain_lantern" | "chipped_express:stonecutting_chipped_edged_calcite_bricks_from_calcite" | "compressedblocks:shapeless_triple_crated_cookie" | "chipped_express:stonecutting_chipped_spiraled_redstone_block_from_redstone_block" | "createdeco:verdant_brick_slab" | "corail_woodcutter:woodcutting/biomesoplenty/dead_fence_gate_from_dead_logs" | "compressedblocks:shaped_c1_warped_nylium" | "snowyspirit:compressedblocks/sled_c5_dark_oak" | "minecraft:mojang_banner_pattern" | "cosmeticarmoursmod:white_skirt_2_black" | "mcwroofs:bamboo_attic_roof" | "pamhc2foodextended:saucedlambkebabitem" | "moa_decor_bath:lroblesc_1" | "chipped_express:stonecutting_chipped_acacia_torch_from_torch" | "chipped_express:stonecutting_chipped_redstone_block_scales_from_redstone_block" | "chipped_express:stonecutting_chipped_plated_netherite_block_from_netherite_block" | "pamhc2foodextended:pearjellytoastitem" | "cookingforblockheads:light_gray_kitchen_floor" | "meadow:mossy_cobbled_limestone_from_vine" | "pamhc2foodextended:blackberryyogurtitem" | "aquaculture:gold_nugget_from_smelting" | "minecraft:dye_green_bed" | "pamhc2foodextended:roastpotatoesitem" | "chipped_express:stonecutting_chipped_thick_inlayed_coal_block_from_coal_block" | "bloomingnature:ebony_pressure_plate" | "chipped_express:stonecutting_chipped_vined_dark_oak_trapdoor_from_dark_oak_trapdoor" | "create:crafting/kinetics/cyan_seat_from_other_seat" | "macawsroofsbop:fir_planks_upper_lower_roof" | "create:cutting/compat/biomesoplenty/stripped_umbran_log" | "compressedblocks:shapeless_septuple_crated_melon_seeds" | "mcwfurnitures:birch_desk" | "mcwfurnitures:stripped_cherry_cupboard_counter" | "compressedblocks:shaped_double_crated_lantern" | "chipped_express:stonecutting_chipped_arched_leaded_glass_pillar_from_glass" | "compressedblocks:shapeless_double_crated_cookie" | "chipped_express:stonecutting_chipped_crossed_birch_planks_from_birch_planks" | "luphieclutteredmod:yellow_tarrey_town_planter_recipe" | "botania:petal_apothecary/manastar" | "compressedblocks:shapeless_mega_crated_allium" | "quark:building/stonecutting/stonevariants/chiseled_jasper_bricks_stonecutter" | "lootbags:clothing_collection/christmas_elves_completion" | "corail_woodcutter:woodcutting/dark_oak_pressure_plate_from_dark_oak_logs" | "handcrafted:birch_counter" | "moa_decor_holidays:banderines_verde_lima_1" | "compressedblocks:shaped_double_crated_magma_cream" | "createdeco:cracked_umber_brick_slab" | "farmersdelight:cutting/smoked_ham" | "pamhc2foodcore:chocolateicecreamitem" | "compressedblocks:shapeless_c5_netherrack" | "quark:building/crafting/vertslabs/red_sandstone_vertical_slab_revert" | "aether:cutting/skyroot_wood" | "moa_decor_science:matrazbnegro_1" | "compressedblocks:shapeless_triple_crated_blaze_rod" | "chipped_express:stonecutting_chipped_massive_basalt_bricks_from_basalt" | "chipped_express:stonecutting_chipped_flat_netherrack_tiles_from_netherrack" | "refinedstorage:coloring_recipes/brown_pattern_grid" | "compressedblocks:shapeless_quintuple_crated_rotten_flesh" | "refinedstorage:coloring_recipes/yellow_fluid_grid" | "botanypots:farming_crossing/crop/pamhc2treesspiderweb_sapling" | "mcwdoors:cherry_japanese_door" | "mcwfurnitures:stripped_spruce_striped_chair" | "chipped_express:stonecutting_chipped_fortified_birch_door_from_birch_door" | "botania:orechid_ignem/nether_quartz_ore" | "conditional:bakery/strawberry" | "cosmeticarmoursmod:purple_plaid_2_skirt" | "compressedblocks:shaped_c5_red_nether_bricks" | "chipped_express:stonecutting_chipped_cut_light_blue_terracotta_from_light_blue_terracotta" | "chipped_express:stonecutting_chipped_tiled_purple_wool_from_purple_wool" | "aquaculture:neptunium_ingot_from_blasting" | "quark:building/stonecutting/stairs/red_shingles_stairs_stonecutter" | "botania:mana_infusion/ochre_froglight_to_verdant_froglight" | "botanypots:pamhc2crops/crop/garlic" | "compressedblocks:shapeless_quadruple_crated_experience_bottle" | "compressedblocks:shapeless_c2_oxidized_copper" | "mcwroofs:cyan_terracotta_roof" | "compressedblocks:shaped_quadruple_crated_cooked_porkchop" | "luphieclutteredmod:luphie_pastel_block_bookshelf_recipe" | "beachparty:rubber_ring_pink" | "compressedblocks:shapeless_c1_stripped_mangrove_log" | "compressedblocks:shaped_c2_diorite" | "handcrafted:jungle_bench" | "railways:crafting/palettes/dyeing_1x/brown_copper_wrapped_locometal_boiler" | "quark:building/crafting/vertslabs/polished_limestone_vertical_slab_revert" | "minecraft:waxed_weathered_cut_copper_stairs_from_waxed_weathered_cut_copper_stonecutting" | "moa_decor_art:violin_1" | "chipped_express:stonecutting_chipped_vertical_disordered_purpur_block_bricks_from_purpur_block" | "conditional:bloomingnature/wood_cutter/aspen_fencegate_woodcutter" | "framedblocks:framing_saw/framed_divided_panel_horizontal" | "moa_decor_cookery:molcajete_1" | "createdeco:mossy_pearl_bricks_from_moss_block" | "quark:building/stonecutting/stonevariants/andesite_bricks_vertical_slab_rough_stonecutting" | "botania:terrasteel_leggings" | "moa_decor_toys:conejodorado_1" | "compressedblocks:shaped_giga_crated_blue_dye" | "mcwroofs:yellow_terracotta_steep_roof" | "chipped_express:stonecutting_chipped_vertically_railed_warped_planks_from_warped_planks" | "botania:incense_stick" | "createdeco:cracked_dusk_brick_stairs_from_cracked_dusk_bricks_stonecutting" | "create:cutting/compat/byg/green_enchanted_log" | "chipped_express:stonecutting_chipped_duh_redstone_block_from_redstone_block" | "botania:lens_bounce" | "railways:crafting/palettes/dyeing_1x/light_gray_brass_wrapped_locometal_boiler" | "refinedstorage:coloring_recipes/orange_wireless_transmitter" | "botania:petal_apothecary/dandelifeon" | "chipped_express:stonecutting_chipped_classic_windowed_warped_trapdoor_from_warped_trapdoor" | "chipped_express:stonecutting_chipped_patched_green_wool_from_green_wool" | "quark:building/stonecutting/vertslabs/polished_diorite_vertical_slab2_stonecutter" | "create:crushing/raw_lead_ore" | "compressedblocks:shaped_quintuple_crated_orange_tulip" | "chipped_express:stonecutting_chipped_smoothed_double_inlayed_blackstone_from_blackstone" | "compressedblocks:shaped_c9_smooth_red_sandstone" | "compressedblocks:shaped_crated_blaze_powder" | "compressedblocks:shapeless_sextuple_crated_item_frame" | "create:item_application/brass_casing_from_log" | "compressedblocks:shapeless_c3_stone" | "chipped_express:stonecutting_chipped_dark_freckled_red_mushroom_block_from_red_mushroom_block" | "compressedblocks:shaped_septuple_crated_lead" | "railways:crafting/palettes/dyeing_1x/pink_locometal_smokebox" | "create:cutting/compat/tconstruct/greenheart_log" | "botania:detector_light_relay" | "pamhc2foodextended:chocovoxelsitem" | "corail_woodcutter:woodcutting/biomesoplenty/umbran_stairs_from_umbran_planks" | "pamhc2foodextended:breadfruitjellyitem" | "compressedblocks:shaped_quintuple_crated_poppy" | "compressedblocks:shapeless_c5_iron_ore" | "cosmeticarmoursmod:fishermans_trousers_rec" | "moa_decor_holidays:calabaza_pillager_1" | "corail_woodcutter:woodcutting/tropicraft/mangrove_fence_from_mangrove_planks" | "chipped_express:stonecutting_chipped_distorted_oak_trapdoor_from_oak_trapdoor" | "railways:crafting/palettes/dyeing_1x/pink_riveted_locometal" | "mcwbridges:stonecutter_deepslate_tile_bridge" | "botania:stonecutting/dark_quartz_to_dark_quartz_pillar" | "alexsdelight:smelting/singular_cooked_moose_rib_campfire" | "create:crafting/kinetics/chute" | "pamhc2foodextended:honeysoyribsitem" | "refinedstorage:coloring_recipes/purple_crafter_manager" | "mcwwindows:dark_prismarine_window2" | "quark:building/crafting/yellow_blossom_hedge" | "chipped_express:stonecutting_chipped_cracked_flat_obsidian_tiles_from_obsidian" | "create:brass_scaffolding_from_ingots_brass_stonecutting" | "chipped_express:stonecutting_chipped_tiled_bordered_tuff_from_tuff" | "compressedblocks:shapeless_giga_crated_egg" | "chipped_express:stonecutting_chipped_brick_bordered_clay_from_clay" | "compressedblocks:shapeless_triple_crated_ender_pearl" | "compressedblocks:shapeless_c6_sand" | "quark:building/crafting/vertslabs/granite_vertical_slab" | "mcwroofs:oak_roof" | "compressedblocks:shapeless_c9_acacia_log" | "compressedblocks:shaped_c2_bamboo_mosaic" | "chipped_express:stonecutting_chipped_fine_raw_iron_block_pillar_from_raw_iron_block" | "create:polished_cut_asurine_stairs" | "handcrafted:blue_cushion" | "pamhc2foodextended:cookedtofishitem_smoker" | "compressedblocks:shaped_septuple_crated_chicken" | "compressedblocks:shapeless_c9_chiseled_red_sandstone" | "mcwfurnitures:jungle_drawer" | "quark:building/stonecutting/stonevariants/granite_bricks_stairs_rough_stonecutting" | "create:cutting/compat/blue_skies/stripped_maple_log" | "compressedblocks:shaped_crated_ghast_tear" | "create:smoking/bread" | "mcwroofs:warped_planks_upper_lower_roof" | "moa_decor_holidays:trebollargo_1" | "createdeco:dusk_brick_stairs_from_tiled_dusk_brick_stairs_stonecutting" | "chipped_express:stonecutting_chipped_wide_eyed_carved_pumpkin_from_carved_pumpkin" | "create:compat/byg/milling/winter_cyclamen" | "chipped_express:stonecutting_chipped_edged_stone_bricks_from_stone" | "chipped_express:stonecutting_chipped_heavy_cherry_door_from_cherry_door" | "framedblocks:framed_flat_ext_inner_slope_panel_corner" | "chipped_express:stonecutting_chipped_secret_spruce_door_from_spruce_door" | "corail_woodcutter:woodcutting/biomesoplenty/umbran_fence_gate_from_umbran_logs" | "chipped_express:stonecutting_chipped_tiled_blue_ice_column_from_blue_ice" | "pamhc2foodcore:friesitem" | "minecraft:orange_stained_glass_pane_from_glass_pane" | "delightful:knives/osmium_knife" | "mcwbridges:balustrade_prismarine_bricks_bridge" | "chipped_express:stonecutting_chipped_knotted_stripped_oak_log_from_stripped_oak_log" | "pamhc2foodextended:juniperberryjuiceitem" | "compressedblocks:shapeless_c2_gold_block" | "sophisticatedstorage:storage_output" | "chipped_express:stonecutting_chipped_tiled_gray_carpet_from_gray_carpet" | "chipped_express:stonecutting_chipped_golden_barred_crimson_trapdoor_from_crimson_trapdoor" | "chipped_express:stonecutting_chipped_tiled_packed_ice_column_from_packed_ice" | "botania:toggle_light_relay" | "quark:building/crafting/walls/calcite_wall" | "chipped_express:stonecutting_chipped_flat_ice_tiles_from_ice" | "botanypots:botanypots/crafting/orange_glazed_terracotta_compact_hopper_botany_pot" | "minecraft:iron_ingot_from_nuggets" | "create:cutting/compat/byg/stripped_lament_log" | "compressedblocks:shaped_mega_crated_sculk_vein" | "chipped_express:stonecutting_chipped_fancy_chiseled_mud_from_mud" | "chipped_express:stonecutting_chipped_meming_soul_sand_from_soul_sand" | "railways:crafting/palettes/dyeing_8x/magenta_brass_wrapped_locometal_boiler" | "corail_woodcutter:woodcutting/tropicraft/mahogany_door_from_mahogany_planks" | "chipped_express:stonecutting_chipped_warped_torch_from_torch" | "botania:dreamwood_fence" | "mcwroofs:green_concrete_roof" | "minecraft:redstone_torch" | "supplementaries:rope_arrow_add" | "compressedblocks:shapeless_quintuple_crated_orange_carpet" | "chipped_express:stonecutting_chipped_hexagonical_red_terracotta_from_red_terracotta" | "pamhc2foodcore:tool_grinder" | "botanypots:minecraft/crop/sugar_cane" | "conditional:regions_unexplored/wood_cutter/eucalyptus_sign_woodcutter" | "exoticbirds:bone_meal_from_eggshell" | "compressedblocks:shapeless_sextuple_crated_feather" | "chipped_express:stonecutting_chipped_cut_pink_terracotta_from_pink_terracotta" | "playershops:oak_player_shop" | "moa_decor_holidays:bota_namarilla_1" | "create:crafting/kinetics/deployer" | "createdeco:short_red_brick_slab_from_tiled_red_bricks_stonecutting" | "delightful:knives/smelting/bone/bone_meal_from_smelting_axe" | "farmersdelight:basket" | "refinedstorage:detector" | "conditional:regions_unexplored/wood_cutter/magnolia_trapdoor_woodcutter" | "chipped_express:stonecutting_chipped_ornate_basalt_pillar_from_basalt" | "create:crafting/materials/andesite_alloy" | "compressedblocks:shapeless_c6_smooth_sandstone" | "pamhc2foodcore:melonjuiceitem" | "chipped_express:stonecutting_chipped_vertical_cut_obsidian_from_obsidian" | "compressedblocks:shapeless_c6_cut_red_sandstone" | "villagersplus:oceanographer_table" | "botania:tiny_planet_block" | "pamhc2crops:cottonseeditem" | "bloomingnature:brown_mushroom_brick_stairs_from_brown_mushroom_bricks_stonecutting" | "chipped_express:stonecutting_chipped_reinforced_gold_block_from_gold_block" | "compressedblocks:shaped_giga_crated_powered_rail" | "chipped_express:stonecutting_chipped_loded_lapis_block_from_lapis_block" | "minecraft:armor_stand" | "compressedblocks:shaped_sextuple_crated_azure_bluet" | "compressedblocks:shaped_mega_crated_fermented_spider_eye" | "botania:petal_green_double" | "meadow:wood_cutter/spruce/spruce_sign_woodcutter" | "compressedblocks:shapeless_c0_weathered_copper" | "chipped_express:stonecutting_chipped_railed_brown_concrete_from_brown_concrete" | "minecraft:pink_stained_glass_pane" | "compressedblocks:shapeless_giga_crated_nether_star" | "create:compat/silentsgems/crushing/morganite_ore" | "pamhc2foodcore:glowberryjuiceitem" | "alexsdelight:smelting/catfish_slice_cook" | "minecraft:blue_dye_from_cornflower" | "compressedblocks:shapeless_octuple_crated_pink_dye" | "quark:building/crafting/vertslabs/granite_bricks_vertical_slab_revert" | "create_confectionery:hot_chocolate_recipe" | "pamhc2crops:roastedgarlicitem_forge" | "mcwbridges:dry_bamboo_bridge_stair_recycle" | "compressedblocks:shapeless_triple_crated_brown_carpet" | "chipped_express:stonecutting_chipped_crafted_green_carpet_from_green_carpet" | "mcwfurnituresbop:magic_covered_desk" | "alexsmobs:banner_pattern_australia_1" | "candlelight:quartz_kitchen_sink" | "chipped_express:stonecutting_chipped_hexagonical_brown_terracotta_from_brown_terracotta" | "delightful:integration/biomesoplenty/lavender_tea" | "alexsmobs:banner_pattern_australia_0" | "create:cutting/compat/biomesoplenty/redwood_wood" | "createdeco:long_dean_brick_slab_from_long_dean_bricks_stonecutting" | "railways:sequenced_assembly/track_twilightforest_sortingwood_wide" | "compressedblocks:shaped_c4_mangrove_planks" | "corail_woodcutter:woodcutting/spruce_slab_from_spruce_logs" | "mcwroofs:gutter_middle_pink" | "railways:sequenced_assembly/track_quark_azalea_wide" | "mcwfurnituresbop:hellbark_stool_chair" | "pamhc2crops:roastedleekitem_smoker" | "mcwwindows:gray_mosaic_glass_pane" | "aquaculturedelight:cooking/poor_fisher_chowder" | "chipped_express:stonecutting_chipped_brick_bordered_ancient_debris_from_ancient_debris" | "chipped_express:stonecutting_chipped_edged_redstone_block_bricks_from_redstone_block" | "create:crimsite_pillar_from_stone_types_crimsite_stonecutting" | "botanypots:minecraft/soil/deepslate_gold_ore" | "comforts:sleeping_bag_to_yellow" | "chipped_express:stonecutting_chipped_vertical_cut_stone_from_stone" | "framedblocks:framed_hanging_sign" | "cosmeticarmoursmod:lime_skirt_2_plaid" | "mcwfurnitures:stripped_birch_double_drawer_counter" | "handcrafted:jungle_pillar_trim" | "biomesoplenty:willow_door" | "botania:red_string_fertilizer" | "conditional:regions_unexplored/wood_cutter/brimwood_pp_woodcutter" | "chipped_express:stonecutting_chipped_fancy_cherry_trapdoor_from_cherry_trapdoor" | "cosmeticarmoursmod:orange_skirt_2_white" | "quark:building/stonecutting/vertslabs/polished_jasper_vertical_slab_stonecutter2" | "minecraft:green_bed" | "aether_redux:cutting/fieldsprout_log" | "bakery:pot_cooking/chocolate_jam" | "mcwbridges:dark_oak_rail_bridge" | "chipped_express:stonecutting_chipped_paved_white_glazed_terracotta_from_white_glazed_terracotta" | "minecraft:red_sandstone_slab_from_red_sandstone_stonecutting" | "chipped_express:stonecutting_chipped_cross_haired_pink_wool_from_pink_wool" | "vinery:spruce_lattice" | "chipped_express:stonecutting_chipped_thick_inlayed_sea_lantern_from_sea_lantern" | "vinery:white_grape_crate" | "moa_decor_bath:bjunglasc_1" | "chipped_express:stonecutting_chipped_thick_inlayed_lodestone_from_lodestone" | "botanypots:minecraft/soil/dried_kelp" | "botania:stonecutting/metamorphic_mountain_cobblestone_to_metamorphic_mountain_cobblestone_slab" | "lootbags:common_decorations/toys_completion" | "minecraft:prismarine_brick_slab_from_prismarine_stonecutting" | "railways:crafting/palettes/dyeing_8x/orange_flat_riveted_locometal" | "framedblocks:framing_saw/framed_fancy_detector_rail_slope" | "compressedblocks:shaped_crated_rose_bush" | "chipped_express:stonecutting_chipped_heavy_crimson_door_from_crimson_door" | "chipped_express:stonecutting_chipped_rounded_red_nether_bricks_bricks_from_red_nether_bricks" | "minecraft:waxed_oxidized_cut_copper_stairs_from_waxed_oxidized_cut_copper_stonecutting" | "candlelight:basalt_stove" | "minecraft:gray_banner" | "chipped_express:stonecutting_chipped_warped_fungus_bulb_from_warped_fungus" | "compressedblocks:shapeless_octuple_crated_end_crystal" | "chipped_express:stonecutting_chipped_panelled_mud_from_mud" | "pamhc2trees:roastedwalnuttitem_smoker" | "refinedstorage:coloring_recipes/red_relay" | "botania:slab_recombine/metamorphic_mountain_cobblestone" | "chipped_express:stonecutting_chipped_stacked_ancient_debris_bricks_from_ancient_debris" | "create:compat/ae2/milling/certus_quartz" | "mcwfurnitures:mangrove_double_wardrobe" | "macawsroofsbop:willow_attic_roof" | "pamhc2crops:roastedleekitem_forge" | "railways:crafting/palettes/dyeing_8x/purple_plated_locometal" | "framedblocks:framing_saw/framed_iron_trapdoor" | "pamhc2crops:jicamaseeditem" | "botania:chiseled_metamorphic_mesa_bricks" | "pamhc2foodextended:lemonlimesodaitem" | "pamhc2foodextended:manjuuitem" | "chipped_express:stonecutting_chipped_mossy_dried_kelp_block_from_dried_kelp_block" | "compressedblocks:shaped_c4_stripped_spruce_log" | "railways:stonecutting/palettes/cycling/blue_slashed_locometal" | "chipped_express:stonecutting_chipped_overgrown_autumnkin_from_pumpkin" | "quark:building/crafting/vertslabs/raw_copper_bricks_vertical_slab_revert" | "compressedblocks:shapeless_giga_crated_jungle_sapling" | "botania:mana_infusion/cod_to_salmon" | "compressedblocks:shaped_c6_smooth_sandstone" | "quark:building/crafting/vertslabs/cut_red_sandstone_vertical_slab_revert" | "farmersdelight:cooking/dumplings" | "quark:building/crafting/vertslabs/waxed_weathered_cut_copper_vertical_slab" | "moa_decor_toys:ovejaamarilla_1" | "compressedblocks:shapeless_quintuple_crated_glow_berries" | "createdeco:mossy_umber_brick_slab_from_mossy_umber_bricks_stonecutting" | "conditional:regions_unexplored/wood_cutter/palm_trapdoor_woodcutter" | "compressedblocks:shaped_crated_azure_bluet" | "pamhc2foodextended:phoitem" | "moa_decor_cookery:bandejadegalletas_1" | "cosmeticarmoursmod:white_skirt_2_magenta" | "compressedblocks:shaped_octuple_crated_book" | "refinedstorage:pattern_grid/blue_pattern_grid" | "moa_decor_cookery:betabelcortado_1" | "botanypots:botanypots/crafting/magenta_concrete_botany_pot" | "mcwfurnituresbop:mahogany_coffee_table" | "macawsroofsbop:dead_steep_roof" | "chipped_express:stonecutting_chipped_glass_verdant_froglight_from_verdant_froglight" | "chipped_express:stonecutting_chipped_vertical_disordered_redstone_block_bricks_from_redstone_block" | "bloomingnature:mushroom_brick_slab_from_mushroom_bricks_stonecutting" | "botania:terrasteel_boots" | "gemsnjewels:garnet" | "compressedblocks:shaped_c5_gold_ore" | "botanypots:farming_crossing/crop/pamhc2treesdate_sapling" | "compressedblocks:shapeless_c9_exposed_copper" | "luphieclutteredmod:bush_recipe" | "quark:building/crafting/azalea_hedge" | "quark:building/crafting/slabs/dripstone_bricks_slab" | "chipped_express:stonecutting_chipped_pressed_mangrove_door_from_mangrove_door" | "chipped_express:stonecutting_chipped_woved_yellow_wool_from_yellow_wool" | "botania:metamorphic_plains_cobblestone_wall" | "compressedblocks:shaped_octuple_crated_bone" | "chipped_express:stonecutting_chipped_reinforced_bone_block_from_bone_block" | "botania:petal_apothecary/pollidisiac" | "sophisticatedstorage:storage_dye" | "copycats:crafting/copycat_panel_from_half_panels" | "moa_decor_lights:basefarol_n_1" | "mcwfences:prismarine_pillar_wall" | "candlelight:mozzarella" | "farmersdelight:book_from_canvas" | "mcwwindows:hammer" | "pamhc2foodextended:lycheejellysandwichitem" | "createaddition:rolling/aluminum_plate" | "mcwdoors:jungle_japanese2_door" | "botania:pattern_2_1" | "minecraft:smooth_red_sandstone" | "framedblocks:framed_fence_gate" | "botania:pattern_2_2" | "botania:pattern_2_3" | "chipped_express:stonecutting_chipped_angry_andesite_from_andesite" | "mcwfurnitures:crimson_modern_chair" | "moa_decor_toys:vendedorambulante_1" | "chipped_express:stonecutting_chipped_massive_purpur_block_bricks_from_purpur_block" | "chipped_express:stonecutting_chipped_overgrown_birch_door_from_birch_door" | "mcwroofs:blackstone_lower_roof" | "chipped_express:stonecutting_chipped_cut_prismarine_column_from_prismarine" | "railways:crafting/palettes/dyeing_8x/cyan_iron_wrapped_locometal" | "compressedblocks:shapeless_c7_end_stone_bricks" | "chipped_express:stonecutting_chipped_crafted_pink_wool_from_pink_wool" | "compressedblocks:shapeless_double_crated_end_crystal" | "mcwfurnitures:acacia_counter" | "chipped_express:stonecutting_chipped_simple_diorite_pillar_from_diorite" | "chipped_express:stonecutting_chipped_pegged_light_gray_concrete_from_light_gray_concrete" | "chipped_express:stonecutting_chipped_unamused_redstone_block_from_redstone_block" | "chipped_express:stonecutting_chipped_weathered_stone_from_stone" | "chipped_express:stonecutting_chipped_engraved_emerald_block_from_emerald_block" | "chipped_express:stonecutting_chipped_square_black_stained_glass_from_black_stained_glass" | "compressedblocks:shapeless_mega_crated_melon_seeds" | "mcwfurnitures:oak_double_wardrobe" | "pamhc2foodextended:sunflowerbroccolisaladitem" | "framedblocks:framing_saw/framed_pane" | "chipped_express:stonecutting_chipped_rectangle_yellow_wool_from_yellow_wool" | "chipped_express:stonecutting_chipped_wicked_brown_mushroom_from_brown_mushroom" | "railways:sequenced_assembly/track_biomesoplenty_redwood" | "pamhc2foodextended:cantaloupeyogurtitem" | "corail_woodcutter:woodcutting/dark_oak_sign_from_dark_oak_logs" | "create:compat/ae2/mixing/fluix_crystal" | "create:milling/azure_bluet" | "moa_decor_toys:gatotabby_1" | "framedblocks:framing_saw/framed_powered_rail_slope" | "compressedblocks:shapeless_giga_crated_powered_rail" | "compressedblocks:shapeless_c0_oak_planks" | "createdeco:black_placard_from_dyeing" | "chipped_express:stonecutting_chipped_harsh_quilted_lime_carpet_from_lime_carpet" | "compressedblocks:shaped_septuple_crated_item_frame" | "chipped_express:stonecutting_chipped_woven_acacia_trapdoor_from_acacia_trapdoor" | "minecraft:black_concrete_powder" | "compressedblocks:shapeless_c4_exposed_cut_copper" | "biomesoplenty:dead_stairs" | "botania:petal_brown" | "botanypots:farming_crossing/crop/pamhc2treesplum_sapling" | "chipped_express:stonecutting_chipped_patched_yellow_wool_from_yellow_wool" | "compressedblocks:shaped_c8_jungle_planks" | "chipped_express:stonecutting_chipped_edged_coal_block_bricks_from_coal_block" | "pamhc2foodextended:gritsitem" | "moa_decor_art:esculturavenusdemilo_1" | "chipped_express:stonecutting_chipped_decorated_brown_terracotta_from_brown_terracotta" | "mcwbridges:acacia_rope_bridge_stair" | "railways:sequenced_assembly/track_natures_spirit_willow_wide" | "chipped_express:stonecutting_chipped_lime_terracotta_bricks_from_lime_terracotta" | "minecraft:dye_red_wool" | "mcwroofs:nether_bricks_lower_roof" | "compressedblocks:shapeless_crated_blue_orchid" | "compressedblocks:shaped_crated_paper" | "chipped_express:stonecutting_chipped_thick_inlayed_crying_obsidian_from_crying_obsidian" | "aquaculture:stone_fillet_knife" | "create:compat/environmental/pressing/podzol_path" | "moa_decor_science:biombommorado_1" | "chipped_express:stonecutting_chipped_minimized_orange_glazed_terracotta_from_orange_glazed_terracotta" | "compressedblocks:shapeless_mega_crated_light_gray_dye" | "chipped_express:stonecutting_chipped_shrunken_light_blue_glazed_terracotta_from_light_blue_glazed_terracotta" | "railways:crafting/palettes/dyeing_8x/light_blue_copper_wrapped_locometal_boiler" | "sophisticatedstorage:gold_to_netherite_tier_upgrade" | "minecraft:polished_diorite_slab_from_polished_diorite_stonecutting" | "chipped_express:stonecutting_chipped_brick_bond_oak_planks_from_oak_planks" | "quark:building/crafting/blossom_post" | "quark:building/crafting/blackstone_bricks" | "chipped_express:stonecutting_chipped_green_redstone_torch_from_redstone_torch" | "moa_decor_toys:gatoragdoll_1" | "moa_decor_cookery:pavo_1" | "chipped_express:stonecutting_chipped_trodden_quartz_block_from_quartz_block" | "chipped_express:stonecutting_chipped_traditional_carved_pumpkin_from_carved_pumpkin" | "vinery:banner_from_smithing_table" | "moa_decor_garden_:florero_tflorantorcha_1" | "mcwfurnitures:stripped_mangrove_wardrobe" | "framedblocks:framed_flat_ext_slope_panel_corner" | "compressedblocks:shapeless_sextuple_crated_red_dye" | "corail_woodcutter:woodcutting/biomesoplenty/palm_planks_from_palm_logs" | "botania:lime_floating_flower" | "botania:stonecutting/metamorphic_fungal_bricks_to_metamorphic_fungal_bricks_stairs" | "compressedblocks:shaped_c2_sandstone" | "botania:virus_necrodermal" | "corail_woodcutter:woodcutting/spruce_trapdoor_from_spruce_logs" | "chipped_express:stonecutting_chipped_rectangle_orange_wool_from_orange_wool" | "pamhc2foodcore:glowberryjellytoastitem" | "gemsnjewels:light_stone_sable_amethyst" | "railways:sequenced_assembly/track_oak" | "framedblocks:framing_saw/framed_double_prism_corner" | "compressedblocks:shapeless_crated_blaze_powder" | "mcwroofs:gray_upper_steep_roof" | "compressedblocks:shapeless_c7_nether_gold_ore" | "compressedblocks:shapeless_c8_oak_log" | "mcwtrpdoors:mangrove_cottage_trapdoor" | "copycats:stonecutting/copycat_slice" | "botania:runic_altar/gluttony" | "chipped_express:stonecutting_chipped_crying_nether_bricks_from_nether_bricks" | "compressedblocks:shaped_c7_cut_red_sandstone" | "createdeco:industrial_iron_nugget_from_industrial_iron_ingot" | "compressedblocks:shaped_quadruple_crated_end_crystal" | "chipped_express:stonecutting_chipped_laced_dark_oak_planks_from_dark_oak_planks" | "vinery:wine_fermentation/mellohi_wine" | "railways:sequenced_assembly/track_blackstone_narrow" | "create:andesite_from_stone_types_andesite_stonecutting" | "meadow:wood_cutter/cherry/cherry_door_woodcutter" | "chipped_express:stonecutting_chipped_pegged_cyan_concrete_from_cyan_concrete" | "compressedblocks:shapeless_octuple_crated_chorus_fruit" | "chipped_express:stonecutting_chipped_sad_dark_prismarine_from_dark_prismarine" | "alexsdelight:smelting/kangaroo_shank_cook" | "botania:cocoon" | "pamhc2foodextended:driedsoupitem" | "pamhc2foodextended:mochicakeitem" | "pamhc2crops:bakedwaterchestnutitem_smoker" | "railways:crafting/palettes/dyeing_1x/magenta_brass_wrapped_locometal" | "chipped_express:stonecutting_chipped_cracked_flat_smooth_stone_tiles_from_smooth_stone" | "meadow:wood_cutter/birch/birch_slabs_woodcutter" | "chipped_express:stonecutting_chipped_polished_jungle_planks_from_jungle_planks" | "compressedblocks:shaped_septuple_crated_twisting_vines" | "corail_woodcutter:woodcutting/jungle_stairs_from_jungle_logs" | "supplementaries:candle_holders/candle_holder_red" | "compressedblocks:shapeless_septuple_crated_paper" | "mcwfurnitures:birch_covered_desk" | "mcwroofs:black_terracotta_top_roof" | "create:compat/endergetic/splashing/petrified_overworld_corrock_block" | "beachparty:mini_fridge_mixing/icecream_cactus" | "mcwdoors:warped_nether_door" | "framedblocks:framed_flat_stacked_slope_slab_corner_rotate_to_framed_flat_stacked_slope_panel_corner" | "lootbags:clothing_collection/cat_ears_completion" | "snowyspirit:compressedblocks/sled_c4_spruce" | "compressedblocks:shapeless_crated_lime_dye" | "compressedblocks:shapeless_c6_birch_planks" | "luphieclutteredmod:luphie_black_left_outer_corner_counter_recipe" | "compressedblocks:shaped_septuple_crated_weeping_vines" | "pamhc2foodextended:papayayogurtitem" | "railways:crafting/palettes/dyeing_8x/brown_iron_wrapped_locometal_boiler" | "quark:building/crafting/vertslabs/wax/waxed_oxidized_cut_copper_vertical_slab_hc" | "luphieclutteredmod:luphie_light_green_sink_counter_recipe" | "create:splashing/purple_concrete_powder" | "biomesoplenty:smooth_black_sandstone_stairs" | "botania:stonecutting/metamorphic_fungal_stone_to_chiseled_metamorphic_fungal_bricks" | "chipped_express:stonecutting_chipped_triangular_lime_terracotta_from_lime_terracotta" | "chipped_express:stonecutting_chipped_tiled_bamboo_door_from_bamboo_door" | "corail_woodcutter:woodcutting/biomesoplenty/magic_stairs_from_magic_planks" | "corail_woodcutter:woodcutting/biomesoplenty/jacaranda_fence_from_jacaranda_planks" | "compressedblocks:shapeless_c5_netherite_block" | "mcwfences:granite_grass_topped_wall" | "chipped_express:stonecutting_chipped_shimmering_shroomlight_from_shroomlight" | "botania:fire_rod" | "chipped_express:stonecutting_chipped_vertical_stiped_cyan_stained_glass_pane_from_cyan_stained_glass_pane" | "botania:petal_pink_double" | "chipped_express:stonecutting_chipped_grill_purple_concrete_from_purple_concrete" | "compressedblocks:shapeless_septuple_crated_nautilus_shell" | "conditional:create/mixing/magnetic_wine_mixing" | "botania:petal_apothecary/jaded_amaranthus" | "compressedblocks:shaped_crated_amethyst_shard" | "chipped_express:stonecutting_chipped_vertical_cut_redstone_block_from_redstone_block" | "compressedblocks:shapeless_c2_stone_bricks" | "chipped_express:stonecutting_chipped_brick_bordered_bricks_from_bricks" | "compressedblocks:shaped_double_crated_yellow_dye" | "create:compacting/honey" | "botania:elementium_shears" | "domesticationinnovation:pet_bed_black_from_dye" | "minecraft:food_serving" | "compressedblocks:shapeless_sextuple_crated_rose_bush" | "pamhc2foodextended:fishdinneritem" | "compressedblocks:shaped_triple_crated_blaze_powder" | "compressedblocks:shaped_octuple_crated_wither_rose" | "mcwfurnituresbop:redwood_covered_desk" | "compressedblocks:shaped_c0_cut_copper" | "chipped_express:stonecutting_chipped_angry_amethyst_block_from_amethyst_block" | "chipped_express:stonecutting_chipped_woven_spruce_trapdoor_from_spruce_trapdoor" | "chipped_express:stonecutting_chipped_creeper_mossy_cobblestone_carving_from_mossy_cobblestone" | "mcwfences:dark_oak_picket_fence" | "railways:crafting/palettes/dyeing_1x/cyan_plated_locometal" | "conditional:bloomingnature/wood_cutter/chestnut_trapdoor_woodcutter" | "botanypots:botanypots/crafting/light_gray_concrete_hopper_botany_pot" | "chipped_express:stonecutting_chipped_warped_planks_panel_from_warped_planks" | "quark:building/stonecutting/vertslabs/jasper_bricks_vertical_slab_stonecutter" | "botania:gaia_pylon" | "compressedblocks:shapeless_triple_crated_orange_carpet" | "mcwfurnitures:stripped_birch_glass_table" | "cosmeticarmoursmod:grey_bunny_tail_rec" | "compressedblocks:shapeless_c3_waxed_cut_copper" | "railways:stonecutting/palettes/cycling/black_plated_locometal" | "compressedblocks:shapeless_giga_crated_chain" | "biomesoplenty:stripped_willow_wood" | "alexsdelight:smelting/catfish_slice_smoke" | "mcwfences:bamboo_highley_gate" | "minecraft:smoking_roastedsunflowerseedsitem" | "chipped_express:stonecutting_chipped_clay_bricks_from_clay" | "minecraft:deepslate_tile_stairs_from_deepslate_tiles_stonecutting" | "fairylights:snowflake_light" | "compressedblocks:shaped_crated_light_gray_carpet" | "chipped_express:stonecutting_chipped_duh_clay_from_clay" | "compressedblocks:shapeless_triple_crated_spruce_sapling" | "pamhc2foodextended:mangosmoothieitem" | "farmersdelight:bacon_and_eggs" | "nethervinery:crimson_grape_seeds" | "gemsnjewels:light_stone_peridot" | "chipped_express:stonecutting_chipped_square_light_blue_stained_glass_pane_from_light_blue_stained_glass_pane" | "delightful:knives/smelting/lead_thermal" | "botanypots:minecraft/crop/melon" | "minecraft:torch" | "chipped_express:stonecutting_chipped_fine_dark_oak_planks_from_dark_oak_planks" | "compressedblocks:shapeless_septuple_crated_red_carpet" | "mcwwindows:window_base" | "pamhc2foodextended:pineappleupsidedowncakeitem" | "chipped_express:stonecutting_chipped_cornered_acacia_planks_from_acacia_planks" | "chipped_express:stonecutting_chipped_massive_dripstone_block_bricks_from_dripstone_block" | "chipped_express:stonecutting_chipped_thick_inlayed_raw_iron_block_from_raw_iron_block" | "moa_decor_bath:c_tcafes_1" | "compressedblocks:shaped_sextuple_crated_gray_dye" | "mcwroofs:mud_brick_upper_lower_roof" | "compressedblocks:shaped_c1_red_sand" | "compressedblocks:shapeless_sextuple_crated_blue_dye" | "railways:sequenced_assembly/track_quark_ancient_narrow" | "utilitix:glue_ball" | "farmersdelight:cutting/acacia_hanging_sign" | "bakery:iron_table" | "pamhc2foodextended:hamandpineapplepizzaitem" | "chipped_express:stonecutting_chipped_polished_redstone_block_from_redstone_block" | "chipped_express:stonecutting_chipped_cobbled_stone_from_stone" | "compressedblocks:shapeless_giga_crated_glistering_melon_slice" | "mcwfurnituresbop:fir_modern_chair" | "chipped_express:stonecutting_chipped_vertical_cut_sandstone_from_sandstone" | "herbalbrews:milk_coffee" | "chipped_express:stonecutting_chipped_overgrown_oak_trapdoor_from_oak_trapdoor" | "chipped_express:stonecutting_chipped_angry_ancient_debris_from_ancient_debris" | "chipped_express:stonecutting_chipped_smoothed_double_inlayed_clay_from_clay" | "chipped_express:stonecutting_chipped_grid_cyan_concrete_from_cyan_concrete" | "biomesoplenty:orange_sandstone_stairs_from_orange_sandstone_stonecutting" | "chipped_express:stonecutting_chipped_warning_light_blue_concrete_from_light_blue_concrete" | "create:crafting/copper/waxed_oxidized_copper_shingles_from_honeycomb" | "framedblocks:framed_inner_corner_slope" | "botania:cosmetic_unicorn_horn" | "railways:crafting/palettes/dyeing_1x/orange_flat_riveted_locometal" | "botania:dreamwood_wand" | "quark:building/crafting/walls/blackstone_bricks_wall" | "chipped_express:stonecutting_chipped_diamond_acacia_planks_from_acacia_planks" | "chipped_express:stonecutting_chipped_tiled_light_blue_carpet_from_light_blue_carpet" | "alexsmobs:komodo_spit_to_slime" | "candlelight:pan_cooking/pancake" | "pamhc2foodextended:dragonfruityogurtitem" | "compressedblocks:shapeless_mega_crated_poppy" | "mcwwindows:green_mosaic_glass" | "compressedblocks:shapeless_septuple_crated_purple_dye" | "sophisticatedstorage:iron_barrel" | "compressedblocks:shaped_triple_crated_magenta_carpet" | "bakery:crafting_bowl/cake_dough" | "mcwbridges:brick_bridge_stair" | "railways:sequenced_assembly/track_blue_skies_starlit" | "compressedblocks:shaped_c4_bone_block" | "create:cutting/stripped_warped_hyphae" | "compressedblocks:shaped_septuple_crated_birch_sapling" | "compressedblocks:shapeless_septuple_crated_wheat_seeds" | "compressedblocks:shapeless_sextuple_crated_poppy" | "pamhc2foodextended:misopasteitem" | "compressedblocks:shapeless_septuple_crated_map" | "mcwfurnitures:stripped_acacia_bookshelf_drawer" | "mcwfurnitures:warped_drawer" | "compressedblocks:shapeless_c0_copper_block" | "botania:dreamwood_wall" | "createdeco:tiled_verdant_brick_stairs_from_verdant_brick_stairs_stonecutting" | "moa_decor_holidays:esp_rosa_1" | "botania:glimmering_stripped_dreamwood_from_log" | "compressedblocks:shapeless_double_crated_egg" | "mcwtrpdoors:cherry_swamp_trapdoor" | "exoticbirds:blue_birdhouse" | "supplementaries:lock_block" | "botania:slab_recombine/metamorphic_swamp_cobblestone" | "compressedblocks:shaped_double_crated_rabbit_foot" | "spawn:tuna_sandwich" | "sophisticatedstorage:stack_upgrade_tier_1" | "sophisticatedstorage:stack_upgrade_tier_2" | "sophisticatedstorage:stack_upgrade_tier_3" | "compressedblocks:shapeless_c2_chiseled_red_sandstone" | "quark:building/stonecutting/stonevariants/limestone_bricks_vertical_slab_polished_stonecutting" | "cosmeticarmoursmod:green_knight_armour_chestplate_rec" | "chipped_express:stonecutting_chipped_eroded_dirt_from_dirt" | "sophisticatedstorage:stack_upgrade_tier_4" | "sophisticatedstorage:orange_shulker_box_to_sophisticated" | "chipped_express:stonecutting_chipped_brick_bordered_red_sandstone_from_red_sandstone" | "create:filling/glowstone" | "chipped_express:stonecutting_chipped_vined_acacia_trapdoor_from_acacia_trapdoor" | "corail_woodcutter:biomesoplenty/willow_woodcutter" | "snowyspirit:biomesoplenty/sled_umbran" | "quark:building/stonecutting/slabs/cut_soul_sandstone_slab_stonecutter2" | "luphieclutteredmod:luphie_apple_chair_recipe" | "corail_woodcutter:woodcutting/biomesoplenty/jacaranda_fence_from_jacaranda_logs" | "cosmeticarmoursmod:rg_angel_halo_rec" | "chipped_express:stonecutting_chipped_sad_snow_block_from_snow_block" | "moa_decor_bath:bcerezosc_1" | "botania:manasteel_helmet" | "corail_woodcutter:woodcutting/biomesoplenty/jacaranda_trapdoor_from_jacaranda_planks" | "cosmeticarmoursmod:pink_bunny_ears_rec" | "create:splashing/gravel" | "railways:sequenced_assembly/track_biomesoplenty_dead_narrow" | "pamhc2foodextended:fiestacornsaladitem" | "create:crafting/kinetics/andesite_door" | "chipped_express:stonecutting_chipped_heart_packed_mud_from_packed_mud" | "compressedblocks:shapeless_giga_crated_yellow_carpet" | "nethersdelight:diamond_machete" | "railways:stonecutting/palettes/cycling/pink_locometal_smokebox" | "macawsroofsbop:hellbark_attic_roof" | "compressedblocks:shaped_double_crated_lily_of_the_valley" | "supplementaries:compressedblocks/sign_post_c2_acacia" | "compressedblocks:shaped_quadruple_crated_light_gray_carpet" | "railways:sequenced_assembly/track_tfc_blackwood_wide" | "mcwfurnitures:stripped_spruce_chair" | "moa_decor_cookery:barrilbetabel_1" | "spawn:cutting/rotten_log" | "gemsnjewels:create/create_crushing_pale_diamond_deepslate_ore" | "mcwroofs:white_concrete_top_roof" | "handcrafted:acacia_shelf" | "mcwroofs:orange_terracotta_steep_roof" | "luphieclutteredmod:luphie_pastel_table_recipe" | "cosmeticarmoursmod:white_skirt_2_light_blue" | "framedblocks:framing_saw/framed_double_threeway_corner" | "chipped_express:stonecutting_chipped_thick_white_inlayed_redstone_lamp_from_redstone_lamp" | "create:compat/atmospheric/cutting/stripped_aspen_log" | "minecraft:granite_wall" | "mcwfurnitures:warped_chair" | "minecraft:black_sheet_from_black_dye" | "handcrafted:granite_corner_trim" | "chipped_express:stonecutting_chipped_cornered_pink_carpet_from_pink_carpet" | "bloomingnature:palm_chest_boat" | "chipped_express:stonecutting_chipped_sign_stripped_oak_log_from_stripped_oak_log" | "moa_decor_toys:zombieahogado_1" | "snowyspirit:compressedblocks/sled_c7_dark_oak" | "compressedblocks:shaped_double_crated_soul_campfire" | "chipped_express:stonecutting_chipped_crossed_red_terracotta_from_red_terracotta" | "chipped_express:stonecutting_chipped_smooth_green_concrete_from_green_concrete" | "botania:floating_manastar" | "chipped_express:stonecutting_chipped_cut_blank_borderless_bricks_from_bricks" | "pamhc2trees:spiderweb_sapling" | "compressedblocks:shaped_quadruple_crated_acacia_sapling" | "chipped_express:stonecutting_chipped_large_packed_mud_sigil_from_packed_mud" | "mcwroofs:acacia_top_roof" | "corail_woodcutter:woodcutting/biomesoplenty/jacaranda_stairs_from_jacaranda_logs" | "chipped_express:stonecutting_chipped_overlapping_packed_ice_tiles_from_packed_ice" | "mcwfurnitures:stripped_mangrove_end_table" | "minecraft:warped_fence" | "createaddition:compat/tconstruct/hepatizon" | "railways:crafting/track_switch_andesite" | "pamhc2crops:cloudberryseeditem" | "botanypots:minecraft/crop/kelp" | "pamhc2crops:yuccaseeditem" | "railways:crafting/palettes/dyeing_1x/black_flat_riveted_locometal" | "mcwlights:redstone_lamp_slab" | "mcwfurnitures:cherry_bookshelf_cupboard" | "createdeco:industrial_iron_ladder_from_stonecutting" | "chipped_express:stonecutting_chipped_tiny_layered_mossy_stone_bricks_bricks_from_mossy_stone_bricks" | "minecraft:loom" | "farmersdelight:cutting/cake" | "chipped_express:stonecutting_chipped_k_sign_stripped_warped_stem_from_stripped_warped_stem" | "chipped_express:stonecutting_chipped_prismal_netherrack_remnants_from_netherrack" | "chiselsandbits:mirror_over_y" | "chiselsandbits:mirror_over_z" | "chipped_express:stonecutting_chipped_duh_tuff_from_tuff" | "pamhc2foodcore:batteritem_x2" | "chiselsandbits:mirror_over_x" | "chipped_express:stonecutting_chipped_engraved_ancient_debris_from_ancient_debris" | "pamhc2foodextended:coffeeconlecheitem" | "compressedblocks:shaped_octuple_crated_ghast_tear" | "pamhc2foodextended:vanillaconchasbreaditem" | "quark:building/crafting/stonevariants/limestone_bricks" | "conditional:regions_unexplored/wood_cutter/brimwood_fencegate_woodcutter" | "byg:nightshade_berry_pie_from_slices" | "compressedblocks:shapeless_c4_coal_block" | "chipped_express:stonecutting_chipped_patched_red_wool_from_red_wool" | "moa_decor_holidays:regalo_gris_1" | "moa_decor_bath:secadormanos_1" | "chipped_express:stonecutting_chipped_fine_vertical_bamboo_planks_from_bamboo_planks" | "chipped_express:stonecutting_chipped_harsh_quilted_light_blue_wool_from_light_blue_wool" | "chipped_express:stonecutting_chipped_weathered_mossy_cobblestone_from_mossy_cobblestone" | "chipped_express:stonecutting_chipped_bordered_raw_gold_block_from_raw_gold_block" | "compressedblocks:shaped_c1_basalt" | "compressedblocks:shaped_c1_stripped_cherry_log" | "botania:stonecutting/red_quartz_to_chiseled_red_quartz" | "quark:building/crafting/panes/framed_glass_pane" | "quark:world/crafting/slabs/polished_myalite_slab" | "mcwlights:soul_spruce_tiki_torch" | "farmersdelight:cutting/sweet_berry_cheesecake" | "chipped_express:stonecutting_chipped_angled_packed_mud_bricks_from_packed_mud" | "quark:building/crafting/vertslabs/polished_andesite_vertical_slab" | "mcwroofs:pink_terracotta_steep_roof" | "bloomingnature:ebony_slab" | "mcwdoors:dark_oak_beach_door" | "aquaculturedelight:cutting/knife/red_shrooma" | "quark:world/stonecutting/walls/andesite_bricks_wall_stonecutter" | "railways:crafting/palettes/dyeing_1x/green_locometal_pillar" | "copycats:stonecutting/copycat_trapdoor" | "chipped_express:stonecutting_chipped_starry_pink_terracotta_from_pink_terracotta" | "non_wandering_trader:travellers_table" | "vinery:cherry_cabinet" | "chipped_express:stonecutting_chipped_spiraled_nether_bricks_from_nether_bricks" | "luphieclutteredmod:luphie_lavender_spool_of_thread_recipe" | "chipped_express:stonecutting_chipped_woved_purple_carpet_from_purple_carpet" | "botania:black_pavement_slab" | "sophisticatedstorage:light_blue_shulker_box_to_sophisticated" | "mcwdoors:cherry_beach_door" | "quark:building/crafting/stonevariants/chiseled_jasper_bricks" | "botania:gaia_spreader" | "mcwroofs:black_upper_lower_roof" | "mighty_mail:warped_mail_box" | "compressedblocks:shaped_c3_clay" | "botanypots:pamhc2crops/crop/juniperberry" | "chipped_express:stonecutting_chipped_end_stone_bricks_from_end_stone" | "mcwwindows:blackstone_parapet" | "chipped_express:stonecutting_chipped_stacked_light_blue_concrete_from_light_blue_concrete" | "botania:metamorphic_mountain_bricks_wall" | "compressedblocks:shapeless_c4_blackstone" | "moa_decor_cookery:copadevino_1" | "botania:stonecutting/blue_pavement_to_blue_pavement_slab" | "cosmeticarmoursmod:light_grey_top_2_white" | "biomesoplenty:dead_wood" | "mcwroofs:stone_top_roof" | "chipped_express:stonecutting_chipped_upside_down_carved_pumpkin_from_carved_pumpkin" | "chipped_express:stonecutting_chipped_checkered_quartz_block_tiles_from_quartz_block" | "railways:crafting/palettes/dyeing_8x/purple_locometal_smokebox" | "supplementaries:soap_block" | "botanypots:pamhc2crops/crop/spiceleaf" | "quark:world/crafting/stairs/myalite_bricks_stairs" | "candlelight:bamboo_big_table" | "chipped_express:stonecutting_chipped_dripstone_block_pillar_top_from_dripstone_block" | "compressedblocks:shaped_sextuple_crated_campfire" | "chipped_express:stonecutting_chipped_shrunken_pink_glazed_terracotta_from_pink_glazed_terracotta" | "pamhc2foodextended:cactusfruitjellysandwichitem" | "moa_decor_art:bateriaroja_1" | "botania:petal_gray_double" | "compressedblocks:shapeless_double_crated_stick" | "pamhc2foodextended:curryitem" | "gemsnjewels:tanzanite_set_gold_crown" | "chipped_express:stonecutting_chipped_dual_paneled_mangrove_door_from_mangrove_door" | "quark:building/stonecutting/stonevariants/chiseled_dripstone_bricks_stonecutter" | "utilitix:anvil_cart" | "chipped_express:stonecutting_chipped_bamboo_planks_panel_from_bamboo_planks" | "pamhc2foodextended:tamarindjellytoastitem" | "refinedstorage:coloring_recipes/crafter" | "chipped_express:stonecutting_chipped_amethyst_block_scales_from_amethyst_block" | "domesticationinnovation:pet_bed_orange_from_dye" | "compressedblocks:shapeless_quadruple_crated_chain" | "chipped_express:stonecutting_chipped_broken_lily_pad_from_lily_pad" | "botanypots:farming_crossing/crop/pamhc2treespassionfruit_sapling" | "chipped_express:stonecutting_chipped_soft_black_carpet_from_black_carpet" | "chipped_express:stonecutting_chipped_grill_orange_concrete_from_orange_concrete" | "chipped_express:stonecutting_chipped_smooth_mud_from_mud" | "framedblocks:framing_saw/framed_half_stairs" | "chipped_express:stonecutting_chipped_starry_light_gray_terracotta_from_light_gray_terracotta" | "sophisticatedbackpacks:compacting_upgrade" | "farmersdelight:kelp_roll" | "chipped_express:stonecutting_chipped_square_yellow_stained_glass_from_yellow_stained_glass" | "framedblocks:framing_saw/framed_slope_panel" | "handcrafted:spruce_cupboard" | "botanypots:botanypots/crafting/magenta_glazed_terracotta_botany_pot" | "quark:building/crafting/panes/magenta_framed_glass_pane" | "chipped_express:stonecutting_chipped_vertical_disordered_stone_bricks_from_stone" | "compressedblocks:shapeless_sextuple_crated_beef" | "quark:building/stonecutting/vertslabs/sandstone_vertical_slab_stonecutter" | "mcwroofs:mangrove_planks_attic_roof" | "conditional:bloomingnature/wood_cutter/larch_planks_woodcutter" | "corail_woodcutter:woodcutting/biomesoplenty/umbran_pressure_plate_from_umbran_planks" | "luphieclutteredmod:luphie_pastel_traditional_table_recipe" | "farmersdelight:carrot_from_crate" | "chipped_express:stonecutting_chipped_vertical_disordered_amethyst_block_bricks_from_amethyst_block" | "compressedblocks:shapeless_double_crated_shulker_shell" | "conditional:bloomingnature/wood_cutter/larch_pp_woodcutter" | "mcwwindows:red_curtain" | "corail_woodcutter:woodcutting/acacia_button_from_acacia_logs" | "conditional:regions_unexplored/wood_cutter/baobab_stairs_woodcutter" | "create:crafting/logistics/brass_funnel" | "chipped_express:stonecutting_chipped_engraved_snow_block_from_snow_block" | "mcwfurnitures:dark_oak_drawer_counter" | "mcwwindows:light_gray_mosaic_glass" | "chipped_express:stonecutting_chipped_angry_cobblestone_from_cobblestone" | "alexsmobs:banner_pattern_bear" | "minecraft:baked_potato_from_campfire_cooking" | "chipped_express:stonecutting_chipped_tiny_brick_bordered_purpur_block_from_purpur_block" | "pamhc2foodextended:blackberryjellytoastitem" | "mcwbridges:crimson_log_bridge_stair_recycle" | "brewery:silo_wood" | "pamhc2foodextended:steakandchipsitem" | "mcwroofs:bamboo_planks_steep_roof" | "pamhc2foodextended:persimmonsmoothieitem" | "macawsroofsbop:magic_upper_lower_roof" | "lootbags:common_decorations/arts_completion" | "chipped_express:stonecutting_chipped_solid_cherry_trapdoor_from_cherry_trapdoor" | "mcwroofs:lime_concrete_lower_roof" | "createdeco:locked_industrial_iron_door" | "mcwfurnitures:stripped_spruce_double_drawer_counter" | "handcrafted:white_cushion" | "create:crushing/amethyst_block" | "mcwroofs:gray_terracotta_attic_roof" | "createdeco:tiled_red_brick_stairs_from_long_red_bricks_stonecutting" | "chipped_express:stonecutting_chipped_shrunken_green_glazed_terracotta_from_green_glazed_terracotta" | "chipped_express:stonecutting_chipped_runic_carved_mossy_cobblestone_from_mossy_cobblestone" | "railways:crafting/palettes/dyeing_1x/light_blue_brass_wrapped_locometal" | "cosmeticarmoursmod:blue_knight_armour_chestplate_rec" | "chipped_express:stonecutting_chipped_creeper_basalt_carving_from_basalt" | "mcwfurnitures:warped_drawer_counter" | "chipped_express:stonecutting_chipped_inlayed_crying_obsidian_from_crying_obsidian" | "chipped_express:stonecutting_chipped_tiled_bone_block_from_bone_block" | "quark:world/crafting/stairs/polished_shale_stairs" | "compressedblocks:shapeless_giga_crated_wheat_seeds" | "cosmeticarmoursmod:yellow_skirt_2_white" | "create:crafting/logistics/display_link" | "compressedblocks:shapeless_c8_dirt" | "chipped_express:stonecutting_chipped_striped_red_concrete_from_red_concrete" | "mcwdoors:jungle_stable_head_door" | "minecraft:red_stained_glass_pane_from_glass_pane" | "createdeco:long_scarlet_brick_slab_from_tiled_scarlet_bricks_stonecutting" | "compressedblocks:shaped_quadruple_crated_sculk_vein" | "chipped_express:stonecutting_chipped_paper_dark_oak_door_from_dark_oak_door" | "compressedblocks:shapeless_mega_crated_wheat_seeds" | "supplementaries:candle_holders/candle_holder_yellow" | "chipped_express:stonecutting_chipped_stop_light_gray_concrete_from_light_gray_concrete" | "quark:building/crafting/orange_blossom_hedge" | "macawsroofsbop:palm_planks_lower_roof" | "chipped_express:stonecutting_chipped_sad_smooth_stone_from_smooth_stone" | "compressedblocks:shapeless_double_crated_peony" | "compressedblocks:shaped_giga_crated_flint" | "compressedblocks:shaped_sextuple_crated_jungle_sapling" | "compressedblocks:shaped_double_crated_milk_bucket" | "quark:building/stonecutting/stairs/sandstone_bricks_stairs_stonecutter" | "chipped_express:stonecutting_chipped_layed_sandstone_bricks_from_sandstone" | "compressedblocks:shapeless_double_crated_golden_carrot" | "chipped_express:stonecutting_chipped_sanded_cobblestone_from_cobblestone" | "mcwlights:mangrove_tiki_torch" | "chipped_express:stonecutting_chipped_sign_stripped_acacia_log_from_stripped_acacia_log" | "gemsnjewels:create/create_crushing_citrine_ore" | "framedblocks:framed_checkered_slab" | "chipped_express:stonecutting_chipped_patched_black_carpet_from_black_carpet" | "chipped_express:stonecutting_chipped_curled_gray_terracotta_from_gray_terracotta" | "compressedblocks:shaped_giga_crated_warped_fungus" | "botanypots:botanypots/crafting/red_glazed_terracotta_hopper_botany_pot" | "chipped_express:stonecutting_chipped_harsh_quilted_light_gray_wool_from_light_gray_wool" | "sophisticatedbackpacks:advanced_restock_upgrade" | "create:compat/neapolitan/emptying/milk_bottle" | "quark:building/crafting/vertplanks/vertical_azalea_planks" | "create:framed_glass_from_glass_colorless_stonecutting" | "compressedblocks:shapeless_octuple_crated_golden_apple" | "mcwfurnituresbop:palm_covered_desk" | "minecraft:warped_sign" | "compressedblocks:shapeless_septuple_crated_carrot" | "moa_decor_art:aerosolmorado_1" | "compressedblocks:shaped_triple_crated_kelp" | "botania:pattern_1_1" | "moa_decor_lights:faroltriple_d_1" | "botania:pattern_1_2" | "botania:pattern_1_3" | "chipped_express:stonecutting_chipped_waved_green_glazed_terracotta_from_green_glazed_terracotta" | "pamhc2foodcore:chocolatebaconitem" | "utilitix:reinforced_filter_rail" | "mcwroofs:black_striped_awning" | "luphieclutteredmod:luphie_red_shroom_terrarium_recipe" | "moa_decor_cookery:sandwich_1" | "cosmeticarmoursmod:purple_plaid_2_white" | "minecraft:bamboo_sign" | "luphieclutteredmod:luphie_retro_white_fridge_recipe" | "framedblocks:framing_saw/framed_fence" | "quark:world/crafting/woodsets/ancient/door" | "moa_decor_art:gemadearte_1" | "quark:building/crafting/panes/green_framed_glass_pane" | "pamhc2trees:roastedhazelnutitem_forge" | "chipped_express:stonecutting_chipped_offset_prismarine_bricks_from_prismarine" | "bloomingnature:brown_mushroom_brick_slab_from_brown_mushroom_bricks_stonecutting" | "delightful:knives/draco_arcanus_knife" | "create:crafting/kinetics/spout" | "chipped_express:stonecutting_chipped_shuttered_waxed_exposed_copper_from_waxed_exposed_copper" | "conditional:regions_unexplored/wood_cutter/maple_button_woodcutter" | "chipped_express:stonecutting_chipped_crossed_white_terracotta_from_white_terracotta" | "compressedblocks:shapeless_giga_crated_cooked_mutton" | "compressedblocks:shapeless_mega_crated_rail" | "chipped_express:stonecutting_chipped_stacked_packed_ice_bricks_from_packed_ice" | "quark:building/crafting/lamps/orange_crystal_lamp" | "sophisticatedstorage:iron_chest" | "mcwlights:black_ceiling_light" | "farmersdelight:integration/create/milling/wild_tomatoes" | "gemsnjewels:forge_diamond_set_gold_ring" | "compressedblocks:shapeless_c4_waxed_oxidized_cut_copper" | "chipped_express:stonecutting_chipped_curled_cyan_terracotta_from_cyan_terracotta" | "compressedblocks:shapeless_mega_crated_cyan_dye" | "create:copper_scaffolding_from_ingots_copper_stonecutting" | "vinery:apple_mashing/apple_mash" | "minecraft:lime_glazed_terracotta" | "chipped_express:stonecutting_chipped_dark_broken_lily_pad_from_lily_pad" | "chipped_express:stonecutting_chipped_square_cyan_stained_glass_pane_from_cyan_stained_glass_pane" | "createdeco:tiled_red_brick_stairs_from_short_red_bricks_stonecutting" | "luphieclutteredmod:yellow_bicycle_recipe" | "pamhc2foodextended:grapefruitjellysandwichitem" | "chipped_express:stonecutting_chipped_patched_orange_wool_from_orange_wool" | "compressedblocks:shaped_octuple_crated_yellow_dye" | "chipped_express:stonecutting_chipped_striped_white_concrete_from_white_concrete" | "createdeco:blue_placard_from_dyeing" | "createdeco:long_pearl_brick_stairs_from_tiled_pearl_brick_stairs_stonecutting" | "create:cutting/compat/byg/fir_log" | "corail_woodcutter:woodcutting/biomesoplenty/hellbark_trapdoor_from_hellbark_planks" | "ars_nouveau:imbuement_mangosteen" | "chipped_express:stonecutting_chipped_prismal_quartz_block_remnants_from_quartz_block" | "botania:azulejo_0_alt" | "botania:incense_plate" | "macawsroofsbop:redwood_attic_roof" | "quark:building/crafting/panes/cyan_framed_glass_pane" | "railways:crafting/palettes/dyeing_1x/white_brass_wrapped_locometal" | "luphieclutteredmod:luphie_flowering_yellow_trapdoor_recipe" | "compressedblocks:shaped_c3_waxed_cut_copper" | "conditional:regions_unexplored/wood_cutter/eucalyptus_button_woodcutter" | "compressedblocks:shapeless_sextuple_crated_ender_pearl" | "quark:building/crafting/vertslabs/wax/waxed_weathered_cut_copper_vertical_slab_hc" | "compressedblocks:shaped_quadruple_crated_stick" | "compressedblocks:shaped_triple_crated_paper" | "compressedblocks:shaped_quadruple_crated_peony" | "compressedblocks:shaped_septuple_crated_glowstone_dust" | "compressedblocks:shapeless_c6_exposed_copper" | "cosmeticarmoursmod:white_top_2_brown" | "compressedblocks:shapeless_c0_waxed_oxidized_copper" | "railways:stonecutting/riveted_locometal" | "sophisticatedstorage:oak_barrel" | "botania:stonecutting/metamorphic_mountain_bricks_to_metamorphic_mountain_bricks_slab" | "chipped_express:stonecutting_chipped_fancy_red_stained_glass_from_red_stained_glass" | "chipped_express:stonecutting_chipped_reinforced_light_blue_concrete_from_light_blue_concrete" | "mcwfences:cherry_highley_gate" | "mcwfurnituresbop:redwood_lower_triple_drawer" | "botania:stonecutting/metamorphic_swamp_cobblestone_to_metamorphic_swamp_cobblestone_wall" | "pamhc2foodextended:papayajuiceitem" | "compressedblocks:shaped_triple_crated_comparator" | "mcwwindows:stripped_warped_pane_window" | "biomesoplenty:white_sandstone_wall" | "create:compat/projectvibrantjourneys/cutting/mangrove_log" | "supplementaries:ash_bricks" | "chipped_express:stonecutting_chipped_exposed_pearlescent_froglight_from_pearlescent_froglight" | "copycats:crafting/copycat_box" | "createdeco:long_verdant_brick_slab" | "chipped_express:stonecutting_chipped_engraved_amethyst_block_from_amethyst_block" | "chipped_express:stonecutting_chipped_tiny_brick_bordered_basalt_from_basalt" | "utilitix:ender_cart" | "moa_decor_bath:babedul_1" | "compressedblocks:shapeless_c4_dark_oak_planks" | "biomesoplenty:chiseled_orange_sandstone_from_orange_sandstone_stonecutting" | "cosmeticarmoursmod:royal_tunic_magenta_2_white" | "chipped_express:stonecutting_chipped_ribbled_black_wool_from_black_wool" | "botania:elven_trade/iron_return" | "pamhc2foodextended:breadfruitjellysandwichitem" | "handcrafted:bamboo_side_table" | "bloomingnature:mushroom_brick" | "create:compat/byg/milling/violet_leather_flower" | "create:cutting/compat/blue_skies/stripped_lunar_wood" | "mcwroofs:bamboo_planks_attic_roof" | "chipped_express:stonecutting_chipped_blue_ice_pillar_top_from_blue_ice" | "mcwroofs:yellow_terracotta_roof" | "compressedblocks:shapeless_mega_crated_light_gray_carpet" | "chipped_express:stonecutting_chipped_poisonous_mushroom_stem_from_mushroom_stem" | "luphieclutteredmod:luphie_lo_small_table_recipe" | "compressedblocks:shaped_c9_netherite_block" | "mcwroofs:mangrove_planks_top_roof" | "mcwfurnitures:stripped_acacia_modern_wardrobe" | "bloomingnature:baobab_window" | "mcwfurnituresbop:mahogany_double_wardrobe" | "create:milling/lilac" | "botania:stonecutting/metamorphic_fungal_stone_to_metamorphic_fungal_bricks_wall" | "compressedblocks:shapeless_sextuple_crated_arrow" | "compressedblocks:shaped_c7_stripped_dark_oak_log" | "compressedblocks:shaped_quintuple_crated_yellow_carpet" | "sophisticatedstorage:upgrade_base" | "vinery:apples" | "meadow:flecked_carpet" | "chipped_express:stonecutting_chipped_crying_packed_mud_from_packed_mud" | "chipped_express:stonecutting_chipped_barred_crimson_door_from_crimson_door" | "gemsnjewels:create/create_crushing_alexandrite_ore" | "macawsroofsbop:hellbark_planks_top_roof" | "botania:mana_infusion/calcite_to_deepslate" | "chipped_express:stonecutting_chipped_massive_sandstone_bricks_from_sandstone" | "framedblocks:framing_saw/framed_divided_slope" | "compressedblocks:shapeless_double_crated_cooked_cod" | "chipped_express:stonecutting_chipped_raster_light_blue_stained_glass_pane_from_light_blue_stained_glass_pane" | "cosmeticarmoursmod:winter_survivalist_boots_grey" | "compressedblocks:shaped_mega_crated_poisonous_potato" | "fairylights:ghost_light" | "moa_decor_lights:farolpared_g_1" | "quark:building/stonecutting/vertslabs/polished_tuff_vertical_slab_stonecutter" | "chipped_express:stonecutting_chipped_gray_terracotta_tiles_from_gray_terracotta" | "compressedblocks:shapeless_quadruple_crated_soul_campfire" | "mcwroofs:purple_concrete_upper_steep_roof" | "corail_woodcutter:woodcutting/oak_door_from_oak_planks" | "conditional:regions_unexplored/wood_cutter/socotra_pp_woodcutter" | "quark:building/crafting/vertslabs/mossy_stone_brick_vertical_slab_revert" | "create:exposed_copper_tile_stairs_from_exposed_copper_tiles_stonecutting" | "refinedstorage:64k_storage_block" | "compressedblocks:shapeless_sextuple_crated_campfire" | "luphieclutteredmod:polaroid_garland_a_recipe" | "biomesoplenty:umbran_hanging_sign" | "railways:crafting/palettes/dyeing_8x/black_iron_wrapped_locometal_boiler" | "compressedblocks:shapeless_septuple_crated_string" | "quark:building/crafting/blue_blossom_leaf_carpet" | "create:cutting/compat/twilightforest/transformation_wood" | "farmersdelight:golden_knife" | "chipped_express:stonecutting_chipped_runic_carved_quartz_block_from_quartz_block" | "compressedblocks:shaped_c9_soul_sand" | "chipped_express:stonecutting_chipped_sanded_granite_from_granite" | "framedblocks:framing_saw/framed_fancy_activator_rail" | "comforts:hammock_to_gray" | "compressedblocks:shapeless_giga_crated_sugar_cane" | "compressedblocks:shapeless_c1_granite" | "farmersdelight:integration/immersiveengineering/crusher/wild_carrots" | "delightful:food/kettle/matcha_latte" | "compressedblocks:shapeless_c0_honey_block" | "chipped_express:stonecutting_chipped_creeper_sandstone_carving_from_sandstone" | "chipped_express:stonecutting_chipped_thick_inlayed_ice_from_ice" | "chipped_express:stonecutting_chipped_thin_cherry_planks_from_cherry_planks" | "compressedblocks:shaped_mega_crated_glow_lichen" | "quark:world/crafting/panes/yellow_corundum" | "botania:red_floating_flower" | "botanypots:biomesoplenty/crop/clover" | "minecraft:golden_boots" | "mcwroofs:crimson_planks_upper_lower_roof" | "create:compat/projectvibrantjourneys/cutting/stripped_baobab_log" | "waystones:mossy_waystone" | "chipped_express:stonecutting_chipped_smooth_snow_block_column_from_snow_block" | "minecraft:pink_dye_from_red_white_dye" | "compressedblocks:shaped_octuple_crated_weeping_vines" | "botania:cosmetic_questgiver_mark" | "chipped_express:stonecutting_chipped_vertical_cut_andesite_from_andesite" | "compressedblocks:shapeless_double_crated_cocoa_beans" | "compressedblocks:shaped_c2_coal_ore" | "compressedblocks:shaped_quadruple_crated_honeycomb" | "chipped_express:stonecutting_chipped_cut_blank_ancient_debris_from_ancient_debris" | "chipped_express:stonecutting_chipped_dark_melon_from_melon" | "supplementaries:flags/flag_cyan" | "compressedblocks:shapeless_c6_dark_oak_log" | "compressedblocks:shapeless_triple_crated_shulker_shell" | "pamhc2foodextended:cashewchickenitem" | "moa_decor_art:pinturanaranja_1" | "snowyspirit:bloomingnature/sled_palm" | "chipped_express:stonecutting_chipped_sanded_ancient_debris_from_ancient_debris" | "pamhc2foodextended:cottagepieitem" | "farmersdelight:cutting/jungle_door" | "luphieclutteredmod:floweringpinklogsrecipe" | "chipped_express:stonecutting_chipped_tiled_gilded_blackstone_from_gilded_blackstone" | "farmersdelight:cutting/oxeye_daisy" | "framedblocks:framed_corner_strip_from_framed_wall_board" | "compressedblocks:shaped_septuple_crated_cooked_chicken" | "compressedblocks:shapeless_c2_basalt" | "mcwbridges:balustrade_cobblestone_bridge" | "meadow:wood_cutter/birch/birch_fence_woodcutter" | "chipped_express:stonecutting_chipped_layed_ice_bricks_from_ice" | "mcwwindows:warped_stem_window2" | "cosmeticarmoursmod:royal_tunic_white_2_grey" | "minecraft:nether_brick_wall_from_nether_bricks_stonecutting" | "minecraft:oxidized_cut_copper_slab_from_oxidized_cut_copper_stonecutting" | "pamhc2crops:coffeebeanseeditem" | "conditional:regions_unexplored/wood_cutter/redwood_button_woodcutter" | "minecraft:silence_armor_trim_smithing_template" | "chipped_express:stonecutting_chipped_fancy_light_gray_stained_glass_from_light_gray_stained_glass" | "create_central_kitchen:crafting/cherry_pie" | "create:crushing/nether_gold_ore" | "compressedblocks:shapeless_mega_crated_repeater" | "mcwdoors:birch_cottage_door" | "compressedblocks:shaped_c7_iron_ore" | "chipped_express:stonecutting_chipped_wickered_cyan_wool_from_cyan_wool" | "aquaculturedelight:cooking/turtle_soup" | "chipped_express:stonecutting_chipped_lime_concrete_bricks_from_lime_concrete" | "chipped_express:stonecutting_chipped_runic_carved_raw_gold_block_from_raw_gold_block" | "biomesoplenty:fir_button" | "compressedblocks:shapeless_c4_mangrove_log" | "chipped_express:stonecutting_chipped_minimized_gray_glazed_terracotta_from_gray_glazed_terracotta" | "mcwwindows:prismarine_parapet" | "farmersdelight:cutting/bamboo_hanging_sign" | "botania:metamorphic_mountain_stone_stairs" | "moa_decor_lights:lm_gnaranja_1" | "chipped_express:stonecutting_chipped_stringed_light_gray_wool_from_light_gray_wool" | "mcwwindows:yellow_curtain" | "pamhc2foodextended:mixedflowerssaladitem" | "refinedstorage:coloring_recipes/gray_wireless_transmitter" | "frozenup:truffle_cake_from_chocolate" | "cosmeticarmoursmod:white_sock_skirt_2_lime" | "mcwbridges:mud_brick_bridge" | "chipped_express:stonecutting_chipped_tiled_raw_copper_block_from_raw_copper_block" | "compressedblocks:shapeless_giga_crated_chicken" | "mcwdoors:spruce_paper_door" | "chipped_express:stonecutting_chipped_thin_spruce_planks_from_spruce_planks" | "pamhc2foodextended:elderberryjuiceitem" | "chipped_express:stonecutting_chipped_minimized_cyan_glazed_terracotta_from_cyan_glazed_terracotta" | "chipped_express:stonecutting_chipped_ornate_dripstone_block_pillar_from_dripstone_block" | "create:crushing/deepslate_zinc_ore" | "mcwfurnitures:birch_lower_bookshelf_drawer" | "mcwlights:festive_wall_lantern" | "compressedblocks:shapeless_c1_oak_log" | "createaddition:crafting/modular_accumulator_gold" | "compressedblocks:shaped_c4_oxidized_cut_copper" | "chipped_express:stonecutting_chipped_creeper_blue_concrete_from_blue_concrete" | "chipped_express:stonecutting_chipped_cyan_terracotta_tiles_from_cyan_terracotta" | "compressedblocks:shaped_septuple_crated_map" | "mcwfurnitures:stripped_birch_bookshelf_drawer" | "compressedblocks:shapeless_octuple_crated_white_tulip" | "pamhc2foodextended:tamarindsmoothieitem" | "compressedblocks:shapeless_sextuple_crated_charcoal" | "domesticationinnovation:pet_bed_brown_from_dye" | "minecraft:granite_stairs" | "chipped_express:stonecutting_chipped_smooth_ringed_dirt_from_dirt" | "create:small_deepslate_brick_slab" | "compressedblocks:shaped_c4_cherry_log" | "moa_decor_holidays:esp_blanco_1" | "create:oxidized_copper_tile_stairs_from_oxidized_copper_tiles_stonecutting" | "chipped_express:stonecutting_chipped_spiraled_netherrack_from_netherrack" | "botanypots:pamhc2crops/crop/guarana" | "createdeco:dean_brick_slab" | "herbalbrews:cauldron_brewing/armor_flask_big" | "chipped_express:stonecutting_chipped_glad_purpur_block_from_purpur_block" | "chipped_express:stonecutting_chipped_bundled_white_wool_from_white_wool" | "createdeco:locked_andesite_door" | "chipped_express:stonecutting_chipped_pressed_bamboo_door_from_bamboo_door" | "farmersdelight:integration/create/milling/wild_rice" | "chipped_express:stonecutting_chipped_offset_redstone_block_bricks_from_redstone_block" | "chipped_express:stonecutting_chipped_slanted_mangrove_planks_from_mangrove_planks" | "createaddition:mixing/netherrack" | "luphieclutteredmod:yellow_left_outer_corner_counter_recipe_alt" | "sophisticatedstorage:crafting_upgrade" | "create:compat/silentsgems/crushing/phosphophyllite_ore" | "compressedblocks:shaped_c9_acacia_planks" | "quark:building/crafting/furnaces/blackstone_smoker" | "create:cutting/compat/tconstruct/skyroot_wood" | "chipped_express:stonecutting_chipped_carved_granite_from_granite" | "botania:mana_infusion/red_tulip_to_orange_tulip" | "minecraft:dye_orange_wool" | "moa_decor_cookery:aroblesc_1" | "chipped_express:stonecutting_chipped_happy_soul_sand_from_soul_sand" | "botania:quartz_lavender" | "moa_decor_holidays:tumbaesqueleto_1" | "create:cutting/compat/biomesoplenty/magic_log" | "mcwtrpdoors:warped_ranch_trapdoor" | "pamhc2foodextended:chickencelerycasseroleitem" | "botanypots:minecraft/soil/mycelium" | "pamhc2foodcore:cookingoilitem_x2_nuts" | "meadow:emerald_from_smelting_alpine_emerald_ore" | "biomesoplenty:umbran_boat" | "botania:stonecutting/metamorphic_forest_cobblestone_to_metamorphic_forest_cobblestone_wall" | "chipped_express:stonecutting_chipped_inlayed_sandstone_from_sandstone" | "chipped_express:stonecutting_chipped_mud_bricks_pillar_from_mud_bricks" | "botania:dye_light_gray" | "compressedblocks:shaped_c6_waxed_weathered_cut_copper" | "create:crafting/materials/copper_nugget" | "chipped_express:stonecutting_chipped_pressed_crimson_door_from_crimson_door" | "mcwwindows:stripped_dark_oak_log_four_window" | "corail_woodcutter:woodcutting/birch_fence_from_birch_logs" | "farmersdelight:cooking/pumpkin_soup" | "createdeco:short_umber_brick_slab_from_umber_brick_slab_stonecutting" | "createdeco:long_blue_bricks_from_short_blue_bricks_stonecutting" | "chipped_express:stonecutting_chipped_ornate_lime_stained_glass_pane_from_lime_stained_glass_pane" | "macawsroofsbop:fir_planks_steep_roof" | "chipped_express:stonecutting_chipped_cross_haired_brown_carpet_from_brown_carpet" | "minecraft:dye_yellow_wool" | "railways:sequenced_assembly/track_cherry_narrow" | "compressedblocks:shaped_triple_crated_light_blue_dye" | "compressedblocks:shapeless_c7_stripped_acacia_log" | "botania:mana_infusion/clay_deconstruct" | "cosmeticarmoursmod:red_sock_skirt_2_plaid" | "railways:sequenced_assembly/track_byg_jacaranda" | "createdeco:verdant_brick_stairs_from_tiled_verdant_brick_stairs_stonecutting" | "botania:petal_apothecary/bellethorn" | "chipped_express:stonecutting_chipped_trodden_ice_from_ice" | "botania:pure_daisy/livingwood" | "botania:slab_recombine/metamorphic_swamp_bricks" | "mcwfurnitures:stripped_mangrove_chair" | "chipped_express:stonecutting_chipped_vertical_cut_deepslate_from_deepslate" | "compressedblocks:shaped_c0_waxed_oxidized_copper" | "chipped_express:stonecutting_chipped_tiny_layered_lodestone_slabs_from_lodestone" | "brewery:potato_salad" | "minecraft:lectern" | "create:cutting/compat/byg/redwood_log" | "herbalbrews:kettle_brewing/green_tea" | "createdeco:light_gray_shipping_container_from_dyeing_vaults" | "pamhc2foodextended:deluxecheeseburgeritem" | "mcwroofs:lime_terracotta_upper_steep_roof" | "chipped_express:stonecutting_chipped_fancy_white_redstone_lamp_from_redstone_lamp" | "chipped_express:stonecutting_chipped_glad_lapis_block_from_lapis_block" | "chipped_express:stonecutting_chipped_i_sign_stripped_cherry_log_from_stripped_cherry_log" | "chipped_express:stonecutting_chipped_crafted_orange_carpet_from_orange_carpet" | "chipped_express:stonecutting_chipped_wickered_orange_wool_from_orange_wool" | "sophisticatedstorage:bamboo_chest_from_quark_bamboo_chest" | "chipped_express:stonecutting_chipped_barred_birch_trapdoor_from_birch_trapdoor" | "chipped:benches/carpenters_table" | "chipped_express:stonecutting_chipped_versailles_acacia_planks_from_acacia_planks" | "create:milling/beetroot" | "botania:cosmetic_groucho_glasses" | "quark:tweaks/crafting/utility/wool/blue_wool" | "compressedblocks:shaped_mega_crated_chorus_fruit" | "framedblocks:framed_flat_stacked_slope_panel_corner_rotate_to_framed_flat_stacked_slope_slab_corner" | "compressedblocks:shapeless_c3_gold_ore" | "compressedblocks:shapeless_crated_glass_bottle" | "chipped_express:stonecutting_chipped_paved_light_gray_glazed_terracotta_from_light_gray_glazed_terracotta" | "botania:stonecutting/metamorphic_taiga_stone_to_metamorphic_taiga_bricks_stairs" | "conditional:regions_unexplored/wood_cutter/magnolia_sign_woodcutter" | "compressedblocks:shapeless_c1_sandstone" | "botanypots:biomesoplenty/soil/black_sand" | "pamhc2foodextended:spaghettidinneritem" | "chipped_express:stonecutting_chipped_triangular_magenta_terracotta_from_magenta_terracotta" | "chipped_express:stonecutting_chipped_reinforced_waxed_exposed_copper_from_waxed_exposed_copper" | "aquaculture:heavy_hook" | "compressedblocks:shaped_c4_mud" | "botanypots:pamhc2crops/crop/wolfberry" | "compressedblocks:shaped_quadruple_crated_powered_rail" | "corail_woodcutter:woodcutting/biomesoplenty/fir_button_from_fir_planks" | "mcwwindows:acacia_window" | "pamhc2foodextended:chocolatecoconutbaritem" | "compressedblocks:shapeless_octuple_crated_cocoa_beans" | "mcwbridges:prismarine_bricks_bridge" | "create:cutting/compat/tconstruct/bloodshroom_wood" | "compressedblocks:shapeless_mega_crated_cooked_beef" | "quark:building/crafting/stonevariants/shale_bricks" | "mcwfurnitures:oak_chair" | "snowyspirit:gumdrop_yellow" | "mcwwindows:stripped_crimson_stem_four_window" | "bakery:deepslate_stove" | "botania:cyan_shiny_flower" | "quark:building/crafting/jungle_ladder" | "createdeco:pressing/coins/gold_coin" | "framedblocks:framed_iron_gate" | "compressedblocks:shaped_mega_crated_porkchop" | "chipped_express:stonecutting_chipped_tiny_brick_bordered_amethyst_block_from_amethyst_block" | "createaddition:crafting/portable_energy_interface" | "quark:building/crafting/chests/birch_trapped_chest" | "chipped_express:stonecutting_chipped_cross_haired_magenta_wool_from_magenta_wool" | "compressedblocks:shapeless_octuple_crated_red_carpet" | "compressedblocks:shapeless_quadruple_crated_torch" | "createdeco:andesite_catwalk_railing_forge" | "botania:dodge_ring" | "meadow:shutter_block_poppy" | "chipped_express:stonecutting_chipped_windowed_birch_trapdoor_from_birch_trapdoor" | "compressedblocks:shapeless_double_crated_glistering_melon_slice" | "chipped_express:stonecutting_chipped_rectangle_brown_carpet_from_brown_carpet" | "quark:world/crafting/stairs/jasper_bricks_stairs" | "compressedblocks:shapeless_quintuple_crated_brown_carpet" | "compressedblocks:shaped_triple_crated_lantern" | "chipped_express:stonecutting_chipped_vertical_cut_quartz_block_from_quartz_block" | "chipped_express:stonecutting_chipped_suspicious_bamboo_trapdoor_from_bamboo_trapdoor" | "comforts:hammock_to_red" | "create:oxidized_copper_shingle_stairs" | "moa_decor_bath:c_tverdeslima_1" | "luphieclutteredmod:luphie_white_left_outer_corner_counter_recipe_alt" | "chipped_express:stonecutting_chipped_ribbled_pink_carpet_from_pink_carpet" | "cosmeticarmoursmod:steampunk_goggles_rec" | "railways:sequenced_assembly/track_create_dd_rose_wide" | "meadow:can" | "railways:crafting/palettes/dyeing_8x/purple_locometal_boiler" | "botania:slab_recombine/livingrock_bricks" | "quark:world/stonecutting/stairs/permafrost_bricks_stairs_stonecutter2" | "chipped_express:stonecutting_chipped_tiled_bordered_diorite_from_diorite" | "aquaculture:neptunium_nugget" | "compressedblocks:shapeless_quadruple_crated_orange_dye" | "mcwfurnitures:stripped_warped_chair" | "compressedblocks:shaped_quintuple_crated_clay_ball" | "chipped_express:stonecutting_chipped_small_purpur_block_bricks_from_purpur_block" | "meadow:cooking_pot/cooked_beef" | "botania:mana_infusion/acacia_leaves_dupe" | "chipped_express:stonecutting_chipped_tiled_bordered_clay_from_clay" | "brewery:pork_knuckle" | "compressedblocks:shaped_double_crated_cooked_cod" | "chipped_express:stonecutting_chipped_vertical_cut_raw_gold_block_from_raw_gold_block" | "chipped_express:stonecutting_chipped_brick_bordered_tuff_from_tuff" | "farmersdelight:green_canvas_sign" | "immersive_aircraft:propeller" | "quark:building/crafting/slabs/pink_shingles_slab" | "snowyspirit:glow_lights_white" | "supplementaries:blackboard" | "moa_decor_holidays:globos_morado_1" | "minecraft:andesite_wall" | "compressedblocks:shapeless_crated_light_gray_carpet" | "botanypots:pamhc2crops/crop/cabbage" | "moa_decor_garden_:carretilla_arena_1" | "createdeco:mossy_blue_bricks_from_moss_block" | "chipped_express:stonecutting_chipped_windmill_magenta_carpet_from_magenta_carpet" | "compressedblocks:shaped_c4_netherrack" | "minecraft:raiser_armor_trim_smithing_template_smithing_trim" | "luphieclutteredmod:flowering_pink_planks_wood_alt_recipe" | "chipped_express:stonecutting_chipped_thin_mangrove_roots_from_mangrove_roots" | "create:compat/byg/milling/cyan_amaranth" | "mcwroofs:jungle_planks_upper_lower_roof" | "quark:building/crafting/compressed/cactus_block_uncompress" | "beachparty:hammock" | "compressedblocks:shaped_double_crated_pink_tulip" | "chipped_express:stonecutting_chipped_cracked_flat_dirt_tiles_from_dirt" | "compressedblocks:shapeless_c7_iron_ore" | "compressedblocks:shaped_double_crated_beetroot_seeds" | "toms_storage:crafting_terminal" | "compressedblocks:shaped_c7_raw_copper_block" | "quark:building/crafting/light_blue_stool" | "quark:tweaks/crafting/utility/chest_boat/direct_birch_chest_boat" | "mcwdoors:bamboo_bark_glass_door" | "create:compat/silentsgems/crushing/cats_eye_ore" | "botanypots:minecraft/pot_interaction/till_coarse_dirt_to_dirt" | "railways:mechanical_crafting/green_brass_wrapped_locometal_boiler" | "chipped_express:stonecutting_chipped_orange_glazed_terracotta_tiles_from_orange_glazed_terracotta" | "moa_decor_toys:hoglin_1" | "biomesoplenty:orange_sandstone_slab" | "mcwfurnituresbop:umbran_modern_chair" | "conditional:regions_unexplored/wood_cutter/brimwood_sign_woodcutter" | "farmersdelight:cooked_bacon_from_campfire_cooking" | "botania:dreamwood_fence_gate" | "chipped_express:stonecutting_chipped_unamused_basalt_from_basalt" | "compressedblocks:shaped_quintuple_crated_seagrass" | "chipped_express:stonecutting_chipped_cornered_blue_carpet_from_blue_carpet" | "chipped_express:stonecutting_chipped_stop_pink_concrete_from_pink_concrete" | "compressedblocks:shapeless_giga_crated_pink_dye" | "chipped_express:stonecutting_chipped_checkered_raw_copper_block_tiles_from_raw_copper_block" | "chipped_express:stonecutting_chipped_cracked_disordered_packed_ice_bricks_from_packed_ice" | "moa_decor_garden_:bancacerezo_1" | "pamhc2foodextended:strawberryjellytoastitem" | "compressedblocks:shaped_mega_crated_golden_apple" | "moa_decor_cookery:licuadora_1" | "create:polished_cut_veridium_from_stone_types_veridium_stonecutting" | "vinery:seed_from_red_jungle_grape" | "moa_decor_science:globoterraqueo_1" | "compressedblocks:shaped_septuple_crated_cobweb" | "gemsnjewels:forge_ametrine_set_gold_ring" | "supplementaries:compressedblocks/sign_post_c3_jungle" | "createdeco:tiled_verdant_brick_slab_from_tiled_verdant_bricks_stonecutting" | "botania:mana_infusion/oak_sapling_to_spruce_sapling" | "comforts:sleeping_bag_purple" | "mcwroofs:gutter_base_red" | "quark:building/crafting/vertslabs/black_shingles_vertical_slab" | "snowyspirit:compressedblocks/sled_c3_dark_oak" | "chipped_express:stonecutting_chipped_spiraled_coal_block_from_coal_block" | "snowyspirit:bloomingnature/sled_aspen" | "moa_decor_cookery:arobleoscsc_1" | "compressedblocks:shapeless_c3_waxed_oxidized_copper" | "moa_decor_garden_:jaula_pdorada_1" | "domesticationinnovation:pet_bed_blue" | "chipped_express:stonecutting_chipped_natural_acacia_planks_from_acacia_planks" | "chipped_express:stonecutting_chipped_stacked_magenta_concrete_from_magenta_concrete" | "minecraft:warped_trapdoor" | "chipped_express:stonecutting_chipped_ribbled_red_wool_from_red_wool" | "luphieclutteredmod:luphie_black_counter_recipe" | "railways:sequenced_assembly/track_mangrove" | "candlelight:birch_chair" | "create:crafting/kinetics/fluid_pipe_vertical" | "chipped_express:stonecutting_chipped_crying_crimson_stem_from_crimson_stem" | "mcwfences:sandstone_pillar_wall" | "compressedblocks:shaped_sextuple_crated_charcoal" | "moa_decor_cookery:soportetazas_1" | "create:cutting/compat/byg/fir_wood" | "quark:building/crafting/compressed/apple_crate" | "compressedblocks:shaped_c6_chiseled_red_sandstone" | "botanypots:botanypots/crafting/blue_concrete_compact_hopper_botany_pot" | "corail_woodcutter:woodcutting/mangrove_pressure_plate_from_mangrove_logs" | "botania:livingrock_bricks_stairs" | "create:cut_diorite_bricks_from_stone_types_diorite_stonecutting" | "compressedblocks:shaped_octuple_crated_peony" | "mcwfurnitures:acacia_end_table" | "supplementaries:hourglass" | "macawsroofsbop:redwood_planks_roof" | "compressedblocks:shaped_c0_weathered_copper" | "framedblocks:framed_flat_elev_slope_slab_corner" | "createdeco:zinc_door" | "chipped_express:stonecutting_chipped_stop_cyan_concrete_from_cyan_concrete" | "compressedblocks:shaped_giga_crated_beetroot_seeds" | "railways:mechanical_crafting/white_locometal_boiler" | "moa_decor_toys:caballocafe_r_1" | "compressedblocks:shaped_octuple_crated_lightning_rod" | "compressedblocks:shaped_c5_cherry_planks" | "beachparty:table" | "quark:building/stonecutting/vertslabs/brick_vertical_slab_stonecutter" | "railways:crafting/palettes/dyeing_1x/yellow_iron_wrapped_locometal_boiler" | "chipped_express:stonecutting_chipped_golden_barred_birch_trapdoor_from_birch_trapdoor" | "create:cut_diorite_stairs" | "mcwfurnituresbop:jacaranda_stool_chair" | "luphieclutteredmod:luphie_decorative_mushroom_block_recipe" | "chipped_express:stonecutting_chipped_crossed_blue_terracotta_from_blue_terracotta" | "compressedblocks:shapeless_c6_red_sandstone" | "create:crushing/deepslate_lapis_ore" | "luphieclutteredmod:green_wood_recipe" | "compressedblocks:shapeless_c2_cut_sandstone" | "compressedblocks:shaped_c9_gold_block" | "botania:stonecutting/mossy_livingrock_bricks_to_mossy_livingrock_bricks_slab" | "chipped_express:stonecutting_chipped_embossed_emerald_block_from_emerald_block" | "compressedblocks:shapeless_octuple_crated_bone" | "compressedblocks:shapeless_octuple_crated_book" | "conditional:create/mixing/white_savanna_grape_juice_mixing" | "mcwdoors:acacia_modern_door" | "chipped_express:stonecutting_chipped_offset_gilded_blackstone_bricks_from_gilded_blackstone" | "storagedrawers:warped_trim" | "compressedblocks:shaped_octuple_crated_stick" | "compressedblocks:shapeless_c0_soul_sand" | "compressedblocks:shaped_quintuple_crated_beetroot_seeds" | "chipped_express:stonecutting_chipped_cracked_snow_block_bricks_from_snow_block" | "sophisticatedstorage:limited_gold_barrel_1" | "sophisticatedstorage:limited_gold_barrel_2" | "railways:sequenced_assembly/track_byg_palm_narrow" | "sophisticatedstorage:limited_gold_barrel_3" | "sophisticatedstorage:limited_gold_barrel_4" | "quark:building/stonecutting/slabs/magenta_shingles_slab_stonecutter2" | "chipped_express:stonecutting_chipped_speckled_warped_wart_block_from_warped_wart_block" | "luphieclutteredmod:luphie_confectionary_table_b_recipe" | "compressedblocks:shaped_giga_crated_paper" | "compressedblocks:shapeless_triple_crated_green_dye" | "pamhc2crops:artichokeseeditem" | "createdeco:umber_brick_slab_from_long_umber_brick_slab_stonecutting" | "corail_woodcutter:woodcutting/acacia_fence_from_acacia_logs" | "create:splashing/stained_glass" | "chipped_express:stonecutting_chipped_rectangle_light_blue_wool_from_light_blue_wool" | "quark:building/crafting/vertslabs/magenta_shingles_vertical_slab_revert" | "cosmeticarmoursmod:white_skirt_2_purple" | "meadow:lapis_lazuli_from_blasting_alpine_lapis_ore" | "chipped_express:stonecutting_chipped_massive_calcite_bricks_from_calcite" | "create:crafting/kinetics/large_water_wheel" | "botania:stonecutting/metamorphic_mountain_stone_to_metamorphic_mountain_bricks_stairs" | "compressedblocks:shaped_quadruple_crated_spectral_arrow" | "create:polished_cut_limestone_stairs_from_stone_types_limestone_stonecutting" | "farmersdelight:cutting_board" | "luphieclutteredmod:purpleplankrecipe" | "botania:elf_quartz_pillar" | "chipped_express:stonecutting_chipped_unamused_raw_copper_block_from_raw_copper_block" | "mcwfurnitures:mangrove_wardrobe" | "botanypots:pamhc2crops/crop/nopales" | "railways:sequenced_assembly/track_byg_embur_wide" | "minecraft:note_block" | "compressedblocks:shaped_c1_soul_sand" | "chipped_express:stonecutting_chipped_stop_orange_concrete_from_orange_concrete" | "railways:crafting/palettes/dyeing_8x/light_blue_iron_wrapped_locometal_boiler" | "mcwfurnituresbop:jacaranda_cupboard_counter" | "quark:building/crafting/vertslabs/brown_shingles_vertical_slab_revert" | "supplementaries:compressedblocks/sign_post_c3_cherry" | "chipped_express:stonecutting_chipped_crated_acacia_planks_from_acacia_planks" | "compressedblocks:shapeless_crated_red_carpet" | "compressedblocks:shaped_c6_oak_log" | "botanypots:minecraft/crop/cocoa_beans" | "compressedblocks:shapeless_sextuple_crated_gray_dye" | "mcwroofs:warped_planks_top_roof" | "compressedblocks:shapeless_triple_crated_light_blue_carpet" | "chipped_express:stonecutting_chipped_layed_magma_block_bricks_from_magma_block" | "compressedblocks:shaped_mega_crated_item_frame" | "chipped_express:stonecutting_chipped_rough_end_stone_from_end_stone" | "mcwfurnituresbop:hellbark_wardrobe" | "chipped_express:stonecutting_chipped_runic_carved_redstone_block_from_redstone_block" | "minecraft:weathered_cut_copper_slab_from_weathered_copper_stonecutting" | "mcwroofs:cobblestone_attic_roof" | "compressedblocks:shaped_crated_blue_carpet" | "compressedblocks:shaped_quadruple_crated_cyan_dye" | "chipped_express:stonecutting_chipped_screen_oak_door_from_oak_door" | "mcwbridges:dry_bamboo_bridge_stair" | "minecraft:shulker_box" | "botania:chiseled_metamorphic_desert_bricks" | "compressedblocks:shaped_double_crated_sunflower" | "createdeco:red_iron_lamp" | "compressedblocks:shaped_double_crated_lime_carpet" | "mcwroofs:white_terracotta_lower_roof" | "handcrafted:brown_cushion" | "compressedblocks:shapeless_quintuple_crated_beetroot" | "luphieclutteredmod:luphie_mini_hanging_terrariums_recipe" | "mcwdoors:jungle_four_panel_door" | "compressedblocks:shaped_octuple_crated_cherry_sapling" | "pamhc2foodextended:batteredsausageitem" | "compressedblocks:shapeless_c2_redstone_ore" | "quark:building/crafting/thatch_revert" | "create:blasting/nickel_ingot_compat_thermal" | "candlelight:dark_oak_big_table" | "mcwfurnitures:stripped_birch_desk" | "bloomingnature:baobab_fence" | "compressedblocks:shapeless_c2_cobblestone" | "compressedblocks:shapeless_triple_crated_beetroot_seeds" | "luphieclutteredmod:luphie_office_box_recipe" | "compressedblocks:shaped_double_crated_pink_carpet" | "moa_decor_holidays:papelpicado_lima_1" | "compressedblocks:shaped_octuple_crated_magenta_carpet" | "fairylights:witch_light" | "chipped_express:stonecutting_chipped_spiraled_raw_gold_block_from_raw_gold_block" | "cosmeticarmoursmod:purple_sock_skirt_2_white" | "chipped_express:stonecutting_chipped_shrunken_light_gray_glazed_terracotta_from_light_gray_glazed_terracotta" | "botania:metamorphic_taiga_bricks_stairs" | "compressedblocks:shaped_octuple_crated_orange_tulip" | "sophisticatedstorage:iron_to_diamond_tier_upgrade" | "railways:crafting/palettes/dyeing_1x/brown_riveted_locometal" | "minecraft:magenta_stained_glass" | "botanypots:pamhc2crops/crop/sweetpotato" | "railways:crafting/palettes/dyeing_8x/gray_locometal_pillar" | "compressedblocks:shapeless_c7_exposed_copper" | "minecraft:iron_trapdoor" | "compressedblocks:shaped_c9_diorite" | "moa_decor_holidays:banderines_azul_claro_1" | "compressedblocks:shaped_quadruple_crated_rabbit_hide" | "pamhc2foodextended:raisinsitem" | "mcwfurnituresbop:redwood_cupboard_counter" | "corail_woodcutter:woodcutting/mangrove_fence_gate_from_mangrove_logs" | "chipped_express:stonecutting_chipped_creeper_calcite_carving_from_calcite" | "chipped_express:stonecutting_chipped_inscribed_light_blue_terracotta_from_light_blue_terracotta" | "compressedblocks:shaped_quintuple_crated_painting" | "moa_decor_art:aerosolnegro_1" | "quark:building/stonecutting/vertslabs/calcite_vertical_slab_stonecutter" | "mcwfurnitures:stripped_crimson_double_drawer_counter" | "compressedblocks:shapeless_octuple_crated_vine" | "chipped_express:stonecutting_chipped_screen_dark_oak_door_from_dark_oak_door" | "create:compat/silentsgems/crushing/moldavite_ore" | "botania:stonecutting/corporea_block_to_corporea_slab" | "chipped_express:stonecutting_chipped_cracked_flat_magma_block_tiles_from_magma_block" | "createaddition:rolling/brass_ingot" | "chipped_express:stonecutting_chipped_planked_warped_stem_from_warped_stem" | "moa_decor_bath:jabonera_1" | "chipped_express:stonecutting_chipped_flowering_jungle_log_from_jungle_log" | "pamhc2foodextended:picklesitem" | "compressedblocks:shaped_c6_oxidized_copper" | "compressedblocks:shapeless_c5_exposed_copper" | "refinedstorage:crafting_grid/light_gray_crafting_grid" | "compressedblocks:shapeless_c1_cut_copper" | "minecraft:deepslate_brick_stairs_from_deepslate_bricks_stonecutting" | "chipped_express:stonecutting_chipped_angry_basalt_from_basalt" | "playershops:acacia_player_shop" | "botanypots:botanypots/crafting/yellow_concrete_botany_pot" | "create:filling/compat/farmersdelight/milk_bottle" | "chipped_express:stonecutting_chipped_white_terracotta_column_from_white_terracotta" | "minecraft:light_gray_wool" | "chipped_express:stonecutting_chipped_pressed_waxed_copper_block_from_waxed_copper_block" | "chipped_express:stonecutting_chipped_stacked_netherite_block_from_netherite_block" | "mcwlights:acacia_tiki_torch" | "compressedblocks:shaped_octuple_crated_amethyst_shard" | "chipped_express:stonecutting_chipped_trodden_dirt_from_dirt" | "biomesoplenty:mahogany_door" | "chipped_express:stonecutting_chipped_arched_light_gray_stained_glass_pane_pillar_from_light_gray_stained_glass_pane" | "mcwwindows:stripped_warped_stem_window" | "quark:world/crafting/waxed_black_corundum" | "railways:sequenced_assembly/track_tfc_acacia_wide" | "framedblocks:framing_saw/framed_chest" | "compressedblocks:shapeless_mega_crated_chicken" | "minecraft:shulker_box_from_vanilla_shulker_box" | "chipped_express:stonecutting_chipped_unamused_raw_gold_block_from_raw_gold_block" | "compressedblocks:shapeless_c5_iron_block" | "chipped_express:stonecutting_chipped_inlayed_amethyst_block_from_amethyst_block" | "chipped_express:stonecutting_chipped_cornered_magenta_carpet_from_magenta_carpet" | "create:compat/botania/milling/light_gray_petal" | "compressedblocks:shaped_c7_lapis_block" | "corail_woodcutter:woodcutting/oak_pressure_plate_from_oak_logs" | "mcwfences:oak_horse_fence" | "botania:cosmetic_red_glasses" | "chipped_express:stonecutting_chipped_thick_inlayed_gilded_blackstone_from_gilded_blackstone" | "mcwfurnitures:stripped_cherry_double_drawer" | "mcwfences:blackstone_pillar_wall" | "chipped_express:stonecutting_chipped_layered_netherite_block_from_netherite_block" | "compressedblocks:shapeless_septuple_crated_redstone_torch" | "botanypots:pamhc2crops/crop/millet" | "quark:building/stonecutting/vertslabs/rusty_iron_plate_vertical_slab_stonecutter" | "chipped_express:stonecutting_chipped_cubed_lime_wool_from_lime_wool" | "chipped_express:stonecutting_chipped_fine_packed_mud_pillar_from_packed_mud" | "supplementaries:biomesoplenty/sign_post_palm" | "railways:sequenced_assembly/track_twilightforest_minewood_wide" | "create:cutting/compat/ars_nouveau/green_archwood_log" | "mcwtrpdoors:dark_oak_ranch_trapdoor" | "bloomingnature:ebony_sign" | "botania:drum_wild" | "luphieclutteredmod:luphie_cat_counter_a_recipe" | "chipped_express:stonecutting_chipped_etched_deepslate_bricks_from_deepslate" | "chipped_express:stonecutting_chipped_tile_windowed_birch_door_from_birch_door" | "mcwfurnitures:cherry_lower_bookshelf_drawer" | "minecraft:lime_banner" | "railways:sequenced_assembly/track_byg_redwood_narrow" | "createdeco:short_pearl_brick_stairs_from_tiled_pearl_bricks_stonecutting" | "chipped_express:stonecutting_chipped_small_lime_stained_glass_from_lime_stained_glass" | "aquaculture:tackle_box" | "chipped_express:stonecutting_chipped_leafy_spruce_trapdoor_from_spruce_trapdoor" | "handcrafted:cherry_table" | "refinedstorage:coloring_recipes/yellow_pattern_grid" | "minecraft:deepslate_brick_wall_from_cobbled_deepslate_stonecutting" | "chipped_express:stonecutting_chipped_cracked_flat_lodestone_tiles_from_lodestone" | "minecraft:cut_copper_from_copper_block_stonecutting" | "mcwlights:green_ceiling_light" | "copycats:crafting/copycat_step_from_conversion" | "chipped_express:stonecutting_chipped_fine_soul_sand_from_soul_sand" | "create:cutting/compat/biomesoplenty/fir_log" | "mcwdoors:warped_classic_door" | "mcwfurnituresbop:jacaranda_table" | "chipped_express:stonecutting_chipped_decorated_gray_terracotta_from_gray_terracotta" | "meadow:wood_cutter/mangrove/mangrove_sign_woodcutter" | "farmersdelight:cabbage_crate" | "compressedblocks:shapeless_crated_rabbit_hide" | "chipped_express:stonecutting_chipped_spider_purpur_block_carving_from_purpur_block" | "nethervinery:crimson_wine_rack_big" | "moa_decor_science:biombommagenta_1" | "chipped_express:stonecutting_chipped_woven_yellow_stained_glass_from_yellow_stained_glass" | "botanypots:minecraft/pot_interaction/till_farmland" | "macawsroofsbop:magic_lower_roof" | "compressedblocks:shaped_c6_end_stone" | "chipped_express:stonecutting_chipped_cyan_concrete_bricks_from_cyan_concrete" | "quark:world/stonecutting/walls/shale_bricks_wall_stonecutter" | "quark:building/stonecutting/slabs/blue_shingles_slab_stonecutter" | "compressedblocks:shaped_c4_sand" | "chipped_express:stonecutting_chipped_lodestone_pillar_top_from_lodestone" | "railways:crafting/palettes/wrapping/cyan_iron_wrapped_locometal" | "mcwfurnituresbop:dead_glass_table" | "chipped_express:stonecutting_chipped_dual_paneled_oak_door_from_oak_door" | "compressedblocks:shaped_c7_oak_planks" | "mcwfurnituresbop:willow_large_drawer" | "bakery:baking_station/apple_cupcake" | "candlelight:mangrove_shelf" | "snowyspirit:glow_lights_green" | "chipped_express:stonecutting_chipped_natural_oak_planks_from_oak_planks" | "fairylights:orb_lantern" | "compressedblocks:shapeless_c6_spruce_planks" | "mcwlights:glowstone_slab" | "mcwfurnituresbop:jacaranda_bookshelf" | "nethervinery:warped_grape_crate" | "compressedblocks:shaped_c0_waxed_copper_block" | "chipped_express:stonecutting_chipped_runic_carved_magma_block_from_magma_block" | "mcwlights:soul_acacia_tiki_torch" | "minecraft:crimson_sign" | "chipped_express:stonecutting_chipped_flat_diorite_tiles_from_diorite" | "railways:sequenced_assembly/track_byg_maple" | "chipped_express:stonecutting_chipped_eroded_prismarine_from_prismarine" | "corail_woodcutter:woodcutting/oak_fence_from_oak_logs" | "quark:building/crafting/vertslabs/mangrove_vertical_slab" | "mcwlights:purple_paper_lamp" | "moa_decor_toys:vex_1" | "minecraft:stone_brick_slab" | "create:cutting/compat/byg/palo_verde_wood" | "railways:sequenced_assembly/track_quark_blossom" | "bakery:pot_cooking/pudding" | "chipped_express:stonecutting_chipped_overlapping_raw_copper_block_tiles_from_raw_copper_block" | "quark:building/stonecutting/vertslabs/orange_shingles_vertical_slab_stonecutter" | "chipped_express:stonecutting_chipped_smooth_inlayed_dripstone_block_from_dripstone_block" | "botanypots:farming_crossing/crop/pamhc2treesgooseberry_sapling" | "pamhc2foodextended:cactussoupitem" | "minecraft:stone_slab_from_stone_stonecutting" | "mcwroofs:cherry_roof" | "minecraft:white_sheet_from_white_dye" | "compressedblocks:shapeless_octuple_crated_purple_dye" | "compressedblocks:shaped_double_crated_gray_carpet" | "chipped_express:stonecutting_chipped_duh_raw_gold_block_from_raw_gold_block" | "botanypots:pamhc2crops/crop/spinach" | "compressedblocks:shapeless_septuple_crated_glass_bottle" | "compressedblocks:shapeless_quintuple_crated_crimson_fungus" | "mcwroofs:brown_concrete_upper_lower_roof" | "compressedblocks:shapeless_c5_clay" | "compressedblocks:shaped_quadruple_crated_gunpowder" | "compressedblocks:shapeless_triple_crated_golden_carrot" | "compressedblocks:shapeless_c7_cobbled_deepslate" | "chipped_express:stonecutting_chipped_nether_bricks_bricks_from_nether_bricks" | "corail_woodcutter:woodcutting/biomesoplenty/willow_trapdoor_from_willow_logs" | "compressedblocks:shaped_crated_glass_bottle" | "chipped_express:stonecutting_chipped_windmill_light_blue_carpet_from_light_blue_carpet" | "chipped_express:stonecutting_chipped_tripped_black_carpet_from_black_carpet" | "quark:building/stonecutting/vertslabs/light_blue_shingles_vertical_slab_stonecutter2" | "mcwtrpdoors:cherry_ranch_trapdoor" | "create:cutting/birch_log" | "chipped_express:stonecutting_chipped_bad_time_jack_o_lantern_from_jack_o_lantern" | "chipped_express:stonecutting_chipped_fine_bamboo_planks_from_bamboo_planks" | "mcwroofs:brown_concrete_top_roof" | "compressedblocks:shaped_triple_crated_oak_sapling" | "comforts:sleeping_bag_to_light_blue" | "playdate:rocking_horse" | "pamhc2foodextended:mangojellytoastitem" | "pamhc2trees:roastedcashewitem_forge" | "compressedblocks:shapeless_double_crated_chain" | "create:compat/druidcraft/milling/lavender" | "ecologics:cutting/azalea_wood" | "exoticbirds:egg_incubator" | "corail_woodcutter:woodcutting/biomesoplenty/umbran_button_from_umbran_planks" | "chipped_express:stonecutting_chipped_tiled_redstone_block_from_redstone_block" | "chipped_express:stonecutting_chipped_angry_dirt_from_dirt" | "compressedblocks:shaped_c7_stripped_birch_log" | "quark:building/crafting/lime_stool" | "createdeco:tiled_umber_bricks_from_umber_bricks_stonecutting" | "mcwfurnituresbop:hellbark_coffee_table" | "supplementaries:candle_holders/candle_holder_light_blue" | "supplementaries:goblet" | "mcwroofs:orange_concrete_upper_steep_roof" | "luphieclutteredmod:luphie_purple_iron_door_recipe" | "railways:crafting/palettes/dyeing_1x/purple_iron_wrapped_locometal_boiler" | "utilitix:utilitix_brewery/apple_juice" | "create:crafting/kinetics/gantry_shaft" | "chipped_express:stonecutting_chipped_paved_light_blue_glazed_terracotta_from_light_blue_glazed_terracotta" | "macawsroofsbop:fir_planks_attic_roof" | "pamhc2foodextended:grilledskewersitem" | "mcwfurnitures:mangrove_bookshelf_cupboard" | "delightful:cantaloupe_slice" | "moa_decor_toys:creeper_1" | "chipped_express:stonecutting_chipped_inlayed_red_nether_bricks_from_red_nether_bricks" | "chipped_express:stonecutting_chipped_duh_prismarine_from_prismarine" | "chipped_express:stonecutting_chipped_pillar_clay_bricks_from_clay" | "compressedblocks:shaped_octuple_crated_light_blue_dye" | "compressedblocks:shapeless_c4_red_nether_bricks" | "minecraft:lapis_lazuli" | "gemsnjewels:ornament_black_opal" | "chipped_express:stonecutting_chipped_pillar_coal_block_bricks_from_coal_block" | "chipped_express:stonecutting_chipped_patient_stripped_cherry_log_from_stripped_cherry_log" | "mcwwindows:stripped_mangrove_log_window2" | "compressedblocks:shapeless_c9_mangrove_planks" | "chipped_express:stonecutting_chipped_inscribed_blue_ice_from_blue_ice" | "createaddition:pressing/zinc_ingot" | "supplementaries:sign_post_birch" | "pamhc2foodcore:groundrabbititem" | "minecraft:quartz_block" | "compressedblocks:shapeless_c0_mangrove_planks" | "compressedblocks:shaped_septuple_crated_ender_pearl" | "moa_decor_toys:bruja_1" | "botania:corporea_spark_master" | "cosmeticarmoursmod:flower_crown_rec" | "luphieclutteredmod:steampunk_lamp_recipe" | "compressedblocks:shaped_c8_acacia_planks" | "compressedblocks:shapeless_c5_stone" | "chipped_express:stonecutting_chipped_ad_astra_pearlescent_froglight_from_pearlescent_froglight" | "compressedblocks:shapeless_c4_lapis_ore" | "chipped_express:stonecutting_chipped_mud_scales_from_mud" | "botania:sunny_quartz_slab" | "botania:mana_infusion/beetroot_seeds_to_melon_seeds" | "chipped_express:stonecutting_chipped_knitted_white_wool_from_white_wool" | "compressedblocks:shaped_c6_dirt" | "luphieclutteredmod:blue_sand_seal_plush_recipe" | "create:deploying/waxed_oxidized_copper_tiles_from_adding_wax" | "botania:dye_gray" | "meadow:green_dye_from_small_fir" | "chipped_express:stonecutting_chipped_arched_light_blue_stained_glass_pane_pillar_from_light_blue_stained_glass_pane" | "compressedblocks:shaped_double_crated_spruce_sapling" | "compressedblocks:shaped_quintuple_crated_spruce_sapling" | "chipped_express:stonecutting_chipped_flat_blackstone_tiles_from_blackstone" | "compressedblocks:shaped_c6_cherry_planks" | "chipped_express:stonecutting_chipped_nailed_mangrove_log_from_mangrove_log" | "quark:building/crafting/vertslabs/lime_shingles_vertical_slab" | "create_central_kitchen:filling/dragon_breath_filling" | "chipped_express:stonecutting_chipped_vertical_disordered_snow_block_bricks_from_snow_block" | "corail_woodcutter:woodcutting/biomesoplenty/dead_door_from_dead_planks" | "chipped_express:stonecutting_chipped_glass_ochre_froglight_from_ochre_froglight" | "biomesoplenty:umbran_fence" | "minecraft:coast_armor_trim_smithing_template" | "minecraft:dune_armor_trim_smithing_template" | "chipped_express:stonecutting_chipped_dead_dark_oak_leaves_from_dark_oak_leaves" | "compressedblocks:shaped_triple_crated_powered_rail" | "pamhc2foodextended:walnutbutteritem" | "vinery:wine_fermentation/bolvar_wine" | "create:cut_veridium_stairs" | "mcwroofs:blue_terracotta_top_roof" | "compressedblocks:shaped_giga_crated_purple_carpet" | "chipped_express:stonecutting_chipped_small_raw_copper_block_bricks_from_raw_copper_block" | "framedblocks:framing_saw/framed_item_frame" | "compressedblocks:shapeless_crated_dandelion" | "chipped_express:stonecutting_chipped_arched_gray_stained_glass_pillar_from_gray_stained_glass" | "chipped_express:stonecutting_chipped_dual_paneled_bamboo_door_from_bamboo_door" | "chipped_express:stonecutting_chipped_blocky_magenta_wool_from_magenta_wool" | "chipped_express:stonecutting_chipped_chiseled_gray_terracotta_from_gray_terracotta" | "chipped_express:stonecutting_chipped_enclosed_crimson_planks_from_crimson_planks" | "mcwwindows:mangrove_shutter" | "quark:world/crafting/panes/black_corundum" | "cosmeticarmoursmod:red_top_2_white" | "pamhc2foodextended:chickentendersitem" | "chipped_express:stonecutting_chipped_inlayed_end_stone_from_end_stone" | "cookingforblockheads:toaster" | "pamhc2foodextended:zucchinibakeitem" | "chipped_express:stonecutting_chipped_fancy_sea_lantern_from_sea_lantern" | "quark:building/crafting/hollowlogs/hollow_mangrove_log" | "mcwroofs:oak_planks_lower_roof" | "chipped_express:stonecutting_chipped_fancy_chiseled_packed_mud_from_packed_mud" | "candlelight:mud_stove" | "gemsnjewels:create/create_crushing_peridot_ore" | "supplementaries:candy" | "quark:tweaks/smelting/raw_iron_bricks_smelt" | "delightful:knives/holystone_knife" | "chipped_express:stonecutting_chipped_unamused_dripstone_block_from_dripstone_block" | "compressedblocks:shaped_c9_gravel" | "biomesoplenty:jacaranda_slab" | "chipped_express:stonecutting_chipped_barred_pearlescent_froglight_from_pearlescent_froglight" | "mcwdoors:cherry_barn_glass_door" | "minecraft:polished_blackstone_brick_wall_from_polished_blackstone_bricks_stonecutting" | "compressedblocks:shapeless_octuple_crated_lilac" | "pamhc2foodextended:spinachpieitem" | "ars_nouveau:cutting/purple_archwood_log" | "botanypots:regions_unexplored/crop/tsubaki" | "compressedblocks:shaped_mega_crated_blue_orchid" | "chipped_express:stonecutting_chipped_lush_sponge_from_sponge" | "corail_woodcutter:woodcutting/dark_oak_trapdoor_from_dark_oak_planks" | "conditional:bloomingnature/wood_cutter/larch_slabs_woodcutter" | "create:small_asurine_brick_stairs" | "createdeco:zinc_support" | "meadow:mossy_limestone_brick_wall" | "conditional:create/mixing/chenet_wine_mixing" | "chipped_express:stonecutting_chipped_overgrown_warped_roots_from_warped_roots" | "bakery:jam_roll" | "botania:pure_daisy/sand" | "meadow:cheese_form/cheese" | "create:compat/atmospheric/cutting/grimwood_log" | "bloomingnature:dye_yellow_from_wild_sunflower" | "compressedblocks:shapeless_c5_stripped_jungle_log" | "compressedblocks:shapeless_mega_crated_cooked_porkchop" | "railways:dying_existing_cap_purple" | "macawsroofsbop:redwood_upper_steep_roof" | "constructionwand:dynamic/wand_upgrade" | "compressedblocks:shaped_c5_waxed_oxidized_cut_copper" | "compressedblocks:shaped_c9_honey_block" | "quark:building/crafting/stairs/dripstone_block_stairs" | "chipped_express:stonecutting_chipped_f_sign_stripped_spruce_log_from_stripped_spruce_log" | "chipped_express:stonecutting_chipped_cut_blank_purpur_block_from_purpur_block" | "cosmeticarmoursmod:royal_tunic_red_2_white" | "compressedblocks:shaped_septuple_crated_soul_torch" | "chipped_express:stonecutting_chipped_edged_amethyst_block_bricks_from_amethyst_block" | "moa_decor_lights:lm_grojo_1" | "compressedblocks:shapeless_quintuple_crated_bread" | "chipped_express:stonecutting_chipped_paper_jungle_door_from_jungle_door" | "biomesoplenty:magic_boat" | "chipped_express:stonecutting_chipped_tiny_brick_bordered_dark_prismarine_from_dark_prismarine" | "farmersdelight:cooking/beetroot_soup" | "luphieclutteredmod:luphie_black_shelf_cabinet_recipe" | "botania:cloud_pendant" | "compressedblocks:shapeless_c5_end_stone" | "pamhc2foodextended:pearyogurtitem" | "chipped_express:stonecutting_chipped_blocky_light_gray_carpet_from_light_gray_carpet" | "chipped_express:stonecutting_chipped_iron_bowl_soul_lantern_from_soul_lantern" | "corail_woodcutter:woodcutting/biomesoplenty/willow_pressure_plate_from_willow_planks" | "botania:lens_fire" | "mcwroofs:white_concrete_upper_steep_roof" | "quark:tweaks/crafting/green_glass" | "cosmeticarmoursmod:yellow_sock_plaid_2_skirt" | "chipped_express:stonecutting_chipped_light_freckled_brown_mushroom_block_from_brown_mushroom_block" | "refinedstorage:coloring_recipes/light_gray_detector" | "moa_decor_lights:lm_ncian_1" | "vinery:cherry_sign" | "railways:crafting/palettes/dyeing_8x/blue_flat_riveted_locometal" | "create:crushing/deepslate_gold_ore" | "chipped_express:stonecutting_chipped_loded_ice_from_ice" | "chipped_express:stonecutting_chipped_overgrown_mangrove_log_from_mangrove_log" | "create:compat/silentsgems/crushing/spinel_ore" | "quark:building/stonecutting/slabs/red_shingles_slab_stonecutter" | "meadow:mossy_cobbled_limestone_wall" | "chipped_express:stonecutting_chipped_heavy_birch_door_from_birch_door" | "railways:sequenced_assembly/orange_conductor_cap" | "mcwfurnitures:stripped_acacia_stool_chair" | "supplementaries:sugar_cube" | "copycats:crafting/copycat_block_from_slabs" | "handcrafted:crimson_nightstand" | "conditional:regions_unexplored/wood_cutter/willow_sign_woodcutter" | "compressedblocks:shaped_octuple_crated_black_dye" | "railways:crafting/palettes/wrapping/green_iron_wrapped_locometal" | "compressedblocks:shapeless_c8_soul_sand" | "compressedblocks:shaped_c1_mangrove_log" | "chipped_express:stonecutting_chipped_checkered_smooth_stone_tiles_from_smooth_stone" | "botania:brew/clear" | "quark:building/stonecutting/stairs/light_gray_shingles_stairs_stonecutter" | "compressedblocks:shaped_c7_stripped_oak_log" | "farmersdelight:cutting/cherry_hanging_sign" | "chipped_express:stonecutting_chipped_carved_ancient_debris_from_ancient_debris" | "chipped_express:stonecutting_chipped_black_glazed_terracotta_tiles_from_black_glazed_terracotta" | "minecraft:exposed_cut_copper_stairs" | "compressedblocks:shaped_quadruple_crated_allium" | "bakery:small_cooking_pot" | "chipped_express:stonecutting_chipped_offset_nether_bricks_bricks_from_nether_bricks" | "railways:crafting/palettes/dyeing_8x/white_brass_wrapped_locometal" | "chipped_express:stonecutting_chipped_bordered_granite_from_granite" | "minecraft:stripped_mangrove_wood" | "chipped_express:stonecutting_chipped_cracked_flat_amethyst_block_tiles_from_amethyst_block" | "railways:sequenced_assembly/magenta_conductor_cap" | "minecraft:light_weighted_pressure_plate" | "beachparty:tiki_bar_mixing/sweetberries_cocktail" | "mcwtrpdoors:jungle_mystic_trapdoor" | "refinedstorage:coloring_recipes/network_transmitter" | "minecraft:dye_green_wool" | "moa_decor_lights:faroltriple_b_1" | "bloomingnature:fir_wood" | "compressedblocks:shaped_c8_stripped_birch_log" | "compressedblocks:shaped_mega_crated_glowstone_dust" | "luphieclutteredmod:luphie_black_cabinet_recipe" | "pamhc2foodcore:scrambledeggitem" | "create:crafting/appliances/netherite_diving_helmet" | "gemsnjewels:light_stone_sapphire" | "chipped_express:stonecutting_chipped_brick_bordered_packed_mud_from_packed_mud" | "create:cut_crimsite_stairs_from_stone_types_crimsite_stonecutting" | "sophisticatedbackpacks:diamond_backpack" | "compressedblocks:shaped_c9_weathered_copper" | "compressedblocks:shapeless_mega_crated_weeping_vines" | "chipped_express:stonecutting_chipped_loded_packed_ice_from_packed_ice" | "chipped_express:stonecutting_chipped_scaled_purple_carpet_from_purple_carpet" | "luphieclutteredmod:luphie_pink_mini_cabinet_recipe" | "minecraft:pink_banner" | "chipped_express:stonecutting_chipped_creeper_coal_block_carving_from_coal_block" | "create:polished_cut_granite_stairs_from_stone_types_granite_stonecutting" | "chipped_express:stonecutting_chipped_vertical_cut_clay_from_clay" | "botanypots:biomesoplenty/crop/huge_clover_petal" | "quark:building/crafting/vertslabs/crimson_vertical_slab" | "mcwfurnitures:spruce_chair" | "compressedblocks:shaped_crated_flint" | "candlelight:jungle_shelf" | "create:cut_deepslate_slab_recycling" | "railways:mechanical_crafting/red_iron_wrapped_locometal_boiler" | "chipped_express:stonecutting_chipped_micro_red_mushroom_from_red_mushroom" | "mcwroofs:oak_planks_upper_lower_roof" | "create:cutting/compat/twilightforest/canopy_log" | "chipped_express:stonecutting_chipped_blue_paper_lantern_from_lantern" | "chipped_express:stonecutting_chipped_double_herringbone_jungle_planks_from_jungle_planks" | "toolbelt:pouch" | "delightful:knives/thyrium_knife" | "conditional:bloomingnature/wood_cutter/larch_fence_woodcutter" | "createdeco:long_scarlet_brick_stairs_from_long_scarlet_bricks_stonecutting" | "compressedblocks:shaped_c3_dark_oak_log" | "compressedblocks:shapeless_c7_waxed_exposed_cut_copper" | "pamhc2foodextended:pawpawjellyitem" | "mcwroofs:thatch_steep_roof" | "minecraft:cut_copper_slab_from_cut_copper_stonecutting" | "chipped_express:stonecutting_chipped_orange_concrete_tiles_from_orange_concrete" | "meadow:wood_cutter/cherry/cherry_pp_woodcutter" | "moa_decor_toys:ovejablanca_1" | "chipped_express:stonecutting_chipped_herringbone_bamboo_planks_from_bamboo_planks" | "chipped_express:stonecutting_chipped_layed_stone_bricks_from_stone" | "chipped_express:stonecutting_chipped_square_gray_stained_glass_from_gray_stained_glass" | "railways:stonecutting/palettes/cycling/cyan_flat_riveted_locometal" | "create_central_kitchen:emptying/hot_cocoa" | "moa_decor_bath:ldistorsionadosc_1" | "botania:cosmetic_black_tie" | "quark:building/crafting/vertslabs/waxed_cut_copper_vertical_slab" | "sophisticatedstorage:auto_smoking_upgrade_from_auto_smelting_upgrade" | "chipped_express:stonecutting_chipped_smoothed_double_inlayed_blue_ice_from_blue_ice" | "chipped_express:stonecutting_chipped_woven_light_gray_stained_glass_from_light_gray_stained_glass" | "sophisticatedstorage:bamboo_chest" | "beautify:candelabra_black" | "compressedblocks:shapeless_double_crated_orange_tulip" | "chipped_express:stonecutting_chipped_sanded_deepslate_from_deepslate" | "compressedblocks:shaped_double_crated_peony" | "chipped_express:stonecutting_chipped_barred_spruce_door_from_spruce_door" | "moa_decor_garden_:florero_trubiacea_1" | "meadow:climbing_rope_topmount" | "create:small_calcite_bricks_from_stone_types_calcite_stonecutting" | "cosmeticarmoursmod:yellow_sock_plaid_2_white" | "compressedblocks:shaped_c1_stripped_mangrove_log" | "chipped_express:stonecutting_chipped_inlayed_ancient_debris_from_ancient_debris" | "cosmeticarmoursmod:bolwer_hat_rec" | "corail_woodcutter:jungle_woodcutter" | "create_confectionery:caramel_bricks_recipe" | "create:haunting/glow_berries" | "moa_decor_art:tocadiscos_1" | "candlelight:bamboo_chair" | "chipped_express:stonecutting_chipped_metal_barrel_from_barrel" | "chipped_express:stonecutting_chipped_inlayed_quartz_block_from_quartz_block" | "delightful:knives/blasting/constantan_thermal" | "chipped_express:stonecutting_chipped_simple_mud_pillar_from_mud" | "chipped_express:stonecutting_chipped_circular_light_gray_terracotta_from_light_gray_terracotta" | "chipped_express:stonecutting_chipped_smooth_crimson_stem_from_crimson_stem" | "create:crushing/asurine" | "corail_woodcutter:woodcutting/biomesoplenty/fir_door_from_fir_logs" | "minecraft:deepslate_tiles" | "compressedblocks:shapeless_septuple_crated_cooked_beef" | "compressedblocks:shapeless_octuple_crated_green_dye" | "chipped_express:stonecutting_chipped_tiny_end_stone_bricks_from_end_stone" | "cosmeticarmoursmod:white_skirt_2_brown" | "compressedblocks:shapeless_c7_lapis_block" | "botania:metamorphic_taiga_cobblestone_stairs" | "compressedblocks:shapeless_c8_slime_block" | "botanypots:minecraft/soil/deepslate_iron_ore" | "botanypots:botania/crop/green_double_flower" | "compressedblocks:shaped_c8_nether_bricks" | "chipped_express:stonecutting_chipped_wickered_yellow_wool_from_yellow_wool" | "comforts:hammock_orange" | "quark:building/crafting/vertslabs/exposed_cut_copper_vertical_slab" | "mcwroofs:black_concrete_roof" | "chipped_express:stonecutting_chipped_boxed_oak_planks_from_oak_planks" | "framedblocks:framed_trapdoor" | "refinedstorage:fluid_grid/brown_fluid_grid" | "botanypots:farming_crossing/crop/candlelighttomato_seeds" | "compressedblocks:shapeless_c8_stripped_acacia_log" | "chipped_express:stonecutting_chipped_windowed_warped_trapdoor_from_warped_trapdoor" | "compressedblocks:shaped_double_crated_cooked_rabbit" | "compressedblocks:shaped_triple_crated_flint" | "chipped_express:stonecutting_chipped_sliding_cherry_door_from_cherry_door" | "bloomingnature:stripped_swamp_cypress_wood" | "quark:building/crafting/compressed/berry_sack_uncompress" | "quark:building/crafting/vertslabs/light_blue_shingles_vertical_slab_revert" | "chipped_express:stonecutting_chipped_placed_mud_from_mud" | "compressedblocks:shapeless_crated_purple_dye" | "compressedblocks:shapeless_c7_red_sandstone" | "cosmeticarmoursmod:lime_skirt_2_white" | "chipped_express:stonecutting_chipped_tiny_layered_diorite_slabs_from_diorite" | "chipped_express:stonecutting_chipped_pegged_oak_planks_from_oak_planks" | "chipped_express:stonecutting_chipped_crossed_iron_bars_from_iron_bars" | "compressedblocks:shaped_c5_red_sand" | "create:cutting/compat/blue_skies/lunar_log" | "luphieclutteredmod:luphie_blue_shroom_terrarium_recipe" | "railways:crafting/palettes/dyeing_8x/light_gray_brass_wrapped_locometal" | "mcwroofs:light_blue_terracotta_lower_roof" | "handcrafted:cyan_cushion" | "compressedblocks:shaped_giga_crated_snowball" | "moa_decor_toys:gatotuxedo_1" | "chipped_express:stonecutting_chipped_crying_gilded_blackstone_from_gilded_blackstone" | "minecraft:sentry_armor_trim_smithing_template_smithing_trim" | "corail_woodcutter:woodcutting/biomesoplenty/palm_sign_from_palm_logs" | "moa_decor_holidays:banderines_gris_claro_1" | "botania:dreamwood_twig" | "farmersdelight:cutting/spruce_trapdoor" | "chipped_express:stonecutting_chipped_layed_coal_block_bricks_from_coal_block" | "botania:floating_bergamute" | "compressedblocks:shapeless_sextuple_crated_cooked_porkchop" | "moa_decor_art:aerosolrojo_1" | "create:crafting/kinetics/item_drain" | "minecraft:eye_armor_trim_smithing_template" | "chipped_express:stonecutting_chipped_wickered_green_wool_from_green_wool" | "luphieclutteredmod:luphie_green_bookshelf_recipe" | "chipped_express:stonecutting_chipped_tiled_bordered_calcite_from_calcite" | "create:cut_tuff_brick_wall" | "mcwfurnitures:stripped_dark_oak_table" | "compressedblocks:shaped_c9_jungle_planks" | "farmersdelight:cutting/warped_door" | "botania:manaweave_boots" | "mcwtrpdoors:mangrove_bark_trapdoor" | "create:crafting/appliances/crafting_blueprint" | "compressedblocks:shaped_c7_nether_bricks" | "bakery:baking_station/chocolate_gateau" | "storagedrawers:jungle_full_drawers_1" | "quark:building/crafting/vertplanks/vertical_acacia_planks_revert" | "beautify:candelabra_brown" | "createdeco:pink_shipping_container_from_dyeing_vaults" | "storagedrawers:upgrade_template" | "compressedblocks:shaped_quintuple_crated_light_gray_carpet" | "minecraft:polished_blackstone_brick_slab_from_blackstone_stonecutting" | "compressedblocks:shapeless_giga_crated_glass_bottle" | "railways:crafting/palettes/dyeing_1x/blue_riveted_locometal" | "railways:stonecutting/palettes/cycling/brown_riveted_locometal" | "chipped_express:stonecutting_chipped_sanded_sandstone_from_sandstone" | "framedblocks:framing_saw/framed_elevated_slope_edge" | "pamhc2foodextended:mettbrotchenitem" | "mcwbridges:stonecutter_balustrade_andesite_bridge" | "chipped_express:stonecutting_chipped_tiled_bricks_column_from_bricks" | "mcwtrpdoors:warped_swamp_trapdoor" | "conditional:regions_unexplored/wood_cutter/baobab_pp_woodcutter" | "compressedblocks:shaped_double_crated_green_dye" | "mcwfences:acacia_wired_fence" | "mcwroofs:orange_terracotta_attic_roof" | "delightful:food/salmonberry_ice_cream_no_neapolitan" | "beautify:hanging_pot" | "meadow:wood_cutter/oak/oak_button_woodcutter" | "compressedblocks:shapeless_c8_raw_copper_block" | "compressedblocks:shaped_c1_bricks" | "minecraft:yellow_bed" | "compressedblocks:shaped_triple_crated_melon_seeds" | "botania:stonecutting/blaze_quartz_to_blaze_quartz_pillar" | "mcwfurnitures:cherry_modern_desk" | "chipped_express:stonecutting_chipped_orange_glazed_terracotta_pillar_sides_from_orange_glazed_terracotta" | "mcwroofs:gray_concrete_top_roof" | "compressedblocks:shapeless_sextuple_crated_repeater" | "minecraft:waxed_cut_copper_slab_from_waxed_cut_copper_stonecutting" | "luphieclutteredmod:luphie_glowing_moon_recipe" | "meadow:limestone_brick_slab" | "chipped_express:stonecutting_chipped_center_cut_spruce_log_from_spruce_log" | "compressedblocks:shaped_c9_clay" | "aquaculturedelight:cutting/knife/goldfish" | "delightful:knives/smelting/silver_immersiveengineering" | "compressedblocks:shaped_octuple_crated_rail" | "compressedblocks:shapeless_triple_crated_experience_bottle" | "mcwdoors:warped_tropical_door" | "botania:metamorphic_taiga_bricks_slab" | "compressedblocks:shaped_c9_iron_block" | "mcwlights:soul_mangrove_tiki_torch" | "compressedblocks:shaped_c4_lapis_ore" | "pamhc2foodextended:grapesodaitem" | "pamhc2foodextended:sausageitem" | "chipped_express:stonecutting_chipped_engraved_lapis_block_from_lapis_block" | "sophisticatedstorage:birch_chest" | "create:layered_crimsite_from_stone_types_crimsite_stonecutting" | "farmersdelight:cutting/jungle_trapdoor" | "quark:building/crafting/birch_leaf_carpet" | "compressedblocks:shapeless_double_crated_crimson_fungus" | "botania:floating_bellethorn" | "chipped_express:stonecutting_chipped_etched_bricks_bricks_from_bricks" | "create:cutting/compat/byg/stripped_ether_log" | "mcwroofs:gutter_base_light_gray" | "compressedblocks:shaped_sextuple_crated_soul_campfire" | "compressedblocks:shaped_crated_light_gray_dye" | "chipped_express:stonecutting_chipped_smooth_ringed_snow_block_from_snow_block" | "chipped_express:stonecutting_chipped_brick_bordered_quartz_block_from_quartz_block" | "pamhc2foodextended:peasandceleryitem" | "pamhc2foodextended:cinnamonappleoatmealitem" | "compressedblocks:shapeless_c4_stripped_jungle_log" | "chipped_express:stonecutting_chipped_edged_red_sandstone_bricks_from_red_sandstone" | "cookingforblockheads:preservation_chamber" | "mcwtrpdoors:birch_four_panel_trapdoor" | "createdeco:long_dean_brick_slab_from_tiled_dean_bricks_stonecutting" | "chipped_express:stonecutting_chipped_rectangle_lime_wool_from_lime_wool" | "quark:building/crafting/vertslabs/white_shingles_vertical_slab" | "railways:crafting/palettes/dyeing_1x/white_locometal_boiler" | "vinery:cherry_wine_rack_mid" | "compressedblocks:shaped_c8_exposed_cut_copper" | "create:crushing/raw_tin_block" | "alexsmobs:falconry_glove" | "libraryferret:smelting/netherite_coins_jtl" | "chipped_express:stonecutting_chipped_railed_jungle_planks_from_jungle_planks" | "compressedblocks:shaped_double_crated_white_carpet" | "chipped_express:stonecutting_chipped_angry_blue_ice_from_blue_ice" | "handcrafted:bamboo_counter" | "create:small_tuff_brick_slab" | "meadow:wood_cutter/acacia/acacia_fencegate_woodcutter" | "railways:crafting/palettes/dyeing_8x/gray_flat_riveted_locometal" | "railways:crafting/palettes/wrapping/gray_copper_wrapped_locometal" | "mcwwindows:jungle_window" | "bloomingnature:swamp_cypress_stairs" | "chipped_express:stonecutting_chipped_weathered_nether_bricks_from_nether_bricks" | "mcwwindows:stripped_crimson_stem_window" | "chipped_express:stonecutting_chipped_prismal_dripstone_block_remnants_from_dripstone_block" | "createdeco:orange_shipping_container" | "compressedblocks:shapeless_giga_crated_light_gray_carpet" | "create:cut_scorchia_brick_wall" | "botania:mana_quartz_pillar" | "refinedstorage:coloring_recipes/red_crafting_monitor" | "chipped_express:stonecutting_chipped_black_glazed_terracotta_pillar_top_from_black_glazed_terracotta" | "chipped_express:stonecutting_chipped_creeper_redstone_block_carving_from_redstone_block" | "createdeco:andesite_mesh_fence_from_stonecutting" | "mcwfences:acacia_highley_gate" | "mcwroofs:andesite_steep_roof" | "quark:building/crafting/shingles/purple_shingles_dye" | "gemsnjewels:stacked_jade_block" | "chipped_express:stonecutting_chipped_creeper_orange_concrete_from_orange_concrete" | "compressedblocks:shaped_quadruple_crated_glow_lichen" | "pamhc2crops:roastedgarlicitem_smoker" | "mcwroofs:pink_concrete_roof" | "create:polished_cut_scoria_slab_recycling" | "pamhc2trees:persimmon_sapling" | "compressedblocks:shapeless_c4_exposed_copper" | "quark:building/stonecutting/stonevariants/tuff_bricks_stairs_rough_stonecutting" | "vinery:wine_press" | "botania:apothecary_taiga" | "create:cut_crimsite_bricks_from_stone_types_crimsite_stonecutting" | "quark:building/crafting/vertslabs/yellow_shingles_vertical_slab" | "chipped_express:stonecutting_chipped_bundled_brown_carpet_from_brown_carpet" | "botania:stonecutting/red_quartz_to_red_quartz_slab" | "compressedblocks:shaped_double_crated_ghast_tear" | "minecraft:sentry_armor_trim_smithing_template" | "vinery:cherry_chest_boat" | "chipped_express:stonecutting_chipped_small_magenta_stained_glass_from_magenta_stained_glass" | "compressedblocks:shapeless_double_crated_pufferfish" | "railways:sequenced_assembly/track_tfc_birch_narrow" | "railways:crafting/palettes/dyeing_1x/yellow_brass_wrapped_locometal" | "createdeco:short_scarlet_brick_slab_from_tiled_scarlet_brick_slab_stonecutting" | "pamhc2trees:acorn_sapling" | "mcwwindows:orange_mosaic_glass" | "chipped_express:stonecutting_chipped_crossed_jungle_planks_from_jungle_planks" | "snowyspirit:compressedblocks/sled_c0_oak" | "chipped_express:stonecutting_chipped_stacked_snow_block_bricks_from_snow_block" | "waystones:warp_dust" | "compressedblocks:shapeless_triple_crated_brown_dye" | "create:cut_veridium_brick_wall_from_stone_types_veridium_stonecutting" | "chipped_express:stonecutting_chipped_cut_blank_obsidian_from_obsidian" | "camera:image_frame" | "chipped_express:stonecutting_chipped_meshed_bamboo_trapdoor_from_bamboo_trapdoor" | "compressedblocks:shapeless_double_crated_green_carpet" | "framedblocks:framed_slab_rotate_to_framed_panel" | "handcrafted:oak_bench" | "mcwfurnituresbop:mahogany_table" | "quark:tweaks/smelting/raw_gold_block_smelt" | "quark:building/stonecutting/stairs/red_sandstone_bricks_stairs_stonecutter" | "chipped_express:stonecutting_chipped_gated_spruce_door_from_spruce_door" | "vinery:wine_fermentation/villagers_fright" | "chipped_express:stonecutting_chipped_ribbled_green_wool_from_green_wool" | "mcwroofs:light_gray_terracotta_lower_roof" | "chipped_express:stonecutting_chipped_spider_smooth_stone_carving_from_smooth_stone" | "meadow:piece_of_goat_cheese" | "luphieclutteredmod:luphie_pink_right_outer_corner_counter_recipe_alt" | "quark:building/crafting/hollowlogs/hollow_spruce_log" | "chipped_express:stonecutting_chipped_cobbled_obsidian_from_obsidian" | "chipped_express:stonecutting_chipped_edged_stripped_crimson_stem_from_stripped_crimson_stem" | "chipped_express:stonecutting_chipped_bulbed_glowstone_from_glowstone" | "chipped_express:stonecutting_chipped_amethyst_block_mini_tiles_from_amethyst_block" | "botanypots:botania/crop/green_mushroom" | "minecraft:iron_leggings" | "compressedblocks:shapeless_double_crated_glow_item_frame" | "railways:crafting/palettes/dyeing_8x/green_flat_riveted_locometal" | "lootbags:common_decorations/llama_plushes_completion" | "delightful:knives/blasting/lead_immersiveengineering" | "compressedblocks:shapeless_c6_soul_soil" | "minecraft:book_cloning" | "botanypots:minecraft/crop/warped_fungus" | "compressedblocks:shaped_triple_crated_white_carpet" | "mcwtrpdoors:jungle_four_panel_trapdoor" | "pamhc2crops:taroseeditem" | "moa_decor_lights:vt_bdistorsionado_1" | "luphieclutteredmod:luphie_blue_mushroom_fence_gate_recipe" | "botanypots:pamhc2crops/crop/coffeebean" | "chipped_express:stonecutting_chipped_angry_raw_copper_block_from_raw_copper_block" | "pamhc2crops:chiaseeditem" | "chipped_express:stonecutting_chipped_overlapping_mossy_stone_bricks_tiles_from_mossy_stone_bricks" | "mcwwindows:spruce_blinds" | "compressedblocks:shapeless_c5_dark_oak_log" | "chipped_express:stonecutting_chipped_planked_jungle_log_from_jungle_log" | "mcwfurnitures:jungle_double_wardrobe" | "botania:mana_infusion/pink_tulip_to_oxeye_daisy" | "chipped_express:stonecutting_chipped_vertical_disordered_nether_bricks_bricks_from_nether_bricks" | "compressedblocks:shaped_c5_stripped_jungle_log" | "compressedblocks:shapeless_sextuple_crated_fermented_spider_eye" | "compressedblocks:shapeless_c6_stone" | "createdeco:brass_coin" | "chipped_express:stonecutting_chipped_offset_bricks_bricks_from_bricks" | "moa_decor_art:bateriacian_1" | "chipped_express:stonecutting_chipped_raster_purple_stained_glass_pane_from_purple_stained_glass_pane" | "pamhc2crops:torch_cattail" | "quark:automation/crafting/nether_brick_fence_gate" | "chipped_express:stonecutting_chipped_cut_brown_terracotta_from_brown_terracotta" | "compressedblocks:shaped_c3_bamboo_mosaic" | "quark:building/crafting/vertslabs/smooth_stone_vertical_slab" | "create:copper_tile_stairs_from_copper_tiles_stonecutting" | "chipped_express:stonecutting_chipped_flat_coal_block_tiles_from_coal_block" | "moa_decor_art:paletadepintura_1" | "minecraft:prismarine_brick_slab" | "compressedblocks:shaped_c5_lapis_ore" | "compressedblocks:shapeless_quadruple_crated_ink_sac" | "pamhc2foodextended:gardensoupitem" | "gemsnjewels:stacked_opal_block" | "candlelight:table_bowl" | "botania:floating_entropinnyum" | "compressedblocks:shaped_c4_nether_wart_block" | "compressedblocks:shaped_sextuple_crated_repeater" | "createaddition:filling/chocolate_cake" | "create:cutting/compat/byg/fungal_imparius_hyphae" | "domesticationinnovation:pet_bed_orange" | "quark:tweaks/crafting/utility/chest_boat/direct_dark_oak_chest_boat" | "create_confectionery:full_white_chocolate_bar_recipe" | "framedblocks:framing_saw/framed_pressure_plate" | "chipped_express:stonecutting_chipped_edged_stripped_mangrove_log_from_stripped_mangrove_log" | "chipped_express:stonecutting_chipped_lapis_block_bricks_from_lapis_block" | "pamhc2foodextended:pearjuiceitem" | "chipped_express:stonecutting_chipped_prismal_packed_ice_remnants_from_packed_ice" | "supplementaries:biomesoplenty/sign_post_redwood" | "minecraft:polished_andesite_from_andesite_stonecutting" | "chipped_express:stonecutting_chipped_harsh_quilted_white_wool_from_white_wool" | "storagedrawers:jungle_full_drawers_4" | "compressedblocks:shapeless_octuple_crated_sugar_cane" | "compressedblocks:shapeless_double_crated_tropical_fish" | "storagedrawers:jungle_full_drawers_2" | "chipped_express:stonecutting_chipped_thick_inlayed_nether_bricks_from_nether_bricks" | "minecraft:mud_brick_slab_from_mud_bricks_stonecutting" | "chipped_express:stonecutting_chipped_ornate_borderless_bricks_pillar_from_bricks" | "create:deploying/waxed_oxidized_copper_shingle_stairs_from_adding_wax" | "createdeco:brass_trapdoor" | "compressedblocks:shaped_octuple_crated_green_dye" | "framedblocks:framing_saw/framed_ext_inner_corner_slope_panel" | "compressedblocks:shapeless_octuple_crated_red_dye" | "moa_decor_toys:ovejamorada_1" | "compressedblocks:shapeless_c2_bricks" | "cosmeticarmoursmod:yellow_skirt_2_plaid" | "chipped_express:stonecutting_chipped_massive_dark_prismarine_bricks_from_dark_prismarine" | "chipped_express:stonecutting_chipped_bordered_crying_obsidian_from_crying_obsidian" | "chipped_express:stonecutting_chipped_cobbled_purpur_block_from_purpur_block" | "minecraft:smooth_stone_slab_from_smooth_stone_stonecutting" | "chipped_express:stonecutting_chipped_layered_pink_terracotta_from_pink_terracotta" | "compressedblocks:shaped_sextuple_crated_blue_carpet" | "botania:stonecutting/metamorphic_taiga_bricks_to_metamorphic_taiga_bricks_wall" | "botanypots:biomesoplenty/soil/flesh" | "chipped_express:stonecutting_chipped_blank_magma_block_carving_from_magma_block" | "quark:oddities/crafting/magnet_pre_end" | "createdeco:tiled_blue_brick_slab" | "refinedstorage:coloring_recipes/magenta_crafter" | "minecraft:clock" | "create:cutting/compat/forbidden_arcanus/stripped_cherrywood_log" | "mcwroofs:diorite_lower_roof" | "comforts:sleeping_bag_light_gray" | "mcwlights:soul_birch_tiki_torch" | "railways:crafting/palettes/dyeing_8x/cyan_locometal_boiler" | "chipped_express:stonecutting_chipped_dark_sprinkled_brown_mushroom_block_from_brown_mushroom_block" | "snowyspirit:bloomingnature/sled_chestnut" | "chipped_express:stonecutting_chipped_curly_clay_pillar_from_clay" | "botanypots:botania/crop/pink_double_flower" | "quark:building/crafting/stonevariants/chiseled_myalite_bricks" | "mcwfurnitures:stripped_oak_double_drawer_counter" | "biomesoplenty:purple_dye_from_lavender" | "quark:building/crafting/warped_post" | "duckling:holiday_fruit_cake" | "pamhc2foodextended:pinkelitem" | "compressedblocks:shapeless_quadruple_crated_painting" | "quark:building/crafting/jungle_bookshelf" | "candlelight:pot_cooking/salmon_wine" | "compressedblocks:shapeless_triple_crated_firework_star" | "minecraft:purple_stained_glass" | "railways:crafting/palettes/wrapping/pink_brass_wrapped_locometal" | "quark:building/stonecutting/stonevariants/calcite_bricks_polished_stonecutting" | "moa_decor_science:suerorojo_1" | "createdeco:copper_window" | "bloomingnature:laterit_brick_slab" | "mcwbridges:nether_bricks_bridge_stair" | "mcwwindows:white_mosaic_glass" | "chipped_express:stonecutting_chipped_plated_waxed_weathered_copper_from_waxed_weathered_copper" | "chipped_express:stonecutting_chipped_weathered_borderless_bricks_from_bricks" | "minecraft:polished_andesite_slab_from_andesite_stonecutting" | "minecraft:dye_black_bed" | "compressedblocks:shapeless_c3_spruce_log" | "compressedblocks:shapeless_c1_stone" | "refinedstorage:4096k_fluid_storage_disk_from_storage_housing" | "chipped_express:stonecutting_chipped_inscribed_orange_terracotta_from_orange_terracotta" | "chipped_express:stonecutting_chipped_woven_white_stained_glass_pane_from_white_stained_glass_pane" | "botanypots:botanypots/crafting/pink_glazed_terracotta_botany_pot" | "railways:crafting/palettes/dyeing_1x/blue_locometal_smokebox" | "createdeco:dean_bricks" | "vinery:bamboo_wine_rack_small" | "create:milling/sunflower" | "meadow:cooking_pot/cooked_cod" | "minecraft:mossy_stone_bricks_from_moss_block" | "mcwwindows:spruce_window2" | "compressedblocks:shapeless_mega_crated_charcoal" | "chipped_express:stonecutting_chipped_tiled_borderless_bricks_column_from_bricks" | "corail_woodcutter:woodcutting/dark_oak_slab_from_dark_oak_logs" | "chipped_express:stonecutting_chipped_sigil_mud_bricks_from_mud_bricks" | "moa_decor_lights:faroltriple_g_1" | "moa_decor_cookery:frobleosc_1" | "framedblocks:framing_saw/framed_small_double_corner_slope_panel" | "chipped_express:stonecutting_chipped_smooth_tuff_column_from_tuff" | "compressedblocks:shapeless_double_crated_nether_star" | "createdeco:cracked_blue_bricks_from_blue_bricks_smelting" | "chipped_express:stonecutting_chipped_red_sandstone_scales_from_red_sandstone" | "chipped_express:stonecutting_chipped_basalt_scales_from_basalt" | "quark:building/stonecutting/vertslabs/gray_shingles_vertical_slab_stonecutter2" | "create:compat/byg/crushing/anthracite_ore" | "refinedstorage:crafting_grid/magenta_crafting_grid" | "ars_nouveau:cutting/blue_archwood_wood" | "quark:world/crafting/panes/violet_corundum" | "compressedblocks:shaped_octuple_crated_leather" | "luphieclutteredmod:luphie_hanging_potted_grass" | "mcwfences:end_brick_railing_gate" | "macawsroofsbop:dead_attic_roof" | "pamhc2trees:roastedpistachiotitem_smoker" | "compressedblocks:shapeless_octuple_crated_amethyst_shard" | "botania:petal_black" | "chipped_express:stonecutting_chipped_raw_gold_block_bricks_from_raw_gold_block" | "chipped_express:stonecutting_chipped_tiled_lime_carpet_from_lime_carpet" | "delightful:food/honey_glazed_walnut" | "moa_decor_lights:lm_bcafe_1" | "createdeco:short_dusk_brick_stairs_from_long_dusk_brick_stairs_stonecutting" | "pamhc2crops:elderberryseeditem" | "chipped_express:stonecutting_chipped_trodden_dripstone_block_from_dripstone_block" | "moa_decor_holidays:calabaza_creeper_1" | "create:cutting/compat/biomesoplenty/cherry_log" | "chipped_express:stonecutting_chipped_smooth_mossy_stone_bricks_column_from_mossy_stone_bricks" | "chipped_express:stonecutting_chipped_cracked_disordered_quartz_block_bricks_from_quartz_block" | "chipped_express:stonecutting_chipped_cyan_terracotta_tile_from_cyan_terracotta" | "moa_decor_cookery:ollahongos_1" | "railways:sequenced_assembly/track_tfc_pine_narrow" | "minecraft:wooden_shovel" | "railways:sequenced_assembly/track_twilightforest_twilight_oak_narrow" | "create:compat/silentsgems/crushing/pearl_ore" | "createdeco:decal_down_right" | "chipped_express:stonecutting_chipped_fine_lodestone_pillar_from_lodestone" | "createdeco:long_umber_brick_slab_from_tiled_umber_bricks_stonecutting" | "botania:stonecutting/metamorphic_plains_stone_to_metamorphic_plains_bricks_wall" | "compressedblocks:shapeless_c1_nether_wart_block" | "compressedblocks:shaped_c8_copper_block" | "mighty_mail:dark_oak_mail_box" | "minecraft:bamboo_trapdoor" | "create:deploying/waxed_copper_block_from_adding_wax" | "pamhc2foodextended:creamofmushroomitem" | "farmersdelight:lead_from_straw" | "compressedblocks:shaped_c8_oxidized_copper" | "minecraft:waxed_copper_block_from_honeycomb" | "pamhc2foodcore:caramelmuffinitem" | "chipped_express:stonecutting_chipped_inscribed_smooth_stone_from_smooth_stone" | "chipped_express:stonecutting_chipped_loded_mossy_cobblestone_from_mossy_cobblestone" | "mcwdoors:print_jungle" | "compressedblocks:shaped_c8_slime_block" | "supplementaries:blackstone_tile_slab" | "createdeco:copper_door" | "corail_woodcutter:woodcutting/biomesoplenty/jacaranda_slab_from_jacaranda_logs" | "createdeco:long_red_bricks_from_short_red_bricks_stonecutting" | "bloomingnature:red_brick_stairs" | "chipped_express:stonecutting_chipped_loreful_mud_from_mud" | "chipped_express:stonecutting_chipped_light_blue_glazed_terracotta_pillar_top_from_light_blue_glazed_terracotta" | "pamhc2crops:kaleseeditem" | "compressedblocks:shaped_quadruple_crated_soul_campfire" | "mcwfences:mud_brick_railing_gate" | "moa_decor_lights:vt_gabeto_1" | "quark:building/stonecutting/cobblestone_bricks_stonecutter" | "moa_decor_garden_:jaula_pnegra_1" | "compressedblocks:shaped_c3_coal_block" | "compressedblocks:shaped_crated_powered_rail" | "compressedblocks:shaped_crated_honeycomb" | "createdeco:zinc_hull" | "farmersdelight:cyan_canvas_sign" | "minecraft:cooked_cod_from_smoking" | "createdeco:pearl_brick_stairs_from_tiled_pearl_brick_stairs_stonecutting" | "luphieclutteredmod:luphie_pink_spool_of_thread_recipe" | "chipped_express:stonecutting_chipped_double_inlayed_glowstone_from_glowstone" | "chipped_express:stonecutting_chipped_crying_obsidian_scales_from_crying_obsidian" | "chipped_express:stonecutting_chipped_crying_calcite_from_calcite" | "mcwfurnituresbop:dead_modern_desk" | "vinery:wine_fermentation/ghastly_grenache" | "compressedblocks:shaped_c3_mud" | "chipped_express:stonecutting_chipped_prismal_lodestone_remnants_from_lodestone" | "mcwbridges:jungle_log_bridge_middle" | "compressedblocks:shaped_triple_crated_fermented_spider_eye" | "moa_decor_garden_:pala_cgrava_1" | "chipped_express:stonecutting_chipped_gilded_barrel_from_barrel" | "botania:dreamwood_planks_slab" | "chipped_express:stonecutting_chipped_laced_warped_planks_from_warped_planks" | "chipped_express:stonecutting_chipped_overgrown_cherry_door_from_cherry_door" | "candlelight:acacia_big_table" | "create:compat/projectvibrantjourneys/cutting/palm_log" | "compressedblocks:shapeless_crated_glowstone_dust" | "candlelight:pot_cooking/chocolate" | "botania:glass_pickaxe" | "botanypots:regions_unexplored/crop/prismoss_sprout" | "mcwbridges:asian_red_bridge_stair" | "chipped_express:stonecutting_chipped_spiraled_calcite_from_calcite" | "compressedblocks:shaped_c2_dark_oak_log" | "moa_decor_cookery:cmangle_1" | "chipped_express:stonecutting_chipped_offset_clay_bricks_from_clay" | "minecraft:copper_ingot" | "railways:crafting/handcar" | "mcwlights:oak_tiki_torch" | "compressedblocks:shaped_crated_rabbit" | "chipped_express:stonecutting_chipped_duh_mud_from_mud" | "compressedblocks:shaped_c8_cut_copper" | "railways:crafting/palettes/dyeing_1x/red_copper_wrapped_locometal_boiler" | "botania:stonecutting/metamorphic_mountain_stone_to_metamorphic_mountain_bricks_wall" | "createdeco:tiled_dusk_brick_stairs_from_tiled_dusk_bricks_stonecutting" | "botania:metamorphic_desert_cobblestone_wall" | "compressedblocks:shaped_quadruple_crated_white_carpet" | "compressedblocks:shaped_c0_weathered_cut_copper" | "delightful:food/cooking/sinigang" | "create_confectionery:white_chocolate_candy_2_recipe" | "quark:world/crafting/woodsets/blossom/ladder" | "compressedblocks:shaped_octuple_crated_blaze_rod" | "pamhc2foodextended:plumsmoothieitem" | "compressedblocks:shapeless_double_crated_torch" | "compressedblocks:shapeless_octuple_crated_glow_lichen" | "chipped_express:stonecutting_chipped_iron_barrel_from_barrel" | "compressedblocks:shaped_sextuple_crated_sunflower" | "create:cutting/compat/byg/rainbow_eucalyptus_wood" | "compressedblocks:shapeless_c8_oak_planks" | "chipped_express:stonecutting_chipped_tiny_brick_bordered_lapis_block_from_lapis_block" | "beachparty:mini_fridge_mixing/chocolate_icecream" | "minecraft:waxed_oxidized_cut_copper_stairs_from_honeycomb" | "libraryferret:blasting/diamond_coins_jtl" | "gemsnjewels:stacked_zircon_block" | "luphieclutteredmod:luphie_glow_planks_recipe" | "createdeco:short_umber_brick_slab_from_tiled_umber_brick_slab_stonecutting" | "handcrafted:warped_nightstand" | "beautify:birch_trellis" | "compressedblocks:shaped_quadruple_crated_chain" | "corail_woodcutter:woodcutting/biomesoplenty/dead_slab_from_dead_planks" | "chipped_express:stonecutting_chipped_airy_spruce_trapdoor_from_spruce_trapdoor" | "chipped_express:stonecutting_chipped_golden_apple_dark_oak_leaves_from_dark_oak_leaves" | "botania:green_pavement_slab" | "pamhc2foodextended:tiropitaitem" | "railways:crafting/palettes/dyeing_8x/magenta_iron_wrapped_locometal" | "mcwwindows:dark_oak_plank_parapet" | "createdeco:long_umber_brick_stairs_from_umber_bricks_stonecutting" | "sophisticatedstorage:gold_barrel" | "chipped_express:stonecutting_chipped_iron_bars_top_from_iron_bars" | "mcwroofs:purple_terracotta_top_roof" | "compressedblocks:shaped_octuple_crated_baked_potato" | "botania:slab_recombine/livingwood" | "compressedblocks:shaped_crated_white_carpet" | "compressedblocks:shaped_double_crated_red_tulip" | "mcwdoors:cherry_glass_door" | "chipped_express:stonecutting_chipped_small_amethyst_block_bricks_from_amethyst_block" | "moa_decor_art:gafas_3d_1" | "compressedblocks:shapeless_quintuple_crated_arrow" | "chipped_express:stonecutting_chipped_diagonal_jungle_planks_from_jungle_planks" | "chipped_express:stonecutting_chipped_smoothed_double_inlayed_tuff_from_tuff" | "botanypots:farming_crossing/crop/pamhc2treesguava_sapling" | "mcwroofs:purple_concrete_roof" | "mcwfurnitures:mangrove_double_drawer" | "lootbags:clothing_collection/farmer_completion" | "botania:elven_trade/pixie_dust" | "chipped_express:stonecutting_chipped_starry_pink_glazed_terracotta_from_pink_glazed_terracotta" | "chipped_express:stonecutting_chipped_rounded_cobblestone_bricks_from_cobblestone" | "minecraft:shield_decoration" | "corail_woodcutter:woodcutting/biomesoplenty/mahogany_fence_from_mahogany_logs" | "create:compat/environmental/milling/cartwheel" | "create:cutting/compat/tconstruct/stripped_bloodshroom_log" | "chipped_express:stonecutting_chipped_raster_leaded_glass_from_glass" | "candlelight:cabinet" | "compressedblocks:shaped_double_crated_chorus_fruit" | "compressedblocks:shapeless_sextuple_crated_jungle_sapling" | "create:small_diorite_brick_slab_from_stone_types_diorite_stonecutting" | "chipped_express:stonecutting_chipped_rectangle_magenta_wool_from_magenta_wool" | "create:cut_limestone_brick_slab_from_stone_types_limestone_stonecutting" | "sophisticatedstorage:stack_upgrade_tier_2_from_tier_1_plus" | "compressedblocks:shaped_giga_crated_brown_dye" | "snowyspirit:sled_mangrove" | "refinedstorage:wrench" | "create:small_tuff_bricks_from_stone_types_tuff_stonecutting" | "quark:building/crafting/panes/light_blue_framed_glass_pane" | "candlelight:spruce_cabinet" | "minecraft:birch_planks" | "conditional:bloomingnature/wood_cutter/chestnut_planks_woodcutter" | "compressedblocks:shapeless_crated_white_carpet" | "botanypots:biomesoplenty/crop/flesh_tendons" | "mcwdoors:jungle_swamp_door" | "vinery:wine_fermentation/cherry_wine" | "compressedblocks:shaped_triple_crated_allium" | "create_confectionery:white_chocolate_recipe" | "handcrafted:bamboo_nightstand" | "compressedblocks:shapeless_mega_crated_apple" | "comforts:sleeping_bag_magenta" | "chipped_express:stonecutting_chipped_angry_purpur_block_from_purpur_block" | "botania:slab_recombine/metamorphic_desert_bricks" | "mcwwindows:stripped_crimson_stem_window2" | "compressedblocks:shaped_sextuple_crated_lime_carpet" | "botanypots:farmersdelight/crop/brown_mushroom_colony" | "compressedblocks:shapeless_sextuple_crated_gunpowder" | "alexsmobs:tarantula_hawk_elytra" | "createdeco:long_dean_brick_slab_from_short_dean_bricks_stonecutting" | "chipped_express:stonecutting_chipped_small_terracotta_tiles_from_terracotta" | "chipped_express:stonecutting_chipped_raw_copper_block_scales_from_raw_copper_block" | "compressedblocks:shapeless_septuple_crated_brown_dye" | "candlelight:crimson_table" | "conditional:regions_unexplored/wood_cutter/pine_stairs_woodcutter" | "meadow:wood_cutter/oak/oak_pp_woodcutter" | "createdeco:mossy_dusk_brick_stairs" | "deep_aether:skyroot_milk_bucket_cake" | "sophisticatedbackpacks:tank_upgrade" | "biomesoplenty:brimstone_brick_wall" | "exoticbirds:cherry_birdcage" | "handcrafted:birch_drawer" | "create_confectionery:gingerbread_block_recipe" | "minecraft:brown_bed" | "compressedblocks:shaped_double_crated_torch" | "railways:stonecutting/palettes/cycling/gray_plated_locometal" | "luphieclutteredmod:luphie_coffee_grinder_recipe" | "sophisticatedstorage:acacia_limited_barrel_1" | "railways:sequenced_assembly/track_tfc_hickory" | "chipped_express:stonecutting_chipped_mosaic_cyan_concrete_from_cyan_concrete" | "sophisticatedstorage:acacia_limited_barrel_3" | "sophisticatedstorage:acacia_limited_barrel_2" | "chipped_express:stonecutting_chipped_tiny_layered_dark_prismarine_slabs_from_dark_prismarine" | "sophisticatedstorage:acacia_limited_barrel_4" | "pamhc2foodextended:soursopjellyitem" | "corail_woodcutter:woodcutting/mangrove_sign_from_mangrove_planks" | "mcwwindows:diorite_window" | "chipped_express:stonecutting_chipped_small_blackstone_bricks_from_blackstone" | "botania:orechid/deepslate_iron_ore" | "mcwfurnitures:oak_modern_wardrobe" | "botanypots:botania/crop/purple_double_flower" | "chipped_express:stonecutting_chipped_pillar_ice_bricks_from_ice" | "compressedblocks:shapeless_septuple_crated_beetroot" | "compressedblocks:shapeless_c4_stripped_birch_log" | "chipped_express:stonecutting_chipped_tiny_layered_coal_block_slabs_from_coal_block" | "pamhc2trees:roastedpistachioitem_campfire" | "snowyspirit:compressedblocks/sled_c9_dark_oak" | "botania:dry_seeds" | "chipped_express:stonecutting_chipped_slight_smile_carved_pumpkin_from_carved_pumpkin" | "biomesoplenty:cut_black_sandstone" | "chipped_express:stonecutting_chipped_weathered_tuff_from_tuff" | "minecraft:tripwire_hook" | "chipped_express:stonecutting_chipped_cross_laced_spruce_planks_from_spruce_planks" | "chipped_express:stonecutting_chipped_rustic_melon_from_melon" | "bloomingnature:laterit" | "mcwroofs:yellow_terracotta_upper_steep_roof" | "chipped_express:stonecutting_chipped_carved_purpur_block_from_purpur_block" | "compressedblocks:shapeless_quintuple_crated_poppy" | "create:cut_calcite_stairs_from_stone_types_calcite_stonecutting" | "create:cutting/compat/byg/stripped_cypress_wood" | "compressedblocks:shapeless_triple_crated_saddle" | "quark:world/crafting/waxed_red_corundum" | "moa_decor_garden_:hachaclavada_1" | "compressedblocks:shapeless_c1_acacia_log" | "farmersdelight:cooking/stuffed_hoglin" | "chipped_express:stonecutting_chipped_meshed_birch_trapdoor_from_birch_trapdoor" | "create:crafting/appliances/copper_backtank" | "mcwtrpdoors:dark_oak_swamp_trapdoor" | "chipped_express:stonecutting_chipped_ornate_green_stained_glass_pane_from_green_stained_glass_pane" | "compressedblocks:shaped_c8_raw_copper_block" | "conditional:regions_unexplored/wood_cutter/kapok_fencegate_woodcutter" | "chipped_express:stonecutting_chipped_purple_glazed_terracotta_tiles_from_purple_glazed_terracotta" | "create:compat/silentsgems/crushing/garnet_ore" | "handcrafted:red_sandstone_corner_trim" | "mcwroofs:granite_top_roof" | "chipped_express:stonecutting_chipped_carved_mud_pillar_from_mud" | "biomesoplenty:pink_dye_from_pink_daffodil" | "corail_woodcutter:spruce_woodcutter" | "compressedblocks:shapeless_giga_crated_carrot" | "compressedblocks:shapeless_mega_crated_nether_star" | "botanypots:botania/crop/red_mushroom" | "chipped_express:stonecutting_chipped_cut_blank_blackstone_from_blackstone" | "pamhc2foodextended:festivalbreaditem" | "chipped_express:stonecutting_chipped_crying_diorite_from_diorite" | "compressedblocks:shapeless_c1_iron_ore" | "quark:building/stonecutting/vertslabs/mossy_cobblestone_bricks_vertical_slab_stonecutter" | "botania:petal_lime_double" | "botania:mana_ring" | "chipped_express:stonecutting_chipped_brick_bordered_coal_block_from_coal_block" | "chipped_express:stonecutting_chipped_fractured_bone_block_from_bone_block" | "chipped_express:stonecutting_chipped_offset_amethyst_block_bricks_from_amethyst_block" | "create:crafting/appliances/netherite_backtank_from_netherite" | "chipped_express:stonecutting_chipped_starry_white_glazed_terracotta_from_white_glazed_terracotta" | "refinedstorage:coloring_recipes/cyan_relay" | "chipped_express:stonecutting_chipped_angry_obsidian_from_obsidian" | "moa_decor_science:jeringaamarilla_1" | "utilitix:comparator_redirector_down" | "chipped_express:stonecutting_chipped_blocky_lime_wool_from_lime_wool" | "pamhc2foodcore:potroastitem" | "chipped_express:stonecutting_chipped_rough_mud_bricks_from_mud_bricks" | "chipped_express:stonecutting_chipped_ancient_cubed_oak_bookshelf_from_bookshelf" | "moa_decor_bath:babedulsc_1" | "pamhc2foodextended:beanburritoitem" | "chipped_express:stonecutting_chipped_eroded_mossy_cobblestone_from_mossy_cobblestone" | "compressedblocks:shapeless_sextuple_crated_lantern" | "refinedstorage:coloring_recipes/lime_network_transmitter" | "create:compat/byg/milling/orange_daisy" | "moa_decor_garden_:hongocafemuro_1" | "botania:mana_infusion/redstone_dupe" | "macawsroofsbop:willow_steep_roof" | "botanypots:botania/crop/black_double_flower" | "mcwfurnitures:stripped_oak_bookshelf" | "exoticbirds:black_birdhouse" | "moa_decor_science:tuboensayoverde_1" | "chipped:benches/loom_table" | "compressedblocks:shaped_quadruple_crated_torch" | "compressedblocks:shapeless_c5_spruce_planks" | "chipped_express:stonecutting_chipped_patient_stripped_oak_log_from_stripped_oak_log" | "sophisticatedstorage:auto_smoking_upgrade" | "cosmeticarmoursmod:winged_gold_halo_rec" | "compressedblocks:shapeless_c9_slime_block" | "compressedblocks:shaped_septuple_crated_egg" | "moa_decor_bath:portapapelhigienico_1" | "createdeco:mossy_pearl_brick_slab_from_mossy_pearl_bricks_stonecutting" | "mcwdoors:print_spruce" | "railways:sequenced_assembly/track_biomesoplenty_hellbark_narrow" | "chipped_express:stonecutting_chipped_rough_purpur_block_from_purpur_block" | "chipped_express:stonecutting_chipped_cut_blank_coal_block_from_coal_block" | "create:crafting/kinetics/piston_extension_pole" | "luphieclutteredmod:luphie_green_checkered_block_recipe" | "moa_decor_cookery:betabel_1" | "botania:manasteel_block" | "chipped_express:stonecutting_chipped_leafy_vine_from_vine" | "create:compat/projectvibrantjourneys/cutting/pine_log" | "minecraft:lime_dye_from_smelting" | "createdeco:long_blue_bricks_from_tiled_blue_bricks_stonecutting" | "compressedblocks:shaped_c8_cobbled_deepslate" | "create:cut_limestone_slab" | "luphieclutteredmod:luphie_light_blue_armchair_recipe" | "railways:mechanical_crafting/light_gray_brass_wrapped_locometal_boiler" | "farmersdelight:hamburger_from_bun" | "chipped_express:stonecutting_chipped_ornate_red_stained_glass_from_red_stained_glass" | "moa_decor_bath:tendederoconsabanas_1" | "chipped_express:stonecutting_chipped_tiny_nether_bricks_bricks_from_nether_bricks" | "chipped_express:stonecutting_chipped_diagonal_warped_planks_from_warped_planks" | "mcwdoors:acacia_bamboo_door" | "compressedblocks:shaped_sextuple_crated_sugar_cane" | "chipped_express:stonecutting_chipped_fine_lapis_block_pillar_from_lapis_block" | "moa_decor_science:sueronegro_1" | "botanypots:pamhc2crops/crop/cotton" | "chipped_express:stonecutting_chipped_rough_prismarine_from_prismarine" | "compressedblocks:shaped_c8_deepslate" | "chipped_express:stonecutting_chipped_barky_red_carpet_from_red_carpet" | "chipped_express:stonecutting_chipped_grid_pink_concrete_from_pink_concrete" | "chipped_express:stonecutting_chipped_spider_calcite_carving_from_calcite" | "mcwfurnitures:birch_glass_table" | "create:milling/sugar_cane" | "refinedstorage:coloring_recipes/green_network_transmitter" | "botanypots:minecraft/crop/moss" | "conditional:decorative_blocks/wood_cutter/crimson_hyphae_beam_woodcutter" | "chipped_express:stonecutting_chipped_goldkin_from_pumpkin" | "createdeco:black_placard" | "luphieclutteredmod:luphie_sketchbook_stack_recipe" | "create:smelting/tin_ingot_compat_thermal" | "chipped_express:stonecutting_chipped_tiled_bordered_redstone_block_from_redstone_block" | "biomesoplenty:pink_dye_from_pink_hibiscus" | "corail_woodcutter:woodcutting/tropicraft/mangrove_stairs_from_mangrove_planks" | "corail_woodcutter:woodcutting/biomesoplenty/redwood_button_from_redwood_planks" | "compressedblocks:shaped_sextuple_crated_salmon" | "chipped_express:stonecutting_chipped_smooth_ringed_amethyst_block_from_amethyst_block" | "createdeco:blue_brick_slab_from_tiled_blue_bricks_stonecutting" | "mcwwindows:stripped_cherry_log_window" | "compressedblocks:shapeless_septuple_crated_blaze_powder" | "gemsnjewels:create/create_crushing_kunzite_deepslate_ore" | "compressedblocks:shaped_quintuple_crated_comparator" | "chipped_express:stonecutting_chipped_smoothed_double_inlayed_cobblestone_from_cobblestone" | "meadow:wood_cutter/mangrove/mangrove_trapdoor_woodcutter" | "quark:building/crafting/shingles/yellow_shingles" | "chipped_express:stonecutting_chipped_stop_purple_concrete_from_purple_concrete" | "minecraft:quartz_bricks" | "botania:mana_infusion/jungle_sapling_to_acacia_sapling" | "minecraft:map_cloning" | "quark:world/crafting/woodsets/azalea/button" | "compressedblocks:shapeless_quintuple_crated_lily_of_the_valley" | "meadow:wood_cutter/spruce/spruce_button_woodcutter" | "macawsroofsbop:dead_planks_steep_roof" | "mcwroofs:gray_roof_slab" | "botanypots:biomesoplenty/crop/glowflower" | "chipped_express:stonecutting_chipped_detailed_bamboo_planks_from_bamboo_planks" | "mcwbridges:balustrade_sandstone_bridge" | "snowyspirit:compressedblocks/sled_c1_dark_oak" | "refinedstorage:coloring_recipes/yellow_disk_manipulator" | "mcwbridges:prismarine_bricks_bridge_stair" | "mcwroofs:warped_planks_attic_roof" | "botania:crystal_bow" | "compressedblocks:shaped_giga_crated_gray_carpet" | "createaddition:crafting/spool" | "farmersdelight:cutting/bamboo_door" | "moa_decor_lights:vt_bacacia_1" | "waystones:warp_plate" | "pamhc2foodextended:ediblerootitem" | "aquaculturedelight:catfish_barbecue_stick" | "minecraft:raw_gold_block" | "minecraft:birch_door" | "snowyspirit:compressedblocks/sled_c8_cherry" | "compressedblocks:shapeless_triple_crated_quartz" | "mcwfences:crimson_horse_fence" | "compressedblocks:shapeless_quadruple_crated_seagrass" | "compressedblocks:shapeless_crated_sunflower" | "mcwroofs:jungle_planks_steep_roof" | "chipped_express:stonecutting_chipped_cornered_cyan_carpet_from_cyan_carpet" | "botanypots:minecraft/crop/cactus" | "compressedblocks:shapeless_septuple_crated_pufferfish" | "railways:sequenced_assembly/track_tfc_ash_narrow" | "compressedblocks:shaped_septuple_crated_honey_bottle" | "handcrafted:acacia_corner_trim" | "railways:stonecutting/palettes/cycling/brown_locometal_pillar" | "chipped_express:stonecutting_chipped_woven_brown_stained_glass_pane_from_brown_stained_glass_pane" | "luphieclutteredmod:luphie_white_right_outer_corner_counter_recipe" | "mcwbridges:warped_bridge_pier" | "createdeco:tiled_dusk_brick_stairs_from_short_dusk_bricks_stonecutting" | "minecraft:birch_fence_gate" | "cosmeticarmoursmod:green_plaid_2_skirt" | "botanypots:pamhc2crops/crop/mustardseeds" | "chipped_express:stonecutting_chipped_rough_sandstone_from_sandstone" | "delightful:food/nut_butter_and_jelly_sandwich" | "compressedblocks:shaped_giga_crated_chicken" | "domesticationinnovation:drum" | "vinery:apple_wood" | "mcwdoors:warped_stem_glass_door" | "createdeco:blue_brick_slab_from_short_blue_bricks_stonecutting" | "libraryferret:crafting_shaped/fake_emerald_block" | "create:compat/atmospheric/milling/warm_monkey_brush" | "botania:terra_pick" | "sophisticatedbackpacks:auto_smoking_upgrade" | "botania:brewery" | "compressedblocks:shapeless_sextuple_crated_snowball" | "compressedblocks:shaped_c6_granite" | "compressedblocks:shapeless_crated_potato" | "botania:blood_pendant" | "compressedblocks:shaped_c7_waxed_weathered_cut_copper" | "candlelight:letter_open" | "mcwroofs:light_gray_concrete_upper_lower_roof" | "minecraft:mud_brick_wall" | "chipped_express:stonecutting_chipped_smoothed_double_inlayed_prismarine_from_prismarine" | "botania:marimorphosis/metamorphic_plains_stone" | "pamhc2foodcore:sweetberryyogurtitem" | "minecraft:prismarine_wall_from_prismarine_stonecutting" | "railways:dying_existing_cap_cyan" | "quark:building/stonecutting/slabs/blue_nether_bricks_slab_stonecutter" | "botania:terra_plate" | "chipped_express:stonecutting_chipped_inlayed_mossy_stone_bricks_from_mossy_stone_bricks" | "quark:building/crafting/sandstone_bricks" | "macawsroofsbop:mahogany_upper_lower_roof" | "gemsnjewels:aquamarine_set_gold_crown" | "create:cutting/compat/botania/glimmering_stripped_livingwood" | "create:cutting/compat/byg/stripped_jacaranda_log" | "compressedblocks:shapeless_quadruple_crated_glow_lichen" | "minecraft:redstone_block" | "createdeco:pearl_bricks_from_tiled_pearl_bricks_stonecutting" | "compressedblocks:shaped_triple_crated_cooked_rabbit" | "minecraft:honeycomb_block" | "nethersdelight:cutting/propelplant_cane" | "cookingforblockheads:recipe_book_smelting" | "compressedblocks:shapeless_septuple_crated_light_blue_carpet" | "gemsnjewels:stacked_peridot_block" | "mcwdoors:crimson_beach_door" | "corail_woodcutter:woodcutting/biomesoplenty/magic_sign_from_magic_logs" | "framedblocks:framed_elevated_double_slope_slab" | "createdeco:mossy_scarlet_bricks_from_vine" | "create_central_kitchen:crafting/honey_cake_from_slices" | "chipped_express:stonecutting_chipped_yellow_glazed_terracotta_smooth_tiles_from_yellow_glazed_terracotta" | "chipped_express:stonecutting_chipped_harsh_quilted_purple_wool_from_purple_wool" | "gemsnjewels:forge_black_opal_set_gold_ring" | "quark:building/crafting/slabs/orange_shingles_slab" | "chipped_express:stonecutting_chipped_oak_large_diamond_glass_from_glass" | "createaddition:liquid_burning/gasoline" | "chipped_express:stonecutting_chipped_ornate_mud_bricks_pillar_from_mud_bricks" | "minecraft:dye_pink_bed" | "chipped_express:stonecutting_chipped_ribbled_lime_wool_from_lime_wool" | "create_confectionery:bar_of_black_chocolate_recipe" | "bloomingnature:brown_mushroom_brick_slab" | "create:crafting/materials/electron_tube" | "chipped_express:stonecutting_chipped_elemental_pearlescent_froglight_from_pearlescent_froglight" | "chipped_express:stonecutting_chipped_lodestone_mini_tiles_from_lodestone" | "compressedblocks:shaped_c5_end_stone" | "farmersdelight:wheat_dough_from_water" | "pamhc2foodextended:etonmessitem" | "mcwlights:pink_lamp" | "macawsroofsbop:hellbark_steep_roof" | "compressedblocks:shaped_septuple_crated_anvil" | "immersive_aircraft:steel_boiler" | "chipped_express:stonecutting_chipped_cracked_disordered_purpur_block_bricks_from_purpur_block" | "compressedblocks:shaped_octuple_crated_rotten_flesh" | "chipped_express:stonecutting_chipped_ornate_light_gray_stained_glass_from_light_gray_stained_glass" | "create:compat/botania/milling/cyan_petal" | "mcwroofs:mangrove_planks_steep_roof" | "botania:apothecary_forest" | "compressedblocks:shaped_triple_crated_book" | "chipped_express:stonecutting_chipped_boarded_birch_door_from_birch_door" | "create:compat/betterendforge/pressing/cave_moss_path" | "chipped_express:stonecutting_chipped_bolted_gray_concrete_from_gray_concrete" | "moa_decor_science:telescopio_1" | "framedcompactdrawers:framed_full_four" | "quark:building/stonecutting/stonevariants/diorite_bricks_stonecutter" | "pamhc2foodextended:cactusfruitjellyitem" | "candlelight:hearth" | "quark:building/crafting/duskbound_block_without_myalite" | "compressedblocks:shapeless_c8_weathered_cut_copper" | "bloomingnature:chestnut_pressure_plate" | "compressedblocks:shaped_triple_crated_bone" | "mcwroofs:cherry_top_roof" | "compressedblocks:shaped_triple_crated_cooked_porkchop" | "moa_decor_science:pizarraabecedario_1" | "minecraft:dye_cyan_carpet" | "moa_decor_science:pizarraabecedario_2" | "framedblocks:framed_elevated_double_slope_slab_rotate_to_framed_extended_double_slope_panel" | "moa_decor_art:rollodepelicula_1" | "compressedblocks:shaped_sextuple_crated_leather" | "meadow:wood_cutter/warped/warped_fencegate_woodcutter" | "botanypots:minecraft/crop/sea_pickle" | "framedblocks:framed_gate" | "compressedblocks:shapeless_double_crated_honeycomb" | "minecraft:oxidized_cut_copper_stairs" | "sophisticatedstorage:storage_link_from_controller" | "chipped_express:stonecutting_chipped_glad_bricks_from_bricks" | "pamhc2crops:radishseeditem" | "mcwfurnitures:spruce_double_drawer" | "bloomingnature:fir_sign" | "chipped_express:stonecutting_chipped_lumpy_stripped_mangrove_log_from_stripped_mangrove_log" | "chipped_express:stonecutting_chipped_spiraled_crying_obsidian_from_crying_obsidian" | "quark:building/crafting/furnaces/blackstone_furnace" | "delightful:cutting/cantaloupe" | "chipped_express:stonecutting_chipped_beach_spruce_door_from_spruce_door" | "mcwfurnitures:stripped_birch_chair" | "chipped_express:stonecutting_chipped_light_sprinkled_brown_mushroom_block_from_brown_mushroom_block" | "refinedstorage:coloring_recipes/white_security_manager" | "refinedstorage:raw_advanced_processor" | "pamhc2foodcore:freshwater_x8" | "chipped_express:stonecutting_chipped_mosaic_pink_concrete_from_pink_concrete" | "minecraft:stick" | "corail_woodcutter:woodcutting/biomesoplenty/umbran_slab_from_umbran_planks" | "chipped_express:stonecutting_chipped_stacked_basalt_bricks_from_basalt" | "chipped_express:stonecutting_chipped_oak_lighted_large_bookshelf_from_bookshelf" | "botanypots:botania/crop/blue_mushroom" | "botanypots:botanypots/crafting/magenta_terracotta_compact_hopper_botany_pot" | "beautify:jungle_blinds" | "railways:sequenced_assembly/track_create_dd_rose" | "chipped_express:stonecutting_chipped_granite_prismarine_from_prismarine" | "mcwbridges:stonecutter_red_sandstone_bridge_stair" | "sophisticatedstorage:brown_shulker_box_to_sophisticated" | "create:crafting/kinetics/red_seat" | "create:deploying/waxed_copper_shingle_slab_from_adding_wax" | "conditional:regions_unexplored/wood_cutter/magnolia_button_woodcutter" | "mcwroofs:acacia_roof" | "botania:metamorphic_swamp_cobblestone_stairs" | "compressedblocks:shaped_double_crated_allium" | "botania:dynamic/ancient_will_attach" | "createdeco:pressing/coins/industrial_iron_coin" | "pamhc2foodextended:hamsweetpicklesandwichitem" | "createdeco:long_red_brick_slab_from_tiled_red_bricks_stonecutting" | "mcwdoors:mangrove_mystic_door" | "chipped_express:stonecutting_chipped_corny_nether_sprouts_from_nether_sprouts" | "beachparty:palm_tall_torch" | "conditional:regions_unexplored/wood_cutter/eucalyptus_trapdoor_woodcutter" | "conditional:regions_unexplored/wood_cutter/pine_door_woodcutter" | "minecraft:dried_kelp_from_campfire_cooking" | "compressedblocks:shaped_quintuple_crated_brown_carpet" | "mcwroofs:birch_upper_steep_roof" | "create:cutting/stripped_mangrove_log" | "wands:palette" | "compressedblocks:shaped_c9_gold_ore" | "compressedblocks:shaped_quintuple_crated_lime_dye" | "pamhc2foodextended:cornonthecobitem" | "compressedblocks:shapeless_double_crated_rose_bush" | "chipped_express:stonecutting_chipped_circle_oak_glass_from_glass" | "aquaculturedelight:cutting/knife/fillet_three" | "chipped_express:stonecutting_chipped_rough_warped_wart_block_from_warped_wart_block" | "aquaculturedelight:cooked_small_turtle_meat" | "paraglider:cosmetic/deku_leaf" | "playdate:ring_tower" | "framedblocks:framing_saw/framed_ext_double_corner_slope_panel" | "gemsnjewels:create/create_crushing_black_opal_ore" | "chipped_express:stonecutting_chipped_heavy_mangrove_door_from_mangrove_door" | "chipped_express:stonecutting_chipped_keyhole_mud_bricks_from_mud_bricks" | "mcwroofs:bamboo_steep_roof" | "corail_woodcutter:woodcutting/biomesoplenty/fir_pressure_plate_from_fir_logs" | "mcwroofs:mud_brick_roof" | "compressedblocks:shapeless_c3_netherite_block" | "gemsnjewels:stacked_alexandrite_stairs" | "gemsnjewels:stacked_ruby_slab" | "createaddition:compat/tconstruct/blaze_blood" | "pamhc2crops:roastedrhubarbitem_forge" | "railways:stonecutting/palettes/cycling/blue_plated_locometal" | "compressedblocks:shapeless_septuple_crated_fire_charge" | "compressedblocks:shaped_c8_tuff" | "compressedblocks:shaped_octuple_crated_sunflower" | "compressedblocks:shapeless_mega_crated_snowball" | "chipped_express:stonecutting_chipped_rounded_netherrack_bricks_from_netherrack" | "chipped_express:stonecutting_chipped_yellow_glazed_terracotta_tiles_from_yellow_glazed_terracotta" | "minecraft:brown_stained_glass_pane" | "minecraft:black_terracotta" | "chipped_express:stonecutting_chipped_raster_blue_stained_glass_from_blue_stained_glass" | "chipped_express:stonecutting_chipped_small_light_blue_terracotta_tiles_from_light_blue_terracotta" | "compressedblocks:shapeless_septuple_crated_birch_sapling" | "compressedblocks:shaped_octuple_crated_beetroot" | "cosmeticarmoursmod:white_sock_skirt_2_green" | "chipped_express:stonecutting_chipped_vertical_cut_basalt_from_basalt" | "createdeco:cracked_dusk_bricks_from_dusk_bricks_smelting" | "chipped_express:stonecutting_chipped_overlapping_cobblestone_tiles_from_cobblestone" | "chipped_express:stonecutting_chipped_basalt_pillar_top_from_basalt" | "quark:building/stonecutting/slabs/mossy_cobblestone_bricks_slab_stonecutter" | "chipped_express:stonecutting_chipped_flowered_crimson_roots_from_crimson_roots" | "supplementaries:bubble_blower_charge" | "gemsnjewels:stacked_black_opal_stairs" | "compressedblocks:shapeless_c7_stripped_oak_log" | "mcwroofs:mangrove_upper_lower_roof" | "chipped_express:stonecutting_chipped_glass_dark_oak_door_from_dark_oak_door" | "refinedstorage:coloring_recipes/pattern_grid" | "chipped_express:stonecutting_chipped_massive_borderless_bricks_bricks_from_bricks" | "luphieclutteredmod:luphie_light_gray_armchair_recipe" | "compressedblocks:shapeless_c7_gold_block" | "create:compacting/andesite_from_flint" | "chipped_express:stonecutting_chipped_damaged_birch_log_from_birch_log" | "cosmeticarmoursmod:green_plaid_2_white" | "luphieclutteredmod:luphie_mermaid_pearl_recipe" | "chipped_express:stonecutting_chipped_cornered_cyan_wool_from_cyan_wool" | "beautify:warped_blinds" | "chipped_express:stonecutting_chipped_edge_cut_warped_stem_from_warped_stem" | "chipped_express:stonecutting_chipped_layed_netherrack_bricks_from_netherrack" | "chipped_express:stonecutting_chipped_pillar_stone_bricks_from_stone" | "compressedblocks:shaped_c5_spruce_log" | "quark:tools/smithing/rune_smithing_lime" | "chipped_express:stonecutting_chipped_framed_spruce_planks_from_spruce_planks" | "createdeco:zinc_support_wedge_from_stonecutting" | "railways:sequenced_assembly/track_hexcasting_edified_wide" | "createdeco:tiled_scarlet_brick_stairs" | "compressedblocks:shapeless_sextuple_crated_apple" | "botanypots:pamhc2crops/crop/cantaloupe" | "railways:crafting/palettes/dyeing_1x/light_gray_iron_wrapped_locometal_boiler" | "bloomingnature:fir_stairs" | "chipped_express:stonecutting_chipped_tiny_brick_bordered_mossy_cobblestone_from_mossy_cobblestone" | "moa_decor_art:tamborverde_1" | "createdeco:mossy_dean_bricks_from_moss_block" | "compressedblocks:shapeless_quadruple_crated_powered_rail" | "botania:stonecutting/metamorphic_mesa_cobblestone_to_metamorphic_mesa_cobblestone_slab" | "refinedstorage:coloring_recipes/black_network_receiver" | "sophisticatedbackpacks:chipped/tinkering_table_upgrade" | "snowyspirit:bloomingnature/sled_swamp_oak" | "delightful:knives/kiwano_knife" | "botania:red_string_interceptor" | "create:crushing/deepslate_diamond_ore" | "botania:speed_up_belt" | "compressedblocks:shapeless_c5_red_sandstone" | "minecraft:gold_ingot_from_smelting_nether_gold_ore" | "framedblocks:framing_saw/framed_flat_slope_slab_corner" | "create:cut_deepslate_stairs_from_stone_types_deepslate_stonecutting" | "pamhc2foodextended:rootbeerfloatitem" | "chipped_express:stonecutting_chipped_stacked_gray_concrete_from_gray_concrete" | "railways:sequenced_assembly/track_tfc_spruce_wide" | "compressedblocks:shaped_triple_crated_vine" | "compressedblocks:shaped_c9_nether_wart_block" | "domesticationinnovation:pet_bed_blue_from_dye" | "railways:sequenced_assembly/track_twilightforest_transwood_wide" | "sophisticatedstorage:smoking_upgrade_from_smelting_upgrade" | "chipped_express:stonecutting_chipped_massive_prismarine_bricks_from_prismarine" | "compressedblocks:shaped_c0_obsidian" | "compressedblocks:shaped_crated_magenta_carpet" | "mcwlights:spruce_tiki_torch" | "chipped_express:stonecutting_chipped_fancy_green_stained_glass_pane_from_green_stained_glass_pane" | "createdeco:scarlet_bricks_from_short_scarlet_bricks_stonecutting" | "chipped_express:stonecutting_chipped_light_dusted_red_mushroom_block_from_red_mushroom_block" | "quark:building/crafting/slabs/calcite_bricks_slab" | "minecraft:smoking_cookedgroundchickenitem" | "chipped_express:stonecutting_chipped_square_orange_stained_glass_from_orange_stained_glass" | "chipped_express:stonecutting_chipped_cracked_calcite_bricks_from_calcite" | "chipped_express:stonecutting_chipped_nice_redstone_lamp_from_redstone_lamp" | "compressedblocks:shapeless_giga_crated_string" | "candlelight:pan_cooking/beef_wellington" | "mcwdoors:warped_four_panel_door" | "moa_decor_garden_:cama_m_naranja_1" | "compressedblocks:shaped_mega_crated_chicken" | "chipped_express:stonecutting_chipped_chiseled_black_terracotta_from_black_terracotta" | "mcwfurnituresbop:fir_desk" | "compressedblocks:shapeless_triple_crated_rotten_flesh" | "compressedblocks:shapeless_mega_crated_spider_eye" | "refinedstorage:coloring_recipes/pink_detector" | "mcwroofs:cobblestone_lower_roof" | "botania:stonecutting/metamorphic_plains_stone_to_chiseled_metamorphic_plains_bricks" | "create:small_ochrum_bricks_from_stone_types_ochrum_stonecutting" | "moa_decor_lights:vt_bjungla_1" | "create:compat/environmental/milling/purple_hibiscus" | "biomesoplenty:brown_dye_from_cattail" | "chipped_express:stonecutting_chipped_double_brown_mushroom_from_brown_mushroom" | "biomesoplenty:orange_sandstone_stairs" | "mcwfurnitures:mangrove_bookshelf" | "delightful:food/matcha_latte" | "vinery:cherry_planks" | "mcwdoors:mangrove_western_door" | "compressedblocks:shapeless_c5_nether_gold_ore" | "compressedblocks:shaped_quadruple_crated_spider_eye" | "chipped_express:stonecutting_chipped_tiled_magenta_stained_glass_pane_from_magenta_stained_glass_pane" | "meadow:fur_chestplate" | "compressedblocks:shaped_quintuple_crated_orange_carpet" | "quark:building/stonecutter/vertslabs/deepslate_tile_vertical_slab_from_polished_deepslate" | "refinedstorage:1024k_fluid_storage_block" | "minecraft:lapis_lazuli_from_blasting_lapis_ore" | "botania:petal_apothecary/solegnolia" | "mcwroofs:black_terracotta_upper_steep_roof" | "create:compat/druidcraft/crushing/moonstone_ore" | "mcwfurnitures:warped_stool_chair" | "minecraft:rib_armor_trim_smithing_template" | "chipped_express:stonecutting_chipped_cut_raw_copper_block_column_from_raw_copper_block" | "minecraft:cooked_chicken_from_campfire_cooking" | "create:emptying/compat/farmersdelight/milk_bottle" | "chipped_express:stonecutting_chipped_leafy_acacia_trapdoor_from_acacia_trapdoor" | "compressedblocks:shaped_c0_cut_red_sandstone" | "createdeco:tiled_verdant_brick_slab_from_long_verdant_brick_slab_stonecutting" | "mcwfurnitures:dark_oak_modern_chair" | "framedblocks:framing_saw/framed_double_half_slope" | "botania:livingwood_planks_stairs" | "mcwfurnitures:stripped_jungle_coffee_table" | "botanypots:botanypots/crafting/lime_concrete_hopper_botany_pot" | "macawsroofsbop:redwood_steep_roof" | "chipped_express:stonecutting_chipped_simple_packed_ice_pillar_from_packed_ice" | "quark:building/stonecutting/vertslabs/quartz_vertical_slab_stonecutter" | "moa_decor_garden_:cama_m_blanca_1" | "quark:world/crafting/waxed_blue_corundum" | "conditional:regions_unexplored/wood_cutter/joshua_pp_woodcutter" | "chipped_express:stonecutting_chipped_ornate_orange_stained_glass_pane_from_orange_stained_glass_pane" | "quark:building/crafting/black_stool" | "meadow:piece_of_cheese" | "pamhc2foodextended:dateyogurtitem" | "railways:sequenced_assembly/track_tfc_rosewood_wide" | "compressedblocks:shaped_crated_spruce_sapling" | "brewery:brewing/whiskey_maggoallan" | "chipped_express:stonecutting_chipped_overlapping_mud_tiles_from_mud" | "quark:building/stonecutting/slabs/tuff_bricks_slab_stonecutter" | "compressedblocks:shaped_giga_crated_repeater" | "minecraft:mossy_cobblestone_wall_from_mossy_cobblestone_stonecutting" | "moa_decor_lights:vt_babedul_1" | "beachparty:tiki_bar_mixing/pumpkin_cocktail" | "create_confectionery:ruby_chocolate_brick_slab_recipe" | "quark:tweaks/crafting/utility/wool/cyan_wool" | "compressedblocks:shapeless_crated_turtle_egg" | "chipped_express:stonecutting_chipped_sad_red_sandstone_from_red_sandstone" | "pamhc2foodextended:cornmealitem" | "chipped_express:stonecutting_chipped_eroded_tuff_from_tuff" | "mcwfences:bamboo_stockade_fence" | "create:cutting/compat/byg/stripped_baobab_log" | "moa_decor_lights:foco_rb_1" | "ecologics:cutting/flowering_azalea_wood" | "mcwwindows:jungle_louvered_shutter" | "compressedblocks:shapeless_triple_crated_flint" | "pamhc2foodextended:beetburgeritem" | "chipped_express:stonecutting_chipped_smoothed_double_inlayed_netherrack_from_netherrack" | "minecraft:dye_purple_bed" | "quark:building/stonecutting/stonevariants/diorite_bricks_wall_rough_stonecutting" | "bakery:sandstone_stove" | "chipped_express:stonecutting_chipped_cracked_flat_lapis_block_tiles_from_lapis_block" | "chipped_express:stonecutting_chipped_bolby_nether_sprouts_from_nether_sprouts" | "mcwfurnitures:stripped_oak_modern_desk" | "corail_woodcutter:woodcutting/biomesoplenty/fir_trapdoor_from_fir_logs" | "create:cutting/compat/byg/holly_wood" | "sophisticatedbackpacks:chipped/botanist_workbench_upgrade" | "create:compacting/chocolate" | "chipped_express:stonecutting_chipped_sanded_purpur_block_from_purpur_block" | "chipped_express:stonecutting_chipped_oak_planks_panel_from_oak_planks" | "quark:building/crafting/slabs/rusty_iron_plate_slab" | "railways:sequenced_assembly/track_mangrove_narrow" | "cosmeticarmoursmod:red_sock_skirt_2_white" | "createdeco:umber_brick_slab_from_long_umber_bricks_stonecutting" | "compressedblocks:shaped_giga_crated_tropical_fish" | "compressedblocks:shapeless_c7_birch_log" | "moa_decor_art:plajovendelaperla_1" | "compressedblocks:shapeless_crated_cookie" | "supplementaries:bellows" | "railways:sequenced_assembly/track_byg_white_mangrove_narrow" | "chipped_express:stonecutting_chipped_orange_terracotta_column_from_orange_terracotta" | "create_confectionery:honey_candy_recipe" | "moa_decor_cookery:manzanadorada_1" | "compressedblocks:shapeless_septuple_crated_egg" | "gemsnjewels:stacked_citrine_stairs" | "mcwfurnitures:acacia_drawer" | "railways:sequenced_assembly/cyan_conductor_cap" | "compressedblocks:shaped_c5_cut_copper" | "compressedblocks:shapeless_octuple_crated_poisonous_potato" | "compressedblocks:shapeless_octuple_crated_lantern" | "chipped_express:stonecutting_chipped_knitted_brown_wool_from_brown_wool" | "create_central_kitchen:compacting/cake" | "chipped_express:stonecutting_chipped_stacked_bamboo_planks_from_bamboo_planks" | "createaddition:compat/jeed/shocking" | "create:cut_tuff_wall" | "create:compat/environmental/milling/red_hibiscus" | "chipped_express:stonecutting_chipped_crafted_white_carpet_from_white_carpet" | "quark:world/crafting/woodsets/ancient/boat" | "compressedblocks:shaped_c6_mangrove_planks" | "quark:building/stonecutting/vertslabs/mud_brick_vertical_slab_stonecutter" | "mcwfurnitures:stripped_oak_desk" | "createdeco:copper_catwalk_forge" | "chipped_express:stonecutting_chipped_cross_haired_cyan_carpet_from_cyan_carpet" | "compressedblocks:shaped_crated_mutton" | "vinery:wine_fermentation/kelp_cider" | "corail_woodcutter:woodcutting/biomesoplenty/umbran_sign_from_umbran_planks" | "compressedblocks:shaped_giga_crated_blue_orchid" | "create:crafting/kinetics/black_seat_from_other_seat" | "chipped_express:stonecutting_chipped_arched_brown_stained_glass_pillar_from_brown_stained_glass" | "conditional:regions_unexplored/wood_cutter/blackwood_fencegate_woodcutter" | "railways:sequenced_assembly/track_tfc_mangrove_wide" | "botania:slab_recombine/metamorphic_mountain_bricks" | "luphieclutteredmod:luphie_flowering_pink_pressure_plate_recipe" | "cosmeticarmoursmod:plain_mask_rec" | "refinedstorage:coloring_recipes/lime_network_receiver" | "moa_decor_science:matrazbrosa_1" | "luphieclutteredmod:luphie_purple_gumball_machine_recipe" | "mcwfurnituresbop:willow_modern_wardrobe" | "compressedblocks:shapeless_c2_stone" | "create:compat/byg/milling/amaranth" | "compressedblocks:shaped_c5_weathered_cut_copper" | "mcwroofs:white_attic_roof" | "farmersdelight:cutting/dark_oak_wood" | "chipped_express:stonecutting_chipped_l_sign_stripped_jungle_log_from_stripped_jungle_log" | "snowyspirit:compressedblocks/sled_c0_spruce" | "chipped_express:stonecutting_chipped_cracked_flat_netherrack_tiles_from_netherrack" | "railways:crafting/palettes/dyeing_1x/black_copper_wrapped_locometal" | "corail_woodcutter:woodcutting/dark_oak_boat_from_dark_oak_logs" | "chipped_express:stonecutting_chipped_engraved_lodestone_from_lodestone" | "naturalist:pumpkin_pie" | "corail_woodcutter:woodcutting/acacia_stairs_from_acacia_planks" | "chipped_express:stonecutting_chipped_end_carved_pumpkin_from_carved_pumpkin" | "mcwwindows:stripped_acacia_log_window2" | "create:calcite_from_stone_types_calcite_stonecutting" | "mcwwindows:dark_prismarine_pane_window" | "moa_decor_garden_:m_pabedul_1" | "chipped_express:stonecutting_chipped_simple_packed_mud_pillar_from_packed_mud" | "corail_woodcutter:woodcutting/biomesoplenty/mahogany_stairs_from_mahogany_planks" | "gemsnjewels:stacked_amethyst_slab" | "handcrafted:spruce_desk" | "farmersdelight:cooking/cooked_rice" | "minecraft:iron_sword" | "sophisticatedstorage:copper_barrel" | "chipped_express:stonecutting_chipped_rusted_magenta_concrete_from_magenta_concrete" | "createdeco:decal_top_right" | "create:milling/saddle" | "chipped_express:stonecutting_chipped_sign_stripped_birch_log_from_stripped_birch_log" | "railways:crafting/palettes/dyeing_8x/red_flat_slashed_locometal" | "quark:building/stonecutting/vertslabs/myalite_vertical_slab_stonecutter" | "botania:runic_altar" | "moa_decor_cookery:amanglesc_1" | "create:splashing/thermal/crushed_raw_tin" | "chipped_express:stonecutting_chipped_red_sandstone_pillar_from_red_sandstone" | "createdeco:pearl_brick_slab_from_long_pearl_bricks_stonecutting" | "cosmeticarmoursmod:white_sock_plaid_2_brown" | "railways:stonecutting/palettes/cycling/slashed_locometal" | "minecraft:chiseled_sandstone_from_sandstone_stonecutting" | "comforts:hammock_red" | "chipped_express:stonecutting_chipped_stem_warped_roots_from_warped_roots" | "moa_decor_art:guitarraelectricanegra_1" | "botania:quartz_red" | "pamhc2foodextended:mixedsaladitem" | "chipped_express:stonecutting_chipped_laced_birch_planks_from_birch_planks" | "farmersdelight:cutting/leather_helmet" | "minecraft:cut_copper_stairs_from_cut_copper_stonecutting" | "chipped_express:stonecutting_chipped_vertical_stiped_black_stained_glass_pane_from_black_stained_glass_pane" | "chipped_express:stonecutting_chipped_hexagonical_terracotta_from_terracotta" | "supplementaries:redstone_illuminator" | "railways:mechanical_crafting/black_copper_wrapped_locometal_boiler" | "chipped_express:stonecutting_chipped_eroded_snow_block_from_snow_block" | "delightful:food/smore_from_chocolate" | "corail_woodcutter:woodcutting/jungle_pressure_plate_from_jungle_logs" | "mcwtrpdoors:dark_oak_classic_trapdoor" | "quark:building/crafting/glowing_glass_item_frame" | "quark:building/stonecutting/vertslabs/polished_blackstone_vertical_slab_stonecutter2" | "railways:sequenced_assembly/track_monorail" | "compressedblocks:shaped_triple_crated_mangrove_propagule" | "chipped_express:stonecutting_chipped_red_nether_bricks_mini_tiles_from_red_nether_bricks" | "cosmeticarmoursmod:magenta_sock_skirt_2_plaid" | "createdeco:cracked_scarlet_brick_slab_from_cracked_scarlet_bricks_stonecutting" | "create:crafting/kinetics/metal_girder" | "refinedstorage:64k_fluid_storage_part" | "pamhc2foodextended:ranchfriedchickenitem" | "createdeco:red_andesite_lamp" | "chipped_express:stonecutting_chipped_blocky_red_wool_from_red_wool" | "bakery:stove/croissant" | "compressedblocks:shaped_c9_weathered_cut_copper" | "railways:crafting/palettes/wrapping/purple_copper_wrapped_locometal" | "mcwwindows:mangrove_blinds" | "chipped_express:stonecutting_chipped_overlapping_mud_bricks_tiles_from_mud_bricks" | "chipped_express:stonecutting_chipped_triangular_red_terracotta_from_red_terracotta" | "botania:stonecutting/metamorphic_taiga_cobblestone_to_metamorphic_taiga_cobblestone_slab" | "chipped_express:stonecutting_chipped_blue_terracotta_pillar_from_blue_terracotta" | "chipped_express:stonecutting_chipped_tiled_bordered_red_nether_bricks_from_red_nether_bricks" | "botania:mana_infusion/mana_bottle" | "chipped_express:stonecutting_chipped_light_leaf_lily_pad_from_lily_pad" | "moa_decor_lights:lm_nazul_1" | "mcwbridges:jungle_rail_bridge" | "mcwbridges:crimson_log_bridge_stair" | "chipped_express:stonecutting_chipped_stacked_end_stone_bricks_from_end_stone" | "mcwroofs:magenta_concrete_upper_lower_roof" | "compressedblocks:shapeless_triple_crated_glow_berries" | "compressedblocks:shapeless_triple_crated_red_tulip" | "luphieclutteredmod:luphie_hanging_plant_shelves_recipe" | "refinedstorage:1k_storage_part" | "snowyspirit:compressedblocks/sled_c3_jungle" | "chipped_express:stonecutting_chipped_gray_concrete_bricks_from_gray_concrete" | "quark:world/crafting/stairs/jasper_stairs" | "cosmeticarmoursmod:white_top_2_black" | "sophisticatedbackpacks:stack_upgrade_starter_tier" | "mcwfurnitures:stripped_crimson_lower_bookshelf_drawer" | "botania:slab_recombine/metamorphic_mesa_cobblestone" | "chipped_express:stonecutting_chipped_mangrove_planks_shavings_from_mangrove_planks" | "moa_decor_toys:vaca_1" | "quark:building/crafting/vertslabs/polished_calcite_vertical_slab_revert" | "quark:oddities/crafting/tiny_potato_heart" | "chipped_express:stonecutting_chipped_cracked_sandstone_bricks_from_sandstone" | "compressedblocks:shapeless_c6_spruce_log" | "moa_decor_toys:caballocafe_m_1" | "railways:crafting/palettes/dyeing_8x/cyan_plated_locometal" | "quark:world/crafting/woodsets/ancient/fence" | "chiselsandbits:magnifying_glass" | "botania:magenta_floating_flower" | "chipped_express:stonecutting_chipped_pillar_borderless_bricks_bricks_from_bricks" | "chipped_express:stonecutting_chipped_fancy_packed_mud_from_packed_mud" | "pamhc2foodextended:hushpuppiesitem" | "botanypots:botanypots/crafting/blue_terracotta_hopper_botany_pot" | "create:cut_dripstone_wall" | "biomesoplenty:fir_hanging_sign" | "compressedblocks:shaped_sextuple_crated_dandelion" | "compressedblocks:shaped_c5_granite" | "chipped_express:stonecutting_chipped_creeper_snow_block_carving_from_snow_block" | "bloomingnature:swamp_oak_button" | "mcwfurnitures:cherry_covered_desk" | "create:cutting/compat/byg/mahogany_log" | "minecraft:cut_red_sandstone" | "chipped_express:stonecutting_chipped_leafy_crimson_trapdoor_from_crimson_trapdoor" | "corail_woodcutter:woodcutting/oak_sign_from_oak_logs" | "compressedblocks:shaped_c6_stripped_acacia_log" | "moa_decor_bath:c_tazulesclaras_1" | "mcwfurnituresbop:palm_stool_chair" | "delightful:melon_slice" | "chipped_express:stonecutting_chipped_reinforced_mangrove_crate_from_barrel" | "chipped_express:stonecutting_chipped_f_sign_stripped_birch_log_from_stripped_birch_log" | "chipped_express:stonecutting_chipped_massive_mossy_stone_bricks_bricks_from_mossy_stone_bricks" | "mcwlights:double_street_lamp" | "bakery:pot_cooking/beetroot_soup" | "cosmeticarmoursmod:white_top_2_blue" | "chipped_express:stonecutting_chipped_lumpy_stripped_warped_stem_from_stripped_warped_stem" | "deep_aether:cutting/cruderoot_wood" | "compressedblocks:shaped_c8_stripped_acacia_log" | "chipped_express:stonecutting_chipped_stacked_raw_iron_block_bricks_from_raw_iron_block" | "compressedblocks:shapeless_triple_crated_cooked_mutton" | "chipped_express:stonecutting_chipped_orange_terracotta_pillar_from_orange_terracotta" | "farmersdelight:canvas_sign" | "chipped_express:stonecutting_chipped_red_sandstone_pillar_top_from_red_sandstone" | "chipped_express:stonecutting_chipped_circular_gray_terracotta_from_gray_terracotta" | "cosmeticarmoursmod:light_blue_sock_skirt_2_plaid" | "mcwtrpdoors:oak_swamp_trapdoor" | "moa_decor_toys:lepisma_1" | "create:cut_limestone_brick_stairs" | "chipped_express:stonecutting_chipped_cross_laced_dark_oak_planks_from_dark_oak_planks" | "mcwfurnitures:crimson_cupboard_counter" | "quark:building/crafting/vertplanks/vertical_warped_planks" | "minecraft:deepslate_brick_stairs_from_polished_deepslate_stonecutting" | "create:item_application/copper_casing_from_log" | "chipped_express:stonecutting_chipped_rounded_raw_gold_block_bricks_from_raw_gold_block" | "railways:crafting/palettes/dyeing_1x/light_gray_plated_locometal" | "chipped_express:stonecutting_chipped_wider_diamond_lodestone_from_lodestone" | "alexsmobs:cooked_catfish" | "chipped_express:stonecutting_chipped_broken_glowstone_from_glowstone" | "farmersdelight:oak_cabinet" | "chipped_express:stonecutting_chipped_striped_orange_concrete_from_orange_concrete" | "chipped_express:stonecutting_chipped_arched_white_stained_glass_pillar_from_white_stained_glass" | "farmersdelight:integration/immersiveengineering/crusher/wild_rice" | "chipped_express:stonecutting_chipped_brick_bordered_amethyst_block_from_amethyst_block" | "mcwwindows:dark_prismarine_window" | "create:compat/byg/milling/bistort" | "sophisticatedstorage:purple_shulker_box_to_sophisticated" | "botanypots:botanypots/crafting/black_glazed_terracotta_botany_pot" | "moa_decor_toys:piglin_1" | "vinery:cherry_wood" | "chipped_express:stonecutting_chipped_lumpy_stripped_spruce_log_from_stripped_spruce_log" | "vinery:coarse_dirt_slab" | "moa_decor_art:hilorosa_1" | "chipped_express:stonecutting_chipped_rectangle_purple_carpet_from_purple_carpet" | "mcwfurnitures:cherry_triple_drawer" | "mcwroofs:light_gray_roof_block" | "compressedblocks:shaped_quintuple_crated_ender_pearl" | "compressedblocks:shaped_double_crated_chain" | "create:small_crimsite_bricks_from_stone_types_crimsite_stonecutting" | "compressedblocks:shaped_septuple_crated_rabbit" | "toms_storage:inventory_proxy" | "cosmeticarmoursmod:black_bunny_ears_rec" | "railways:sequenced_assembly/track_byg_redwood" | "sophisticatedstorage:storage_link" | "alexsdelight:smelting/kangaroo_shank_campfire" | "biomesoplenty:chiseled_white_sandstone_from_white_sandstone_stonecutting" | "macawsroofsbop:umbran_planks_steep_roof" | "pamhc2foodextended:durianjuiceitem" | "create:milling/sea_pickle" | "railways:crafting/palettes/dyeing_1x/gray_flat_slashed_locometal" | "chipped_express:stonecutting_chipped_magenta_concrete_pillar_from_magenta_concrete" | "handcrafted:calcite_corner_trim" | "minecraft:yellow_wool" | "quark:building/crafting/vertslabs/soul_sandstone_vertical_slab" | "pamhc2foodextended:gravyitem" | "supplementaries:flags/flag_white" | "cookingforblockheads:dye_brown_oven" | "luphieclutteredmod:luphie_pastry_display_case_recipe_alt_3" | "luphieclutteredmod:luphie_pastry_display_case_recipe_alt_2" | "chipped_express:stonecutting_chipped_fortified_dark_oak_door_from_dark_oak_door" | "mcwbridges:birch_rail_bridge" | "botania:stonecutting/white_pavement_to_white_pavement_slab" | "railways:mechanical_crafting/blue_copper_wrapped_locometal_boiler" | "chipped_express:stonecutting_chipped_tiny_mossy_cobblestone_bricks_from_mossy_cobblestone" | "chipped_express:stonecutting_chipped_tiny_brick_bordered_gilded_blackstone_from_gilded_blackstone" | "compressedblocks:shapeless_c8_end_stone_bricks" | "pamhc2trees:cinnamon_sapling" | "chipped_express:stonecutting_chipped_smooth_inlayed_purpur_block_from_purpur_block" | "chipped_express:stonecutting_chipped_engraved_prismarine_from_prismarine" | "mcwroofs:magenta_concrete_roof" | "chipped_express:stonecutting_chipped_barky_white_wool_from_white_wool" | "create:crafting/kinetics/mechanical_plough" | "mcwtrpdoors:spruce_bark_trapdoor" | "compressedblocks:shapeless_septuple_crated_nether_star" | "botanypots:minecraft/crop/red_tulip" | "railways:sequenced_assembly/track_biomesoplenty_jacaranda_narrow" | "compressedblocks:shaped_c3_sandstone" | "corail_woodcutter:woodcutting/tropicraft/mangrove_pressure_plate_from_mangrove_planks" | "minecraft:oxidized_cut_copper_stairs_from_oxidized_cut_copper_stonecutting" | "mcwfurnitures:stripped_birch_coffee_table" | "mcwbridges:diorite_bridge" | "macawsroofsbop:umbran_planks_upper_steep_roof" | "refinedstorage:coloring_recipes/brown_controller" | "macawsroofsbop:redwood_planks_top_roof" | "luphieclutteredmod:stripped_yellow_wood_recipe" | "conditional:regions_unexplored/wood_cutter/willow_trapdoor_woodcutter" | "chipped_express:stonecutting_chipped_mosaic_green_concrete_from_green_concrete" | "chipped_express:stonecutting_chipped_whirlwind_cherry_planks_from_cherry_planks" | "railways:stonecutting/palettes/cycling/blue_locometal_smokebox" | "chipped_express:stonecutting_chipped_cut_deepslate_column_from_deepslate" | "quark:building/crafting/vertslabs/stone_vertical_slab" | "chipped_express:stonecutting_chipped_small_yellow_terracotta_tiles_from_yellow_terracotta" | "compressedblocks:shaped_c5_gravel" | "chipped_express:stonecutting_chipped_ornate_dark_prismarine_pillar_from_dark_prismarine" | "chipped_express:stonecutting_chipped_vertical_stiped_magenta_stained_glass_from_magenta_stained_glass" | "quark:building/stonecutting/stairs/raw_iron_bricks_stairs_stonecutter" | "cosmeticarmoursmod:orange_top_2_white" | "compressedblocks:shapeless_c8_birch_log" | "chipped_express:stonecutting_chipped_crying_borderless_bricks_from_bricks" | "quark:building/crafting/stairs/light_gray_shingles_stairs" | "compressedblocks:shapeless_c7_stripped_dark_oak_log" | "mcwdoors:warped_beach_door" | "compressedblocks:shaped_quadruple_crated_redstone_torch" | "compressedblocks:shapeless_c8_smooth_red_sandstone" | "create:crafting/logistics/andesite_tunnel" | "chipped_express:stonecutting_chipped_crying_mossy_stone_bricks_from_mossy_stone_bricks" | "pamhc2foodextended:dragonfruitsmoothieitem" | "framedblocks:framing_saw/framed_gate" | "compressedblocks:shapeless_c0_cobbled_deepslate" | "chipped_express:stonecutting_chipped_crying_end_stone_from_end_stone" | "mcwbridges:oak_log_bridge_middle" | "compressedblocks:shapeless_octuple_crated_cookie" | "quark:building/crafting/panes/black_framed_glass_pane" | "sophisticatedstorage:gold_shulker_from_gold_chest" | "chipped_express:stonecutting_chipped_button_mud_from_mud" | "utilitix:highspeed_rail" | "chipped_express:stonecutting_chipped_overgrown_mangrove_door_from_mangrove_door" | "corail_woodcutter:woodcutting/ladder_from_planks" | "chipped_express:stonecutting_chipped_smooth_borderless_bricks_column_from_bricks" | "compressedblocks:shapeless_triple_crated_black_dye" | "gemsnjewels:light_stone_ametrine" | "chipped_express:stonecutting_chipped_flowering_lily_pad_from_lily_pad" | "compressedblocks:shaped_c3_red_sand" | "conditional:create/mixing/cake_dough" | "compressedblocks:shapeless_double_crated_map" | "chipped_express:stonecutting_chipped_cobblestone_mini_tiles_from_cobblestone" | "mcwwindows:cherry_louvered_shutter" | "compressedblocks:shaped_giga_crated_lead" | "pamhc2foodextended:cinnamonbreaditem" | "supplementaries:candle_holders/candle_holder_soul" | "compressedblocks:shapeless_double_crated_yellow_dye" | "framedblocks:framed_stacked_corner_slope_panel" | "minecraft:dye_black_carpet" | "mcwtrpdoors:cherry_bamboo_trapdoor" | "luphieclutteredmod:yellow_planks_wood_alt_recipe" | "compressedblocks:shaped_double_crated_mangrove_propagule" | "farmersdelight:cutting/red_mushroom_colony" | "chipped_express:stonecutting_chipped_crossed_terracotta_from_terracotta" | "createdeco:short_umber_brick_stairs_from_tiled_umber_brick_stairs_stonecutting" | "create:cut_asurine_slab_recycling" | "delightful:cutting/mini_melon" | "pamhc2foodextended:greeneggsandhamitem" | "minecraft:magma_block" | "compressedblocks:shapeless_giga_crated_phantom_membrane" | "chipped_express:stonecutting_chipped_cubed_oak_webbed_bookshelf_from_bookshelf" | "railways:crafting/palettes/wrapping/black_iron_wrapped_locometal" | "compressedblocks:shaped_c4_stripped_mangrove_log" | "quark:tweaks/crafting/utility/wool/magenta_wool" | "quark:building/crafting/orange_blossom_leaf_carpet" | "compressedblocks:shapeless_c9_red_nether_bricks" | "chipped_express:stonecutting_chipped_raster_lime_stained_glass_pane_from_lime_stained_glass_pane" | "chipped_express:stonecutting_chipped_d_sign_stripped_jungle_log_from_stripped_jungle_log" | "pamhc2foodextended:apricotpieitem" | "compressedblocks:shapeless_crated_powered_rail" | "minecraft:deepslate_tile_slab_from_deepslate_tiles_stonecutting" | "framedblocks:framed_pyramid_slab" | "chipped_express:stonecutting_chipped_diorite_scales_from_diorite" | "quark:tweaks/crafting/utility/wool/red_wool" | "gemsnjewels:create/create_crushing_sapphire_ore" | "chipped_express:stonecutting_chipped_mud_pillar_top_from_mud" | "chipped:alchemy_bench" | "pamhc2foodextended:papayajellytoastitem" | "compressedblocks:shaped_septuple_crated_redstone_torch" | "compressedblocks:shaped_giga_crated_golden_carrot" | "compressedblocks:shaped_quadruple_crated_repeater" | "framedblocks:framed_sloped_stairs" | "conditional:regions_unexplored/wood_cutter/redwood_sign_woodcutter" | "chipped_express:stonecutting_chipped_massive_stone_bricks_from_stone" | "moa_decor_cookery:mermelada_1" | "create:cutting/compat/byg/blue_enchanted_wood" | "framedblocks:framed_elevated_slope_slab" | "pamhc2foodextended:strawberryjuiceitem" | "compressedblocks:shaped_double_crated_beetroot" | "moa_decor_cookery:barrilmanzana_1" | "compressedblocks:shapeless_quintuple_crated_ender_pearl" | "createdeco:umber_brick_stairs_from_short_umber_bricks_stonecutting" | "compressedblocks:shaped_double_crated_pointed_dripstone" | "compressedblocks:shaped_triple_crated_cooked_beef" | "macawsroofsbop:palm_upper_steep_roof" | "create:sequenced_assembly/track" | "compressedblocks:shaped_giga_crated_sweet_berries" | "delightful:knives/knightmetal_knife" | "chipped_express:stonecutting_chipped_end_stone_mini_tiles_from_end_stone" | "railways:mechanical_crafting/brown_iron_wrapped_locometal_boiler" | "create:mixing/tea" | "create:cut_deepslate_wall" | "chipped_express:stonecutting_chipped_checkered_diorite_tiles_from_diorite" | "gemsnjewels:stacked_dusk_emerald_block" | "chipped_express:stonecutting_chipped_smooth_ringed_mud_from_mud" | "chipped_express:stonecutting_chipped_airy_mangrove_trapdoor_from_mangrove_trapdoor" | "supplementaries:soap/spike" | "chipped_express:stonecutting_chipped_smooth_ringed_ancient_debris_from_ancient_debris" | "create:cutting/compat/twilightforest/stripped_dark_wood" | "compressedblocks:shaped_mega_crated_anvil" | "moa_decor_bath:lmanglesc_1" | "handcrafted:quartz_pillar_trim" | "libraryferret:blasting/iron_coins_jtl" | "pamhc2foodextended:meatpieitem" | "moa_decor_art:bateriagrisclaro_1" | "chipped_express:stonecutting_chipped_bordered_redstone_block_from_redstone_block" | "chipped_express:stonecutting_chipped_wrought_iron_lantern_from_lantern" | "pamhc2foodextended:lycheesmoothieitem" | "mcwroofs:oak_planks_upper_steep_roof" | "minecraft:chain" | "compressedblocks:shaped_octuple_crated_allium" | "chipped_express:stonecutting_chipped_edged_mossy_stone_bricks_bricks_from_mossy_stone_bricks" | "chipped_express:stonecutting_chipped_loded_magma_block_from_magma_block" | "create:cutting/compat/byg/imparius_hyphae" | "chipped_express:stonecutting_chipped_oak_large_diamond_glass_pane_from_glass_pane" | "luphieclutteredmod:luphie_retro_yellow_fridge_recipe" | "compressedblocks:shapeless_sextuple_crated_poisonous_potato" | "railways:stonecutting/palettes/cycling/light_gray_slashed_locometal" | "pamhc2foodextended:cookedtofuttonitem_smoker" | "compressedblocks:shapeless_triple_crated_paper" | "quark:building/crafting/stairs/pink_shingles_stairs" | "framedblocks:framed_one_way_window" | "railways:sequenced_assembly/track_tfc_mangrove" | "minecraft:oak_fence" | "chipped_express:stonecutting_chipped_cracked_flat_mossy_cobblestone_tiles_from_mossy_cobblestone" | "create:blasting/lead_ingot_compat_thermal" | "compressedblocks:shaped_quintuple_crated_rose_bush" | "chipped_express:stonecutting_chipped_scaled_red_carpet_from_red_carpet" | "candlelight:typewriter_copper" | "pamhc2foodcore:potatochipsitem" | "chipped_express:stonecutting_chipped_prismal_redstone_block_remnants_from_redstone_block" | "bloomingnature:larch_chest_boat" | "chipped_express:stonecutting_chipped_engraved_diamond_block_from_diamond_block" | "chipped_express:stonecutting_chipped_cherry_planks_shavings_from_cherry_planks" | "chipped_express:stonecutting_chipped_sliding_crimson_door_from_crimson_door" | "quark:building/stonecutting/walls/blackstone_bricks_wall_stonecutter" | "mcwroofs:gray_concrete_roof" | "mcwfurnitures:crimson_drawer_counter" | "gravestone:gravestone" | "luphieclutteredmod:lily_hills_flooring_recipe" | "minecraft:deepslate" | "compressedblocks:shapeless_c5_bone_block" | "compressedblocks:shaped_c4_stripped_jungle_log" | "mcwdoors:jungle_mystic_door" | "compressedblocks:shapeless_crated_green_dye" | "aquaculture:neptunium_pickaxe" | "chipped_express:stonecutting_chipped_etched_dirt_bricks_from_dirt" | "delightful:smoking/cactus_steak" | "createdeco:blue_brick_stairs_from_tiled_blue_bricks_stonecutting" | "botania:mana_infusion/lily_pad_to_vine" | "compressedblocks:shapeless_c6_gravel" | "chipped_express:stonecutting_chipped_wickered_green_carpet_from_green_carpet" | "createdeco:verdant_brick_slab_from_long_verdant_bricks_stonecutting" | "chipped_express:stonecutting_chipped_polished_emerald_block_from_emerald_block" | "conditional:bloomingnature/wood_cutter/chestnut_fence_woodcutter" | "compressedblocks:shaped_giga_crated_phantom_membrane" | "createdeco:andesite_support_wedge" | "createdeco:copper_trapdoor" | "framedblocks:framed_slope_slab" | "compressedblocks:shapeless_c4_oxidized_copper" | "herbalbrews:kettle_brewing/black_tea" | "moa_decor_art:premiogrammy_1" | "candlelight:acacia_table" | "fairylights:color_changing_light" | "chipped_express:stonecutting_chipped_crafted_cyan_wool_from_cyan_wool" | "compressedblocks:shaped_octuple_crated_red_dye" | "compressedblocks:shaped_quintuple_crated_cooked_mutton" | "farmersdelight:skillet" | "compressedblocks:shapeless_septuple_crated_detector_rail" | "quark:building/crafting/panes/purple_framed_glass_pane" | "candlelight:dark_oak_chair" | "moa_decor_lights:vt_ddistorsionado_1" | "compressedblocks:shapeless_crated_saddle" | "compressedblocks:shaped_sextuple_crated_white_dye" | "mcwbridges:stonecutter_balustrade_blackstone_bridge" | "mcwwindows:orange_mosaic_glass_pane" | "chipped_express:stonecutting_chipped_etched_obsidian_bricks_from_obsidian" | "create:compat/druidcraft/cutting/elder_log" | "moa_decor_holidays:esp_morado_1" | "chipped_express:stonecutting_chipped_ribbled_blue_carpet_from_blue_carpet" | "minecraft:green_terracotta" | "chipped_express:stonecutting_chipped_cracked_disordered_crying_obsidian_bricks_from_crying_obsidian" | "chipped_express:stonecutting_chipped_trodden_lapis_block_from_lapis_block" | "chipped_express:stonecutting_chipped_big_soul_lantern_from_soul_lantern" | "chipped_express:stonecutting_chipped_netherrack_mini_tiles_from_netherrack" | "chipped_express:stonecutting_chipped_triangular_yellow_terracotta_from_yellow_terracotta" | "quark:building/crafting/red_blossom_leaf_carpet" | "railways:crafting/palettes/dyeing_1x/yellow_locometal_smokebox" | "luphieclutteredmod:pink_flower_shelf_candle_recipe" | "createaddition:rolling/steel_plate" | "compressedblocks:shapeless_mega_crated_oak_sapling" | "refinedstorage:pattern_grid/white_pattern_grid" | "moa_decor_bath:brobleosc_1" | "botania:orechid/copper_ore" | "moa_decor_cookery:acarmesisc_1" | "create:cut_diorite_brick_stairs_from_stone_types_diorite_stonecutting" | "mcwfences:prismarine_railing_gate_stonecutter" | "quark:building/stonecutting/walls/raw_iron_bricks_wall_stonecutter" | "chipped_express:stonecutting_chipped_vertical_stiped_light_blue_stained_glass_pane_from_light_blue_stained_glass_pane" | "chipped_express:stonecutting_chipped_horned_mud_from_mud" | "chipped_express:stonecutting_chipped_tiled_snow_block_column_from_snow_block" | "supplementaries:gold_door" | "compressedblocks:shapeless_c3_weathered_cut_copper" | "quark:building/crafting/warped_ladder" | "compressedblocks:shapeless_double_crated_glow_lichen" | "chipped_express:stonecutting_chipped_lapis_block_scales_from_lapis_block" | "mcwfences:acacia_horse_fence" | "cosmeticarmoursmod:warden_mask_rec" | "chipped_express:stonecutting_chipped_small_dirt_bricks_from_dirt" | "compressedblocks:shaped_c4_smooth_red_sandstone" | "chipped_express:stonecutting_chipped_flowering_oak_log_from_oak_log" | "mcwfences:spruce_hedge" | "chipped_express:stonecutting_chipped_smooth_light_gray_concrete_from_light_gray_concrete" | "compressedblocks:shaped_c0_deepslate" | "compressedblocks:shaped_double_crated_magenta_dye" | "mcwfurnitures:stripped_crimson_modern_desk" | "create:cut_limestone_stairs_from_stone_types_limestone_stonecutting" | "mcwdoors:jungle_classic_door" | "compressedblocks:shapeless_mega_crated_chorus_fruit" | "compressedblocks:shaped_sextuple_crated_baked_potato" | "pamhc2foodextended:groundcinnamonitem" | "chipped_express:stonecutting_chipped_meshed_crimson_trapdoor_from_crimson_trapdoor" | "supplementaries:end_stone_lamp" | "corail_woodcutter:woodcutting/biomesoplenty/redwood_trapdoor_from_redwood_logs" | "mcwroofs:gutter_middle_green" | "mcwfurnitures:stripped_birch_double_wardrobe" | "chipped_express:stonecutting_chipped_tiny_gilded_blackstone_bricks_from_gilded_blackstone" | "botania:manasteel_shovel" | "minecraft:quartz_from_blasting" | "compressedblocks:shaped_quadruple_crated_blaze_powder" | "delightful:knives/blasting/emerald_emeraldequipment" | "botania:mossy_livingrock_bricks_vine" | "mcwtrpdoors:mangrove_beach_trapdoor" | "mcwroofs:white_steep_roof" | "moa_decor_lights:lm_gamarillo_1" | "compressedblocks:shapeless_crated_quartz" | "mcwlights:jungle_tiki_torch" | "createdeco:blue_brick_slab_from_short_blue_brick_slab_stonecutting" | "createaddition:filling/honey_cake" | "moa_decor_cookery:refrigerador_1" | "mcwbridges:stonecutter_mud_brick_bridge_stair" | "chipped_express:stonecutting_chipped_bolted_green_concrete_from_green_concrete" | "pamhc2foodextended:veggiestripsitem" | "cosmeticarmoursmod:white_top_2_orange" | "compressedblocks:shapeless_octuple_crated_rail" | "railways:crafting/palettes/dyeing_8x/brown_slashed_locometal" | "mcwfurnituresbop:palm_wardrobe" | "chipped_express:stonecutting_chipped_small_granite_bricks_from_granite" | "create:compat/betterendforge/pressing/amber_moss_path" | "chipped_express:stonecutting_chipped_edged_stripped_cherry_log_from_stripped_cherry_log" | "quark:building/crafting/vertslabs/quartz_vertical_slab_revert" | "createaddition:compat/immersiveengineering/constantan" | "pamhc2foodcore:groundchickenitem" | "railways:crafting/palettes/dyeing_8x/lime_slashed_locometal" | "railways:sequenced_assembly/track_natures_spirit_sugi_wide" | "chipped_express:stonecutting_chipped_nether_jack_o_lantern_from_jack_o_lantern" | "chipped_express:stonecutting_chipped_warted_oak_trapdoor_from_oak_trapdoor" | "minecraft:waxed_oxidized_cut_copper" | "createdeco:short_verdant_brick_slab_from_tiled_verdant_bricks_stonecutting" | "compressedblocks:shaped_giga_crated_pink_carpet" | "mcwwindows:diorite_four_window" | "chipped_express:stonecutting_chipped_woven_purple_stained_glass_from_purple_stained_glass" | "candlelight:red_nether_bricks_counter" | "mcwfurnitures:stripped_spruce_desk" | "artifacts:eternal_steak_campfire" | "biomesoplenty:umbran_stairs" | "createdeco:verdant_brick_stairs_from_long_verdant_bricks_stonecutting" | "mcwbridges:warped_rope_bridge_stair_recycle" | "chipped_express:stonecutting_chipped_unamused_packed_ice_from_packed_ice" | "create:small_calcite_brick_wall_from_stone_types_calcite_stonecutting" | "moa_decor_garden_:mangle_1" | "chipped_express:stonecutting_chipped_golden_barred_bamboo_trapdoor_from_bamboo_trapdoor" | "meadow:wood_cutter/crimson/crimson_hyphae_door_woodcutter" | "sophisticatedstorage:gold_chest" | "mcwfurnituresbop:mahogany_end_table" | "chipped_express:stonecutting_chipped_tile_windowed_oak_door_from_oak_door" | "quark:tweaks/crafting/utility/misc/chest_minecart" | "compressedblocks:shaped_crated_minecart" | "minecraft:light_blue_stained_glass_pane_from_glass_pane" | "minecraft:magenta_dye_from_lilac" | "mcwwindows:mud_brick_gothic" | "compressedblocks:shaped_c3_birch_planks" | "mcwwindows:warped_plank_pane_window" | "moa_decor_holidays:calabaza_creeper_nav_l_1" | "railways:crafting/palettes/dyeing_1x/gray_copper_wrapped_locometal_boiler" | "compressedblocks:shaped_octuple_crated_spider_eye" | "compressedblocks:shapeless_octuple_crated_beetroot_seeds" | "chipped_express:stonecutting_chipped_tiled_nether_bricks_from_nether_bricks" | "quark:building/stonecutting/vertslabs/raw_copper_bricks_vertical_slab_stonecutter" | "supplementaries:candle_holders/candle_holder_white" | "minecraft:blue_stained_glass_pane_from_glass_pane" | "gemsnjewels:light_stone_topaz" | "moa_decor_toys:ocelote_1" | "botanypots:botanypots/crafting/green_glazed_terracotta_hopper_botany_pot" | "quark:building/stonecutting/stonevariants/granite_bricks_slab_rough_stonecutting" | "handcrafted:orange_cushion" | "compressedblocks:shapeless_octuple_crated_map" | "compressedblocks:shaped_sextuple_crated_green_carpet" | "refinedstorage:coloring_recipes/green_crafter" | "chipped_express:stonecutting_chipped_cubed_brown_carpet_from_brown_carpet" | "createdeco:zinc_coinstack" | "quark:building/crafting/vertslabs/crimson_vertical_slab_revert" | "railways:sequenced_assembly/track_blue_skies_maple_wide" | "moa_decor_bath:toallaverdelimacolg_1" | "compressedblocks:shaped_double_crated_blaze_rod" | "chipped_express:stonecutting_chipped_smooth_stone_column_from_stone" | "pamhc2foodcore:icecreamitem" | "compressedblocks:shapeless_c7_soul_soil" | "mcwtrpdoors:crimson_ranch_trapdoor" | "compressedblocks:shaped_c4_weathered_cut_copper" | "chipped_express:stonecutting_chipped_rounded_raw_copper_block_bricks_from_raw_copper_block" | "quark:world/crafting/woodsets/blossom/chest_wood" | "chipped_express:stonecutting_chipped_star_mud_from_mud" | "lootbags:furniture/loot_neighborly" | "moa_decor_bath:llavesdebanera_1" | "railways:crafting/palettes/wrapping/purple_iron_wrapped_locometal" | "mcwwindows:one_way_glass" | "chipped_express:stonecutting_chipped_bundled_acacia_log_from_acacia_log" | "minecraft:spyglass" | "pamhc2foodextended:carrotjuiceitem" | "quark:building/crafting/vertplanks/vertical_blossom_planks" | "create:smelting/glass_from_horizontal_framed_glass" | "botania:metamorphic_mountain_cobblestone_wall" | "botania:mana_infusion/oxeye_daisy_to_cornflower" | "minecraft:pink_stained_glass" | "compressedblocks:shapeless_crated_pink_carpet" | "railways:crafting/palettes/dyeing_8x/red_locometal_pillar" | "chipped_express:stonecutting_chipped_secret_oak_door_from_oak_door" | "botanypots:minecraft/soil/dripstone" | "minecraft:end_stone_brick_wall_from_end_stone_brick_stonecutting" | "quark:world/crafting/woodsets/ancient/chest_wood" | "mcwbridges:stonecutter_granite_bridge" | "compressedblocks:shapeless_c5_oak_planks" | "create:cutting/jungle_wood" | "domesticationinnovation:pet_bed_cyan_from_dye" | "chipped_express:stonecutting_chipped_duh_mud_bricks_from_mud_bricks" | "snowyspirit:glow_lights_yellow" | "compressedblocks:shapeless_giga_crated_fermented_spider_eye" | "chipped_express:stonecutting_chipped_warning_red_concrete_from_red_concrete" | "chipped_express:stonecutting_chipped_hooded_warped_fungus_from_warped_fungus" | "chipped_express:stonecutting_chipped_grid_light_blue_concrete_from_light_blue_concrete" | "moa_decor_cookery:croblesc_1" | "minecraft:raiser_armor_trim_smithing_template" | "farmersdelight:white_canvas_sign" | "compressedblocks:shapeless_octuple_crated_leather" | "botania:slab_recombine/green_pavement" | "gemsnjewels:topaz" | "quark:world/stonecutting/walls/myalite_bricks_wall_stonecutter" | "create:crushing/amethyst_cluster" | "chipped_express:stonecutting_chipped_pegged_purple_concrete_from_purple_concrete" | "create:polished_cut_dripstone_from_stone_types_dripstone_stonecutting" | "chipped_express:stonecutting_chipped_boxed_crimson_planks_from_crimson_planks" | "corail_woodcutter:acacia_woodcutter" | "compressedblocks:shapeless_octuple_crated_sunflower" | "compressedblocks:shaped_mega_crated_spider_eye" | "create:crafting/appliances/copper_diving_helmet" | "gemsnjewels:stacked_alexandrite_slab" | "compressedblocks:shapeless_c8_nether_wart_block" | "botanypots:minecraft/soil/soul_soil" | "chipped_express:stonecutting_chipped_bordered_lodestone_from_lodestone" | "chipped_express:stonecutting_chipped_windmill_orange_carpet_from_orange_carpet" | "chipped_express:stonecutting_chipped_shack_warped_door_from_warped_door" | "compressedblocks:shapeless_triple_crated_potato" | "aether:moa_egg_cake" | "moa_decor_art:tambornaranja_1" | "chipped_express:stonecutting_chipped_tiny_granite_bricks_from_granite" | "supplementaries:hat_stand" | "mcwroofs:yellow_terracotta_attic_roof" | "supplementaries:compressedblocks/sign_post_c7_jungle" | "moa_decor_cookery:froble_1" | "compressedblocks:shapeless_octuple_crated_nether_star" | "chipped_express:stonecutting_chipped_oak_ornate_bared_glass_from_glass" | "minecraft:bamboo_slab" | "railways:sequenced_assembly/track_natures_spirit_joshua_wide" | "railways:stonecutting/palettes/cycling/white_flat_slashed_locometal" | "compressedblocks:shapeless_c3_stripped_birch_log" | "chipped_express:stonecutting_chipped_semi_spongy_warped_wart_block_from_warped_wart_block" | "chipped_express:stonecutting_chipped_square_oak_glass_from_glass" | "compressedblocks:shaped_c3_waxed_oxidized_copper" | "pamhc2foodextended:bamboosteamedriceitem" | "compressedblocks:shaped_octuple_crated_pufferfish" | "gemsnjewels:stacked_topaz_block" | "chipped_express:stonecutting_chipped_muddy_mangrove_roots_from_mangrove_roots" | "compressedblocks:shaped_c9_iron_ore" | "chipped_express:stonecutting_chipped_layered_waxed_weathered_copper_from_waxed_weathered_copper" | "chipped_express:stonecutting_chipped_wickered_white_carpet_from_white_carpet" | "quark:building/crafting/carved_mud_bricks" | "create:emptying/builders_tea" | "luphieclutteredmod:luphie_stack_of_small_books_recipe" | "quark:tweaks/crafting/utility/bent/cookie" | "moa_decor_lights:lm_bazulclara_1" | "pamhc2foodextended:mangojuiceitem" | "compressedblocks:shaped_sextuple_crated_comparator" | "create:calcite_pillar_from_stone_types_calcite_stonecutting" | "cosmeticarmoursmod:lime_sock_plaid_2_white" | "libraryferret:smelting/emerald_coins_jtl" | "chipped_express:stonecutting_chipped_small_mud_bricks_bricks_from_mud_bricks" | "minecraft:cooked_chicken" | "moa_decor_cookery:tarro_1" | "compressedblocks:shaped_crated_sweet_berries" | "chipped_express:stonecutting_chipped_engraved_dripstone_block_from_dripstone_block" | "createdeco:long_red_brick_slab_from_tiled_red_brick_slab_stonecutting" | "chipped_express:stonecutting_chipped_oak_diamond_bordered_glass_pane_from_glass_pane" | "chipped_express:stonecutting_chipped_tiled_bordered_red_sandstone_from_red_sandstone" | "biomesoplenty:redwood_fence" | "quark:building/crafting/vertslabs/sandstone_bricks_vertical_slab_revert" | "chipped_express:stonecutting_chipped_smiling_carved_pumpkin_from_carved_pumpkin" | "createdeco:scarlet_brick_slab_from_tiled_scarlet_bricks_stonecutting" | "create:cutting/compat/byg/ebony_log" | "chipped_express:stonecutting_chipped_barred_warped_door_from_warped_door" | "mcwfurnituresbop:palm_triple_drawer" | "botania:dynamic/phantom_ink_apply" | "biomesoplenty:jacaranda_stairs" | "botania:purple_petal_block" | "compressedblocks:shapeless_mega_crated_magenta_carpet" | "mcwfurnitures:birch_table" | "pamhc2foodextended:guisoitem" | "pamhc2foodcore:basicchickensandwichitem" | "compressedblocks:shaped_giga_crated_white_tulip" | "create:cut_scoria_stairs_from_stone_types_scoria_stonecutting" | "compressedblocks:shaped_quadruple_crated_minecart" | "chipped_express:stonecutting_chipped_runic_carved_smooth_stone_from_smooth_stone" | "botania:petal_purple" | "chipped_express:stonecutting_chipped_twisted_warped_trapdoor_from_warped_trapdoor" | "moa_decor_cookery:taza_1" | "chipped_express:stonecutting_chipped_stacked_mangrove_planks_from_mangrove_planks" | "waystones:return_scroll" | "pamhc2foodextended:orangesodaitem" | "create:cutting/stripped_cherry_log" | "chipped_express:stonecutting_chipped_eroded_blue_ice_from_blue_ice" | "sophisticatedstorage:crimson_barrel" | "chipped_express:stonecutting_chipped_angry_ice_from_ice" | "chipped_express:stonecutting_chipped_dark_dotted_red_mushroom_block_from_red_mushroom_block" | "compressedblocks:shapeless_sextuple_crated_cooked_rabbit" | "compressedblocks:shaped_c3_stripped_jungle_log" | "quark:building/crafting/vertslabs/weathered_cut_copper_vertical_slab" | "compressedblocks:shapeless_septuple_crated_turtle_egg" | "quark:building/crafting/shingles/blue_shingles_dye" | "compressedblocks:shapeless_crated_crimson_fungus" | "chipped_express:stonecutting_chipped_cracked_flat_quartz_block_tiles_from_quartz_block" | "botania:vine_ball" | "mcwfurnitures:dark_oak_bookshelf_drawer" | "chipped_express:stonecutting_chipped_carved_dripstone_block_from_dripstone_block" | "chipped_express:stonecutting_chipped_vertical_cut_mossy_cobblestone_from_mossy_cobblestone" | "compressedblocks:shaped_triple_crated_oxeye_daisy" | "chipped_express:stonecutting_chipped_polished_crimson_planks_from_crimson_planks" | "create:cutting/compat/byg/cherry_log" | "delightful:integration/cooked_venison" | "moa_decor_cookery:queso_1" | "farmersdelight:straw" | "moa_decor_holidays:banderines_rosa_1" | "chipped_express:stonecutting_chipped_crafted_light_gray_carpet_from_light_gray_carpet" | "botania:balance_cloak" | "quark:building/stonecutting/vertslabs/red_sandstone_bricks_vertical_slab_stonecutter" | "compressedblocks:shaped_c7_gold_ore" | "railways:crafting/palettes/dyeing_8x/green_copper_wrapped_locometal_boiler" | "compressedblocks:shaped_c7_slime_block" | "pamhc2crops:sunchokeseeditem" | "chipped_express:stonecutting_chipped_raw_copper_block_pillar_top_from_raw_copper_block" | "quark:building/stonecutting/stairs/blue_nether_bricks_stairs_stonecutter" | "luphieclutteredmod:luphie_glow_wood_set_slab_recipe" | "minecraft:waxed_oxidized_cut_copper_slab_from_waxed_oxidized_cut_copper_stonecutting" | "pamhc2crops:blueberryseeditem" | "chipped_express:stonecutting_chipped_blackstone_mini_tiles_from_blackstone" | "corail_woodcutter:woodcutting/bowl_from_logs" | "botania:polished_livingrock_wall" | "compressedblocks:shaped_c2_chiseled_sandstone" | "compressedblocks:shaped_quadruple_crated_cocoa_beans" | "chipped_express:stonecutting_chipped_windmill_purple_wool_from_purple_wool" | "compressedblocks:shaped_c4_chiseled_sandstone" | "chipped_express:stonecutting_chipped_hexagonical_green_glazed_terracotta_from_green_glazed_terracotta" | "chipped_express:stonecutting_chipped_blank_dark_prismarine_carving_from_dark_prismarine" | "chipped_express:stonecutting_chipped_offset_blue_ice_bricks_from_blue_ice" | "delightful:campfire/marshmallow_stick" | "chipped_express:stonecutting_chipped_slanted_acacia_planks_from_acacia_planks" | "quark:building/crafting/vertslabs/tuff_bricks_vertical_slab_revert" | "pamhc2foodextended:cookedtofickenitem_forge" | "createdeco:cracked_blue_brick_slab_from_cracked_blue_bricks_stonecutting" | "chipped_express:stonecutting_chipped_lead_woven_glass_from_glass" | "chipped_express:stonecutting_chipped_tiny_tuff_bricks_from_tuff" | "chipped_express:stonecutting_chipped_edged_crying_obsidian_bricks_from_crying_obsidian" | "supplementaries:wrench" | "chipped_express:stonecutting_chipped_tiny_layered_calcite_bricks_from_calcite" | "corail_woodcutter:woodcutting/crimson_stairs_from_crimson_stems" | "compressedblocks:shaped_septuple_crated_carrot" | "compressedblocks:shapeless_quintuple_crated_pufferfish" | "chipped_express:stonecutting_chipped_cornered_green_wool_from_green_wool" | "refinedstorage:coloring_recipes/blue_fluid_grid" | "pamhc2foodextended:gourmetmuttonpattyitem" | "chipped_express:stonecutting_chipped_small_cyan_stained_glass_pane_from_cyan_stained_glass_pane" | "compressedblocks:shapeless_c0_oxidized_copper" | "botania:cosmetic_clock_eye" | "railways:crafting/palettes/dyeing_1x/cyan_locometal_boiler" | "createdeco:short_dusk_brick_stairs_from_long_dusk_bricks_stonecutting" | "minecraft:jungle_slab" | "chipped_express:stonecutting_chipped_engraved_raw_copper_block_from_raw_copper_block" | "botania:slab_recombine/blue_pavement" | "chipped_express:stonecutting_chipped_ornate_yellow_stained_glass_from_yellow_stained_glass" | "railways:stonecutting/palettes/cycling/black_flat_slashed_locometal" | "beachparty:palm_fence_gate" | "create:blasting/ingot_aluminum_compat_immersiveengineering" | "mcwfurnituresbop:fir_lower_triple_drawer" | "handcrafted:mangrove_pillar_trim" | "botania:tiny_planet" | "quark:building/crafting/cut_soul_sandstone" | "createaddition:charging/weathered_copper" | "compressedblocks:shaped_c2_spruce_log" | "minecraft:granite" | "railways:crafting/palettes/dyeing_1x/light_gray_riveted_locometal" | "compressedblocks:shapeless_c3_iron_ore" | "bloomingnature:palm_fence_gate" | "railways:mechanical_crafting/cyan_iron_wrapped_locometal_boiler" | "chipped_express:stonecutting_chipped_vertical_cut_raw_copper_block_from_raw_copper_block" | "chipped_express:stonecutting_chipped_wise_stripped_cherry_log_from_stripped_cherry_log" | "createdeco:dusk_brick_stairs_from_short_dusk_brick_stairs_stonecutting" | "chipped_express:stonecutting_chipped_paved_yellow_glazed_terracotta_from_yellow_glazed_terracotta" | "botanypots:botania/crop/gray_double_flower" | "chipped_express:stonecutting_chipped_pillar_diorite_bricks_from_diorite" | "cosmeticarmoursmod:orange_knight_armour_chestplate_rec" | "compressedblocks:shaped_giga_crated_glass_bottle" | "botanypots:delightful/crop/salmonberries" | "compressedblocks:shapeless_mega_crated_white_carpet" | "chipped_express:stonecutting_chipped_polished_granite_from_granite" | "chipped_express:stonecutting_chipped_vertical_cut_end_stone_from_end_stone" | "cosmeticarmoursmod:lime_sock_plaid_2_skirt" | "simplehats:hatscraps" | "compressedblocks:shapeless_double_crated_turtle_egg" | "corail_woodcutter:woodcutting/acacia_sign_from_acacia_planks" | "compressedblocks:shapeless_c0_cherry_log" | "chipped_express:stonecutting_chipped_sign_stripped_mangrove_log_from_stripped_mangrove_log" | "corail_woodcutter:woodcutting/biomesoplenty/mahogany_slab_from_mahogany_planks" | "quark:tweaks/crafting/utility/chests/oak_chest_wood" | "farmersdelight:cutting/kelp_roll" | "createdeco:decal_ice" | "chipped_express:stonecutting_chipped_flat_borderless_bricks_tiles_from_bricks" | "delightful:knives/stellium_knife" | "mcwbridges:stonecutter_balustrade_nether_bricks_bridge" | "moa_decor_lights:lm_brojo_1" | "gemsnjewels:black_opal" | "compressedblocks:shapeless_quintuple_crated_shulker_shell" | "chipped_express:stonecutting_chipped_acacia_planks_mosaic_from_acacia_planks" | "compressedblocks:shaped_giga_crated_rabbit_foot" | "gemsnjewels:stacked_peridot_stairs" | "botanypots:pamhc2crops/crop/elderberry" | "chipped_express:stonecutting_chipped_large_tiled_mud_bricks_from_mud_bricks" | "quark:building/stonecutting/stonevariants/andesite_bricks_slab_polished_stonecutting" | "compressedblocks:shapeless_crated_white_tulip" | "pamhc2trees:papaya_sapling" | "quark:building/stonecutting/stonevariants/limestone_bricks_slab_rough_stonecutting" | "cosmeticarmoursmod:black_sock_plaid_2_white" | "mcwdoors:jungle_tropical_door" | "compressedblocks:shaped_septuple_crated_string" | "compressedblocks:shaped_septuple_crated_red_mushroom" | "mcwdoors:garage_black_door" | "chipped_express:stonecutting_chipped_tiny_layered_blackstone_slabs_from_blackstone" | "create:andesite_bars_from_andesite_alloy_stonecutting" | "mcwdoors:oak_barn_door" | "snowyspirit:bloomingnature/sled_fir" | "compressedblocks:shapeless_c9_waxed_copper_block" | "compressedblocks:shaped_quintuple_crated_arrow" | "candlelight:side_table" | "biomesoplenty:dead_hanging_sign" | "chipped_express:stonecutting_chipped_crated_mangrove_planks_from_mangrove_planks" | "mcwwindows:stripped_jungle_log_window2" | "botania:glimmering_stripped_livingwood_log" | "refinedstorage:coloring_recipes/light_gray_crafting_monitor" | "minecraft:purpur_slab_from_purpur_block_stonecutting" | "compressedblocks:shapeless_c3_smooth_red_sandstone" | "chipped_express:stonecutting_chipped_squished_cute_jack_o_lantern_from_jack_o_lantern" | "bloomingnature:larch_stairs" | "botania:lava_pendant" | "compressedblocks:shapeless_c2_stripped_birch_log" | "botanypots:farming_crossing/crop/pamhc2treespecan_sapling" | "supplementaries:candle_holders/candle_holder_black" | "railways:crafting/palettes/dyeing_8x/brown_copper_wrapped_locometal" | "compressedblocks:shaped_crated_leather" | "gemsnjewels:stacked_aquamarine_stairs" | "chipped_express:stonecutting_chipped_damaged_acacia_log_from_acacia_log" | "quark:building/crafting/glass_item_frame" | "corail_woodcutter:woodcutting/crimson_fence_from_crimson_planks" | "quark:building/crafting/raw_iron_bricks" | "chipped_express:stonecutting_chipped_vertical_cut_dirt_from_dirt" | "create:cutting/compat/byg/lament_wood" | "compressedblocks:shapeless_crated_ink_sac" | "chipped_express:stonecutting_chipped_k_sign_stripped_birch_log_from_stripped_birch_log" | "botanypots:biomesoplenty/crop/hair" | "sophisticatedstorage:bamboo_limited_barrel_1" | "compressedblocks:shapeless_sextuple_crated_sculk_vein" | "vinery:wine_fermentation/creepers_crush" | "luphieclutteredmod:luphie_flowering_purple_button_recipe" | "chipped_express:stonecutting_chipped_bundled_brown_wool_from_brown_wool" | "botanypots:biomesoplenty/crop/orange_cosmos" | "mcwfences:blackstone_railing_gate" | "chipped_express:stonecutting_chipped_cross_laced_cherry_planks_from_cherry_planks" | "compressedblocks:shaped_double_crated_amethyst_shard" | "sophisticatedstorage:bamboo_limited_barrel_4" | "botania:orechid/lapis_ore" | "chipped_express:stonecutting_chipped_heavy_oak_door_from_oak_door" | "chipped_express:stonecutting_chipped_smooth_ringed_clay_from_clay" | "sophisticatedstorage:bamboo_limited_barrel_2" | "createdeco:short_red_bricks_from_long_red_bricks_stonecutting" | "sophisticatedstorage:bamboo_limited_barrel_3" | "cookingforblockheads:sink" | "botania:metamorphic_desert_bricks" | "mcwfurnitures:dark_oak_end_table" | "botania:hourglass" | "chipped_express:stonecutting_chipped_loded_granite_from_granite" | "compressedblocks:shapeless_c8_waxed_copper_block" | "pamhc2foodextended:rambutanjellysandwichitem" | "mcwfurnitures:stripped_spruce_coffee_table" | "cosmeticarmoursmod:white_sock_plaid_2_yellow" | "bloomingnature:fir_planks" | "createdeco:copper_mesh_fence" | "mcwfurnitures:spruce_double_wardrobe" | "create:cut_scoria_brick_wall_from_stone_types_scoria_stonecutting" | "chipped_express:stonecutting_chipped_tiled_obsidian_column_from_obsidian" | "meadow:stove_tiles_wood" | "herbalbrews:brown_dye_from_coffee_beans" | "railways:crafting/palettes/dyeing_1x/white_plated_locometal" | "pamhc2foodextended:cranberryjuiceitem" | "compressedblocks:shaped_crated_cobweb" | "chipped_express:stonecutting_chipped_tiny_layered_smooth_stone_slabs_from_smooth_stone" | "quark:mobs/smoking/cooked_crab_leg" | "pamhc2foodextended:peanutbuttercupitem" | "minecraft:brown_cushion_from_brown_dye" | "quark:world/crafting/woodsets/ancient/trapped_chest" | "chipped_express:stonecutting_chipped_simple_tuff_pillar_from_tuff" | "brewery:rope" | "chipped_express:stonecutting_chipped_edged_raw_copper_block_bricks_from_raw_copper_block" | "corail_woodcutter:woodcutting/biomesoplenty/fir_sign_from_fir_planks" | "mcwfurnitures:birch_triple_drawer" | "chipped_express:stonecutting_chipped_etched_calcite_bricks_from_calcite" | "chipped_express:stonecutting_chipped_eroded_purpur_block_from_purpur_block" | "chipped_express:stonecutting_chipped_weathered_blue_ice_from_blue_ice" | "compressedblocks:shaped_quadruple_crated_rose_bush" | "quark:building/stonecutting/stairs/black_shingles_stairs_stonecutter2" | "compressedblocks:shaped_c9_deepslate" | "chipped_express:stonecutting_chipped_gilded_blackstone_scales_from_gilded_blackstone" | "createdeco:pearl_brick_stairs_from_tiled_pearl_bricks_stonecutting" | "pamhc2foodextended:steakfajitaitem" | "botania:petal_apothecary/rafflowsia" | "conditional:regions_unexplored/wood_cutter/palm_sign_woodcutter" | "pamhc2foodcore:softpretzelitem" | "snowyspirit:luphieclutteredmod/sled_luphie_flowering_pink" | "compressedblocks:shapeless_septuple_crated_spectral_arrow" | "moa_decor_bath:esp_ncent_1" | "chipped_express:stonecutting_chipped_lumpy_stripped_dark_oak_log_from_stripped_dark_oak_log" | "compressedblocks:shapeless_giga_crated_peony" | "moa_decor_holidays:esp_cian_1" | "createdeco:umber_brick_slab" | "minecraft:gold_nugget_from_smelting" | "quark:world/crafting/stairs/blossom_planks_stairs" | "waystones:light_gray_sharestone" | "chipped_express:stonecutting_chipped_copper_barrel_from_barrel" | "macawsroofsbop:hellbark_upper_lower_roof" | "luphieclutteredmod:luphie_halloween_wallpaper_b_recipe" | "moa_decor_art:pinturanegra_1" | "chipped_express:stonecutting_chipped_edged_obsidian_bricks_from_obsidian" | "railways:crafting/palettes/dyeing_8x/white_locometal_pillar" | "compressedblocks:shaped_c2_mangrove_planks" | "pamhc2foodcore:hotdogitem" | "chipped_express:stonecutting_chipped_grill_magenta_concrete_from_magenta_concrete" | "luphieclutteredmod:luphie_imperial_chair_recipe" | "meadow:mossy_limestone_brick_stairs_from_mossy_limestone_brick_stonecutting" | "quark:tweaks/crafting/utility/coral/horn_to_yellow" | "chipped_express:stonecutting_chipped_fine_packed_ice_pillar_from_packed_ice" | "chipped_express:stonecutting_chipped_glass_cherry_door_from_cherry_door" | "botanypots:minecraft/soil/nether_gold_ore" | "mcwroofs:purple_terracotta_upper_steep_roof" | "mcwroofs:pink_striped_awning" | "compressedblocks:shapeless_quadruple_crated_gray_dye" | "chipped_express:stonecutting_chipped_ornate_blackstone_pillar_from_blackstone" | "chipped_express:stonecutting_chipped_endstone_pointed_dripstone_from_pointed_dripstone" | "pamhc2foodextended:pumpkinoatsconesitem" | "chipped_express:stonecutting_chipped_cut_ice_column_from_ice" | "meadow:limestone_bricks_from_limestone_stonecutting" | "botanypots:botanypots/crafting/orange_glazed_terracotta_hopper_botany_pot" | "pamhc2foodextended:pomegranatejellyitem" | "chipped_express:stonecutting_chipped_carved_nether_bricks_from_nether_bricks" | "create:cut_veridium_from_stone_types_veridium_stonecutting" | "compressedblocks:shaped_c2_nether_gold_ore" | "luphieclutteredmod:luphie_flowering_purple_pressure_plate_recipe" | "chipped_express:stonecutting_chipped_mixed_oak_log_from_oak_log" | "compressedblocks:shaped_c0_coal_ore" | "luphieclutteredmod:luphie_glow_wood_set_fence_gate_recipe" | "chipped_express:stonecutting_chipped_vertical_cut_smooth_stone_from_smooth_stone" | "chipped_express:stonecutting_chipped_seared_warped_wart_block_from_warped_wart_block" | "minecraft:weathered_cut_copper_slab_from_weathered_cut_copper_stonecutting" | "chipped_express:stonecutting_chipped_supported_jungle_door_from_jungle_door" | "mcwfurnitures:stripped_birch_modern_desk" | "create:cutting/compat/twilightforest/time_log" | "compressedblocks:shaped_c5_jungle_log" | "compressedblocks:shapeless_c2_mud" | "pamhc2foodcore:applejellyitem" | "compressedblocks:shaped_c3_chiseled_sandstone" | "mcwroofs:gutter_middle_white" | "create:crushing/emerald_ore" | "chipped_express:stonecutting_chipped_whirlwind_spruce_planks_from_spruce_planks" | "botania:mana_infusion/granite_to_andesite" | "compressedblocks:shaped_mega_crated_magenta_dye" | "chipped_express:stonecutting_chipped_smooth_bricks_column_from_bricks" | "chipped_express:stonecutting_chipped_vertical_cut_dripstone_block_from_dripstone_block" | "gemsnjewels:ornament_citrine" | "snowyspirit:gumdrop_light_blue" | "mcwroofs:oak_planks_top_roof" | "botania:floating_fallen_kanade" | "chipped_express:stonecutting_chipped_knitted_lime_wool_from_lime_wool" | "createdeco:tiled_verdant_brick_slab" | "createdeco:long_dean_brick_slab" | "createdeco:brass_support_wedge_from_stonecutting" | "chipped_express:stonecutting_chipped_small_basalt_bricks_from_basalt" | "farmersdelight:cooked_mutton_chops" | "chipped_express:stonecutting_chipped_railed_birch_planks_from_birch_planks" | "supplementaries:bloomingnature/sign_post_swamp_cypress" | "chipped_express:stonecutting_chipped_red_concrete_tiles_from_red_concrete" | "chipped_express:stonecutting_chipped_loded_purpur_block_from_purpur_block" | "chipped_express:stonecutting_chipped_sprouting_crimson_roots_bulb_from_crimson_roots" | "cosmeticarmoursmod:rose_gold_halo_rec" | "chipped_express:stonecutting_chipped_barky_black_carpet_from_black_carpet" | "botania:brew/feather_feet" | "minecraft:shulker_box_coloring" | "railways:stonecutting/palettes/cycling/magenta_locometal_pillar" | "create:cutting/compat/ecologics/stripped_coconut_log" | "moa_decor_toys:abeja_1" | "compressedblocks:shapeless_septuple_crated_glowstone_dust" | "compressedblocks:shaped_giga_crated_gray_dye" | "supplementaries:blackstone_tile" | "cosmeticarmoursmod:white_plaid_2_cyan" | "compressedblocks:shapeless_sextuple_crated_green_carpet" | "compressedblocks:shapeless_giga_crated_stick" | "refinedstorage:256k_fluid_storage_block" | "railways:sequenced_assembly/track_spruce_wide" | "moa_decor_garden_:pala_ctierra_1" | "corail_woodcutter:woodcutting/jungle_planks_from_jungle_logs" | "chipped_express:stonecutting_chipped_blue_terracotta_bricks_from_blue_terracotta" | "mcwroofs:blue_terracotta_lower_roof" | "botania:framed_dreamwood" | "chipped_express:stonecutting_chipped_spider_amethyst_block_carving_from_amethyst_block" | "refinedstorage:pattern_grid/magenta_pattern_grid" | "moa_decor_lights:farolpared_d_1" | "create:cut_asurine_from_stone_types_asurine_stonecutting" | "mcwfurnituresbop:dead_modern_chair" | "railways:sequenced_assembly/track_crimson" | "chipped_express:stonecutting_chipped_blank_tuff_carving_from_tuff" | "mcwbridges:warped_log_bridge_stair_recycle" | "cosmeticarmoursmod:santa_coat_rec" | "moa_decor_lights:lm_ggrisclaro_1" | "chipped_express:stonecutting_chipped_light_gray_terracotta_tile_from_light_gray_terracotta" | "botanypots:regions_unexplored/crop/corpse_flower" | "cosmeticarmoursmod:black_sock_plaid_2_skirt" | "chipped_express:stonecutting_chipped_inlayed_granite_from_granite" | "compressedblocks:shaped_c8_acacia_log" | "compressedblocks:shaped_sextuple_crated_snowball" | "refinedstorage:coloring_recipes/pink_network_transmitter" | "compressedblocks:shaped_mega_crated_cooked_rabbit" | "chipped_express:stonecutting_chipped_inlayed_packed_ice_from_packed_ice" | "botania:sunny_quartz" | "chipped_express:stonecutting_chipped_brick_bond_acacia_planks_from_acacia_planks" | "compressedblocks:shapeless_c1_gold_ore" | "create:cutting/compat/byg/stripped_rainbow_eucalyptus_log" | "compressedblocks:shapeless_sextuple_crated_baked_potato" | "chipped_express:stonecutting_chipped_vertical_stiped_yellow_stained_glass_pane_from_yellow_stained_glass_pane" | "moa_decor_bath:toallagrisclaracolg_1" | "create:cut_diorite_brick_wall" | "create:sequenced_assembly/precision_mechanism" | "chipped_express:stonecutting_chipped_crying_packed_ice_from_packed_ice" | "chipped_express:stonecutting_chipped_small_clay_bricks_from_clay" | "conditional:regions_unexplored/wood_cutter/maple_pp_woodcutter" | "pamhc2crops:arrowrootseeditem" | "compressedblocks:shaped_quadruple_crated_cooked_rabbit" | "compressedblocks:shaped_septuple_crated_glistering_melon_slice" | "mcwfurnitures:stripped_acacia_counter" | "candlelight:cherry_table" | "compressedblocks:shaped_quadruple_crated_ghast_tear" | "mcwdoors:bamboo_stable_door" | "corail_woodcutter:woodcutting/spruce_stairs_from_spruce_planks" | "farmersdelight:integration/immersiveengineering/cloche/tomato" | "create:compat/byg/milling/magenta_tulip" | "compressedblocks:shaped_c0_soul_soil" | "chipped_express:stonecutting_chipped_smooth_pink_concrete_from_pink_concrete" | "macawsroofsbop:magic_planks_top_roof" | "mcwroofs:lime_terracotta_lower_roof" | "neighborly:cut_stone_brick_slab" | "chipped_express:stonecutting_chipped_rectangle_magenta_carpet_from_magenta_carpet" | "create:cut_scorchia_wall" | "macawsroofsbop:magic_attic_roof" | "quark:building/stonecutting/stairs/shingles_stairs_stonecutter" | "immersive_aircraft:cargo_airship" | "create:polished_cut_deepslate_wall" | "brewery:pretzel" | "compressedblocks:shapeless_sextuple_crated_sugar" | "luphieclutteredmod:green_sand_seal_plush_recipe" | "mcwdoors:mangrove_four_panel_door" | "compressedblocks:shaped_c7_cherry_log" | "herbalbrews:yerba_mate_leaf_from_plant" | "cookingforblockheads:dye_black_oven" | "compressedblocks:shaped_c4_bamboo_mosaic" | "cosmeticarmoursmod:steampunkers_tophat_f_rec" | "pamhc2foodextended:poachedpearitem" | "beautify:acacia_trellis" | "botania:missile_rod" | "chipped_express:stonecutting_chipped_roped_ladder_from_ladder" | "pamhc2foodextended:cookedtofickenitem_campfire" | "compressedblocks:shapeless_triple_crated_baked_potato" | "chipped_express:stonecutting_chipped_soft_green_wool_from_green_wool" | "quark:building/crafting/shingles/lime_shingles_dye" | "quark:tweaks/crafting/utility/coral/brain_to_pink" | "cosmeticarmoursmod:pink_plaid_2_skirt" | "supplementaries:spiky_bomb" | "chipped_express:stonecutting_chipped_angry_mud_from_mud" | "minecraft:waxed_cut_copper_slab" | "create:haunting/lapis_recycling" | "compressedblocks:shapeless_triple_crated_cyan_carpet" | "chipped_express:stonecutting_chipped_mixed_jungle_log_from_jungle_log" | "chipped_express:stonecutting_chipped_massive_quartz_block_bricks_from_quartz_block" | "gemsnjewels:stacked_opal_stairs" | "moa_decor_toys:caballogris_c_1" | "chipped_express:stonecutting_chipped_hooded_brown_mushroom_from_brown_mushroom" | "chipped_express:stonecutting_chipped_rectangle_gray_wool_from_gray_wool" | "storagedrawers:jungle_trim" | "chipped_express:stonecutting_chipped_tiled_purple_carpet_from_purple_carpet" | "quark:building/stonecutting/stonevariants/polished_tuff_slab_stonecutter2" | "botanypots:botanypots/crafting/cyan_concrete_compact_hopper_botany_pot" | "railways:stonecutting/palettes/cycling/cyan_riveted_locometal" | "conditional:vinery/wood_cutter/cherry_sign_woodcutter" | "moa_decor_lights:candelabro_b_1" | "railways:sequenced_assembly/track_twilightforest_darkwood" | "chipped_express:stonecutting_chipped_basket_woven_crimson_planks_from_crimson_planks" | "moa_decor_science:camahmorada_1" | "delightful:knives/blasting/bone/knife_minecraft" | "compressedblocks:shapeless_c7_dark_oak_log" | "moa_decor_cookery:fjunglasc_1" | "compressedblocks:shaped_quadruple_crated_white_dye" | "compressedblocks:shapeless_quintuple_crated_tropical_fish" | "chipped_express:stonecutting_chipped_tiled_cyan_wool_from_cyan_wool" | "beautify:jungle_picture_frame" | "compressedblocks:shaped_double_crated_cooked_mutton" | "luphieclutteredmod:luphie_yellow_shroom_terrarium_recipe" | "mcwfurnitures:stripped_crimson_covered_desk" | "mcwroofs:white_roof_slab" | "moa_decor_bath:l_bhombres_1" | "mcwbridges:cherry_log_bridge_stair_recycle" | "moa_decor_garden_:acacia_1" | "comforts:sleeping_bag_to_blue" | "create:cutting/compat/ars_nouveau/stripped_red_archwood_log" | "chipped_express:stonecutting_chipped_boxed_acacia_planks_from_acacia_planks" | "compressedblocks:shaped_c3_exposed_copper" | "mcwdoors:crimson_bamboo_door" | "create:deploying/waxed_oxidized_copper_tile_slab_from_adding_wax" | "compressedblocks:shaped_c1_red_sandstone" | "gemsnjewels:stacked_pale_diamond_block" | "meadow:wood_cutter/mangrove/mangrove_stairs_woodcutter" | "compressedblocks:shapeless_mega_crated_scute" | "pamhc2foodextended:marzipanitem" | "chipped_express:stonecutting_chipped_tiny_deepslate_bricks_from_deepslate" | "compressedblocks:shapeless_c1_stripped_birch_log" | "compressedblocks:shaped_c3_warped_nylium" | "create:crafting/kinetics/black_valve_handle_from_other_valve_handle" | "compressedblocks:shaped_c6_waxed_oxidized_copper" | "chipped_express:stonecutting_chipped_soft_magenta_carpet_from_magenta_carpet" | "copycats:crafting/copycat_slice_from_conversion" | "railways:crafting/palettes/dyeing_8x/white_copper_wrapped_locometal" | "chipped_express:stonecutting_chipped_golden_birch_leaves_from_birch_leaves" | "corail_woodcutter:woodcutting/biomesoplenty/redwood_boat_from_redwood_logs" | "mcwfurnitures:stripped_dark_oak_double_drawer_counter" | "botania:manaweave_chestplate" | "compressedblocks:shapeless_octuple_crated_melon_seeds" | "chipped_express:stonecutting_chipped_orange_terracotta_tiles_from_orange_terracotta" | "quark:world/stonecutting/walls/calcite_wall_stonecutter" | "villagersplus:crimson_horticulturist_table" | "compressedblocks:shapeless_giga_crated_cobweb" | "alexsdelight:smelting/bunfungus_campfire" | "beachparty:dried_wheat_slab" | "cosmeticarmoursmod:rg_winged_angel_halo_rec" | "biomesoplenty:jacaranda_wood" | "pamhc2foodextended:pokebowlitem" | "candlelight:brown_dye_from_chocolate" | "quark:building/stonecutting/vertslabs/light_blue_shingles_vertical_slab_stonecutter" | "chipped_express:stonecutting_chipped_suspicious_warped_trapdoor_from_warped_trapdoor" | "chipped_express:stonecutting_chipped_cross_haired_blue_carpet_from_blue_carpet" | "compressedblocks:shaped_c2_oak_planks" | "conditional:regions_unexplored/wood_cutter/blackwood_sign_woodcutter" | "chipped_express:stonecutting_chipped_inscribed_dripstone_block_from_dripstone_block" | "refinedstorage:coloring_recipes/brown_security_manager" | "railways:crafting/small_buffer" | "compressedblocks:shapeless_quintuple_crated_apple" | "chipped_express:stonecutting_chipped_duh_borderless_bricks_from_bricks" | "mcwroofs:black_top_roof" | "chipped_express:stonecutting_chipped_flowery_vine_from_vine" | "botanypots:farmingforblockheads/soil/fertilized_farmland_healthy" | "wands:iron_wand" | "botania:metamorphic_mountain_bricks" | "compressedblocks:shapeless_giga_crated_light_blue_carpet" | "createdeco:green_placard" | "botania:floating_clayconia_chibi" | "corail_woodcutter:woodcutting/bamboo_stairs_from_bamboo_blocks" | "pamhc2foodextended:okracreoleitem" | "chipped_express:stonecutting_chipped_supported_iron_bars_from_iron_bars" | "minecraft:white_dye" | "chipped_express:stonecutting_chipped_airy_birch_trapdoor_from_birch_trapdoor" | "railways:sequenced_assembly/track_byg_aspen" | "refinedstorage:crafting_grid/yellow_crafting_grid" | "chipped_express:stonecutting_chipped_large_diamond_blue_stained_glass_from_blue_stained_glass" | "compressedblocks:shaped_quadruple_crated_clay_ball" | "aquaculture:note_hook" | "minecraft:wild_armor_trim_smithing_template_smithing_trim" | "sophisticatedstorage:controller" | "delightful:smelting/cactus_steak" | "create:polished_cut_veridium_stairs" | "macawsroofsbop:fir_planks_lower_roof" | "compressedblocks:shapeless_c7_coal_block" | "compressedblocks:shapeless_quadruple_crated_glass_bottle" | "chipped_express:stonecutting_chipped_flowering_cherry_log_from_cherry_log" | "compressedblocks:shaped_double_crated_azure_bluet" | "chipped_express:stonecutting_chipped_engraved_stone_from_stone" | "compressedblocks:shapeless_c0_stripped_cherry_log" | "mcwroofs:magenta_concrete_upper_steep_roof" | "brewery:bench" | "chipped_express:stonecutting_chipped_cut_blank_cobblestone_from_cobblestone" | "chipped_express:stonecutting_chipped_inscribed_basalt_from_basalt" | "quark:building/crafting/vertslabs/birch_vertical_slab" | "chipped_express:stonecutting_chipped_hexagonical_purple_terracotta_from_purple_terracotta" | "immersive_aircraft:enhanced_propeller" | "quark:building/crafting/azalea_hedge_oak" | "compressedblocks:shaped_c5_dirt" | "storagedrawers:max_redstone_upgrade" | "framedblocks:framing_saw/framed_compound_slope_panel" | "compressedblocks:shaped_double_crated_black_dye" | "bloomingnature:chestnut_hanging_sign" | "botania:corporea_interceptor" | "compressedblocks:shapeless_c1_honey_block" | "mcwfurnitures:stripped_crimson_bookshelf" | "cosmeticarmoursmod:pink_plaid_2_white" | "chipped_express:stonecutting_chipped_blue_dried_kelp_block_from_dried_kelp_block" | "compressedblocks:shaped_giga_crated_crimson_fungus" | "pamhc2foodextended:peanutbuttercookiesitem" | "chipped_express:stonecutting_chipped_smooth_warped_planks_from_warped_planks" | "create:cut_ochrum_from_stone_types_ochrum_stonecutting" | "compressedblocks:shaped_septuple_crated_oxeye_daisy" | "minecraft:cut_copper_stairs_from_copper_block_stonecutting" | "moa_decor_art:bateriaazul_1" | "refinedstorage:portable_grid" | "farmersdelight:potato_from_crate" | "create:granite_from_stone_types_granite_stonecutting" | "moa_decor_art:silladedirector_1" | "handcrafted:evoker_trophy" | "moa_decor_science:matrazbamarillo_1" | "compressedblocks:shapeless_septuple_crated_sugar_cane" | "moa_decor_cookery:tarrodecerveza_1" | "minecraft:dried_kelp_block" | "compressedblocks:shapeless_double_crated_leather" | "botania:mossy_dreamwood_planks_vine" | "compressedblocks:shaped_giga_crated_pufferfish" | "luphieclutteredmod:purple_flower_shelf_candle_recipe" | "railways:stonecutting/palettes/cycling/red_plated_locometal" | "create:cutting/compat/ars_nouveau/stripped_green_archwood_wood" | "bloomingnature:fir_fence" | "create:deploying/waxed_weathered_copper_shingle_slab_from_adding_wax" | "chipped_express:stonecutting_chipped_tied_bamboo_planks_from_bamboo_planks" | "supplementaries:compressedblocks/sign_post_c7_acacia" | "chipped_express:stonecutting_chipped_vertical_cut_granite_from_granite" | "create:polished_cut_dripstone_slab_from_stone_types_dripstone_stonecutting" | "bakery:brick_counter" | "pamhc2trees:roastedpinenutitem_campfire" | "compressedblocks:shaped_triple_crated_dark_oak_sapling" | "compressedblocks:shaped_c5_red_sandstone" | "chipped_express:stonecutting_chipped_small_magenta_terracotta_tiles_from_magenta_terracotta" | "moa_decor_toys:zoglin_1" | "pamhc2foodcore:melondonutitem" | "compressedblocks:shapeless_mega_crated_end_crystal" | "chipped_express:stonecutting_chipped_large_diamond_cyan_stained_glass_from_cyan_stained_glass" | "chipped_express:stonecutting_chipped_angry_clay_from_clay" | "conditional:bloomingnature/wood_cutter/swamp_oak_planks_woodcutter" | "chipped_express:stonecutting_chipped_oak_crate_from_barrel" | "chipped_express:stonecutting_chipped_circular_black_stained_glass_pane_from_black_stained_glass_pane" | "createdeco:blue_brass_lamp" | "luphieclutteredmod:pinkstrippedlogrecipe" | "chipped_express:stonecutting_chipped_k_sign_stripped_crimson_stem_from_stripped_crimson_stem" | "moa_decor_cookery:cafetera_1" | "compressedblocks:shapeless_c1_weathered_copper" | "chipped_express:stonecutting_chipped_kelp_sand_from_sand" | "minecraft:blue_carpet" | "createdeco:long_dusk_brick_slab_from_tiled_dusk_brick_slab_stonecutting" | "chipped_express:stonecutting_chipped_duh_blackstone_from_blackstone" | "compressedblocks:shaped_c0_bamboo_mosaic" | "railways:sequenced_assembly/blue_conductor_cap" | "compressedblocks:shaped_double_crated_blue_orchid" | "create:cut_dripstone_brick_slab" | "mcwroofs:green_terracotta_attic_roof" | "nethersdelight:cutting/hoglin_hide" | "biomesoplenty:redwood_planks" | "conditional:create/mixing/clark_wine_mixing" | "compressedblocks:shaped_quintuple_crated_amethyst_shard" | "create:small_limestone_brick_stairs_from_stone_types_limestone_stonecutting" | "chipped_express:stonecutting_chipped_circular_lime_stained_glass_from_lime_stained_glass" | "conditional:bloomingnature/wood_cutter/fir_planks_woodcutter" | "compressedblocks:shapeless_crated_cooked_rabbit" | "refinedstorage:fluid_grid/fluid_grid" | "chipped_express:stonecutting_chipped_checkered_amethyst_block_tiles_from_amethyst_block" | "railways:sequenced_assembly/track_byg_pine_wide" | "chipped_express:stonecutting_chipped_engraved_dirt_from_dirt" | "compressedblocks:shapeless_c1_stripped_dark_oak_log" | "mcwfurnituresbop:umbran_coffee_table" | "chipped_express:stonecutting_chipped_tiny_dripstone_block_bricks_from_dripstone_block" | "minecraft:cooked_chicken_from_smoking" | "compressedblocks:shaped_c0_gravel" | "chipped_express:stonecutting_chipped_smooth_inlayed_granite_from_granite" | "meadow:wood_cutter/spruce/spruce_planks_woodcutter" | "minecraft:waxed_weathered_cut_copper_slab_from_waxed_weathered_copper_stonecutting" | "chipped_express:stonecutting_chipped_enclosed_oak_planks_from_oak_planks" | "luphieclutteredmod:luphie_darkwood_cabinet_recipe_alt_1" | "luphieclutteredmod:luphie_darkwood_cabinet_recipe_alt_2" | "pamhc2foodextended:elderberryjellyitem" | "chipped_express:stonecutting_chipped_meshed_dark_oak_trapdoor_from_dark_oak_trapdoor" | "macawsroofsbop:mahogany_roof" | "minecraft:mangrove_chest_boat" | "minecraft:iron_hoe" | "moa_decor_holidays:leprechaun_1" | "chipped_express:stonecutting_chipped_deepslate_pillar_top_from_deepslate" | "chipped_express:stonecutting_chipped_oak_woven_glass_pane_from_glass_pane" | "framedblocks:framed_inner_threeway_corner" | "compressedblocks:shaped_c1_sandstone" | "compressedblocks:shapeless_quadruple_crated_soul_torch" | "chipped_express:stonecutting_chipped_cobblestone_pillar_from_cobblestone" | "brewery:dried_barley" | "framedblocks:framed_iron_pressure_plate" | "compressedblocks:shapeless_quintuple_crated_chicken" | "chipped_express:stonecutting_chipped_flat_purpur_block_tiles_from_purpur_block" | "refinedstorage:coloring_recipes/blue_network_transmitter" | "compressedblocks:shaped_octuple_crated_black_carpet" | "mcwfurnitures:dark_oak_coffee_table" | "candlelight:warped_shelf" | "aether:cutting/golden_oak_log" | "moa_decor_bath:mingitorio_1" | "beachparty:palm_beam" | "compressedblocks:shaped_quadruple_crated_snowball" | "railways:crafting/palettes/dyeing_1x/brown_locometal_boiler" | "compressedblocks:shaped_c1_chiseled_sandstone" | "chipped_express:stonecutting_chipped_crimson_planks_mosaic_from_crimson_planks" | "conditional:regions_unexplored/wood_cutter/baobab_fence_woodcutter" | "moa_decor_cookery:barril_4" | "sophisticatedbackpacks:filter_upgrade" | "moa_decor_cookery:barril_3" | "cosmeticarmoursmod:pink_archer_attire_chestplate_rec" | "chipped_express:stonecutting_chipped_scaled_orange_wool_from_orange_wool" | "chipped_express:stonecutting_chipped_cornered_light_blue_carpet_from_light_blue_carpet" | "moa_decor_cookery:barril_2" | "botania:smelt_rod" | "moa_decor_cookery:barril_1" | "compressedblocks:shaped_c6_waxed_exposed_copper" | "chipped_express:stonecutting_chipped_netherrack_scales_from_netherrack" | "compressedblocks:shaped_c1_waxed_copper_block" | "chipped_express:stonecutting_chipped_polished_ice_from_ice" | "chipped_express:stonecutting_chipped_tiled_spruce_planks_from_spruce_planks" | "create:deploying/waxed_exposed_copper_tile_slab_from_adding_wax" | "handcrafted:acacia_desk" | "mcwdoors:birch_glass_door" | "compressedblocks:shaped_c7_exposed_cut_copper" | "railways:crafting/palettes/dyeing_1x/green_brass_wrapped_locometal" | "framedblocks:framing_saw/framed_one_way_window" | "gemsnjewels:ametrine_set_gold_crown" | "compressedblocks:shapeless_c4_chiseled_red_sandstone" | "beautify:candelabra_yellow" | "chipped_express:stonecutting_chipped_duh_mossy_stone_bricks_from_mossy_stone_bricks" | "compressedblocks:shapeless_crated_paper" | "compressedblocks:shaped_double_crated_name_tag" | "pamhc2trees:grapefruit_sapling" | "compressedblocks:shapeless_c0_deepslate" | "compressedblocks:shaped_giga_crated_milk_bucket" | "chipped_express:stonecutting_chipped_tiny_blackstone_bricks_from_blackstone" | "compressedblocks:shaped_crated_carrot" | "handcrafted:light_blue_sheet" | "compressedblocks:shaped_septuple_crated_mutton" | "create:campfire_cooking/bread" | "compressedblocks:shaped_quintuple_crated_crimson_fungus" | "framedblocks:framing_saw/framed_lattice_block" | "botania:mana_detector" | "mcwroofs:mangrove_planks_lower_roof" | "supplementaries:soap/dirty_glass_pane" | "deep_aether:cutting/conberry_log" | "chipped_express:stonecutting_chipped_stacked_gold_block_from_gold_block" | "cosmeticarmoursmod:green_sock_skirt_2_white" | "mcwroofs:orange_terracotta_top_roof" | "chipped_express:stonecutting_chipped_barky_orange_wool_from_orange_wool" | "quark:building/crafting/stairs/green_shingles_stairs" | "compressedblocks:shaped_c0_mangrove_log" | "botania:stonecutting/corporea_block_to_corporea_brick" | "quark:building/stonecutting/slabs/light_blue_shingles_slab_stonecutter2" | "railways:crafting/palettes/dyeing_1x/brown_flat_riveted_locometal" | "botanypots:minecraft/crop/poppy" | "corail_woodcutter:woodcutting/bamboo_mosaic_slab_from_bamboo_mosaic" | "pamhc2crops:bellpepperseeditem" | "botania:stonecutting/elf_quartz_to_elf_quartz_stairs" | "chipped_express:stonecutting_chipped_warped_fungus_bushel_from_warped_fungus" | "chipped_express:stonecutting_chipped_grill_red_concrete_from_red_concrete" | "pamhc2foodcore:potatosoupitem" | "corail_woodcutter:woodcutting/spruce_fence_gate_from_spruce_logs" | "chipped_express:stonecutting_chipped_crying_bricks_from_bricks" | "quark:building/crafting/crimson_bookshelf" | "create:cut_diorite_slab_recycling" | "biomesoplenty:light_blue_dye_from_blue_hydrangea" | "railways:sequenced_assembly/track_natures_spirit_palo_verde" | "framedblocks:framed_divided_stairs" | "compressedblocks:shapeless_c4_weathered_cut_copper" | "corail_woodcutter:woodcutting/bamboo_sign_from_bamboo_planks" | "botania:chiseled_metamorphic_forest_bricks" | "refinedstorage:coloring_recipes/black_detector" | "botanypots:botanypots/crafting/brown_terracotta_botany_pot" | "utilitix:mob_bell" | "create:cutting/compat/blue_skies/stripped_frostbright_log" | "moa_decor_art:tambormagenta_1" | "compressedblocks:shaped_c7_smooth_sandstone" | "railways:crafting/palettes/dyeing_8x/purple_flat_riveted_locometal" | "mcwfences:birch_highley_gate" | "create:cutting/compat/ecologics/flowering_azalea_wood" | "compressedblocks:shaped_sextuple_crated_pointed_dripstone" | "createdeco:placard" | "create:blasting/iron_ingot_from_crushed" | "quark:building/crafting/chests/bamboo_trapped_chest" | "supplementaries:compressedblocks/sign_post_c4_dark_oak" | "pamhc2foodextended:kiwijellysandwichitem" | "chipped_express:stonecutting_chipped_screen_bamboo_door_from_bamboo_door" | "botanypots:botanypots/crafting/yellow_terracotta_botany_pot" | "chipped_express:stonecutting_chipped_railed_light_gray_concrete_from_light_gray_concrete" | "chipped_express:stonecutting_chipped_trodden_diorite_from_diorite" | "createdeco:tiled_dusk_brick_slab_from_dusk_bricks_stonecutting" | "quark:building/stonecutting/stonevariants/diorite_bricks_stairs_polished_stonecutting" | "compressedblocks:shaped_c8_end_stone_bricks" | "mcwbridges:diorite_bridge_stair" | "quark:building/crafting/oak_bookshelf" | "compressedblocks:shapeless_sextuple_crated_ender_eye" | "bloomingnature:larch_window" | "alexsdelight:smelting/bison_patty_smoke" | "chipped_express:stonecutting_chipped_cobweb_cherry_trapdoor_from_cherry_trapdoor" | "chipped_express:stonecutting_chipped_decorated_light_gray_terracotta_from_light_gray_terracotta" | "chipped_express:stonecutting_chipped_heavy_spruce_door_from_spruce_door" | "chipped_express:stonecutting_chipped_pressed_waxed_exposed_copper_from_waxed_exposed_copper" | "meadow:wood_cutter/birch/birch_stairs_woodcutter" | "compressedblocks:shapeless_c6_lapis_block" | "chipped_express:stonecutting_chipped_white_flower_oak_leaves_from_oak_leaves" | "bakery:baking_station/strawberry_cupcake" | "cosmeticarmoursmod:white_sock_skirt_2_purple" | "meadow:wood_cutter/acacia/acacia_stairs_woodcutter" | "sophisticatedstorage:oak_chest_from_vanilla_chest" | "minecraft:light_blue_candle" | "chipped_express:stonecutting_chipped_rusted_orange_concrete_from_orange_concrete" | "framedblocks:framing_saw/framed_double_sloped_prism" | "luphieclutteredmod:luphie_mushroom_lamp_recipe" | "beachparty:tiki_bar_mixing/sweetberry_milkshake" | "biomesoplenty:chiseled_brimstone_bricks" | "createdeco:short_blue_brick_slab_from_tiled_blue_brick_slab_stonecutting" | "compressedblocks:shapeless_mega_crated_ghast_tear" | "compressedblocks:shapeless_c6_stripped_jungle_log" | "snowyspirit:snow_globe" | "mcwroofs:mangrove_upper_steep_roof" | "create:polished_cut_scoria_slab_from_stone_types_scoria_stonecutting" | "farmersdelight:light_blue_hanging_canvas_sign" | "chipped_express:stonecutting_chipped_smooth_inlayed_deepslate_from_deepslate" | "mcwbridges:jungle_rope_bridge_stair" | "chipped_express:stonecutting_chipped_knitted_lime_carpet_from_lime_carpet" | "chipped_express:stonecutting_chipped_magenta_glazed_terracotta_tiles_from_magenta_glazed_terracotta" | "conditional:create/mixing/apple_juice_mixing" | "compressedblocks:shaped_c6_jungle_planks" | "chipped_express:stonecutting_chipped_sanded_stone_from_stone" | "pamhc2foodcore:gummycreepersitem" | "botania:mana_infusion/coal_dupe" | "botania:mana_infusion/flint_to_gunpowder" | "mcwfences:modern_sandstone_wall" | "chipped_express:stonecutting_chipped_wise_stripped_birch_log_from_stripped_birch_log" | "quark:building/crafting/shingles/light_blue_shingles" | "botania:corporea_index" | "moa_decor_lights:lm_dblanco_1" | "mcwfurnitures:spruce_wardrobe" | "compressedblocks:shapeless_septuple_crated_end_crystal" | "luphieclutteredmod:red_birdhouse_recipe" | "mcwroofs:bamboo_planks_lower_roof" | "railways:crafting/palettes/dyeing_8x/yellow_brass_wrapped_locometal_boiler" | "chipped_express:stonecutting_chipped_cherry_planks_mosaic_from_cherry_planks" | "chipped_express:stonecutting_chipped_cracked_flat_packed_ice_tiles_from_packed_ice" | "compressedblocks:shaped_quadruple_crated_soul_torch" | "compressedblocks:shapeless_giga_crated_beef" | "mcwroofs:purple_concrete_steep_roof" | "moa_decor_garden_:hongodistorsionado_3" | "moa_decor_garden_:hongodistorsionado_1" | "quark:building/crafting/vertslabs/polished_granite_vertical_slab_revert" | "quark:building/crafting/slabs/smooth_soul_sandstone_slab" | "bloomingnature:aspen_slab" | "create:crafting/kinetics/mysterious_cuckoo_clock" | "chipped_express:stonecutting_chipped_red_moss_block_from_moss_block" | "macawsroofsbop:magic_upper_steep_roof" | "mcwtrpdoors:cherry_tropical_trapdoor" | "minecraft:firework_star_fade" | "delightful:knives/ironwood_knife" | "luphieclutteredmod:luphie_darkwood_geometric_sofa_recipe" | "mcwwindows:stripped_dark_oak_log_window2" | "gemsnjewels:forge_aquamarine_set_gold_ring" | "farmersdelight:cooked_salmon_slice_from_campfire_cooking" | "refinedstorage:coloring_recipes/brown_crafter_manager" | "mcwwindows:crimson_shutter" | "mcwroofs:jungle_top_roof" | "chipped_express:stonecutting_chipped_circular_orange_stained_glass_pane_from_orange_stained_glass_pane" | "moa_decor_toys:camello_1" | "compressedblocks:shaped_triple_crated_orange_dye" | "chipped_express:stonecutting_chipped_barred_spruce_trapdoor_from_spruce_trapdoor" | "create:small_granite_brick_wall_from_stone_types_granite_stonecutting" | "mcwfurnitures:stripped_dark_oak_desk" | "nethervinery:crimson_wine_rack_small" | "chipped_express:stonecutting_chipped_tiled_mangrove_planks_from_mangrove_planks" | "mcwfences:modern_prismarine_wall_stonecutter" | "create:small_granite_brick_slab" | "pamhc2foodextended:orangeyogurtitem" | "chipped_express:stonecutting_chipped_cut_blank_gilded_blackstone_from_gilded_blackstone" | "chipped_express:stonecutting_chipped_stop_light_blue_concrete_from_light_blue_concrete" | "compressedblocks:shaped_octuple_crated_green_carpet" | "minecraft:blue_candle" | "chipped_express:stonecutting_chipped_pillar_deepslate_bricks_from_deepslate" | "chipped_express:stonecutting_chipped_yellow_terracotta_bricks_from_yellow_terracotta" | "compressedblocks:shaped_septuple_crated_spectral_arrow" | "fairylights:triangle_pennant" | "pamhc2foodextended:strawberryrhubarbpieitem" | "botania:red_string_relay" | "chipped_express:stonecutting_chipped_squished_cute_carved_pumpkin_from_carved_pumpkin" | "create_confectionery:ruby_chocolate_brick_stairs_recipe_2" | "pamhc2foodcore:basiccheeseburgeritem" | "minecraft:flower_banner_pattern" | "handcrafted:dripstone_pillar_trim" | "botanypots:botanypots/crafting/pink_terracotta_compact_hopper_botany_pot" | "mcwroofs:purple_terracotta_upper_lower_roof" | "pamhc2foodextended:cornchipsitem" | "conditional:create/mixing/kelp_cider_mixing" | "luphieclutteredmod:luphie_button_stool_recipe" | "biomesoplenty:orange_dye_from_burning_blossom" | "mcwbridges:dark_oak_log_bridge_stair_recycle" | "railways:crafting/palettes/dyeing_8x/white_slashed_locometal" | "beautify:dark_oak_blinds" | "chipped_express:stonecutting_chipped_arched_red_stained_glass_pillar_from_red_stained_glass" | "minecraft:polished_blackstone_brick_slab_from_polished_blackstone_bricks_stonecutting" | "chipped_express:stonecutting_chipped_cross_haired_pink_carpet_from_pink_carpet" | "candlelight:table" | "chipped_express:stonecutting_chipped_windmill_gray_carpet_from_gray_carpet" | "candlelight:lettuce_crate" | "compressedblocks:shapeless_c9_oak_log" | "chipped_express:stonecutting_chipped_framed_acacia_planks_from_acacia_planks" | "compressedblocks:shaped_crated_pufferfish" | "luphieclutteredmod:black_right_outer_corner_counter_recipe_alt" | "botania:mana_infusion/spruce_sapling_to_birch_sapling" | "create:small_diorite_brick_slab" | "chipped_express:stonecutting_chipped_mossy_stone_bricks_pillar_from_mossy_stone_bricks" | "luphieclutteredmod:luphie_sewing_clutter_recipe" | "chipped_express:stonecutting_chipped_fortified_crimson_door_from_crimson_door" | "createdeco:long_umber_brick_slab_from_tiled_umber_brick_slab_stonecutting" | "chipped_express:stonecutting_chipped_k_sign_stripped_acacia_log_from_stripped_acacia_log" | "mcwfurnituresbop:mahogany_wardrobe" | "mcwroofs:oak_planks_steep_roof" | "botania:pure_daisy/cobblestone" | "railways:sequenced_assembly/track_byg_imparius_narrow" | "macawsroofsbop:fir_steep_roof" | "chipped_express:stonecutting_chipped_spider_raw_gold_block_carving_from_raw_gold_block" | "create:cut_ochrum_brick_stairs_from_stone_types_ochrum_stonecutting" | "create:smelting/zinc_ingot_from_raw_ore" | "compressedblocks:shaped_mega_crated_cocoa_beans" | "minecraft:purple_banner" | "moa_decor_bath:batanegra_1" | "farmersdelight:straw_bale" | "compressedblocks:shapeless_octuple_crated_ink_sac" | "create:deepslate_from_stone_types_deepslate_stonecutting" | "pamhc2foodextended:pumpkinspicelatteitem" | "createdeco:blue_brick_stairs_from_long_blue_bricks_stonecutting" | "quark:world/crafting/woodsets/ancient/bookshelf" | "mcwroofs:lime_concrete_steep_roof" | "botania:mana_spreader" | "mcwfurnituresbop:willow_double_wardrobe" | "refinedstorage:coloring_recipes/light_gray_network_transmitter" | "create:cutting/compat/byg/ebony_wood" | "compressedblocks:shapeless_c6_stripped_acacia_log" | "chipped_express:stonecutting_chipped_ornate_light_gray_stained_glass_pane_from_light_gray_stained_glass_pane" | "chipped_express:stonecutting_chipped_ancient_oak_large_bookshelf_from_bookshelf" | "corail_woodcutter:woodcutting/biomesoplenty/mahogany_fence_gate_from_mahogany_logs" | "chipped_express:stonecutting_chipped_curly_raw_copper_block_pillar_from_raw_copper_block" | "chipped_express:stonecutting_chipped_small_green_stained_glass_from_green_stained_glass" | "moa_decor_lights:vt_dcarmesi_1" | "railways:mechanical_crafting/yellow_iron_wrapped_locometal_boiler" | "quark:tweaks/crafting/utility/chests/dark_oak_chest_wood" | "compressedblocks:shaped_mega_crated_glass_bottle" | "chipped_express:stonecutting_chipped_starry_green_glazed_terracotta_from_green_glazed_terracotta" | "chipped_express:stonecutting_chipped_rough_deepslate_from_deepslate" | "pamhc2foodextended:cactusfruitsmoothieitem" | "sophisticatedstorage:spruce_barrel_from_vanilla_barrel" | "botania:mana_infusion/piston_relay" | "aquaculture:fish_fillet" | "quark:building/stonecutting/vertslabs/lime_shingles_vertical_slab_stonecutter" | "aquaculture:worm_farm" | "aquaculturedelight:cutting/knife/turtle" | "compressedblocks:shaped_octuple_crated_fermented_spider_eye" | "compressedblocks:shapeless_c7_netherite_block" | "chipped_express:stonecutting_chipped_paved_purple_glazed_terracotta_from_purple_glazed_terracotta" | "mcwtrpdoors:spruce_glass_trapdoor" | "compressedblocks:shaped_quintuple_crated_firework_star" | "botania:stonecutting/corporea_block_to_corporea_stairs" | "compressedblocks:shaped_sextuple_crated_seagrass" | "bloomingnature:larch_fence_gate" | "createdeco:tiled_umber_brick_stairs_from_umber_bricks_stonecutting" | "create:compat/ae2/milling/sky_stone_block" | "snowyspirit:gumdrop_orange" | "refinedcooking:kitchen_access_point" | "compressedblocks:shaped_c4_oak_planks" | "chipped_express:stonecutting_chipped_tiny_brick_bordered_diorite_from_diorite" | "create:compat/environmental/milling/pink_delphinium" | "chipped_express:stonecutting_chipped_reinforced_gray_concrete_from_gray_concrete" | "chipped_express:stonecutting_chipped_warning_yellow_concrete_from_yellow_concrete" | "moa_decor_toys:zombie_1" | "chipped_express:stonecutting_chipped_sheet_diamond_block_from_diamond_block" | "minecraft:white_banner" | "chipped_express:stonecutting_chipped_vertical_disordered_lapis_block_bricks_from_lapis_block" | "compressedblocks:shapeless_c4_spruce_planks" | "compressedblocks:shaped_c5_bricks" | "botania:mana_bomb" | "quark:building/crafting/chests/prismarine_trapped_chest" | "luphieclutteredmod:small_shelf_recipe" | "quark:building/stonecutting/vertslabs/diorite_bricks_vertical_slab_stonecutter" | "pamhc2foodcore:glazedcarrotsitem" | "createdeco:long_red_brick_stairs_from_bricks_stonecutting" | "chipped_express:stonecutting_chipped_harsh_quilted_red_carpet_from_red_carpet" | "railways:sequenced_assembly/track_tfc_chestnut" | "biomesoplenty:smooth_white_sandstone_slab" | "chipped_express:stonecutting_chipped_carved_packed_mud_pillar_from_packed_mud" | "mcwdoors:acacia_cottage_door" | "create:cutting/compat/blue_skies/maple_wood" | "chipped_express:stonecutting_chipped_crumbled_warped_wart_block_from_warped_wart_block" | "create:sequenced_assembly/sturdy_sheet" | "mcwlights:cross_wall_lantern" | "mcwlights:light_gray_ceiling_light" | "chipped_express:stonecutting_chipped_creeper_white_concrete_from_white_concrete" | "moa_decor_bath:babeto_1" | "compressedblocks:shapeless_c5_waxed_exposed_copper" | "chipped_express:stonecutting_chipped_cut_orange_terracotta_from_orange_terracotta" | "corail_woodcutter:woodcutting/acacia_pressure_plate_from_acacia_logs" | "mcwfences:birch_stockade_fence" | "createdeco:long_verdant_bricks_from_short_verdant_bricks_stonecutting" | "minecraft:diorite_stairs_from_diorite_stonecutting" | "meadow:wood_cutter/cherry/cherry_button_woodcutter" | "mcwroofs:andesite_attic_roof" | "handcrafted:cherry_fancy_bed" | "chipped_express:stonecutting_chipped_fancy_light_blue_stained_glass_from_light_blue_stained_glass" | "luphieclutteredmod:luphie_yellow_slab_recipe" | "compressedblocks:shaped_c3_sand" | "macawsroofsbop:redwood_planks_attic_roof" | "compressedblocks:shaped_mega_crated_apple" | "create_confectionery:candy_cane_recipe_2" | "mcwtrpdoors:spruce_mystic_trapdoor" | "minecraft:green_glazed_terracotta" | "compressedblocks:shaped_c7_birch_log" | "compressedblocks:shaped_mega_crated_ender_eye" | "luphieclutteredmod:luphie_pastel_strawberry_wallpaper_recipe" | "compressedblocks:shaped_c8_diamond_block" | "compressedblocks:shapeless_mega_crated_blue_dye" | "chipped_express:stonecutting_chipped_ice_scales_from_ice" | "chipped_express:stonecutting_chipped_thick_inlayed_packed_mud_from_packed_mud" | "minecraft:blue_cushion_from_blue_dye" | "chipped_express:stonecutting_chipped_square_purple_stained_glass_pane_from_purple_stained_glass_pane" | "chipped_express:stonecutting_chipped_tuff_pointed_dripstone_from_pointed_dripstone" | "chipped_express:stonecutting_chipped_crying_purpur_block_from_purpur_block" | "mcwroofs:lime_striped_awning" | "meadow:wood_cutter/oak/oak_sign_woodcutter" | "botania:metamorphic_forest_bricks" | "compressedblocks:shaped_quadruple_crated_wheat_seeds" | "quark:building/stonecutting/stonevariants/calcite_bricks_stonecutter" | "mcwlights:red_paper_lamp" | "botanypots:botanypots/crafting/gray_glazed_terracotta_compact_hopper_botany_pot" | "ecologics:tropical_stew" | "chipped_express:stonecutting_chipped_fine_dark_prismarine_pillar_from_dark_prismarine" | "mcwlights:covered_wall_lantern" | "railways:sequenced_assembly/track_biomesoplenty_palm_wide" | "farmersdelight:stove" | "mcwwindows:birch_plank_four_window" | "chipped_express:stonecutting_chipped_hewn_jungle_planks_from_jungle_planks" | "chipped_express:stonecutting_chipped_etched_ice_bricks_from_ice" | "chipped_express:stonecutting_chipped_weathered_dirt_from_dirt" | "compressedblocks:shapeless_mega_crated_kelp" | "chipped_express:stonecutting_chipped_unamused_magma_block_from_magma_block" | "pamhc2foodextended:vegemiteontoastitem" | "pamhc2foodextended:yorkshirepuddingitem" | "chipped_express:stonecutting_chipped_stone_pillar_top_from_stone" | "minecraft:light_blue_carpet" | "railways:sequenced_assembly/track_natures_spirit_sugi_narrow" | "pamhc2foodcore:sweetberrymuffinitem" | "railways:mechanical_crafting/lime_iron_wrapped_locometal_boiler" | "mcwdoors:birch_mystic_door" | "chipped_express:stonecutting_chipped_triangular_pink_terracotta_from_pink_terracotta" | "mcwfurnitures:stripped_crimson_chair" | "mcwfurnitures:birch_double_drawer" | "chipped_express:stonecutting_chipped_tiny_brick_bordered_cobblestone_from_cobblestone" | "compressedblocks:shapeless_c7_smooth_sandstone" | "botania:cosmetic_red_ribbons" | "quark:building/crafting/cobblestone_bricks" | "refinedstorage:coloring_recipes/white_crafter_manager" | "create:layered_andesite_from_stone_types_andesite_stonecutting" | "createdeco:short_umber_brick_stairs_from_short_umber_bricks_stonecutting" | "create:polished_cut_ochrum_slab_from_stone_types_ochrum_stonecutting" | "createdeco:short_blue_brick_stairs_from_tiled_blue_brick_stairs_stonecutting" | "chipped_express:stonecutting_chipped_layed_raw_iron_block_bricks_from_raw_iron_block" | "botania:scorched_seeds" | "compressedblocks:shaped_septuple_crated_peony" | "luphieclutteredmod:scrambled_pastel_rubiks_cube_recipe" | "railways:stonecutting/palettes/cycling/red_slashed_locometal" | "createdeco:light_gray_shipping_container" | "compressedblocks:shapeless_c7_slime_block" | "railways:crafting/palettes/dyeing_8x/pink_plated_locometal" | "chipped_express:stonecutting_chipped_nether_sprouts_weeds_from_nether_sprouts" | "botanypots:biomesoplenty/crop/wilted_lily" | "pamhc2trees:plum_sapling" | "compressedblocks:shapeless_sextuple_crated_lime_dye" | "railways:crafting/palettes/dyeing_1x/pink_flat_slashed_locometal" | "compressedblocks:shaped_c9_nether_gold_ore" | "corail_woodcutter:woodcutting/birch_pressure_plate_from_birch_logs" | "compressedblocks:shaped_c8_sculk" | "pamhc2foodcore:glowberryjellyitem" | "chipped_express:stonecutting_chipped_prismal_borderless_bricks_remnants_from_bricks" | "quark:building/crafting/vertslabs/limestone_bricks_vertical_slab_revert" | "create:cutting/compat/byg/holly_log" | "mcwroofs:red_terracotta_attic_roof" | "twilightdelight:cutting/raw_venison_rib" | "chipped_express:stonecutting_chipped_vertically_railed_jungle_planks_from_jungle_planks" | "minecraft:warped_button" | "pamhc2foodextended:elderberryyogurtitem" | "pamhc2crops:wolfberryseeditem" | "pamhc2foodextended:kiwijuiceitem" | "create:cut_crimsite_stairs" | "fairylights:meteor_light" | "createdeco:tiled_pearl_brick_stairs_from_pearl_bricks_stonecutting" | "chipped_express:stonecutting_chipped_green_concrete_tiles_from_green_concrete" | "createdeco:tiled_red_brick_slab_from_long_red_brick_slab_stonecutting" | "mcwroofs:white_terracotta_roof" | "create:crafting/kinetics/sequenced_gearshift" | "chipped_express:stonecutting_chipped_bordered_red_sandstone_from_red_sandstone" | "chipped_express:stonecutting_chipped_rough_red_sandstone_from_red_sandstone" | "minecraft:armor_dye" | "luphieclutteredmod:luphie_empty_picnic_basket_recipe" | "framedblocks:framing_saw/framed_large_double_corner_slope_panel" | "create:compat/bop/milling/burning_blossom" | "moa_decor_holidays:pino_navideno_1" | "botanypots:farming_crossing/crop/vinerywhite_grape_seeds" | "farmersdelight:cutting/mangrove_hanging_sign" | "chipped_express:stonecutting_chipped_smoothed_double_inlayed_calcite_from_calcite" | "create_confectionery:candy_cane_recipe" | "compressedblocks:shapeless_quadruple_crated_lime_carpet" | "mcwfurnitures:birch_large_drawer" | "create:cut_scorchia_stairs" | "minecraft:smoking_cookedgroundfishitem" | "minecraft:detector_rail" | "refinedstorage:4096k_fluid_storage_part" | "chipped_express:stonecutting_chipped_pillar_raw_copper_block_bricks_from_raw_copper_block" | "luphieclutteredmod:luphie_lime_armchair_recipe" | "mcwroofs:light_gray_top_roof" | "compressedblocks:shapeless_c0_chiseled_sandstone" | "biomesoplenty:jacaranda_hanging_sign" | "botanypots:minecraft/crop/white_tulip" | "chipped_express:stonecutting_chipped_ancient_waxed_exposed_copper_from_waxed_exposed_copper" | "createdeco:copper_catwalk_railing_forge" | "mcwfurnitures:jungle_double_drawer" | "compressedblocks:shapeless_quadruple_crated_glow_item_frame" | "mcwfurnitures:crimson_bookshelf" | "chipped_express:stonecutting_chipped_barky_gray_carpet_from_gray_carpet" | "moa_decor_cookery:cacaciasc_1" | "create:splashing/mekanism/crushed_raw_uranium" | "moa_decor_toys:cubodemagma_1" | "meadow:pine_sign" | "refinedstorage:coloring_recipes/red_controller" | "pamhc2foodcore:fishsticksitem" | "chipped_express:stonecutting_chipped_overgrown_birch_log_from_birch_log" | "botanypots:regions_unexplored/crop/hibiscus" | "botania:floating_rannuncarpus" | "compressedblocks:shapeless_crated_flint" | "botania:stonecutting/metamorphic_forest_stone_to_chiseled_metamorphic_forest_bricks" | "create:crafting/logistics/stockpile_switch" | "botanypots:farming_crossing/crop/herbalbrewsrooibos_leaf" | "quark:automation/crafting/feeding_trough" | "chipped_express:stonecutting_chipped_spruce_planks_mosaic_from_spruce_planks" | "chipped_express:stonecutting_chipped_reinforced_iron_block_from_iron_block" | "chipped_express:stonecutting_chipped_reinforced_jungle_log_from_jungle_log" | "createdeco:dusk_brick_slab_from_tiled_dusk_brick_slab_stonecutting" | "handcrafted:crimson_side_table" | "createdeco:tiled_dean_brick_slab_from_short_dean_brick_slab_stonecutting" | "pamhc2foodextended:tortillaitem" | "compressedblocks:shaped_c8_soul_sand" | "chipped_express:stonecutting_chipped_chipped_stripped_crimson_stem_from_stripped_crimson_stem" | "create:compat/environmental/milling/yellow_hibiscus" | "gemsnjewels:create/create_crushing_tourmaline_nether_ore" | "utilitix:comparator_redirector_up" | "botanypots:botanypots/crafting/lime_concrete_botany_pot" | "compressedblocks:shapeless_octuple_crated_turtle_egg" | "compressedblocks:shapeless_crated_snowball" | "botanypots:minecraft/soil/tropical_fish_bucket" | "chipped_express:stonecutting_chipped_curly_cobblestone_pillar_from_cobblestone" | "railways:crafting/palettes/dyeing_8x/orange_locometal_boiler" | "compressedblocks:shapeless_triple_crated_magenta_carpet" | "moa_decor_toys:caballoblanco_h_1" | "compressedblocks:shapeless_quadruple_crated_light_blue_carpet" | "compressedblocks:shaped_c8_coal_block" | "farmersdelight:magenta_hanging_canvas_sign" | "compressedblocks:shapeless_c1_nether_quartz_ore" | "quark:building/crafting/stone_lamp" | "chipped_express:stonecutting_chipped_weathered_end_stone_from_end_stone" | "compressedblocks:shapeless_octuple_crated_weeping_vines" | "create:polished_cut_limestone_slab_from_stone_types_limestone_stonecutting" | "compressedblocks:shaped_c7_acacia_planks" | "chipped_express:stonecutting_chipped_barred_crimson_trapdoor_from_crimson_trapdoor" | "minecraft:black_glazed_terracotta" | "chipped_express:stonecutting_chipped_crimson_mangrove_roots_from_mangrove_roots" | "quark:tools/smithing/rune_smithing_pink" | "botania:sextant" | "libraryferret:crafting_shaped/fake_diamond_block" | "luphieclutteredmod:scrambled_rubiks_cube_recipe" | "compressedblocks:shaped_c7_netherrack" | "minecraft:carrot_on_a_stick" | "exoticbirds:phoenix_egg_from_desert_phoenix" | "create:cutting/compat/byg/pine_wood" | "botanypots:regions_unexplored/crop/steppe_grass" | "conditional:regions_unexplored/wood_cutter/redwood_planks_woodcutter" | "compressedblocks:shapeless_crated_cocoa_beans" | "quark:building/crafting/glass/magenta_framed_glass" | "paraglider:horned_statue/buy_heart_container" | "macawsroofsbop:magic_top_roof" | "chipped_express:stonecutting_chipped_woved_light_gray_wool_from_light_gray_wool" | "chipped_express:stonecutting_chipped_micro_brown_mushroom_from_brown_mushroom" | "mcwroofs:blue_concrete_upper_steep_roof" | "quark:building/stonecutting/stonevariants/calcite_bricks_slab_polished_stonecutting" | "compressedblocks:shapeless_septuple_crated_pumpkin_seeds" | "chipped_express:stonecutting_chipped_chipped_waxed_oxidized_copper_from_waxed_oxidized_copper" | "refinedstorage:pattern_grid/orange_pattern_grid" | "pamhc2crops:cattailseeditem" | "moa_decor_holidays:calabaza_slime_l_1" | "quark:building/crafting/vertslabs/polished_dripstone_vertical_slab_revert" | "pamhc2foodextended:lambkebabitem" | "compressedblocks:shaped_c1_weathered_copper" | "quark:building/crafting/vertplanks/vertical_mangrove_planks_revert" | "chipped_express:stonecutting_chipped_cubed_green_carpet_from_green_carpet" | "luphieclutteredmod:pink_planks_alt_recipe" | "moa_decor_holidays:murcielagoabierto_2" | "aether:skyroot_milk_bucket_moa_egg_cake" | "moa_decor_art:guitarraelectricacian_1" | "meadow:shelf" | "mcwwindows:stone_window2" | "chipped_express:stonecutting_chipped_detailed_oak_planks_from_oak_planks" | "moa_decor_holidays:murcielagoabierto_1" | "chipped_express:stonecutting_chipped_suspicious_birch_trapdoor_from_birch_trapdoor" | "chipped_express:stonecutting_chipped_cobbled_mossy_cobblestone_from_mossy_cobblestone" | "compressedblocks:shapeless_quintuple_crated_porkchop" | "bloomingnature:ebony_wood" | "framedblocks:framing_saw/framed_flat_double_slope_slab_corner" | "framedblocks:framed_flat_ext_inner_double_slope_panel_corner" | "mcwdoors:dark_oak_western_door" | "quark:building/stonecutting/stairs/tuff_bricks_stairs_stonecutter" | "chipped_express:stonecutting_chipped_spider_borderless_bricks_carving_from_bricks" | "pamhc2foodextended:bakedhamitem" | "quark:building/stonecutting/stairs/raw_gold_bricks_stairs_stonecutter" | "compressedblocks:shapeless_sextuple_crated_yellow_carpet" | "corail_woodcutter:woodcutting/biomesoplenty/redwood_fence_from_redwood_planks" | "create:cutting/compat/botania/dreamwood" | "quark:building/crafting/slabs/light_gray_shingles_slab" | "meadow:pine_trapdoor" | "botania:stripped_dreamwood_wall" | "chipped_express:stonecutting_chipped_small_cyan_terracotta_tiles_from_cyan_terracotta" | "quark:building/crafting/stairs/calcite_bricks_stairs" | "createdeco:mossy_dean_brick_slab" | "botanypots:botanypots/crafting/green_concrete_compact_hopper_botany_pot" | "chipped_express:stonecutting_chipped_fine_vertical_birch_planks_from_birch_planks" | "mcwroofs:lime_terracotta_upper_lower_roof" | "quark:building/crafting/raw_gold_bricks" | "chipped_express:stonecutting_chipped_waved_brown_glazed_terracotta_from_brown_glazed_terracotta" | "compressedblocks:shapeless_giga_crated_soul_campfire" | "refinedstorage:1024k_fluid_storage_part" | "handcrafted:dark_oak_fancy_bed" | "minecraft:polished_granite_stairs_from_polished_granite_stonecutting" | "compressedblocks:shapeless_crated_blaze_rod" | "pamhc2foodextended:chickenkatsuitem" | "compressedblocks:shapeless_c9_blackstone" | "mcwtrpdoors:oak_bark_trapdoor" | "mcwroofs:gutter_middle_light_blue" | "compressedblocks:shaped_triple_crated_sugar_cane" | "conditional:bloomingnature/wood_cutter/chestnut_button_woodcutter" | "quark:world/stonecutting/stairs/granite_bricks_stairs_stonecutter" | "botanypots:regions_unexplored/crop/white_trillium" | "pamhc2foodextended:cornedbeefandcabbageitem" | "handcrafted:skeleton_trophy" | "farmersdelight:purple_canvas_sign" | "handcrafted:dark_oak_counter" | "immersive_aircraft:bomb_bay" | "moa_decor_science:camahverdelima_1" | "moa_decor_toys:caballocafe_h_1" | "gemsnjewels:create/create_crushing_iolite_deepslate_ore" | "chipped_express:stonecutting_chipped_simple_coal_block_pillar_from_coal_block" | "quark:building/crafting/compressed/beetroot_crate" | "chipped_express:stonecutting_chipped_crying_deepslate_from_deepslate" | "chipped_express:stonecutting_chipped_donut_soul_lantern_from_soul_lantern" | "create:compat/betterendforge/pressing/end_moss_path" | "compressedblocks:shapeless_c3_stripped_cherry_log" | "create:cut_granite_brick_wall_from_stone_types_granite_stonecutting" | "biomesoplenty:magic_trapdoor" | "villagersplus:warped_horticulturist_table" | "chipped_express:stonecutting_chipped_bundled_cyan_wool_from_cyan_wool" | "cosmeticarmoursmod:green_knight_armour_helmet_rec" | "minecraft:green_wool" | "domesticationinnovation:pet_bed_yellow" | "chipped_express:stonecutting_chipped_smoothed_double_inlayed_coal_block_from_coal_block" | "compressedblocks:shaped_c0_red_nether_bricks" | "compressedblocks:shapeless_c7_cherry_planks" | "compressedblocks:shaped_giga_crated_orange_carpet" | "chipped_express:stonecutting_chipped_smooth_blue_ice_column_from_blue_ice" | "chipped_express:stonecutting_chipped_reinforced_waxed_weathered_copper_from_waxed_weathered_copper" | "compressedblocks:shaped_c8_blackstone" | "framedblocks:framed_elevated_slope_slab_rotate_to_framed_extended_slope_panel" | "cosmeticarmoursmod:magenta_plaid_2_white" | "chipped_express:stonecutting_chipped_fine_vertical_warped_planks_from_warped_planks" | "biomesoplenty:red_dye_from_waterlily" | "chipped_express:stonecutting_chipped_brick_bordered_smooth_stone_from_smooth_stone" | "lootbags:common_decorations/trophies_completion" | "quark:building/crafting/stonevariants/jasper_bricks" | "framedblocks:framed_centered_slab_rotate_to_framed_centered_panel" | "botania:horn_snow" | "create:compat/alexsmobs/emptying/lava_bottle" | "compressedblocks:shaped_giga_crated_amethyst_shard" | "compressedblocks:shapeless_c2_cherry_log" | "compressedblocks:shaped_quadruple_crated_ender_eye" | "railways:crafting/palettes/dyeing_1x/white_flat_riveted_locometal" | "beautify:birch_picture_frame" | "compressedblocks:shapeless_c9_coal_block" | "refinedstorage:coloring_recipes/yellow_wireless_transmitter" | "corail_woodcutter:woodcutting/jungle_door_from_jungle_logs" | "gemsnjewels:create/create_crushing_peridot_nether_ore" | "chipped_express:stonecutting_chipped_ancient_pearlescent_froglight_from_pearlescent_froglight" | "chipped_express:stonecutting_chipped_end_pumpkin_purple_from_pumpkin" | "luphieclutteredmod:luphie_pink_trapdoor_recipe" | "moa_decor_cookery:soporteinstrumentos_1" | "sophisticatedstorage:netherite_barrel" | "compressedblocks:shapeless_septuple_crated_cod" | "create:compat/autumnity/cutting/maple_log" | "compressedblocks:shaped_c0_spruce_log" | "moa_decor_bath:banera_1" | "create:cutting/compat/biomesoplenty/hellbark_log" | "pamhc2foodextended:papayajellyitem" | "handcrafted:goat_trophy" | "minecraft:respawn_anchor" | "chipped_express:stonecutting_chipped_cracked_disordered_raw_iron_block_bricks_from_raw_iron_block" | "chipped_express:stonecutting_chipped_crafted_magenta_wool_from_magenta_wool" | "create:cutting/compat/byg/skyris_wood" | "compressedblocks:shaped_c2_jungle_log" | "chipped_express:stonecutting_chipped_golden_paper_soul_lantern_from_soul_lantern" | "framedblocks:framed_flat_ext_slope_panel_corner_rotate_to_framed_flat_elev_slope_slab_corner" | "compressedblocks:shapeless_sextuple_crated_pointed_dripstone" | "chipped_express:stonecutting_chipped_beach_bamboo_door_from_bamboo_door" | "mcwroofs:blue_striped_awning" | "compressedblocks:shaped_c0_cobblestone" | "compressedblocks:shapeless_double_crated_blue_orchid" | "chipped_express:stonecutting_chipped_bolted_magenta_concrete_from_magenta_concrete" | "compressedblocks:shapeless_septuple_crated_oak_sapling" | "pamhc2foodextended:gooseberrypieitem" | "botania:livingwood_wall" | "chipped_express:stonecutting_chipped_warning_light_gray_concrete_from_light_gray_concrete" | "createaddition:charging/cut_copper_slab" | "cosmeticarmoursmod:light_grey_skirt_2_plaid" | "botania:fabulous_pool_upgrade" | "botania:yellow_shiny_flower" | "corail_woodcutter:woodcutting/spruce_door_from_spruce_logs" | "chipped_express:stonecutting_chipped_dirt_pillar_top_from_dirt" | "chipped_express:stonecutting_chipped_brick_bordered_packed_ice_from_packed_ice" | "chipped_express:stonecutting_chipped_large_diamond_pink_stained_glass_from_pink_stained_glass" | "pamhc2trees:roastedpistachioitem_forge" | "botania:slab_recombine/metamorphic_forest_stone" | "compressedblocks:shapeless_c8_spruce_planks" | "bakery:street_sign" | "mcwtrpdoors:spruce_swamp_trapdoor" | "minecraft:snow_block" | "snowyspirit:gumdrop_pink" | "utilitix:utilitix_brewery/upgrade" | "playershops:jungle_player_shop" | "compressedblocks:shapeless_quadruple_crated_spectral_arrow" | "supplementaries:treasure_map_recipe" | "minecraft:cyan_wool" | "minecraft:sandstone_stairs" | "meadow:wood_cutter/dark_oak/dark_oak_stairs_woodcutter" | "quark:building/crafting/hollowlogs/hollow_warped_stem" | "chipped_express:stonecutting_chipped_tiled_orange_carpet_from_orange_carpet" | "compressedblocks:shaped_quintuple_crated_green_carpet" | "mcwroofs:warped_planks_steep_roof" | "create:haunting/infested_cracked_stone_bricks" | "createdeco:long_scarlet_brick_slab_from_scarlet_bricks_stonecutting" | "compressedblocks:shapeless_octuple_crated_saddle" | "create:copper_tile_stairs" | "railways:crafting/palettes/dyeing_8x/magenta_flat_slashed_locometal" | "framedblocks:framed_large_corner_slope_panel" | "minecraft:coarse_dirt" | "botania:pattern_donut" | "create:crafting/kinetics/white_seat" | "mcwfurnituresbop:palm_double_wardrobe" | "mcwfurnituresbop:umbran_double_wardrobe" | "quark:building/crafting/vertslabs/polished_limestone_vertical_slab" | "aquaculturedelight:cooking/halibut_with_tartar_sauce" | "luphieclutteredmod:luphie_pink_fence_gate_recipe" | "refinedstorage:relay" | "mcwtrpdoors:oak_mystic_trapdoor" | "minecraft:fermented_spider_eye" | "railways:crafting/palettes/dyeing_1x/blue_iron_wrapped_locometal" | "compressedblocks:shaped_crated_pumpkin_seeds" | "chipped_express:stonecutting_chipped_duh_lodestone_from_lodestone" | "chipped_express:stonecutting_chipped_thin_oak_planks_from_oak_planks" | "meadow:limestone_wall_from_limestone_stonecutting" | "create:cutting/compat/biomesoplenty/mahogany_log" | "compressedblocks:shapeless_c7_bamboo_mosaic" | "mcwdoors:spruce_classic_door" | "create:cutting/compat/ecologics/flowering_azalea_log" | "supplementaries:flags/flag_black" | "mcwwindows:acacia_louvered_shutter" | "chipped_express:stonecutting_chipped_crunched_packed_mud_bricks_from_packed_mud" | "moa_decor_garden_:m_pacacia_1" | "botania:stonecutting/corporea_brick_to_corporea_brick_slab" | "pamhc2foodextended:breadfruityogurtitem" | "minecraft:cobbled_deepslate_slab" | "createdeco:short_red_brick_stairs" | "create:crafting/appliances/dough" | "mcwroofs:oak_upper_steep_roof" | "quark:world/stonecutting/walls/jasper_wall_stonecutter" | "botanypots:botanypots/crafting/blue_terracotta_compact_hopper_botany_pot" | "luphieclutteredmod:luphie_yellow_fence_gate_recipe" | "compressedblocks:shaped_c7_netherite_block" | "mcwfurnitures:stripped_spruce_stool_chair" | "compressedblocks:shapeless_c6_exposed_cut_copper" | "minecraft:chiseled_quartz_block" | "create:crafting/materials/rose_quartz_tilesfrom_conversion" | "chipped_express:stonecutting_chipped_boarded_mangrove_door_from_mangrove_door" | "compressedblocks:shaped_c4_waxed_oxidized_cut_copper" | "pamhc2foodextended:saltedcaramelitem" | "botanypots:farmersdelight/crop/wild_rice" | "cosmeticarmoursmod:magenta_plaid_2_skirt" | "chipped_express:stonecutting_chipped_rounded_gilded_blackstone_bricks_from_gilded_blackstone" | "create:cut_crimsite_brick_stairs_from_stone_types_crimsite_stonecutting" | "compressedblocks:shaped_triple_crated_rail" | "compressedblocks:shapeless_giga_crated_map" | "createdeco:short_umber_brick_stairs_from_umber_bricks_stonecutting" | "compressedblocks:shaped_septuple_crated_stick" | "railways:stonecutting/palettes/cycling/brown_locometal_smokebox" | "chipped_express:stonecutting_chipped_woved_light_blue_wool_from_light_blue_wool" | "comforts:hammock_to_lime" | "moa_decor_lights:farolpared_b_1" | "luphieclutteredmod:luphie_purple_armchair_recipe" | "sophisticatedstorage:light_gray_shulker_box_to_sophisticated" | "quark:building/stonecutting/mud_pillar_stonecutter" | "utilitix:gilding" | "chipped_express:stonecutting_chipped_simple_andesite_pillar_from_andesite" | "compressedblocks:shapeless_crated_nautilus_shell" | "botania:dark_quartz_stairs" | "quark:building/crafting/chests/warped_chest" | "compressedblocks:shaped_c8_stripped_mangrove_log" | "create:blasting/ingot_uranium_compat_mekanism" | "compressedblocks:shapeless_mega_crated_poisonous_potato" | "bakery:oat_slab" | "chipped_express:stonecutting_chipped_glass_oak_door_from_oak_door" | "handcrafted:oak_pillar_trim" | "compressedblocks:shapeless_c3_red_sand" | "pamhc2foodcore:glowberryyogurtitem" | "moa_decor_science:jeringaroja_1" | "chipped_express:stonecutting_chipped_massive_raw_copper_block_bricks_from_raw_copper_block" | "chipped_express:stonecutting_chipped_stacked_packed_mud_bricks_from_packed_mud" | "meadow:coal_from_blasting_alpine_coal_ore" | "botanypots:pamhc2crops/crop/flax" | "compressedblocks:shapeless_quadruple_crated_rabbit" | "create:smelting/ingot_lead_compat_mekanism" | "chipped_express:stonecutting_chipped_small_pink_stained_glass_pane_from_pink_stained_glass_pane" | "chipped_express:stonecutting_chipped_inlayed_sea_lantern_from_sea_lantern" | "chipped_express:stonecutting_chipped_symbolic_mud_bricks_pillar_from_mud_bricks" | "compressedblocks:shapeless_septuple_crated_lightning_rod" | "botania:flighttiara_5" | "botania:flighttiara_4" | "botania:flighttiara_7" | "botania:terrasteel_helmet" | "botania:flighttiara_6" | "botania:flighttiara_1" | "botania:flighttiara_0" | "botania:flighttiara_3" | "compressedblocks:shaped_triple_crated_totem_of_undying" | "chipped_express:stonecutting_chipped_sided_mangrove_planks_from_mangrove_planks" | "botania:flighttiara_2" | "bakery:strawberry_from_crate" | "create:compat/projectvibrantjourneys/cutting/aspen_log" | "compressedblocks:shaped_c4_waxed_cut_copper" | "botania:flighttiara_8" | "compressedblocks:shapeless_quadruple_crated_totem_of_undying" | "conditional:regions_unexplored/wood_cutter/blackwood_trapdoor_woodcutter" | "chipped_express:stonecutting_chipped_stringed_purple_wool_from_purple_wool" | "handcrafted:dark_oak_chair" | "chipped_express:stonecutting_chipped_thin_vine_from_vine" | "chipped_express:stonecutting_chipped_ornate_crying_obsidian_pillar_from_crying_obsidian" | "lootbags:common_decorations/snare_completion" | "railways:crafting/palettes/dyeing_8x/red_riveted_locometal" | "framedblocks:framed_small_double_corner_slope_panel" | "railways:sequenced_assembly/track_ender_wide" | "chipped_express:stonecutting_chipped_l_sign_stripped_warped_stem_from_stripped_warped_stem" | "chipped_express:stonecutting_chipped_spider_dripstone_block_carving_from_dripstone_block" | "chipped_express:stonecutting_chipped_starry_yellow_terracotta_from_yellow_terracotta" | "chipped_express:stonecutting_chipped_tiled_tuff_column_from_tuff" | "compressedblocks:shapeless_c1_redstone_ore" | "quark:building/stonecutting/walls/soul_sandstone_wall_stonecutter" | "wildberries:blackberry_pie_from_slices" | "compressedblocks:shapeless_triple_crated_light_gray_dye" | "botanypots:minecraft/soil/podzol" | "create:cutting/compat/ars_nouveau/stripped_blue_archwood_log" | "compressedblocks:shaped_crated_light_blue_dye" | "mcwwindows:blackstone_window2" | "chipped_express:stonecutting_chipped_checkered_deepslate_tiles_from_deepslate" | "minecraft:spruce_boat" | "compressedblocks:shapeless_sextuple_crated_cooked_mutton" | "chipped_express:stonecutting_chipped_shrunken_brown_glazed_terracotta_from_brown_glazed_terracotta" | "bakery:bread_knife" | "chipped_express:stonecutting_chipped_fancy_pink_stained_glass_pane_from_pink_stained_glass_pane" | "compressedblocks:shaped_c6_obsidian" | "botania:elf_glass_pane" | "chipped_express:stonecutting_chipped_spiraled_blackstone_from_blackstone" | "compressedblocks:shaped_septuple_crated_fermented_spider_eye" | "conditional:regions_unexplored/wood_cutter/joshua_fence_woodcutter" | "chipped_express:stonecutting_chipped_spiraled_red_nether_bricks_from_red_nether_bricks" | "snowyspirit:compressedblocks/sled_c5_mangrove" | "pamhc2foodextended:gyudonitem" | "chipped_express:stonecutting_chipped_curly_purpur_block_pillar_from_purpur_block" | "chipped_express:stonecutting_chipped_circular_blue_stained_glass_from_blue_stained_glass" | "quark:building/crafting/vertplanks/vertical_ancient_planks_revert" | "compressedblocks:shapeless_mega_crated_beetroot_seeds" | "chipped_express:stonecutting_chipped_stacked_cherry_planks_from_cherry_planks" | "conditional:bloomingnature/wood_cutter/fir_slabs_woodcutter" | "refinedstorage:crafting_grid/white_crafting_grid" | "brewery:drawer" | "pamhc2foodcore:chocolatecakeitem" | "moa_decor_garden_:m_pjungla_1" | "moa_decor_lights:vt_ncerezo_1" | "quark:building/crafting/vertplanks/vertical_acacia_planks" | "chipped_express:stonecutting_chipped_shrooming_warped_stem_from_warped_stem" | "farmersdelight:salmon_roll" | "compressedblocks:shaped_c3_mangrove_log" | "pamhc2foodextended:meringuecookieitem" | "botanypots:botanypots/crafting/blue_concrete_hopper_botany_pot" | "sophisticatedstorage:compacting_upgrade" | "moa_decor_holidays:gema_festividades_1" | "pamhc2foodextended:mangochutneyitem" | "mcwfurnitures:mangrove_drawer_counter" | "create:cut_tuff_brick_slab_recycling" | "chipped_express:stonecutting_chipped_engraved_tuff_from_tuff" | "botanypots:minecraft/soil/granite" | "compressedblocks:shaped_c7_waxed_weathered_copper" | "chipped_express:stonecutting_chipped_paneled_mangrove_door_from_mangrove_door" | "compressedblocks:shapeless_sextuple_crated_white_dye" | "vinery:big_table" | "compressedblocks:shapeless_sextuple_crated_scute" | "compressedblocks:shapeless_c2_warped_nylium" | "meadow:cooking_pot/ham_cheese" | "fairylights:hanging_lights_augmentation" | "biomesoplenty:dead_slab" | "compressedblocks:shapeless_sextuple_crated_phantom_membrane" | "pamhc2foodextended:breadfruitjuiceitem" | "quark:building/stonecutting/slabs/cobblestone_bricks_slab_stonecutter" | "compressedblocks:shapeless_double_crated_spruce_sapling" | "exoticbirds:gold_birdcage" | "chipped_express:stonecutting_chipped_oak_webbed_bookshelf_from_bookshelf" | "compressedblocks:shapeless_giga_crated_potato" | "chipped_express:stonecutting_chipped_andesite_pointed_dripstone_from_pointed_dripstone" | "compressedblocks:shaped_c9_stripped_birch_log" | "chipped_express:stonecutting_chipped_barky_brown_wool_from_brown_wool" | "compressedblocks:shaped_septuple_crated_torch" | "pamhc2foodcore:melonjellyitem" | "compressedblocks:shapeless_quadruple_crated_magma_cream" | "chipped_express:stonecutting_chipped_rectangle_blue_wool_from_blue_wool" | "chipped_express:stonecutting_chipped_green_terracotta_column_from_green_terracotta" | "farmersdelight:cutting/gravel" | "compressedblocks:shaped_triple_crated_dragon_breath" | "chipped_express:stonecutting_chipped_brick_bordered_mossy_stone_bricks_from_mossy_stone_bricks" | "moa_decor_toys:aldeanodesierto_1" | "farmersdelight:cooking/baked_cod_stew" | "chipped_express:stonecutting_chipped_inscribed_mossy_stone_bricks_from_mossy_stone_bricks" | "createdeco:tiled_blue_brick_stairs" | "compressedblocks:shaped_double_crated_turtle_egg" | "quark:world/crafting/woodsets/azalea/trapped_chest" | "compressedblocks:shaped_mega_crated_milk_bucket" | "compressedblocks:shaped_mega_crated_white_carpet" | "createdeco:brass_coinstack" | "cosmeticarmoursmod:light_grey_skirt_2_white" | "farmersdelight:cherry_cabinet" | "chipped_express:stonecutting_chipped_overlapping_redstone_block_tiles_from_redstone_block" | "comforts:hammock_purple" | "handcrafted:terracotta_crockery_combo" | "quark:building/stonecutting/slabs/pink_shingles_slab_stonecutter2" | "compressedblocks:shaped_c6_stripped_jungle_log" | "create:cutting/compat/integrateddynamics/menril_log" | "mcwroofs:yellow_terracotta_lower_roof" | "compressedblocks:shapeless_quintuple_crated_oak_sapling" | "refinedstorage:coloring_recipes/security_manager" | "compressedblocks:shapeless_sextuple_crated_leather" | "mcwroofs:light_blue_terracotta_steep_roof" | "mcwroofs:gutter_middle_purple" | "chipped_express:stonecutting_chipped_tiny_brick_bordered_snow_block_from_snow_block" | "minecraft:dye_light_gray_wool" | "quark:building/crafting/stonevariants/dripstone_bricks" | "compressedblocks:shapeless_c9_jungle_planks" | "minecraft:writable_book" | "chipped_express:stonecutting_chipped_ancient_debris_pillar_top_from_ancient_debris" | "botanypots:botanypots/crafting/lime_glazed_terracotta_hopper_botany_pot" | "create:cut_dripstone_brick_wall_from_stone_types_dripstone_stonecutting" | "railways:stonecutting/palettes/cycling/flat_slashed_locometal" | "pamhc2trees:dragonfruit_sapling" | "minecraft:diamond_pickaxe" | "gemsnjewels:forge_garnet_set_gold_ring" | "chipped_express:stonecutting_chipped_minimized_white_glazed_terracotta_from_white_glazed_terracotta" | "chipped_express:stonecutting_chipped_layered_lime_terracotta_from_lime_terracotta" | "createdeco:cracked_umber_brick_slab_from_cracked_umber_bricks_stonecutting" | "compressedblocks:shapeless_c2_coal_ore" | "chipped_express:stonecutting_chipped_unamused_mossy_stone_bricks_from_mossy_stone_bricks" | "create:crushing/deepslate_redstone_ore" | "mcwroofs:deepslate_attic_roof" | "create:compat/byg/milling/incan_lily" | "mcwroofs:orange_terracotta_upper_steep_roof" | "chipped_express:stonecutting_chipped_windmill_light_gray_wool_from_light_gray_wool" | "luphieclutteredmod:luphie_open_cardboard_box_recipe" | "moa_decor_cookery:platos_1" | "quark:world/crafting/panes/indigo_corundum_pane" | "gemsnjewels:ornament_iolite" | "compressedblocks:shaped_c2_cut_red_sandstone" | "chipped_express:stonecutting_chipped_fancy_white_stained_glass_pane_from_white_stained_glass_pane" | "vinery:seed_from_white_savanna_grape" | "moa_decor_lights:vt_bmanglar_1" | "luphieclutteredmod:luphie_mushroom_bookshelf_recipe" | "chipped_express:stonecutting_chipped_tiny_layered_andesite_slabs_from_andesite" | "createdeco:short_dusk_brick_slab_from_tiled_dusk_brick_slab_stonecutting" | "chipped_express:stonecutting_chipped_crying_netherrack_from_netherrack" | "chipped_express:stonecutting_chipped_inlayed_ice_from_ice" | "luphieclutteredmod:yellow_endtable" | "mcwtrpdoors:mangrove_classic_trapdoor" | "chipped_express:stonecutting_chipped_purpur_block_pillar_top_from_purpur_block" | "mcwfurnitures:stripped_mangrove_triple_drawer" | "compressedblocks:shaped_sextuple_crated_painting" | "bloomingnature:swamp_oak_fence_gate" | "compressedblocks:shapeless_octuple_crated_lightning_rod" | "chipped_express:stonecutting_chipped_slotted_crimson_trapdoor_from_crimson_trapdoor" | "supplementaries:compressedblocks/sign_post_c8_oak" | "quark:world/crafting/panes/orange_corundum_pane" | "constructionwand:infinity_wand" | "sophisticatedstorage:green_shulker_box_to_sophisticated" | "cookingforblockheads:gray_kitchen_floor" | "beachparty:palm_chest_boat" | "luphieclutteredmod:luphie_small_filled_jars_b_recipe" | "delightful:knives/blasting/bronze_thermal" | "compressedblocks:shapeless_c3_stripped_jungle_log" | "chipped_express:stonecutting_chipped_smooth_mangrove_planks_from_mangrove_planks" | "mcwdoors:warped_waffle_door" | "quark:world/stonecutting/stairs/shale_stairs_stonecutter" | "botania:cosmetic_hyper_plus" | "chipped_express:stonecutting_chipped_small_crying_obsidian_bricks_from_crying_obsidian" | "chipped_express:stonecutting_chipped_purple_glazed_terracotta_pillar_sides_from_purple_glazed_terracotta" | "botania:lens_weight" | "meadow:fondue" | "compressedblocks:shapeless_septuple_crated_mutton" | "quark:building/crafting/stonevariants/chiseled_granite_bricks" | "farmersdelight:cutting/oak_wood" | "compressedblocks:shapeless_mega_crated_light_blue_carpet" | "pamhc2foodextended:blueberryjellysandwichitem" | "mcwfurnitures:stripped_mangrove_modern_wardrobe" | "quark:world/crafting/waxed_indigo_corundum" | "chipped_express:stonecutting_chipped_edge_cut_jungle_log_from_jungle_log" | "mcwdoors:bamboo_classic_door" | "railways:crafting/palettes/dyeing_8x/yellow_copper_wrapped_locometal_boiler" | "quark:building/crafting/purple_stool" | "compressedblocks:shapeless_c6_acacia_log" | "chipped_express:stonecutting_chipped_knotted_stripped_spruce_log_from_stripped_spruce_log" | "chipped_express:stonecutting_chipped_blocky_brown_wool_from_brown_wool" | "mcwfences:warped_highley_gate" | "create:warped_window_pane" | "create:crafting/schematics/schematic_table" | "createdeco:industrial_iron_block" | "compressedblocks:shaped_sextuple_crated_red_carpet" | "chipped_express:stonecutting_chipped_curly_lodestone_pillar_from_lodestone" | "compressedblocks:shapeless_septuple_crated_white_tulip" | "cosmeticarmoursmod:white_sock_skirt_2_red" | "botania:stonecutting/metamorphic_mountain_bricks_to_chiseled_metamorphic_mountain_bricks" | "mcwroofs:sandstone_roof" | "railways:stonecutting/palettes/cycling/yellow_plated_locometal" | "chipped_express:stonecutting_chipped_duh_dripstone_block_from_dripstone_block" | "chipped_express:stonecutting_chipped_i_sign_stripped_mangrove_log_from_stripped_mangrove_log" | "compressedblocks:shapeless_double_crated_red_carpet" | "cosmeticarmoursmod:white_sock_plaid_2_blue" | "utilitix:diamond_shears" | "minecraft:wooden_pickaxe" | "pamhc2foodcore:mashedpotatoesitem" | "compressedblocks:shaped_c6_oxidized_cut_copper" | "chipped_express:stonecutting_chipped_woved_brown_wool_from_brown_wool" | "framedblocks:framed_pressure_plate" | "moa_decor_science:camahrosa_1" | "railways:sequenced_assembly/track_twilightforest_sortingwood" | "lootbags:common_decorations/parrot_plushes_completion" | "botanypots:minecraft/soil/hay_bale" | "compressedblocks:shaped_septuple_crated_blaze_powder" | "quark:building/crafting/shingles/magenta_shingles" | "botanypots:botanypots/crafting/green_terracotta_botany_pot" | "supplementaries:pancake" | "corail_woodcutter:woodcutting/mangrove_button_from_mangrove_logs" | "railways:mechanical_crafting/black_iron_wrapped_locometal_boiler" | "compressedblocks:shaped_sextuple_crated_brown_dye" | "botania:mana_infusion/jungle_leaves_dupe" | "chipped_express:stonecutting_chipped_curled_terracotta_from_terracotta" | "botanypots:botania/crop/orange_mystical_flower" | "minecraft:diamond_from_blasting_diamond_ore" | "createaddition:compat/immersiveengineering/item_application/leaded_concrete" | "botania:mana_infusion/dark_oak_leaves_dupe" | "compressedblocks:shapeless_c0_bamboo_planks" | "handcrafted:blue_glazed_wide_pot" | "chipped_express:stonecutting_chipped_tiled_red_stained_glass_from_red_stained_glass" | "create:crushing/tin_ore" | "moa_decor_bath:bcerezo_1" | "moa_decor_holidays:banderines_blanco_1" | "minecraft:end_stone_brick_stairs" | "chiselsandbits:rotate_around_x" | "chiselsandbits:rotate_around_y" | "chiselsandbits:rotate_around_z" | "chipped_express:stonecutting_chipped_crunched_mud_bricks_from_mud" | "chipped_express:stonecutting_chipped_patched_light_gray_carpet_from_light_gray_carpet" | "chipped_express:stonecutting_chipped_light_gray_concrete_panel_from_light_gray_concrete" | "compressedblocks:shapeless_c7_soul_sand" | "chipped_express:stonecutting_chipped_starry_cyan_glazed_terracotta_from_cyan_glazed_terracotta" | "createdeco:long_umber_brick_slab_from_long_umber_bricks_stonecutting" | "chipped_express:stonecutting_chipped_purple_concrete_panel_from_purple_concrete" | "cosmeticarmoursmod:white_plaid_2_red" | "chipped_express:stonecutting_chipped_carved_dirt_from_dirt" | "conditional:bloomingnature/wood_cutter/baobab_trapdoor_woodcutter" | "quark:building/crafting/glass/red_framed_glass" | "handcrafted:lime_cushion" | "compressedblocks:shapeless_c9_sandstone" | "luphieclutteredmod:luphie_hanging_pottery_shelves_recipe" | "pamhc2foodextended:lavendershortbreaditem" | "sliceanddice:filling/hot_cocoa_from_fluid" | "moa_decor_art:aerosolcafe_1" | "botania:floating_rafflowsia" | "createdeco:iron_sheet_metal" | "sophisticatedstorage:limited_iron_barrel_3_from_limited_copper_barrel_3" | "quark:building/stonecutting/walls/mossy_cobblestone_bricks_wall_stonecutter" | "minecraft:mangrove_fence" | "supplementaries:stool_from_feather_block" | "refinedstorage:coloring_recipes/gray_crafting_monitor" | "chipped_express:stonecutting_chipped_soft_pink_carpet_from_pink_carpet" | "cookingforblockheads:orange_kitchen_floor" | "botania:spawner_claw" | "gemsnjewels:create/create_crushing_pale_diamond_nether_ore" | "chipped_express:stonecutting_chipped_small_mossy_stone_bricks_bricks_from_mossy_stone_bricks" | "compressedblocks:shaped_double_crated_brown_dye" | "delightful:knives/refined_glowstone_knife" | "compressedblocks:shapeless_c9_nether_bricks" | "compressedblocks:shapeless_c3_nether_wart_block" | "chipped_express:stonecutting_chipped_tiled_ancient_debris_column_from_ancient_debris" | "chipped_express:stonecutting_chipped_mud_bricks_pillar_top_from_mud_bricks" | "pamhc2foodextended:juniperberryjellyitem" | "railways:stonecutting/palettes/cycling/lime_slashed_locometal" | "botanypots:nethersdelight/crop/propelplant" | "chipped_express:stonecutting_chipped_reinforced_waxed_oxidized_copper_from_waxed_oxidized_copper" | "refinedstorage:coloring_recipes/orange_crafter" | "chipped_express:stonecutting_chipped_lapis_block_mini_tiles_from_lapis_block" | "chipped_express:stonecutting_chipped_crying_obsidian_from_obsidian" | "compressedblocks:shapeless_mega_crated_white_tulip" | "conditional:bloomingnature/wood_cutter/baobab_fence_woodcutter" | "createdeco:short_verdant_brick_stairs_from_verdant_bricks_stonecutting" | "pamhc2foodcore:muttonpotpieitem" | "chipped_express:stonecutting_chipped_cornered_magenta_wool_from_magenta_wool" | "compressedblocks:shaped_giga_crated_magma_cream" | "moa_decor_science:lupa_1" | "refinedstorage:pattern_grid/black_pattern_grid" | "delightful:storage/salmonberry_storage_block" | "luphieclutteredmod:luphie_blue_mushroom_bookshelf_recipe" | "minecraft:spruce_chest_boat" | "compressedblocks:shaped_c5_basalt" | "quark:world/crafting/woodsets/azalea/ladder" | "cosmeticarmoursmod:green_knight_armour_leggings_rec" | "chipped_express:stonecutting_chipped_checkered_spruce_trapdoor_from_spruce_trapdoor" | "chipped_express:stonecutting_chipped_wickered_magenta_wool_from_magenta_wool" | "meadow:cheesecake" | "chipped_express:stonecutting_chipped_minimized_light_blue_glazed_terracotta_from_light_blue_glazed_terracotta" | "farmersdelight:sweet_berry_cheesecake_from_slices" | "vinery:cherry_button" | "pamhc2foodextended:kalechipsitem" | "luphieclutteredmod:stripped_flowering_yellow_log_recipe" | "quark:building/crafting/vertplanks/vertical_jungle_planks" | "compressedblocks:shapeless_mega_crated_blaze_powder" | "chipped_express:stonecutting_chipped_dripstone_block_mini_tiles_from_dripstone_block" | "createdeco:short_scarlet_brick_slab_from_scarlet_bricks_stonecutting" | "cosmeticarmoursmod:cyan_plaid_2_white" | "supplementaries:ash_brick_stairs" | "corail_woodcutter:woodcutting/biomesoplenty/magic_planks_from_magic_logs" | "botanypots:botanypots/crafting/lime_terracotta_compact_hopper_botany_pot" | "bloomingnature:red_brick_slab" | "quark:building/stonecutting/stonevariants/jasper_bricks_stairs_rough_stonecutting" | "minecraft:snow" | "compressedblocks:shapeless_double_crated_beetroot_seeds" | "create:cut_crimsite_brick_slab_recycling" | "refinedstorage:coloring_recipes/red_wireless_transmitter" | "handcrafted:quartz_corner_trim" | "compressedblocks:shaped_c5_exposed_copper" | "botanypots:regions_unexplored/crop/steppe_tall_grass" | "chipped_express:stonecutting_chipped_ornate_netherrack_pillar_from_netherrack" | "railways:crafting/palettes/dyeing_8x/green_brass_wrapped_locometal_boiler" | "corail_woodcutter:woodcutting/biomesoplenty/hellbark_slab_from_hellbark_logs" | "pamhc2foodextended:dragonfruitjellyitem" | "cosmeticarmoursmod:red_plaid_2_white" | "botania:smelting/metamorphic_swamp_stone" | "moa_decor_bath:lb_bhombres_1" | "moa_decor_bath:lb_bhombres_2" | "biomesoplenty:chiseled_orange_sandstone" | "quark:building/crafting/panes/paper_wall" | "create:crafting/appliances/copper_diving_boots" | "compressedblocks:shaped_crated_lime_carpet" | "corail_woodcutter:woodcutting/biomesoplenty/willow_fence_gate_from_willow_logs" | "pamhc2foodextended:pearjellyitem" | "create:compat/silentsgems/crushing/moonstone_ore" | "compressedblocks:shapeless_septuple_crated_red_tulip" | "framedblocks:framed_vertical_double_half_stairs" | "macawsroofsbop:jacaranda_planks_lower_roof" | "compressedblocks:shapeless_mega_crated_salmon" | "pamhc2foodextended:orangejellyitem" | "chipped_express:stonecutting_chipped_wickered_purple_carpet_from_purple_carpet" | "create:crimson_window" | "beautify:acacia_picture_frame" | "compressedblocks:shaped_triple_crated_beetroot_seeds" | "chipped_express:stonecutting_chipped_tiny_layered_borderless_bricks_bricks_from_bricks" | "farmersdelight:cutting/cooked_cod" | "botanypots:botanypots/crafting/white_concrete_botany_pot" | "createdeco:decal_creeper" | "minecraft:yellow_terracotta" | "compressedblocks:shaped_septuple_crated_end_rod" | "compressedblocks:shaped_c1_gravel" | "quark:building/crafting/vertslabs/stone_brick_vertical_slab_revert" | "pamhc2foodextended:breakfastburritoitem" | "compressedblocks:shaped_septuple_crated_experience_bottle" | "minecraft:cherry_boat" | "minecraft:chiseled_nether_bricks_from_nether_bricks_stonecutting" | "compressedblocks:shaped_quadruple_crated_rail" | "corail_woodcutter:woodcutting/biomesoplenty/fir_boat_from_fir_logs" | "refinedstorage:256k_fluid_storage_part" | "aquaculture:cooked_fish_fillet_from_campfire" | "chipped_express:stonecutting_chipped_yellow_concrete_bricks_from_yellow_concrete" | "create:compat/silentsgems/crushing/jasper_ore" | "compressedblocks:shapeless_c8_cut_red_sandstone" | "moa_decor_art:microfonoenpedestal_1" | "chipped_express:stonecutting_chipped_boarded_bamboo_door_from_bamboo_door" | "framedblocks:framing_saw/framed_stacked_slope_slab" | "mcwfurnituresbop:dead_drawer" | "compressedblocks:shapeless_c8_netherrack" | "mcwfurnitures:stripped_jungle_modern_chair" | "corail_woodcutter:woodcutting/tropicraft/palm_trapdoor_from_palm_planks" | "alexsmobs:bison_upgrade" | "framedblocks:framed_prism_corner" | "pamhc2foodextended:springsaladitem" | "chipped_express:stonecutting_chipped_ornate_red_stained_glass_pane_from_red_stained_glass_pane" | "create:cut_deepslate_wall_from_stone_types_deepslate_stonecutting" | "compressedblocks:shaped_giga_crated_red_tulip" | "compressedblocks:shapeless_quadruple_crated_end_crystal" | "minecraft:barrel" | "delightful:food/berry_matcha_latte" | "chipped_express:stonecutting_chipped_blank_stone_carving_from_stone" | "quark:building/crafting/blue_blossom_hedge" | "create:tuff_pillar_from_stone_types_tuff_stonecutting" | "handcrafted:crimson_bench" | "quark:building/stonecutting/slabs/orange_shingles_slab_stonecutter2" | "chipped_express:stonecutting_chipped_framed_cherry_planks_from_cherry_planks" | "botania:laputa_shard" | "aquaculture:golden_fishing_rod" | "quark:building/stonecutting/slabs/purple_shingles_slab_stonecutter2" | "createdeco:tiled_dean_bricks_from_short_dean_bricks_stonecutting" | "mcwdoors:acacia_swamp_door" | "quark:building/stonecutting/stonevariants/andesite_bricks_polished_stonecutting" | "botania:stonecutting/azulejo_13" | "botania:stonecutting/azulejo_12" | "botania:stonecutting/azulejo_11" | "botania:stonecutting/azulejo_10" | "chipped:benches/mechanist_workbench" | "compressedblocks:shaped_quintuple_crated_tropical_fish" | "compressedblocks:shaped_crated_gray_dye" | "chipped_express:stonecutting_chipped_netherrack_pointed_dripstone_from_pointed_dripstone" | "compressedblocks:shapeless_septuple_crated_weeping_vines" | "mcwroofs:blue_concrete_attic_roof" | "compressedblocks:shapeless_giga_crated_spectral_arrow" | "compressedblocks:shaped_crated_sculk_vein" | "gemsnjewels:stacked_kunzite_block" | "pamhc2foodextended:fajitaburritoitem" | "minecraft:shaper_armor_trim_smithing_template" | "cosmeticarmoursmod:christmas_elf_coat_green_ftm_rec" | "mcwfurnitures:jungle_cupboard_counter" | "cosmeticarmoursmod:royal_tunic_light_blue_2_white" | "compressedblocks:shaped_quintuple_crated_saddle" | "minecraft:cauldron" | "moa_decor_cookery:ollabetabel_1" | "moa_decor_cookery:papa_1" | "quark:building/stonecutting/stonevariants/tuff_bricks_slab_rough_stonecutting" | "vinery:winemaker_boots" | "botania:pure_daisy/blue_ice" | "compressedblocks:shapeless_giga_crated_white_carpet" | "createdeco:tiled_blue_brick_slab_from_short_blue_bricks_stonecutting" | "minecraft:waxed_weathered_cut_copper_slab_from_honeycomb" | "pamhc2foodextended:museliitem" | "chipped_express:stonecutting_chipped_stacked_mossy_stone_bricks_bricks_from_mossy_stone_bricks" | "mcwdoors:spruce_modern_door" | "chipped_express:stonecutting_chipped_light_dotted_red_mushroom_block_from_red_mushroom_block" | "compressedblocks:shapeless_quintuple_crated_sugar_cane" | "alexsmobs:void_worm_effigy" | "create:cutting/compat/byg/cypress_log" | "botania:stonecutting/azulejo_15" | "minecraft:gold_ingot_from_smelting_gold_ore" | "botania:stonecutting/azulejo_14" | "pamhc2foodextended:almondbutteritem" | "pamhc2crops:parsnipseeditem" | "botania:mana_infusion/soul_sand_dupe" | "compressedblocks:shapeless_octuple_crated_wheat_seeds" | "railways:sequenced_assembly/track_natures_spirit_redwood_narrow" | "railways:stonecutting/palettes/cycling/yellow_riveted_locometal" | "chipped_express:stonecutting_chipped_pressed_spruce_door_from_spruce_door" | "create:compat/atmospheric/cutting/kousa_log" | "pamhc2foodextended:coleslawitem" | "compressedblocks:shaped_mega_crated_painting" | "botanypots:botanypots/crafting/terracotta_botany_pot" | "minecraft:chest" | "railways:crafting/palettes/dyeing_8x/red_iron_wrapped_locometal" | "minecraft:gray_stained_glass" | "compressedblocks:shapeless_septuple_crated_honey_bottle" | "cosmeticarmoursmod:royal_tunic_pink_2_white" | "quark:building/crafting/stairs/netherrack_bricks_stairs" | "chipped_express:stonecutting_chipped_pink_concrete_tiles_from_pink_concrete" | "mcwfurnituresbop:mahogany_stool_chair" | "compressedblocks:shaped_mega_crated_honey_bottle" | "chipped_express:stonecutting_chipped_inscribed_green_terracotta_from_green_terracotta" | "cosmeticarmoursmod:red_plaid_2_skirt" | "pamhc2foodextended:haggisitem" | "chipped_express:stonecutting_chipped_crimson_crate_from_barrel" | "chipped_express:stonecutting_chipped_firewood_acacia_log_from_acacia_log" | "quark:tweaks/blasting/raw_iron_block_blast" | "chipped_express:stonecutting_chipped_cubed_white_carpet_from_white_carpet" | "compressedblocks:shaped_c6_bricks" | "corail_woodcutter:woodcutting/tropicraft/mangrove_planks_from_mangrove_logs" | "moa_decor_cookery:aacaciasc_1" | "cookingforblockheads:yellow_kitchen_floor" | "mcwbridges:nether_bricks_bridge_stair_recycle" | "chipped_express:stonecutting_chipped_tiled_ancient_debris_from_ancient_debris" | "minecraft:deepslate_bricks_from_cobbled_deepslate_stonecutting" | "createdeco:mossy_umber_bricks_from_vine" | "railways:crafting/palettes/dyeing_8x/light_blue_locometal_smokebox" | "bloomingnature:sticks_from_beach_bush" | "utilitix:stone_wall" | "botania:manasteel_pick" | "create:compacting/granite_from_flint" | "cosmeticarmoursmod:magenta_sock_skirt_2_white" | "create:compat/thermal/crushing/sulfur_ore" | "framedblocks:framed_vertical_sliced_stairs" | "compressedblocks:shapeless_sextuple_crated_dragon_breath" | "corail_woodcutter:woodcutting/oak_fence_from_oak_planks" | "moa_decor_garden_:florero_tallium_1" | "chipped_express:stonecutting_chipped_rounded_sandstone_bricks_from_sandstone" | "compressedblocks:shaped_c1_exposed_copper" | "farmersdelight:cooked_cod_slice_from_campfire_cooking" | "railways:crafting/palettes/dyeing_1x/purple_flat_riveted_locometal" | "compressedblocks:shapeless_c2_obsidian" | "botania:slab_recombine/black_pavement" | "create:copper_ladder_from_ingots_copper_stonecutting" | "sophisticatedstorage:dark_oak_barrel" | "compressedblocks:shaped_quadruple_crated_nether_star" | "quark:building/stonecutting/vertslabs/brown_shingles_vertical_slab_stonecutter" | "snowyspirit:compressedblocks/sled_c9_spruce" | "cosmeticarmoursmod:cyan_plaid_2_skirt" | "chipped_express:stonecutting_chipped_rectangle_green_wool_from_green_wool" | "chipped_express:stonecutting_chipped_grill_white_concrete_from_white_concrete" | "create:cutting/stripped_birch_log" | "chipped_express:stonecutting_chipped_windmill_lime_wool_from_lime_wool" | "compressedblocks:shapeless_quadruple_crated_honey_bottle" | "minecraft:iron_boots" | "chipped_express:stonecutting_chipped_crossed_yellow_terracotta_from_yellow_terracotta" | "mcwroofs:cobblestone_steep_roof" | "createdeco:long_dusk_brick_slab_from_dusk_bricks_stonecutting" | "bloomingnature:dye_white_from_foxglove_white" | "minecraft:golden_chestplate" | "mcwtrpdoors:print_cottage" | "chipped_express:stonecutting_chipped_yellow_redstone_torch_from_redstone_torch" | "quark:world/stonecutting/walls/shale_wall_stonecutter" | "chipped_express:stonecutting_chipped_angry_tuff_from_tuff" | "chipped_express:stonecutting_chipped_red_mushroom_trio_from_red_mushroom" | "pamhc2foodextended:potatocakesitem" | "farmersdelight:warped_cabinet" | "chipped_express:stonecutting_chipped_red_nether_bricks_pillar_top_from_red_nether_bricks" | "botania:dye_lime" | "botanypots:botanypots/crafting/white_terracotta_compact_hopper_botany_pot" | "quark:building/stonecutting/vertslabs/permafrost_bricks_vertical_slab_stonecutter" | "chipped_express:stonecutting_chipped_tiled_magenta_wool_from_magenta_wool" | "botanypots:farming_crossing/crop/pamhc2treesbanana_sapling" | "railways:mechanical_crafting/cyan_copper_wrapped_locometal_boiler" | "quark:building/crafting/bamboo_post" | "minecraft:light_blue_terracotta" | "create:cutting/compat/botania/glimmering_livingwood_log" | "chipped_express:stonecutting_chipped_ornate_cyan_stained_glass_from_cyan_stained_glass" | "minecraft:spruce_stairs" | "enderchests:ender_chest" | "chipped_express:stonecutting_chipped_vertical_cut_blue_ice_from_blue_ice" | "compressedblocks:shapeless_c5_sand" | "conditional:bloomingnature/wood_cutter/larch_button_woodcutter" | "create_confectionery:bar_of_caramel_recipe" | "compressedblocks:shapeless_c4_cut_copper" | "chipped_express:stonecutting_chipped_mangrove_tile_barrel_from_barrel" | "compressedblocks:shapeless_giga_crated_quartz" | "pamhc2crops:bakedtaroitem_smoker" | "framedblocks:framing_saw/framed_flat_stacked_slope_slab_corner" | "minecraft:light_gray_dye_from_white_tulip" | "mcwfurnitures:stripped_crimson_drawer" | "create:cutting/compat/blue_skies/bluebright_log" | "quark:building/stonecutting/stonevariants/chiseled_myalite_bricks_stonecutter" | "cosmeticarmoursmod:thighhigh_rec" | "compressedblocks:shapeless_c8_jungle_log" | "createdeco:yellow_placard" | "create:compat/byg/pressing/lush_grass_path" | "candlelight:oak_shelf" | "botanypots:pamhc2crops/crop/radish" | "botanypots:botanypots/crafting/pink_concrete_hopper_botany_pot" | "create:cutting/compat/quark/azalea_log" | "gemsnjewels:ornament_sable_amethyst_block" | "candlelight:gold_ring" | "compressedblocks:shapeless_quintuple_crated_salmon" | "mcwfences:spruce_picket_fence" | "mcwtrpdoors:mangrove_ranch_trapdoor" | "chipped_express:stonecutting_chipped_cracked_diorite_bricks_from_diorite" | "compressedblocks:shaped_mega_crated_acacia_sapling" | "compressedblocks:shapeless_c8_red_sandstone" | "mcwfurnitures:stripped_acacia_end_table" | "mcwfurnituresbop:mahogany_cupboard_counter" | "biomesoplenty:brimstone_brick_wall_from_brimstone_stonecutting" | "chipped_express:stonecutting_chipped_wickered_orange_carpet_from_orange_carpet" | "framedblocks:framed_flat_stacked_inner_slope_slab_corner_rotate_to_framed_flat_stacked_inner_slope_panel_corner" | "botania:mana_infusion/ice" | "compressedblocks:shaped_quintuple_crated_golden_carrot" | "mcwfurnitures:stripped_warped_modern_desk" | "create:copycat_panel_from_ingots_zinc_stonecutting" | "moa_decor_art:pinturagris_1" | "createdeco:long_pearl_brick_stairs_from_tiled_pearl_bricks_stonecutting" | "frozenup:truffle_cake" | "meadow:wooden_cauldron" | "chipped_express:stonecutting_chipped_oak_webbed_large_bookshelf_from_bookshelf" | "quark:building/stonecutting/stairs/yellow_shingles_stairs_stonecutter2" | "railways:crafting/palettes/dyeing_8x/blue_copper_wrapped_locometal_boiler" | "quark:building/stonecutter/vertslabs/deepslate_brick_vertical_slab_from_polished_deepslate" | "biomesoplenty:chiseled_brimstone_bricks_from_brimstone_stonecutting" | "compressedblocks:shapeless_triple_crated_totem_of_undying" | "mcwfences:deepslate_railing_gate_stonecutter" | "compressedblocks:shapeless_double_crated_end_rod" | "quark:tools/smithing/rune_smithing_yellow" | "railways:sequenced_assembly/track_twilightforest_sortingwood_narrow" | "luphieclutteredmod:purple_cabinet_recipe" | "chipped_express:stonecutting_chipped_enclosed_jungle_planks_from_jungle_planks" | "mcwbridges:stonecutter_nether_bricks_bridge_pier" | "mcwwindows:brown_mosaic_glass_pane" | "framedblocks:framed_half_pillar" | "compressedblocks:shaped_c1_iron_ore" | "compressedblocks:shapeless_c0_raw_copper_block" | "frozenup:mug_of_truffle_hot_chocolate_from_chocolate" | "minecraft:light_gray_carpet" | "compressedblocks:shapeless_double_crated_ink_sac" | "minecraft:smooth_sandstone" | "compressedblocks:shaped_mega_crated_rabbit_foot" | "chipped_express:stonecutting_chipped_unamused_cobblestone_from_cobblestone" | "mcwfurnitures:stripped_mangrove_large_drawer" | "compressedblocks:shaped_quadruple_crated_phantom_membrane" | "chipped_express:stonecutting_chipped_eroded_ice_from_ice" | "chipped_express:stonecutting_chipped_blank_crying_obsidian_carving_from_crying_obsidian" | "pamhc2foodextended:gooseberryjellysandwichitem" | "compressedblocks:shapeless_c0_sandstone" | "railways:stonecutting/palettes/cycling/white_locometal_pillar" | "pamhc2foodextended:applefritteritem" | "quark:building/crafting/vertplanks/vertical_birch_planks_revert" | "railways:crafting/palettes/dyeing_1x/magenta_iron_wrapped_locometal_boiler" | "chipped_express:stonecutting_chipped_leafy_dark_oak_trapdoor_from_dark_oak_trapdoor" | "createdeco:zinc_catwalk_stairs_from_stonecutting" | "pamhc2foodextended:lemonyogurtitem" | "chipped_express:stonecutting_chipped_railed_white_concrete_from_white_concrete" | "mcwdoors:dark_oak_barn_glass_door" | "botania:marimorphosis/metamorphic_forest_stone" | "minecraft:polished_blackstone_bricks" | "mcwfurnitures:mangrove_bookshelf_drawer" | "pamhc2foodextended:cheddarandsourcreampotatochipsitem" | "mcwdoors:oak_stable_head_door" | "chipped_express:stonecutting_chipped_circular_pink_stained_glass_pane_from_pink_stained_glass_pane" | "botania:unholy_cloak" | "create:small_granite_brick_stairs" | "chipped_express:stonecutting_chipped_reanimated_soul_sand_from_soul_sand" | "chipped_express:stonecutting_chipped_flat_mossy_stone_bricks_tiles_from_mossy_stone_bricks" | "refinedstorage:speed_upgrade" | "compressedblocks:shaped_c4_birch_planks" | "quark:building/crafting/vertslabs/brick_vertical_slab" | "corail_woodcutter:woodcutting/mangrove_button_from_mangrove_planks" | "quark:building/crafting/stripped_cherry_post" | "minecraft:deepslate_brick_wall" | "mcwroofs:bamboo_planks_top_roof" | "corail_woodcutter:woodcutting/dark_oak_button_from_dark_oak_logs" | "quark:world/crafting/woodsets/blossom/planks" | "handcrafted:stone_corner_trim" | "gemsnjewels:create/create_crushing_jade_deepslate_ore" | "compressedblocks:shaped_septuple_crated_chain" | "compressedblocks:shaped_quintuple_crated_wither_rose" | "create:small_ochrum_brick_stairs_from_stone_types_ochrum_stonecutting" | "snowyspirit:compressedblocks/sled_c3_acacia" | "cosmeticarmoursmod:white_sock_skirt_2_cyan" | "chipped_express:stonecutting_chipped_creeper_cyan_concrete_from_cyan_concrete" | "createdeco:mossy_dean_brick_stairs" | "compressedblocks:shaped_c7_bone_block" | "chipped_express:stonecutting_chipped_d_sign_stripped_crimson_stem_from_stripped_crimson_stem" | "quark:building/crafting/compressed/bonded_leather" | "moa_decor_art:aerosolblanco_1" | "sophisticatedstorage:spruce_barrel" | "moa_decor_bath:toallaciancolg_1" | "chipped_express:stonecutting_chipped_edge_cut_oak_log_from_oak_log" | "compressedblocks:shapeless_giga_crated_activator_rail" | "quark:building/crafting/walls/blue_nether_bricks_wall" | "mcwfences:modern_deepslate_wall" | "railways:sequenced_assembly/track_tfc_rosewood_narrow" | "compressedblocks:shaped_sextuple_crated_cyan_dye" | "pamhc2foodcore:macncheeseitem" | "farmersdelight:flint_knife" | "create_central_kitchen:emptying/dragon_breath_emptying" | "luphieclutteredmod:tarrey_town_cluttered_woodstove_recipe" | "compressedblocks:shapeless_c4_stripped_mangrove_log" | "mcwfurnitures:stripped_spruce_drawer" | "pamhc2foodextended:durianjellyitem" | "chipped_express:stonecutting_chipped_blocky_orange_wool_from_orange_wool" | "chipped_express:stonecutting_chipped_warty_nether_sprouts_from_nether_sprouts" | "mcwfurnitures:stripped_mangrove_bookshelf_drawer" | "create:cutting/compat/biomesoplenty/stripped_mahogany_wood" | "handcrafted:acacia_cupboard" | "compressedblocks:shapeless_c7_dirt" | "candlelight:jungle_table" | "macawsroofsbop:willow_lower_roof" | "chipped_express:stonecutting_chipped_vined_oak_trapdoor_from_oak_trapdoor" | "moa_decor_art:hilonaranja_1" | "create:milling/tall_grass" | "railways:crafting/palettes/dyeing_1x/purple_riveted_locometal" | "create_central_kitchen:crafting/dough_4" | "utilitix:redstone_lamp_revert" | "create_central_kitchen:crafting/dough_3" | "chipped_express:stonecutting_chipped_cubed_lime_carpet_from_lime_carpet" | "create_central_kitchen:crafting/dough_2" | "brewery:bar_counter" | "create_central_kitchen:crafting/dough_1" | "create:polished_cut_scorchia_slab_recycling" | "chipped_express:stonecutting_chipped_hewn_mangrove_planks_from_mangrove_planks" | "chipped_express:stonecutting_chipped_inlayed_bricks_from_bricks" | "chipped_express:stonecutting_chipped_inscribed_blue_terracotta_from_blue_terracotta" | "quark:building/crafting/vertslabs/brown_shingles_vertical_slab" | "chipped_express:stonecutting_chipped_tiny_layered_gilded_blackstone_slabs_from_gilded_blackstone" | "biomesoplenty:palm_trapdoor" | "createdeco:short_scarlet_brick_stairs_from_tiled_scarlet_brick_stairs_stonecutting" | "chipped_express:stonecutting_chipped_triangular_gray_terracotta_from_gray_terracotta" | "botania:petal_apothecary/nightshade_motif" | "moa_decor_science:biombomnaranja_1" | "chipped_express:stonecutting_chipped_fortified_warped_door_from_warped_door" | "pamhc2foodcore:friedeggitem" | "create:compat/druidcraft/crushing/amber_ore" | "createdeco:decal_fluid" | "bloomingnature:fir_slab" | "compressedblocks:shapeless_quintuple_crated_dragon_breath" | "minecraft:redstone_lamp" | "chipped_express:stonecutting_chipped_white_concrete_panel_from_white_concrete" | "mcwfurnitures:warped_lower_bookshelf_drawer" | "compressedblocks:shaped_c9_tuff" | "create:compat/byg/milling/purple_amaranth" | "alexsmobs:transmutation_table" | "minecraft:iron_ingot_from_blasting_iron_ore" | "compressedblocks:shapeless_quadruple_crated_anvil" | "mcwfurnitures:stripped_birch_large_drawer" | "chipped_express:stonecutting_chipped_smooth_inlayed_cobblestone_from_cobblestone" | "luphieclutteredmod:luphie_white_shelf_cabinet_recipe" | "framedblocks:framed_flat_stacked_slope_panel_corner" | "candlelight:deepslate_kitchen_sink" | "biomesoplenty:orange_sandstone" | "chipped_express:stonecutting_chipped_tiled_brown_carpet_from_brown_carpet" | "quark:tools/smithing/rune_smithing_gray" | "createdeco:magenta_placard" | "chipped_express:stonecutting_chipped_small_quartz_block_bricks_from_quartz_block" | "botania:spark_upgrade_dominant" | "mcwwindows:red_mosaic_glass" | "compressedblocks:shapeless_octuple_crated_glow_berries" | "mcwroofs:diorite_attic_roof" | "chipped_express:stonecutting_chipped_vertical_disordered_quartz_block_bricks_from_quartz_block" | "compressedblocks:shaped_crated_milk_bucket" | "mcwtrpdoors:print_bamboo" | "refinedstorage:security_manager" | "mcwfurnitures:stripped_acacia_double_wardrobe" | "compressedblocks:shaped_triple_crated_yellow_carpet" | "railways:stonecutting/palettes/cycling/white_riveted_locometal" | "create:scoria_pillar_from_stone_types_scoria_stonecutting" | "lootbags:rare_decorations/misc_completion" | "create:compat/botania/milling/orange_petal" | "vinery:dirt_slab" | "compressedblocks:shaped_triple_crated_cyan_carpet" | "chipped_express:stonecutting_chipped_pegged_yellow_concrete_from_yellow_concrete" | "chipped_express:stonecutting_chipped_massive_ice_bricks_from_ice" | "chipped_express:stonecutting_chipped_crimson_roots_bloom_from_crimson_roots" | "chipped_express:stonecutting_chipped_blank_ice_carving_from_ice" | "farmersdelight:cutting/wild_potatoes" | "pamhc2foodextended:lamingtonitem" | "chipped_express:stonecutting_chipped_cut_blank_lodestone_from_lodestone" | "createdeco:industrial_iron_bars_from_stonecutting" | "corail_woodcutter:woodcutting/biomesoplenty/mahogany_planks_from_mahogany_logs" | "createdeco:zinc_sheet_metal" | "chipped_express:stonecutting_chipped_ornate_purple_stained_glass_from_purple_stained_glass" | "mcwroofs:andesite_upper_steep_roof" | "framedblocks:framed_horizontal_pane" | "minecraft:red_sheet_from_red_dye" | "quark:building/stonecutting/stonevariants/calcite_bricks_vertical_slab_rough_stonecutting" | "minecraft:dark_oak_wood" | "handcrafted:mangrove_bench" | "quark:world/crafting/woodsets/ancient/stripped_wood" | "chipped_express:stonecutting_chipped_paved_gray_glazed_terracotta_from_gray_glazed_terracotta" | "botania:brew/emptiness" | "farmersdelight:cutting/birch_hanging_sign" | "botania:stonecutting/azulejo_6" | "botania:stonecutting/azulejo_5" | "createdeco:tiled_scarlet_brick_slab" | "botania:stonecutting/azulejo_8" | "createdeco:cracked_scarlet_bricks_from_scarlet_bricks_blasting" | "botania:stonecutting/azulejo_7" | "compressedblocks:shapeless_octuple_crated_magenta_carpet" | "botania:stonecutting/azulejo_9" | "compressedblocks:shaped_giga_crated_end_crystal" | "chipped_express:stonecutting_chipped_cut_purple_terracotta_from_purple_terracotta" | "pamhc2foodcore:sweetberrysmoothieitem" | "compressedblocks:shaped_septuple_crated_cod" | "createdeco:umber_brick_stairs_from_long_umber_bricks_stonecutting" | "farmersdelight:integration/create/milling/wild_potatoes" | "chipped_express:stonecutting_chipped_brick_bordered_gilded_blackstone_from_gilded_blackstone" | "compressedblocks:shaped_c2_obsidian" | "aquaculturedelight:cooking/buckling" | "railways:sequenced_assembly/track_cherry_wide" | "compressedblocks:shaped_septuple_crated_glass_bottle" | "compressedblocks:shapeless_giga_crated_cooked_rabbit" | "botania:stonecutting/azulejo_0" | "create:deploying/waxed_weathered_copper_shingle_stairs_from_adding_wax" | "botania:stonecutting/azulejo_2" | "chipped_express:stonecutting_chipped_stringed_yellow_wool_from_yellow_wool" | "botania:stonecutting/azulejo_1" | "create:crafting/materials/andesite_alloy_block" | "botania:stonecutting/azulejo_4" | "mcwlights:white_paper_lamp" | "botania:stonecutting/azulejo_3" | "chipped_express:stonecutting_chipped_tiny_brick_bordered_magma_block_from_magma_block" | "create:cutting/compat/architects_palette/stripped_twisted_log" | "compressedblocks:shapeless_mega_crated_bread" | "pamhc2foodextended:southernstylebreakfastitem" | "compressedblocks:shaped_crated_ender_eye" | "mcwwindows:mangrove_plank_pane_window" | "chipped_express:stonecutting_chipped_lush_red_sand_from_sand" | "compressedblocks:shaped_double_crated_spider_eye" | "supplementaries:sugar_cube_uncrafting" | "create:compat/byg/crushing/lignite_ore" | "chipped_express:stonecutting_chipped_massive_crying_obsidian_bricks_from_crying_obsidian" | "botania:dreamwood" | "compressedblocks:shaped_quadruple_crated_red_mushroom" | "bakery:baking_station/strawberry_cake" | "compressedblocks:shapeless_quadruple_crated_rabbit_hide" | "compressedblocks:shapeless_sextuple_crated_bread" | "chimes:iron_chimes" | "minecraft:birch_button" | "moa_decor_cookery:frascoazucar_1" | "luphieclutteredmod:luphie_jam_jar_pyramid_recipe" | "railways:sequenced_assembly/track_natures_spirit_maple_narrow" | "gemsnjewels:light_stone_tourmaline" | "mcwroofs:mud_brick_lower_roof" | "compressedblocks:shaped_double_crated_glass_bottle" | "compressedblocks:shapeless_c8_coal_ore" | "compressedblocks:shapeless_c9_stripped_acacia_log" | "chipped_express:stonecutting_chipped_spider_dark_prismarine_carving_from_dark_prismarine" | "mcwtrpdoors:crimson_bamboo_trapdoor" | "botania:pink_floating_flower" | "chipped_express:stonecutting_chipped_rectangle_green_carpet_from_green_carpet" | "minecraft:weathered_cut_copper_stairs_from_weathered_copper_stonecutting" | "quark:building/crafting/chests/mangrove_chest" | "chipped_express:stonecutting_chipped_small_light_blue_stained_glass_pane_from_light_blue_stained_glass_pane" | "delightful:knives/smelting/bone/bone_meal_from_smelting_hoe" | "createdeco:green_andesite_lamp" | "mcwfences:prismarine_grass_topped_wall" | "chipped_express:stonecutting_chipped_bundled_yellow_wool_from_yellow_wool" | "quark:building/crafting/stairs/lime_shingles_stairs" | "conditional:regions_unexplored/wood_cutter/brimwood_fence_woodcutter" | "mcwfurnitures:stripped_mangrove_double_wardrobe" | "compressedblocks:shaped_c0_waxed_exposed_copper" | "corail_woodcutter:woodcutting/birch_trapdoor_from_birch_logs" | "corail_woodcutter:woodcutting/mangrove_stairs_from_mangrove_logs" | "create:crafting/kinetics/white_valve_handle_from_other_valve_handle" | "chipped_express:stonecutting_chipped_unamused_obsidian_from_obsidian" | "pamhc2foodextended:huckleberrysmoothieitem" | "beachparty:tiki_bar_mixing/coconut_cocktail" | "pamhc2trees:roastedacornitem_smoker" | "compressedblocks:shapeless_triple_crated_lilac" | "mcwroofs:warped_steep_roof" | "botania:stonecutting/metamorphic_swamp_stone_to_chiseled_metamorphic_swamp_bricks" | "railways:sequenced_assembly/track_tfc_blackwood" | "compressedblocks:shapeless_quintuple_crated_purple_carpet" | "compressedblocks:shapeless_c6_jungle_log" | "quark:building/stonecutting/slabs/green_shingles_slab_stonecutter" | "compressedblocks:shaped_c0_granite" | "railways:crafting/palettes/dyeing_8x/purple_brass_wrapped_locometal" | "chipped_express:stonecutting_chipped_fancy_dark_oak_trapdoor_from_dark_oak_trapdoor" | "moa_decor_toys:burro_1" | "chipped_express:stonecutting_chipped_smooth_obsidian_column_from_obsidian" | "refinedstorage:coloring_recipes/light_gray_relay" | "macawsroofsbop:hellbark_lower_roof" | "compressedblocks:shapeless_triple_crated_dark_oak_sapling" | "railways:crafting/palettes/dyeing_1x/light_gray_copper_wrapped_locometal" | "createdeco:gold_coinstack" | "cosmeticarmoursmod:white_bunny_tail_rec" | "mcwwindows:stripped_cherry_log_four_window" | "mcwdoors:cherry_cottage_door" | "createdeco:long_blue_brick_slab_from_tiled_blue_brick_slab_stonecutting" | "compressedblocks:shapeless_c9_copper_block" | "chipped_express:stonecutting_chipped_golden_apple_jungle_leaves_from_jungle_leaves" | "chipped_express:stonecutting_chipped_ribbled_gray_wool_from_gray_wool" | "quark:building/stonecutting/stonevariants/dripstone_bricks_polished_stonecutting" | "compressedblocks:shaped_double_crated_gunpowder" | "supplementaries:wind_vane" | "mcwroofs:blue_terracotta_upper_lower_roof" | "chipped_express:stonecutting_chipped_cobbled_redstone_block_from_redstone_block" | "railways:crafting/palettes/dyeing_1x/blue_locometal_pillar" | "chipped_express:stonecutting_chipped_trodden_smooth_stone_from_smooth_stone" | "corail_woodcutter:woodcutting/warped_slab_from_warped_stems" | "compressedblocks:shapeless_c2_exposed_cut_copper" | "cosmeticarmoursmod:white_skirt_2_blue" | "mcwwindows:mud_brick_arrow_slit" | "compressedblocks:shapeless_giga_crated_honey_bottle" | "utilitix:utilitix_brewery/merge" | "vinery:window" | "railways:stonecutting/palettes/cycling/cyan_locometal_pillar" | "chipped_express:stonecutting_chipped_reinforced_stripped_crimson_stem_from_stripped_crimson_stem" | "macawsroofsbop:dead_top_roof" | "corail_woodcutter:woodcutting/tropicraft/mangrove_slab_from_mangrove_planks" | "mcwfences:sandstone_railing_gate_stonecutter" | "pamhc2foodextended:chickencurryitem" | "libraryferret:blasting/gold_coins_jtl" | "handcrafted:cherry_cupboard" | "mcwfurnitures:stripped_warped_bookshelf_cupboard" | "create:compat/silentsgems/crushing/malachite_ore" | "moa_decor_cookery:sopahongos_1" | "mcwbridges:diorite_bridge_pier" | "chipped_express:stonecutting_chipped_hazard_brown_concrete_from_brown_concrete" | "chipped_express:stonecutting_chipped_starry_magenta_glazed_terracotta_from_magenta_glazed_terracotta" | "create:deploying/waxed_weathered_copper_tile_slab_from_adding_wax" | "pamhc2foodextended:baconwrappedchiliitem" | "railways:stonecutting/palettes/cycling/light_blue_locometal_smokebox" | "compressedblocks:shapeless_crated_charcoal" | "meadow:wood_cutter/pine/pine_slabs_woodcutter" | "botanypots:minecraft/soil/warped_nylium" | "chipped_express:stonecutting_chipped_stacked_smooth_stone_bricks_from_smooth_stone" | "exoticbirds:cyan_birdhouse" | "create:crafting/kinetics/smart_chute" | "minecraft:brown_dye" | "mcwtrpdoors:acacia_mystic_trapdoor" | "beachparty:palm_trapdoor" | "compressedblocks:shapeless_c0_exposed_copper" | "minecraft:brick_slab" | "railways:crafting/palettes/dyeing_8x/orange_plated_locometal" | "botanypots:botania/crop/brown_mystical_flower" | "railways:conductor_vent_from_industrial_iron_block_stonecutting" | "chipped_express:stonecutting_chipped_small_red_sandstone_bricks_from_red_sandstone" | "compressedblocks:shaped_septuple_crated_beetroot" | "chipped_express:stonecutting_chipped_tiny_layered_bricks_bricks_from_bricks" | "minecraft:red_sandstone_slab" | "bloomingnature:ebony_chest_boat" | "chipped_express:stonecutting_chipped_tripped_yellow_wool_from_yellow_wool" | "quark:world/crafting/panes/blue_corundum" | "handcrafted:cherry_shelf" | "compressedblocks:shaped_quintuple_crated_apple" | "quark:building/stonecutting/vertslabs/shale_vertical_slab_stonecutter" | "compressedblocks:shapeless_double_crated_lead" | "create:polished_cut_diorite_stairs_from_stone_types_diorite_stonecutting" | "sophisticatedbackpacks:auto_smoking_upgrade_from_auto_smelting_upgrade" | "chipped_express:stonecutting_chipped_tiled_raw_gold_block_column_from_raw_gold_block" | "pamhc2crops:zucchiniseeditem" | "compressedblocks:shapeless_quadruple_crated_cooked_rabbit" | "chipped_express:stonecutting_chipped_boxed_birch_planks_from_birch_planks" | "botanypots:minecraft/soil/birch_wood" | "compressedblocks:shaped_giga_crated_glow_item_frame" | "chipped_express:stonecutting_chipped_sunny_melon_from_melon" | "snowyspirit:compressedblocks/sled_c4_jungle" | "farmersdelight:cutting/cherry_wood" | "alexsdelight:smelting/bunfungus_smoke_drumstick" | "moa_decor_holidays:calabaza_warden_l_1" | "pamhc2foodextended:sesamesnapsitem" | "chipped_express:stonecutting_chipped_warning_black_concrete_from_black_concrete" | "chipped_express:stonecutting_chipped_ornate_brown_stained_glass_pane_from_brown_stained_glass_pane" | "luphieclutteredmod:stripped_yellow_log_recipe" | "farmersdelight:honey_glazed_ham_block" | "mcwwindows:prismarine_window2" | "chipped_express:stonecutting_chipped_fine_coal_block_pillar_from_coal_block" | "moa_decor_garden_:maceta_trosal_1" | "cosmeticarmoursmod:royal_tunic_white_2_lime" | "compressedblocks:shaped_c9_nether_quartz_ore" | "pamhc2foodextended:gooseberryyogurtitem" | "botania:stonecutting/metamorphic_plains_stone_to_metamorphic_plains_bricks" | "refinedstorage:coloring_recipes/green_detector" | "chipped_express:stonecutting_chipped_solid_crimson_trapdoor_from_crimson_trapdoor" | "quark:world/crafting/slabs/limestone_slab" | "compressedblocks:shaped_c3_oxidized_cut_copper" | "mcwwindows:acacia_four_window" | "compressedblocks:shaped_octuple_crated_experience_bottle" | "moa_decor_garden_:cerezo_1" | "botania:fertilizer_dye" | "chipped_express:stonecutting_chipped_brick_bordered_end_stone_from_end_stone" | "compressedblocks:shapeless_septuple_crated_rabbit" | "mcwdoors:bamboo_nether_door" | "compressedblocks:shapeless_septuple_crated_experience_bottle" | "botania:petal_light_blue" | "pamhc2crops:sorghumseeditem" | "nethersdelight:cutting/strider_slice" | "botania:mana_infusion/potato_to_carrot" | "biomesoplenty:hellbark_slab" | "botania:stonecutting/red_pavement_to_red_pavement_stairs" | "chipped_express:stonecutting_chipped_layed_cobblestone_bricks_from_cobblestone" | "chipped_express:stonecutting_chipped_cut_lapis_block_column_from_lapis_block" | "railways:sequenced_assembly/track_byg_skyris_narrow" | "handcrafted:cherry_pillar_trim" | "mcwfurnitures:warped_bookshelf_cupboard" | "moa_decor_science:tuboensayomorado_1" | "moa_decor_art:guitarraelectricaverde_1" | "quark:mobs/smelting/cooked_crab_leg" | "farmersdelight:integration/immersiveengineering/squeezer/tomato_seeds" | "mcwdoors:birch_stable_door" | "framedblocks:framed_double_threeway_corner_pillar" | "compressedblocks:shaped_crated_cooked_porkchop" | "create:cut_deepslate_brick_stairs" | "bloomingnature:aspen_sign" | "minecraft:red_nether_brick_wall" | "create:small_crimsite_brick_stairs" | "biomesoplenty:magic_pressure_plate" | "chipped_express:stonecutting_chipped_white_terracotta_tiles_from_white_terracotta" | "botanypots:botanypots/crafting/pink_concrete_botany_pot" | "corail_woodcutter:woodcutting/birch_planks_from_birch_logs" | "compressedblocks:shaped_giga_crated_cobweb" | "compressedblocks:shaped_septuple_crated_poisonous_potato" | "create:cutting/compat/biomesoplenty/mahogany_wood" | "mcwfurnitures:stripped_oak_table" | "botanypots:botania/crop/cyan_mushroom" | "minecraft:light_gray_candle" | "mcwbridges:stonecutter_balustrade_prismarine_bricks_bridge" | "compressedblocks:shaped_sextuple_crated_magenta_dye" | "luphieclutteredmod:purple_wood_recipe" | "naturalist:cooked_egg_from_campfire_cooking" | "gemsnjewels:create/create_crushing_dusk_emerald_ore" | "chipped_express:stonecutting_chipped_button_warped_fungus_from_warped_fungus" | "farmersdelight:cooking/tomato_sauce" | "farmersdelight:fruit_salad" | "compressedblocks:shaped_quadruple_crated_charcoal" | "supplementaries:soap/map" | "chipped_express:stonecutting_chipped_weathered_sandstone_from_sandstone" | "utilitix:cherry_shulker_boat_with_shell" | "quark:building/crafting/stripped_azalea_post" | "compressedblocks:shapeless_quadruple_crated_white_carpet" | "compressedblocks:shaped_c2_netherite_block" | "compressedblocks:shapeless_quadruple_crated_mutton" | "chipped_express:stonecutting_chipped_pegged_acacia_planks_from_acacia_planks" | "compressedblocks:shapeless_c8_weathered_copper" | "botania:bellows" | "create:weathered_copper_tile_slab" | "mcwroofs:magenta_terracotta_upper_lower_roof" | "railways:sequenced_assembly/track_tfc_sequoia" | "compressedblocks:shapeless_octuple_crated_cherry_sapling" | "mcwdoors:spruce_tropical_door" | "aquaculture:gold_nugget_from_gold_fish" | "create:crushing/raw_silver_ore" | "minecraft:diamond_hoe" | "farmersdelight:tomato_seeds" | "botanypots:minecraft/crop/beetroot" | "compressedblocks:shapeless_c3_cut_sandstone" | "compressedblocks:shaped_giga_crated_rabbit_hide" | "create:compat/silentsgems/crushing/tanzanite_ore" | "chipped_express:stonecutting_chipped_harsh_quilted_brown_wool_from_brown_wool" | "chipped_express:stonecutting_chipped_shroomy_nether_sprouts_from_nether_sprouts" | "farmersdelight:cutting/allium" | "compressedblocks:shapeless_sextuple_crated_salmon" | "railways:stonecutting/palettes/cycling/pink_slashed_locometal" | "compressedblocks:shapeless_triple_crated_salmon" | "ecologics:cutting/coconut_wood" | "create:cutting/compat/tconstruct/stripped_bloodshroom_wood" | "createdeco:long_verdant_brick_slab_from_verdant_bricks_stonecutting" | "compressedblocks:shapeless_octuple_crated_cooked_beef" | "create:cutting/compat/silentgear/netherwood_log" | "chipped_express:stonecutting_chipped_dark_spotted_red_mushroom_block_from_red_mushroom_block" | "chipped_express:stonecutting_chipped_inscribed_calcite_from_calcite" | "railways:crafting/palettes/dyeing_1x/orange_brass_wrapped_locometal" | "cosmeticarmoursmod:winter_survivalist_boots_brown" | "chipped_express:stonecutting_chipped_knotted_stripped_birch_log_from_stripped_birch_log" | "mcwbridges:balustrade_granite_bridge" | "compressedblocks:shapeless_c4_tuff" | "vinery:dark_oak_lattice" | "compressedblocks:shaped_septuple_crated_fire_charge" | "conditional:regions_unexplored/wood_cutter/brimwood_slabs_woodcutter" | "pamhc2foodextended:elderberrypieitem" | "compressedblocks:shapeless_c1_dirt" | "snowyspirit:gumdrop_gray" | "chipped_express:stonecutting_chipped_chiseled_packed_mud_from_packed_mud" | "create:polished_cut_ochrum_stairs" | "meadow:cobbled_limestone_stairs_from_cobbled_limestone_stonecutting" | "refinedstorage:coloring_recipes/cyan_disk_manipulator" | "alexsmobs:kangaroo_hide_to_leather" | "quark:building/stonecutting/stonevariants/shale_bricks_stairs_polished_stonecutting" | "compressedblocks:shaped_crated_rabbit_foot" | "create:smelting/ingot_aluminum_compat_immersiveengineering" | "chipped_express:stonecutting_chipped_tiled_red_sandstone_column_from_red_sandstone" | "mcwfurnituresbop:willow_chair" | "chipped_express:stonecutting_chipped_cracked_disordered_dark_prismarine_bricks_from_dark_prismarine" | "chipped_express:stonecutting_chipped_tiny_red_nether_bricks_bricks_from_red_nether_bricks" | "chipped_express:stonecutting_chipped_glass_warped_door_from_warped_door" | "create:cutting/compat/byg/stripped_witch_hazel_wood" | "compressedblocks:shaped_double_crated_purple_dye" | "minecraft:furnace" | "mcwroofs:nether_bricks_attic_roof" | "quark:building/crafting/slabs/raw_gold_bricks_slab" | "delightful:food/cooking/ender_nectar" | "pamhc2foodextended:greengrapejellytoastitem" | "quark:building/crafting/vertslabs/white_shingles_vertical_slab_revert" | "quark:oddities/crafting/backpack_no_hide" | "chipped_express:stonecutting_chipped_paved_cyan_glazed_terracotta_from_cyan_glazed_terracotta" | "botania:mana_infusion/red_quartz_deconstruct" | "mcwfences:modern_quartz_wall_stonecutter" | "chipped:botanist_workbench" | "compressedblocks:shapeless_c4_mud" | "chipped_express:stonecutting_chipped_smoothed_double_inlayed_deepslate_from_deepslate" | "bloomingnature:fir_fence_gate" | "mcwfurnitures:stripped_oak_lower_bookshelf_drawer" | "pamhc2foodextended:bbqchickenpizzaitem" | "mcwfurnituresbop:fir_glass_table" | "createdeco:cracked_umber_brick_stairs" | "quark:building/stonecutting/stonevariants/granite_pillar_stonecutter" | "handcrafted:deepslate_pillar_trim" | "chipped_express:stonecutting_chipped_unamused_end_stone_from_end_stone" | "quark:tweaks/crafting/utility/wool/green_wool" | "mcwbridges:balustrade_stone_bricks_bridge" | "chipped_express:stonecutting_chipped_massive_redstone_block_bricks_from_redstone_block" | "pamhc2foodextended:teriyakichickenitem" | "bakery:kitchen_sink" | "botania:mana_infusion/birch_sapling_to_jungle_sapling" | "luphieclutteredmod:luphie_steampunk_globe_recipe" | "moa_decor_holidays:globos_cafe_1" | "createaddition:compat/tconstruct/slimesteel" | "chipped_express:stonecutting_chipped_bricky_acacia_planks_from_acacia_planks" | "botanypots:farmersdelight/crop/wild_potato" | "quark:building/crafting/stairs/light_blue_shingles_stairs" | "candlelight:mangrove_table" | "moa_decor_art:guitarraelectricagrisclara_1" | "handcrafted:crimson_pillar_trim" | "compressedblocks:shaped_c4_oxidized_copper" | "compressedblocks:shapeless_triple_crated_porkchop" | "luphieclutteredmod:checkered_wallpaper_lime_recipe" | "chipped_express:stonecutting_chipped_tiled_mossy_stone_bricks_column_from_mossy_stone_bricks" | "createdeco:tiled_umber_brick_slab_from_short_umber_bricks_stonecutting" | "chipped_express:stonecutting_chipped_tuff_pillar_from_tuff" | "compressedblocks:shapeless_c6_dark_oak_planks" | "chipped_express:stonecutting_chipped_firewood_warped_stem_from_warped_stem" | "createdeco:mossy_pearl_brick_stairs_from_mossy_pearl_bricks_stonecutting" | "compressedblocks:shaped_triple_crated_cornflower" | "chipped_express:stonecutting_chipped_woven_crimson_trapdoor_from_crimson_trapdoor" | "luphieclutteredmod:darkwood_endtable_recipe" | "compressedblocks:shaped_quadruple_crated_activator_rail" | "chipped_express:stonecutting_chipped_spider_ancient_debris_carving_from_ancient_debris" | "createdeco:long_umber_brick_stairs_from_short_umber_bricks_stonecutting" | "macawsroofsbop:mahogany_planks_upper_steep_roof" | "compressedblocks:shaped_quadruple_crated_ink_sac" | "chipped_express:stonecutting_chipped_crimson_roots_bramble_from_crimson_roots" | "chipped_express:stonecutting_chipped_massive_lapis_block_bricks_from_lapis_block" | "compressedblocks:shaped_giga_crated_black_dye" | "chipped_express:stonecutting_chipped_weathered_bricks_from_bricks" | "create:compat/thermal/crushing/niter_ore" | "playdate:toy_clock" | "chipped_express:stonecutting_chipped_small_yellow_stained_glass_pane_from_yellow_stained_glass_pane" | "chipped_express:stonecutting_chipped_cut_blank_blue_ice_from_blue_ice" | "compressedblocks:shapeless_septuple_crated_black_dye" | "create:cutting/compat/twilightforest/dark_wood" | "compressedblocks:shaped_mega_crated_black_carpet" | "minecraft:birch_boat" | "compressedblocks:shaped_quintuple_crated_light_gray_dye" | "snowyspirit:bloomingnature/sled_larch" | "handcrafted:gray_sheet" | "compressedblocks:shapeless_c2_exposed_copper" | "compressedblocks:shaped_c9_cherry_log" | "chipped_express:stonecutting_chipped_ornate_orange_stained_glass_from_orange_stained_glass" | "cosmeticarmoursmod:black_cat_ears_rec" | "mcwfences:modern_end_brick_wall" | "railways:crafting/palettes/dyeing_1x/light_blue_copper_wrapped_locometal_boiler" | "mcwdoors:mangrove_bark_glass_door" | "compressedblocks:shaped_crated_campfire" | "compressedblocks:shapeless_c1_coal_block" | "exoticbirds:warped_birdcage" | "compressedblocks:shaped_giga_crated_magenta_dye" | "minecraft:netherite_helmet_smithing" | "supplementaries:soap/dirty_glass" | "chipped_express:stonecutting_chipped_dead_birch_leaves_from_birch_leaves" | "create:cutting/compat/byg/stripped_cika_wood" | "mcwroofs:gray_terracotta_top_roof" | "pamhc2crops:roastedkohlrabiitem_campfire" | "create:cutting/compat/blue_skies/lunar_wood" | "moa_decor_bath:esp_dder_1" | "mcwroofs:magenta_concrete_top_roof" | "beautify:candelabra_blue" | "quark:building/crafting/shingles/green_shingles_dye" | "moa_decor_science:barriltoxico_3" | "compressedblocks:shapeless_crated_cooked_chicken" | "moa_decor_science:barriltoxico_1" | "cosmeticarmoursmod:green_sock_skirt_2_plaid" | "moa_decor_science:barriltoxico_2" | "minecraft:stripped_dark_oak_wood" | "compressedblocks:shaped_quadruple_crated_honey_bottle" | "exoticbirds:light_blue_birdhouse" | "compressedblocks:shapeless_quadruple_crated_glistering_melon_slice" | "compressedblocks:shaped_c5_oxidized_cut_copper" | "createdeco:andesite_support" | "mcwroofs:sandstone_upper_lower_roof" | "chipped_express:stonecutting_chipped_glad_raw_iron_block_from_raw_iron_block" | "botania:livingrock_stairs" | "create:crafting/kinetics/brass_door" | "cosmeticarmoursmod:black_skirt_2_plaid" | "farmersdelight:cooking_pot" | "create:crafting/materials/zinc_ingot_from_compacting" | "quark:building/crafting/glass/black_framed_glass" | "meadow:cobbled_limestone_wall_from_cobbled_limestone_stonecutting" | "create:compat/botania/milling/gray_petal" | "chipped_express:stonecutting_chipped_circular_red_terracotta_from_red_terracotta" | "chipped_express:stonecutting_chipped_cubed_oak_spaced_bookshelf_from_bookshelf" | "createdeco:decal_top_left" | "createdeco:tiled_dean_brick_stairs_from_tiled_dean_bricks_stonecutting" | "corail_woodcutter:biomesoplenty/magic_woodcutter" | "aquaculturedelight:cooking/jellyfish_jelly" | "botania:framed_livingwood" | "luphieclutteredmod:luphie_light_green_outer_corner_cabinet_recipe" | "domesticationinnovation:pet_bed_purple" | "compressedblocks:shaped_c1_gold_ore" | "compressedblocks:shaped_double_crated_honey_bottle" | "chipped_express:stonecutting_chipped_dark_oak_torch_from_torch" | "snowyspirit:compressedblocks/sled_c8_spruce" | "compressedblocks:shaped_giga_crated_blaze_powder" | "create:crafting/kinetics/green_valve_handle_from_other_valve_handle" | "create:cutting/compat/ars_nouveau/blue_archwood_log" | "cosmeticarmoursmod:white_sock_plaid_2_light_blue" | "railways:crafting/palettes/dyeing_8x/lime_flat_slashed_locometal" | "cosmeticarmoursmod:white_top_2_light_blue" | "compressedblocks:shapeless_octuple_crated_detector_rail" | "chipped_express:stonecutting_chipped_hazard_white_concrete_from_white_concrete" | "botania:mana_infusion/cactus_to_slime" | "bloomingnature:dye_white_from_mountain_laurel" | "botania:dye_yellow" | "createdeco:short_dean_brick_stairs_from_dean_brick_stairs_stonecutting" | "supplementaries:compressedblocks/sign_post_c8_jungle" | "framedblocks:framed_flat_stacked_inner_slope_panel_corner" | "compressedblocks:shapeless_sextuple_crated_honeycomb" | "luphieclutteredmod:stripped_flowering_pink_log_recipe" | "handcrafted:cherry_nightstand" | "immersive_aircraft:engine" | "framedblocks:framed_large_double_corner_slope_panel" | "pamhc2foodcore:glowberrysmoothieitem" | "chipped_express:stonecutting_chipped_smooth_inlayed_mossy_cobblestone_from_mossy_cobblestone" | "chipped_express:stonecutting_chipped_netherite_block_panels_from_netherite_block" | "mcwbridges:granite_bridge_stair_recycle" | "pamhc2foodcore:sunflowerseedsitem" | "compressedblocks:shapeless_sextuple_crated_orange_carpet" | "railways:crafting/palettes/dyeing_8x/brown_locometal_pillar" | "chipped_express:stonecutting_chipped_cut_blank_mossy_cobblestone_from_mossy_cobblestone" | "nethersdelight:blackstone_furnace" | "framedblocks:framing_saw/framed_inv_double_corner_slope_panel" | "minecraft:polished_granite_from_granite_stonecutting" | "chipped_express:stonecutting_chipped_rough_crimson_dried_kelp_block_from_dried_kelp_block" | "compressedblocks:shapeless_c2_lapis_ore" | "chipped_express:stonecutting_chipped_mini_tiled_packed_mud_from_packed_mud" | "createdeco:mossy_red_brick_stairs" | "chipped_express:stonecutting_chipped_bundled_light_gray_wool_from_light_gray_wool" | "lootbags:common_decorations/animal_crossing_completion" | "mcwroofs:crimson_planks_lower_roof" | "delightful:knives/smelting/copper_thermal" | "mcwfurnitures:stripped_jungle_counter" | "create:mechanical_crafting/extendo_grip" | "compressedblocks:shaped_septuple_crated_cooked_salmon" | "chipped_express:stonecutting_chipped_offset_smooth_stone_bricks_from_smooth_stone" | "botania:mana_infusion/mana_powder_dust" | "mcwwindows:andesite_louvered_shutter" | "quark:building/crafting/dark_oak_post" | "supplementaries:biomesoplenty/sign_post_magic" | "botania:stonecutting/mossy_livingrock_bricks_to_mossy_livingrock_bricks_stairs" | "moa_decor_bath:toallagriscolg_1" | "railways:crafting/palettes/wrapping/orange_iron_wrapped_locometal" | "minecraft:bamboo_planks" | "compressedblocks:shaped_giga_crated_firework_star" | "beachparty:bikini" | "sophisticatedstorage:crimson_chest_from_quark_crimson_chest" | "pamhc2foodextended:chickenandwafflesitem" | "chipped_express:stonecutting_chipped_layed_tuff_bricks_from_tuff" | "create:cutting/compat/byg/jacaranda_wood" | "delightful:food/cheeseburger_from_milk" | "compressedblocks:shaped_sextuple_crated_ink_sac" | "moa_decor_lights:lm_gmagenta_1" | "compressedblocks:shapeless_crated_nether_star" | "chipped_express:stonecutting_chipped_tiled_bamboo_planks_from_bamboo_planks" | "moa_decor_science:pizarramatematicas_1" | "railways:sequenced_assembly/track_tfc_sequoia_narrow" | "moa_decor_science:pizarramatematicas_2" | "moa_decor_garden_:bancajungla_1" | "cosmeticarmoursmod:royal_tunic_black_2_white" | "mcwwindows:crimson_louvered_shutter" | "moa_decor_cookery:estufapay_1" | "chipped_express:stonecutting_chipped_tiny_brick_bordered_end_stone_from_end_stone" | "quark:building/crafting/compressed/carrot_crate_uncompress" | "pamhc2foodextended:dragonfruitjuiceitem" | "delightful:knives/blasting/steel_immersiveengineering" | "moa_decor_holidays:globos_gris_claro_1" | "compressedblocks:shaped_c7_exposed_copper" | "compressedblocks:shaped_quintuple_crated_baked_potato" | "minecraft:coal_from_blasting_coal_ore" | "pamhc2foodextended:californiarollitem" | "mcwtrpdoors:birch_cottage_trapdoor" | "chipped_express:stonecutting_chipped_simple_crying_obsidian_pillar_from_crying_obsidian" | "mcwbridges:crimson_rail_bridge" | "quark:building/crafting/slabs/netherrack_bricks_slab" | "supplementaries:gold_gate" | "handcrafted:acacia_bench" | "biomesoplenty:redwood_wood" | "compressedblocks:shapeless_septuple_crated_phantom_membrane" | "mcwroofs:spruce_roof" | "corail_woodcutter:woodcutting/cherry_trapdoor_from_cherry_logs" | "railways:stonecutting/palettes/cycling/pink_flat_slashed_locometal" | "create:cutting/compat/byg/cika_log" | "mcwbridges:stonecutter_diorite_bridge_stair" | "quark:building/crafting/sturdy_stone_cyclic" | "chipped_express:stonecutting_chipped_soft_cyan_carpet_from_cyan_carpet" | "farmersdelight:cutting/spruce_wood" | "create:crafting/logistics/powered_latch" | "compressedblocks:shaped_c7_soul_soil" | "railways:crafting/palettes/wrapping/red_copper_wrapped_locometal" | "supplementaries:bloomingnature/sign_post_fir" | "chipped_express:stonecutting_chipped_eroded_raw_gold_block_from_raw_gold_block" | "cosmeticarmoursmod:cyan_sock_plaid_2_white" | "minecraft:warped_hanging_sign" | "botania:metamorphic_forest_bricks_stairs" | "quark:building/crafting/sakura_paper_lantern" | "minecraft:cracked_deepslate_bricks" | "mcwdoors:mangrove_modern_door" | "brewery:dumplings_from_campfire_cooking" | "railways:crafting/palettes/dyeing_1x/white_riveted_locometal" | "compressedblocks:shaped_crated_golden_apple" | "pamhc2foodextended:spicygreensitem" | "pamhc2foodextended:earlgreyteaitem" | "chipped_express:stonecutting_chipped_waved_blue_glazed_terracotta_from_blue_glazed_terracotta" | "create:crafting/materials/andesite_alloy_from_block" | "compressedblocks:shapeless_c2_stripped_cherry_log" | "pamhc2trees:roastedchestnutitem_smoker" | "createdeco:short_scarlet_brick_stairs" | "mcwdoors:mangrove_paper_door" | "moa_decor_garden_:sombrillacafe_1" | "pamhc2foodextended:steaktartareitem" | "railways:crafting/palettes/dyeing_8x/red_brass_wrapped_locometal" | "create:crafting/materials/raw_zinc_block" | "conditional:bloomingnature/wood_cutter/chestnut_slabs_woodcutter" | "create:cutting/andesite_alloy" | "farmersdelight:light_blue_canvas_sign" | "delightful:knives/blasting/bone/bone_meal_from_blasting_helmet" | "meadow:wood_cutter/warped/warped_button_woodcutter" | "compressedblocks:shapeless_septuple_crated_beef" | "compressedblocks:shaped_sextuple_crated_red_tulip" | "pamhc2crops:garlicseeditem" | "compressedblocks:shapeless_quadruple_crated_activator_rail" | "mcwfences:deepslate_pillar_wall" | "moa_decor_cookery:barrilzanahoria_1" | "meadow:pine_hanging_sign" | "create:crafting/kinetics/sticker" | "corail_woodcutter:woodcutting/spruce_sign_from_spruce_logs" | "pamhc2foodextended:paradiseburgeritem" | "minecraft:red_candle" | "compressedblocks:shapeless_giga_crated_light_blue_dye" | "corail_woodcutter:woodcutting/biomesoplenty/willow_pressure_plate_from_willow_logs" | "conditional:bloomingnature/wood_cutter/larch_trapdoor_woodcutter" | "chipped_express:stonecutting_chipped_tile_windowed_crimson_door_from_crimson_door" | "quark:building/crafting/vertslabs/acacia_vertical_slab" | "corail_woodcutter:woodcutting/crimson_button_from_crimson_stems" | "minecraft:brown_carpet" | "chipped_express:stonecutting_chipped_woven_red_stained_glass_pane_from_red_stained_glass_pane" | "handcrafted:green_sheet" | "railways:crafting/palettes/dyeing_8x/pink_flat_riveted_locometal" | "compressedblocks:shaped_octuple_crated_purple_dye" | "chipped_express:stonecutting_chipped_fancy_leaded_glass_from_glass" | "minecraft:crimson_fence" | "compressedblocks:shapeless_octuple_crated_cooked_salmon" | "compressedblocks:shaped_quintuple_crated_gray_dye" | "botanypots:pamhc2crops/crop/kohlrabi" | "quark:tools/crafting/pickarang_no_heart" | "compressedblocks:shaped_septuple_crated_sculk_vein" | "mcwbridges:rope_oak_bridge" | "createdeco:long_pearl_brick_stairs_from_long_pearl_bricks_stonecutting" | "chipped_express:stonecutting_chipped_stringed_lime_carpet_from_lime_carpet" | "botania:divining_rod" | "compressedblocks:shaped_sextuple_crated_cherry_sapling" | "compressedblocks:shapeless_quintuple_crated_yellow_carpet" | "minecraft:light_gray_stained_glass" | "compressedblocks:shapeless_septuple_crated_cooked_chicken" | "mcwwindows:yellow_mosaic_glass_pane" | "sophisticatedbackpacks:backpack_dye" | "corail_woodcutter:woodcutting/biomesoplenty/redwood_door_from_redwood_logs" | "pamhc2foodextended:lambwithmintsauceitem" | "luphieclutteredmod:luphie_light_green_inner_corner_counter_recipe" | "compressedblocks:shapeless_c0_waxed_exposed_cut_copper" | "chipped_express:stonecutting_chipped_shack_birch_door_from_birch_door" | "cratedelight:minecraft/crafting/apple_crate" | "minecraft:decorated_pot_simple" | "chipped_express:stonecutting_chipped_small_black_stained_glass_from_black_stained_glass" | "botanypots:farming_crossing/crop/pamhc2treeschestnut_sapling" | "compressedblocks:shapeless_quadruple_crated_blue_dye" | "cosmeticarmoursmod:crown_rec" | "chipped_express:stonecutting_chipped_layed_quartz_block_bricks_from_quartz_block" | "compressedblocks:shapeless_c5_mangrove_log" | "chipped_express:stonecutting_chipped_tiny_layered_purpur_block_bricks_from_purpur_block" | "chipped_express:stonecutting_chipped_fortified_cherry_door_from_cherry_door" | "refinedstorage:coloring_recipes/purple_wireless_transmitter" | "botanypots:pamhc2crops/crop/jute" | "compressedblocks:shaped_c3_stripped_cherry_log" | "chipped_express:stonecutting_chipped_magenta_terracotta_tile_from_magenta_terracotta" | "farmersdelight:cutting/bricks" | "chipped_express:stonecutting_chipped_rusted_pink_concrete_from_pink_concrete" | "utilitix:mangrove_shulker_boat_with_shell" | "chipped_express:stonecutting_chipped_spotted_brown_mushroom_block_from_brown_mushroom_block" | "snowyspirit:glow_lights_prismatic" | "botanypots:quark/crop/cherry_hedge" | "compressedblocks:shapeless_c5_soul_soil" | "sophisticatedstorage:warped_limited_barrel_2" | "chipped_express:stonecutting_chipped_tiled_bordered_amethyst_block_from_amethyst_block" | "sophisticatedstorage:warped_limited_barrel_1" | "sophisticatedstorage:warped_limited_barrel_4" | "sophisticatedstorage:warped_limited_barrel_3" | "mcwroofs:birch_planks_upper_steep_roof" | "libraryferret:blasting/netherite_coins_jtl" | "mcwroofs:warped_planks_roof" | "quark:building/crafting/mangrove_ladder" | "corail_woodcutter:woodcutting/tropicraft/mahogany_fence_from_mahogany_planks" | "chipped_express:stonecutting_chipped_arched_cyan_stained_glass_pillar_from_cyan_stained_glass" | "botania:twig_wand" | "gemsnjewels:create/create_crushing_ruby_ore" | "compressedblocks:shaped_c6_waxed_oxidized_cut_copper" | "aquaculture:iron_fillet_knife" | "chipped_express:stonecutting_chipped_cut_blank_amethyst_block_from_amethyst_block" | "chipped_express:stonecutting_chipped_yellow_terracotta_tile_from_yellow_terracotta" | "beachparty:palm_door" | "quark:building/stonecutting/slabs/iron_plate_slab_stonecutter" | "create:crushing/blaze_rod" | "chipped_express:stonecutting_chipped_ornate_coal_block_pillar_from_coal_block" | "chipped_express:stonecutting_chipped_railed_warped_planks_from_warped_planks" | "botania:livingwood_fence" | "quark:building/crafting/stairs/brown_shingles_stairs" | "minecraft:warped_slab" | "minecraft:mangrove_stairs" | "mcwlights:blue_paper_lamp" | "moa_decor_garden_:bancamangle_1" | "bloomingnature:laterit_brick_stairs_from_laterit_bricks_stonecutting" | "pamhc2foodextended:passionfruitjellyitem" | "botania:brew/jump_boost" | "chipped_express:stonecutting_chipped_curly_raw_iron_block_pillar_from_raw_iron_block" | "chipped_express:stonecutting_chipped_prismarine_scales_from_prismarine" | "chipped_express:stonecutting_chipped_overgrown_spruce_log_from_spruce_log" | "undergardendelight:gloomgourd_pie" | "snowyspirit:gumdrop_red" | "mcwfurnitures:stripped_jungle_chair" | "createdeco:industrial_iron_window_pane" | "domesticationinnovation:pet_bed_light_gray_from_dye" | "create:crafting/kinetics/nozzle" | "corail_woodcutter:woodcutting/cherry_button_from_cherry_planks" | "bloomingnature:travertin" | "mcwbridges:mud_brick_bridge_stair" | "compressedblocks:shaped_c0_stripped_dark_oak_log" | "minecraft:polished_diorite_slab_from_diorite_stonecutting" | "cosmeticarmoursmod:winged_fallen_angel_halo_rec_wing_v" | "railways:stonecutting/palettes/cycling/yellow_locometal_smokebox" | "createaddition:compat/tconstruct/pig_iron" | "create:polished_cut_asurine_slab" | "beachparty:mini_fridge_mixing/icecream_melon" | "chipped_express:stonecutting_chipped_runic_carved_blue_ice_from_blue_ice" | "chipped_express:stonecutting_chipped_glass_spruce_door_from_spruce_door" | "crafting_on_a_stick:uncraft_grindstone" | "corail_woodcutter:woodcutting/warped_button_from_warped_stems" | "mcwroofs:thatch_top_roof" | "chipped_express:stonecutting_chipped_frosted_spruce_leaves_from_spruce_leaves" | "chipped_express:stonecutting_chipped_hexagonical_purple_glazed_terracotta_from_purple_glazed_terracotta" | "chipped_express:stonecutting_chipped_sprouting_crimson_roots_from_crimson_roots" | "supplementaries:lapis_brick_slab" | "pamhc2foodextended:candleberryjellysandwichitem" | "botanypots:minecraft/pot_interaction/water_to_stone" | "moa_decor_lights:lm_gcafe_1" | "chipped_express:stonecutting_chipped_damaged_dark_oak_log_from_dark_oak_log" | "chipped:glassblower" | "refinedstorage:coloring_recipes/purple_network_transmitter" | "chipped_express:stonecutting_chipped_smooth_ringed_granite_from_granite" | "minecraft:sandstone_wall_from_sandstone_stonecutting" | "botania:brew/weak_regeneration" | "mcwfurnituresbop:hellbark_table" | "pamhc2foodextended:guavasmoothieitem" | "minecraft:polished_blackstone_bricks_from_polished_blackstone_stonecutting" | "railways:mechanical_crafting/light_gray_iron_wrapped_locometal_boiler" | "quark:world/crafting/woodsets/azalea/door" | "quark:building/crafting/vertslabs/polished_myalite_vertical_slab" | "create:cutting/compat/byg/palm_log" | "railways:crafting/palettes/dyeing_1x/green_locometal_smokebox" | "minecraft:redstone_from_blasting_deepslate_redstone_ore" | "chipped_express:stonecutting_chipped_blank_dripstone_block_carving_from_dripstone_block" | "mcwbridges:blackstone_bridge_stair" | "chipped_express:stonecutting_chipped_brick_bordered_dripstone_block_from_dripstone_block" | "lootbags:clothing_collection/vinemakers_outfit_completion" | "mcwfurnitures:stripped_mangrove_covered_desk" | "chipped_express:stonecutting_chipped_massive_amethyst_block_bricks_from_amethyst_block" | "pamhc2foodcore:grilledcheeseitem" | "compressedblocks:shapeless_septuple_crated_twisting_vines" | "refinedstorage:coloring_recipes/orange_security_manager" | "mcwbridges:bridge_torch" | "create_confectionery:ruby_chocolate_candy_3_recipe" | "chipped_express:stonecutting_chipped_etched_diorite_bricks_from_diorite" | "create:cutting/compat/blue_skies/cherry_wood" | "pamhc2foodextended:grapesmoothieitem" | "compressedblocks:shaped_giga_crated_sugar_cane" | "moa_decor_garden_:sombrillanegra_1" | "moa_decor_holidays:globos_magenta_1" | "mcwbridges:iron_bridge_stair" | "quark:world/crafting/polished_jasper" | "compressedblocks:shapeless_crated_painting" | "chipped_express:stonecutting_chipped_seared_nether_wart_block_from_nether_wart_block" | "delightful:knives/smelting/copper_immersiveengineering" | "pamhc2foodextended:mulberryjellysandwichitem" | "gemsnjewels:ornament_spinel_block" | "chipped_express:stonecutting_chipped_brown_mushroom_bulb_from_brown_mushroom" | "compressedblocks:shapeless_septuple_crated_stick" | "ecologics:cutting/flowering_azalea_log" | "chipped_express:stonecutting_chipped_circular_brown_terracotta_from_brown_terracotta" | "moa_decor_bath:c_tverdes_1" | "create:cut_scoria_brick_stairs" | "compressedblocks:shapeless_quadruple_crated_string" | "corail_woodcutter:woodcutting/bamboo_door_from_bamboo_blocks" | "compressedblocks:shaped_quintuple_crated_soul_campfire" | "compressedblocks:shaped_c2_cobblestone" | "refinedstorage:coloring_recipes/lime_crafting_monitor" | "chipped_express:stonecutting_chipped_framed_crimson_planks_from_crimson_planks" | "botanypots:farming_crossing/crop/pamhc2treespapaya_sapling" | "compressedblocks:shapeless_c8_lapis_block" | "supplementaries:compressedblocks/sign_post_c9_oak" | "compressedblocks:shaped_mega_crated_light_gray_carpet" | "luphieclutteredmod:luphie_sweetheart_sink_recipe" | "supplementaries:quark/sign_post_azalea" | "create:polished_cut_scoria_from_stone_types_scoria_stonecutting" | "chipped_express:stonecutting_chipped_blocky_green_carpet_from_green_carpet" | "compressedblocks:shapeless_c3_jungle_log" | "compressedblocks:shapeless_c7_raw_copper_block" | "createdeco:mossy_umber_brick_stairs" | "botania:stonecutting/metamorphic_desert_stone_to_metamorphic_desert_bricks_slab" | "minecraft:cracked_polished_blackstone_bricks" | "botania:mana_infusion/blaze_quartz_deconstruct" | "chipped_express:stonecutting_chipped_rounded_smooth_stone_bricks_from_smooth_stone" | "railways:crafting/palettes/dyeing_8x/lime_plated_locometal" | "gemsnjewels:forge_emerald_set_gold_ring" | "compressedblocks:shapeless_c4_oxidized_cut_copper" | "compressedblocks:shaped_double_crated_blue_carpet" | "snowyspirit:gingerbread_cookie" | "quark:building/crafting/chiseled_soul_sandstone" | "railways:sequenced_assembly/track_byg_aspen_narrow" | "compressedblocks:shapeless_quintuple_crated_egg" | "compressedblocks:shaped_giga_crated_glow_lichen" | "quark:building/stonecutting/stonevariants/andesite_bricks_slab_rough_stonecutting" | "gemsnjewels:stacked_aquamarine_slab" | "compressedblocks:shaped_c1_birch_planks" | "luphieclutteredmod:luphie_black_mini_cabinet_recipe" | "chipped_express:stonecutting_chipped_square_light_blue_stained_glass_from_light_blue_stained_glass" | "delightful:integration/ecologics/azalea_tea" | "mcwroofs:mud_brick_top_roof" | "railways:sequenced_assembly/track_byg_bulbis_narrow" | "pamhc2foodextended:veggiestirfryitem" | "pamhc2foodcore:crackersandcheeseitem" | "chipped_express:stonecutting_chipped_green_terracotta_tile_from_green_terracotta" | "meadow:limestone_brick_stairs_from_limestone_bricks_stonecutting" | "compressedblocks:shaped_octuple_crated_red_tulip" | "create:compat/byg/milling/crocus" | "compressedblocks:shaped_octuple_crated_sculk_vein" | "farmersdelight:mangrove_cabinet" | "conditional:regions_unexplored/wood_cutter/larch_trapdoor_woodcutter" | "quark:world/stonecutting/stairs/polished_shale_stairs_stonecutter2" | "botania:red_pavement" | "vinery:grass_slab" | "quark:tweaks/crafting/utility/chests/bamboo_chest_wood" | "createdeco:short_scarlet_brick_stairs_from_tiled_scarlet_bricks_stonecutting" | "chipped_express:stonecutting_chipped_duh_mossy_cobblestone_from_mossy_cobblestone" | "compressedblocks:shapeless_triple_crated_poisonous_potato" | "chipped_express:stonecutting_chipped_reinforced_bamboo_planks_from_bamboo_planks" | "compressedblocks:shapeless_c6_red_nether_bricks" | "botania:stonecutting/lavender_quartz_to_lavender_quartz_pillar" | "chipped_express:stonecutting_chipped_stacked_bricks_bricks_from_bricks" | "pamhc2foodextended:cranberrypieitem" | "framedblocks:framing_saw/framed_small_corner_slope_panel" | "moa_decor_lights:lm_gverde_1" | "moa_decor_art:esculturadragonchino_1" | "bloomingnature:palm_slab" | "botania:metamorphic_mesa_stone_slab" | "macawsroofsbop:palm_planks_steep_roof" | "compressedblocks:shapeless_c6_andesite" | "compressedblocks:shapeless_c7_iron_block" | "compressedblocks:shapeless_mega_crated_rabbit_hide" | "compressedblocks:shapeless_mega_crated_rose_bush" | "chipped_express:stonecutting_chipped_smooth_ringed_dripstone_block_from_dripstone_block" | "chipped_express:stonecutting_chipped_weathered_cobblestone_from_cobblestone" | "minecraft:netherite_hoe_smithing" | "mcwfurnitures:acacia_triple_drawer" | "corail_woodcutter:biomesoplenty/dead_woodcutter" | "chipped_express:stonecutting_chipped_simple_ancient_debris_pillar_from_ancient_debris" | "createdeco:brass_catwalk_stairs" | "botania:chiseled_metamorphic_fungal_bricks" | "minecraft:pink_sheet_from_pink_dye" | "compressedblocks:shapeless_octuple_crated_blaze_powder" | "botanypots:minecraft/crop/big_dripleaf" | "botanypots:minecraft/crop/oxeye_daisy" | "mcwfurnitures:stripped_acacia_double_drawer_counter" | "chipped_express:stonecutting_chipped_gated_oak_door_from_oak_door" | "quark:building/stonecutting/stonevariants/chiseled_granite_bricks_stonecutter" | "quark:tweaks/crafting/utility/bent/paper" | "compressedblocks:shaped_triple_crated_light_gray_carpet" | "chipped_express:stonecutting_chipped_beach_cherry_door_from_cherry_door" | "mcwlights:light_blue_lamp" | "meadow:wood_cutter/spruce/spruce_pp_woodcutter" | "compressedblocks:shapeless_triple_crated_oak_sapling" | "chipped_express:stonecutting_chipped_diamond_mud_bricks_bricks_from_mud_bricks" | "compressedblocks:shapeless_quadruple_crated_pink_carpet" | "create:cut_scorchia_wall_from_stone_types_scorchia_stonecutting" | "create:crafting/materials/zinc_nugget_from_decompacting" | "botanypots:farming_crossing/crop/delightfulcantaloupe_seeds" | "chipped_express:stonecutting_chipped_cut_blank_packed_mud_from_packed_mud" | "corail_woodcutter:woodcutting/biomesoplenty/umbran_boat_from_umbran_logs" | "minecraft:black_bed" | "chipped_express:stonecutting_chipped_smooth_inlayed_obsidian_from_obsidian" | "botania:apothecary_mossy" | "botanypots:minecraft/soil/mossy_cobblestone" | "create:crafting/kinetics/hose_pulley" | "farmersdelight:cooked_bacon" | "railways:crafting/palettes/dyeing_8x/green_locometal_smokebox" | "createdeco:mossy_verdant_bricks_from_vine" | "railways:crafting/palettes/dyeing_1x/blue_flat_slashed_locometal" | "botania:livingwood_twig" | "compressedblocks:shaped_mega_crated_seagrass" | "chipped_express:stonecutting_chipped_carved_tuff_from_tuff" | "chipped_express:stonecutting_chipped_massive_nether_bricks_bricks_from_nether_bricks" | "refinedstorage:coloring_recipes/cyan_pattern_grid" | "compressedblocks:shaped_octuple_crated_feather" | "compressedblocks:shaped_sextuple_crated_brown_mushroom" | "chipped_express:stonecutting_chipped_overgrown_bamboo_trapdoor_from_bamboo_trapdoor" | "beachparty:cabinet" | "gemsnjewels:create/create_crushing_black_opal_nether_ore" | "chipped_express:stonecutting_chipped_spiraled_sandstone_from_sandstone" | "minecraft:purple_concrete_powder" | "chipped_express:stonecutting_chipped_stacked_nether_bricks_bricks_from_nether_bricks" | "pamhc2crops:waterchestnutseeditem" | "chipped_express:stonecutting_chipped_vertical_warped_planks_from_warped_planks" | "luphieclutteredmod:blue_birdhouse_recipe" | "compressedblocks:shapeless_c0_netherrack" | "beachparty:palm_floorboard" | "pamhc2foodextended:blueberrypieitem" | "chipped_express:stonecutting_chipped_vertical_stiped_black_stained_glass_from_black_stained_glass" | "cosmeticarmoursmod:fishermans_bucket_hat_rec" | "chipped_express:stonecutting_chipped_d_sign_stripped_mangrove_log_from_stripped_mangrove_log" | "minecraft:red_carpet" | "bloomingnature:ebony_window" | "compressedblocks:shapeless_c3_stone_bricks" | "chipped_express:stonecutting_chipped_cracked_disordered_mossy_cobblestone_bricks_from_mossy_cobblestone" | "quark:building/crafting/stairs/sandstone_bricks_stairs" | "fairylights:spearhead_pennant" | "mcwfurnitures:stripped_cherry_desk" | "meadow:polished_limestone_brick_from_limestone_stonecutting" | "refinedstorage:coloring_recipes/black_fluid_grid" | "chipped_express:stonecutting_chipped_mud_bricks_scales_from_mud_bricks" | "mcwroofs:blue_terracotta_steep_roof" | "compressedblocks:shaped_c9_nether_bricks" | "farmersdelight:cooking/dog_food" | "chipped_express:stonecutting_chipped_cut_purpur_block_column_from_purpur_block" | "create:small_scoria_brick_stairs" | "moa_decor_toys:caballocafe_c_1" | "create:cutting/compat/byg/pine_log" | "botanypots:supplementaries/crop/wild_flax" | "createdeco:brass_sheet_metal" | "conditional:bakery/oat" | "chipped_express:stonecutting_chipped_smooth_nether_bricks_column_from_nether_bricks" | "moa_decor_lights:lm_grosa_1" | "pamhc2foodextended:dimsumitem" | "quark:building/stonecutting/slabs/shingles_slab_stonecutter" | "sophisticatedstorage:basic_to_copper_tier_upgrade" | "create:crafting/kinetics/white_sail" | "chipped_express:stonecutting_chipped_vertical_jungle_planks_from_jungle_planks" | "compressedblocks:shaped_quadruple_crated_light_blue_carpet" | "quark:automation/crafting/gravisand" | "refinedstorage:pattern_grid/yellow_pattern_grid" | "chipped_express:stonecutting_chipped_brick_bordered_calcite_from_calcite" | "chipped_express:stonecutting_chipped_layered_stripped_cherry_log_from_stripped_cherry_log" | "pamhc2foodextended:pizzasliceitem_bbqchickenpizzaitem" | "pamhc2foodextended:greengrapesmoothieitem" | "mcwroofs:white_terracotta_steep_roof" | "chipped_express:stonecutting_chipped_sanded_packed_ice_from_packed_ice" | "chipped_express:stonecutting_chipped_thick_inlayed_cobblestone_from_cobblestone" | "minecraft:cyan_stained_glass_pane" | "create:crafting/copper/waxed_oxidized_copper_tile_slab_from_honeycomb" | "sophisticatedstorage:diamond_shulker_box" | "delightful:food/prickly_pear_juice" | "mcwdoors:oak_western_door" | "create:cutting/jungle_log" | "ecologics:cutting/coconut_log" | "vinery:oak_planks" | "moa_decor_toys:arana_1" | "conditional:regions_unexplored/wood_cutter/eucalyptus_fencegate_woodcutter" | "mcwroofs:base_steep_roof" | "botanypots:botanypots/crafting/black_terracotta_botany_pot" | "create:cut_tuff_slab_recycling" | "compressedblocks:shapeless_mega_crated_cherry_sapling" | "mcwroofs:gray_terracotta_steep_roof" | "railways:sequenced_assembly/yellow_conductor_cap" | "compressedblocks:shapeless_quadruple_crated_gray_carpet" | "chipped_express:stonecutting_chipped_supported_birch_door_from_birch_door" | "compressedblocks:shapeless_quintuple_crated_cod" | "beachparty:rubber_ring_stripped" | "farmersdelight:paper_from_tree_bark" | "refinedstorage:coloring_recipes/purple_controller" | "mcwtrpdoors:acacia_swamp_trapdoor" | "refinedstorage:coloring_recipes/orange_controller" | "compressedblocks:shaped_sextuple_crated_lilac" | "create:cut_dripstone_stairs" | "createaddition:liquid_burning/biodiesel" | "createaddition:mixing/electrum" | "mcwwindows:acacia_plank_parapet" | "moa_decor_holidays:corona_navidena_1" | "create_central_kitchen:emptying/apple_cider" | "compressedblocks:shaped_c5_cut_red_sandstone" | "chipped_express:stonecutting_chipped_smooth_inlayed_diorite_from_diorite" | "minecraft:cooked_cod" | "sophisticatedstorage:shulker_from_chest" | "pamhc2foodextended:passionfruitjuiceitem" | "createdeco:long_scarlet_bricks_from_short_scarlet_bricks_stonecutting" | "minecraft:cartography_table" | "mcwdoors:crimson_western_door" | "compressedblocks:shapeless_sextuple_crated_allium" | "chipped_express:stonecutting_chipped_woved_magenta_carpet_from_magenta_carpet" | "chipped_express:stonecutting_chipped_ornate_magenta_stained_glass_from_magenta_stained_glass" | "aquaculturedelight:cooking/halaszle" | "quark:building/stonecutting/stonevariants/calcite_pillar_stonecutter" | "compressedblocks:shaped_crated_gunpowder" | "createdeco:mossy_dean_brick_slab_from_mossy_dean_bricks_stonecutting" | "chipped_express:stonecutting_chipped_ornate_clay_pillar_from_clay" | "chipped_express:stonecutting_chipped_ornate_white_redstone_lamp_from_redstone_lamp" | "mcwfurnitures:stripped_dark_oak_triple_drawer" | "chipped_express:stonecutting_chipped_ribbled_blue_wool_from_blue_wool" | "cosmeticarmoursmod:grey_skirt_2_plaid" | "moa_decor_garden_:cama_m_magenta_1" | "compressedblocks:shapeless_quadruple_crated_light_blue_dye" | "chipped_express:stonecutting_chipped_fired_nether_sprouts_from_nether_sprouts" | "pamhc2crops:bakedjicamaitem_forge" | "createdeco:iron_window" | "compressedblocks:shapeless_crated_cyan_dye" | "quark:building/crafting/vertslabs/tuff_bricks_vertical_slab" | "pamhc2foodextended:onionhamburgeritem" | "createdeco:red_brass_lamp" | "chipped_express:stonecutting_chipped_orange_oak_leaves_from_oak_leaves" | "cosmeticarmoursmod:blue_knight_armour_boots_rec" | "mcwfurnituresbop:mahogany_large_drawer" | "mcwwindows:stone_window" | "chipped_express:stonecutting_chipped_decorated_black_glazed_terracotta_from_black_glazed_terracotta" | "snowyspirit:compressedblocks/sled_c0_cherry" | "chipped_express:stonecutting_chipped_overlapping_raw_iron_block_tiles_from_raw_iron_block" | "macawsroofsbop:umbran_upper_lower_roof" | "compressedblocks:shaped_octuple_crated_cooked_salmon" | "moa_decor_holidays:bota_nverdelima_1" | "compressedblocks:shapeless_c9_soul_sand" | "biomesoplenty:magic_chest_boat" | "chipped_express:stonecutting_chipped_angry_lodestone_from_lodestone" | "luphieclutteredmod:luphie_purple_plank_set_pressure_plate_recipe" | "corail_woodcutter:woodcutting/bamboo_button_from_bamboo_blocks" | "quark:world/crafting/stairs/permafrost_stairs" | "chipped_express:stonecutting_chipped_rune_packed_mud_from_packed_mud" | "chipped_express:stonecutting_chipped_tiny_layered_blue_ice_slabs_from_blue_ice" | "compressedblocks:shaped_c9_soul_soil" | "mcwfences:crimson_picket_fence" | "pamhc2crops:hotcoffeeitem_forge" | "create:compat/byg/crushing/blue_nether_gold_ore" | "mcwfurnitures:jungle_chair" | "chipped_express:stonecutting_chipped_cornered_black_wool_from_black_wool" | "compressedblocks:shaped_quadruple_crated_leather" | "chipped_express:stonecutting_chipped_smoothed_double_inlayed_mud_bricks_from_mud_bricks" | "compressedblocks:shaped_c2_tuff" | "mcwfurnitures:stripped_warped_striped_chair" | "railways:crafting/palettes/dyeing_8x/lime_brass_wrapped_locometal" | "chipped_express:stonecutting_chipped_harsh_quilted_magenta_wool_from_magenta_wool" | "create:cut_calcite_brick_slab_recycling" | "create:layered_tuff_from_stone_types_tuff_stonecutting" | "compressedblocks:shapeless_triple_crated_cherry_sapling" | "handcrafted:cherry_side_table" | "minecraft:netherite_pickaxe_smithing" | "botanypots:pamhc2crops/crop/oats" | "corail_woodcutter:biomesoplenty/umbran_woodcutter" | "framedblocks:framing_saw/framed_floor_board" | "beachparty:tiki_bar" | "compressedblocks:shapeless_c7_stripped_jungle_log" | "createdeco:short_blue_bricks_from_blue_bricks_stonecutting" | "chipped_express:stonecutting_chipped_raw_iron_block_pillar_from_raw_iron_block" | "compressedblocks:shaped_c0_redstone_ore" | "delightful:knives/fiery_knife" | "chipped_express:stonecutting_chipped_golden_cherry_dark_oak_leaves_from_dark_oak_leaves" | "create:cut_veridium_brick_stairs_from_stone_types_veridium_stonecutting" | "quark:building/stonecutting/walls/dripstone_bricks_wall_stonecutter" | "chipped_express:stonecutting_chipped_cracked_flat_sandstone_tiles_from_sandstone" | "snowyspirit:biomesoplenty/sled_jacaranda" | "minecraft:golden_helmet" | "refinedstorage:1k_storage_block" | "minecraft:light_blue_dye_from_blue_orchid" | "chipped_express:stonecutting_chipped_poisonous_vine_from_vine" | "mcwfurnitures:stripped_cherry_bookshelf_cupboard" | "chipped_express:stonecutting_chipped_edged_dripstone_block_bricks_from_dripstone_block" | "compressedblocks:shaped_triple_crated_golden_apple" | "quark:world/crafting/woodsets/blossom/boat" | "chipped_express:stonecutting_chipped_silly_carved_pumpkin_from_carved_pumpkin" | "railways:sequenced_assembly/track_byg_ether_wide" | "create:scoria_from_stone_types_scoria_stonecutting" | "chipped_express:stonecutting_chipped_curled_black_terracotta_from_black_terracotta" | "compressedblocks:shaped_sextuple_crated_honeycomb" | "sophisticatedstorage:mangrove_barrel" | "chipped_express:stonecutting_chipped_meshed_mangrove_trapdoor_from_mangrove_trapdoor" | "cookingforblockheads:dye_purple_oven" | "quark:building/crafting/vertslabs/blossom_planks_vertical_slab" | "chipped_express:stonecutting_chipped_vertical_stiped_orange_stained_glass_pane_from_orange_stained_glass_pane" | "chipped_express:stonecutting_chipped_quartz_block_pillar_from_quartz_block" | "compressedblocks:shaped_quintuple_crated_dragon_breath" | "luphieclutteredmod:stripped_flowering_pink_wood_recipe" | "create:cutting/compat/biomesoplenty/fir_wood" | "chipped_express:stonecutting_chipped_pillar_red_sandstone_bricks_from_red_sandstone" | "chipped_express:stonecutting_chipped_unamused_sandstone_from_sandstone" | "cosmeticarmoursmod:white_top_2_red" | "railways:crafting/palettes/dyeing_8x/orange_copper_wrapped_locometal_boiler" | "farmersdelight:cutting/warped_stem" | "compressedblocks:shaped_c5_stripped_birch_log" | "chipped_express:stonecutting_chipped_warped_planks_shavings_from_warped_planks" | "chipped_express:stonecutting_chipped_knitted_purple_wool_from_purple_wool" | "chipped_express:stonecutting_chipped_rounded_tuff_bricks_from_tuff" | "luphieclutteredmod:luphie_blue_mushroom_slab_recipe" | "compressedblocks:shapeless_double_crated_quartz" | "chipped_express:stonecutting_chipped_cubed_gray_wool_from_gray_wool" | "chipped_express:stonecutting_chipped_small_gray_terracotta_tiles_from_gray_terracotta" | "storagedrawers:fill_level_upgrade" | "supplementaries:stonecutting/blackstone_tile" | "pamhc2foodextended:stuffingitem" | "create:cutting/compat/byg/aspen_log" | "chipped_express:stonecutting_chipped_spider_mossy_cobblestone_carving_from_mossy_cobblestone" | "aquaculture:iron_fishing_rod" | "framedblocks:framing_saw/framed_fancy_detector_rail" | "conditional:vinery/wood_cutter/cherry_fencegate_woodcutter" | "compressedblocks:shaped_sextuple_crated_yellow_carpet" | "create:compat/atmospheric/pressing/crustose_path" | "moa_decor_bath:esp_dizq_2" | "moa_decor_bath:esp_dizq_1" | "handcrafted:warped_chair" | "compressedblocks:shapeless_octuple_crated_blaze_rod" | "pamhc2foodextended:stuffedpepperitem" | "botania:stonecutting/metamorphic_forest_bricks_to_metamorphic_forest_bricks_stairs" | "botania:black_petal_block" | "railways:crafting/palettes/dyeing_8x/blue_iron_wrapped_locometal_boiler" | "chipped_express:stonecutting_chipped_cut_blank_red_sandstone_from_red_sandstone" | "mcwfences:spruce_wired_fence" | "chipped_express:stonecutting_chipped_crimson_fungus_cluster_from_crimson_fungus" | "mcwfurnitures:stripped_dark_oak_drawer_counter" | "handcrafted:andesite_corner_trim" | "compressedblocks:shapeless_mega_crated_phantom_membrane" | "farmersdelight:jungle_cabinet" | "ftbquests:screen_5" | "ftbquests:screen_7" | "ftbquests:screen_1" | "compressedblocks:shaped_octuple_crated_ink_sac" | "brewery:banner_from_smithing_table" | "mcwroofs:magenta_terracotta_top_roof" | "ftbquests:screen_3" | "compressedblocks:shapeless_sextuple_crated_black_carpet" | "quark:building/stonecutting/stonevariants/limestone_bricks_stonecutter" | "luphieclutteredmod:luphie_flowering_purple_door_recipe" | "chipped_express:stonecutting_chipped_sticky_melon_from_melon" | "pamhc2foodextended:pickledonionsitem" | "chipped_express:stonecutting_chipped_loded_borderless_bricks_from_bricks" | "vinery:wine_fermentation/nether_fizz" | "chipped_express:stonecutting_chipped_sad_prismarine_from_prismarine" | "chipped_express:stonecutting_chipped_duh_dirt_from_dirt" | "chipped_express:stonecutting_chipped_warped_vine_from_vine" | "mcwroofs:sandstone_steep_roof" | "mcwroofs:gutter_middle_gray" | "framedblocks:framing_saw/framed_pyramid_slab" | "compressedblocks:shaped_septuple_crated_ghast_tear" | "create:compat/byg/crushing/ametrine_ore" | "compressedblocks:shapeless_septuple_crated_peony" | "mcwroofs:cherry_steep_roof" | "compressedblocks:shapeless_septuple_crated_cookie" | "compressedblocks:shaped_giga_crated_carrot" | "meadow:stone_bench" | "mcwbridges:stonecutter_deepslate_tile_bridge_pier" | "mcwroofs:orange_concrete_upper_lower_roof" | "mcwfurnituresbop:palm_bookshelf_cupboard" | "quark:building/stonecutting/brown_shingles_stonecutter2" | "bloomingnature:stripped_baobab_wood" | "refinedstorage:regulator_upgrade" | "compressedblocks:shapeless_mega_crated_glistering_melon_slice" | "farmersdelight:blue_hanging_canvas_sign" | "chipped_express:stonecutting_chipped_polished_mossy_stone_bricks_from_mossy_stone_bricks" | "chipped_express:stonecutting_chipped_overgrown_spruce_door_from_spruce_door" | "chipped_express:stonecutting_chipped_rough_ice_from_ice" | "compressedblocks:shaped_triple_crated_lilac" | "macawsroofsbop:jacaranda_upper_steep_roof" | "railways:crafting/palettes/dyeing_1x/white_copper_wrapped_locometal" | "railways:crafting/palettes/dyeing_1x/red_brass_wrapped_locometal_boiler" | "compressedblocks:shaped_triple_crated_porkchop" | "delightful:knives/blasting/electrum_immersiveengineering" | "compressedblocks:shaped_septuple_crated_glow_item_frame" | "compressedblocks:shaped_double_crated_feather" | "compressedblocks:shapeless_double_crated_potato" | "compressedblocks:shapeless_c6_slime_block" | "create:compat/supplementaries/splashing/blackboard" | "mcwroofs:deepslate_lower_roof" | "createdeco:umber_brick_slab_from_tiled_umber_brick_slab_stonecutting" | "compressedblocks:shaped_c6_lapis_ore" | "chipped_express:stonecutting_chipped_tiled_smooth_stone_column_from_smooth_stone" | "chipped_express:stonecutting_chipped_polished_blue_ice_from_blue_ice" | "chipped_express:stonecutting_chipped_sheet_waxed_oxidized_copper_from_waxed_oxidized_copper" | "chipped_express:stonecutting_chipped_spider_granite_carving_from_granite" | "minecraft:lightning_rod" | "minecraft:brown_stained_glass_pane_from_glass_pane" | "chipped_express:stonecutting_chipped_wide_eyed_jack_o_lantern_from_jack_o_lantern" | "moa_decor_garden_:casa_mrobleosc_1" | "mcwroofs:jungle_planks_top_roof" | "createdeco:tiled_scarlet_brick_stairs_from_scarlet_brick_stairs_stonecutting" | "artifacts:eternal_steak_smoker" | "railways:crafting/palettes/dyeing_1x/cyan_locometal_smokebox" | "chipped_express:stonecutting_chipped_tiled_crimson_planks_from_crimson_planks" | "chipped_express:stonecutting_chipped_green_terracotta_bricks_from_green_terracotta" | "quark:building/crafting/vertplanks/vertical_dark_oak_planks" | "conditional:regions_unexplored/wood_cutter/brimwood_stairs_woodcutter" | "mcwdoors:acacia_paper_door" | "chipped_express:stonecutting_chipped_checkered_dripstone_block_tiles_from_dripstone_block" | "minecraft:stone_brick_slab_from_stone_bricks_stonecutting" | "chipped_express:stonecutting_chipped_edged_quartz_block_bricks_from_quartz_block" | "chipped_express:stonecutting_chipped_hexagonical_yellow_glazed_terracotta_from_yellow_glazed_terracotta" | "create:crafting/appliances/filter_clear" | "framedblocks:framed_inv_double_slope_slab_rotate_to_framed_inv_double_slope_panel" | "compressedblocks:shapeless_quadruple_crated_red_mushroom" | "compressedblocks:shaped_c7_jungle_log" | "biomesoplenty:stripped_redwood_wood" | "chipped_express:stonecutting_chipped_rounded_andesite_bricks_from_andesite" | "chipped_express:stonecutting_chipped_unamused_andesite_from_andesite" | "corail_woodcutter:woodcutting/biomesoplenty/mahogany_trapdoor_from_mahogany_planks" | "bloomingnature:dye_purple_from_tall_lupine_purple" | "bakery:baking_station/strawberry_cookie" | "farmersdelight:sweet_berry_cookie" | "create:crafting/kinetics/cuckoo_clock" | "compressedblocks:shaped_sextuple_crated_dragon_breath" | "pamhc2trees:pinenut_sapling" | "mcwfurnitures:stripped_warped_glass_table" | "compressedblocks:shapeless_mega_crated_bone" | "quark:building/stonecutting/vertslabs/iron_plate_vertical_slab_stonecutter" | "chipped_express:stonecutting_chipped_cracked_andesite_bricks_from_andesite" | "createdeco:mossy_red_brick_stairs_from_mossy_red_bricks_stonecutting" | "chipped_express:stonecutting_chipped_lime_glazed_terracotta_tiles_from_lime_glazed_terracotta" | "alexsdelight:smelting/bison_cook" | "pamhc2foodextended:limejuiceitem" | "botania:mining_ring" | "ars_nouveau:source_berry_pie" | "create:copper_tile_slab_from_copper_tiles_stonecutting" | "create:polished_cut_andesite_slab" | "compressedblocks:shaped_quadruple_crated_gray_carpet" | "quark:building/crafting/sturdy_stone" | "chipped_express:stonecutting_chipped_smooth_inlayed_prismarine_from_prismarine" | "compressedblocks:shapeless_crated_light_blue_carpet" | "cosmeticarmoursmod:cyan_sock_plaid_2_skirt" | "chipped_express:stonecutting_chipped_fancy_mud_bricks_pillar_from_mud_bricks" | "mcwroofs:cherry_planks_upper_steep_roof" | "compressedblocks:shapeless_mega_crated_item_frame" | "quark:world/crafting/walls/permafrost_wall" | "chipped_express:stonecutting_chipped_small_white_terracotta_tiles_from_white_terracotta" | "quark:building/crafting/vertslabs/deepslate_tile_vertical_slab" | "pamhc2foodextended:musubiitem" | "compressedblocks:shapeless_giga_crated_redstone_torch" | "create_confectionery:full_black_chocolate_bar_recipe" | "chipped_express:stonecutting_chipped_shuttered_netherite_block_from_netherite_block" | "compressedblocks:shaped_c1_cherry_log" | "quark:building/crafting/dark_oak_ladder" | "chipped_express:stonecutting_chipped_gated_bamboo_door_from_bamboo_door" | "chipped_express:stonecutting_chipped_knitted_yellow_carpet_from_yellow_carpet" | "create:cutting/compat/forbidden_arcanus/mysterywood" | "botanypots:farmersdelight/crop/rice" | "moa_decor_holidays:calabaza_dulces_1" | "botania:pure_daisy/obsidian" | "compressedblocks:shaped_septuple_crated_name_tag" | "mcwfurnituresbop:redwood_lower_bookshelf_drawer" | "create:compat/byg/splashing/cryptic_magma_block" | "compressedblocks:shaped_c9_waxed_weathered_copper" | "botanypots:botanypots/crafting/lime_glazed_terracotta_compact_hopper_botany_pot" | "aquaculture:oak_fish_mount" | "compressedblocks:shaped_c7_end_stone" | "chipped_express:stonecutting_chipped_smooth_ringed_sandstone_from_sandstone" | "compressedblocks:shaped_quadruple_crated_nautilus_shell" | "luphieclutteredmod:luphie_antique_lamp_recipe" | "chipped_express:stonecutting_chipped_cracked_cobblestone_bricks_from_cobblestone" | "meadow:wood_cutter/pine/pine_shelf_woodcutter" | "chipped_express:stonecutting_chipped_edged_blackstone_bricks_from_blackstone" | "mcwfurnitures:cherry_drawer_counter" | "framedblocks:framing_saw" | "compressedblocks:shaped_quintuple_crated_warped_fungus" | "minecraft:brewing_stand" | "cosmeticarmoursmod:royal_tunic_rec" | "compressedblocks:shaped_octuple_crated_detector_rail" | "chipped_express:stonecutting_chipped_sweet_melon_from_melon" | "chipped_express:stonecutting_chipped_carved_basalt_from_basalt" | "mcwroofs:orange_concrete_steep_roof" | "mcwwindows:warped_planks_window" | "beachparty:palm_button" | "chipped_express:stonecutting_chipped_lime_terracotta_column_from_lime_terracotta" | "gemsnjewels:light_stone_alexandrite" | "create:compat/endergetic/splashing/petrified_nether_corrock_block" | "delightful:smelting/cooked_goat" | "handcrafted:spruce_bench" | "chipped_express:stonecutting_chipped_blobby_moss_block_from_moss_block" | "create:crafting/kinetics/gearboxfrom_conversion" | "create_central_kitchen:filling/apple_cider" | "createdeco:mossy_red_brick_slab_from_mossy_red_bricks_stonecutting" | "chipped_express:stonecutting_chipped_barky_yellow_carpet_from_yellow_carpet" | "framedblocks:framed_panel_from_framed_centered_panel" | "compressedblocks:shaped_mega_crated_cookie" | "moa_decor_toys:gatocalico_1" | "mcwbridges:stonecutter_mossy_cobblestone_bridge_pier" | "minecraft:diamond_block" | "handcrafted:diorite_corner_trim" | "chipped_express:stonecutting_chipped_polished_netherite_block_from_netherite_block" | "chipped_express:stonecutting_chipped_thick_inlayed_raw_copper_block_from_raw_copper_block" | "farmersdelight:lime_canvas_sign" | "chipped_express:stonecutting_chipped_dark_prismarine_scales_from_dark_prismarine" | "mcwtrpdoors:oak_beach_trapdoor" | "chipped_express:stonecutting_chipped_blue_glazed_terracotta_pillar_sides_from_blue_glazed_terracotta" | "quark:building/crafting/stripped_blossom_post" | "create:compat/atmospheric/cutting/stripped_kousa_log" | "compressedblocks:shapeless_c1_spruce_log" | "mcwbridges:stonecutter_mud_brick_bridge_pier" | "compressedblocks:shapeless_triple_crated_sunflower" | "compressedblocks:shapeless_double_crated_dandelion" | "createdeco:long_scarlet_brick_stairs_from_tiled_scarlet_bricks_stonecutting" | "luphieclutteredmod:luphie_flowering_yellow_bookshelf_recipe" | "railways:dying_existing_cap_lime" | "mcwfurnituresbop:dead_striped_chair" | "chipped_express:stonecutting_chipped_vertical_stiped_blue_stained_glass_from_blue_stained_glass" | "mcwfurnituresbop:fir_table" | "pamhc2trees:cherry_sapling" | "railways:sequenced_assembly/track_biomesoplenty_dead" | "railways:crafting/palettes/dyeing_1x/yellow_locometal_boiler" | "create:cutting/stripped_crimson_hyphae" | "chipped_express:stonecutting_chipped_eroded_sandstone_from_sandstone" | "createdeco:umber_brick_slab_from_short_umber_brick_slab_stonecutting" | "compressedblocks:shapeless_c3_bricks" | "chipped_express:stonecutting_chipped_cross_haired_red_wool_from_red_wool" | "pamhc2trees:guava_sapling" | "brewery:pork_knuckle_from_smoking" | "quark:building/crafting/hollowlogs/hollow_dark_oak_log" | "botania:metamorphic_mountain_stone_wall" | "compressedblocks:shaped_triple_crated_salmon" | "chipped_express:stonecutting_chipped_thick_inlayed_mossy_cobblestone_from_mossy_cobblestone" | "handcrafted:bricks_corner_trim" | "compressedblocks:shapeless_mega_crated_book" | "chipped_express:stonecutting_chipped_raster_lime_stained_glass_from_lime_stained_glass" | "conditional:regions_unexplored/wood_cutter/cypress_trapdoor_woodcutter" | "chipped_express:stonecutting_chipped_fine_vertical_cherry_planks_from_cherry_planks" | "compressedblocks:shapeless_c7_deepslate" | "quark:world/stonecutting/slabs/limestone_bricks_slab_stonecutter" | "mcwroofs:pink_terracotta_attic_roof" | "meadow:wooden_flower_pot" | "railways:mechanical_crafting/orange_brass_wrapped_locometal_boiler" | "pamhc2foodextended:gourmetmuttonburgeritem" | "chipped_express:stonecutting_chipped_inscribed_deepslate_from_deepslate" | "conditional:beachparty/wood_cutter/palm_fencegate_woodcutter" | "chipped_express:stonecutting_chipped_bundled_light_blue_wool_from_light_blue_wool" | "supplementaries:compressedblocks/sign_post_c2_jungle" | "chipped_express:stonecutting_chipped_cornered_pink_wool_from_pink_wool" | "compressedblocks:shaped_c8_weathered_copper" | "gemsnjewels:stacked_morganite_stairs" | "create:compat/silentsgems/crushing/amber_ore" | "chipped_express:stonecutting_chipped_small_green_lantern_from_lantern" | "corail_woodcutter:woodcutting/biomesoplenty/willow_door_from_willow_planks" | "toolbelt:pouch_via_sewing" | "createdeco:pressing/netherite_sheet" | "compressedblocks:shaped_quadruple_crated_item_frame" | "sophisticatedstorage:advanced_compacting_upgrade" | "chipped_express:stonecutting_chipped_curly_bricks_pillar_from_bricks" | "chipped_express:stonecutting_chipped_ad_astra_ochre_froglight_from_ochre_froglight" | "botania:manasteel_shears" | "nethersdelight:cooking/magma_gelatin" | "alexsmobs:rainbow_glass" | "compressedblocks:shaped_c1_spruce_planks" | "compressedblocks:shapeless_giga_crated_saddle" | "mcwwindows:stone_brick_gothic" | "compressedblocks:shaped_c8_mangrove_planks" | "handcrafted:blackstone_pillar_trim" | "framedblocks:framing_saw/framed_ext_inner_double_corner_slope_panel" | "minecraft:iron_ingot_from_smelting_raw_iron" | "conditional:regions_unexplored/wood_cutter/kapok_pp_woodcutter" | "moa_decor_science:camahcafe_1" | "chipped_express:stonecutting_chipped_layered_orange_terracotta_from_orange_terracotta" | "mcwfences:modern_blackstone_wall_stonecutter" | "chipped_express:stonecutting_chipped_spider_quartz_block_carving_from_quartz_block" | "compressedblocks:shaped_c0_stripped_cherry_log" | "createdeco:brass_catwalk_forge" | "mcwroofs:pink_terracotta_upper_lower_roof" | "mcwlights:green_lamp" | "chipped_express:stonecutting_chipped_shifted_spruce_planks_from_spruce_planks" | "compressedblocks:shapeless_double_crated_cooked_chicken" | "compressedblocks:shaped_c7_copper_block" | "chipped_express:stonecutting_chipped_engraved_andesite_from_andesite" | "minecraft:stripped_warped_hyphae" | "create:cut_calcite_brick_stairs" | "mcwbridges:stonecutter_andesite_bridge_stair" | "create:smelting/glass_pane_from_tiled_glass_pane" | "refinedstorage:wireless_grid" | "chipped_express:stonecutting_chipped_button_crimson_fungus_from_crimson_fungus" | "storagedrawers:emerald_storage_upgrade" | "compressedblocks:shaped_c9_exposed_copper" | "refinedstorage:coloring_recipes/red_network_receiver" | "compressedblocks:shaped_giga_crated_spruce_sapling" | "macawsroofsbop:jacaranda_planks_upper_lower_roof" | "refinedstorage:coloring_recipes/pink_grid" | "cosmeticarmoursmod:creeper_mask_rec" | "chipped_express:stonecutting_chipped_kitty_faced_carved_pumpkin_from_carved_pumpkin" | "minecraft:cherry_hanging_sign" | "supplementaries:compressedblocks/sign_post_c0_dark_oak" | "mcwfurnitures:warped_double_wardrobe" | "compressedblocks:shapeless_quadruple_crated_redstone_torch" | "mcwbridges:cherry_rail_bridge" | "chipped_express:stonecutting_chipped_massive_tuff_bricks_from_tuff" | "quark:building/stonecutting/slabs/purple_shingles_slab_stonecutter" | "ars_nouveau:cutting/red_archwood_wood" | "compressedblocks:shaped_c5_spruce_planks" | "chipped_express:stonecutting_chipped_glad_granite_from_granite" | "quark:tweaks/blasting/raw_gold_bricks_blast" | "mcwbridges:brick_bridge_pier" | "chipped_express:stonecutting_chipped_arched_brown_stained_glass_pane_pillar_from_brown_stained_glass_pane" | "compressedblocks:shaped_crated_lily_of_the_valley" | "createaddition:rolling/lead_plate" | "chipped_express:stonecutting_chipped_stacked_black_concrete_from_black_concrete" | "chipped_express:stonecutting_chipped_spider_prismarine_carving_from_prismarine" | "railways:sequenced_assembly/track_tfc_douglas_fir_wide" | "chipped_express:stonecutting_chipped_raster_magenta_stained_glass_from_magenta_stained_glass" | "compressedblocks:shaped_giga_crated_glow_ink_sac" | "chipped_express:stonecutting_chipped_thick_inlayed_purpur_block_from_purpur_block" | "exoticbirds:white_birdhouse" | "railways:crafting/palettes/dyeing_8x/purple_riveted_locometal" | "ars_nouveau:cutting/purple_archwood_wood" | "compressedblocks:shapeless_sextuple_crated_soul_campfire" | "compressedblocks:shaped_c8_stripped_oak_log" | "biomesoplenty:redwood_button" | "compressedblocks:shaped_c3_red_nether_bricks" | "chipped_express:stonecutting_chipped_tiny_magma_block_bricks_from_magma_block" | "compressedblocks:shapeless_sextuple_crated_clay_ball" | "chipped_express:stonecutting_chipped_pegged_pink_concrete_from_pink_concrete" | "compressedblocks:shapeless_c5_gravel" | "quark:building/crafting/compressed/golden_apple_crate_uncompress" | "compressedblocks:shapeless_quadruple_crated_cooked_mutton" | "compressedblocks:shapeless_c3_bamboo_mosaic" | "macawsroofsbop:redwood_planks_lower_roof" | "compressedblocks:shapeless_c8_cherry_log" | "mcwfurnitures:jungle_modern_chair" | "compressedblocks:shaped_c5_iron_ore" | "chipped_express:stonecutting_chipped_cracked_flat_redstone_block_tiles_from_redstone_block" | "minecraft:quartz_slab" | "chipped_express:stonecutting_chipped_bundled_red_carpet_from_red_carpet" | "mcwtrpdoors:birch_bamboo_trapdoor" | "compressedblocks:shapeless_c9_deepslate" | "quark:building/stonecutting/slabs/cyan_shingles_slab_stonecutter" | "createdeco:light_blue_placard" | "aquaculturedelight:cooking/rollmops" | "meadow:limestone_slab_from_limestone_stonecutting" | "nethervinery:crimson_wine_rack_mid" | "chipped_express:stonecutting_chipped_oak_horizontal_lined_glass_from_glass" | "bloomingnature:baobab_door" | "conditional:decorative_blocks/wood_cutter/pine_beam_woodcutter" | "compressedblocks:shaped_septuple_crated_detector_rail" | "compressedblocks:shapeless_triple_crated_white_dye" | "compressedblocks:shaped_quadruple_crated_end_rod" | "compressedblocks:shaped_c9_slime_block" | "moa_decor_bath:toallascafes_1" | "compressedblocks:shapeless_mega_crated_sculk_vein" | "chipped_express:stonecutting_chipped_bundled_white_carpet_from_white_carpet" | "pamhc2foodextended:grapefruitsmoothieitem" | "chipped_express:stonecutting_chipped_stringed_light_blue_wool_from_light_blue_wool" | "snowyspirit:glow_lights_light_blue" | "compressedblocks:shaped_mega_crated_brown_mushroom" | "botanypots:farming_crossing/crop/pamhc2treesorange_sapling" | "conditional:bloomingnature/wood_cutter/baobab_slabs_woodcutter" | "quark:building/crafting/stairs/white_shingles_stairs" | "railways:crafting/palettes/dyeing_8x/light_blue_locometal_boiler" | "compressedblocks:shapeless_mega_crated_vine" | "moa_decor_art:aerosolrosa_1" | "compressedblocks:shaped_c4_cherry_planks" | "conditional:create/mixing/jellie_wine_mixing" | "mcwfurnituresbop:hellbark_counter" | "chipped_express:stonecutting_chipped_small_gray_stained_glass_from_gray_stained_glass" | "railways:sequenced_assembly/track_create_dd_rubber_narrow" | "compressedblocks:shaped_triple_crated_cherry_sapling" | "compressedblocks:shapeless_c3_mud" | "botanypots:botanypots/crafting/brown_terracotta_compact_hopper_botany_pot" | "delightful:food/deluxe_cheeseburger_from_milk" | "luphieclutteredmod:polaroids_a_recipe" | "mcwlights:lime_ceiling_light" | "sophisticatedstorage:diamond_shulker_from_diamond_chest" | "compressedblocks:shapeless_giga_crated_purple_dye" | "moa_decor_science:tubosensayonegro_1" | "minecraft:bucket" | "supplementaries:soap/globe_sepia" | "farmersdelight:cutting/crimson_hanging_sign" | "quark:building/crafting/vertslabs/blackstone_bricks_vertical_slab_revert" | "chipped_express:stonecutting_chipped_rectangle_white_carpet_from_white_carpet" | "create:compat/supplementaries/milling/flax" | "meadow:wood_cutter/warped/warped_fence_woodcutter" | "create_confectionery:white_chocolate_candy_3_recipe" | "create:crafting/kinetics/white_seat_from_other_seat" | "quark:building/crafting/birch_post" | "quark:building/crafting/vertslabs/black_shingles_vertical_slab_revert" | "mcwfurnituresbop:redwood_double_drawer" | "vinery:acacia_wine_rack_mid" | "chipped_express:stonecutting_chipped_checkered_mossy_cobblestone_tiles_from_mossy_cobblestone" | "create:exposed_copper_tile_slab" | "compressedblocks:shapeless_crated_totem_of_undying" | "chipped_express:stonecutting_chipped_wickered_spruce_planks_from_spruce_planks" | "moa_decor_bath:lcerezosc_1" | "luphieclutteredmod:luphie_pink_shelf_cabinet_recipe" | "chipped_express:stonecutting_chipped_simple_purpur_block_pillar_from_purpur_block" | "chipped_express:stonecutting_chipped_layed_calcite_bricks_from_calcite" | "chipped_express:stonecutting_chipped_hexagonical_lime_terracotta_from_lime_terracotta" | "minecraft:rabbit_stew_from_brown_mushroom" | "moa_decor_garden_:bebedero_1" | "compressedblocks:shaped_mega_crated_salmon" | "mcwbridges:spruce_rope_bridge_stair" | "mcwfurnituresbop:hellbark_striped_chair" | "create:cutting/stripped_jungle_wood" | "compressedblocks:shaped_sextuple_crated_feather" | "compressedblocks:shapeless_mega_crated_pumpkin_seeds" | "chipped_express:stonecutting_chipped_polished_raw_gold_block_from_raw_gold_block" | "mighty_mail:acacia_mail_box" | "pamhc2foodextended:cookedtofabbititem_campfire" | "moa_decor_lights:faroltriple_n_1" | "mcwbridges:jungle_log_bridge_stair" | "gemsnjewels:stacked_pale_diamond_slab" | "pamhc2crops:roastedscallionitem_campfire" | "compressedblocks:shaped_c0_mangrove_planks" | "compressedblocks:shaped_c9_birch_log" | "compressedblocks:shapeless_c1_stripped_cherry_log" | "mcwfurnitures:stripped_oak_glass_table" | "candlelight:dark_oak_cabinet" | "pamhc2foodextended:kiwipieitem" | "mcwroofs:blackstone_attic_roof" | "mcwroofs:black_lower_roof" | "quark:building/crafting/slabs/yellow_shingles_slab" | "vinery:cherry_slab" | "mcwroofs:gutter_base_blue" | "chipped_express:stonecutting_chipped_tiled_mossy_cobblestone_from_mossy_cobblestone" | "compressedblocks:shapeless_c5_bamboo_mosaic" | "chipped_express:stonecutting_chipped_black_concrete_pillar_from_black_concrete" | "chipped_express:stonecutting_chipped_minimized_magenta_glazed_terracotta_from_magenta_glazed_terracotta" | "minecraft:warped_pressure_plate" | "compressedblocks:shapeless_c0_jungle_log" | "mcwfences:railing_stone_brick_wall_stonecutter" | "chipped_express:stonecutting_chipped_crossed_mangrove_planks_from_mangrove_planks" | "mcwtrpdoors:oak_four_panel_trapdoor" | "luphieclutteredmod:luphie_wedding_arch_recipe" | "chipped_express:stonecutting_chipped_red_concrete_panel_from_red_concrete" | "botanypots:pamhc2crops/crop/alfalfa" | "chipped_express:stonecutting_chipped_stacked_warped_planks_from_warped_planks" | "mcwfurnitures:jungle_modern_desk" | "chipped_express:stonecutting_chipped_wickered_oak_planks_from_oak_planks" | "chipped_express:stonecutting_chipped_pillar_sandstone_bricks_from_sandstone" | "chipped_express:stonecutting_chipped_offset_mossy_cobblestone_bricks_from_mossy_cobblestone" | "sophisticatedbackpacks:advanced_compacting_upgrade" | "create:cutting/compat/ecologics/stripped_azalea_log" | "chipped_express:stonecutting_chipped_square_brown_stained_glass_from_brown_stained_glass" | "compressedblocks:shaped_quadruple_crated_cod" | "compressedblocks:shapeless_c1_cut_sandstone" | "compressedblocks:shapeless_crated_seagrass" | "storagedrawers:iron_storage_upgrade" | "supplementaries:sconce_ender" | "utilitix:birch_shulker_boat_with_shell" | "cookingforblockheads:dye_pink_oven" | "mcwroofs:andesite_lower_roof" | "moa_decor_bath:bataazul_1" | "pamhc2crops:grapeseeditem" | "moa_decor_cookery:bolsadesemillas_1" | "createdeco:short_dusk_brick_stairs" | "bloomingnature:baobab_hanging_sign" | "create_confectionery:ruby_chocolate_recipe" | "chipped_express:stonecutting_chipped_patched_pink_wool_from_pink_wool" | "chipped_express:stonecutting_chipped_small_light_gray_terracotta_tiles_from_light_gray_terracotta" | "cosmeticarmoursmod:royal_tunic_light_grey_2_white" | "compressedblocks:shapeless_quintuple_crated_glowstone_dust" | "railways:sequenced_assembly/track_byg_rainbow_eucalyptus_narrow" | "create:crafting/materials/raw_zinc" | "gemsnjewels:forge_kunzite_set_gold_ring" | "minecraft:spruce_fence" | "chipped_express:stonecutting_chipped_tiled_bordered_ancient_debris_from_ancient_debris" | "create:cutting/compat/ecologics/coconut_log" | "snowyspirit:compressedblocks/sled_c2_acacia" | "mcwfurnituresbop:redwood_bookshelf" | "compressedblocks:shapeless_c4_bamboo_planks" | "framedblocks:framing_saw/framed_torch" | "pamhc2foodextended:chipsandsalsaitem" | "pamhc2foodextended:schnitzelitem" | "corail_woodcutter:woodcutting/birch_stairs_from_birch_logs" | "botanypots:botania/crop/white_mystical_flower" | "quark:tweaks/crafting/gray_glass" | "minecraft:dried_kelp_from_smoking" | "compressedblocks:shaped_septuple_crated_activator_rail" | "botania:gray_floating_flower" | "botania:petal_light_blue_double" | "chipped_express:stonecutting_chipped_tiny_layered_quartz_block_slabs_from_quartz_block" | "bloomingnature:flower_box" | "chipped_express:stonecutting_chipped_etched_andesite_bricks_from_andesite" | "pamhc2crops:strawberryseeditem" | "botania:metamorphic_mesa_cobblestone_slab" | "chipped_express:stonecutting_chipped_ornate_purpur_block_pillar_from_purpur_block" | "meadow:emerald_from_blasting_alpine_emerald_ore" | "pamhc2crops:riceseeditem" | "compressedblocks:shaped_c7_stripped_mangrove_log" | "refinedstorage:coloring_recipes/cyan_controller" | "mcwbridges:stonecutter_balustrade_deepslate_tiles_bridge" | "compressedblocks:shapeless_crated_dark_oak_sapling" | "botanypots:farming_crossing/crop/pamhc2treesacorn_sapling" | "chipped_express:stonecutting_chipped_sheet_emerald_block_from_emerald_block" | "quark:building/stonecutting/stonevariants/myalite_bricks_slab_polished_stonecutting" | "compressedblocks:shaped_double_crated_white_dye" | "chipped_express:stonecutting_chipped_light_gray_terracotta_column_from_light_gray_terracotta" | "compressedblocks:shapeless_double_crated_pink_tulip" | "pamhc2foodcore:glowberrypopsicleitem" | "compressedblocks:shapeless_c2_bamboo_planks" | "chipped_express:stonecutting_chipped_decorated_lime_glazed_terracotta_from_lime_glazed_terracotta" | "chipped_express:stonecutting_chipped_ivy_vine_from_vine" | "botania:abstruse_platform" | "pamhc2foodcore:meatloafitem" | "mcwfences:crimson_stockade_fence" | "railways:crafting/palettes/dyeing_8x/purple_copper_wrapped_locometal_boiler" | "minecraft:orange_cushion_from_orange_dye" | "compressedblocks:shaped_giga_crated_light_gray_carpet" | "moa_decor_lights:lm_nrosa_1" | "chipped_express:stonecutting_chipped_classic_acacia_trapdoor_from_acacia_trapdoor" | "corail_woodcutter:woodcutting/tropicraft/palm_pressure_plate_from_palm_logs" | "chipped_express:stonecutting_chipped_blocky_white_carpet_from_white_carpet" | "compressedblocks:shapeless_c3_oak_planks" | "compressedblocks:shapeless_c3_oxidized_cut_copper" | "mcwwindows:dark_oak_plank_window" | "compressedblocks:shapeless_double_crated_name_tag" | "compressedblocks:shapeless_mega_crated_seagrass" | "createdeco:short_dusk_brick_slab_from_tiled_dusk_bricks_stonecutting" | "create:crimsite_from_stone_types_crimsite_stonecutting" | "cosmeticarmoursmod:ghillie_suit_leggings_rec" | "compressedblocks:shapeless_c2_sandstone" | "mcwroofs:crimson_steep_roof" | "chipped_express:stonecutting_chipped_sheet_waxed_copper_block_from_waxed_copper_block" | "create:compat/projectvibrantjourneys/cutting/stripped_maple_log" | "chipped_express:stonecutting_chipped_borderless_bricks_bricks_from_bricks" | "sophisticatedstorage:jungle_chest_from_quark_jungle_chest" | "chipped_express:stonecutting_chipped_woven_green_stained_glass_pane_from_green_stained_glass_pane" | "chipped_express:stonecutting_chipped_bordered_mossy_cobblestone_from_mossy_cobblestone" | "chipped_express:stonecutting_chipped_layed_blue_ice_bricks_from_blue_ice" | "botanypots:botanypots/crafting/pink_glazed_terracotta_hopper_botany_pot" | "mcwbridges:end_stone_bricks_bridge" | "pamhc2foodextended:gourmetbeefpattyitem" | "compressedblocks:shaped_quintuple_crated_porkchop" | "mcwroofs:light_gray_terracotta_steep_roof" | "compressedblocks:shaped_giga_crated_lime_dye" | "compressedblocks:shapeless_crated_glow_ink_sac" | "moa_decor_bath:toallamagentacolg_1" | "minecraft:gray_terracotta" | "compressedblocks:shapeless_mega_crated_golden_apple" | "chipped_express:stonecutting_chipped_rounded_granite_bricks_from_granite" | "minecraft:netherite_boots_smithing" | "mcwroofs:mangrove_planks_upper_steep_roof" | "railways:sequenced_assembly/track_tfc_palm_wide" | "gemsnjewels:create/create_crushing_citrine_deepslate_ore" | "compressedblocks:shapeless_septuple_crated_chicken" | "railways:crafting/palettes/dyeing_1x/brown_plated_locometal" | "compressedblocks:shaped_quadruple_crated_anvil" | "minecraft:cooked_beef_from_smoking" | "railways:crafting/palettes/dyeing_1x/light_blue_copper_wrapped_locometal" | "createdeco:long_dean_brick_stairs_from_short_dean_brick_stairs_stonecutting" | "pamhc2foodextended:homestylelunchitem" | "pamhc2foodextended:mozzerellasticksitem" | "create:crafting/appliances/clipboard_clear" | "mcwwindows:dark_oak_window2" | "botanypots:botanypots/crafting/light_blue_glazed_terracotta_compact_hopper_botany_pot" | "chipped_express:stonecutting_chipped_triangular_light_blue_terracotta_from_light_blue_terracotta" | "compressedblocks:shapeless_c4_warped_nylium" | "farmersdelight:cutting/rice_panicle" | "chipped_express:stonecutting_chipped_sign_stripped_jungle_log_from_stripped_jungle_log" | "supplementaries:candle_holders/candle_holder_cyan" | "delightful:knives/smelting/silver_thermal" | "chipped_express:stonecutting_chipped_brick_bordered_purpur_block_from_purpur_block" | "chipped_express:stonecutting_chipped_windowed_jungle_trapdoor_from_jungle_trapdoor" | "chipped_express:stonecutting_chipped_inscribed_raw_gold_block_from_raw_gold_block" | "quark:building/crafting/acacia_leaf_carpet" | "chipped_express:stonecutting_chipped_slotted_bamboo_trapdoor_from_bamboo_trapdoor" | "chipped_express:stonecutting_chipped_offset_red_nether_bricks_bricks_from_red_nether_bricks" | "botanypots:minecraft/crop/sunflower" | "chipped_express:stonecutting_chipped_layed_blackstone_bricks_from_blackstone" | "mcwroofs:brown_terracotta_roof" | "luphieclutteredmod:glow_flower_recipe" | "chipped_express:stonecutting_chipped_pacman_lily_pad_from_lily_pad" | "chipped_express:stonecutting_chipped_stacked_deepslate_bricks_from_deepslate" | "chipped_express:stonecutting_chipped_boarded_crimson_door_from_crimson_door" | "compressedblocks:shaped_mega_crated_ghast_tear" | "minecraft:mossy_stone_bricks_from_vine" | "compressedblocks:shapeless_c6_warped_nylium" | "create:milling/fern" | "aquaculture:nether_star_hook" | "chipped_express:stonecutting_chipped_magma_block_pillar_top_from_magma_block" | "botania:orechid/deepslate_redstone_ore" | "compressedblocks:shaped_quintuple_crated_purple_carpet" | "create:haunting/haunted_bell" | "mcwfences:railing_andesite_wall_stonecutter" | "compressedblocks:shapeless_giga_crated_red_mushroom" | "meadow:wood_cutter/pine/pine_fencegate_woodcutter" | "quark:building/crafting/compressed/bonded_leather_uncompress" | "quark:building/stonecutting/vertslabs/purple_shingles_vertical_slab_stonecutter2" | "minecraft:black_dye" | "compressedblocks:shapeless_octuple_crated_feather" | "compressedblocks:shaped_double_crated_red_dye" | "camera:album" | "create:cut_granite_wall_from_stone_types_granite_stonecutting" | "compressedblocks:shaped_septuple_crated_painting" | "conditional:regions_unexplored/wood_cutter/joshua_slabs_woodcutter" | "mcwbridges:oak_rail_bridge" | "compressedblocks:shaped_quadruple_crated_vine" | "createdeco:cracked_dusk_brick_slab" | "botania:slab_recombine/metamorphic_plains_bricks" | "quark:building/crafting/shingles/blue_shingles" | "chipped_express:stonecutting_chipped_edged_stripped_warped_stem_from_stripped_warped_stem" | "snowyspirit:compressedblocks/sled_c1_mangrove" | "nethersdelight:cooking/grilled_strider" | "create:deploying/waxed_cut_copper_stairs_from_adding_wax" | "chipped_express:stonecutting_chipped_polished_gilded_blackstone_from_gilded_blackstone" | "createdeco:tiled_dean_brick_stairs_from_dean_bricks_stonecutting" | "create:polished_cut_scoria_wall_from_stone_types_scoria_stonecutting" | "brewery:brewing/haley_beer" | "mcwdoors:oak_bamboo_door" | "bloomingnature:laterit_brick_wall_from_laterit_bricks_stonecutting" | "chipped_express:stonecutting_chipped_bordered_gilded_blackstone_from_gilded_blackstone" | "chipped_express:stonecutting_chipped_purple_concrete_tiles_from_purple_concrete" | "create:rose_quartz_tiles_from_polished_rose_quartz_stonecutting" | "compressedblocks:shapeless_c0_bone_block" | "compressedblocks:shapeless_quintuple_crated_purple_dye" | "chipped_express:stonecutting_chipped_stacked_waxed_copper_block_from_waxed_copper_block" | "botania:metamorphic_plains_stone_wall" | "chipped_express:stonecutting_chipped_cobbled_red_sandstone_from_red_sandstone" | "quark:building/stonecutting/stonevariants/tuff_bricks_polished_stonecutting" | "compressedblocks:shapeless_c9_lapis_block" | "corail_woodcutter:woodcutting/biomesoplenty/willow_door_from_willow_logs" | "byg:blueberry_pie_from_slices" | "biomesoplenty:jacaranda_sign" | "chipped_express:stonecutting_chipped_crimson_roots_bud_from_crimson_roots" | "chipped_express:stonecutting_chipped_smooth_ringed_diorite_from_diorite" | "delightful:knives/smelting/bone/bone_meal_from_smelting_helmet" | "create:cutting/compat/quark/stripped_azalea_log" | "refinedstorage:crafting_grid/cyan_crafting_grid" | "botania:stonecutting/metamorphic_fungal_cobblestone_to_metamorphic_fungal_cobblestone_wall" | "chipped_express:stonecutting_chipped_hewn_warped_planks_from_warped_planks" | "chipped_express:stonecutting_chipped_polished_mossy_cobblestone_from_mossy_cobblestone" | "mcwbridges:rope_dark_oak_bridge" | "waystones:cyan_sharestone" | "supplementaries:item_shelf" | "wands:magic_bag_3" | "chipped_express:stonecutting_chipped_rusted_cyan_concrete_from_cyan_concrete" | "handcrafted:terracotta_plate" | "wands:magic_bag_2" | "wands:magic_bag_1" | "compressedblocks:shapeless_c4_dark_oak_log" | "vinery:cherry_fence_gate" | "mcwroofs:light_blue_terracotta_roof" | "create:cut_deepslate_brick_wall_from_stone_types_deepslate_stonecutting" | "mcwfurnitures:stripped_warped_cupboard_counter" | "gemsnjewels:stacked_tanzanite_slab" | "botania:mana_infusion/cherry_log_to_oak_log" | "chipped_express:stonecutting_chipped_cracked_flat_calcite_tiles_from_calcite" | "moa_decor_toys:gatopersa_1" | "moa_decor_art:guitarraelectricaazulclara_1" | "chipped_express:stonecutting_chipped_cross_haired_yellow_carpet_from_yellow_carpet" | "chipped_express:stonecutting_chipped_purple_concrete_bricks_from_purple_concrete" | "quark:building/stonecutting/stonevariants/limestone_pillar_stonecutter" | "farmersdelight:cutting/cooked_mutton" | "mcwfurnitures:dark_oak_striped_chair" | "minecraft:granite_slab_from_granite_stonecutting" | "botania:metamorphic_desert_stone_stairs" | "compressedblocks:shaped_c9_sculk" | "railways:mechanical_crafting/magenta_locometal_boiler" | "chipped_express:stonecutting_chipped_harsh_quilted_gray_carpet_from_gray_carpet" | "macawsroofsbop:dead_planks_top_roof" | "meadow:limestone" | "minecraft:golden_sword" | "moa_decor_toys:warden_1" | "conditional:regions_unexplored/wood_cutter/maple_planks_woodcutter" | "quark:building/stonecutting/stonevariants/jasper_bricks_slab_polished_stonecutting" | "botanypots:pamhc2crops/crop/candleberry" | "compressedblocks:shaped_c7_red_sand" | "create:polished_cut_granite_slab_from_stone_types_granite_stonecutting" | "chipped_express:stonecutting_chipped_unamused_lapis_block_from_lapis_block" | "chipped_express:stonecutting_chipped_pillar_dark_prismarine_bricks_from_dark_prismarine" | "createdeco:tiled_pearl_bricks_from_short_pearl_bricks_stonecutting" | "compressedblocks:shaped_c4_nether_gold_ore" | "createdeco:brass_hull_from_stonecutting" | "pamhc2foodextended:lemonjellytoastitem" | "create:compat/silentsgems/crushing/apatite_ore" | "quark:tools/smithing/rune_smithing_light_blue" | "quark:building/stonecutting/stairs/shingles_stairs_stonecutter2" | "minecraft:furnace_minecart" | "mcwroofs:pink_concrete_steep_roof" | "compressedblocks:shaped_octuple_crated_paper" | "chipped_express:stonecutting_chipped_tiny_layered_diorite_bricks_from_diorite" | "chipped_express:stonecutting_chipped_cobbled_lodestone_from_lodestone" | "railways:sequenced_assembly/track_byg_redwood_wide" | "mcwroofs:spruce_planks_top_roof" | "cosmeticarmoursmod:christmas_elf_hat_red_rec" | "botania:glimmering_livingwood" | "compressedblocks:shaped_sextuple_crated_milk_bucket" | "luphieclutteredmod:luphie_general_store_cabinet_recipe" | "storagedrawers:warped_half_drawers_4" | "create:crafting/materials/zinc_block_from_compacting" | "storagedrawers:warped_half_drawers_1" | "create:crafting/kinetics/red_valve_handle_from_other_valve_handle" | "storagedrawers:warped_half_drawers_2" | "moa_decor_art:tecladomusical_1" | "create:crafting/appliances/netherite_diving_boots_from_netherite" | "chipped_express:stonecutting_chipped_tiny_layered_snow_block_slabs_from_snow_block" | "chipped_express:stonecutting_chipped_polished_warped_planks_from_warped_planks" | "quark:world/crafting/panes/green_corundum" | "create_confectionery:hot_chocolate_bottle_recipe" | "pamhc2foodextended:blackberryjuiceitem" | "pamhc2foodcore:muttonjerkyitem" | "moa_decor_toys:ajolotecafe_1" | "moa_decor_lights:vt_drobleosc_1" | "chipped_express:stonecutting_chipped_barred_mangrove_door_from_mangrove_door" | "mcwtrpdoors:acacia_barred_trapdoor" | "minecraft:purple_cushion_from_purple_dye" | "snowyspirit:sled_birch" | "chipped_express:stonecutting_chipped_tiled_orange_stained_glass_pane_from_orange_stained_glass_pane" | "createdeco:short_pearl_brick_stairs_from_long_pearl_brick_stairs_stonecutting" | "railways:stonecutting/palettes/cycling/brown_flat_slashed_locometal" | "pamhc2foodcore:sweetberrypieitem" | "botania:stonecutting/sunny_quartz_to_sunny_quartz_slab" | "minecraft:chiseled_stone_bricks" | "supplementaries:compressedblocks/sign_post_c6_acacia" | "quark:building/crafting/vertslabs/mangrove_vertical_slab_revert" | "quark:building/crafting/chests/chest_revert" | "corail_woodcutter:oak_woodcutter" | "mcwfences:railing_quartz_wall_stonecutter" | "chipped_express:stonecutting_chipped_engraved_purpur_block_from_purpur_block" | "beautify:candelabra_light_blue" | "pamhc2foodextended:cornbreaditem" | "gemsnjewels:create/create_crushing_tanzanite_deepslate_ore" | "compressedblocks:shaped_octuple_crated_porkchop" | "compressedblocks:shaped_quadruple_crated_bone" | "vinery:flower_box" | "chipped_express:stonecutting_chipped_chipped_stripped_acacia_log_from_stripped_acacia_log" | "chipped_express:stonecutting_chipped_detailed_crimson_planks_from_crimson_planks" | "moa_decor_garden_:maceta_tarbustoseco_1" | "luphieclutteredmod:polaroid_camera_recipe" | "botania:pool_minecart" | "compressedblocks:shaped_octuple_crated_birch_sapling" | "chipped_express:stonecutting_chipped_golden_cherry_oak_leaves_from_oak_leaves" | "chipped_express:stonecutting_chipped_circular_brown_stained_glass_pane_from_brown_stained_glass_pane" | "sophisticatedstorage:magenta_shulker_box_to_sophisticated" | "compressedblocks:shaped_double_crated_orange_carpet" | "bloomingnature:chestnut_planks" | "mcwlights:pink_ceiling_light" | "railways:sequenced_assembly/track_tfc_spruce" | "chipped_express:stonecutting_chipped_heavy_warped_door_from_warped_door" | "botania:mana_infusion/dandelion_to_poppy" | "createdeco:short_dusk_brick_stairs_from_dusk_brick_stairs_stonecutting" | "minecraft:hay_block" | "framedblocks:framing_saw/framed_flat_stacked_slope_panel_corner" | "chipped_express:stonecutting_chipped_tiny_brick_bordered_prismarine_from_prismarine" | "compressedblocks:shaped_mega_crated_beetroot" | "chipped_express:stonecutting_chipped_rough_mossy_stone_bricks_from_mossy_stone_bricks" | "mcwbridges:bamboo_bridge_stair_recycle" | "compressedblocks:shapeless_sextuple_crated_orange_tulip" | "railways:crafting/smokestack_coalburner" | "framedblocks:framed_stairs" | "compressedblocks:shaped_octuple_crated_brown_dye" | "compressedblocks:shaped_quadruple_crated_book" | "biomesoplenty:cut_white_sandstone_slab_from_cut_white_sandstone_stonecutting" | "quark:world/crafting/woodsets/azalea/stripped_wood" | "mcwfurnituresbop:palm_bookshelf_drawer" | "compressedblocks:shaped_quadruple_crated_white_tulip" | "compressedblocks:shaped_quadruple_crated_pink_carpet" | "byg:crimson_berry_pie" | "bloomingnature:dye_pink_from_freesia_pink" | "mcwfences:mangrove_highley_gate" | "playershops:crimson_player_shop" | "chipped_express:stonecutting_chipped_layed_obsidian_bricks_from_obsidian" | "moa_decor_holidays:estrella_navidena_1" | "create:cut_calcite_slab" | "compressedblocks:shapeless_giga_crated_orange_carpet" | "quark:world/stonecutting/stairs/permafrost_stairs_stonecutter" | "botania:red_petal_block" | "minecraft:cut_copper" | "moa_decor_holidays:calabaza_esqueleto_1" | "handcrafted:acacia_drawer" | "compressedblocks:shaped_mega_crated_phantom_membrane" | "botania:metamorphic_plains_bricks_stairs" | "compressedblocks:shapeless_c0_diamond_block" | "minecraft:smelting_cookedgroundfishitem" | "quark:building/stonecutter/vertslabs/cut_copper_vertical_slab_from_cut_copper" | "botania:terra_plate/terrasteel_ingot" | "corail_woodcutter:woodcutting/cherry_fence_from_cherry_logs" | "chipped_express:stonecutting_chipped_pillar_magma_block_bricks_from_magma_block" | "chipped_express:stonecutting_chipped_sifted_soul_sand_from_soul_sand" | "mcwtrpdoors:dark_oak_beach_trapdoor" | "compressedblocks:shapeless_quadruple_crated_white_tulip" | "compressedblocks:shapeless_octuple_crated_name_tag" | "chipped_express:stonecutting_chipped_layed_smooth_stone_bricks_from_smooth_stone" | "compressedblocks:shapeless_c2_honey_block" | "chipped_express:stonecutting_chipped_overlapping_packed_mud_tiles_from_packed_mud" | "chipped_express:stonecutting_chipped_birch_planks_panel_from_birch_planks" | "chipped_express:stonecutting_chipped_angry_calcite_from_calcite" | "compressedblocks:shaped_quadruple_crated_poisonous_potato" | "delightful:knives/fiery_iron_knife" | "createdeco:green_zinc_lamp" | "chipped_express:stonecutting_chipped_smooth_inlayed_snow_block_from_snow_block" | "mcwfences:blackstone_grass_topped_wall" | "aquaculture:diamond_hook" | "chipped_express:stonecutting_chipped_patched_purple_carpet_from_purple_carpet" | "chipped_express:stonecutting_chipped_netherrack_pillar_top_from_netherrack" | "mcwfurnitures:birch_modern_desk" | "copycats:stonecutting/copycat_stone_pressure_plate" | "create:exposed_copper_shingle_stairs_from_exposed_copper_shingles_stonecutting" | "chipped_express:stonecutting_chipped_brick_bordered_mud_from_mud" | "railways:crafting/palettes/dyeing_8x/blue_brass_wrapped_locometal_boiler" | "chipped_express:stonecutting_chipped_purple_glazed_terracotta_pillar_top_from_purple_glazed_terracotta" | "minecraft:prismarine_brick_stairs" | "mcwroofs:crimson_planks_attic_roof" | "compressedblocks:shaped_sextuple_crated_blue_dye" | "playdate:smiley_banner" | "conditional:bloomingnature/wood_cutter/swamp_cypress_stairs_woodcutter" | "supplementaries:sconce_soul" | "compressedblocks:shapeless_mega_crated_dandelion" | "quark:building/stonecutting/stonevariants/polished_dripstone_slab_stonecutter2" | "framedblocks:framing_saw/framed_prism_corner" | "railways:crafting/palettes/dyeing_1x/light_blue_locometal_smokebox" | "chipped_express:stonecutting_chipped_nailed_crimson_planks_from_crimson_planks" | "quark:building/crafting/chests/oak_chest" | "createdeco:magenta_placard_from_dyeing" | "railways:crafting/wooden_headstock_link_and_pin" | "framedblocks:framed_divided_slab_rotate_to_framed_divided_panel_horizontal" | "chipped_express:stonecutting_chipped_stacked_mud_bricks_from_mud" | "compressedblocks:shaped_c2_mud" | "botania:tornado_rod" | "quark:building/stonecutting/green_shingles_stonecutter2" | "quark:building/stonecutting/vertslabs/prismarine_vertical_slab_stonecutter" | "chipped_express:stonecutting_chipped_acacia_barrel_from_barrel" | "chipped_express:stonecutting_chipped_leafy_mangrove_trapdoor_from_mangrove_trapdoor" | "minecraft:netherite_block" | "create:oxidized_copper_shingle_slab" | "chipped_express:stonecutting_chipped_stacked_magma_block_bricks_from_magma_block" | "chipped_express:stonecutting_chipped_prismal_gilded_blackstone_remnants_from_gilded_blackstone" | "gemsnjewels:spinel_set_gold_crown" | "meadow:limestone_slab" | "corail_woodcutter:woodcutting/oak_button_from_oak_planks" | "railways:sequenced_assembly/track_quark_ancient" | "railways:crafting/palettes/dyeing_1x/white_brass_wrapped_locometal_boiler" | "create:cut_dripstone_brick_stairs_from_stone_types_dripstone_stonecutting" | "refinedstorage:coloring_recipes/purple_disk_manipulator" | "chipped_express:stonecutting_chipped_cobbled_basalt_from_basalt" | "moa_decor_science:tubosensayomagenta_1" | "quark:building/crafting/stonevariants/myalite_bricks" | "chipped_express:stonecutting_chipped_duh_netherrack_from_netherrack" | "botania:lime_shiny_flower" | "meadow:wood_cutter/warped/warped_sign_woodcutter" | "quark:building/crafting/vertslabs/dark_prismarine_vertical_slab_revert" | "chipped_express:stonecutting_chipped_smooth_inlayed_andesite_from_andesite" | "minecraft:diamond" | "chipped_express:stonecutting_chipped_nether_bricks_pillar_top_from_nether_bricks" | "mcwroofs:gray_upper_lower_roof" | "chipped_express:stonecutting_chipped_prismarine_bricks_from_prismarine" | "chipped_express:stonecutting_chipped_runic_carved_lapis_block_from_lapis_block" | "botanypots:botania/crop/cyan_mystical_flower" | "chipped_express:stonecutting_chipped_emerald_block_panels_from_emerald_block" | "railways:crafting/palettes/dyeing_8x/white_iron_wrapped_locometal_boiler" | "botania:metamorphic_mesa_bricks" | "luphieclutteredmod:rubiks_cube_recipe_alt" | "botania:mossy_livingrock_bricks_stairs" | "chipped_express:stonecutting_chipped_windmill_black_carpet_from_black_carpet" | "createdeco:long_dusk_brick_stairs_from_short_dusk_brick_stairs_stonecutting" | "compressedblocks:shaped_double_crated_lead" | "create:polished_cut_tuff_wall" | "quark:building/stonecutting/vertslabs/blackstone_bricks_vertical_slab_stonecutter" | "create:polished_cut_limestone_wall" | "corail_woodcutter:woodcutting/oak_boat_from_oak_logs" | "createdeco:dusk_brick_stairs" | "compressedblocks:shapeless_c9_waxed_exposed_copper" | "cosmeticarmoursmod:orange_archer_attire_helmet_rec" | "mcwdoors:warped_japanese_door" | "mcwfurnituresbop:hellbark_end_table" | "exoticbirds:pigeon_backpack" | "mcwfurnitures:stripped_warped_bookshelf_drawer" | "supplementaries:sconce_green" | "supplementaries:soap" | "compressedblocks:shaped_c2_stripped_cherry_log" | "mcwroofs:acacia_planks_attic_roof" | "botania:fork_light_relay" | "moa_decor_holidays:papelpicado_cian_1" | "bloomingnature:larch_hanging_sign" | "macawsroofsbop:palm_top_roof" | "mcwbridges:stonecutter_orange_sandstone_bridge" | "chipped_express:stonecutting_chipped_cobbled_quartz_block_from_quartz_block" | "moa_decor_garden_:bancaacacia_1" | "botania:metamorphic_forest_bricks_wall" | "moa_decor_garden_:podadora_cesped_1" | "chipped_express:stonecutting_chipped_stacked_clay_bricks_from_clay" | "compressedblocks:shaped_septuple_crated_lightning_rod" | "chipped_express:stonecutting_chipped_inlayed_glowstone_from_glowstone" | "chipped_express:stonecutting_chipped_fine_netherrack_pillar_from_netherrack" | "luphieclutteredmod:luphie_cluttered_havana_cabinet_recipe" | "nethervinery:crimson_barrel" | "compressedblocks:shaped_sextuple_crated_orange_tulip" | "minecraft:acacia_hanging_sign" | "sophisticatedstorage:dark_oak_chest" | "chipped_express:stonecutting_chipped_iron_barred_cherry_trapdoor_from_cherry_trapdoor" | "compressedblocks:shapeless_octuple_crated_birch_sapling" | "moa_decor_cookery:barrica_1" | "create:small_limestone_brick_slab" | "botania:metamorphic_fungal_stone_stairs" | "pamhc2foodextended:jambalayaitem" | "chipped_express:stonecutting_chipped_cracked_disordered_amethyst_block_bricks_from_amethyst_block" | "mcwdoors:birch_tropical_door" | "chipped_express:stonecutting_chipped_tiny_layered_end_stone_slabs_from_end_stone" | "corail_woodcutter:woodcutting/biomesoplenty/magic_stairs_from_magic_logs" | "mcwtrpdoors:bamboo_glass_trapdoor" | "create:crafting/kinetics/mechanical_harvester" | "chipped_express:stonecutting_chipped_brick_bordered_redstone_block_from_redstone_block" | "quark:building/stonecutting/stairs/gray_shingles_stairs_stonecutter" | "compressedblocks:shapeless_c7_oxidized_cut_copper" | "quark:building/stonecutting/vertslabs/white_shingles_vertical_slab_stonecutter2" | "moa_decor_cookery:latasdeatun_1" | "minecraft:sponge" | "chipped_express:stonecutting_chipped_damaged_jungle_log_from_jungle_log" | "minecraft:quartz_stairs" | "vinery:cherry_fence" | "railways:sequenced_assembly/track_natures_spirit_fir_wide" | "railways:stonecutting/palettes/cycling/light_blue_locometal_pillar" | "vinery:straw_hat" | "farmersdelight:full_tatami_mat_from_halves" | "compressedblocks:shaped_double_crated_red_mushroom" | "chipped_express:stonecutting_chipped_carved_calcite_from_calcite" | "botanypots:pamhc2crops/crop/kenaf" | "pamhc2trees:roastedchestnutitem_campfire" | "chipped_express:stonecutting_chipped_tiled_packed_ice_from_packed_ice" | "compressedblocks:shaped_c3_spruce_planks" | "chipped_express:stonecutting_chipped_edged_magma_block_bricks_from_magma_block" | "createdeco:long_dusk_brick_stairs" | "create:small_calcite_brick_slab_recycling" | "quark:building/crafting/walls/dripstone_bricks_wall" | "compressedblocks:shapeless_crated_lime_carpet" | "gemsnjewels:stacked_emerald_slab" | "chipped_express:stonecutting_chipped_crying_raw_iron_block_from_raw_iron_block" | "cookingforblockheads:black_kitchen_floor" | "gemsnjewels:create/create_crushing_topaz_ore" | "mcwfurnitures:stripped_dark_oak_bookshelf_drawer" | "exoticbirds:phoenix_egg_from_nether_phoenix" | "quark:building/stonecutter/vertslabs/waxed_oxidized_cut_copper_vertical_slab_from_waxed_oxidized_copper" | "candlelight:drawer" | "chipped_express:stonecutting_chipped_ribbled_brown_carpet_from_brown_carpet" | "mcwfurnitures:stripped_warped_counter" | "compressedblocks:shapeless_c8_stripped_oak_log" | "delightful:integration/aether/blueberry_sack" | "meadow:stove_tiles_bench" | "compressedblocks:shaped_giga_crated_campfire" | "chipped_express:stonecutting_chipped_enclosed_birch_planks_from_birch_planks" | "compressedblocks:shapeless_c8_birch_planks" | "railways:mechanical_crafting/blue_brass_wrapped_locometal_boiler" | "storagedrawers:controller" | "refinedstorage:16k_storage_disk_from_storage_housing" | "chipped_express:stonecutting_chipped_carved_packed_ice_from_packed_ice" | "minecraft:blackstone_slab_from_blackstone_stonecutting" | "utilitix:dimmable_redstone_lamp" | "railways:crafting/palettes/dyeing_8x/purple_copper_wrapped_locometal" | "pamhc2foodextended:limejellyitem" | "handcrafted:bench" | "chipped_express:stonecutting_chipped_vined_birch_trapdoor_from_birch_trapdoor" | "create:milling/wither_rose" | "chipped_express:stonecutting_chipped_etched_basalt_bricks_from_basalt" | "aquaculture:neptunium_shovel" | "minecraft:stone_slab" | "botania:petal_apothecary/entropinnyum" | "moa_decor_holidays:santa_claus_1" | "botania:petal_cyan" | "compressedblocks:shaped_giga_crated_purple_dye" | "createdeco:tiled_pearl_brick_slab_from_pearl_brick_slab_stonecutting" | "handcrafted:dark_oak_pillar_trim" | "meadow:pine_wood" | "chipped_express:stonecutting_chipped_small_gilded_blackstone_bricks_from_gilded_blackstone" | "minecraft:brick_stairs_from_bricks_stonecutting" | "mcwbridges:glass_bridge" | "chipped_express:stonecutting_chipped_unamused_netherrack_from_netherrack" | "chipped_express:stonecutting_chipped_triangular_cyan_terracotta_from_cyan_terracotta" | "compressedblocks:shapeless_triple_crated_fermented_spider_eye" | "pamhc2foodextended:spicebunitem" | "quark:world/crafting/walls/andesite_bricks_wall" | "chipped_express:stonecutting_chipped_stacked_waxed_weathered_copper_from_waxed_weathered_copper" | "mcwroofs:cobblestone_top_roof" | "compressedblocks:shaped_c6_coal_ore" | "railways:sequenced_assembly/track_create_dd_rubber_wide" | "chipped_express:stonecutting_chipped_cracked_shroomlight_from_shroomlight" | "chipped_express:stonecutting_chipped_smoothed_double_inlayed_raw_copper_block_from_raw_copper_block" | "compressedblocks:shapeless_double_crated_saddle" | "chipped_express:stonecutting_chipped_rotted_warped_stem_from_warped_stem" | "botania:livingrock_bricks_wall" | "chipped_express:stonecutting_chipped_smooth_jungle_planks_from_jungle_planks" | "moa_decor_toys:murcielago_1" | "chipped_express:stonecutting_chipped_vertical_cut_tuff_from_tuff" | "luphieclutteredmod:blue_tarrey_town_planter_recipe" | "mcwroofs:blackstone_roof" | "compressedblocks:shaped_sextuple_crated_blue_orchid" | "chipped_express:stonecutting_chipped_patient_stripped_mangrove_log_from_stripped_mangrove_log" | "compressedblocks:shapeless_octuple_crated_magma_cream" | "framedblocks:framed_pane" | "chipped_express:stonecutting_chipped_weathered_lapis_block_from_lapis_block" | "mcwroofs:black_concrete_steep_roof" | "mcwwindows:crimson_stem_four_window" | "chipped_express:stonecutting_chipped_decorated_lime_terracotta_from_lime_terracotta" | "farmersdelight:cutting/cooked_crab_ecologics" | "compressedblocks:shaped_quadruple_crated_blue_dye" | "chipped_express:stonecutting_chipped_cubed_red_carpet_from_red_carpet" | "chipped_express:stonecutting_chipped_firewood_mangrove_log_from_mangrove_log" | "botania:metamorphic_forest_stone_stairs" | "chipped_express:stonecutting_chipped_hewn_crimson_planks_from_crimson_planks" | "compressedblocks:shapeless_giga_crated_oxeye_daisy" | "minecraft:cooked_salmon" | "chipped_express:stonecutting_chipped_sad_end_stone_from_end_stone" | "compressedblocks:shaped_mega_crated_red_mushroom" | "chipped_express:stonecutting_chipped_cracked_dark_prismarine_bricks_from_dark_prismarine" | "luphieclutteredmod:luphie_darkwood_clock_recipe" | "chipped_express:stonecutting_chipped_pegged_light_blue_concrete_from_light_blue_concrete" | "framedblocks:framed_flat_inv_double_slope_panel_corner" | "toms_storage:inventory_cable" | "chipped_express:stonecutting_chipped_cut_blank_lapis_block_from_lapis_block" | "botania:glimmering_stripped_livingwood_from_log" | "compressedblocks:shaped_c0_birch_log" | "sophisticatedstorage:advanced_hopper_upgrade" | "chipped_express:stonecutting_chipped_runic_carved_end_stone_from_end_stone" | "chipped_express:stonecutting_chipped_blank_cobblestone_carving_from_cobblestone" | "chipped_express:stonecutting_chipped_decorated_light_gray_glazed_terracotta_from_light_gray_glazed_terracotta" | "quark:building/crafting/oak_hedge" | "mcwwindows:spruce_shutter" | "chipped_express:stonecutting_chipped_overgrown_crimson_trapdoor_from_crimson_trapdoor" | "botania:yellow_pavement" | "quark:building/crafting/cherry_ladder" | "mcwfurnituresbop:palm_cupboard_counter" | "botanypots:regions_unexplored/crop/daisy" | "chipped_express:stonecutting_chipped_tiled_white_stained_glass_pane_from_white_stained_glass_pane" | "compressedblocks:shapeless_crated_blue_dye" | "create:compat/byg/filling/lush_grass_block" | "chipped_express:stonecutting_chipped_runic_carved_red_sandstone_from_red_sandstone" | "createdeco:scarlet_brick_slab_from_long_scarlet_bricks_stonecutting" | "railways:crafting/palettes/dyeing_1x/yellow_plated_locometal" | "chipped_express:stonecutting_chipped_pink_concrete_panel_from_pink_concrete" | "botania:mana_infusion/potato_unpoison" | "chipped_express:stonecutting_chipped_laced_jungle_planks_from_jungle_planks" | "compressedblocks:shapeless_c5_birch_planks" | "corail_woodcutter:woodcutting/acacia_button_from_acacia_planks" | "mcwdoors:spruce_western_door" | "chipped_express:stonecutting_chipped_trodden_raw_copper_block_from_raw_copper_block" | "botania:lens_mine" | "farmersdelight:integration/immersiveengineering/cloche/cabbage" | "mcwbridges:rope_acacia_bridge" | "corail_woodcutter:woodcutting/warped_door_from_warped_stems" | "mcwfurnituresbop:hellbark_large_drawer" | "createdeco:decal_fire_diamond" | "compressedblocks:shaped_quadruple_crated_cooked_chicken" | "supplementaries:flags/flag_light_gray" | "vinery:red_grape" | "chipped_express:stonecutting_chipped_stern_stripped_birch_log_from_stripped_birch_log" | "railways:crafting/palettes/dyeing_1x/white_copper_wrapped_locometal_boiler" | "chipped_express:stonecutting_chipped_mud_bricks_bricks_from_mud_bricks" | "quark:building/crafting/lavender_blossom_hedge" | "chipped_express:stonecutting_chipped_vertically_railed_oak_planks_from_oak_planks" | "chipped_express:stonecutting_chipped_herringbone_warped_planks_from_warped_planks" | "chipped_express:stonecutting_chipped_cross_haired_white_wool_from_white_wool" | "minecraft:cobbled_deepslate_slab_from_cobbled_deepslate_stonecutting" | "delightful:integration/aether/unpack_blueberry_sack" | "moa_decor_cookery:manzana_1" | "compressedblocks:shaped_c4_chiseled_red_sandstone" | "compressedblocks:shapeless_c9_cherry_planks" | "quark:building/stonecutting/orange_shingles_stonecutter2" | "createdeco:long_dusk_brick_slab_from_short_dusk_brick_slab_stonecutting" | "meadow:wood_cutter/warped/warped_pp_woodcutter" | "candlelight:banner_from_smithing_table" | "createdeco:tiled_umber_brick_stairs_from_long_umber_brick_stairs_stonecutting" | "chipped_express:stonecutting_chipped_cracked_packed_ice_bricks_from_packed_ice" | "pamhc2foodcore:sprinklesdonutitem" | "minecraft:dark_oak_trapdoor" | "additionaladditions:fried_egg_from_campfire_cooking" | "conditional:regions_unexplored/wood_cutter/blackwood_planks_woodcutter" | "mcwfences:iron_cheval_de_frise" | "chipped_express:stonecutting_chipped_glad_mossy_stone_bricks_from_mossy_stone_bricks" | "compressedblocks:shapeless_c0_stone_bricks" | "chipped_express:stonecutting_chipped_ornate_magma_block_pillar_from_magma_block" | "compressedblocks:shapeless_c6_oxidized_cut_copper" | "chipped_express:stonecutting_chipped_stacked_crimson_planks_from_crimson_planks" | "mcwfences:modern_sandstone_wall_stonecutter" | "quark:tweaks/crafting/utility/chests/warped_chest_wood" | "minecraft:acacia_chest_boat" | "delightful:knives/smelting/emerald_emeraldequipment" | "chipped_express:stonecutting_chipped_cut_redstone_block_column_from_redstone_block" | "compressedblocks:shaped_septuple_crated_powered_rail" | "mcwtrpdoors:acacia_four_panel_trapdoor" | "botania:floating_solegnolia" | "minecraft:deepslate_bricks" | "chipped_express:stonecutting_chipped_tiny_layered_red_sandstone_slabs_from_red_sandstone" | "chipped_express:stonecutting_chipped_railed_magenta_concrete_from_magenta_concrete" | "macawsroofsbop:jacaranda_planks_attic_roof" | "domesticationinnovation:pet_bed_green_from_dye" | "minecraft:waxed_weathered_cut_copper_stairs" | "mcwwindows:stripped_spruce_log_window2" | "minecraft:mossy_stone_brick_stairs" | "pamhc2foodextended:persimmonpieitem" | "compressedblocks:shaped_c8_dark_oak_planks" | "chipped_express:stonecutting_chipped_striped_gray_concrete_from_gray_concrete" | "chipped_express:stonecutting_chipped_stern_stripped_crimson_stem_from_stripped_crimson_stem" | "delightful:knives/zinc_knife" | "pamhc2foodcore:plaindonutitem" | "conditional:regions_unexplored/wood_cutter/palm_pp_woodcutter" | "quark:building/crafting/vertplanks/vertical_cherry_planks" | "chipped_express:stonecutting_chipped_wickered_bamboo_planks_from_bamboo_planks" | "pamhc2foodextended:ovenroastedcaulifloweritem" | "candlelight:crimson_cabinet" | "farmersdelight:integration/immersiveengineering/crusher/wild_beetroots" | "mcwroofs:orange_terracotta_roof" | "compressedblocks:shaped_triple_crated_fire_charge" | "minecraft:nether_brick" | "chipped_express:stonecutting_chipped_woven_magenta_stained_glass_pane_from_magenta_stained_glass_pane" | "pamhc2foodextended:leafyfishsandwichitem" | "cosmeticarmoursmod:royal_tunic_blue_2_white" | "candlelight:red_nether_bricks_kitchen_sink" | "conditional:regions_unexplored/wood_cutter/socotra_planks_woodcutter" | "chipped_express:stonecutting_chipped_bundled_green_carpet_from_green_carpet" | "chipped_express:stonecutting_chipped_simple_raw_gold_block_pillar_from_raw_gold_block" | "compressedblocks:shaped_c4_stripped_dark_oak_log" | "railways:sequenced_assembly/track_byg_ebony_narrow" | "gemsnjewels:stacked_amethyst_stairs" | "chipped_express:stonecutting_chipped_shack_crimson_door_from_crimson_door" | "chipped_express:stonecutting_chipped_pointless_bamboo_trapdoor_from_bamboo_trapdoor" | "compressedblocks:shapeless_sextuple_crated_wither_rose" | "quark:building/crafting/vertslabs/purpur_vertical_slab_revert" | "chipped_express:stonecutting_chipped_angry_red_nether_bricks_from_red_nether_bricks" | "railways:sequenced_assembly/track_twilightforest_timewood" | "createdeco:long_umber_brick_stairs_from_tiled_umber_brick_stairs_stonecutting" | "railways:crafting/palettes/dyeing_8x/magenta_riveted_locometal" | "meadow:bear_meat_from_smoking" | "compressedblocks:shapeless_septuple_crated_porkchop" | "crafting_on_a_stick:stonecutter" | "corail_woodcutter:woodcutting/acacia_stairs_from_acacia_logs" | "compressedblocks:shaped_c1_cobblestone" | "chipped_express:stonecutting_chipped_small_white_stained_glass_pane_from_white_stained_glass_pane" | "compressedblocks:shaped_c3_cut_copper" | "create:crafting/kinetics/furnace_minecart_from_contraption_cart" | "mcwbridges:stonecutter_sandstone_bridge" | "botania:lens_light_alt" | "createdeco:short_dusk_brick_slab" | "createdeco:tiled_red_brick_slab_from_tiled_red_bricks_stonecutting" | "compressedblocks:shapeless_quadruple_crated_charcoal" | "chipped_express:stonecutting_chipped_runic_carved_clay_from_clay" | "compressedblocks:shapeless_c4_stone" | "moa_decor_bath:batagris_1" | "biomesoplenty:black_sandstone_wall_from_black_sandstone_stonecutting" | "railways:crafting/palettes/dyeing_8x/cyan_copper_wrapped_locometal_boiler" | "create:cutting/acacia_log" | "moa_decor_garden_:bancaabeto_1" | "create:small_scoria_brick_wall" | "chipped_express:stonecutting_chipped_tiny_layered_calcite_slabs_from_calcite" | "cosmeticarmoursmod:christmas_elf_boots_red_rec" | "chipped_express:stonecutting_chipped_crimson_roots_bulb_from_crimson_roots" | "mcwdoors:bamboo_swamp_door" | "quark:building/crafting/slabs/lime_shingles_slab" | "mcwbridges:balustrade_orange_sandstone_bridge" | "corail_woodcutter:woodcutting/bamboo_mosaic_from_bamboo_planks" | "snowyspirit:compressedblocks/sled_c9_oak" | "candlelight:lettuce_salad" | "quark:tweaks/crafting/utility/misc/tnt_minecart" | "lootbags:common_decorations/graveyard_completion" | "lootbags:clothing_collection/beach_outfit_completion" | "chipped_express:stonecutting_chipped_grill_brown_concrete_from_brown_concrete" | "aquaculture:brown_mushroom_from_fish" | "chipped_express:stonecutting_chipped_stringed_brown_wool_from_brown_wool" | "mcwwindows:light_gray_mosaic_glass_pane" | "farmersdelight:cutting/amethyst_block" | "gemsnjewels:tourmaline_set_gold_crown" | "createdeco:scarlet_brick_stairs" | "farmersdelight:gold_nugget_from_smelting_knife" | "chipped_express:stonecutting_chipped_stern_stripped_mangrove_log_from_stripped_mangrove_log" | "botania:super_lava_pendant" | "compressedblocks:shaped_sextuple_crated_rabbit_foot" | "corail_woodcutter:woodcutting/warped_fence_gate_from_warped_stems" | "handcrafted:bear_trophy" | "compressedblocks:shapeless_octuple_crated_rabbit_hide" | "compressedblocks:shaped_sextuple_crated_allium" | "cosmeticarmoursmod:black_skirt_2_white" | "compressedblocks:shaped_quintuple_crated_magenta_carpet" | "botania:stonecutting/sunny_quartz_to_sunny_quartz_pillar" | "chipped_express:stonecutting_chipped_barred_ochre_froglight_from_ochre_froglight" | "handcrafted:white_glazed_thick_pot" | "comforts:sleeping_bag_lime" | "railways:mechanical_crafting/white_iron_wrapped_locometal_boiler" | "mcwfurnitures:mangrove_modern_wardrobe" | "compressedblocks:shaped_sextuple_crated_sugar" | "handcrafted:acacia_counter" | "chipped_express:stonecutting_chipped_ribbled_purple_carpet_from_purple_carpet" | "mcwfurnitures:stripped_dark_oak_double_drawer" | "chipped_express:stonecutting_chipped_double_mud_bricks_bricks_from_mud_bricks" | "create:cut_ochrum_brick_slab_recycling" | "quark:building/crafting/vertslabs/smooth_sandstone_vertical_slab" | "chipped_express:stonecutting_chipped_soft_light_blue_wool_from_light_blue_wool" | "corail_woodcutter:woodcutting/tropicraft/mangrove_stairs_from_mangrove_logs" | "compressedblocks:shapeless_c2_cobbled_deepslate" | "compressedblocks:shapeless_giga_crated_firework_star" | "minecraft:copper_ingot_from_smelting_deepslate_copper_ore" | "minecraft:mossy_stone_brick_wall" | "compressedblocks:shapeless_triple_crated_comparator" | "sophisticatedbackpacks:feeding_upgrade" | "comforts:hammock_yellow" | "create:crafting/kinetics/clutch" | "farmersdelight:smoked_ham" | "luphieclutteredmod:luphie_flowering_purple_slab_recipe" | "create:milling/orange_tulip" | "create:crafting/kinetics/encased_fan" | "cosmeticarmoursmod:rose_gold_crown_rec" | "chipped_express:stonecutting_chipped_swampy_hay_block_from_hay_block" | "exoticbirds:crimson_birdcage" | "createdeco:umber_brick_slab_from_tiled_umber_bricks_stonecutting" | "mcwdoors:spruce_mystic_door" | "chipped_express:stonecutting_chipped_checkered_raw_gold_block_tiles_from_raw_gold_block" | "railways:crafting/palettes/dyeing_1x/orange_copper_wrapped_locometal_boiler" | "moa_decor_bath:tendederoconropamasculina_1" | "mcwbridges:birch_rope_bridge_stair_recycle" | "chipped_express:stonecutting_chipped_spider_deepslate_carving_from_deepslate" | "railways:crafting/palettes/dyeing_8x/brown_flat_riveted_locometal" | "create:polished_cut_diorite_slab" | "minecraft:campfire_roastedsunflowerseedsitem" | "supplementaries:pedestal" | "quark:building/crafting/vertslabs/calcite_vertical_slab_revert" | "chipped_express:stonecutting_chipped_hard_mud_bricks_from_mud_bricks" | "compressedblocks:shaped_crated_crimson_fungus" | "compressedblocks:shaped_quadruple_crated_glass_bottle" | "chipped_express:stonecutting_chipped_small_pink_stained_glass_from_pink_stained_glass" | "lootbags:common_decorations/zombie_plushes_completion" | "exoticbirds:bird_book" | "refinedstorage:wireless_transmitter" | "cookingforblockheads:tool_rack" | "createdeco:mossy_scarlet_brick_stairs" | "cosmeticarmoursmod:royal_tunic_cyan_2_white" | "herbalbrews:cauldron_brewing/damage_flask_big" | "compressedblocks:shapeless_c3_end_stone" | "chipped_express:stonecutting_chipped_windmill_orange_wool_from_orange_wool" | "minecraft:campfire_cookedgroundmuttonitem" | "farmersdelight:integration/create/mixing/cabbage_slice_from_mixing" | "compressedblocks:shaped_c9_redstone_ore" | "botania:stonecutting/metamorphic_desert_cobblestone_to_metamorphic_desert_cobblestone_slab" | "botanypots:farming_crossing/crop/pamhc2treesvanillabean_sapling" | "compressedblocks:shaped_c4_nether_quartz_ore" | "minecraft:stone" | "minecraft:blackstone_stairs" | "refinedstorage:coloring_recipes/magenta_grid" | "mcwroofs:spruce_upper_steep_roof" | "botania:mana_infusion/spruce_log_to_birch_log" | "quark:building/crafting/rusty_iron_plate2" | "chipped_express:stonecutting_chipped_circular_yellow_terracotta_from_yellow_terracotta" | "fairylights:garland" | "corail_woodcutter:woodcutting/biomesoplenty/umbran_trapdoor_from_umbran_planks" | "chipped_express:stonecutting_chipped_chipped_stripped_cherry_log_from_stripped_cherry_log" | "chipped_express:stonecutting_chipped_boxed_mangrove_planks_from_mangrove_planks" | "mcwfurnitures:jungle_triple_drawer" | "compressedblocks:shapeless_c5_cherry_log" | "botania:elf_quartz" | "compressedblocks:shapeless_octuple_crated_light_gray_dye" | "create:compat/byg/milling/foxglove" | "lootbags:clothing_collection/tops_completion" | "mcwbridges:mangrove_log_bridge_middle" | "alexsmobs:void_worm_beak" | "framedblocks:framed_fancy_powered_rail" | "pamhc2foodextended:beefwellingtonitem" | "exoticbirds:gray_birdhouse" | "pamhc2foodextended:bbqchickenbiscuititem" | "botanypots:minecraft/soil/deepslate_copper_ore" | "quark:tweaks/crafting/utility/coral/tube_to_blue" | "mcwwindows:cherry_plank_pane_window" | "compressedblocks:shaped_sextuple_crated_black_dye" | "mcwfurnitures:stripped_dark_oak_cupboard_counter" | "chipped_express:stonecutting_chipped_unamused_diorite_from_diorite" | "framedblocks:framed_flat_inner_slope_slab_corner_rotate_to_framed_flat_inner_slope_panel_corner" | "farmersdelight:cutting/porkchop" | "mcwbridges:stone_brick_bridge" | "moa_decor_science:camahblanca_1" | "chipped_express:stonecutting_chipped_chiseled_red_terracotta_from_red_terracotta" | "compressedblocks:shaped_c6_basalt" | "compressedblocks:shapeless_c5_oxidized_cut_copper" | "chipped_express:stonecutting_chipped_rusted_black_concrete_from_black_concrete" | "luphieclutteredmod:luphie_safe_recipe" | "chipped_express:stonecutting_chipped_chiseled_cyan_terracotta_from_cyan_terracotta" | "create:compat/endergetic/splashing/petrified_nether_corrock" | "chipped_express:stonecutting_chipped_duh_gilded_blackstone_from_gilded_blackstone" | "meadow:wood_cutter/spruce/spruce_fencegate_woodcutter" | "moa_decor_science:jeringarosa_1" | "alexsmobs:mosquito_larva" | "chipped_express:stonecutting_chipped_bordered_bricks_from_bricks" | "createdeco:white_shipping_container_from_dyeing_vaults" | "moa_decor_science:biombomverdelima_1" | "chipped_express:stonecutting_chipped_cubed_purple_wool_from_purple_wool" | "quark:building/crafting/stairs/cobblestone_bricks_stairs" | "compressedblocks:shaped_quadruple_crated_egg" | "luphieclutteredmod:pink_tarrey_town_planter_recipe" | "moa_decor_lights:vt_nabedul_1" | "compressedblocks:shaped_septuple_crated_nautilus_shell" | "chipped_express:stonecutting_chipped_loded_dripstone_block_from_dripstone_block" | "corail_woodcutter:woodcutting/biomesoplenty/hellbark_pressure_plate_from_hellbark_planks" | "quark:world/crafting/polished_limestone" | "chipped_express:stonecutting_chipped_twisted_crimson_trapdoor_from_crimson_trapdoor" | "create:tiled_glass_pane" | "chipped_express:stonecutting_chipped_layed_granite_bricks_from_granite" | "quark:building/stonecutting/slabs/green_shingles_slab_stonecutter2" | "mcwfurnituresbop:magic_cupboard_counter" | "compressedblocks:shapeless_double_crated_black_carpet" | "moa_decor_bath:toallarojacolg_1" | "compressedblocks:shaped_mega_crated_clay_ball" | "chipped_express:stonecutting_chipped_shack_dark_oak_door_from_dark_oak_door" | "luphieclutteredmod:luphie_yellow_door_recipe" | "chipped_express:stonecutting_chipped_red_sandstone_mini_tiles_from_red_sandstone" | "compressedblocks:shapeless_quadruple_crated_poisonous_potato" | "handcrafted:yellow_bowl" | "chipped_express:stonecutting_chipped_plated_waxed_oxidized_copper_from_waxed_oxidized_copper" | "create:small_ochrum_brick_wall" | "pamhc2foodextended:lycheepieitem" | "botania:mana_void" | "compressedblocks:shapeless_quintuple_crated_golden_carrot" | "vinery:stackable_log" | "mcwfurnituresbop:fir_bookshelf_drawer" | "compressedblocks:shapeless_crated_twisting_vines" | "chipped_express:stonecutting_chipped_waved_orange_glazed_terracotta_from_orange_glazed_terracotta" | "botania:pattern_3_1" | "botania:pattern_3_2" | "moa_decor_garden_:florero_tdientedeleon_1" | "quark:world/crafting/waxed_violet_corundum" | "mcwroofs:brown_terracotta_attic_roof" | "chipped_express:stonecutting_chipped_prismal_lapis_block_remnants_from_lapis_block" | "quark:tweaks/crafting/light_blue_glass" | "chipped_express:stonecutting_chipped_soft_yellow_carpet_from_yellow_carpet" | "minecraft:hopper_minecart" | "compressedblocks:shapeless_sextuple_crated_magenta_carpet" | "chipped_express:stonecutting_chipped_orange_concrete_panel_from_orange_concrete" | "framedblocks:framed_corner_pillar" | "mcwroofs:red_nether_bricks_roof" | "chipped_express:stonecutting_chipped_checkered_bricks_tiles_from_bricks" | "botania:stonecutting/metamorphic_mountain_stone_to_metamorphic_mountain_stone_stairs" | "bloomingnature:swamp_oak_pressure_plate" | "compressedblocks:shapeless_c7_waxed_weathered_copper" | "chipped_express:stonecutting_chipped_inlayed_basalt_from_basalt" | "chipped_express:stonecutting_chipped_engraved_obsidian_from_obsidian" | "mcwwindows:black_curtain" | "pamhc2foodextended:lycheejellytoastitem" | "corail_woodcutter:woodcutting/biomesoplenty/dead_button_from_dead_logs" | "farmersdelight:cooked_chicken_cuts_from_campfire_cooking" | "botania:pixie_ring" | "farmersdelight:cutting/jungle_hanging_sign" | "createdeco:long_blue_brick_stairs_from_tiled_blue_bricks_stonecutting" | "botania:drum_gathering" | "moa_decor_art:bateriarosa_1" | "chipped_express:stonecutting_chipped_bordered_tuff_from_tuff" | "pamhc2foodextended:sauerbratenitem" | "pamhc2foodextended:sorbetitem" | "compressedblocks:shapeless_c7_gold_ore" | "chipped_express:stonecutting_chipped_cornered_purple_carpet_from_purple_carpet" | "pamhc2foodcore:chickenjerkyitem" | "botania:stonecutting/metamorphic_swamp_bricks_to_metamorphic_swamp_bricks_slab" | "botanypots:botanypots/crafting/white_terracotta_hopper_botany_pot" | "chipped_express:stonecutting_chipped_rectangle_orange_carpet_from_orange_carpet" | "create:cutting/stripped_birch_wood" | "compressedblocks:shapeless_septuple_crated_powered_rail" | "cosmeticarmoursmod:orange_skirt_2_plaid" | "chipped_express:stonecutting_chipped_tiled_basalt_from_basalt" | "create:cut_crimsite_slab" | "compressedblocks:shapeless_septuple_crated_rabbit_hide" | "conditional:bloomingnature/wood_cutter/aspen_trapdoor_woodcutter" | "conditional:regions_unexplored/wood_cutter/blackwood_door_woodcutter" | "luphieclutteredmod:luphie_confectionary_table_a_recipe" | "handcrafted:spruce_corner_trim" | "biomesoplenty:dead_sign" | "chipped_express:stonecutting_chipped_fine_warped_planks_from_warped_planks" | "bakery:jar" | "mcwfurnituresbop:willow_covered_desk" | "compressedblocks:shaped_septuple_crated_cyan_carpet" | "nethervinery:reinforced_warped_planks" | "luphieclutteredmod:luphie_pink_left_outer_corner_counter_recipe_alt" | "farmersdelight:cooked_cod_slice_from_smoking" | "botanypots:botanypots/crafting/orange_terracotta_compact_hopper_botany_pot" | "compressedblocks:shaped_triple_crated_soul_campfire" | "framedblocks:framing_saw/framed_small_inner_corner_slope_panel" | "quark:building/crafting/vertplanks/vertical_mangrove_planks" | "chipped_express:stonecutting_chipped_chipped_waxed_copper_block_from_waxed_copper_block" | "supplementaries:daub" | "create:crafting/kinetics/wooden_bracket" | "mcwfences:oak_hedge" | "chipped_express:stonecutting_chipped_tripped_magenta_carpet_from_magenta_carpet" | "compressedblocks:shapeless_crated_beef" | "compressedblocks:shapeless_c2_mangrove_log" | "storagedrawers:birch_full_drawers_1" | "storagedrawers:birch_full_drawers_2" | "cosmeticarmoursmod:winter_survivalist_trousers_blue" | "storagedrawers:birch_full_drawers_4" | "moa_decor_cookery:adistorsionadosc_1" | "chipped_express:stonecutting_chipped_small_redstone_block_bricks_from_redstone_block" | "cosmeticarmoursmod:brown_bunny_ears_rec" | "chipped:mason_table" | "chipped_express:stonecutting_chipped_duh_basalt_from_basalt" | "mcwfurnitures:birch_bookshelf" | "pamhc2foodextended:pizzasliceitem_pepperonipizzaitem" | "corail_woodcutter:woodcutting/oak_slab_from_oak_planks" | "create:cutting/compat/ars_nouveau/stripped_green_archwood_log" | "undergarden:cutting/wigglewood_log" | "chipped_express:stonecutting_chipped_big_flower_lily_pad_from_lily_pad" | "conditional:vinery/wood_cutter/cherry_planks_woodcutter" | "biomesoplenty:mahogany_pressure_plate" | "botania:livingwood_fence_gate" | "mcwlights:brown_paper_lamp" | "compressedblocks:shaped_octuple_crated_flint" | "createdeco:tiled_verdant_bricks_from_long_verdant_bricks_stonecutting" | "compressedblocks:shaped_c2_cherry_planks" | "compressedblocks:shapeless_c6_nether_wart_block" | "compressedblocks:shaped_quadruple_crated_twisting_vines" | "createdeco:industrial_iron_trapdoor" | "farmersdelight:cutting/oak_sign" | "compressedblocks:shapeless_giga_crated_cocoa_beans" | "handcrafted:cherry_couch" | "create:polished_cut_scorchia_from_stone_types_scorchia_stonecutting" | "chipped_express:stonecutting_chipped_creeper_lodestone_carving_from_lodestone" | "pamhc2foodextended:blueberryyogurtitem" | "moa_decor_holidays:bota_ncafe_1" | "railways:crafting/palettes/dyeing_8x/light_blue_plated_locometal" | "compressedblocks:shaped_septuple_crated_orange_dye" | "mcwlights:bell_wall_lantern" | "conditional:bloomingnature/wood_cutter/aspen_pp_woodcutter" | "chipped_express:stonecutting_chipped_checkered_magma_block_tiles_from_magma_block" | "quark:building/crafting/stripped_spruce_post" | "minecraft:black_stained_glass" | "quark:building/stonecutting/vertslabs/pink_shingles_vertical_slab_stonecutter" | "botania:star_sword" | "mcwfurnitures:stripped_spruce_bookshelf" | "compressedblocks:shaped_c0_nether_wart_block" | "compressedblocks:shaped_c5_andesite" | "mcwbridges:stonecutter_mossy_stone_brick_bridge" | "gemsnjewels:ornament_opal_block" | "supplementaries:ash_brick_slab" | "chipped_express:stonecutting_chipped_bricky_jungle_planks_from_jungle_planks" | "biomesoplenty:fir_boat" | "sophisticatedstorage:diamond_to_netherite_tier_upgrade" | "refinedstorage:coloring_recipes/red_detector" | "cosmeticarmoursmod:santa_coat_ftm_rec" | "pamhc2foodextended:tamarindjellysandwichitem" | "chipped_express:stonecutting_chipped_wired_yellow_concrete_from_yellow_concrete" | "compressedblocks:shaped_quadruple_crated_birch_sapling" | "chipped_express:stonecutting_chipped_harsh_quilted_yellow_wool_from_yellow_wool" | "gemsnjewels:light_stone_ruby" | "moa_decor_science:jeringanaranja_1" | "quark:world/crafting/stairs/granite_bricks_stairs" | "railways:crafting/palettes/dyeing_8x/yellow_locometal_pillar" | "chipped_express:stonecutting_chipped_bundled_light_blue_carpet_from_light_blue_carpet" | "chipped_express:stonecutting_chipped_blank_nether_bricks_carving_from_nether_bricks" | "refinedstorage:coloring_recipes/red_pattern_grid" | "bloomingnature:larch_planks" | "compressedblocks:shaped_giga_crated_lilac" | "chipped_express:stonecutting_chipped_heavy_mangrove_trapdoor_from_mangrove_trapdoor" | "mcwlights:bell_lantern" | "botania:pure_daisy/packed_ice" | "compressedblocks:shaped_giga_crated_golden_apple" | "chipped_express:stonecutting_chipped_bricky_mangrove_planks_from_mangrove_planks" | "mcwfurnitures:stripped_acacia_bookshelf_cupboard" | "pamhc2foodextended:pearjellysandwichitem" | "mcwfurnituresbop:umbran_counter" | "botanypots:pamhc2crops/crop/cloudberry" | "quark:building/crafting/vertplanks/vertical_oak_planks" | "compressedblocks:shapeless_c9_spruce_log" | "corail_woodcutter:woodcutting/biomesoplenty/dead_planks_from_dead_logs" | "beautify:candelabra_magenta" | "chipped_express:stonecutting_chipped_harsh_quilted_red_wool_from_red_wool" | "toms_storage:open_crate" | "railways:sequenced_assembly/track_byg_rainbow_eucalyptus" | "createdeco:cracked_verdant_bricks_from_verdant_bricks_smelting" | "compressedblocks:shaped_quadruple_crated_milk_bucket" | "chipped_express:stonecutting_chipped_whirlwind_acacia_planks_from_acacia_planks" | "fairylights:star_light" | "pamhc2crops:roastedpeanutitem_campfire" | "farmersdelight:cutting/acacia_sign" | "create:cut_scorchia_slab_recycling" | "corail_woodcutter:woodcutting/birch_sign_from_birch_logs" | "botania:metamorphic_forest_bricks_slab" | "compressedblocks:shaped_quintuple_crated_soul_lantern" | "chipped_express:stonecutting_chipped_tiny_smug_carved_pumpkin_from_carved_pumpkin" | "moa_decor_science:tubosensayoverde_1" | "quark:building/crafting/stonevariants/vanilla/polished_calcite" | "chipped_express:stonecutting_chipped_natural_spruce_planks_from_spruce_planks" | "mcwbridges:mud_brick_bridge_pier" | "framedblocks:framing_saw/framed_elevated_double_slope_slab" | "createdeco:short_dusk_bricks_from_tiled_dusk_bricks_stonecutting" | "chipped_express:stonecutting_chipped_star_packed_mud_from_packed_mud" | "compressedblocks:shapeless_c5_waxed_cut_copper" | "gemsnjewels:ornament_topaz_block" | "chipped_express:stonecutting_chipped_runic_carved_amethyst_block_from_amethyst_block" | "create:crafting/logistics/brass_tunnel" | "botanypots:pamhc2crops/crop/tealeaf" | "compressedblocks:shapeless_double_crated_rabbit_foot" | "chipped_express:stonecutting_chipped_herringbone_spruce_planks_from_spruce_planks" | "quark:building/stonecutting/stairs/yellow_shingles_stairs_stonecutter" | "quark:world/stonecutting/stairs/polished_myalite_stairs_stonecutter" | "create_confectionery:chocolate_recipe_5" | "create_confectionery:chocolate_recipe_6" | "chipped_express:stonecutting_chipped_wickered_birch_planks_from_birch_planks" | "create_confectionery:chocolate_recipe_3" | "framedblocks:framed_stacked_slope_slab" | "create_confectionery:chocolate_recipe_4" | "alexsmobs:cooked_catfish_campfire" | "minecraft:chiseled_nether_bricks" | "mcwbridges:stonecutter_balustrade_stone_bricks_bridge" | "chipped_express:stonecutting_chipped_red_nether_bricks_bricks_from_red_nether_bricks" | "moa_decor_garden_:florero_traizcarmesi_1" | "compressedblocks:shaped_quadruple_crated_weeping_vines" | "pamhc2foodextended:cherrysmoothieitem" | "chipped_express:stonecutting_chipped_barky_cyan_wool_from_cyan_wool" | "chipped_express:stonecutting_chipped_screen_spruce_door_from_spruce_door" | "mcwroofs:acacia_planks_top_roof" | "compressedblocks:shapeless_c1_raw_gold_block" | "mcwfurnituresbop:dead_double_wardrobe" | "botania:elementium_sword" | "chipped_express:stonecutting_chipped_crafted_yellow_carpet_from_yellow_carpet" | "compressedblocks:shapeless_octuple_crated_cyan_dye" | "compressedblocks:shapeless_c7_gravel" | "pamhc2foodextended:bananajellyitem" | "mcwfurnituresbop:jacaranda_large_drawer" | "chipped_express:stonecutting_chipped_elemental_verdant_froglight_from_verdant_froglight" | "alexsdelight:smelting/singular_cooked_moose_rib_smoke" | "chipped_express:stonecutting_chipped_engraved_raw_gold_block_from_raw_gold_block" | "botania:stonecutting/blaze_quartz_to_chiseled_blaze_quartz" | "chipped_express:stonecutting_chipped_beach_birch_door_from_birch_door" | "aquaculture:iron_nugget_from_smelting" | "compressedblocks:shaped_double_crated_rotten_flesh" | "quark:building/crafting/compressed/potato_crate" | "quark:building/crafting/vertslabs/cyan_shingles_vertical_slab" | "mcwroofs:acacia_planks_upper_lower_roof" | "macawsroofsbop:mahogany_planks_attic_roof" | "create:cutting/compat/botania/stripped_dreamwood" | "chipped_express:stonecutting_chipped_prismal_mossy_stone_bricks_remnants_from_mossy_stone_bricks" | "farmersdelight:integration/create/milling/wild_beetroots" | "snowyspirit:glow_lights_brown" | "villagersplus:spruce_horticulturist_table" | "railways:stonecutting/palettes/cycling/white_plated_locometal" | "pamhc2foodextended:pineapplejuiceitem" | "cosmeticarmoursmod:red_sock_plaid_2_white" | "chipped_express:stonecutting_chipped_oak_woven_glass_from_glass" | "createdeco:tiled_umber_brick_slab" | "moa_decor_holidays:esp_grisclaro_1" | "create:compat/ae2/milling/fluix_crystal" | "compressedblocks:shaped_c2_iron_block" | "chipped_express:stonecutting_chipped_woven_dark_oak_trapdoor_from_dark_oak_trapdoor" | "pamhc2crops:cucumberseeditem" | "createdeco:zinc_mesh_fence" | "chipped_express:stonecutting_chipped_fancy_magenta_stained_glass_pane_from_magenta_stained_glass_pane" | "minecraft:cherry_door" | "compressedblocks:shaped_c2_chiseled_red_sandstone" | "meadow:cheese_form/sheep_cheese" | "corail_woodcutter:woodcutting/oak_door_from_oak_logs" | "compressedblocks:shapeless_c7_mangrove_log" | "botanypots:minecraft/crop/fern" | "createaddition:charging/exposed_cut_copper" | "refinedstorage:coloring_recipes/white_grid" | "luphieclutteredmod:yellow_planks_alt_recipe" | "compressedblocks:shaped_septuple_crated_mangrove_propagule" | "compressedblocks:shapeless_septuple_crated_seagrass" | "quark:building/stonecutting/slabs/red_sandstone_bricks_slab_stonecutter" | "botanypots:pamhc2crops/crop/sesameseeds" | "framedblocks:framed_centered_slab" | "chipped_express:stonecutting_chipped_windowed_acacia_trapdoor_from_acacia_trapdoor" | "supplementaries:compressedblocks/sign_post_c1_acacia" | "quark:building/stonecutting/slabs/gray_shingles_slab_stonecutter" | "lootbags:common_decorations/film_completion" | "gemsnjewels:ornament_tanzanite_block" | "chipped_express:stonecutting_chipped_flat_magma_block_tiles_from_magma_block" | "compressedblocks:shaped_quadruple_crated_pufferfish" | "create:compat/silentsgems/crushing/sodalite_ore" | "chipped_express:stonecutting_chipped_thin_dark_oak_planks_from_dark_oak_planks" | "chipped_express:stonecutting_chipped_tiny_layered_granite_slabs_from_granite" | "createaddition:rolling/electrum_ingot" | "mcwroofs:stone_bricks_upper_steep_roof" | "refinedstorage:fluid_grid/light_gray_fluid_grid" | "chipped_express:stonecutting_chipped_eroded_raw_iron_block_from_raw_iron_block" | "gemsnjewels:stacked_morganite_slab" | "mcwtrpdoors:bamboo_mystic_trapdoor" | "chipped_express:stonecutting_chipped_edged_stripped_oak_log_from_stripped_oak_log" | "delightful:knives/ritual/living_knife" | "compressedblocks:shapeless_c9_obsidian" | "moa_decor_cookery:paydecalabaza_1" | "compressedblocks:shaped_sextuple_crated_weeping_vines" | "chipped_express:stonecutting_chipped_edged_dark_prismarine_bricks_from_dark_prismarine" | "mcwlights:lime_paper_lamp" | "mcwfurnitures:oak_striped_chair" | "chipped_express:stonecutting_chipped_inlayed_purpur_block_from_purpur_block" | "mcwwindows:birch_plank_window" | "minecraft:sandstone" | "compressedblocks:shaped_triple_crated_glow_lichen" | "chipped_express:stonecutting_chipped_cobbled_raw_iron_block_from_raw_iron_block" | "bloomingnature:swamp_oak_boat" | "createdeco:long_blue_brick_slab_from_blue_bricks_stonecutting" | "mcwbridges:rope_warped_bridge" | "createdeco:short_blue_brick_stairs_from_tiled_blue_bricks_stonecutting" | "moa_decor_bath:toallaamarillacolg_1" | "railways:sequenced_assembly/track_biomesoplenty_jacaranda" | "compressedblocks:shapeless_sextuple_crated_azure_bluet" | "luphieclutteredmod:luphie_decorative_mushroom_recipe" | "pamhc2foodextended:onigiriitem" | "minecraft:yellow_sheet_from_yellow_dye" | "meadow:flower_pot_big" | "luphieclutteredmod:red_sand_seal_plush_recipe" | "chipped_express:stonecutting_chipped_edged_basalt_bricks_from_basalt" | "create_central_kitchen:crafting/pumpkin_pie_from_slices" | "luphieclutteredmod:luphie_sea_gem_lantern_recipe" | "railways:sequenced_assembly/track_natures_spirit_wisteria_wide" | "compressedblocks:shapeless_giga_crated_yellow_dye" | "compressedblocks:shapeless_c6_coal_block" | "chipped_express:stonecutting_chipped_trodden_bricks_from_bricks" | "moa_decor_science:sueroazul_1" | "paraglider:horned_statue/buy_stamina_vessel" | "railways:crafting/remote_lens" | "chipped_express:stonecutting_chipped_vertical_dark_oak_planks_from_dark_oak_planks" | "pamhc2foodextended:berryvinaigrettesaladitem" | "mcwfurnituresbop:dead_double_drawer_counter" | "chipped_express:stonecutting_chipped_duh_coal_block_from_coal_block" | "gemsnjewels:create/create_crushing_zircon_nether_ore" | "mcwtrpdoors:cherry_glass_trapdoor" | "compressedblocks:shaped_mega_crated_allium" | "chipped_express:stonecutting_chipped_inlayed_diorite_from_diorite" | "chipped_express:stonecutting_chipped_tiled_sandstone_from_sandstone" | "lootbags:clothing_collection/knight_armor_completion" | "farmersdelight:cyan_hanging_canvas_sign" | "candlelight:veggie_plate" | "mcwtrpdoors:cherry_barred_trapdoor" | "mcwroofs:cobblestone_upper_lower_roof" | "moa_decor_lights:lm_nmorado_1" | "luphieclutteredmod:luphie_small_empty_jars_recipe" | "quark:building/crafting/furnaces/deepslate_furnace" | "compressedblocks:shaped_crated_golden_carrot" | "botania:fabulous_pool" | "compressedblocks:shapeless_c5_cherry_planks" | "chipped_express:stonecutting_chipped_checkered_borderless_bricks_tiles_from_bricks" | "quark:building/stonecutting/vertslabs/polished_dripstone_vertical_slab_stonecutter" | "bakery:stone_bricks_stove" | "refinedstorage:coloring_recipes/red_grid" | "minecraft:lime_candle" | "mcwtrpdoors:warped_tropical_trapdoor" | "botanypots:farmersdelight/crop/wild_tomatoes" | "chipped_express:stonecutting_chipped_stacked_coal_block_bricks_from_coal_block" | "conditional:regions_unexplored/wood_cutter/larch_planks_woodcutter" | "botanypots:farming_crossing/crop/pamhc2treesapricot_sapling" | "chipped_express:stonecutting_chipped_leafy_jungle_trapdoor_from_jungle_trapdoor" | "chipped_express:stonecutting_chipped_layered_stripped_warped_stem_from_stripped_warped_stem" | "biomesoplenty:stripped_jacaranda_wood" | "corail_woodcutter:woodcutting/biomesoplenty/fir_slab_from_fir_logs" | "chipped_express:stonecutting_chipped_oak_bordered_glass_pane_from_glass_pane" | "cosmeticarmoursmod:magenta_sock_plaid_2_skirt" | "chipped_express:stonecutting_chipped_netherrack_bricks_from_netherrack" | "chipped_express:stonecutting_chipped_planked_acacia_log_from_acacia_log" | "compressedblocks:shapeless_c9_cut_red_sandstone" | "moa_decor_lights:farol_d_1" | "corail_woodcutter:woodcutting/crimson_fence_from_crimson_stems" | "supplementaries:bloomingnature/sign_post_palm" | "botania:petal_apothecary/medumone" | "meadow:wood_cutter/crimson/crimson_hyphae_pp_woodcutter" | "chipped_express:stonecutting_chipped_cracked_disordered_lodestone_bricks_from_lodestone" | "createaddition:crafting/modular_accumulator_electrum" | "compressedblocks:shaped_sextuple_crated_rose_bush" | "mcwlights:red_ceiling_light" | "chipped_express:stonecutting_chipped_tiny_layered_nether_bricks_bricks_from_nether_bricks" | "minecraft:exposed_cut_copper_slab_from_exposed_cut_copper_stonecutting" | "moa_decor_garden_:maceta_tpastoalto_1" | "chipped_express:stonecutting_chipped_tiny_brick_bordered_quartz_block_from_quartz_block" | "create:compat/projectvibrantjourneys/cutting/stripped_redwood_log" | "chipped_express:stonecutting_chipped_spruce_crate_from_barrel" | "chipped_express:stonecutting_chipped_windmill_yellow_carpet_from_yellow_carpet" | "mcwdoors:birch_stable_head_door" | "railways:crafting/palettes/dyeing_8x/yellow_iron_wrapped_locometal_boiler" | "corail_woodcutter:woodcutting/biomesoplenty/hellbark_boat_from_hellbark_logs" | "refinedstorage:coloring_recipes/magenta_network_receiver" | "botania:dynamic/cosmetic_remove" | "createdeco:cracked_blue_bricks_from_blue_bricks_blasting" | "railways:crafting/palettes/dyeing_1x/light_blue_locometal_boiler" | "chipped_express:stonecutting_chipped_inscribed_lime_terracotta_from_lime_terracotta" | "compressedblocks:shapeless_triple_crated_chicken" | "chipped_express:stonecutting_chipped_simple_dripstone_block_pillar_from_dripstone_block" | "createdeco:tiled_dusk_brick_slab_from_short_dusk_brick_slab_stonecutting" | "minecraft:cyan_glazed_terracotta" | "framedblocks:framed_ladder" | "chipped_express:stonecutting_chipped_vertical_cut_amethyst_block_from_amethyst_block" | "botanypots:minecraft/crop/cornflower" | "minecraft:stone_sword" | "delightful:knives/mechanical_crafting/gilded_quartz_knife" | "chipped_express:stonecutting_chipped_polished_clay_from_clay" | "quark:building/crafting/glass/purple_framed_glass" | "chipped_express:stonecutting_chipped_minimized_blue_glazed_terracotta_from_blue_glazed_terracotta" | "chipped_express:stonecutting_chipped_smoothed_double_inlayed_ice_from_ice" | "snowyspirit:luphieclutteredmod/sled_luphie_glow" | "pamhc2foodextended:orangejuiceitem" | "chipped_express:stonecutting_chipped_cracked_disordered_obsidian_bricks_from_obsidian" | "chipped_express:stonecutting_chipped_overjoyed_jack_o_lantern_from_jack_o_lantern" | "botanypots:minecraft/crop/crimson_roots" | "chipped_express:stonecutting_chipped_crafted_white_wool_from_white_wool" | "macawsroofsbop:umbran_planks_lower_roof" | "pamhc2foodextended:bakedbeansitem" | "candlelight:basalt_kitchen_sink" | "mcwfences:nether_brick_pillar_wall" | "moa_decor_lights:vt_ncarmesi_1" | "create:cutting/stripped_jungle_log" | "chipped_express:stonecutting_chipped_tiny_layered_raw_copper_block_bricks_from_raw_copper_block" | "candlelight:tomato" | "mcwbridges:rope_jungle_bridge" | "chipped_express:stonecutting_chipped_leaning_mud_from_mud" | "chipped_express:stonecutting_chipped_pressed_cherry_door_from_cherry_door" | "chipped_express:stonecutting_chipped_stop_red_concrete_from_red_concrete" | "bloomingnature:palm_trapdoor" | "pamhc2trees:paperbark_sapling" | "chipped_express:stonecutting_chipped_plated_gold_block_from_gold_block" | "nethervinery:crested_crimson_planks" | "chipped_express:stonecutting_chipped_fine_purpur_block_pillar_from_purpur_block" | "create:compat/bop/milling/pink_hibiscus" | "storagedrawers:oak_half_drawers_1" | "chipped_express:stonecutting_chipped_tiled_blue_stained_glass_from_blue_stained_glass" | "createdeco:cracked_pearl_bricks_from_pearl_bricks_smelting" | "createaddition:charging/exposed_cut_copper_slab" | "chipped_express:stonecutting_chipped_stacked_dirt_bricks_from_dirt" | "minecraft:granite_stairs_from_granite_stonecutting" | "storagedrawers:oak_half_drawers_2" | "storagedrawers:oak_half_drawers_4" | "candlelight:lamp" | "compressedblocks:shaped_triple_crated_rabbit_hide" | "mcwfurnitures:stripped_cherry_table" | "compressedblocks:shaped_quadruple_crated_oak_sapling" | "chipped_express:stonecutting_chipped_anguished_jack_o_lantern_from_jack_o_lantern" | "mcwwindows:stripped_cherry_log_window2" | "lootbags:common_decorations/wall_decorations_completion" | "pamhc2foodextended:greenteaitem" | "compressedblocks:shapeless_c3_waxed_exposed_cut_copper" | "chipped_express:stonecutting_chipped_small_orange_stained_glass_pane_from_orange_stained_glass_pane" | "minecraft:ladder" | "chipped_express:stonecutting_chipped_basket_woven_bamboo_planks_from_bamboo_planks" | "corail_woodcutter:woodcutting/biomesoplenty/magic_pressure_plate_from_magic_planks" | "compressedblocks:shaped_c4_cobblestone" | "moa_decor_bath:bataroja_1" | "nethersdelight:warped_moldy_meat" | "botanypots:botanypots/crafting/pink_terracotta_hopper_botany_pot" | "pamhc2foodextended:kiwijellyitem" | "compressedblocks:shaped_mega_crated_cornflower" | "chipped_express:stonecutting_chipped_smiling_jack_o_lantern_from_jack_o_lantern" | "luphieclutteredmod:luphie_dynasty_door_recipe" | "moa_decor_art:bateriaazulclara_1" | "corail_woodcutter:woodcutting/cherry_door_from_cherry_logs" | "conditional:create/mixing/villagers_fright_mixing" | "chipped_express:stonecutting_chipped_cracked_flat_basalt_tiles_from_basalt" | "minecraft:diamond_from_blasting_deepslate_diamond_ore" | "pamhc2foodextended:figsmoothieitem" | "compressedblocks:shaped_c7_tuff" | "pamhc2foodextended:generaltsochickenitem" | "corail_woodcutter:woodcutting/biomesoplenty/hellbark_fence_gate_from_hellbark_logs" | "luphieclutteredmod:luphie_china_cabinet_recipe" | "compressedblocks:shapeless_crated_weeping_vines" | "corail_woodcutter:woodcutting/biomesoplenty/willow_slab_from_willow_logs" | "bloomingnature:dye_yellow_from_golden_rod" | "minecraft:stripped_cherry_wood" | "compressedblocks:shaped_crated_beef" | "minecraft:quartz_slab_from_stonecutting" | "quark:building/crafting/glass/blue_framed_glass" | "candlelight:cherry_shelf" | "chipped_express:stonecutting_chipped_crying_red_nether_bricks_from_red_nether_bricks" | "cosmeticarmoursmod:white_bunny_ears_rec" | "mcwdoors:crimson_classic_door" | "minecraft:smoking_cookedgroundrabbititem" | "mcwwindows:magenta_mosaic_glass_pane" | "railways:sequenced_assembly/track_byg_blue_enchanted_narrow" | "moa_decor_garden_:comedero_trigo_1" | "compressedblocks:shapeless_mega_crated_red_tulip" | "chipped_express:stonecutting_chipped_lime_concrete_panel_from_lime_concrete" | "compressedblocks:shapeless_c6_granite" | "beachparty:tiki_bar_mixing/chocolate_milkshake" | "compressedblocks:shaped_septuple_crated_seagrass" | "supplementaries:checker_slab" | "pamhc2foodextended:mashedpotatoeschickenbiscuititem" | "mcwfurnitures:stripped_birch_drawer" | "meadow:banner_from_smithing_table" | "chipped_express:stonecutting_chipped_cracked_disordered_red_sandstone_bricks_from_red_sandstone" | "createaddition:crafting/large_connector_gold" | "compressedblocks:shaped_mega_crated_name_tag" | "compressedblocks:shaped_c0_dark_oak_log" | "chipped_express:stonecutting_chipped_flat_bricks_tiles_from_bricks" | "chipped_express:stonecutting_chipped_fine_red_nether_bricks_pillar_from_red_nether_bricks" | "framedblocks:framed_flat_double_slope_slab_corner_from_inverse" | "compressedblocks:shaped_sextuple_crated_birch_sapling" | "chipped_express:stonecutting_chipped_tripped_yellow_carpet_from_yellow_carpet" | "quark:building/stonecutting/vertslabs/red_shingles_vertical_slab_stonecutter2" | "railways:sequenced_assembly/track_twilightforest_transwood" | "compressedblocks:shaped_triple_crated_experience_bottle" | "chipped_express:stonecutting_chipped_rough_mossy_cobblestone_from_mossy_cobblestone" | "framedblocks:framing_saw/framed_compound_slope_slab" | "create:layered_ochrum_from_stone_types_ochrum_stonecutting" | "luphieclutteredmod:luphie_yellow_armchair_recipe" | "mcwroofs:red_concrete_lower_roof" | "alexsmobs:banner_pattern_new_mexico" | "quark:building/crafting/vertslabs/myalite_vertical_slab" | "compressedblocks:shapeless_c0_netherite_block" | "handcrafted:spruce_counter" | "chipped_express:stonecutting_chipped_ancient_oak_bookshelf_from_bookshelf" | "chipped_express:stonecutting_chipped_scaled_cyan_carpet_from_cyan_carpet" | "mcwfurnitures:stripped_cherry_bookshelf_drawer" | "compressedblocks:shaped_c7_stripped_spruce_log" | "chipped_express:stonecutting_chipped_harsh_quilted_lime_wool_from_lime_wool" | "comforts:hammock_to_black" | "corail_woodcutter:woodcutting/biomesoplenty/fir_planks_from_fir_logs" | "chipped_express:stonecutting_chipped_exposed_verdant_froglight_from_verdant_froglight" | "moa_decor_art:bateriaverde_1" | "chipped_express:stonecutting_chipped_bamboo_planks_fine_mosaic_from_bamboo_planks" | "chipped_express:stonecutting_chipped_bundled_pink_carpet_from_pink_carpet" | "quark:building/stonecutting/slabs/cyan_shingles_slab_stonecutter2" | "nethervinery:crested_warped_planks" | "corail_woodcutter:woodcutting/birch_trapdoor_from_birch_planks" | "compressedblocks:shapeless_octuple_crated_milk_bucket" | "create:small_crimsite_brick_wall" | "create:deploying/waxed_weathered_cut_copper_stairs_from_adding_wax" | "refinedstorage:coloring_recipes/magenta_controller" | "chipped_express:stonecutting_chipped_sad_andesite_from_andesite" | "compressedblocks:shaped_triple_crated_orange_carpet" | "create:small_calcite_brick_slab_from_stone_types_calcite_stonecutting" | "moa_decor_lights:foco_rn_1" | "compressedblocks:shapeless_crated_lead" | "meadow:limestone_bricks_stairs" | "sophisticatedstorage:cherry_chest" | "botanypots:minecraft/crop/brain_coral_fan" | "create:cutting/compat/quark/stripped_azalea_wood" | "compressedblocks:shaped_c5_netherite_block" | "chipped_express:stonecutting_chipped_cracked_granite_bricks_from_granite" | "chipped_express:stonecutting_chipped_bordered_snow_block_from_snow_block" | "chipped_express:stonecutting_chipped_creeper_dripstone_block_carving_from_dripstone_block" | "chipped_express:stonecutting_chipped_blank_dirt_carving_from_dirt" | "compressedblocks:shaped_triple_crated_name_tag" | "createdeco:iron_coin" | "compressedblocks:shaped_c6_spruce_planks" | "chipped_express:stonecutting_chipped_prismal_ancient_debris_remnants_from_ancient_debris" | "botania:stonecutting/metamorphic_forest_stone_to_metamorphic_forest_stone_slab" | "botania:gray_petal_block" | "compressedblocks:shaped_c1_oak_planks" | "gemsnjewels:light_stone_dusk_emerald" | "chipped_express:stonecutting_chipped_cobweb_birch_trapdoor_from_birch_trapdoor" | "chipped_express:stonecutting_chipped_simple_gilded_blackstone_pillar_from_gilded_blackstone" | "moa_decor_holidays:banderines_azul_1" | "macawsroofsbop:hellbark_upper_steep_roof" | "chipped_express:stonecutting_chipped_flat_calcite_tiles_from_calcite" | "corail_woodcutter:woodcutting/biomesoplenty/palm_trapdoor_from_palm_planks" | "chipped_express:stonecutting_chipped_brick_bordered_raw_gold_block_from_raw_gold_block" | "chipped_express:stonecutting_chipped_chipped_waxed_weathered_copper_from_waxed_weathered_copper" | "chipped_express:stonecutting_chipped_offset_raw_iron_block_bricks_from_raw_iron_block" | "pamhc2crops:bakedjicamaitem_campfire" | "compressedblocks:shapeless_triple_crated_bread" | "cosmeticarmoursmod:white_plaid_2_light_blue" | "create:cut_veridium_bricks_from_stone_types_veridium_stonecutting" | "chipped_express:stonecutting_chipped_cobbled_lapis_block_from_lapis_block" | "quark:building/crafting/flowering_azalea_hedge" | "delightful:cutting/nightshade_berry_pie" | "pamhc2foodextended:hashitem" | "handcrafted:diorite_pillar_trim" | "compressedblocks:shapeless_triple_crated_gunpowder" | "chipped_express:stonecutting_chipped_plated_emerald_block_from_emerald_block" | "chipped_express:stonecutting_chipped_franken_red_mushroom_from_red_mushroom" | "bloomingnature:dye_pink_from_hyssop" | "vinery:winemaker_apron" | "pamhc2crops:celeryseeditem" | "compressedblocks:shaped_c5_warped_nylium" | "create:compat/environmental/milling/orange_hibiscus" | "quark:building/stonecutting/slabs/black_shingles_slab_stonecutter2" | "quark:building/stonecutter/vertslabs/exposed_cut_copper_vertical_slab_from_exposed_copper" | "railways:sequenced_assembly/track_create_dd_rubber" | "chipped_express:stonecutting_chipped_franken_crimson_fungus_from_crimson_fungus" | "create:oxidized_copper_tile_slab_from_oxidized_copper_tiles_stonecutting" | "chipped_express:stonecutting_chipped_kitty_faced_jack_o_lantern_from_jack_o_lantern" | "create:cutting/compat/tconstruct/stripped_skyroot_log" | "create:cut_limestone_brick_slab" | "quark:building/stonecutting/vertslabs/blue_shingles_vertical_slab_stonecutter" | "compressedblocks:shapeless_sextuple_crated_porkchop" | "chipped_express:stonecutting_chipped_curled_pink_terracotta_from_pink_terracotta" | "compressedblocks:shapeless_quadruple_crated_allium" | "botanypots:minecraft/crop/tube_coral_fan" | "pamhc2foodextended:baconpancakesitem" | "chipped_express:stonecutting_chipped_circular_green_terracotta_from_green_terracotta" | "botania:glimmering_dreamwood" | "chipped_express:stonecutting_chipped_runic_carved_packed_ice_from_packed_ice" | "sophisticatedbackpacks:advanced_pickup_upgrade" | "mcwwindows:lime_curtain" | "undergardendelight:frosteel_knife" | "compressedblocks:shapeless_quadruple_crated_detector_rail" | "botania:lavender_quartz_pillar" | "chipped_express:stonecutting_chipped_light_blue_terracotta_bricks_from_light_blue_terracotta" | "create:cut_crimsite_brick_wall_from_stone_types_crimsite_stonecutting" | "pamhc2foodextended:spicymustardporkitem" | "minecraft:mangrove_planks" | "compressedblocks:shapeless_quintuple_crated_brown_mushroom" | "botania:stonecutting/livingrock_to_polished_livingrock_wall" | "railways:crafting/palettes/dyeing_1x/cyan_copper_wrapped_locometal_boiler" | "herbalbrews:kettle_brewing/lavender_tea" | "luphieclutteredmod:green_planks_alt_wood_recipe" | "chipped_express:stonecutting_chipped_massive_blackstone_bricks_from_blackstone" | "compressedblocks:shaped_sextuple_crated_magenta_carpet" | "compressedblocks:shapeless_sextuple_crated_yellow_dye" | "chipped_express:stonecutting_chipped_tiled_cyan_stained_glass_from_cyan_stained_glass" | "refinedstorage:256k_fluid_storage_disk" | "chipped_express:stonecutting_chipped_starry_brown_glazed_terracotta_from_brown_glazed_terracotta" | "meadow:wood_cutter/dark_oak/dark_oak_trapdoor_woodcutter" | "mcwbridges:andesite_bridge_pier" | "createdeco:mossy_dusk_brick_stairs_from_mossy_dusk_bricks_stonecutting" | "create:cutting/warped_hyphae" | "quark:world/crafting/permafrost_bricks" | "supplementaries:inspirations/blackboard_clear" | "compressedblocks:shapeless_crated_cooked_beef" | "minecraft:magenta_dye_from_blue_red_pink" | "luphieclutteredmod:green_logrecipe" | "quark:building/stonecutting/vertslabs/dark_prismarine_vertical_slab_stonecutter" | "minecraft:lime_carpet" | "chipped_express:stonecutting_chipped_polished_smooth_stone_from_smooth_stone" | "chipped_express:stonecutting_chipped_cobweb_dark_oak_trapdoor_from_dark_oak_trapdoor" | "chipped_express:stonecutting_chipped_offset_snow_block_bricks_from_snow_block" | "chipped_express:stonecutting_chipped_polished_dripstone_block_from_dripstone_block" | "gemsnjewels:light_stone_iolite" | "vinery:jungle_wine_rack_mid" | "quark:building/crafting/stairs/soul_sandstone_stairs" | "quark:world/crafting/woodsets/azalea/chest_boat" | "luphieclutteredmod:luphie_green_stairs_recipe" | "moa_decor_cookery:cdistorsionado_1" | "chipped_express:stonecutting_chipped_prismal_diorite_remnants_from_diorite" | "chipped_express:stonecutting_chipped_simple_netherrack_pillar_from_netherrack" | "botanypots:botanypots/crafting/terracotta_hopper_botany_pot" | "railways:crafting/palettes/dyeing_1x/cyan_slashed_locometal" | "mcwroofs:nether_bricks_top_roof" | "alexsmobs:mimicream_repair_recipe" | "compressedblocks:shaped_c1_mud" | "minecraft:waxed_cut_copper_from_honeycomb" | "refinedstorage:coloring_recipes/yellow_network_receiver" | "mcwroofs:cyan_concrete_top_roof" | "moa_decor_lights:vt_nmanglar_1" | "biomesoplenty:jacaranda_door" | "bloomingnature:dye_yellow_from_genisteae" | "railways:sequenced_assembly/track_byg_cypress_narrow" | "quark:building/stonecutting/stairs/red_shingles_stairs_stonecutter2" | "mcwroofs:gutter_base_green" | "chipped_express:stonecutting_chipped_weathered_diorite_from_diorite" | "chipped_express:stonecutting_chipped_versailles_cherry_planks_from_cherry_planks" | "chipped_express:stonecutting_chipped_woved_lime_wool_from_lime_wool" | "biomesoplenty:light_blue_dye_from_icy_iris" | "compressedblocks:shaped_double_crated_mutton" | "refinedstorage:pattern_grid/pink_pattern_grid" | "compressedblocks:shapeless_octuple_crated_oxeye_daisy" | "chipped_express:stonecutting_chipped_massive_red_sandstone_bricks_from_red_sandstone" | "chimes:glass_bells_custom" | "minecraft:muddy_mangrove_roots" | "compressedblocks:shapeless_triple_crated_lime_dye" | "pamhc2foodextended:groundnutmegitem" | "quark:building/crafting/vertslabs/oak_vertical_slab" | "chipped_express:stonecutting_chipped_carved_packed_mud_from_packed_mud" | "corail_woodcutter:woodcutting/mangrove_boat_from_mangrove_logs" | "cosmeticarmoursmod:green_knight_armour_boots_rec" | "create:small_asurine_brick_slab_from_stone_types_asurine_stonecutting" | "quark:building/crafting/vertslabs/shingles_vertical_slab" | "mcwlights:white_lamp" | "chipped_express:stonecutting_chipped_rounded_blue_ice_bricks_from_blue_ice" | "luphieclutteredmod:luphie_yellow_sink_counter_recipe" | "compressedblocks:shaped_sextuple_crated_minecart" | "chipped_express:stonecutting_chipped_starry_green_terracotta_from_green_terracotta" | "create:weathered_copper_tile_stairs_from_weathered_copper_tiles_stonecutting" | "botania:brew/overload" | "compressedblocks:shapeless_c0_dirt" | "chipped_express:stonecutting_chipped_inlayed_tuff_from_tuff" | "chipped_express:stonecutting_chipped_smooth_redstone_block_column_from_redstone_block" | "pamhc2foodextended:datepieitem" | "minecraft:light_gray_banner" | "cosmeticarmoursmod:straw_hat_rec" | "pamhc2foodextended:orangepieitem" | "luphieclutteredmod:luphie_plated_croissant_recipe" | "farmersdelight:cutting/mangrove_sign" | "compressedblocks:shapeless_septuple_crated_dandelion" | "mcwfurnitures:dark_oak_lower_triple_drawer" | "refinedstorage:coloring_recipes/magenta_crafting_monitor" | "botania:elven_trade/elf_quartz" | "create:cutting/compat/byg/ether_wood" | "railways:mechanical_crafting/purple_copper_wrapped_locometal_boiler" | "create:smelting/glass_from_tiled_glass" | "mcwlights:orange_ceiling_light" | "chipped_express:stonecutting_chipped_rounded_deepslate_bricks_from_deepslate" | "chipped_express:stonecutting_chipped_hewn_acacia_planks_from_acacia_planks" | "compressedblocks:shaped_c3_sculk" | "chipped_express:stonecutting_chipped_reinforced_stripped_birch_log_from_stripped_birch_log" | "vinery:wine_fermentation/bottle_mojang_noir" | "botanypots:botanypots/crafting/purple_concrete_hopper_botany_pot" | "create:pressing/brass_ingot" | "candlelight:cherry_chair" | "luphieclutteredmod:luphie_pink_shroom_terrarium_recipe" | "delightful:food/cooking/rock_candy" | "chipped_express:stonecutting_chipped_rough_bricks_from_bricks" | "minecraft:trapped_chest" | "mcwfurnitures:stripped_cherry_double_wardrobe" | "quark:world/crafting/stairs/azalea_planks_stairs" | "chipped_express:stonecutting_chipped_fine_redstone_block_pillar_from_redstone_block" | "createdeco:tiled_red_brick_slab_from_long_red_bricks_stonecutting" | "mcwbridges:mangrove_log_bridge_stair_recycle" | "minecraft:polished_andesite_stairs_from_andesite_stonecutting" | "chipped_express:stonecutting_chipped_checkered_crimson_trapdoor_from_crimson_trapdoor" | "chipped_express:stonecutting_chipped_inlayed_mud_from_mud" | "chipped_express:stonecutting_chipped_tiled_mud_column_from_mud" | "quark:world/stonecutting/slabs/polished_jasper_slab_stonecutter" | "chipped_express:stonecutting_chipped_small_red_stained_glass_from_red_stained_glass" | "chipped_express:stonecutting_chipped_unamused_lodestone_from_lodestone" | "chipped_express:stonecutting_chipped_vertical_disordered_andesite_bricks_from_andesite" | "chipped_express:stonecutting_chipped_tiny_layered_granite_bricks_from_granite" | "minecraft:diamond_axe" | "luphieclutteredmod:luphie_pink_fence_recipe" | "corail_woodcutter:woodcutting/biomesoplenty/hellbark_slab_from_hellbark_planks" | "pamhc2foodextended:bananajellysandwichitem" | "create:cutting/compat/byg/stripped_skyris_log" | "railways:sequenced_assembly/light_blue_conductor_cap" | "mcwbridges:acacia_rail_bridge" | "chipped_express:stonecutting_chipped_diagonal_crimson_planks_from_crimson_planks" | "compressedblocks:shaped_c2_stone_bricks" | "chipped_express:stonecutting_chipped_layered_iron_block_from_iron_block" | "minecraft:dark_oak_pressure_plate" | "minecraft:dye_blue_wool" | "chipped_express:stonecutting_chipped_edge_cut_acacia_log_from_acacia_log" | "botania:stonecutting/red_quartz_to_red_quartz_pillar" | "compressedblocks:shapeless_double_crated_milk_bucket" | "chipped_express:stonecutting_chipped_blue_mangrove_roots_from_mangrove_roots" | "farmingforblockheads:red_fertilizer" | "mcwfurnitures:stripped_cherry_coffee_table" | "compressedblocks:shapeless_octuple_crated_oak_sapling" | "botanypots:minecraft/soil/red_sand" | "botania:mossy_dreamwood_planks" | "create:compat/bop/milling/wildflower" | "chipped_express:stonecutting_chipped_unamused_mossy_cobblestone_from_mossy_cobblestone" | "quark:building/stonecutting/stonevariants/shale_pillar_stonecutter" | "botania:marimorphosis/metamorphic_fungal_stone" | "compressedblocks:shapeless_septuple_crated_pink_dye" | "create:polished_cut_dripstone_wall" | "mcwroofs:red_terracotta_upper_steep_roof" | "gemsnjewels:light_stone_kunzite" | "compressedblocks:shaped_octuple_crated_warped_fungus" | "compressedblocks:shapeless_sextuple_crated_anvil" | "handcrafted:dark_oak_dining_bench" | "quark:building/crafting/vertslabs/bamboo_vertical_slab" | "create:cutting/stripped_spruce_wood" | "mcwroofs:light_gray_steep_roof" | "chipped_express:stonecutting_chipped_pressed_warped_door_from_warped_door" | "quark:building/crafting/sturdy_stone_decompress" | "chipped_express:stonecutting_chipped_vined_jungle_trapdoor_from_jungle_trapdoor" | "compressedblocks:shapeless_c9_raw_iron_block" | "quark:building/stonecutting/vertslabs/cobblestone_bricks_vertical_slab_stonecutter" | "biomesoplenty:cut_black_sandstone_from_black_sandstone_stonecutting" | "minecraft:red_banner" | "conditional:regions_unexplored/wood_cutter/joshua_stairs_woodcutter" | "createdeco:short_dean_bricks_from_tiled_dean_bricks_stonecutting" | "create:cutting/compat/biomesoplenty/stripped_umbran_wood" | "vinery:cherry_beam" | "compressedblocks:shaped_triple_crated_sunflower" | "compressedblocks:shapeless_c5_mud" | "compressedblocks:shapeless_mega_crated_egg" | "moa_decor_cookery:sushi_1" | "handcrafted:pillager_trophy" | "compressedblocks:shapeless_c9_jungle_log" | "storagedrawers:controller_slave" | "chipped_express:stonecutting_chipped_leafy_mangrove_roots_from_mangrove_roots" | "mcwfences:oak_stockade_fence" | "cosmeticarmoursmod:light_grey_sock_skirt_2_plaid" | "compressedblocks:shaped_c1_raw_copper_block" | "quark:building/crafting/vertslabs/polished_tuff_vertical_slab" | "create_confectionery:gingerbread_brick_stairs_recipe_2" | "chipped_express:stonecutting_chipped_runic_carved_dripstone_block_from_dripstone_block" | "luphieclutteredmod:pink_wood_recipe" | "moa_decor_science:biombomgris_1" | "pamhc2foodextended:persimmonjuiceitem" | "chipped_express:stonecutting_chipped_chiseled_white_terracotta_from_white_terracotta" | "compressedblocks:shapeless_giga_crated_light_gray_dye" | "chipped_express:stonecutting_chipped_magma_block_pillar_from_magma_block" | "mcwfurnitures:acacia_double_wardrobe" | "compressedblocks:shapeless_giga_crated_soul_lantern" | "botania:manasteel_chestplate" | "quark:world/stonecutting/stairs/polished_shale_stairs_stonecutter" | "botanypots:botanypots/crafting/yellow_terracotta_hopper_botany_pot" | "chipped_express:stonecutting_chipped_chipped_stripped_mangrove_log_from_stripped_mangrove_log" | "corail_woodcutter:woodcutting/dark_oak_fence_from_dark_oak_logs" | "chipped_express:stonecutting_chipped_cross_haired_light_blue_carpet_from_light_blue_carpet" | "conditional:bloomingnature/wood_cutter/chestnut_stairs_woodcutter" | "chipped_express:stonecutting_chipped_knitted_light_blue_wool_from_light_blue_wool" | "chipped_express:stonecutting_chipped_checkered_obsidian_tiles_from_obsidian" | "delightful:knives/blasting/invar_thermal" | "candlelight:lettuce" | "chipped_express:stonecutting_chipped_tiled_cherry_door_from_cherry_door" | "compressedblocks:shaped_c9_chiseled_red_sandstone" | "compressedblocks:shapeless_c3_waxed_exposed_copper" | "chipped_express:stonecutting_chipped_cracked_disordered_red_nether_bricks_bricks_from_red_nether_bricks" | "compressedblocks:shapeless_octuple_crated_cooked_rabbit" | "chipped_express:stonecutting_chipped_sanded_obsidian_from_obsidian" | "moa_decor_science:pergamino_3" | "compressedblocks:shaped_quintuple_crated_oxeye_daisy" | "create:compat/atmospheric/milling/yucca_flower" | "moa_decor_science:pergamino_1" | "moa_decor_science:pergamino_2" | "createdeco:short_verdant_brick_stairs" | "supplementaries:compressedblocks/sign_post_c1_mangrove" | "luphieclutteredmod:yellow_flower_shelf_candle_recipe" | "create:cutting/compat/twilightforest/stripped_dark_log" | "chipped_express:stonecutting_chipped_circular_white_stained_glass_pane_from_white_stained_glass_pane" | "alexsmobs:shark_tooth_arrow" | "chipped_express:stonecutting_chipped_clear_leaded_glass_from_glass" | "supplementaries:stone_tile_slab" | "chipped_express:stonecutting_chipped_ornate_bricks_pillar_from_bricks" | "compressedblocks:shaped_quadruple_crated_chicken" | "alexsmobs:shield_of_the_deep" | "compressedblocks:shaped_quadruple_crated_lime_carpet" | "luphieclutteredmod:luphie_darkwood_round_table_recipe" | "botanypots:botanypots/crafting/black_glazed_terracotta_hopper_botany_pot" | "chipped_express:stonecutting_chipped_leaning_mud_bricks_from_mud_bricks" | "compressedblocks:shapeless_mega_crated_anvil" | "create:cutting/compat/twilightforest/mining_wood" | "botanypots:quark/crop/chorus_weeds" | "botania:spark_upgrade_dispersive" | "cratedelight:minecraft/crafting/sugar_bag" | "create:cutting/compat/byg/palo_verde_log" | "mcwroofs:light_blue_terracotta_upper_steep_roof" | "pamhc2foodcore:fruitsaladitem" | "biomesoplenty:jacaranda_pressure_plate" | "delightful:knives/smelting/lead_immersiveengineering" | "minecraft:sandstone_wall" | "chipped_express:stonecutting_chipped_smooth_moss_block_from_moss_block" | "moa_decor_art:tijeras_1" | "moa_decor_science:pizarra_1" | "quark:building/crafting/chests/spruce_trapped_chest" | "chipped_express:stonecutting_chipped_blocky_blue_wool_from_blue_wool" | "supplementaries:jar" | "compressedblocks:shaped_mega_crated_rail" | "aquaculture:acacia_fish_mount" | "compressedblocks:shaped_double_crated_cod" | "botania:red_string_dispenser" | "compressedblocks:shaped_c5_dark_oak_planks" | "farmersdelight:cutting/mangrove_log" | "luphieclutteredmod:luphie_choco_mint_wallpaper_b_recipe" | "beautify:lamp_bamboo" | "railways:crafting/palettes/dyeing_1x/orange_locometal_pillar" | "pamhc2foodextended:biscuitsandgravyitem" | "gemsnjewels:ornament_iolite_block" | "mcwroofs:green_terracotta_lower_roof" | "moa_decor_garden_:mproble_1" | "chipped_express:stonecutting_chipped_barky_light_gray_carpet_from_light_gray_carpet" | "createaddition:mixing/bioethanol" | "toms_storage:trim_clean" | "beautify:iron_blinds" | "chipped_express:stonecutting_chipped_carved_sandstone_from_sandstone" | "botania:mana_infusion/cocoa_beans_to_wheat_seeds" | "chipped_express:stonecutting_chipped_historical_oak_bookshelf_from_bookshelf" | "meadow:wood_cutter/crimson/crimson_hyphae_sign_woodcutter" | "railways:crafting/palettes/wrapping/lime_iron_wrapped_locometal" | "chipped_express:stonecutting_chipped_l_sign_stripped_acacia_log_from_stripped_acacia_log" | "moa_decor_cookery:aabedulsc_1" | "railways:stonecutting/palettes/cycling/magenta_flat_slashed_locometal" | "chipped_express:stonecutting_chipped_unamused_nether_bricks_from_nether_bricks" | "moa_decor_science:matrazbgris_1" | "chipped_express:stonecutting_chipped_k_sign_stripped_spruce_log_from_stripped_spruce_log" | "create_confectionery:gingerbread_stairs_recipe_2" | "chipped_express:stonecutting_chipped_harsh_quilted_purple_carpet_from_purple_carpet" | "chipped_express:stonecutting_chipped_glad_amethyst_block_from_amethyst_block" | "minecraft:brick_wall" | "compressedblocks:shapeless_double_crated_sugar_cane" | "lootbags:common_decorations/lab_completion" | "chipped_express:stonecutting_chipped_trodden_blue_ice_from_blue_ice" | "quark:building/stonecutting/slabs/polished_tuff_slab_stonecutter" | "mcwroofs:light_blue_concrete_attic_roof" | "compressedblocks:shaped_octuple_crated_pink_dye" | "chipped_express:stonecutting_chipped_bordered_ancient_debris_from_ancient_debris" | "compressedblocks:shapeless_c5_redstone_ore" | "chipped_express:stonecutting_chipped_stacked_raw_copper_block_bricks_from_raw_copper_block" | "create:compat/botania/milling/yellow_petal" | "create:compat/botania/milling/black_petal" | "chipped_express:stonecutting_chipped_trodden_deepslate_from_deepslate" | "chipped_express:stonecutting_chipped_vertical_disordered_mud_bricks_from_mud" | "quark:building/crafting/vertslabs/yellow_shingles_vertical_slab_revert" | "compressedblocks:shaped_giga_crated_dragon_breath" | "chipped_express:stonecutting_chipped_cornered_yellow_carpet_from_yellow_carpet" | "railways:crafting/palettes/dyeing_8x/light_blue_brass_wrapped_locometal" | "fairylights:fairy_light" | "chipped_express:stonecutting_chipped_cross_haired_light_blue_wool_from_light_blue_wool" | "create:compat/byg/milling/green_tulip" | "compressedblocks:shapeless_triple_crated_soul_campfire" | "compressedblocks:shapeless_c8_warped_nylium" | "botania:stonecutting/metamorphic_forest_stone_to_metamorphic_forest_bricks_stairs" | "createdeco:industrial_iron_catwalk_railing_forge" | "luphieclutteredmod:luphie_darkwood_geometric_chair_recipe" | "mcwtrpdoors:metal_warning_trapdoor" | "chipped_express:stonecutting_chipped_iron_barred_dark_oak_trapdoor_from_dark_oak_trapdoor" | "create:polished_cut_asurine_slab_from_stone_types_asurine_stonecutting" | "luphieclutteredmod:luphie_watermelon_armchair_recipe" | "pamhc2foodextended:currypowderitem" | "compressedblocks:shaped_crated_glow_ink_sac" | "pamhc2crops:pineappleseeditem" | "quark:building/crafting/chests/jungle_chest" | "chipped_express:stonecutting_chipped_edged_stripped_dark_oak_log_from_stripped_dark_oak_log" | "chipped_express:stonecutting_chipped_slotted_jungle_trapdoor_from_jungle_trapdoor" | "mcwroofs:yellow_concrete_upper_steep_roof" | "minecraft:diamond_helmet" | "pamhc2foodextended:tomatosoupitem" | "mcwroofs:dark_oak_planks_steep_roof" | "createdeco:blue_copper_lamp" | "chipped_express:stonecutting_chipped_woved_orange_carpet_from_orange_carpet" | "chipped_express:stonecutting_chipped_stacked_gilded_blackstone_bricks_from_gilded_blackstone" | "chipped_express:stonecutting_chipped_vertical_cut_gilded_blackstone_from_gilded_blackstone" | "candlelight:red_nether_bricks_stove" | "chipped_express:stonecutting_chipped_blackstone_pillar_top_from_blackstone" | "moa_decor_bath:c_tnegras_1" | "chipped_express:stonecutting_chipped_white_flower_birch_leaves_from_birch_leaves" | "corail_woodcutter:woodcutting/crimson_button_from_crimson_planks" | "chipped_express:stonecutting_chipped_arched_lime_stained_glass_pillar_from_lime_stained_glass" | "compressedblocks:shaped_quintuple_crated_rabbit_foot" | "minecraft:compass" | "chipped_express:stonecutting_chipped_eroded_smooth_stone_from_smooth_stone" | "create:cutting/compat/byg/stripped_willow_log" | "moa_decor_garden_:florero_torquidiaazul_1" | "corail_woodcutter:woodcutting/acacia_door_from_acacia_logs" | "mcwfurnitures:warped_modern_chair" | "create:cut_deepslate_brick_stairs_from_stone_types_deepslate_stonecutting" | "luphieclutteredmod:luphie_mushroom_door_recipe" | "quark:building/stonecutting/vertslabs/pink_shingles_vertical_slab_stonecutter2" | "chipped_express:stonecutting_chipped_arched_purple_stained_glass_pillar_from_purple_stained_glass" | "create:compat/silentsgems/crushing/fluorite_ore" | "pamhc2foodextended:leafychickensandwichitem" | "supplementaries:sign_post_spruce" | "chipped_express:stonecutting_chipped_dusty_bookshelf_from_bookshelf" | "compressedblocks:shaped_triple_crated_chain" | "mcwtrpdoors:spruce_barrel_trapdoor" | "compressedblocks:shaped_quadruple_crated_lead" | "compressedblocks:shaped_septuple_crated_lime_dye" | "railways:crafting/palettes/dyeing_1x/magenta_iron_wrapped_locometal" | "compressedblocks:shaped_sextuple_crated_red_dye" | "chipped_express:stonecutting_chipped_carved_diorite_from_diorite" | "chipped_express:stonecutting_chipped_smooth_stone_bricks_from_smooth_stone" | "supplementaries:compressedblocks/sign_post_c0_spruce" | "moa_decor_cookery:tazadecafe_1" | "sophisticatedbackpacks:smoking_upgrade_from_smelting_upgrade" | "chipped_express:stonecutting_chipped_prismarine_pillar_top_from_prismarine" | "compressedblocks:shaped_quintuple_crated_repeater" | "minecraft:green_sheet_from_green_dye" | "alexsmobs:gustmaker" | "chipped_express:stonecutting_chipped_offset_dripstone_block_bricks_from_dripstone_block" | "railways:crafting/palettes/dyeing_1x/red_locometal_boiler" | "create:cutting/compat/byg/stripped_witch_hazel_log" | "chipped_express:stonecutting_chipped_heavy_bamboo_door_from_bamboo_door" | "createdeco:tiled_blue_brick_stairs_from_long_blue_bricks_stonecutting" | "luphieclutteredmod:luphie_yellow_left_outer_corner_counter_recipe" | "biomesoplenty:cut_black_sandstone_slab_from_cut_black_sandstone_stonecutting" | "chipped_express:stonecutting_chipped_bundled_crimson_stem_from_crimson_stem" | "compressedblocks:shaped_triple_crated_torch" | "compressedblocks:shaped_quintuple_crated_magma_cream" | "chipped_express:stonecutting_chipped_sheet_iron_block_from_iron_block" | "biomesoplenty:willow_stairs" | "exoticbirds:cooked_birdmeat" | "botania:green_shiny_flower" | "sophisticatedbackpacks:everlasting_upgrade" | "supplementaries:flax_block" | "botania:red_string_comparator" | "botania:chiseled_metamorphic_taiga_bricks" | "botania:orechid_ignem/nether_gold_ore" | "chipped_express:stonecutting_chipped_square_oak_glass_pane_from_glass_pane" | "minecraft:gray_stained_glass_pane" | "chipped_express:stonecutting_chipped_ice_mini_tiles_from_ice" | "quark:world/stonecutting/stairs/polished_calcite_stairs_stonecutter2" | "mcwfurnitures:stripped_cherry_triple_drawer" | "mcwroofs:gray_concrete_attic_roof" | "herbalbrews:tea_leafs_from_crate" | "chipped_express:stonecutting_chipped_wickered_gray_carpet_from_gray_carpet" | "quark:building/stonecutting/stonevariants/granite_bricks_stairs_polished_stonecutting" | "railways:sequenced_assembly/track_twilightforest_canopy_narrow" | "handcrafted:blue_crockery_combo" | "compressedblocks:shaped_c9_cobblestone" | "chipped_express:stonecutting_chipped_cubed_light_gray_wool_from_light_gray_wool" | "chipped_express:stonecutting_chipped_tiled_coal_block_column_from_coal_block" | "chipped_express:stonecutting_chipped_barky_magenta_wool_from_magenta_wool" | "conditional:bloomingnature/wood_cutter/palm_sign_woodcutter" | "chipped_express:stonecutting_chipped_scaled_green_carpet_from_green_carpet" | "minecraft:bamboo_mosaic_slab" | "botania:floating_hyacidus" | "moa_decor_bath:toallasrojas_1" | "create:cut_deepslate_slab_from_stone_types_deepslate_stonecutting" | "compressedblocks:shaped_mega_crated_pink_tulip" | "railways:stonecutting/palettes/cycling/lime_plated_locometal" | "botania:floating_tangleberrie" | "compressedblocks:shaped_c7_andesite" | "chipped_express:stonecutting_chipped_harsh_quilted_orange_wool_from_orange_wool" | "quark:building/stonecutting/stairs/white_shingles_stairs_stonecutter2" | "beachparty:floaty" | "create:cut_dripstone_brick_stairs" | "botania:mana_infusion/glowstone_deconstruct" | "botanypots:minecraft/soil/acacia_wood" | "mcwfences:warped_wired_fence" | "minecraft:stone_axe" | "corail_woodcutter:woodcutting/oak_planks_from_oak_logs" | "chipped_express:stonecutting_chipped_stacked_iron_block_from_iron_block" | "moa_decor_holidays:p_galleta_jengibre_n_1" | "createaddition:charging/weathered_copper_shingle_stairs" | "mcwtrpdoors:oak_cottage_trapdoor" | "chipped_express:stonecutting_chipped_eroded_deepslate_from_deepslate" | "compressedblocks:shapeless_septuple_crated_comparator" | "alexsdelight:smelting/centipede_leg_cook" | "compressedblocks:shaped_giga_crated_yellow_carpet" | "corail_woodcutter:biomesoplenty/fir_woodcutter" | "compressedblocks:shaped_crated_dark_oak_sapling" | "pamhc2foodextended:blueberrysmoothieitem" | "chipped_express:stonecutting_chipped_grid_yellow_concrete_from_yellow_concrete" | "chipped_express:stonecutting_chipped_smooth_ringed_lodestone_from_lodestone" | "create:crafting/kinetics/controls" | "compressedblocks:shapeless_quadruple_crated_wheat_seeds" | "chipped_express:stonecutting_chipped_tiny_brick_bordered_raw_gold_block_from_raw_gold_block" | "comforts:sleeping_bag_to_gray" | "refinedstorage:destructor" | "corail_woodcutter:woodcutting/biomesoplenty/dead_pressure_plate_from_dead_planks" | "conditional:regions_unexplored/wood_cutter/joshua_fencegate_woodcutter" | "chipped_express:stonecutting_chipped_woved_green_wool_from_green_wool" | "conditional:decorative_blocks/wood_cutter/birch_beam_woodcutter" | "corail_woodcutter:woodcutting/biomesoplenty/jacaranda_slab_from_jacaranda_planks" | "bakery:tray" | "create:polishe